(function ($) {

Drupal.behaviors.commentNotify = {
  attach: function (context) {
    $('#edit-notify', context)
      .bind('change', function() {
        $('#edit-notify-type', context)
          [this.checked ? 'show' : 'hide']()
          .find('input[type=checkbox]:checked').attr('checked', 'checked');
      })
      .trigger('change');
  }
}

})(jQuery);
;
/**
 * @file
 * Controls the slideshow for home page feature articles
 *
 */

(function ($) {
  Drupal.behaviors.featureArticles = {
    attach: function (context, settings) {

			/**
			* Global variables
			*/
			var num_items = $('#region-feature-articles .views-row').length;
			var speed = 6000;
			var interval;
			
			if (num_items > 1) {
  			interval = setInterval(nextSlide, speed);
  			
  			/**
  			* Builds the pager
  			*/
  			var pager = '<span id="slideshow-controls">Slideshow controls</span><ul id="featured-article-pager">';
  			
  			
  			for (i = 1; i <= num_items; i++) {
  				pager += '<li' + ((i == 1) ? ' class="current"' : '') + '><a href="#views-row-' + i + '" title="View slide ' + i + '">' + i + '</a></li>';
  			}
  			
  			pager += '<li><a href="#pause" class="pause playing" data-paused="false" title="Pause slideshow">Pause</a></li></ul>';
  			
  			$('#block-views-slideshow-block').prepend(pager);
			}
			/**
			* Updates the active state on the pager
			*/
			function updatePager() {
				var itemIndex = $('#region-feature-articles .views-row:visible').index() + 1;

				$('#featured-article-pager li').removeClass('current');
				$('#featured-article-pager li a[href="#views-row-' + itemIndex + '"]').parent().addClass('current');	
			}

			/**
			* Used by 'interval'
			* Animates between featured articles
			*/
			function nextSlide() {
				var _currentSlide = $('#region-feature-articles .views-row:visible');
				var _nextSlide;
		
				// if the last row is visible, then switch back to the first row
				if ($('#region-feature-articles .views-row:last-child').is(':visible')) {
					_nextSlide = $('#region-feature-articles .views-row:first-child');
				}
				else {
					// otherwise just use the next .views-row in the stack
					_nextSlide 	= _currentSlide.next();
				}
				
				_currentSlide.fadeOut();
				_nextSlide.fadeIn(function() {
					updatePager();
				});
			}

			/**
			* Pauses/resumes the animation
			*/
			$('#featured-article-pager a.pause').click(function() {
				if ($(this).attr('data-paused') == 'false') {
					// is paused
					$('#region-feature-articles .views-row').stop(true, true);
					$(this).attr('data-paused', true);
					$(this).removeClass('playing').addClass('paused');
					$('#featured-article-pager li').removeClass('current');
					clearInterval(interval);
				}
				else {
					// is playing
					$(this).attr('data-paused', false);
					$(this).removeClass('paused').addClass('playing');
					interval = setInterval(nextSlide, speed);
					
					updatePager();
				}
			});
			
			/**
			* Switches to the selected item in the pager onclick
			*/
			$('#featured-article-pager li a').click(function(e) {
				e.preventDefault();
				
				if (!$(this).hasClass('pause')) {
					// make sure it's _not_ the pause button
					var row = $(this).attr('href').replace('#','');
					
					// pager active state
					$('#featured-article-pager li').removeClass('current');
					$(this).parent().addClass('current');
					
					clearInterval(interval);
					
					// make sure the pause button has an inactive state
					$('#featured-article-pager a.pause').attr('data-paused', false);
					$('#featured-article-pager a.pause').removeClass('paused').addClass('playing');
					
					// hide all
					$('#region-feature-articles .views-row').fadeOut();
					
					// show the selected row
					$('#region-feature-articles .' + row).fadeIn(function() {
						updatePager();
						interval = setInterval(nextSlide, speed);
					});
				}
			});
    }
  }
}(jQuery));;

(function($) {
  Drupal.behaviors.CToolsJumpMenu = {
    attach: function(context) {
      $('.ctools-jump-menu-hide')
        .once('ctools-jump-menu')
        .hide();

      $('.ctools-jump-menu-change')
        .once('ctools-jump-menu')
        .change(function() {
          var loc = $(this).val();
          var urlArray = loc.split('::');
          if (urlArray[1]) {
            location.href = urlArray[1];
          }
          else {
            location.href = loc;
          }
          return false;
        });

      $('.ctools-jump-menu-button')
        .once('ctools-jump-menu')
        .click(function() {
          // Instead of submitting the form, just perform the redirect.

          // Find our sibling value.
          var $select = $(this).parents('form').find('.ctools-jump-menu-select');
          var loc = $select.val();
          var urlArray = loc.split('::');
          if (urlArray[1]) {
            location.href = urlArray[1];
          }
          else {
            location.href = loc;
          }
          return false;
        });
    }
  }
})(jQuery);
;
/**
 * @file
 * Adds smooth scrolling to TOC anchor links.
 *
 * From: Scroll window smoothly in jQuery - Animated scroll
 *       http://blog.freelancer-id.com/2009/03/26/scroll-window-smoothly-in-jquery/
 */

(function ($) {

Drupal.tocFilterScrollToOnClick = function() {
  // Make sure links still has hash.
  if (!this.hash || this.hash == '#') {
    return true;
  }

  // Make sure the href is pointing to an anchor link on this page.
  var href = this.href.replace(/#[^#]*$/, '');
  var url = window.location.toString();
  if (href && url.indexOf(href) === -1) {
    return true;
  }

  // Scroll to the anchor
  return Drupal.tocFilterScrollTo(this.hash);
}

Drupal.tocFilterScrollTo = function(hash) {
  // Find hash target.
  var $a = $('a[name=' + hash.substring(1) + ']');

  // Make hash target is on the current page.
  if (!$a.length) {
    return true;
  }

  // Scroll to hash target
  var duration = Drupal.settings.toc_filter_smooth_scroll_duration || 'medium';
  $('html, body').animate({scrollTop: $a.offset().top}, duration);

  // Move focus to targets back to top link.
  // Target anchor not focused; breaks keyboard navigation https://drupal.org/node/2058875
  $a.parent().prev('.toc-filter-back-to-top').find('a').focus();

  return false;
}

Drupal.behaviors.tocFilterSmoothScroll = {
  attach: function (context) {
    // Only map <a href="#..."> links
    $('a[href*="#"]', context).once('toc-filter').click(Drupal.tocFilterScrollToOnClick);
  }
};

// Override CToolsJumpMenu behavior for TOC filter jumpmenus.
Drupal.behaviors.tocFilterCToolsJumpMenu = {
  attach: function(context) {
    $('.toc-filter-jump-menu .ctools-jump-menu-change:not(.toc-filter-jump-menu-processed)')
      .addClass('toc-filter-jump-menu-processed')
      .unbind('change')
      .change(function() {
        // Find our sibling value.
        var $select = $(this).parents('form').find('.ctools-jump-menu-select');
        var hash = $select.val();
        if (hash) {
          Drupal.tocFilterScrollTo(hash);
        }
        $select.find('option:first').attr('selected', true);
        return false;
      });
  }
};

})(jQuery)
;
/**
 * @file
 */

(function ($) {

  'use strict';

  Drupal.extlink = Drupal.extlink || {};

  Drupal.extlink.attach = function (context, settings) {
    if (!settings.hasOwnProperty('extlink')) {
      return;
    }

    // Strip the host name down, removing ports, subdomains, or www.
    var pattern = /^(([^\/:]+?\.)*)([^\.:]{1,})((\.[a-z0-9]{1,253})*)(:[0-9]{1,5})?$/;
    var host = window.location.host.replace(pattern, '$2$3');
    var subdomain = window.location.host.replace(host, '');

    // Determine what subdomains are considered internal.
    var subdomains;
    if (settings.extlink.extSubdomains) {
      subdomains = '([^/]*\\.)?';
    }
    else if (subdomain === 'www.' || subdomain === '') {
      subdomains = '(www\\.)?';
    }
    else {
      subdomains = subdomain.replace('.', '\\.');
    }

    // Build regular expressions that define an internal link.
    var internal_link = new RegExp('^https?://([^@]*@)?' + subdomains + host, 'i');

    // Extra internal link matching.
    var extInclude = false;
    if (settings.extlink.extInclude) {
      extInclude = new RegExp(settings.extlink.extInclude.replace(/\\/, '\\'), 'i');
    }

    // Extra external link matching.
    var extExclude = false;
    if (settings.extlink.extExclude) {
      extExclude = new RegExp(settings.extlink.extExclude.replace(/\\/, '\\'), 'i');
    }

    // Extra external link CSS selector exclusion.
    var extCssExclude = false;
    if (settings.extlink.extCssExclude) {
      extCssExclude = settings.extlink.extCssExclude;
    }

    // Extra external link CSS selector explicit.
    var extCssExplicit = false;
    if (settings.extlink.extCssExplicit) {
      extCssExplicit = settings.extlink.extCssExplicit;
    }

    // Define the jQuery method (either 'append' or 'prepend') of placing the icon, defaults to 'append'.
    var extIconPlacement = settings.extlink.extIconPlacement || 'append';

    // Find all links which are NOT internal and begin with http as opposed
    // to ftp://, javascript:, etc. other kinds of links.
    // When operating on the 'this' variable, the host has been appended to
    // all links by the browser, even local ones.
    // In jQuery 1.1 and higher, we'd use a filter method here, but it is not
    // available in jQuery 1.0 (Drupal 5 default).
    var external_links = [];
    var mailto_links = [];
    $('a:not(.' + settings.extlink.extClass + ', .' + settings.extlink.mailtoClass + '), area:not(.' + settings.extlink.extClass + ', .' + settings.extlink.mailtoClass + ')', context).each(function (el) {
      try {
        var url = '';
        if (typeof this.href == 'string') {
          url = this.href.toLowerCase();
        }
        // Handle SVG links (xlink:href).
        else if (typeof this.href == 'object') {
          url = this.href.baseVal;
        }
        if (url.indexOf('http') === 0
          && ((!url.match(internal_link) && !(extExclude && url.match(extExclude))) || (extInclude && url.match(extInclude)))
          && !(extCssExclude && $(this).is(extCssExclude))
          && !(extCssExclude && $(this).parents(extCssExclude).length > 0)
          && !(extCssExplicit && $(this).parents(extCssExplicit).length < 1)) {
          external_links.push(this);
        }
        // Do not include area tags with begin with mailto: (this prohibits
        // icons from being added to image-maps).
        else if (this.tagName !== 'AREA'
          && url.indexOf('mailto:') === 0
          && !(extCssExclude && $(this).parents(extCssExclude).length > 0)
          && !(extCssExplicit && $(this).parents(extCssExplicit).length < 1)) {
          mailto_links.push(this);
        }
      }
      // IE7 throws errors often when dealing with irregular links, such as:
      // <a href="node/10"></a> Empty tags.
      // <a href="http://user:pass@example.com">example</a> User:pass syntax.
      catch (error) {
        return false;
      }
    });

    if (settings.extlink.extClass) {
      Drupal.extlink.applyClassAndSpan(external_links, settings.extlink.extClass, extIconPlacement);
    }

    if (settings.extlink.mailtoClass) {
      Drupal.extlink.applyClassAndSpan(mailto_links, settings.extlink.mailtoClass, extIconPlacement);
    }

    if (settings.extlink.extTarget) {
      // Apply the target attribute to all links.
      $(external_links).attr('target', settings.extlink.extTarget);
      // Add rel attributes noopener and noreferrer.
      $(external_links).attr('rel', function (i, val) {
        // If no rel attribute is present, create one with the values noopener and noreferrer.
        if (val == null) {
          return 'noopener noreferrer';
        }
        // Check to see if rel contains noopener or noreferrer. Add what doesn't exist.
        if (val.indexOf('noopener') > -1 || val.indexOf('noreferrer') > -1) {
          if (val.indexOf('noopener') === -1) {
            return val + ' noopener';
          }
          if (val.indexOf('noreferrer') === -1) {
            return val + ' noreferrer';
          }
          // Both noopener and noreferrer exist. Nothing needs to be added.
          else {
            return val;
          }
        }
        // Else, append noopener and noreferrer to val.
        else {
          return val + ' noopener noreferrer';
        }
      });
    }

    Drupal.extlink = Drupal.extlink || {};

    // Set up default click function for the external links popup. This should be
    // overridden by modules wanting to alter the popup.
    Drupal.extlink.popupClickHandler = Drupal.extlink.popupClickHandler || function () {
      if (settings.extlink.extAlert) {
        return confirm(settings.extlink.extAlertText);
      }
    };

    $(external_links).click(function (e) {
      return Drupal.extlink.popupClickHandler(e, this);
    });
  };

  /**
   * Apply a class and a trailing <span> to all links not containing images.
   *
   * @param {object[]} links
   *   An array of DOM elements representing the links.
   * @param {string} class_name
   *   The class to apply to the links.
   * @param {string} icon_placement
   *   'append' or 'prepend' the icon to the link.
   */
  Drupal.extlink.applyClassAndSpan = function (links, class_name, icon_placement) {
    var $links_to_process;
    if (Drupal.settings.extlink.extImgClass) {
      $links_to_process = $(links);
    }
    else {
      var links_with_images = $(links).find('img').parents('a');
      $links_to_process = $(links).not(links_with_images);
    }
    $links_to_process.addClass(class_name);
    var i;
    var length = $links_to_process.length;
    for (i = 0; i < length; i++) {
      var $link = $($links_to_process[i]);
      if ($link.css('display') === 'inline' || $link.css('display') === 'inline-block') {
        if (class_name === Drupal.settings.extlink.mailtoClass) {
          $link[icon_placement]('<span class="' + class_name + '" aria-label="' + Drupal.settings.extlink.mailtoLabel + '"></span>');
        }
        else {
          $link[icon_placement]('<span class="' + class_name + '" aria-label="' + Drupal.settings.extlink.extLabel + '"></span>');
        }
      }
    }
  };

  Drupal.behaviors.extlink = Drupal.behaviors.extlink || {};
  Drupal.behaviors.extlink.attach = function (context, settings) {
    // Backwards compatibility, for the benefit of modules overriding extlink
    // functionality by defining an "extlinkAttach" global function.
    if (typeof extlinkAttach === 'function') {
      extlinkAttach(context);
    }
    else {
      Drupal.extlink.attach(context, settings);
    }
  };

})(jQuery);
;
