/**
* OpenX semi- Lazy Loader script
*
* This script will load all the ads on a page IFF those ares
* are on the current layout (ie, desktop, mobile, tablet).
*
* This will correct the problem of ads being request that
* will never be seen by the user because they are not on the
* display the user is seeing.
*
*
* This script runs by calling OXSemiLazyLoader.initialize(OXAds)
* 
* Note that OXAds is the same as OpenX's window.OX_ads array.
* I use OXAds because most likely you'll need to unset
* window.OX_ads before calling the
* http://ox-d.charisma.net/w/1.0/jstag script. This is 
* because that script will request all ads units found in 
* window.OX_ads when it loads, which would defeat the 
* purpose of lazy loading those ads later on with OXSemiLazyLoader
* 
* Here is an example of how to handle window.OX_ads before
* loading http://ox-d.charisma.net/w/1.0/jstag:
*
* <script>
* var OXAds = window.OX_ads;
* window.OX_ads = undefined;
* </script>
*
* jQuery is required for this script to work. If your site
* has jQuery.noConflict() then you'll probably need to 
* change the "$" functions to "jQuery".
*
* @author		Drew Glaser <drew.glaser@charismamedia.com>
* @version		1.0
* @copyright	2015 Charisma Media, All rights reserved.
*/

var OXSemiLazyLoader =
{
	// -----------------
	// Configuration vars
	
	// slot_id of ads to always load at the start. Use this
	// to work around any banners that don't trigger when
	// they should
	//alwaysLoad : ['BNR538070298'],
	
	// -----------------
	// Non-config vars
	
	window : null,
	invisibleAds : null,
	loaded : [],
	
	// -----------------
	// Methods

	// Sets up variables and makes the initial check for
	// visible ads to load. Also sets up the scroll trigger
	initialize: function(OXAds)
	{
		if(OXAds.length==0) return;

		this.window = $(window);
		this.invisibleAds = OXAds;

		// Check for which ads to load when the page first
		// loads (before any scrolling)
		this.invisibleAds.forEach(this.checkForVisibleBanners);
		if(this.loaded.length>0)
		{
			this.loaded.forEach(this.removeLoaded);
			this.loaded = [];
		}

		// Adds scroll listener. Even though all the ads for the
		// current layout should be loaded we're still going to
		// check on scroll. This is in cases where the view changes
		// (exposing previously invisible ads) or we've added
		// code that makes a previously invisible ad visible for
		// some reason.
		this.window.bind("scroll",OXSemiLazyLoader.afterScrollListenerActions);

	},
	
	// The forEach callback that loads an ad unit if it's visible
	checkForVisibleBanners : function(el, index, array)
	{
		if(Array.isArray(el)) el = el[0];

		// Is the element visible on the current layout
		if($('#'+el.slot_id).is(':visible')===false) { return; }

		// Load the ad unit. It seems we need to create a new
		// OX() variable for each ad unit call or else the
		// settings get messed up (When I was sharing the same
		// OXLoader I had an issue where ads were refreshing 
		// ver and over every X number of seconds. Or, when a 
		// later ad was loaded all the previous ads would
		// refresh).
		var OXLoader = OX();
		OXLoader.addAdUnit(el.auid);
		OXLoader.setAdUnitSlotId(el.auid,el.slot_id);
		OXLoader.load();

		// Record the index of which ads were loaded so
		// we can remove them from this.invisibleAds
		OXSemiLazyLoader.loaded.push(index);

	},

	// Removes the elements from this.invisibleAds that were
	// loaded/requested so we don't recheck/load them
	removeLoaded : function(el, index, array)
	{
		OXSemiLazyLoader.invisibleAds.splice(el, 1);
	},

	// the "on scroll" listener callback
	afterScrollListenerActions : function(e)
	{

		if(OXSemiLazyLoader.invisibleAds.length==0)
		{
			this.window.unbind('scroll', OXSemiLazyLoader.afterScrollListenerActions);
			return;
		}

		OXSemiLazyLoader.invisibleAds.forEach(OXSemiLazyLoader.checkForVisibleBanners);
		
		if(OXSemiLazyLoader.loaded.length>0)
		{
			OXSemiLazyLoader.loaded.forEach(OXSemiLazyLoader.removeLoaded);
			OXSemiLazyLoader.loaded = [];
		}

	}
}

// Let's do this!
window.OXSemiLazyLoader.initialize(semiLazyLoadItems);