// tipsy, facebook style tooltips for jquery
// version 1.0.0a
// (c) 2008-2010 jason frame [jason@onehackoranother.com]
// released under the MIT license

(function($) {
    
    function maybeCall(thing, ctx) {
        return (typeof thing == 'function') ? (thing.call(ctx)) : thing;
    };
    
    function isElementInDOM(ele) {
      while (ele = ele.parentNode) {
        if (ele == document) return true;
      }
      return false;
    };
    
    function Tipsy(element, options) {
        this.$element = $(element);
        this.options = options;
        this.enabled = true;
        this.fixTitle();
    };
    
    Tipsy.prototype = {
        show: function() {
            var title = this.getTitle();
            if (title && this.enabled) {
                var $tip = this.tip();
                
                $tip.find('.tipsy-inner')[this.options.html ? 'html' : 'text'](title);
                $tip[0].className = 'tipsy'; // reset classname in case of dynamic gravity
                $tip.remove().css({top: 0, left: 0, visibility: 'hidden', display: 'block'}).prependTo(document.body);
                
                var pos = $.extend({}, this.$element.offset(), {
                    width: this.$element[0].offsetWidth,
                    height: this.$element[0].offsetHeight
                });
                
                var actualWidth = $tip[0].offsetWidth,
                    actualHeight = $tip[0].offsetHeight,
                    gravity = maybeCall(this.options.gravity, this.$element[0]);
                
                var tp;
                switch (gravity.charAt(0)) {
                    case 'n':
                        tp = {top: pos.top + pos.height + this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
                        break;
                    case 's':
                        tp = {top: pos.top - actualHeight - this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
                        break;
                    case 'e':
                        tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left - actualWidth - this.options.offset};
                        break;
                    case 'w':
                        tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left + pos.width + this.options.offset};
                        break;
                }
                
                if (gravity.length == 2) {
                    if (gravity.charAt(1) == 'w') {
                        tp.left = pos.left + pos.width / 2 - 15;
                    } else {
                        tp.left = pos.left + pos.width / 2 - actualWidth + 15;
                    }
                }
                
                $tip.css(tp).addClass('tipsy-' + gravity);
                $tip.find('.tipsy-arrow')[0].className = 'tipsy-arrow tipsy-arrow-' + gravity.charAt(0);
                if (this.options.className) {
                    $tip.addClass(maybeCall(this.options.className, this.$element[0]));
                }
                
                if (this.options.fade) {
                    $tip.stop().css({opacity: 0, display: 'block', visibility: 'visible'}).animate({opacity: this.options.opacity});
                } else {
                    $tip.css({visibility: 'visible', opacity: this.options.opacity});
                }
            }
        },
        
        hide: function() {
            if (this.options.fade) {
                this.tip().stop().fadeOut(function() { $(this).remove(); });
            } else {
                this.tip().remove();
            }
        },
        
        fixTitle: function() {
            var $e = this.$element;
            if ($e.attr('title') || typeof($e.attr('original-title')) != 'string') {
                $e.attr('original-title', $e.attr('title') || '').removeAttr('title');
            }
        },
        
        getTitle: function() {
            var title, $e = this.$element, o = this.options;
            this.fixTitle();
            var title, o = this.options;
            if (typeof o.title == 'string') {
                title = $e.attr(o.title == 'title' ? 'original-title' : o.title);
            } else if (typeof o.title == 'function') {
                title = o.title.call($e[0]);
            }
            title = ('' + title).replace(/(^\s*|\s*$)/, "");
            return title || o.fallback;
        },
        
        tip: function() {
            if (!this.$tip) {
                this.$tip = $('<div class="tipsy"></div>').html('<div class="tipsy-arrow"></div><div class="tipsy-inner"></div>');
                this.$tip.data('tipsy-pointee', this.$element[0]);
            }
            return this.$tip;
        },
        
        validate: function() {
            if (!this.$element[0].parentNode) {
                this.hide();
                this.$element = null;
                this.options = null;
            }
        },
        
        enable: function() { this.enabled = true; },
        disable: function() { this.enabled = false; },
        toggleEnabled: function() { this.enabled = !this.enabled; }
    };
    
    $.fn.tipsy = function(options) {
        
        if (options === true) {
            return this.data('tipsy');
        } else if (typeof options == 'string') {
            var tipsy = this.data('tipsy');
            if (tipsy) tipsy[options]();
            return this;
        }
        
        options = $.extend({}, $.fn.tipsy.defaults, options);
        
        function get(ele) {
            var tipsy = $.data(ele, 'tipsy');
            if (!tipsy) {
                tipsy = new Tipsy(ele, $.fn.tipsy.elementOptions(ele, options));
                $.data(ele, 'tipsy', tipsy);
            }
            return tipsy;
        }
        
        function enter() {
            var tipsy = get(this);
            tipsy.hoverState = 'in';
            if (options.delayIn == 0) {
                tipsy.show();
            } else {
                tipsy.fixTitle();
                setTimeout(function() { if (tipsy.hoverState == 'in') tipsy.show(); }, options.delayIn);
            }
        };
        
        function leave() {
            var tipsy = get(this);
            tipsy.hoverState = 'out';
            if (options.delayOut == 0) {
                tipsy.hide();
            } else {
                setTimeout(function() { if (tipsy.hoverState == 'out') tipsy.hide(); }, options.delayOut);
            }
        };
        
        if (!options.live) this.each(function() { get(this); });
        
        if (options.trigger != 'manual') {
            var binder   = options.live ? 'live' : 'bind',
                eventIn  = options.trigger == 'hover' ? 'mouseenter' : 'focus',
                eventOut = options.trigger == 'hover' ? 'mouseleave' : 'blur';
            this[binder](eventIn, enter)[binder](eventOut, leave);
        }
        
        return this;
        
    };
    
    $.fn.tipsy.defaults = {
        className: null,
        delayIn: 0,
        delayOut: 0,
        fade: false,
        fallback: '',
        gravity: 'n',
        html: false,
        live: false,
        offset: 0,
        opacity: 0.8,
        title: 'title',
        trigger: 'hover'
    };
    
    $.fn.tipsy.revalidate = function() {
      $('.tipsy').each(function() {
        var pointee = $.data(this, 'tipsy-pointee');
        if (!pointee || !isElementInDOM(pointee)) {
          $(this).remove();
        }
      });
    };
    
    // Overwrite this method to provide options on a per-element basis.
    // For example, you could store the gravity in a 'tipsy-gravity' attribute:
    // return $.extend({}, options, {gravity: $(ele).attr('tipsy-gravity') || 'n' });
    // (remember - do not modify 'options' in place!)
    $.fn.tipsy.elementOptions = function(ele, options) {
        return $.metadata ? $.extend({}, options, $(ele).metadata()) : options;
    };
    
    $.fn.tipsy.autoNS = function() {
        return $(this).offset().top > ($(document).scrollTop() + $(window).height() / 2) ? 's' : 'n';
    };
    
    $.fn.tipsy.autoWE = function() {
        return $(this).offset().left > ($(document).scrollLeft() + $(window).width() / 2) ? 'e' : 'w';
    };
    
    /**
     * yields a closure of the supplied parameters, producing a function that takes
     * no arguments and is suitable for use as an autogravity function like so:
     *
     * @param margin (int) - distance from the viewable region edge that an
     *        element should be before setting its tooltip's gravity to be away
     *        from that edge.
     * @param prefer (string, e.g. 'n', 'sw', 'w') - the direction to prefer
     *        if there are no viewable region edges effecting the tooltip's
     *        gravity. It will try to vary from this minimally, for example,
     *        if 'sw' is preferred and an element is near the right viewable 
     *        region edge, but not the top edge, it will set the gravity for
     *        that element's tooltip to be 'se', preserving the southern
     *        component.
     */
     $.fn.tipsy.autoBounds = function(margin, prefer) {
		return function() {
			var dir = {ns: prefer[0], ew: (prefer.length > 1 ? prefer[1] : false)},
			    boundTop = $(document).scrollTop() + margin,
			    boundLeft = $(document).scrollLeft() + margin,
			    $this = $(this);

			if ($this.offset().top < boundTop) dir.ns = 'n';
			if ($this.offset().left < boundLeft) dir.ew = 'w';
			if ($(window).width() + $(document).scrollLeft() - $this.offset().left < margin) dir.ew = 'e';
			if ($(window).height() + $(document).scrollTop() - $this.offset().top < margin) dir.ns = 's';

			return dir.ns + (dir.ew ? dir.ew : '');
		}
	};
    
})(jQuery);


/* Chosen v1.4.2 | (c) 2011-2015 by Harvest | MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md */
(function(){var a,AbstractChosen,Chosen,SelectParser,b,c={}.hasOwnProperty,d=function(a,b){function d(){this.constructor=a}for(var e in b)c.call(b,e)&&(a[e]=b[e]);return d.prototype=b.prototype,a.prototype=new d,a.__super__=b.prototype,a};SelectParser=function(){function SelectParser(){this.options_index=0,this.parsed=[]}return SelectParser.prototype.add_node=function(a){return"OPTGROUP"===a.nodeName.toUpperCase()?this.add_group(a):this.add_option(a)},SelectParser.prototype.add_group=function(a){var b,c,d,e,f,g;for(b=this.parsed.length,this.parsed.push({array_index:b,group:!0,label:this.escapeExpression(a.label),title:a.title?a.title:void 0,children:0,disabled:a.disabled,classes:a.className}),f=a.childNodes,g=[],d=0,e=f.length;e>d;d++)c=f[d],g.push(this.add_option(c,b,a.disabled));return g},SelectParser.prototype.add_option=function(a,b,c){return"OPTION"===a.nodeName.toUpperCase()?(""!==a.text?(null!=b&&(this.parsed[b].children+=1),this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,value:a.value,text:a.text,html:a.innerHTML,title:a.title?a.title:void 0,selected:a.selected,disabled:c===!0?c:a.disabled,group_array_index:b,group_label:null!=b?this.parsed[b].label:null,classes:a.className,style:a.style.cssText})):this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,empty:!0}),this.options_index+=1):void 0},SelectParser.prototype.escapeExpression=function(a){var b,c;return null==a||a===!1?"":/[\&\<\>\"\'\`]/.test(a)?(b={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},c=/&(?!\w+;)|[\<\>\"\'\`]/g,a.replace(c,function(a){return b[a]||"&amp;"})):a},SelectParser}(),SelectParser.select_to_array=function(a){var b,c,d,e,f;for(c=new SelectParser,f=a.childNodes,d=0,e=f.length;e>d;d++)b=f[d],c.add_node(b);return c.parsed},AbstractChosen=function(){function AbstractChosen(a,b){this.form_field=a,this.options=null!=b?b:{},AbstractChosen.browser_is_supported()&&(this.is_multiple=this.form_field.multiple,this.set_default_text(),this.set_default_values(),this.setup(),this.set_up_html(),this.register_observers(),this.on_ready())}return AbstractChosen.prototype.set_default_values=function(){var a=this;return this.click_test_action=function(b){return a.test_active_click(b)},this.activate_action=function(b){return a.activate_field(b)},this.active_field=!1,this.mouse_on_container=!1,this.results_showing=!1,this.result_highlighted=null,this.allow_single_deselect=null!=this.options.allow_single_deselect&&null!=this.form_field.options[0]&&""===this.form_field.options[0].text?this.options.allow_single_deselect:!1,this.disable_search_threshold=this.options.disable_search_threshold||0,this.disable_search=this.options.disable_search||!1,this.enable_split_word_search=null!=this.options.enable_split_word_search?this.options.enable_split_word_search:!0,this.group_search=null!=this.options.group_search?this.options.group_search:!0,this.search_contains=this.options.search_contains||!1,this.single_backstroke_delete=null!=this.options.single_backstroke_delete?this.options.single_backstroke_delete:!0,this.max_selected_options=this.options.max_selected_options||1/0,this.inherit_select_classes=this.options.inherit_select_classes||!1,this.display_selected_options=null!=this.options.display_selected_options?this.options.display_selected_options:!0,this.display_disabled_options=null!=this.options.display_disabled_options?this.options.display_disabled_options:!0,this.include_group_label_in_selected=this.options.include_group_label_in_selected||!1},AbstractChosen.prototype.set_default_text=function(){return this.default_text=this.form_field.getAttribute("data-placeholder")?this.form_field.getAttribute("data-placeholder"):this.is_multiple?this.options.placeholder_text_multiple||this.options.placeholder_text||AbstractChosen.default_multiple_text:this.options.placeholder_text_single||this.options.placeholder_text||AbstractChosen.default_single_text,this.results_none_found=this.form_field.getAttribute("data-no_results_text")||this.options.no_results_text||AbstractChosen.default_no_result_text},AbstractChosen.prototype.choice_label=function(a){return this.include_group_label_in_selected&&null!=a.group_label?"<b class='group-name'>"+a.group_label+"</b>"+a.html:a.html},AbstractChosen.prototype.mouse_enter=function(){return this.mouse_on_container=!0},AbstractChosen.prototype.mouse_leave=function(){return this.mouse_on_container=!1},AbstractChosen.prototype.input_focus=function(){var a=this;if(this.is_multiple){if(!this.active_field)return setTimeout(function(){return a.container_mousedown()},50)}else if(!this.active_field)return this.activate_field()},AbstractChosen.prototype.input_blur=function(){var a=this;return this.mouse_on_container?void 0:(this.active_field=!1,setTimeout(function(){return a.blur_test()},100))},AbstractChosen.prototype.results_option_build=function(a){var b,c,d,e,f;for(b="",f=this.results_data,d=0,e=f.length;e>d;d++)c=f[d],b+=c.group?this.result_add_group(c):this.result_add_option(c),(null!=a?a.first:void 0)&&(c.selected&&this.is_multiple?this.choice_build(c):c.selected&&!this.is_multiple&&this.single_set_selected_text(this.choice_label(c)));return b},AbstractChosen.prototype.result_add_option=function(a){var b,c;return a.search_match?this.include_option_in_results(a)?(b=[],a.disabled||a.selected&&this.is_multiple||b.push("active-result"),!a.disabled||a.selected&&this.is_multiple||b.push("disabled-result"),a.selected&&b.push("result-selected"),null!=a.group_array_index&&b.push("group-option"),""!==a.classes&&b.push(a.classes),c=document.createElement("li"),c.className=b.join(" "),c.style.cssText=a.style,c.setAttribute("data-option-array-index",a.array_index),c.innerHTML=a.search_text,a.title&&(c.title=a.title),this.outerHTML(c)):"":""},AbstractChosen.prototype.result_add_group=function(a){var b,c;return a.search_match||a.group_match?a.active_options>0?(b=[],b.push("group-result"),a.classes&&b.push(a.classes),c=document.createElement("li"),c.className=b.join(" "),c.innerHTML=a.search_text,a.title&&(c.title=a.title),this.outerHTML(c)):"":""},AbstractChosen.prototype.results_update_field=function(){return this.set_default_text(),this.is_multiple||this.results_reset_cleanup(),this.result_clear_highlight(),this.results_build(),this.results_showing?this.winnow_results():void 0},AbstractChosen.prototype.reset_single_select_options=function(){var a,b,c,d,e;for(d=this.results_data,e=[],b=0,c=d.length;c>b;b++)a=d[b],a.selected?e.push(a.selected=!1):e.push(void 0);return e},AbstractChosen.prototype.results_toggle=function(){return this.results_showing?this.results_hide():this.results_show()},AbstractChosen.prototype.results_search=function(){return this.results_showing?this.winnow_results():this.results_show()},AbstractChosen.prototype.winnow_results=function(){var a,b,c,d,e,f,g,h,i,j,k,l;for(this.no_results_clear(),d=0,f=this.get_search_text(),a=f.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),i=new RegExp(a,"i"),c=this.get_search_regex(a),l=this.results_data,j=0,k=l.length;k>j;j++)b=l[j],b.search_match=!1,e=null,this.include_option_in_results(b)&&(b.group&&(b.group_match=!1,b.active_options=0),null!=b.group_array_index&&this.results_data[b.group_array_index]&&(e=this.results_data[b.group_array_index],0===e.active_options&&e.search_match&&(d+=1),e.active_options+=1),b.search_text=b.group?b.label:b.html,(!b.group||this.group_search)&&(b.search_match=this.search_string_match(b.search_text,c),b.search_match&&!b.group&&(d+=1),b.search_match?(f.length&&(g=b.search_text.search(i),h=b.search_text.substr(0,g+f.length)+"</em>"+b.search_text.substr(g+f.length),b.search_text=h.substr(0,g)+"<em>"+h.substr(g)),null!=e&&(e.group_match=!0)):null!=b.group_array_index&&this.results_data[b.group_array_index].search_match&&(b.search_match=!0)));return this.result_clear_highlight(),1>d&&f.length?(this.update_results_content(""),this.no_results(f)):(this.update_results_content(this.results_option_build()),this.winnow_results_set_highlight())},AbstractChosen.prototype.get_search_regex=function(a){var b;return b=this.search_contains?"":"^",new RegExp(b+a,"i")},AbstractChosen.prototype.search_string_match=function(a,b){var c,d,e,f;if(b.test(a))return!0;if(this.enable_split_word_search&&(a.indexOf(" ")>=0||0===a.indexOf("["))&&(d=a.replace(/\[|\]/g,"").split(" "),d.length))for(e=0,f=d.length;f>e;e++)if(c=d[e],b.test(c))return!0},AbstractChosen.prototype.choices_count=function(){var a,b,c,d;if(null!=this.selected_option_count)return this.selected_option_count;for(this.selected_option_count=0,d=this.form_field.options,b=0,c=d.length;c>b;b++)a=d[b],a.selected&&(this.selected_option_count+=1);return this.selected_option_count},AbstractChosen.prototype.choices_click=function(a){return a.preventDefault(),this.results_showing||this.is_disabled?void 0:this.results_show()},AbstractChosen.prototype.keyup_checker=function(a){var b,c;switch(b=null!=(c=a.which)?c:a.keyCode,this.search_field_scale(),b){case 8:if(this.is_multiple&&this.backstroke_length<1&&this.choices_count()>0)return this.keydown_backstroke();if(!this.pending_backstroke)return this.result_clear_highlight(),this.results_search();break;case 13:if(a.preventDefault(),this.results_showing)return this.result_select(a);break;case 27:return this.results_showing&&this.results_hide(),!0;case 9:case 38:case 40:case 16:case 91:case 17:break;default:return this.results_search()}},AbstractChosen.prototype.clipboard_event_checker=function(){var a=this;return setTimeout(function(){return a.results_search()},50)},AbstractChosen.prototype.container_width=function(){return null!=this.options.width?this.options.width:""+this.form_field.offsetWidth+"px"},AbstractChosen.prototype.include_option_in_results=function(a){return this.is_multiple&&!this.display_selected_options&&a.selected?!1:!this.display_disabled_options&&a.disabled?!1:a.empty?!1:!0},AbstractChosen.prototype.search_results_touchstart=function(a){return this.touch_started=!0,this.search_results_mouseover(a)},AbstractChosen.prototype.search_results_touchmove=function(a){return this.touch_started=!1,this.search_results_mouseout(a)},AbstractChosen.prototype.search_results_touchend=function(a){return this.touch_started?this.search_results_mouseup(a):void 0},AbstractChosen.prototype.outerHTML=function(a){var b;return a.outerHTML?a.outerHTML:(b=document.createElement("div"),b.appendChild(a),b.innerHTML)},AbstractChosen.browser_is_supported=function(){return"Microsoft Internet Explorer"===window.navigator.appName?document.documentMode>=8:/iP(od|hone)/i.test(window.navigator.userAgent)?!1:/Android/i.test(window.navigator.userAgent)&&/Mobile/i.test(window.navigator.userAgent)?!1:!0},AbstractChosen.default_multiple_text="Select Some Options",AbstractChosen.default_single_text="Select an Option",AbstractChosen.default_no_result_text="No results match",AbstractChosen}(),a=jQuery,a.fn.extend({chosen:function(b){return AbstractChosen.browser_is_supported()?this.each(function(){var c,d;c=a(this),d=c.data("chosen"),"destroy"===b&&d instanceof Chosen?d.destroy():d instanceof Chosen||c.data("chosen",new Chosen(this,b))}):this}}),Chosen=function(c){function Chosen(){return b=Chosen.__super__.constructor.apply(this,arguments)}return d(Chosen,c),Chosen.prototype.setup=function(){return this.form_field_jq=a(this.form_field),this.current_selectedIndex=this.form_field.selectedIndex,this.is_rtl=this.form_field_jq.hasClass("chosen-rtl")},Chosen.prototype.set_up_html=function(){var b,c;return b=["chosen-container"],b.push("chosen-container-"+(this.is_multiple?"multi":"single")),this.inherit_select_classes&&this.form_field.className&&b.push(this.form_field.className),this.is_rtl&&b.push("chosen-rtl"),c={"class":b.join(" "),style:"width: "+this.container_width()+";",title:this.form_field.title},this.form_field.id.length&&(c.id=this.form_field.id.replace(/[^\w]/g,"_")+"_chosen"),this.container=a("<div />",c),this.is_multiple?this.container.html('<ul class="chosen-choices"><li class="search-field"><input type="text" value="'+this.default_text+'" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chosen-drop"><ul class="chosen-results"></ul></div>'):this.container.html('<a class="chosen-single chosen-default" tabindex="-1"><span>'+this.default_text+'</span><div><b></b></div></a><div class="chosen-drop"><div class="chosen-search"><input type="text" autocomplete="off" /></div><ul class="chosen-results"></ul></div>'),this.form_field_jq.hide().after(this.container),this.dropdown=this.container.find("div.chosen-drop").first(),this.search_field=this.container.find("input").first(),this.search_results=this.container.find("ul.chosen-results").first(),this.search_field_scale(),this.search_no_results=this.container.find("li.no-results").first(),this.is_multiple?(this.search_choices=this.container.find("ul.chosen-choices").first(),this.search_container=this.container.find("li.search-field").first()):(this.search_container=this.container.find("div.chosen-search").first(),this.selected_item=this.container.find(".chosen-single").first()),this.results_build(),this.set_tab_index(),this.set_label_behavior()},Chosen.prototype.on_ready=function(){return this.form_field_jq.trigger("chosen:ready",{chosen:this})},Chosen.prototype.register_observers=function(){var a=this;return this.container.bind("touchstart.chosen",function(b){return a.container_mousedown(b),b.preventDefault()}),this.container.bind("touchend.chosen",function(b){return a.container_mouseup(b),b.preventDefault()}),this.container.bind("mousedown.chosen",function(b){a.container_mousedown(b)}),this.container.bind("mouseup.chosen",function(b){a.container_mouseup(b)}),this.container.bind("mouseenter.chosen",function(b){a.mouse_enter(b)}),this.container.bind("mouseleave.chosen",function(b){a.mouse_leave(b)}),this.search_results.bind("mouseup.chosen",function(b){a.search_results_mouseup(b)}),this.search_results.bind("mouseover.chosen",function(b){a.search_results_mouseover(b)}),this.search_results.bind("mouseout.chosen",function(b){a.search_results_mouseout(b)}),this.search_results.bind("mousewheel.chosen DOMMouseScroll.chosen",function(b){a.search_results_mousewheel(b)}),this.search_results.bind("touchstart.chosen",function(b){a.search_results_touchstart(b)}),this.search_results.bind("touchmove.chosen",function(b){a.search_results_touchmove(b)}),this.search_results.bind("touchend.chosen",function(b){a.search_results_touchend(b)}),this.form_field_jq.bind("chosen:updated.chosen",function(b){a.results_update_field(b)}),this.form_field_jq.bind("chosen:activate.chosen",function(b){a.activate_field(b)}),this.form_field_jq.bind("chosen:open.chosen",function(b){a.container_mousedown(b)}),this.form_field_jq.bind("chosen:close.chosen",function(b){a.input_blur(b)}),this.search_field.bind("blur.chosen",function(b){a.input_blur(b)}),this.search_field.bind("keyup.chosen",function(b){a.keyup_checker(b)}),this.search_field.bind("keydown.chosen",function(b){a.keydown_checker(b)}),this.search_field.bind("focus.chosen",function(b){a.input_focus(b)}),this.search_field.bind("cut.chosen",function(b){a.clipboard_event_checker(b)}),this.search_field.bind("paste.chosen",function(b){a.clipboard_event_checker(b)}),this.is_multiple?this.search_choices.bind("click.chosen",function(b){a.choices_click(b)}):this.container.bind("click.chosen",function(a){a.preventDefault()})},Chosen.prototype.destroy=function(){return a(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.search_field[0].tabIndex&&(this.form_field_jq[0].tabIndex=this.search_field[0].tabIndex),this.container.remove(),this.form_field_jq.removeData("chosen"),this.form_field_jq.show()},Chosen.prototype.search_field_disabled=function(){return this.is_disabled=this.form_field_jq[0].disabled,this.is_disabled?(this.container.addClass("chosen-disabled"),this.search_field[0].disabled=!0,this.is_multiple||this.selected_item.unbind("focus.chosen",this.activate_action),this.close_field()):(this.container.removeClass("chosen-disabled"),this.search_field[0].disabled=!1,this.is_multiple?void 0:this.selected_item.bind("focus.chosen",this.activate_action))},Chosen.prototype.container_mousedown=function(b){return this.is_disabled||(b&&"mousedown"===b.type&&!this.results_showing&&b.preventDefault(),null!=b&&a(b.target).hasClass("search-choice-close"))?void 0:(this.active_field?this.is_multiple||!b||a(b.target)[0]!==this.selected_item[0]&&!a(b.target).parents("a.chosen-single").length||(b.preventDefault(),this.results_toggle()):(this.is_multiple&&this.search_field.val(""),a(this.container[0].ownerDocument).bind("click.chosen",this.click_test_action),this.results_show()),this.activate_field())},Chosen.prototype.container_mouseup=function(a){return"ABBR"!==a.target.nodeName||this.is_disabled?void 0:this.results_reset(a)},Chosen.prototype.search_results_mousewheel=function(a){var b;return a.originalEvent&&(b=a.originalEvent.deltaY||-a.originalEvent.wheelDelta||a.originalEvent.detail),null!=b?(a.preventDefault(),"DOMMouseScroll"===a.type&&(b=40*b),this.search_results.scrollTop(b+this.search_results.scrollTop())):void 0},Chosen.prototype.blur_test=function(){return!this.active_field&&this.container.hasClass("chosen-container-active")?this.close_field():void 0},Chosen.prototype.close_field=function(){return a(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.active_field=!1,this.results_hide(),this.container.removeClass("chosen-container-active"),this.clear_backstroke(),this.show_search_field_default(),this.search_field_scale()},Chosen.prototype.activate_field=function(){return this.container.addClass("chosen-container-active"),this.active_field=!0,this.search_field.val(this.search_field.val()),this.search_field.focus()},Chosen.prototype.test_active_click=function(b){var c;return c=a(b.target).closest(".chosen-container"),c.length&&this.container[0]===c[0]?this.active_field=!0:this.close_field()},Chosen.prototype.results_build=function(){return this.parsing=!0,this.selected_option_count=null,this.results_data=SelectParser.select_to_array(this.form_field),this.is_multiple?this.search_choices.find("li.search-choice").remove():this.is_multiple||(this.single_set_selected_text(),this.disable_search||this.form_field.options.length<=this.disable_search_threshold?(this.search_field[0].readOnly=!0,this.container.addClass("chosen-container-single-nosearch")):(this.search_field[0].readOnly=!1,this.container.removeClass("chosen-container-single-nosearch"))),this.update_results_content(this.results_option_build({first:!0})),this.search_field_disabled(),this.show_search_field_default(),this.search_field_scale(),this.parsing=!1},Chosen.prototype.result_do_highlight=function(a){var b,c,d,e,f;if(a.length){if(this.result_clear_highlight(),this.result_highlight=a,this.result_highlight.addClass("highlighted"),d=parseInt(this.search_results.css("maxHeight"),10),f=this.search_results.scrollTop(),e=d+f,c=this.result_highlight.position().top+this.search_results.scrollTop(),b=c+this.result_highlight.outerHeight(),b>=e)return this.search_results.scrollTop(b-d>0?b-d:0);if(f>c)return this.search_results.scrollTop(c)}},Chosen.prototype.result_clear_highlight=function(){return this.result_highlight&&this.result_highlight.removeClass("highlighted"),this.result_highlight=null},Chosen.prototype.results_show=function(){return this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.container.addClass("chosen-with-drop"),this.results_showing=!0,this.search_field.focus(),this.search_field.val(this.search_field.val()),this.winnow_results(),this.form_field_jq.trigger("chosen:showing_dropdown",{chosen:this}))},Chosen.prototype.update_results_content=function(a){return this.search_results.html(a)},Chosen.prototype.results_hide=function(){return this.results_showing&&(this.result_clear_highlight(),this.container.removeClass("chosen-with-drop"),this.form_field_jq.trigger("chosen:hiding_dropdown",{chosen:this})),this.results_showing=!1},Chosen.prototype.set_tab_index=function(){var a;return this.form_field.tabIndex?(a=this.form_field.tabIndex,this.form_field.tabIndex=-1,this.search_field[0].tabIndex=a):void 0},Chosen.prototype.set_label_behavior=function(){var b=this;return this.form_field_label=this.form_field_jq.parents("label"),!this.form_field_label.length&&this.form_field.id.length&&(this.form_field_label=a("label[for='"+this.form_field.id+"']")),this.form_field_label.length>0?this.form_field_label.bind("click.chosen",function(a){return b.is_multiple?b.container_mousedown(a):b.activate_field()}):void 0},Chosen.prototype.show_search_field_default=function(){return this.is_multiple&&this.choices_count()<1&&!this.active_field?(this.search_field.val(this.default_text),this.search_field.addClass("default")):(this.search_field.val(""),this.search_field.removeClass("default"))},Chosen.prototype.search_results_mouseup=function(b){var c;return c=a(b.target).hasClass("active-result")?a(b.target):a(b.target).parents(".active-result").first(),c.length?(this.result_highlight=c,this.result_select(b),this.search_field.focus()):void 0},Chosen.prototype.search_results_mouseover=function(b){var c;return c=a(b.target).hasClass("active-result")?a(b.target):a(b.target).parents(".active-result").first(),c?this.result_do_highlight(c):void 0},Chosen.prototype.search_results_mouseout=function(b){return a(b.target).hasClass("active-result")?this.result_clear_highlight():void 0},Chosen.prototype.choice_build=function(b){var c,d,e=this;return c=a("<li />",{"class":"search-choice"}).html("<span>"+this.choice_label(b)+"</span>"),b.disabled?c.addClass("search-choice-disabled"):(d=a("<a />",{"class":"search-choice-close","data-option-array-index":b.array_index}),d.bind("click.chosen",function(a){return e.choice_destroy_link_click(a)}),c.append(d)),this.search_container.before(c)},Chosen.prototype.choice_destroy_link_click=function(b){return b.preventDefault(),b.stopPropagation(),this.is_disabled?void 0:this.choice_destroy(a(b.target))},Chosen.prototype.choice_destroy=function(a){return this.result_deselect(a[0].getAttribute("data-option-array-index"))?(this.show_search_field_default(),this.is_multiple&&this.choices_count()>0&&this.search_field.val().length<1&&this.results_hide(),a.parents("li").first().remove(),this.search_field_scale()):void 0},Chosen.prototype.results_reset=function(){return this.reset_single_select_options(),this.form_field.options[0].selected=!0,this.single_set_selected_text(),this.show_search_field_default(),this.results_reset_cleanup(),this.form_field_jq.trigger("change"),this.active_field?this.results_hide():void 0},Chosen.prototype.results_reset_cleanup=function(){return this.current_selectedIndex=this.form_field.selectedIndex,this.selected_item.find("abbr").remove()},Chosen.prototype.result_select=function(a){var b,c;return this.result_highlight?(b=this.result_highlight,this.result_clear_highlight(),this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.is_multiple?b.removeClass("active-result"):this.reset_single_select_options(),b.addClass("result-selected"),c=this.results_data[b[0].getAttribute("data-option-array-index")],c.selected=!0,this.form_field.options[c.options_index].selected=!0,this.selected_option_count=null,this.is_multiple?this.choice_build(c):this.single_set_selected_text(this.choice_label(c)),(a.metaKey||a.ctrlKey)&&this.is_multiple||this.results_hide(),this.search_field.val(""),(this.is_multiple||this.form_field.selectedIndex!==this.current_selectedIndex)&&this.form_field_jq.trigger("change",{selected:this.form_field.options[c.options_index].value}),this.current_selectedIndex=this.form_field.selectedIndex,a.preventDefault(),this.search_field_scale())):void 0},Chosen.prototype.single_set_selected_text=function(a){return null==a&&(a=this.default_text),a===this.default_text?this.selected_item.addClass("chosen-default"):(this.single_deselect_control_build(),this.selected_item.removeClass("chosen-default")),this.selected_item.find("span").html(a)},Chosen.prototype.result_deselect=function(a){var b;return b=this.results_data[a],this.form_field.options[b.options_index].disabled?!1:(b.selected=!1,this.form_field.options[b.options_index].selected=!1,this.selected_option_count=null,this.result_clear_highlight(),this.results_showing&&this.winnow_results(),this.form_field_jq.trigger("change",{deselected:this.form_field.options[b.options_index].value}),this.search_field_scale(),!0)},Chosen.prototype.single_deselect_control_build=function(){return this.allow_single_deselect?(this.selected_item.find("abbr").length||this.selected_item.find("span").first().after('<abbr class="search-choice-close"></abbr>'),this.selected_item.addClass("chosen-single-with-deselect")):void 0},Chosen.prototype.get_search_text=function(){return a("<div/>").text(a.trim(this.search_field.val())).html()},Chosen.prototype.winnow_results_set_highlight=function(){var a,b;return b=this.is_multiple?[]:this.search_results.find(".result-selected.active-result"),a=b.length?b.first():this.search_results.find(".active-result").first(),null!=a?this.result_do_highlight(a):void 0},Chosen.prototype.no_results=function(b){var c;return c=a('<li class="no-results">'+this.results_none_found+' "<span></span>"</li>'),c.find("span").first().html(b),this.search_results.append(c),this.form_field_jq.trigger("chosen:no_results",{chosen:this})},Chosen.prototype.no_results_clear=function(){return this.search_results.find(".no-results").remove()},Chosen.prototype.keydown_arrow=function(){var a;return this.results_showing&&this.result_highlight?(a=this.result_highlight.nextAll("li.active-result").first())?this.result_do_highlight(a):void 0:this.results_show()},Chosen.prototype.keyup_arrow=function(){var a;return this.results_showing||this.is_multiple?this.result_highlight?(a=this.result_highlight.prevAll("li.active-result"),a.length?this.result_do_highlight(a.first()):(this.choices_count()>0&&this.results_hide(),this.result_clear_highlight())):void 0:this.results_show()},Chosen.prototype.keydown_backstroke=function(){var a;return this.pending_backstroke?(this.choice_destroy(this.pending_backstroke.find("a").first()),this.clear_backstroke()):(a=this.search_container.siblings("li.search-choice").last(),a.length&&!a.hasClass("search-choice-disabled")?(this.pending_backstroke=a,this.single_backstroke_delete?this.keydown_backstroke():this.pending_backstroke.addClass("search-choice-focus")):void 0)},Chosen.prototype.clear_backstroke=function(){return this.pending_backstroke&&this.pending_backstroke.removeClass("search-choice-focus"),this.pending_backstroke=null},Chosen.prototype.keydown_checker=function(a){var b,c;switch(b=null!=(c=a.which)?c:a.keyCode,this.search_field_scale(),8!==b&&this.pending_backstroke&&this.clear_backstroke(),b){case 8:this.backstroke_length=this.search_field.val().length;break;case 9:this.results_showing&&!this.is_multiple&&this.result_select(a),this.mouse_on_container=!1;break;case 13:this.results_showing&&a.preventDefault();break;case 32:this.disable_search&&a.preventDefault();break;case 38:a.preventDefault(),this.keyup_arrow();break;case 40:a.preventDefault(),this.keydown_arrow()}},Chosen.prototype.search_field_scale=function(){var b,c,d,e,f,g,h,i,j;if(this.is_multiple){for(d=0,h=0,f="position:absolute; left: -1000px; top: -1000px; display:none;",g=["font-size","font-style","font-weight","font-family","line-height","text-transform","letter-spacing"],i=0,j=g.length;j>i;i++)e=g[i],f+=e+":"+this.search_field.css(e)+";";return b=a("<div />",{style:f}),b.text(this.search_field.val()),a("body").append(b),h=b.width()+25,b.remove(),c=this.container.outerWidth(),h>c-10&&(h=c-10),this.search_field.css({width:h+"px"})}},Chosen}(AbstractChosen)}).call(this);

/*!
 * Isotope PACKAGED v2.2.2
 *
 * Licensed GPLv3 for open source use
 * or Isotope Commercial License for commercial use
 *
 * http://isotope.metafizzy.co
 * Copyright 2015 Metafizzy
 */

!function(a){function b(){}function c(a){function c(b){b.prototype.option||(b.prototype.option=function(b){a.isPlainObject(b)&&(this.options=a.extend(!0,this.options,b))})}function e(b,c){a.fn[b]=function(e){if("string"==typeof e){for(var g=d.call(arguments,1),h=0,i=this.length;i>h;h++){var j=this[h],k=a.data(j,b);if(k)if(a.isFunction(k[e])&&"_"!==e.charAt(0)){var l=k[e].apply(k,g);if(void 0!==l)return l}else f("no such method '"+e+"' for "+b+" instance");else f("cannot call methods on "+b+" prior to initialization; attempted to call '"+e+"'")}return this}return this.each(function(){var d=a.data(this,b);d?(d.option(e),d._init()):(d=new c(this,e),a.data(this,b,d))})}}if(a){var f="undefined"==typeof console?b:function(a){console.error(a)};return a.bridget=function(a,b){c(b),e(a,b)},a.bridget}}var d=Array.prototype.slice;"function"==typeof define&&define.amd?define("jquery-bridget/jquery.bridget",["jquery"],c):c("object"==typeof exports?require("jquery"):a.jQuery)}(window),function(a){function b(b){var c=a.event;return c.target=c.target||c.srcElement||b,c}var c=document.documentElement,d=function(){};c.addEventListener?d=function(a,b,c){a.addEventListener(b,c,!1)}:c.attachEvent&&(d=function(a,c,d){a[c+d]=d.handleEvent?function(){var c=b(a);d.handleEvent.call(d,c)}:function(){var c=b(a);d.call(a,c)},a.attachEvent("on"+c,a[c+d])});var e=function(){};c.removeEventListener?e=function(a,b,c){a.removeEventListener(b,c,!1)}:c.detachEvent&&(e=function(a,b,c){a.detachEvent("on"+b,a[b+c]);try{delete a[b+c]}catch(d){a[b+c]=void 0}});var f={bind:d,unbind:e};"function"==typeof define&&define.amd?define("eventie/eventie",f):"object"==typeof exports?module.exports=f:a.eventie=f}(window),function(){"use strict";function a(){}function b(a,b){for(var c=a.length;c--;)if(a[c].listener===b)return c;return-1}function c(a){return function(){return this[a].apply(this,arguments)}}var d=a.prototype,e=this,f=e.EventEmitter;d.getListeners=function(a){var b,c,d=this._getEvents();if(a instanceof RegExp){b={};for(c in d)d.hasOwnProperty(c)&&a.test(c)&&(b[c]=d[c])}else b=d[a]||(d[a]=[]);return b},d.flattenListeners=function(a){var b,c=[];for(b=0;b<a.length;b+=1)c.push(a[b].listener);return c},d.getListenersAsObject=function(a){var b,c=this.getListeners(a);return c instanceof Array&&(b={},b[a]=c),b||c},d.addListener=function(a,c){var d,e=this.getListenersAsObject(a),f="object"==typeof c;for(d in e)e.hasOwnProperty(d)&&-1===b(e[d],c)&&e[d].push(f?c:{listener:c,once:!1});return this},d.on=c("addListener"),d.addOnceListener=function(a,b){return this.addListener(a,{listener:b,once:!0})},d.once=c("addOnceListener"),d.defineEvent=function(a){return this.getListeners(a),this},d.defineEvents=function(a){for(var b=0;b<a.length;b+=1)this.defineEvent(a[b]);return this},d.removeListener=function(a,c){var d,e,f=this.getListenersAsObject(a);for(e in f)f.hasOwnProperty(e)&&(d=b(f[e],c),-1!==d&&f[e].splice(d,1));return this},d.off=c("removeListener"),d.addListeners=function(a,b){return this.manipulateListeners(!1,a,b)},d.removeListeners=function(a,b){return this.manipulateListeners(!0,a,b)},d.manipulateListeners=function(a,b,c){var d,e,f=a?this.removeListener:this.addListener,g=a?this.removeListeners:this.addListeners;if("object"!=typeof b||b instanceof RegExp)for(d=c.length;d--;)f.call(this,b,c[d]);else for(d in b)b.hasOwnProperty(d)&&(e=b[d])&&("function"==typeof e?f.call(this,d,e):g.call(this,d,e));return this},d.removeEvent=function(a){var b,c=typeof a,d=this._getEvents();if("string"===c)delete d[a];else if(a instanceof RegExp)for(b in d)d.hasOwnProperty(b)&&a.test(b)&&delete d[b];else delete this._events;return this},d.removeAllListeners=c("removeEvent"),d.emitEvent=function(a,b){var c,d,e,f,g=this.getListenersAsObject(a);for(e in g)if(g.hasOwnProperty(e))for(d=g[e].length;d--;)c=g[e][d],c.once===!0&&this.removeListener(a,c.listener),f=c.listener.apply(this,b||[]),f===this._getOnceReturnValue()&&this.removeListener(a,c.listener);return this},d.trigger=c("emitEvent"),d.emit=function(a){var b=Array.prototype.slice.call(arguments,1);return this.emitEvent(a,b)},d.setOnceReturnValue=function(a){return this._onceReturnValue=a,this},d._getOnceReturnValue=function(){return this.hasOwnProperty("_onceReturnValue")?this._onceReturnValue:!0},d._getEvents=function(){return this._events||(this._events={})},a.noConflict=function(){return e.EventEmitter=f,a},"function"==typeof define&&define.amd?define("eventEmitter/EventEmitter",[],function(){return a}):"object"==typeof module&&module.exports?module.exports=a:e.EventEmitter=a}.call(this),function(a){function b(a){if(a){if("string"==typeof d[a])return a;a=a.charAt(0).toUpperCase()+a.slice(1);for(var b,e=0,f=c.length;f>e;e++)if(b=c[e]+a,"string"==typeof d[b])return b}}var c="Webkit Moz ms Ms O".split(" "),d=document.documentElement.style;"function"==typeof define&&define.amd?define("get-style-property/get-style-property",[],function(){return b}):"object"==typeof exports?module.exports=b:a.getStyleProperty=b}(window),function(a,b){function c(a){var b=parseFloat(a),c=-1===a.indexOf("%")&&!isNaN(b);return c&&b}function d(){}function e(){for(var a={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},b=0,c=h.length;c>b;b++){var d=h[b];a[d]=0}return a}function f(b){function d(){if(!m){m=!0;var d=a.getComputedStyle;if(j=function(){var a=d?function(a){return d(a,null)}:function(a){return a.currentStyle};return function(b){var c=a(b);return c||g("Style returned "+c+". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1"),c}}(),k=b("boxSizing")){var e=document.createElement("div");e.style.width="200px",e.style.padding="1px 2px 3px 4px",e.style.borderStyle="solid",e.style.borderWidth="1px 2px 3px 4px",e.style[k]="border-box";var f=document.body||document.documentElement;f.appendChild(e);var h=j(e);l=200===c(h.width),f.removeChild(e)}}}function f(a){if(d(),"string"==typeof a&&(a=document.querySelector(a)),a&&"object"==typeof a&&a.nodeType){var b=j(a);if("none"===b.display)return e();var f={};f.width=a.offsetWidth,f.height=a.offsetHeight;for(var g=f.isBorderBox=!(!k||!b[k]||"border-box"!==b[k]),m=0,n=h.length;n>m;m++){var o=h[m],p=b[o];p=i(a,p);var q=parseFloat(p);f[o]=isNaN(q)?0:q}var r=f.paddingLeft+f.paddingRight,s=f.paddingTop+f.paddingBottom,t=f.marginLeft+f.marginRight,u=f.marginTop+f.marginBottom,v=f.borderLeftWidth+f.borderRightWidth,w=f.borderTopWidth+f.borderBottomWidth,x=g&&l,y=c(b.width);y!==!1&&(f.width=y+(x?0:r+v));var z=c(b.height);return z!==!1&&(f.height=z+(x?0:s+w)),f.innerWidth=f.width-(r+v),f.innerHeight=f.height-(s+w),f.outerWidth=f.width+t,f.outerHeight=f.height+u,f}}function i(b,c){if(a.getComputedStyle||-1===c.indexOf("%"))return c;var d=b.style,e=d.left,f=b.runtimeStyle,g=f&&f.left;return g&&(f.left=b.currentStyle.left),d.left=c,c=d.pixelLeft,d.left=e,g&&(f.left=g),c}var j,k,l,m=!1;return f}var g="undefined"==typeof console?d:function(a){console.error(a)},h=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"];"function"==typeof define&&define.amd?define("get-size/get-size",["get-style-property/get-style-property"],f):"object"==typeof exports?module.exports=f(require("desandro-get-style-property")):a.getSize=f(a.getStyleProperty)}(window),function(a){function b(a){"function"==typeof a&&(b.isReady?a():g.push(a))}function c(a){var c="readystatechange"===a.type&&"complete"!==f.readyState;b.isReady||c||d()}function d(){b.isReady=!0;for(var a=0,c=g.length;c>a;a++){var d=g[a];d()}}function e(e){return"complete"===f.readyState?d():(e.bind(f,"DOMContentLoaded",c),e.bind(f,"readystatechange",c),e.bind(a,"load",c)),b}var f=a.document,g=[];b.isReady=!1,"function"==typeof define&&define.amd?define("doc-ready/doc-ready",["eventie/eventie"],e):"object"==typeof exports?module.exports=e(require("eventie")):a.docReady=e(a.eventie)}(window),function(a){"use strict";function b(a,b){return a[g](b)}function c(a){if(!a.parentNode){var b=document.createDocumentFragment();b.appendChild(a)}}function d(a,b){c(a);for(var d=a.parentNode.querySelectorAll(b),e=0,f=d.length;f>e;e++)if(d[e]===a)return!0;return!1}function e(a,d){return c(a),b(a,d)}var f,g=function(){if(a.matches)return"matches";if(a.matchesSelector)return"matchesSelector";for(var b=["webkit","moz","ms","o"],c=0,d=b.length;d>c;c++){var e=b[c],f=e+"MatchesSelector";if(a[f])return f}}();if(g){var h=document.createElement("div"),i=b(h,"div");f=i?b:e}else f=d;"function"==typeof define&&define.amd?define("matches-selector/matches-selector",[],function(){return f}):"object"==typeof exports?module.exports=f:window.matchesSelector=f}(Element.prototype),function(a,b){"use strict";"function"==typeof define&&define.amd?define("fizzy-ui-utils/utils",["doc-ready/doc-ready","matches-selector/matches-selector"],function(c,d){return b(a,c,d)}):"object"==typeof exports?module.exports=b(a,require("doc-ready"),require("desandro-matches-selector")):a.fizzyUIUtils=b(a,a.docReady,a.matchesSelector)}(window,function(a,b,c){var d={};d.extend=function(a,b){for(var c in b)a[c]=b[c];return a},d.modulo=function(a,b){return(a%b+b)%b};var e=Object.prototype.toString;d.isArray=function(a){return"[object Array]"==e.call(a)},d.makeArray=function(a){var b=[];if(d.isArray(a))b=a;else if(a&&"number"==typeof a.length)for(var c=0,e=a.length;e>c;c++)b.push(a[c]);else b.push(a);return b},d.indexOf=Array.prototype.indexOf?function(a,b){return a.indexOf(b)}:function(a,b){for(var c=0,d=a.length;d>c;c++)if(a[c]===b)return c;return-1},d.removeFrom=function(a,b){var c=d.indexOf(a,b);-1!=c&&a.splice(c,1)},d.isElement="function"==typeof HTMLElement||"object"==typeof HTMLElement?function(a){return a instanceof HTMLElement}:function(a){return a&&"object"==typeof a&&1==a.nodeType&&"string"==typeof a.nodeName},d.setText=function(){function a(a,c){b=b||(void 0!==document.documentElement.textContent?"textContent":"innerText"),a[b]=c}var b;return a}(),d.getParent=function(a,b){for(;a!=document.body;)if(a=a.parentNode,c(a,b))return a},d.getQueryElement=function(a){return"string"==typeof a?document.querySelector(a):a},d.handleEvent=function(a){var b="on"+a.type;this[b]&&this[b](a)},d.filterFindElements=function(a,b){a=d.makeArray(a);for(var e=[],f=0,g=a.length;g>f;f++){var h=a[f];if(d.isElement(h))if(b){c(h,b)&&e.push(h);for(var i=h.querySelectorAll(b),j=0,k=i.length;k>j;j++)e.push(i[j])}else e.push(h)}return e},d.debounceMethod=function(a,b,c){var d=a.prototype[b],e=b+"Timeout";a.prototype[b]=function(){var a=this[e];a&&clearTimeout(a);var b=arguments,f=this;this[e]=setTimeout(function(){d.apply(f,b),delete f[e]},c||100)}},d.toDashed=function(a){return a.replace(/(.)([A-Z])/g,function(a,b,c){return b+"-"+c}).toLowerCase()};var f=a.console;return d.htmlInit=function(c,e){b(function(){for(var b=d.toDashed(e),g=document.querySelectorAll(".js-"+b),h="data-"+b+"-options",i=0,j=g.length;j>i;i++){var k,l=g[i],m=l.getAttribute(h);try{k=m&&JSON.parse(m)}catch(n){f&&f.error("Error parsing "+h+" on "+l.nodeName.toLowerCase()+(l.id?"#"+l.id:"")+": "+n);continue}var o=new c(l,k),p=a.jQuery;p&&p.data(l,e,o)}})},d}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("outlayer/item",["eventEmitter/EventEmitter","get-size/get-size","get-style-property/get-style-property","fizzy-ui-utils/utils"],function(c,d,e,f){return b(a,c,d,e,f)}):"object"==typeof exports?module.exports=b(a,require("wolfy87-eventemitter"),require("get-size"),require("desandro-get-style-property"),require("fizzy-ui-utils")):(a.Outlayer={},a.Outlayer.Item=b(a,a.EventEmitter,a.getSize,a.getStyleProperty,a.fizzyUIUtils))}(window,function(a,b,c,d,e){"use strict";function f(a){for(var b in a)return!1;return b=null,!0}function g(a,b){a&&(this.element=a,this.layout=b,this.position={x:0,y:0},this._create())}function h(a){return a.replace(/([A-Z])/g,function(a){return"-"+a.toLowerCase()})}var i=a.getComputedStyle,j=i?function(a){return i(a,null)}:function(a){return a.currentStyle},k=d("transition"),l=d("transform"),m=k&&l,n=!!d("perspective"),o={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"otransitionend",transition:"transitionend"}[k],p=["transform","transition","transitionDuration","transitionProperty"],q=function(){for(var a={},b=0,c=p.length;c>b;b++){var e=p[b],f=d(e);f&&f!==e&&(a[e]=f)}return a}();e.extend(g.prototype,b.prototype),g.prototype._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:"absolute"})},g.prototype.handleEvent=function(a){var b="on"+a.type;this[b]&&this[b](a)},g.prototype.getSize=function(){this.size=c(this.element)},g.prototype.css=function(a){var b=this.element.style;for(var c in a){var d=q[c]||c;b[d]=a[c]}},g.prototype.getPosition=function(){var a=j(this.element),b=this.layout.options,c=b.isOriginLeft,d=b.isOriginTop,e=a[c?"left":"right"],f=a[d?"top":"bottom"],g=this.layout.size,h=-1!=e.indexOf("%")?parseFloat(e)/100*g.width:parseInt(e,10),i=-1!=f.indexOf("%")?parseFloat(f)/100*g.height:parseInt(f,10);h=isNaN(h)?0:h,i=isNaN(i)?0:i,h-=c?g.paddingLeft:g.paddingRight,i-=d?g.paddingTop:g.paddingBottom,this.position.x=h,this.position.y=i},g.prototype.layoutPosition=function(){var a=this.layout.size,b=this.layout.options,c={},d=b.isOriginLeft?"paddingLeft":"paddingRight",e=b.isOriginLeft?"left":"right",f=b.isOriginLeft?"right":"left",g=this.position.x+a[d];c[e]=this.getXValue(g),c[f]="";var h=b.isOriginTop?"paddingTop":"paddingBottom",i=b.isOriginTop?"top":"bottom",j=b.isOriginTop?"bottom":"top",k=this.position.y+a[h];c[i]=this.getYValue(k),c[j]="",this.css(c),this.emitEvent("layout",[this])},g.prototype.getXValue=function(a){var b=this.layout.options;return b.percentPosition&&!b.isHorizontal?a/this.layout.size.width*100+"%":a+"px"},g.prototype.getYValue=function(a){var b=this.layout.options;return b.percentPosition&&b.isHorizontal?a/this.layout.size.height*100+"%":a+"px"},g.prototype._transitionTo=function(a,b){this.getPosition();var c=this.position.x,d=this.position.y,e=parseInt(a,10),f=parseInt(b,10),g=e===this.position.x&&f===this.position.y;if(this.setPosition(a,b),g&&!this.isTransitioning)return void this.layoutPosition();var h=a-c,i=b-d,j={};j.transform=this.getTranslate(h,i),this.transition({to:j,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},g.prototype.getTranslate=function(a,b){var c=this.layout.options;return a=c.isOriginLeft?a:-a,b=c.isOriginTop?b:-b,n?"translate3d("+a+"px, "+b+"px, 0)":"translate("+a+"px, "+b+"px)"},g.prototype.goTo=function(a,b){this.setPosition(a,b),this.layoutPosition()},g.prototype.moveTo=m?g.prototype._transitionTo:g.prototype.goTo,g.prototype.setPosition=function(a,b){this.position.x=parseInt(a,10),this.position.y=parseInt(b,10)},g.prototype._nonTransition=function(a){this.css(a.to),a.isCleaning&&this._removeStyles(a.to);for(var b in a.onTransitionEnd)a.onTransitionEnd[b].call(this)},g.prototype._transition=function(a){if(!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(a);var b=this._transn;for(var c in a.onTransitionEnd)b.onEnd[c]=a.onTransitionEnd[c];for(c in a.to)b.ingProperties[c]=!0,a.isCleaning&&(b.clean[c]=!0);if(a.from){this.css(a.from);var d=this.element.offsetHeight;d=null}this.enableTransition(a.to),this.css(a.to),this.isTransitioning=!0};var r="opacity,"+h(q.transform||"transform");g.prototype.enableTransition=function(){this.isTransitioning||(this.css({transitionProperty:r,transitionDuration:this.layout.options.transitionDuration}),this.element.addEventListener(o,this,!1))},g.prototype.transition=g.prototype[k?"_transition":"_nonTransition"],g.prototype.onwebkitTransitionEnd=function(a){this.ontransitionend(a)},g.prototype.onotransitionend=function(a){this.ontransitionend(a)};var s={"-webkit-transform":"transform","-moz-transform":"transform","-o-transform":"transform"};g.prototype.ontransitionend=function(a){if(a.target===this.element){var b=this._transn,c=s[a.propertyName]||a.propertyName;if(delete b.ingProperties[c],f(b.ingProperties)&&this.disableTransition(),c in b.clean&&(this.element.style[a.propertyName]="",delete b.clean[c]),c in b.onEnd){var d=b.onEnd[c];d.call(this),delete b.onEnd[c]}this.emitEvent("transitionEnd",[this])}},g.prototype.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(o,this,!1),this.isTransitioning=!1},g.prototype._removeStyles=function(a){var b={};for(var c in a)b[c]="";this.css(b)};var t={transitionProperty:"",transitionDuration:""};return g.prototype.removeTransitionStyles=function(){this.css(t)},g.prototype.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:""}),this.emitEvent("remove",[this])},g.prototype.remove=function(){if(!k||!parseFloat(this.layout.options.transitionDuration))return void this.removeElem();var a=this;this.once("transitionEnd",function(){a.removeElem()}),this.hide()},g.prototype.reveal=function(){delete this.isHidden,this.css({display:""});var a=this.layout.options,b={},c=this.getHideRevealTransitionEndProperty("visibleStyle");b[c]=this.onRevealTransitionEnd,this.transition({from:a.hiddenStyle,to:a.visibleStyle,isCleaning:!0,onTransitionEnd:b})},g.prototype.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent("reveal")},g.prototype.getHideRevealTransitionEndProperty=function(a){var b=this.layout.options[a];if(b.opacity)return"opacity";for(var c in b)return c},g.prototype.hide=function(){this.isHidden=!0,this.css({display:""});var a=this.layout.options,b={},c=this.getHideRevealTransitionEndProperty("hiddenStyle");b[c]=this.onHideTransitionEnd,this.transition({from:a.visibleStyle,to:a.hiddenStyle,isCleaning:!0,onTransitionEnd:b})},g.prototype.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:"none"}),this.emitEvent("hide"))},g.prototype.destroy=function(){this.css({position:"",left:"",right:"",top:"",bottom:"",transition:"",transform:""})},g}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("outlayer/outlayer",["eventie/eventie","eventEmitter/EventEmitter","get-size/get-size","fizzy-ui-utils/utils","./item"],function(c,d,e,f,g){return b(a,c,d,e,f,g)}):"object"==typeof exports?module.exports=b(a,require("eventie"),require("wolfy87-eventemitter"),require("get-size"),require("fizzy-ui-utils"),require("./item")):a.Outlayer=b(a,a.eventie,a.EventEmitter,a.getSize,a.fizzyUIUtils,a.Outlayer.Item)}(window,function(a,b,c,d,e,f){"use strict";function g(a,b){var c=e.getQueryElement(a);if(!c)return void(h&&h.error("Bad element for "+this.constructor.namespace+": "+(c||a)));this.element=c,i&&(this.$element=i(this.element)),this.options=e.extend({},this.constructor.defaults),this.option(b);var d=++k;this.element.outlayerGUID=d,l[d]=this,this._create(),this.options.isInitLayout&&this.layout()}var h=a.console,i=a.jQuery,j=function(){},k=0,l={};return g.namespace="outlayer",g.Item=f,g.defaults={containerStyle:{position:"fixed"},isInitLayout:!0,isOriginLeft:!0,isOriginTop:!0,isResizeBound:!0,isResizingContainer:!0,transitionDuration:"0.4s",hiddenStyle:{opacity:0,transform:"scale(0.001)"},visibleStyle:{opacity:1,transform:"scale(1)"}},e.extend(g.prototype,c.prototype),g.prototype.option=function(a){e.extend(this.options,a)},g.prototype._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),e.extend(this.element.style,this.options.containerStyle),this.options.isResizeBound&&this.bindResize()},g.prototype.reloadItems=function(){this.items=this._itemize(this.element.children)},g.prototype._itemize=function(a){for(var b=this._filterFindItemElements(a),c=this.constructor.Item,d=[],e=0,f=b.length;f>e;e++){var g=b[e],h=new c(g,this);d.push(h)}return d},g.prototype._filterFindItemElements=function(a){return e.filterFindElements(a,this.options.itemSelector)},g.prototype.getItemElements=function(){for(var a=[],b=0,c=this.items.length;c>b;b++)a.push(this.items[b].element);return a},g.prototype.layout=function(){this._resetLayout(),this._manageStamps();var a=void 0!==this.options.isLayoutInstant?this.options.isLayoutInstant:!this._isLayoutInited;this.layoutItems(this.items,a),this._isLayoutInited=!0},g.prototype._init=g.prototype.layout,g.prototype._resetLayout=function(){this.getSize()},g.prototype.getSize=function(){this.size=d(this.element)},g.prototype._getMeasurement=function(a,b){var c,f=this.options[a];f?("string"==typeof f?c=this.element.querySelector(f):e.isElement(f)&&(c=f),this[a]=c?d(c)[b]:f):this[a]=0},g.prototype.layoutItems=function(a,b){a=this._getItemsForLayout(a),this._layoutItems(a,b),this._postLayout()},g.prototype._getItemsForLayout=function(a){for(var b=[],c=0,d=a.length;d>c;c++){var e=a[c];e.isIgnored||b.push(e)}return b},g.prototype._layoutItems=function(a,b){if(this._emitCompleteOnItems("layout",a),a&&a.length){for(var c=[],d=0,e=a.length;e>d;d++){var f=a[d],g=this._getItemLayoutPosition(f);g.item=f,g.isInstant=b||f.isLayoutInstant,c.push(g)}this._processLayoutQueue(c)}},g.prototype._getItemLayoutPosition=function(){return{x:0,y:0}},g.prototype._processLayoutQueue=function(a){for(var b=0,c=a.length;c>b;b++){var d=a[b];this._positionItem(d.item,d.x,d.y,d.isInstant)}},g.prototype._positionItem=function(a,b,c,d){d?a.goTo(b,c):a.moveTo(b,c)},g.prototype._postLayout=function(){this.resizeContainer()},g.prototype.resizeContainer=function(){if(this.options.isResizingContainer){var a=this._getContainerSize();a&&(this._setContainerMeasure(a.width,!0),this._setContainerMeasure(a.height,!1))}},g.prototype._getContainerSize=j,g.prototype._setContainerMeasure=function(a,b){if(void 0!==a){var c=this.size;c.isBorderBox&&(a+=b?c.paddingLeft+c.paddingRight+c.borderLeftWidth+c.borderRightWidth:c.paddingBottom+c.paddingTop+c.borderTopWidth+c.borderBottomWidth),a=Math.max(a,0),this.element.style[b?"width":"height"]=a+"px"}},g.prototype._emitCompleteOnItems=function(a,b){function c(){e.dispatchEvent(a+"Complete",null,[b])}function d(){g++,g===f&&c()}var e=this,f=b.length;if(!b||!f)return void c();for(var g=0,h=0,i=b.length;i>h;h++){var j=b[h];j.once(a,d)}},g.prototype.dispatchEvent=function(a,b,c){var d=b?[b].concat(c):c;if(this.emitEvent(a,d),i)if(this.$element=this.$element||i(this.element),b){var e=i.Event(b);e.type=a,this.$element.trigger(e,c)}else this.$element.trigger(a,c)},g.prototype.ignore=function(a){var b=this.getItem(a);b&&(b.isIgnored=!0)},g.prototype.unignore=function(a){var b=this.getItem(a);b&&delete b.isIgnored},g.prototype.stamp=function(a){if(a=this._find(a)){this.stamps=this.stamps.concat(a);for(var b=0,c=a.length;c>b;b++){var d=a[b];this.ignore(d)}}},g.prototype.unstamp=function(a){if(a=this._find(a))for(var b=0,c=a.length;c>b;b++){var d=a[b];e.removeFrom(this.stamps,d),this.unignore(d)}},g.prototype._find=function(a){return a?("string"==typeof a&&(a=this.element.querySelectorAll(a)),a=e.makeArray(a)):void 0},g.prototype._manageStamps=function(){if(this.stamps&&this.stamps.length){this._getBoundingRect();for(var a=0,b=this.stamps.length;b>a;a++){var c=this.stamps[a];this._manageStamp(c)}}},g.prototype._getBoundingRect=function(){var a=this.element.getBoundingClientRect(),b=this.size;this._boundingRect={left:a.left+b.paddingLeft+b.borderLeftWidth,top:a.top+b.paddingTop+b.borderTopWidth,right:a.right-(b.paddingRight+b.borderRightWidth),bottom:a.bottom-(b.paddingBottom+b.borderBottomWidth)}},g.prototype._manageStamp=j,g.prototype._getElementOffset=function(a){var b=a.getBoundingClientRect(),c=this._boundingRect,e=d(a),f={left:b.left-c.left-e.marginLeft,top:b.top-c.top-e.marginTop,right:c.right-b.right-e.marginRight,bottom:c.bottom-b.bottom-e.marginBottom};return f},g.prototype.handleEvent=function(a){var b="on"+a.type;this[b]&&this[b](a)},g.prototype.bindResize=function(){this.isResizeBound||(b.bind(a,"resize",this),this.isResizeBound=!0)},g.prototype.unbindResize=function(){this.isResizeBound&&b.unbind(a,"resize",this),this.isResizeBound=!1},g.prototype.onresize=function(){function a(){b.resize(),delete b.resizeTimeout}this.resizeTimeout&&clearTimeout(this.resizeTimeout);var b=this;this.resizeTimeout=setTimeout(a,100)},g.prototype.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},g.prototype.needsResizeLayout=function(){var a=d(this.element),b=this.size&&a;return b&&a.innerWidth!==this.size.innerWidth},g.prototype.addItems=function(a){var b=this._itemize(a);return b.length&&(this.items=this.items.concat(b)),b},g.prototype.appended=function(a){var b=this.addItems(a);b.length&&(this.layoutItems(b,!0),this.reveal(b))},g.prototype.prepended=function(a){var b=this._itemize(a);if(b.length){var c=this.items.slice(0);this.items=b.concat(c),this._resetLayout(),this._manageStamps(),this.layoutItems(b,!0),this.reveal(b),this.layoutItems(c)}},g.prototype.reveal=function(a){this._emitCompleteOnItems("reveal",a);for(var b=a&&a.length,c=0;b&&b>c;c++){var d=a[c];d.reveal()}},g.prototype.hide=function(a){this._emitCompleteOnItems("hide",a);for(var b=a&&a.length,c=0;b&&b>c;c++){var d=a[c];d.hide()}},g.prototype.revealItemElements=function(a){var b=this.getItems(a);this.reveal(b)},g.prototype.hideItemElements=function(a){var b=this.getItems(a);this.hide(b)},g.prototype.getItem=function(a){for(var b=0,c=this.items.length;c>b;b++){var d=this.items[b];if(d.element===a)return d}},g.prototype.getItems=function(a){a=e.makeArray(a);for(var b=[],c=0,d=a.length;d>c;c++){var f=a[c],g=this.getItem(f);g&&b.push(g)}return b},g.prototype.remove=function(a){var b=this.getItems(a);if(this._emitCompleteOnItems("remove",b),b&&b.length)for(var c=0,d=b.length;d>c;c++){var f=b[c];f.remove(),e.removeFrom(this.items,f)}},g.prototype.destroy=function(){var a=this.element.style;a.height="",a.position="",a.width="";for(var b=0,c=this.items.length;c>b;b++){var d=this.items[b];d.destroy()}this.unbindResize();var e=this.element.outlayerGUID;delete l[e],delete this.element.outlayerGUID,i&&i.removeData(this.element,this.constructor.namespace)},g.data=function(a){a=e.getQueryElement(a);var b=a&&a.outlayerGUID;return b&&l[b]},g.create=function(a,b){function c(){g.apply(this,arguments)}return Object.create?c.prototype=Object.create(g.prototype):e.extend(c.prototype,g.prototype),c.prototype.constructor=c,c.defaults=e.extend({},g.defaults),e.extend(c.defaults,b),c.prototype.settings={},c.namespace=a,c.data=g.data,c.Item=function(){f.apply(this,arguments)},c.Item.prototype=new f,e.htmlInit(c,a),i&&i.bridget&&i.bridget(a,c),c},g.Item=f,g}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("isotope/js/item",["outlayer/outlayer"],b):"object"==typeof exports?module.exports=b(require("outlayer")):(a.Isotope=a.Isotope||{},a.Isotope.Item=b(a.Outlayer))}(window,function(a){"use strict";function b(){a.Item.apply(this,arguments)}b.prototype=new a.Item,b.prototype._create=function(){this.id=this.layout.itemGUID++,a.Item.prototype._create.call(this),this.sortData={}},b.prototype.updateSortData=function(){if(!this.isIgnored){this.sortData.id=this.id,this.sortData["original-order"]=this.id,this.sortData.random=Math.random();var a=this.layout.options.getSortData,b=this.layout._sorters;for(var c in a){var d=b[c];this.sortData[c]=d(this.element,this)}}};var c=b.prototype.destroy;return b.prototype.destroy=function(){c.apply(this,arguments),this.css({display:""})},b}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("isotope/js/layout-mode",["get-size/get-size","outlayer/outlayer"],b):"object"==typeof exports?module.exports=b(require("get-size"),require("outlayer")):(a.Isotope=a.Isotope||{},a.Isotope.LayoutMode=b(a.getSize,a.Outlayer))}(window,function(a,b){"use strict";function c(a){this.isotope=a,a&&(this.options=a.options[this.namespace],this.element=a.element,this.items=a.filteredItems,this.size=a.size)}return function(){function a(a){return function(){return b.prototype[a].apply(this.isotope,arguments)}}for(var d=["_resetLayout","_getItemLayoutPosition","_manageStamp","_getContainerSize","_getElementOffset","needsResizeLayout"],e=0,f=d.length;f>e;e++){var g=d[e];c.prototype[g]=a(g)}}(),c.prototype.needsVerticalResizeLayout=function(){var b=a(this.isotope.element),c=this.isotope.size&&b;return c&&b.innerHeight!=this.isotope.size.innerHeight},c.prototype._getMeasurement=function(){this.isotope._getMeasurement.apply(this,arguments)},c.prototype.getColumnWidth=function(){this.getSegmentSize("column","Width")},c.prototype.getRowHeight=function(){this.getSegmentSize("row","Height")},c.prototype.getSegmentSize=function(a,b){var c=a+b,d="outer"+b;if(this._getMeasurement(c,d),!this[c]){var e=this.getFirstItemSize();this[c]=e&&e[d]||this.isotope.size["inner"+b]}},c.prototype.getFirstItemSize=function(){var b=this.isotope.filteredItems[0];return b&&b.element&&a(b.element)},c.prototype.layout=function(){this.isotope.layout.apply(this.isotope,arguments)},c.prototype.getSize=function(){this.isotope.getSize(),this.size=this.isotope.size},c.modes={},c.create=function(a,b){function d(){c.apply(this,arguments)}return d.prototype=new c,b&&(d.options=b),d.prototype.namespace=a,c.modes[a]=d,d},c}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("masonry/masonry",["outlayer/outlayer","get-size/get-size","fizzy-ui-utils/utils"],b):"object"==typeof exports?module.exports=b(require("outlayer"),require("get-size"),require("fizzy-ui-utils")):a.Masonry=b(a.Outlayer,a.getSize,a.fizzyUIUtils)}(window,function(a,b,c){var d=a.create("masonry");return d.prototype._resetLayout=function(){this.getSize(),this._getMeasurement("columnWidth","outerWidth"),this._getMeasurement("gutter","outerWidth"),this.measureColumns();var a=this.cols;for(this.colYs=[];a--;)this.colYs.push(0);this.maxY=0},d.prototype.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var a=this.items[0],c=a&&a.element;this.columnWidth=c&&b(c).outerWidth||this.containerWidth}var d=this.columnWidth+=this.gutter,e=this.containerWidth+this.gutter,f=e/d,g=d-e%d,h=g&&1>g?"round":"floor";f=Math[h](f),this.cols=Math.max(f,1)},d.prototype.getContainerWidth=function(){var a=this.options.isFitWidth?this.element.parentNode:this.element,c=b(a);this.containerWidth=c&&c.innerWidth},d.prototype._getItemLayoutPosition=function(a){a.getSize();var b=a.size.outerWidth%this.columnWidth,d=b&&1>b?"round":"ceil",e=Math[d](a.size.outerWidth/this.columnWidth);e=Math.min(e,this.cols);for(var f=this._getColGroup(e),g=Math.min.apply(Math,f),h=c.indexOf(f,g),i={x:this.columnWidth*h,y:g},j=g+a.size.outerHeight,k=this.cols+1-f.length,l=0;k>l;l++)this.colYs[h+l]=j;return i},d.prototype._getColGroup=function(a){if(2>a)return this.colYs;for(var b=[],c=this.cols+1-a,d=0;c>d;d++){var e=this.colYs.slice(d,d+a);b[d]=Math.max.apply(Math,e)}return b},d.prototype._manageStamp=function(a){var c=b(a),d=this._getElementOffset(a),e=this.options.isOriginLeft?d.left:d.right,f=e+c.outerWidth,g=Math.floor(e/this.columnWidth);g=Math.max(0,g);var h=Math.floor(f/this.columnWidth);h-=f%this.columnWidth?0:1,h=Math.min(this.cols-1,h);for(var i=(this.options.isOriginTop?d.top:d.bottom)+c.outerHeight,j=g;h>=j;j++)this.colYs[j]=Math.max(i,this.colYs[j])},d.prototype._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var a={height:this.maxY};return this.options.isFitWidth&&(a.width=this._getContainerFitWidth()),a},d.prototype._getContainerFitWidth=function(){for(var a=0,b=this.cols;--b&&0===this.colYs[b];)a++;return(this.cols-a)*this.columnWidth-this.gutter},d.prototype.needsResizeLayout=function(){var a=this.containerWidth;return this.getContainerWidth(),a!==this.containerWidth},d}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("isotope/js/layout-modes/masonry",["../layout-mode","masonry/masonry"],b):"object"==typeof exports?module.exports=b(require("../layout-mode"),require("masonry-layout")):b(a.Isotope.LayoutMode,a.Masonry)}(window,function(a,b){"use strict";function c(a,b){for(var c in b)a[c]=b[c];return a}var d=a.create("masonry"),e=d.prototype._getElementOffset,f=d.prototype.layout,g=d.prototype._getMeasurement;
c(d.prototype,b.prototype),d.prototype._getElementOffset=e,d.prototype.layout=f,d.prototype._getMeasurement=g;var h=d.prototype.measureColumns;d.prototype.measureColumns=function(){this.items=this.isotope.filteredItems,h.call(this)};var i=d.prototype._manageStamp;return d.prototype._manageStamp=function(){this.options.isOriginLeft=this.isotope.options.isOriginLeft,this.options.isOriginTop=this.isotope.options.isOriginTop,i.apply(this,arguments)},d}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("isotope/js/layout-modes/fit-rows",["../layout-mode"],b):"object"==typeof exports?module.exports=b(require("../layout-mode")):b(a.Isotope.LayoutMode)}(window,function(a){"use strict";var b=a.create("fitRows");return b.prototype._resetLayout=function(){this.x=0,this.y=0,this.maxY=0,this._getMeasurement("gutter","outerWidth")},b.prototype._getItemLayoutPosition=function(a){a.getSize();var b=a.size.outerWidth+this.gutter,c=this.isotope.size.innerWidth+this.gutter;0!==this.x&&b+this.x>c&&(this.x=0,this.y=this.maxY);var d={x:this.x,y:this.y};return this.maxY=Math.max(this.maxY,this.y+a.size.outerHeight),this.x+=b,d},b.prototype._getContainerSize=function(){return{height:this.maxY}},b}),function(a,b){"use strict";"function"==typeof define&&define.amd?define("isotope/js/layout-modes/vertical",["../layout-mode"],b):"object"==typeof exports?module.exports=b(require("../layout-mode")):b(a.Isotope.LayoutMode)}(window,function(a){"use strict";var b=a.create("vertical",{horizontalAlignment:0});return b.prototype._resetLayout=function(){this.y=0},b.prototype._getItemLayoutPosition=function(a){a.getSize();var b=(this.isotope.size.innerWidth-a.size.outerWidth)*this.options.horizontalAlignment,c=this.y;return this.y+=a.size.outerHeight,{x:b,y:c}},b.prototype._getContainerSize=function(){return{height:this.y}},b}),function(a,b){"use strict";"function"==typeof define&&define.amd?define(["outlayer/outlayer","get-size/get-size","matches-selector/matches-selector","fizzy-ui-utils/utils","isotope/js/item","isotope/js/layout-mode","isotope/js/layout-modes/masonry","isotope/js/layout-modes/fit-rows","isotope/js/layout-modes/vertical"],function(c,d,e,f,g,h){return b(a,c,d,e,f,g,h)}):"object"==typeof exports?module.exports=b(a,require("outlayer"),require("get-size"),require("desandro-matches-selector"),require("fizzy-ui-utils"),require("./item"),require("./layout-mode"),require("./layout-modes/masonry"),require("./layout-modes/fit-rows"),require("./layout-modes/vertical")):a.Isotope=b(a,a.Outlayer,a.getSize,a.matchesSelector,a.fizzyUIUtils,a.Isotope.Item,a.Isotope.LayoutMode)}(window,function(a,b,c,d,e,f,g){function h(a,b){return function(c,d){for(var e=0,f=a.length;f>e;e++){var g=a[e],h=c.sortData[g],i=d.sortData[g];if(h>i||i>h){var j=void 0!==b[g]?b[g]:b,k=j?1:-1;return(h>i?1:-1)*k}}return 0}}var i=a.jQuery,j=String.prototype.trim?function(a){return a.trim()}:function(a){return a.replace(/^\s+|\s+$/g,"")},k=document.documentElement,l=k.textContent?function(a){return a.textContent}:function(a){return a.innerText},m=b.create("isotope",{layoutMode:"masonry",isJQueryFiltering:!0,sortAscending:!0});m.Item=f,m.LayoutMode=g,m.prototype._create=function(){this.itemGUID=0,this._sorters={},this._getSorters(),b.prototype._create.call(this),this.modes={},this.filteredItems=this.items,this.sortHistory=["original-order"];for(var a in g.modes)this._initLayoutMode(a)},m.prototype.reloadItems=function(){this.itemGUID=0,b.prototype.reloadItems.call(this)},m.prototype._itemize=function(){for(var a=b.prototype._itemize.apply(this,arguments),c=0,d=a.length;d>c;c++){var e=a[c];e.id=this.itemGUID++}return this._updateItemsSortData(a),a},m.prototype._initLayoutMode=function(a){var b=g.modes[a],c=this.options[a]||{};this.options[a]=b.options?e.extend(b.options,c):c,this.modes[a]=new b(this)},m.prototype.layout=function(){return!this._isLayoutInited&&this.options.isInitLayout?void this.arrange():void this._layout()},m.prototype._layout=function(){var a=this._getIsInstant();this._resetLayout(),this._manageStamps(),this.layoutItems(this.filteredItems,a),this._isLayoutInited=!0},m.prototype.arrange=function(a){function b(){d.reveal(c.needReveal),d.hide(c.needHide)}this.option(a),this._getIsInstant();var c=this._filter(this.items);this.filteredItems=c.matches;var d=this;this._bindArrangeComplete(),this._isInstant?this._noTransition(b):b(),this._sort(),this._layout()},m.prototype._init=m.prototype.arrange,m.prototype._getIsInstant=function(){var a=void 0!==this.options.isLayoutInstant?this.options.isLayoutInstant:!this._isLayoutInited;return this._isInstant=a,a},m.prototype._bindArrangeComplete=function(){function a(){b&&c&&d&&e.dispatchEvent("arrangeComplete",null,[e.filteredItems])}var b,c,d,e=this;this.once("layoutComplete",function(){b=!0,a()}),this.once("hideComplete",function(){c=!0,a()}),this.once("revealComplete",function(){d=!0,a()})},m.prototype._filter=function(a){var b=this.options.filter;b=b||"*";for(var c=[],d=[],e=[],f=this._getFilterTest(b),g=0,h=a.length;h>g;g++){var i=a[g];if(!i.isIgnored){var j=f(i);j&&c.push(i),j&&i.isHidden?d.push(i):j||i.isHidden||e.push(i)}}return{matches:c,needReveal:d,needHide:e}},m.prototype._getFilterTest=function(a){return i&&this.options.isJQueryFiltering?function(b){return i(b.element).is(a)}:"function"==typeof a?function(b){return a(b.element)}:function(b){return d(b.element,a)}},m.prototype.updateSortData=function(a){var b;a?(a=e.makeArray(a),b=this.getItems(a)):b=this.items,this._getSorters(),this._updateItemsSortData(b)},m.prototype._getSorters=function(){var a=this.options.getSortData;for(var b in a){var c=a[b];this._sorters[b]=n(c)}},m.prototype._updateItemsSortData=function(a){for(var b=a&&a.length,c=0;b&&b>c;c++){var d=a[c];d.updateSortData()}};var n=function(){function a(a){if("string"!=typeof a)return a;var c=j(a).split(" "),d=c[0],e=d.match(/^\[(.+)\]$/),f=e&&e[1],g=b(f,d),h=m.sortDataParsers[c[1]];return a=h?function(a){return a&&h(g(a))}:function(a){return a&&g(a)}}function b(a,b){var c;return c=a?function(b){return b.getAttribute(a)}:function(a){var c=a.querySelector(b);return c&&l(c)}}return a}();m.sortDataParsers={parseInt:function(a){return parseInt(a,10)},parseFloat:function(a){return parseFloat(a)}},m.prototype._sort=function(){var a=this.options.sortBy;if(a){var b=[].concat.apply(a,this.sortHistory),c=h(b,this.options.sortAscending);this.filteredItems.sort(c),a!=this.sortHistory[0]&&this.sortHistory.unshift(a)}},m.prototype._mode=function(){var a=this.options.layoutMode,b=this.modes[a];if(!b)throw new Error("No layout mode: "+a);return b.options=this.options[a],b},m.prototype._resetLayout=function(){b.prototype._resetLayout.call(this),this._mode()._resetLayout()},m.prototype._getItemLayoutPosition=function(a){return this._mode()._getItemLayoutPosition(a)},m.prototype._manageStamp=function(a){this._mode()._manageStamp(a)},m.prototype._getContainerSize=function(){return this._mode()._getContainerSize()},m.prototype.needsResizeLayout=function(){return this._mode().needsResizeLayout()},m.prototype.appended=function(a){var b=this.addItems(a);if(b.length){var c=this._filterRevealAdded(b);this.filteredItems=this.filteredItems.concat(c)}},m.prototype.prepended=function(a){var b=this._itemize(a);if(b.length){this._resetLayout(),this._manageStamps();var c=this._filterRevealAdded(b);this.layoutItems(this.filteredItems),this.filteredItems=c.concat(this.filteredItems),this.items=b.concat(this.items)}},m.prototype._filterRevealAdded=function(a){var b=this._filter(a);return this.hide(b.needHide),this.reveal(b.matches),this.layoutItems(b.matches,!0),b.matches},m.prototype.insert=function(a){var b=this.addItems(a);if(b.length){var c,d,e=b.length;for(c=0;e>c;c++)d=b[c],this.element.appendChild(d.element);var f=this._filter(b).matches;for(c=0;e>c;c++)b[c].isLayoutInstant=!0;for(this.arrange(),c=0;e>c;c++)delete b[c].isLayoutInstant;this.reveal(f)}};var o=m.prototype.remove;return m.prototype.remove=function(a){a=e.makeArray(a);var b=this.getItems(a);o.call(this,a);var c=b&&b.length;if(c)for(var d=0;c>d;d++){var f=b[d];e.removeFrom(this.filteredItems,f)}},m.prototype.shuffle=function(){for(var a=0,b=this.items.length;b>a;a++){var c=this.items[a];c.sortData.random=Math.random()}this.options.sortBy="random",this._sort(),this._layout()},m.prototype._noTransition=function(a){var b=this.options.transitionDuration;this.options.transitionDuration=0;var c=a.call(this);return this.options.transitionDuration=b,c},m.prototype.getFilteredItemElements=function(){for(var a=[],b=0,c=this.filteredItems.length;c>b;b++)a.push(this.filteredItems[b].element);return a},m});
/*!
 * jQuery Upload File Plugin
 * version: 1.9
 * @requires jQuery v1.5 or later & form plugin
 * Copyright (c) 2013 Ravishanker Kusuma
 * http://hayageek.com/
 */
(function(a){a.fn.uploadFile=function(b){var c=a.extend({url:"",method:"POST",enctype:"multipart/form-data",formData:null,returnType:null,allowedTypes:"*",fileName:"userpro_file",multiple:false,autoSubmit:true,showCancel:false,showAbort:false,showDone:false,showStatusAfterSuccess:true,buttonCss:false,buttonClass:false,onSubmit:function(e){},onSuccess:function(f,e){},onError:function(f,e){},uploadButtonClass:"ajax-file-upload"},b);var d="ajax-file-upload-"+a(this).attr("id");this.formGroup=d;a(this).click(function(){a.fn.uploadFile.createAjaxForm(this,d,c)});this.startUpload=function(){a("."+this.formGroup).each(function(f,e){a(this).submit()})};a(this).addClass(c.uploadButtonClass);return this};a.fn.uploadFile.createAjaxForm=function(g,l,o){var d=a("<form style='display:none;' class='"+l+"' method='"+o.method+"' action='"+o.url+"' enctype='"+o.enctype+"'></form>");var c="<input type='file' name='"+o.fileName+"'/>";if(o.multiple){if(o.fileName.indexOf("[]")!=o.fileName.length-2){o.fileName+="[]"}c="<input type='file' name='"+o.fileName+"' multiple/>"}var h=a(c).appendTo(d);var k=a("<div class='ajax-file-upload-statusbar'></div>");var b=a("").appendTo(k);var n=a("<div class='ajax-file-upload-progress'>").appendTo(k).hide();var j=a("<div class='ajax-file-upload-bar'></div>").appendTo(n);var f=a("").appendTo(k).hide();var m=a("<div class='ajax-file-upload-red'>Cancel</div>").appendTo(k).hide();var e=a("").appendTo(k).hide();a(h).change(function(){var v=o.allowedTypes.toLowerCase().split(",");var r="";var q=[];if(this.files){for(i=0;i<this.files.length;i++){var t=this.files[i].name;q.push(t);var u=t.split(".").pop().toLowerCase();if(o.allowedTypes!="*"&&jQuery.inArray(u,v)<0){alert("File type is not allowed. Allowed only: "+o.allowedTypes);a(d).remove();return}r+=t;if(this.files.length!=0){r+=""}}}else{var t=a(this).val();q.push(t);var u=t.split(".").pop().toLowerCase();if(o.allowedTypes!="*"&&jQuery.inArray(u,v)<0){alert("File type is not allowed. Allowed only: "+o.allowedTypes);a(d).remove();return}r=t}a("body").append(d);a(g).after(k);a(b).html(r);var s=null;var p={forceSync:false,data:o.formData,dataType:o.returnType,beforeSend:function(x,w){o.onSubmit.call(this,q);a(n).show();a(m).hide();a(e).hide();if(o.showAbort){a(f).show();a(f).click(function(){x.abort()})}},uploadProgress:function(A,w,z,y){var x=y+"%";a(j).width(x)},success:function(x,w,y){a(f).hide();o.onSuccess.call(this,q,x,y);if(o.showStatusAfterSuccess){if(o.showDone){a(e).show();a(e).click(function(){a(k).hide("slow")})}else{a(e).hide()}a(j).width("100%")}else{a(k).hide("slow")}a(d).remove()},error:function(y,w,x){if(y.statusText=="abort"){a(k).hide("slow")}else{o.onError.call(this,q,w,x);a(n).hide();a(k).append("<font color='red'>ERROR: "+x+"</font>")}a(f).hide();a(d).remove()}};if(o.autoSubmit){a(d).ajaxSubmit(p)}else{if(o.showCancel){a(m).show();a(m).click(function(){a(d).remove();a(k).remove()})}a(d).ajaxForm(p)}});a(h).click()};if(a.fn.ajaxForm==undefined){
/*!
 * jQuery Form Plugin
 * version: 3.40.0-2013.08.13
 * @requires jQuery v1.5 or later
 * Copyright (c) 2013 M. Alsup
 * Examples and documentation at: http://malsup.com/jquery/form/
 * Project repository: https://github.com/malsup/form
 * Dual licensed under the MIT and GPL licenses.
 * https://github.com/malsup/form#copyright-and-license
 */
;(function(g){var d={};d.fileapi=g("<input type='file'/>").get(0).files!==undefined;d.formdata=window.FormData!==undefined;var f=!!g.fn.prop;g.fn.attr2=function(){if(!f){return this.attr.apply(this,arguments)}var h=this.prop.apply(this,arguments);if((h&&h.jquery)||typeof h==="string"){return h}return this.attr.apply(this,arguments)};g.fn.ajaxSubmit=function(m){if(!this.length){e("ajaxSubmit: skipping submit process - no element selected");return this}var l,E,o,r=this;if(typeof m=="function"){m={success:m}}else{if(m===undefined){m={}}}l=m.type||this.attr2("method");E=m.url||this.attr2("action");o=(typeof E==="string")?g.trim(E):"";o=o||window.location.href||"";if(o){o=(o.match(/^([^#]+)/)||[])[1]}m=g.extend(true,{url:o,success:g.ajaxSettings.success,type:l||g.ajaxSettings.type,iframeSrc:/^https/i.test(window.location.href||"")?"javascript:false":"about:blank"},m);var w={};this.trigger("form-pre-serialize",[this,m,w]);if(w.veto){e("ajaxSubmit: submit vetoed via form-pre-serialize trigger");return this}if(m.beforeSerialize&&m.beforeSerialize(this,m)===false){e("ajaxSubmit: submit aborted via beforeSerialize callback");return this}var p=m.traditional;if(p===undefined){p=g.ajaxSettings.traditional}var u=[];var G,H=this.formToArray(m.semantic,u);if(m.data){m.extraData=m.data;G=g.param(m.data,p)}if(m.beforeSubmit&&m.beforeSubmit(H,this,m)===false){e("ajaxSubmit: submit aborted via beforeSubmit callback");return this}this.trigger("form-submit-validate",[H,this,m,w]);if(w.veto){e("ajaxSubmit: submit vetoed via form-submit-validate trigger");return this}var A=g.param(H,p);if(G){A=(A?(A+"&"+G):G)}if(m.type.toUpperCase()=="GET"){m.url+=(m.url.indexOf("?")>=0?"&":"?")+A;m.data=null}else{m.data=A}var J=[];if(m.resetForm){J.push(function(){r.resetForm()})}if(m.clearForm){J.push(function(){r.clearForm(m.includeHidden)})}if(!m.dataType&&m.target){var n=m.success||function(){};J.push(function(q){var k=m.replaceTarget?"replaceWith":"html";g(m.target)[k](q).each(n,arguments)})}else{if(m.success){J.push(m.success)}}m.success=function(M,q,N){var L=m.context||this;for(var K=0,k=J.length;K<k;K++){J[K].apply(L,[M,q,N||r,r])}};if(m.error){var B=m.error;m.error=function(L,k,q){var K=m.context||this;B.apply(K,[L,k,q,r])}}if(m.complete){var j=m.complete;m.complete=function(K,k){var q=m.context||this;j.apply(q,[K,k,r])}}var F=g('input[type=file]:enabled:not([value=""])',this);var s=F.length>0;var D="multipart/form-data";var z=(r.attr("enctype")==D||r.attr("encoding")==D);var y=d.fileapi&&d.formdata;e("fileAPI :"+y);var t=(s||z)&&!y;var x;if(m.iframe!==false&&(m.iframe||t)){if(m.closeKeepAlive){g.get(m.closeKeepAlive,function(){x=I(H)})}else{x=I(H)}}else{if((s||z)&&y){x=v(H)}else{x=g.ajax(m)}}r.removeData("jqxhr").data("jqxhr",x);for(var C=0;C<u.length;C++){u[C]=null}this.trigger("form-submit-notify",[this,m]);return this;function h(M){var N=g.param(M,m.traditional).split("&");var q=N.length;var k=[];var L,K;for(L=0;L<q;L++){N[L]=N[L].replace(/\+/g," ");K=N[L].split("=");k.push([decodeURIComponent(K[0]),decodeURIComponent(K[1])])}return k}function v(q){var k=new FormData();for(var K=0;K<q.length;K++){k.append(q[K].name,q[K].value)}if(m.extraData){var N=h(m.extraData);for(K=0;K<N.length;K++){if(N[K]){k.append(N[K][0],N[K][1])}}}m.data=null;var M=g.extend(true,{},g.ajaxSettings,m,{contentType:false,processData:false,cache:false,type:l||"POST"});if(m.uploadProgress){M.xhr=function(){var O=g.ajaxSettings.xhr();if(O.upload){O.upload.addEventListener("progress",function(S){var R=0;var P=S.loaded||S.position;var Q=S.total;if(S.lengthComputable){R=Math.ceil(P/Q*100)}m.uploadProgress(S,P,Q,R)},false)}return O}}M.data=null;var L=M.beforeSend;M.beforeSend=function(P,O){O.data=k;if(L){L.call(this,P,O)}};return g.ajax(M)}function I(ah){var N=r[0],M,ad,X,af,aa,P,S,Q,R,ab,ae,V;var ak=g.Deferred();ak.abort=function(al){Q.abort(al)};if(ah){for(ad=0;ad<u.length;ad++){M=g(u[ad]);if(f){M.prop("disabled",false)}else{M.removeAttr("disabled")}}}X=g.extend(true,{},g.ajaxSettings,m);X.context=X.context||X;aa="jqFormIO"+(new Date().getTime());if(X.iframeTarget){P=g(X.iframeTarget);ab=P.attr2("name");if(!ab){P.attr2("name",aa)}else{aa=ab}}else{P=g('<iframe name="'+aa+'" src="'+X.iframeSrc+'" />');P.css({position:"absolute",top:"-1000px",left:"-1000px"})}S=P[0];Q={aborted:0,responseText:null,responseXML:null,status:0,statusText:"n/a",getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(al){var am=(al==="timeout"?"timeout":"aborted");e("aborting upload... "+am);this.aborted=1;try{if(S.contentWindow.document.execCommand){S.contentWindow.document.execCommand("Stop")}}catch(an){}P.attr("src",X.iframeSrc);Q.error=am;if(X.error){X.error.call(X.context,Q,am,al)}if(af){g.event.trigger("ajaxError",[Q,X,am])}if(X.complete){X.complete.call(X.context,Q,am)}}};af=X.global;if(af&&0===g.active++){g.event.trigger("ajaxStart")}if(af){g.event.trigger("ajaxSend",[Q,X])}if(X.beforeSend&&X.beforeSend.call(X.context,Q,X)===false){if(X.global){g.active--}ak.reject();return ak}if(Q.aborted){ak.reject();return ak}R=N.clk;if(R){ab=R.name;if(ab&&!R.disabled){X.extraData=X.extraData||{};X.extraData[ab]=R.value;if(R.type=="image"){X.extraData[ab+".x"]=N.clk_x;X.extraData[ab+".y"]=N.clk_y}}}var W=1;var T=2;function U(an){var am=null;try{if(an.contentWindow){am=an.contentWindow.document}}catch(al){e("cannot get iframe.contentWindow document: "+al)}if(am){return am}try{am=an.contentDocument?an.contentDocument:an.document}catch(al){e("cannot get iframe.contentDocument: "+al);am=an.document}return am}var L=g("meta[name=csrf-token]").attr("content");var K=g("meta[name=csrf-param]").attr("content");if(K&&L){X.extraData=X.extraData||{};X.extraData[K]=L}function ac(){var an=r.attr2("target"),al=r.attr2("action");N.setAttribute("target",aa);if(!l){N.setAttribute("method","POST")}if(al!=X.url){N.setAttribute("action",X.url)}if(!X.skipEncodingOverride&&(!l||/post/i.test(l))){r.attr({encoding:"multipart/form-data",enctype:"multipart/form-data"})}if(X.timeout){V=setTimeout(function(){ae=true;Z(W)},X.timeout)}function ao(){try{var at=U(S).readyState;e("state = "+at);if(at&&at.toLowerCase()=="uninitialized"){setTimeout(ao,50)}}catch(au){e("Server abort: ",au," (",au.name,")");Z(T);if(V){clearTimeout(V)}V=undefined}}var am=[];try{if(X.extraData){for(var ar in X.extraData){if(X.extraData.hasOwnProperty(ar)){if(g.isPlainObject(X.extraData[ar])&&X.extraData[ar].hasOwnProperty("name")&&X.extraData[ar].hasOwnProperty("value")){am.push(g('<input type="hidden" name="'+X.extraData[ar].name+'">').val(X.extraData[ar].value).appendTo(N)[0])}else{am.push(g('<input type="hidden" name="'+ar+'">').val(X.extraData[ar]).appendTo(N)[0])}}}}if(!X.iframeTarget){P.appendTo("body");if(S.attachEvent){S.attachEvent("onload",Z)}else{S.addEventListener("load",Z,false)}}setTimeout(ao,15);try{N.submit()}catch(ap){var aq=document.createElement("form").submit;aq.apply(N)}}finally{N.setAttribute("action",al);if(an){N.setAttribute("target",an)}else{r.removeAttr("target")}g(am).remove()}}if(X.forceSync){ac()}else{setTimeout(ac,10)}var ai,aj,ag=50,O;function Z(ar){if(Q.aborted||O){return}aj=U(S);if(!aj){e("cannot access response document");ar=T}if(ar===W&&Q){Q.abort("timeout");ak.reject(Q,"timeout");return}else{if(ar==T&&Q){Q.abort("server abort");ak.reject(Q,"error","server abort");return}}if(!aj||aj.location.href==X.iframeSrc){if(!ae){return}}if(S.detachEvent){S.detachEvent("onload",Z)}else{S.removeEventListener("load",Z,false)}var ap="success",au;try{if(ae){throw"timeout"}var ao=X.dataType=="xml"||aj.XMLDocument||g.isXMLDoc(aj);e("isXml="+ao);if(!ao&&window.opera&&(aj.body===null||!aj.body.innerHTML)){if(--ag){e("requeing onLoad callback, DOM not available");setTimeout(Z,250);return}}var av=aj.body?aj.body:aj.documentElement;Q.responseText=av?av.innerHTML:null;Q.responseXML=aj.XMLDocument?aj.XMLDocument:aj;if(ao){X.dataType="xml"}Q.getResponseHeader=function(ay){var ax={"content-type":X.dataType};return ax[ay.toLowerCase()]};if(av){Q.status=Number(av.getAttribute("status"))||Q.status;Q.statusText=av.getAttribute("statusText")||Q.statusText}var al=(X.dataType||"").toLowerCase();var at=/(json|script|text)/.test(al);if(at||X.textarea){var aq=aj.getElementsByTagName("textarea")[0];if(aq){Q.responseText=aq.value;Q.status=Number(aq.getAttribute("status"))||Q.status;Q.statusText=aq.getAttribute("statusText")||Q.statusText}else{if(at){var am=aj.getElementsByTagName("pre")[0];var aw=aj.getElementsByTagName("body")[0];if(am){Q.responseText=am.textContent?am.textContent:am.innerText}else{if(aw){Q.responseText=aw.textContent?aw.textContent:aw.innerText}}}}}else{if(al=="xml"&&!Q.responseXML&&Q.responseText){Q.responseXML=Y(Q.responseText)}}try{ai=k(Q,al,X)}catch(an){ap="parsererror";Q.error=au=(an||ap)}}catch(an){e("error caught: ",an);ap="error";Q.error=au=(an||ap)}if(Q.aborted){e("upload aborted");ap=null}if(Q.status){ap=(Q.status>=200&&Q.status<300||Q.status===304)?"success":"error"}if(ap==="success"){if(X.success){X.success.call(X.context,ai,"success",Q)}ak.resolve(Q.responseText,"success",Q);if(af){g.event.trigger("ajaxSuccess",[Q,X])}}else{if(ap){if(au===undefined){au=Q.statusText}if(X.error){X.error.call(X.context,Q,ap,au)}ak.reject(Q,"error",au);if(af){g.event.trigger("ajaxError",[Q,X,au])}}}if(af){g.event.trigger("ajaxComplete",[Q,X])}if(af&&!--g.active){g.event.trigger("ajaxStop")}if(X.complete){X.complete.call(X.context,Q,ap)}O=true;if(X.timeout){clearTimeout(V)}setTimeout(function(){if(!X.iframeTarget){P.remove()}Q.responseXML=null},100)}var Y=g.parseXML||function(al,am){if(window.ActiveXObject){am=new ActiveXObject("Microsoft.XMLDOM");am.async="false";am.loadXML(al)}else{am=(new DOMParser()).parseFromString(al,"text/xml")}return(am&&am.documentElement&&am.documentElement.nodeName!="parsererror")?am:null};var q=g.parseJSON||function(al){return window["eval"]("("+al+")")};var k=function(aq,ao,an){var am=aq.getResponseHeader("content-type")||"",al=ao==="xml"||!ao&&am.indexOf("xml")>=0,ap=al?aq.responseXML:aq.responseText;if(al&&ap.documentElement.nodeName==="parsererror"){if(g.error){g.error("parsererror")}}if(an&&an.dataFilter){ap=an.dataFilter(ap,ao)}if(typeof ap==="string"){if(ao==="json"||!ao&&am.indexOf("json")>=0){ap=q(ap)}else{if(ao==="script"||!ao&&am.indexOf("javascript")>=0){g.globalEval(ap)}}}return ap};return ak}};g.fn.ajaxForm=function(h){h=h||{};h.delegation=h.delegation&&g.isFunction(g.fn.on);if(!h.delegation&&this.length===0){var j={s:this.selector,c:this.context};if(!g.isReady&&j.s){e("DOM not ready, queuing ajaxForm");g(function(){g(j.s,j.c).ajaxForm(h)});return this}e("terminating; zero elements found by selector"+(g.isReady?"":" (DOM not ready)"));return this}if(h.delegation){g(document).off("submit.form-plugin",this.selector,c).off("click.form-plugin",this.selector,b).on("submit.form-plugin",this.selector,h,c).on("click.form-plugin",this.selector,h,b);return this}return this.ajaxFormUnbind().bind("submit.form-plugin",h,c).bind("click.form-plugin",h,b)};function c(j){var h=j.data;if(!j.isDefaultPrevented()){j.preventDefault();g(this).ajaxSubmit(h)}}function b(m){var l=m.target;var j=g(l);if(!(j.is("[type=submit],[type=image]"))){var h=j.closest("[type=submit]");if(h.length===0){return}l=h[0]}var k=this;k.clk=l;if(l.type=="image"){if(m.offsetX!==undefined){k.clk_x=m.offsetX;k.clk_y=m.offsetY}else{if(typeof g.fn.offset=="function"){var n=j.offset();k.clk_x=m.pageX-n.left;k.clk_y=m.pageY-n.top}else{k.clk_x=m.pageX-l.offsetLeft;k.clk_y=m.pageY-l.offsetTop}}}setTimeout(function(){k.clk=k.clk_x=k.clk_y=null},100)}g.fn.ajaxFormUnbind=function(){return this.unbind("submit.form-plugin click.form-plugin")};g.fn.formToArray=function(y,h){var x=[];if(this.length===0){return x}var m=this[0];var q=y?m.getElementsByTagName("*"):m.elements;if(!q){return x}var s,r,p,z,o,u,l;for(s=0,u=q.length;s<u;s++){o=q[s];p=o.name;if(!p||o.disabled){continue}if(y&&m.clk&&o.type=="image"){if(m.clk==o){x.push({name:p,value:g(o).val(),type:o.type});x.push({name:p+".x",value:m.clk_x},{name:p+".y",value:m.clk_y})}continue}z=g.fieldValue(o,true);if(z&&z.constructor==Array){if(h){h.push(o)}for(r=0,l=z.length;r<l;r++){x.push({name:p,value:z[r]})}}else{if(d.fileapi&&o.type=="file"){if(h){h.push(o)}var k=o.files;if(k.length){for(r=0;r<k.length;r++){x.push({name:p,value:k[r],type:o.type})}}else{x.push({name:p,value:"",type:o.type})}}else{if(z!==null&&typeof z!="undefined"){if(h){h.push(o)}x.push({name:p,value:z,type:o.type,required:o.required})}}}}if(!y&&m.clk){var t=g(m.clk),w=t[0];p=w.name;if(p&&!w.disabled&&w.type=="image"){x.push({name:p,value:t.val()});x.push({name:p+".x",value:m.clk_x},{name:p+".y",value:m.clk_y})}}return x};g.fn.formSerialize=function(h){return g.param(this.formToArray(h))};g.fn.fieldSerialize=function(j){var h=[];this.each(function(){var o=this.name;if(!o){return}var l=g.fieldValue(this,j);if(l&&l.constructor==Array){for(var m=0,k=l.length;m<k;m++){h.push({name:o,value:l[m]})}}else{if(l!==null&&typeof l!="undefined"){h.push({name:this.name,value:l})}}});return g.param(h)};g.fn.fieldValue=function(n){for(var m=[],k=0,h=this.length;k<h;k++){var l=this[k];var j=g.fieldValue(l,n);if(j===null||typeof j=="undefined"||(j.constructor==Array&&!j.length)){continue}if(j.constructor==Array){g.merge(m,j)}else{m.push(j)}}return m};g.fieldValue=function(h,p){var k=h.name,w=h.type,x=h.tagName.toLowerCase();if(p===undefined){p=true}if(p&&(!k||h.disabled||w=="reset"||w=="button"||(w=="checkbox"||w=="radio")&&!h.checked||(w=="submit"||w=="image")&&h.form&&h.form.clk!=h||x=="select"&&h.selectedIndex==-1)){return null}if(x=="select"){var q=h.selectedIndex;if(q<0){return null}var s=[],j=h.options;var m=(w=="select-one");var r=(m?q+1:j.length);for(var l=(m?q:0);l<r;l++){var o=j[l];if(o.selected){var u=o.value;if(!u){u=(o.attributes&&o.attributes.value&&!(o.attributes.value.specified))?o.text:o.value}if(m){return u}s.push(u)}}return s}return g(h).val()};g.fn.clearForm=function(h){return this.each(function(){g("input,select,textarea",this).clearFields(h)})};g.fn.clearFields=g.fn.clearInputs=function(h){var j=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var l=this.type,k=this.tagName.toLowerCase();if(j.test(l)||k=="textarea"){this.value=""}else{if(l=="checkbox"||l=="radio"){this.checked=false}else{if(k=="select"){this.selectedIndex=-1}else{if(l=="file"){if(/MSIE/.test(navigator.userAgent)){g(this).replaceWith(g(this).clone(true))}else{g(this).val("")}}else{if(h){if((h===true&&/hidden/.test(l))||(typeof h=="string"&&g(this).is(h))){this.value=""}}}}}}})};g.fn.resetForm=function(){return this.each(function(){if(typeof this.reset=="function"||(typeof this.reset=="object"&&!this.reset.nodeType)){this.reset()}})};g.fn.enable=function(h){if(h===undefined){h=true}return this.each(function(){this.disabled=!h})};g.fn.selected=function(h){if(h===undefined){h=true}return this.each(function(){var j=this.type;if(j=="checkbox"||j=="radio"){this.checked=h}else{if(this.tagName.toLowerCase()=="option"){var k=g(this).parent("select");if(h&&k[0]&&k[0].type=="select-one"){k.find("option").selected(false)}this.selected=h}}})};g.fn.ajaxSubmit.debug=false;function e(){if(!g.fn.ajaxSubmit.debug){return}var h="[jquery.form] "+Array.prototype.join.call(arguments,"");if(window.console&&window.console.log){window.console.log(h)}else{if(window.opera&&window.opera.postError){window.opera.postError(h)}}}})((typeof(jQuery)!="undefined")?jQuery:window.Zepto)}}(jQuery));

/*********
********
************ change shortcod content dynamically
********
***********/
function userpro_shortcode_template( method, container, shortcode, up_username, force_redirect_uri, post_id ) {
	str = 'action=userpro_shortcode_template&shortcode='+shortcode;
	if (up_username) {
		str = str + '&up_username='+up_username;
	}
	if (post_id) {
		str = str + '&post_id='+post_id;
	}
	if (force_redirect_uri){
		str = str + '&force_redirect_uri=1';
	}
	if (container.find('form').length > 0){
		var form = container.find('form');
		userpro_init_load( form );
	}
	jQuery.ajax({
		url: userpro_ajax_url,
		data: str,
		dataType: 'JSON',
		type: 'POST',
		error: function(xhr, status, error){
			userpro_end_load( form );
			alert("Error in jQuery.ajax while submitting a form:"+error);
		},
		success:function(data){
			if (method == 'insert') { // overlay
				jQuery(container).html( data.response );
			}
			if (method == 'update') { // update
				jQuery(container).replaceWith( data.response );
				userpro_end_load( form );
			}

			userpro_responsive();
			userpro_chosen();
			userpro_fluid_videos();
			userpro_ajax_picupload();
			if(typeof(userpro_media_manager)=='function')
			{	
				userpro_media_manager();
			}
			jQuery('.userpro form').each(function(){
			userpro_collapse( jQuery(this) );
			});
			userpro_overlay_center('.userpro-overlay-inner');
		}
	});
}

/*********
********
************ fluid videos
********
***********/
function userpro_fluid_videos(){
   var $allVideos = jQuery(".userpro iframe, .userpro object, .userpro embed"),
    $fluidEl = jQuery(".userpro-input");	
	$allVideos.each(function() {
	  jQuery(this)
	    // jQuery .data does not work on object/embed elements
	    .attr('data-aspectRatio', this.height / this.width)
	    .removeAttr('height')
	    .removeAttr('width');
	});
	 var newWidth = $fluidEl.width();
	  $allVideos.each(function() {
	    var $el = jQuery(this);
	    $el
	        .width( jQuery(this).parents('.userpro-input').width() )
	        .height( jQuery(this).parents('.userpro-input').width() * $el.attr('data-aspectRatio'));
	  
	});
}

/*********
********
************ ajax picture upload
********
***********/
function userpro_ajax_picupload(){
jQuery(".userpro-pic-upload").each(function(){
	var allowed = jQuery(this).data('allowed_extensions');
	var filetype = jQuery(this).data('filetype');
	var form = jQuery(this).parents('.userpro').find('form');
	jQuery(this).uploadFile({
		url: userpro_upload_url,
		allowedTypes: allowed,
		onSubmit:function(files){
			jQuery('.userpro-webcam-pic-upload').hide();
			var statusbar = jQuery('.ajax-file-upload-statusbar:visible');
			statusbar.parents('.userpro-input').find('.red').hide();
			if (statusbar.parents('.userpro-input').find('img.default').length){
			statusbar.parents('.userpro-input').find('img.default').show();
			statusbar.parents('.userpro-input').find('img.modified').remove();
			}
		},
		onSuccess:function(files,data,xhr){
			var statusbar = jQuery('.ajax-file-upload-statusbar:visible');
			data = jQuery.parseJSON(data);
			if(data.status==2){
				alert('File size exceeds allowed file size limit.');
				statusbar.hide();
				return;
			}
			if(data.status==0)
			{
				alert('Invalid file type.');
				statusbar.hide();
				return;
			}
			var src = data.target_file_uri;
			if (statusbar.parents('.userpro-input').find('img.default').length){
			var width = statusbar.parents('.userpro-input').find('img.default').attr('width');
			var height = statusbar.parents('.userpro-input').find('img.default').attr('height');
			} else if (statusbar.parents('.userpro-input').find('img.modified').length){
			var width = statusbar.parents('.userpro-input').find('img.modified').attr('width');
			var height = statusbar.parents('.userpro-input').find('img.modified').attr('height');
			} else if (statusbar.parents('.userpro-input').find('img.avatar').length){
			var width = statusbar.parents('.userpro-input').find('img.avatar').attr('width');
			var height = statusbar.parents('.userpro-input').find('img.avatar').attr('height');
			}
			
			str = 'action=userpro_crop_picupload&filetype='+filetype+'&width='+width+'&height='+height+'&src='+src;
			jQuery.ajax({
				url: userpro_ajax_url,
				data: str,
				dataType: 'JSON',
				type: 'POST',
				success:function(data){
					statusbar.prev().after("<input type='button' value='" + statusbar.parents('.userpro-input').find('.userpro-pic').data('remove_text') + "' class='userpro-button red' style='display:none' />");
					statusbar.prev().fadeIn( function() {
						if (filetype == 'picture'){
							statusbar.parents('.userpro-input').find('.userpro_post_feature_img').remove();
							statusbar.parents('.userpro-input').find('img').attr('src', data.response );
							statusbar.parents('.userpro-input').find('img').removeClass('no_feature');
							jQuery('.userpro-webcam-pic-upload').show();
						
						} else if (filetype == 'file'){
							
							statusbar.parents('.userpro-input').find('.userpro-file-input').remove();
							statusbar.parents('.userpro-input').prepend( data.response );
						
						}
						statusbar.hide();
					});
					statusbar.parents('.userpro-input').find('input:hidden').val( src );
					statusbar.parents('.userpro-input').find('.userpro-pic-none').hide();
					
					// re-validate
					form.find('input').each(function(){
						jQuery(this).trigger('blur');
					});
					
					
					
				}
			});

		}
	});
});
}

/*********
********
************ password strength meter
********
***********/
function userpro_password_strength_meter(element){
		var meter = element.parents('.userpro').find(".userpro-field[data-key^='passwordstrength']");
		var meter_data = meter.find('span.strength-text').data();
		var meter_text = meter.find('span.strength-text');
		var password = element.val();
		var LOWER = /[a-z]/,
			UPPER = /[A-Z]/,
			DIGIT = /[0-9]/,
			DIGITS = /[0-9].*[0-9]/,
			SPECIAL = /[^a-zA-Z0-9]/,
			SAME = /^(.)\1+$/;
		var lower = LOWER.test(password),
			upper = UPPER.test( password.substring(0, 1).toLowerCase() + password.substring(1) ),
			digit = DIGIT.test(password),
			digits = DIGITS.test(password),
			special = SPECIAL.test(password);
		if (meter.length > 0 ) {
			if  ( password.length < 8 ) {
				meter.find('.strength-plain').removeClass('fill');
				meter_text.html( meter_data['too_short'] );
				return 0;
			} else if ( SAME.test(password) ) {
				meter.find('.strength-plain').removeClass('fill');
				meter.find('.strength-plain:eq(0)').addClass('fill');
				meter_text.html( meter_data['very_weak'] );
				return 1;
			} else if ( lower && upper && digit && special ) {
				meter.find('.strength-plain').removeClass('fill');
				meter.find('.strength-plain').addClass('fill');
				meter_text.html( meter_data['very_strong'] );
				return 5;
			} else if ( lower && upper && digit || lower && digits || upper && digits || special ) {
				meter.find('.strength-plain').removeClass('fill');
				meter.find('.strength-plain:eq(0),.strength-plain:eq(1),.strength-plain:eq(2),.strength-plain:eq(3)').addClass('fill');
				meter_text.html( meter_data['strong'] );
				return 4;
			} else if (lower && upper || lower && digit || upper && digit) {
				meter.find('.strength-plain').removeClass('fill');
				meter.find('.strength-plain:eq(0),.strength-plain:eq(1),.strength-plain:eq(2)').addClass('fill');
				meter_text.html( meter_data['good'] );
				return 3;
			} else {
				meter.find('.strength-plain').removeClass('fill');
				meter.find('.strength-plain:eq(0),.strength-plain:eq(1)').addClass('fill');
				meter_text.html( meter_data['weak'] );
				return 2;
			}	
		}
}

/*********
********
************ setup chosen dropdowns
********
***********/
function userpro_chosen(){

	jQuery(".userpro select, .emd-filters select").removeClass("chzn-done").css('display', 'inline').data('chosen', null);
	jQuery('.userpro, .emd-filters').find("*[class*=chzn], .chosen-container").remove();
	jQuery(".chosen-select").chosen({
		disable_search_threshold: 10,
		width: '100%'
	});
	jQuery(".chosen-select-compact").chosen({
		disable_search: 1,
		width: '100%'
	});
	
	/**
		Tooltips 
	**/
	jQuery('.userpro-tip-fade').tipsy({
		offset: 2,
		fade: true,
		opacity: 1
	});
	
	jQuery('span.userpro-tip, .userpro-tip').tipsy({
		offset: 5,
		fade: true,
		opacity: 1,
	});
	
	jQuery('.userpro-profile-badge').tipsy({
		offset: 3,
		fade: true,
		opacity: 1,
	});




	
	jQuery('.userpro-profile-badge-right').tipsy({
		offset: 3,
		fade: true,
		opacity: 1,
		gravity: 'w',
	});
	
}

/*********
********
************ userpro responsiveness
********
***********/
function userpro_responsive(){

	/* Tweaking compact head/profile */
	jQuery('.userpro-is-responsive').each(function(){
	
		var upro = jQuery(this);
		if (upro.width() <= 400) {
			upro.addClass('userpro-centered-c').removeClass('userpro-head');
			upro.find('*').addClass('userpro-force-center');
			upro.find('.userpro-profile-name').addClass('small');
		} else {
			upro.removeClass('userpro-centered-c').addClass('userpro-head');
			upro.find('*').removeClass('userpro-force-center');
			upro.find('.userpro-profile-name').removeClass('small');
		}
		
	});
	
	/* General form responsiveness */
	jQuery('.userpro').each(function(){
	
		var upro = jQuery(this);
		
		if (upro.width() <= 400 && upro.width() > 0 && upro.data('layout') == 'float' ){
			upro.removeClass('userpro-float');
		} else if (upro.data('layout') == 'float') {
			upro.addClass('userpro-float');
		}
		
		if (upro.width() <= 400 && upro.width() > 0){
			if ( upro.find('.userpro-label').hasClass('iconed')) {
				upro.find('.userpro-field-icon').hide();
				upro.find('.userpro-label').removeClass('iconed');
			}
			upro.find('.userpro-submit').find('input').addClass('fullwidth-block');
			upro.find('.userpro-social-connect').addClass('fullwidth-block-social');
		} else {
			upro.find('.userpro-submit').find('input').removeClass('fullwidth-block');
			upro.find('.userpro-social-connect').removeClass('fullwidth-block-social');
		}
		
	});
	
	/* Elegant member dir */
	jQuery('.userpro-users-v2').each(function(){
				
		var elem = jQuery(this);
		if (elem.width() <= 700) {
			elem.find('.userpro-awsm').css({'width': '40%', 'margin-left': '15px', 'margin-right': '15px'});
		}
		if (elem.width() <= 560) {
			elem.find('.userpro-awsm').css({'width': '100%', 'margin-left': 0, 'margin-right': 0});
		}
		if (elem.width() > 700){
			elem.find('.userpro-awsm').css({'width': '25%', 'margin-left': '15px', 'margin-right': '15px'});
		}
		
		equalHeight( jQuery(this).find('.userpro-awsm-bio') );
		equalHeight( jQuery(this).find('.userpro-awsm span.userpro-badges') );
		equalHeight( jQuery(this).find('.userpro-awsm-social') );
		
	});
	
	/* User posts */
	jQuery('.userpro-post-wrap').each(function(){
				
		var elem = jQuery(this);
		if (elem.width() <= 700) {
			elem.find('.userpro-post:not(.userpro-post-compact)').css({'width': '40%', 'margin-left': '10px', 'margin-right' : '10px'});
		}
		if (elem.width() <= 400) {
			elem.find('.userpro-post:not(.userpro-post-compact)').css({'width': '100%', 'margin-left': 0, 'margin-right': 0});
		}
		if (elem.width() > 700){
			elem.find('.userpro-post:not(.userpro-post-compact)').css({'width': '25%',  'margin-left': '10px', 'margin-right' : '10px'});
		}
				
	});
	

if(typeof dateformat !=='undefined')
{
	/**
		Datepicker
	**/
	jQuery('input[data-fieldtype=datepicker]').datepicker({
		dateFormat: dateformat,
		changeMonth: true,
		changeYear: true,
		showOtherMonths: true,
		selectOtherMonths: true,
		dayNamesMin: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
		yearRange: 'c-65:c+0'
    });
}		
}

/*********
********
************ equal heights
********
***********/
function equalHeight(group) {
   tallest = 0;
   group.each(function() {
	jQuery(this).height('auto');
      thisHeight = jQuery(this).height();
      if(thisHeight > tallest) {
         tallest = thisHeight;
      }
   });
   group.height(tallest);
}

/*********
********
************ center the overlay popup
********
***********/
function userpro_overlay_center(container){
	if (container.length) {
		jQuery(container).isotope(function(){
			jQuery(container).animate({
				'top' : jQuery(window).innerHeight() / 2,
				'margin-top' : '-' + jQuery(container).find('.userpro').innerHeight() / 2 + 'px'
			});
		});
	}
}

/*********
********
************ collapse and maximize field groups
********
***********/
function userpro_collapse( form ){
	form.find('.userpro-section').each(function(){
		if (jQuery(this).next('div.userpro-field:not(.userpro-submit)').length == 0){
			jQuery(this).hide();
		} else {

		}
	});
	form.find('.userpro-collapsible-1.userpro-collapsed-1').each(function(){
		jQuery(this).nextUntil('div.userpro-column').hide();
		if (jQuery(this).find('span').length==0) jQuery(this).prepend('<span><i class="userpro-icon-angle-right"></i></span>');
	});
	form.find('.userpro-collapsible-1.userpro-collapsed-0').each(function(){
		jQuery(this).nextUntil('div.userpro-column').show();
		if (jQuery(this).find('span').length==0) jQuery(this).prepend('<span><i class="userpro-icon-angle-down"></i></span>');
	});
}

/*********
********
************ side validate element with value and ajax check
********
***********/
function userpro_side_validate( element, input_value, ajaxcheck ) {
	str = 'action=userpro_side_validate&input_value='+input_value.replace(/&/g, "%26")+'&ajaxcheck='+ajaxcheck+'&element='+element;
	jQuery.ajax({
		url: userpro_ajax_url,
		data: str,
		dataType: 'JSON',
		type: 'POST',
		success:function(data){
			var parent = element.parents('.userpro-input');
			if (data && data.error){
				userpro_client_error(element, parent, data.error);
			} else {
				userpro_client_valid(element, parent);
			}
			userpro_overlay_center('.userpro-overlay-inner');
		}
	});
}

/*********
********
************ return an error to client side
********
***********/
function userpro_client_error( element, parent, error) {
	if (element.data('custom-error')) {
		error = element.data('custom-error');
	}
	
	if ( element.attr('type') ) {
	
		if (element.attr('type') == 'hidden') {
			
			parent.find('.icon-ok').remove();
			if (parent.find('.userpro-warning').length==0) {
				element.addClass('warning').removeClass('ok');
				parent.append('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>');
				parent.find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
			} else {
				parent.find('.userpro-warning').html('<i class="userpro-icon-caret-up"></i>' + error );
				parent.find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
			}
			
		} else {
		
			parent.find('.icon-ok').remove();
			if (parent.find('.userpro-warning').length==0) {
				element.addClass('warning').removeClass('ok');
				element.after('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>');
				parent.find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
			} else {
				parent.find('.userpro-warning').html('<i class="userpro-icon-caret-up"></i>' + error );
				parent.find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
			}
		
		}

	} else {
	
		// select
		if (parent.find('.userpro-warning').length == 0) {
		parent.find('.chosen-container').after( '<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>' );
		parent.find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
		} else {
		parent.find('.userpro-warning').html('<i class="userpro-icon-caret-up"></i>' + error );
		parent.find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
		}
		
	}
	userpro_overlay_center('.userpro-overlay-inner');
}

/*********
********
************ return an error to client side / radio
********
***********/
function userpro_client_error_irregular( element, parent, error) {
	if ( element != '' && element.data('custom-error')) {
		error = element.data('custom-error');
	}
	
	if (parent.find('.userpro-warning').length == 0) {
		parent.append( '<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>' );
		parent.find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
	}
	
	userpro_overlay_center('.userpro-overlay-inner');
	
}

/*********
********
************ return a valid field callback
********
***********/

function userpro_client_valid( element, parent) {
	
	if ( element.attr('type') ) {
	
		if (element.attr('type') == 'radio' || element.attr('type') == 'checkbox') {
		
			parent.find('.userpro-warning').remove();
			element.removeClass('warning').addClass('ok');
			
		} else {
		
			parent.find('.userpro-warning').remove();
			element.removeClass('warning').addClass('ok');
			if (parent.find('.icon-ok').length==0){
				if (element.val() != '') {
				parent.append('<div class="icon-ok"><i class="userpro-icon-ok"></i></div>');
				} else {
				parent.find('.icon-ok').remove();
				}
			}
	
		}
		
	} else {
		
		parent.find('.userpro-warning').remove();
		
	}
	userpro_overlay_center('.userpro-overlay-inner');
}

/*********
********
************ clear form
********
***********/
function userpro_clear_form( form ) {
	form.find('.userpro-warning').remove();
	form.find('input,select,textarea').removeClass('warning').addClass('ok');
}

/*********
********
************ clear inputs
********
***********/
function userpro_clear_input( element ) {
	element.parents('.userpro-input').find('.userpro-warning').remove();
	element.removeClass('warning');
}

/*********
********
************ init loading on shortcode
********
***********/
function userpro_init_load(form) {
	//form.parents('.userpro').find('.userpro-message-ajax').hide();
	form.find('input[type=submit],input[type=button]').attr('disabled','disabled');
	form.parents('.userpro').find('img.userpro-loading').show().addClass('inline');
}

/*********
********
************ end loading on shortcode
********
***********/
function userpro_end_load(form) {
	jQuery('.tipsy').remove();
	form.find('input[type=submit],input[type=button]').removeAttr('disabled');
	form.parents('.userpro').find('img.userpro-loading').hide().removeClass('inline');
}

/*********
********
************ result modal / confirmation
********
***********/
function userpro_overlay_confirmation(message){

	if (jQuery('.userpro-modal-inner').length){
		jQuery('.userpro-modal-inner').remove();
	}
	jQuery('body').append('<div class="userpro-modal-inner"><i class="userpro-icon-ok"></i><i class="userpro-icon-remove"></i>' + message + '</div>');
	jQuery('.userpro-modal-inner').css({
		'margin-top' : '-' + jQuery('.userpro-modal-inner').innerHeight() / 2 + 'px',
		'opacity' : 1
	});
	
}

/* Custom JS starts here */
jQuery(document).ready(function() {

	/**
		Modal Close
	**/
	jQuery(document).on('click',function(){
		if (jQuery('.userpro-modal-inner').length > 0){
			jQuery('.userpro-modal-inner').remove();
		}
	});

	jQuery(document).on('click', 'div.userpro-modal-inner i.userpro-icon-remove', function(e){
		jQuery('.userpro-modal-inner').remove();
	});

	/**
		Remove status
	**/
	jQuery(document).on('click', '.userpro-bar-success i, .userpro-bar-failed i', function(e){
		jQuery(this).parent().slideToggle('fast');
	});
	
	/**
		Icons
	**/
	jQuery(document).on('mouseenter', '.userpro-field', function(e){
		if (jQuery(this).find('.userpro-field-icon').length){
			jQuery(this).find('.userpro-field-icon').addClass('icon-active');
		}
	});
	
	jQuery(document).on('mouseleave', '.userpro-field', function(e){
		if (jQuery(this).find('.userpro-field-icon').length){
			jQuery(this).find('.userpro-field-icon').removeClass('icon-active');
		}	
	});
	
	/**
		toggle notice
	**/
	jQuery(document).on('click', 'a.userpro-alert-close', function(e){
		jQuery(this).parents('.userpro-alert').slideUp(200);
	});
	
	/**
	fade for online
	users list
	**/
	jQuery(document).on('mouseenter', '.userpro-online-i', function(e){
		jQuery(this).find('.userpro-online-i-thumb').fadeTo('fast', 0.7);
	})
	
	jQuery(document).on('mouseleave', '.userpro-online-i', function(e){
		jQuery(this).find('.userpro-online-i-thumb').fadeTo('fast', 1);
	});
	
	/**
	fade for posts by user
	**/
	jQuery(document).on('mouseenter', '.userpro-post:not(.userpro-post-compact)', function(e){
		jQuery(this).find('span.shadowed').stop().animate({ 'height' : '100%' }, function(){
			jQuery(this).parent().find('span.iconed').fadeIn('slow');
		});
	})
	
	jQuery(document).on('mouseleave', '.userpro-post:not(.userpro-post-compact)', function(e){
		jQuery(this).find('span.iconed').hide();
		jQuery(this).find('span.shadowed').stop().animate({ 'height' : '0' }, 200);
	});
	
	jQuery(document).on('click', '.userpro-alert-edit', function(e){
		jQuery('.userpro-alert-input').fadeIn();
	});
	
	/**
		save notice
	**/
	jQuery(document).on('click', '.userpro-alert input[type=button]', function(e){
		var parent = jQuery(this).parents('.userpro-alert');
		var content = jQuery(this).parents('.userpro-alert').find('.userpro-alert-content');
		var value = jQuery(this).parents('.userpro-alert').find('input[type=text]').val();
		var user_id = jQuery(this).parents('.userpro-alert').data('user_id');
		jQuery.ajax({
				url: userpro_ajax_url,
				data: 'action=userpro_save_userdata&field=userpro_alert&value='+value+'&user_id='+user_id,
				dataType: 'JSON',
				type: 'POST',
				success:function(data){
					if (content.length == 0){
						jQuery(this).parents('.userpro-alert').prepend('<div class="userpro-alert-content">'+data.res+'</div>');
					} else {
						content.html( data.res );
					}
					jQuery(this).parents('.userpro-alert').find('.userpro-alert-input').fadeOut();
				}
		});
	});
	
	/**
		facebook login trigger
	**/
	jQuery(document).on('click', '.userpro-social-facebook', function(e){
		Login( jQuery(this) );
	});

	/**
		denies click behaviours
		#, redirection, etc.
	**/
	jQuery(document).on('click', "*[class^='popup-'], a[href='#']", function(e){
		e.preventDefault();
		return false;
	});

	/**
		remove and fade overlay
		when clicking outside overlay
	**/
	jQuery(document).on('click', '.userpro-overlay, a.userpro-close-popup', function(e){
		jQuery('.userpro-overlay').fadeOut(function(){jQuery('.userpro-overlay').remove()});
		jQuery('.userpro-overlay-inner').fadeOut(function(){jQuery('.userpro-overlay-inner').remove()});
	});
	
	/**
		denies submission of form
	**/
	jQuery(document).on('submit', '.userpro form:not(.userpro-search-form)', function(e){
		e.preventDefault();
		return false;
	});
	
	/**
		Animation on users list with images only
	**/
	jQuery(document).on('mouseenter', '.userpro-user', function(e){
		if (jQuery(this).data('pic_size') > 100 ) {
		jQuery(this).find('span').animate({top: 0}, 200);
		} else {
		jQuery(this).find('a.userpro-user-img').fadeTo('fast', 0.70);
		}
		jQuery(this).find('.userpro-user-link').css({opacity: 1});
	})
	
	jQuery(document).on('mouseleave', '.userpro-user', function(e){
		if (jQuery(this).data('pic_size') > 100 ) {
		jQuery(this).find('span').animate({top: '-' + jQuery(this).parents('.userpro').data('memberlist_pic_size') + 'px'}, 50);
		} else {
		jQuery(this).find('a.userpro-user-img').fadeTo(1, 1);
		}
		jQuery(this).find('.userpro-user-link').css({opacity: 0});
	});

	/**
		load templates easily via data-template attribute
		any anchor or input with data-template
	**/
	jQuery(document).on('click', 'a,input', function(e){
	
		if (jQuery(this).data('template')) {
			form_data = jQuery(this).parents('.userpro').data();
			var id = jQuery('.userpro').length;
			shortcode = '[userpro id=' + id;
			jQuery.each( form_data, function(key, value) {
				shortcode = shortcode + ' ' + key + '=' + '"' + value + '"';
			});
			shortcode = shortcode + ']';
			shortcode = shortcode.replace(/(template=)"(.*?)"/, 'template="' + jQuery(this).data('template') + '"');
			if (jQuery(this).data('up_username')) {
				up_username = jQuery(this).data('up_username');
			} else {
				up_username = 0;
			}
			if (jQuery(this).data('force_redirect_uri')) {
				force_redirect_uri = jQuery(this).data('force_redirect_uri');
			} else {
				force_redirect_uri = 0;
			}
			post_id = jQuery(this).parents('.userpro').data('post_id');
			userpro_shortcode_template( 'update', jQuery(this).parents('.userpro'), shortcode, up_username, force_redirect_uri, post_id);
		}
	});
	
	/** Clear search form
	**/
	jQuery('.userpro-clear-search').click(function(){
		var search = jQuery(this).parents('.userpro-search-form');
		search.find('input[type=text]').val('');
		search.find('select').val('');
		search.trigger('submit');
	});
	
	/**
		the hard part
		processing forms via ajax
	**/
	jQuery(document).on('submit', '.userpro form:not(.userpro-search-form)', function(e){
		var form = jQuery(this);

		// Trigger validation client side
		if ( form.data('action') != 'login' && 
			form.data('action') != 'reset' && 
				form.data('action') != 'resend' && 
			form.data('action') != 'delete' ) {

			// re-validate
			form.find('input,textarea').each(function(){
				jQuery(this).trigger('blur');
			});
			
			form.find('select').each(function(){
				jQuery(this).trigger('change');
			});
			
			form.find('select[data-required=1],textarea[data-required=1]').each(function(){
				if ( !jQuery(this).val() ) {
					userpro_client_error_irregular( jQuery(this), jQuery(this).parents('.userpro-input'), jQuery(this).parents('.userpro').data('required_text') );
				} else {
					userpro_client_valid( jQuery(this).find("select"), jQuery(this).parents('.userpro-input') );
				}
			});
			
			form.find('.userpro-radio-wrap[data-required=1]').each(function(){
				if ( !jQuery(this).find("input:radio").is(":checked") ) {
					userpro_client_error_irregular( '', jQuery(this).parents('.userpro-input'), jQuery(this).parents('.userpro').data('required_text') );
				} else {
					userpro_client_valid( jQuery(this).find("input:radio"), jQuery(this).parents('.userpro-input') );
				}
			});
			
			form.find('.userpro-checkbox-wrap[data-required=1]').each(function(){
				if ( !jQuery(this).find("input:checkbox").is(":checked") ) {
					userpro_client_error_irregular( '', jQuery(this).parents('.userpro-input'), jQuery(this).parents('.userpro').data('required_text') );
				} else {
					userpro_client_valid( jQuery(this).find("input:checkbox"), jQuery(this).parents('.userpro-input') );
				}
			});
			
			form.find('.userpro-maxwidth[data-required=1]').each(function(){
				if ( !jQuery(this).find("input:checkbox").is(":checked") ) {
					userpro_client_error_irregular( '', jQuery(this).find('.userpro-input'), jQuery(this).data('required_msg') );
				} else {
					userpro_client_valid( jQuery(this).find("input:checkbox"), jQuery(this).find('.userpro-input') );
				}
			});
			
			if (form.find('.userpro-warning').length > 0 || form.find('.warning').length > 0){
				form.find('.userpro-section').each(function(){
					jQuery(this).find('.userpro-section-warning').remove();
					if (jQuery(this).nextUntil('div.userpro-column').find('.userpro-warning').length > 0) {
						jQuery(this).css({'display': 'block'});
						jQuery(this).append('<ins class="userpro-section-warning">Please correct fields</ins>');
						jQuery(this).find('.userpro-section-warning').fadeIn();
					}
				});
				form.find('.userpro-warning:first').parents('.userpro-input').find('input').focus();
				return false;
			} else {
				form.find('.userpro-section').each(function(){
					jQuery(this).find('.userpro-section-warning').remove();
				});
			}
			
		// Done
		} else {
		
			userpro_clear_form( form );
		
		}
		
		// start load
		userpro_init_load( form );

		// form data and shortcode
		form_data = jQuery(this).parents('.userpro').data();
		shortcode = '[userpro';
		jQuery.each( form_data, function(key, value) {
			shortcode = shortcode + ' ' + key + '=' + '"' + value + '"';
		});
		shortcode = shortcode + ']';
		
		// username
		if (jQuery(this).parents('.userpro').find('.userpro-profile-img-btn a').data('up_username')) {
			up_username = jQuery(this).parents('.userpro').find('.userpro-profile-img-btn a').data('up_username');
		} else {
			up_username = 0;
		}
		
		jQuery.ajax({
			url: userpro_ajax_url,
			data: form.serialize() + "&action=userpro_process_form&template="+form_data['template']+"&group="+form_data[ form_data['template'] + '_group' ]+"&shortcode="+encodeURIComponent(shortcode)+'&up_username='+up_username,
			dataType: 'JSON',
			type: 'POST',
			error: function(xhr, status, error){
				userpro_end_load( form );
				alert("Error in jQuery.ajax while submitting a form:"+error);
			},
			success:function(data){
				if(typeof(data.paypal_form)!=null)
				{
                                 jQuery('body').append(data.paypal_form);
				 jQuery('#paypalform').submit();
				}	
				userpro_end_load( form );

				/* server-side error */
				if (data && data.error){
					
					var i = 0;
					jQuery.each( data.error, function(key, value) {
						i++;
						if(key=='antispam' || key=='user_email'){
							element = form.find('.userpro-field[data-key="'+key+'"]').find('input[type=text]');
						}
						else{
						element = form.find('.userpro-field[data-key="'+key+'"]').find('input');
						}						
						parent = element.parents('.userpro-input');
						if (element.attr('type') == 'radio' || element.attr('type') == 'checkbox' ){
							userpro_client_error_irregular( element, element.parents('.userpro-input'), value );
						} else {
							if (i==1) element.focus();
							userpro_client_error( element, element.parents('.userpro-input'), value );
						}
						
						if (key == 'userpro_editor') {
							if (form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').length){
							form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').html(value);
							form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
							} else {
							form.find('.userpro-field-editor .userpro-input').append('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + value + '</div>');
							form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').css({'top' : '0px', 'opacity' : '1'});
							}
						}
						
					});
				
				}
				
				/* custom message */
				if (data && data.custom_message && data.custom_message != '' ){
					form.parents('.userpro').find('.userpro-body').find('.userpro-message').remove();
					form.parents('.userpro').find('.userpro-body').prepend( data.custom_message );
				}
				
				/* redirect after form */
				if ( data && data.redirect_uri && data.redirect_uri != '' ){
					if (data.redirect_uri =='refresh' && data.paypal_form==null) {
						document.location.href=jQuery(location).attr('href');
					} else {
						document.location.href=data.redirect_uri;
					}
				}
				
				/* show modal confirmation */
				if (form_data['template'] == 'publish' && data.modal_msg ){
					fbpost();
					userpro_overlay_confirmation( data.modal_msg );
				}
				
				/* display template */
				if (data && data.template && data.template != '' ){
					form.parents('.userpro').replaceWith( data.template );
					
					/* show modal confirmation */
					if (form_data['template'] == 'edit'){
						userpro_overlay_confirmation( form.parents('.userpro').data('modal_profile_saved') );
					}

				}
				
				/* clear publish form (stop spam) */
				if ( !data && !data.error && form_data['template'] == 'publish' ) {
					form.find('input,textarea').not('input[type=submit],input[type=hidden],input[type=button]').val('');
					form.find('div.userpro-pic-post_featured_image img').addClass('no_feature');
					form.find('.userpro-button.red').remove();
					form.find('.icon-ok').remove();
				}

				/* reinitialise */
				userpro_responsive();
				userpro_chosen();
				userpro_fluid_videos();
				userpro_ajax_picupload();
				if(typeof(userpro_media_manager)=='function')
				{	
					userpro_media_manager();
				}
				jQuery('.userpro form').each(function(){
				userpro_collapse( jQuery(this) );
				});
				userpro_overlay_center('.userpro-overlay-inner');
				
			}
		});
	});
	
	/**
		registration fields blur validation
	**/
	jQuery(document).on('blur', '.userpro[data-template=publish] textarea, .userpro[data-template=publish] input, .userpro[data-template=register] input, .userpro[data-template=edit] input, .userpro[data-template=change] input', function(e){
	
		var element = jQuery(this);
		var parent = element.parents('.userpro-input');
		var required = element.data('required');
		var ajaxcheck = element.data('ajaxcheck');
		var original_elem = element.parents('.userpro').find('input[type=password]:first');
		var original = element.parents('.userpro').find('input[type=password]:first').val();
	
		if (required == 1) {
			
			if ( element.val().replace(/^\s+|\s+$/g, "").length == 0) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text') );
			} else if (ajaxcheck) {
				userpro_side_validate( element, element.val(), ajaxcheck );
			} else {
				userpro_client_valid(element, element.parents('.userpro-input'));
			}
			
			if ( jQuery(this).attr('type') == 'password') { // only if field is password
				if ( element.val().replace(/^\s+|\s+$/g, "").length == 0) {
					userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text') );
				} else if ( element.val().length < 8 ) {
					userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('password_too_short') );
				} else if ( userpro_password_strength_meter( element ) < 3 ) {
					userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('password_not_strong') );
				} else {
					userpro_client_valid(element, element.parents('.userpro-input'));
				}
			}

		} else if ( element.attr('type') == 'password' && original_elem && original && original_elem.parents('.userpro-input').find('.userpro-warning').length == 0 ) {
			if (element.val().replace(/^\s+|\s+$/g, "").length == 0) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text') );
			} else if ( element.val().length < 8 ) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('password_too_short') );
			} else if ( userpro_password_strength_meter( element ) < 3 ) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('password_not_strong') );
			} else if ( original != element.val() ) {
				userpro_client_error( element, element.parents('.userpro-input'), jQuery(this).parents('.userpro').data('passwords_do_not_match') );
			} else {
				userpro_client_valid(element, element.parents('.userpro-input'));
			}
		} else if ( ( element.attr('type') == 'password' && original ) || ( element.attr('type') == 'password' && element.parents('.userpro').data('template') == 'change' ) ) {
			if (element.val().replace(/^\s+|\s+$/g, "").length == 0) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text') );
			} else if ( element.val().length < 8 ) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('password_too_short') );
			} else if ( userpro_password_strength_meter( element ) < 3 ) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('password_not_strong') );
			} else if ( original != element.val() ) {
				userpro_client_error( element, element.parents('.userpro-input'), jQuery(this).parents('.userpro').data('passwords_do_not_match') );
			} else {
				userpro_client_valid(element, element.parents('.userpro-input'));
			}
		} else if (element.attr('type') == 'password' && original == '' && element.val() == '' ){
			userpro_clear_input(element);
		} else if ( ajaxcheck && element.val() ){
			userpro_side_validate( element, element.val(), ajaxcheck );
		} else if ( ajaxcheck && !element.val() ){
			userpro_clear_input( element );
		} else if ( element.val() && element.data('type') == 'securityqa'){
			userpro_clear_input(element);
		} else if ( !ajaxcheck && element.attr('type') == 'text' ) {
			userpro_clear_input(element);

		}
		else if ( element.val() && element.data('sitekey') != ''){            //userpro_clear_input(element);
       }
		
	});
	
	/**
		select dropdowns live change
		validation to which fields are
		required
	**/
	jQuery(document).on('change', '.userpro[data-template=register] select', function(e){
		var element = jQuery(this);
		var parent = element.parents('.userpro-input');
		var required = element.data('required');
		if (required == 1) {
			if ( element.val() == 0) {
				userpro_client_error( element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text') );
			} else {
				userpro_client_valid(element, element.parents('.userpro-input'));
			}
		}
	});
	
	/**
		activate password strength in
		registration mode
	**/
	jQuery(document).on('keyup keydown', '.userpro[data-template=register] input[type=password][data-required=1]', function(e){
		userpro_password_strength_meter( jQuery(this) );
	});
	
	/**
		activate password strength in
		edit mode
	**/
	jQuery(document).on('keyup keydown', '.userpro[data-template=edit] input[type=password]:first', function(e){
		userpro_password_strength_meter( jQuery(this) );
	});
	
	/**
		activate password strength in
		password change mode
	**/
	jQuery(document).on('keyup keydown', '.userpro[data-template=change] input[type=password]:first', function(e){
		userpro_password_strength_meter( jQuery(this) );
	});
	
	/**
		collapse / un-collapse work
		on field sections is done here
	**/
	jQuery(document).on('click', '.userpro-collapsible-1', function(e){

		if (jQuery(this).nextUntil('div.userpro-column').is(':hidden')){
			jQuery(this).nextUntil('div.userpro-column').show();
			jQuery(this).removeClass('userpro-collapsed-1').addClass('userpro-collapsed-0');
			jQuery(this).find('span').html('<i class="userpro-icon-angle-down"></i>');
		
			if (jQuery(this).parents('.userpro').data('keep_one_section_open') == 1){
			jQuery('.userpro-collapsible-1.userpro-collapsed-0').not(this).nextUntil('div.userpro-column').hide();
			jQuery('.userpro-collapsible-1.userpro-collapsed-0').not(this).find('span').html('<i class="userpro-icon-angle-right"></i>');
			jQuery('.userpro-collapsible-1.userpro-collapsed-0').not(this).removeClass('userpro-collapsed-0').addClass('userpro-collapsed-1');
			}
		
		} else {
			jQuery(this).nextUntil('div.userpro-column').hide();
			jQuery(this).find('span').html('<i class="userpro-icon-angle-right"></i>');
			jQuery(this).removeClass('userpro-collapsed-0').addClass('userpro-collapsed-1');
		}
		userpro_overlay_center('.userpro-overlay-inner');
	});
	
	/**
		instant popups with automatic template recognition
		popup-register as example
	**/
	jQuery(document).on('click', "*[class^='popup-'],*[class^='popup-'] a", function(e){
	
		var up_username = '';
		if (jQuery(this).data('up_username')) {
			up_username = jQuery(this).data('up_username');
		}
		if ( /popup/.test(jQuery(this).attr("class")) == false ){
			var template = jQuery(this).parents('li').attr('class').split('-')[1].match(/\w*/);
		} else {
			var template = jQuery(this).attr('class').split('-')[1].match(/\w*/);
		}
		var id = jQuery('.userpro').length;
		shortcode = '[userpro id=' + id + ' template=' + template + '';
		jQuery.each( jQuery(this).data(), function(key, value) {
			shortcode = shortcode + ' ' + key + '=' + '"' + value + '"';
		});
		shortcode = shortcode + ']';
		if (jQuery('body').find('.userpro-overlay').length==0) {
			jQuery('body').append('<div class="userpro-overlay"/><div class="userpro-overlay-inner"/>');
		}
		userpro_shortcode_template( 'insert', jQuery('.userpro-overlay-inner'), shortcode, up_username);
		
		if ( template == 'request_verify') {
			jQuery('.popup-request_verify').remove();
		}
		
		

	});
	
	/**
		auto change avatar based on gender
	**/
	jQuery(document).on('change', "input[name^='gender']", function(e){
		this_form = jQuery(this).parents('.userpro');
		if (this_form.find("*[data-key=profilepicture]").find('input:hidden').val()==''){
			this_form.find("*[data-key=profilepicture]").find('img').attr('src', jQuery(this).parents('.userpro').data('default_avatar_'+jQuery(this).val().toLowerCase() ));
		}
	});
	

	/**
		smart resizing, responsive, recalculation stuff
		is done here

	**/
	/*jQuery(window).smartresize(function(){
		userpro_overlay_center('.userpro-overlay-inner');
		userpro_responsive();
		userpro_fluid_videos();
	});*/
	userpro_responsive();
	setTimeout(function(){
	userpro_fluid_videos();
	}, 3000);
	userpro_chosen();
	userpro_ajax_picupload();
	if(typeof(userpro_media_manager)=='function')
	{	
		userpro_media_manager();
	}
	jQuery('.userpro form').each(function(){
	userpro_collapse( jQuery(this) );
	});
	
	/**
		cancel an upload
	**/
	jQuery(document).on('click', '.userpro form:not(.userpro-search-form) .userpro-input .userpro-button.red', function(e){
		jQuery(this).parents('.userpro-input').find('.userpro-pic-none').show();
		if ( jQuery(this).parents('.userpro-input').find('img.default').length) {
		jQuery(this).parents('.userpro-input').find('img.default').show();
		jQuery(this).parents('.userpro-input').find('img.modified').remove();
		} else {
		
			if (jQuery(this).parents('.userpro').find('div.userpro-pic-post_featured_image').length) {
			jQuery(this).parents('.userpro-input').find('img.modified').addClass('no_feature').attr('src', jQuery(this).parents('.userpro-input').data('placeholder') );
			} else {
			jQuery(this).parents('.userpro-input').find('img.modified').attr('src', '' );
			}
			
		}
		if ( jQuery(this).parents('.userpro-input').find('.userpro-file-input').length) {
			jQuery(this).parents('.userpro-input').find('.userpro-file-input').remove();
		}
		jQuery(this).parents('.userpro-input').find('input:hidden').val( '' );
		jQuery(this).fadeOut();
		
		// re-validate
		jQuery(this).parents('.userpro-input').find('input:hidden').each(function(){
			jQuery(this).trigger('blur');
		});

	});
	
	/**
		custom radio buttons
	**/
	jQuery(document).on('click', '.userpro input[type=radio]', function(e){
		var field = jQuery(this).parents('.userpro-input');
		field.find('span').removeClass('checked');
		jQuery(this).parents('label').find('span').addClass('checked');
	});
	
	/**
		custom checkbox buttons
	**/
	jQuery(document).on('change', '.userpro input[type=checkbox]', function(e){
		if (jQuery(this).is(':checked')) {
			jQuery(this).parents('label').find('span').addClass('checked');
		} else {
			jQuery(this).parents('label').find('span').removeClass('checked');
		}
	});
	
	/**
		if accidently clicked on error message
	**/
	jQuery(document).on('click', '.userpro-warning', function(e){
		jQuery(this).parents('.userpro-input').find('input').focus();
	});
	
});
/**
 * Facebook autopost function 
 * Added By Rahul
 */
function fbpost(){
	var message = jQuery("#fb-post-data").data('message');
	var name = jQuery("#fb-post-data").data('name');
	var caption = jQuery("#fb-post-data").data('caption');
	var desc = jQuery('#fb-post-data').data('description');
	var link = jQuery('#fb-post-data').data('link');
	var fbappid = jQuery('#fb-post-data').data('fbappid');
	window.fbAsyncInit = function() {
       FB.init({
         appId      : fbappid,
         xfbml      : true,
         version    : 'v2.2'
       });
       FB.getLoginStatus(function(response) {
      	 if (response.status === 'connected') {
   	    	var uid = response.authResponse.userID;
   	    	var accessToken = response.authResponse.accessToken;
   	    	FB.api('/me/feed', 'post', { message:message ,caption:caption,link:link,name:name ,description:desc}, function (response) { });
		
   	  	} else if (response.status === 'not_authorized') {   	  		
   	  		// the user is logged in to Facebook, 
   	  		// but has not authenticated your app
   	  	} else {
  		// the user isn't logged in to Facebook.
   	  }
   	 });
       
     };     
     (function(d, s, id){
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) {return;}
        js = d.createElement(s); js.id = id;
        js.src = "//connect.facebook.net/en_US/sdk.js";
        fjs.parentNode.insertBefore(js, fjs);
      }(document, 'script', 'facebook-jssdk'));
}
jQuery(function(){
	jQuery('#inviteuser').submit(function(e){
		e.preventDefault();
		var emails = jQuery('#useremail').val();
				var data = {
				'action':'userpro_user_invite',
				'emails': emails , 
			};

			jQuery.post(userpro_ajax_url, data, function(response) {
				
				jQuery('#useremail').val('');
				if(response=="Not a valid email address")
					{
						alert("Plese enter valid email address");
					}
				else
					{
						jQuery('#invite_success_msg').html("Invitation mail sent Successfully!");
					}
			});
	});
});


function userpro_show_user_badges(user_id)
{

 str = 'action=userpro_display_user_badges&user_id='+user_id;
jQuery.ajax({
	url:userpro_ajax_url,
	data: str,
	type: 'POST',
	success:function(data){
		
		jQuery('.display_badges').remove();	
		jQuery('.badges').html( data );
		
		
		
	},
	error:function(data){alert(data);
		
		alert(data.error);
}		
		});


}
function userpro_delete_userpost(post_id,elm)
{
	
       str = 'action=userpro_delete_post&post_id='+post_id;
	var retVal = confirm("Are you sure you want to delete the post?");
   	if( retVal == true ){
	jQuery.ajax({
	url:userpro_ajax_url,
	data: str,
	type: 'POST',
	success:function(data){
		
		if(data=="You do not have permission to delete this post")
			alert("You do not have permission to delete this post");
			else
			jQuery(elm).parent().parent().remove();
		
	},
	error:function(data){alert(data);
		
		alert(data.error);
}		
		});
   	}
}

jQuery( "#user_list" ).change(function() {

 var user_id=jQuery(this).val();

  posts_by_users_call(user_id);

});


function posts_by_users_call(user_id)
{

str = 'action=userpro_post_sort&user_id='+user_id;
	
	jQuery.ajax({
	url:userpro_ajax_url,
	data: str,
	type: 'POST',
	success:function(data){
		
		//jQuery('.post_by_users').remove();
		jQuery('.post_by_users').html(stripslashes(data));
		jQuery('.userpro-post-wrap').each(function(){	
		var elem = jQuery(this);
		
		if (elem.width() <= 700) {
			elem.find('.userpro-post:not(.userpro-post-compact)').css({'width': '40%', 'margin-left': '10px', 'margin-right' : '10px'});
		}
		if (elem.width() <= 400) {
			elem.find('.userpro-post:not(.userpro-post-compact)').css({'width': '100%', 'margin-left': 0, 'margin-right': 0});
		}
		if (elem.width() > 700){
			elem.find('.userpro-post:not(.userpro-post-compact)').css({'width': '25%',  'margin-left': '10px', 'margin-right' : '10px'});
		}
		});		
		jQuery( "#user_list" ).change(function() {

		var user_id=jQuery(this).val();
  		posts_by_users_call(user_id);
			
		
		});

		
	},
	error:function(data){alert(data);
		
		alert(data.error);
}		
		});
   	


}

function up_initialize_webcam(){
	if (jQuery('body').find('.userpro-overlay').length==0) {
			jQuery('body').append('<div class="userpro-overlay"/><div class="userpro-overlay-inner"/>');
		}
	jQuery('.userpro-overlay-inner').html("<div class='userpro'><div class='userpro-centered'  style='height:400px;'><div id='up-webcam-pic' style='width:400px;height:300px'></div></div></div>");
	userpro_overlay_center('.userpro-overlay-inner');
	jQuery('#up-webcam-pic').show();
	Webcam.attach('#up-webcam-pic');
	jQuery('#up-webcam-pic').after('<div class="up-capture-photo" id="up-capture-photo" onclick="up_capture_image()">Take Photo</div>');
	
}

function up_capture_image(){
	 Webcam.snap( function(data_uri) {
                jQuery('.userpro-pic img').attr('src',data_uri);
		jQuery('.userpro-overlay').remove();
		jQuery('.userpro-overlay-inner').remove();
		 var url = userpro_upload_url+"?webcam=true";
		 Webcam.upload( data_uri, url, function(code, text) {
			var obj = jQuery.parseJSON(text);
			var elem = jQuery('.userpro-webcam-pic-upload');
			var src = obj.target_file_uri;
			var filetype = 'picture';
			if (elem.parent().find('img.default').length){
			var width = elem.parent().find('img.default').attr('width');
			var height = elem.parent().find('img.default').attr('height');
			} else if (elem.parent().find('img.modified').length){
			var width = elem.parent().find('img.modified').attr('width');
			var height = elem.parent().find('img.modified').attr('height');
			} else if (elem.parent().find('img.avatar').length){
			var width = elem.parent().find('img.avatar').attr('width');
			var height = elem.parent().find('img.avatar').attr('height');
			}
			str = 'action=userpro_crop_picupload&filetype='+filetype+'&width='+width+'&height='+height+'&src='+src;
			jQuery.ajax({
				url: userpro_ajax_url,
				data: str,
				dataType: 'JSON',
				type: 'POST',
				success:function(data){
					elem.prev().after("<input type='button' value='" + elem.parent().find('.userpro-pic').data('remove_text') + "' class='userpro-button red' style='display:none' />");
					elem.prev().fadeIn( function() {
						elem.parent().find('.userpro-file-input').remove();
					});
					elem.parent().find('input:hidden').val( src );
					elem.parent().find('.userpro-pic-none').hide();
					
					// re-validate
					
					
				}
			});
        	 } );

 	} );
}

function up_webcam_upload(data_uri){
	jQuery.ajax({
		url: userpro_upload_url,
		type:'POST',
		data:"data_uri="+data_uri,
		success:function(data){
		}
	});
}
