/**
 * 
 * ClientEngage UberPanel for WordPress (http://www.clientengage.com)
 * Copyright 2014, ClientEngage (http://www.clientengage.com)
 *
 * You must have purchased a valid license from CodeCanyon in order to have 
 * the permission to use this file.
 * 
 * You may only use this file according to the respective licensing terms 
 * you agreed to when purchasing this item on CodeCanyon.
 * 
 * All PHP code utilising WordPress features is licensed as GPL version 2 or 
 * later. External libraries placed in the "vendors"-directory are subject to
 * their respective licensing terms (take note of their licenses).
 *  
 * However, other ClientEngage assets such as JavaScript code, 
 * CSS styles and images are not licensed as GPL version 2 or later and you are 
 * required to abide by the CodeCanyon Regular License. 
 * 
 *
 * @author          ClientEngage <contact@clientengage.com>
 * @copyright       Copyright 2014, ClientEngage (http://www.clientengage.com)
 * @link            http://www.clientengage.com ClientEngage
 * @since           ClientEngage UberPanel for WordPress v 1.0
 * @license         CodeCanyon Regular License
 * 
 */
 (function ($) {
    $(function () {
        $("#ce_uberpanel").prependTo("body");
        $("#ce_uberpanel_side").prependTo("body");
        $(".ce_uberpanel_container").fadeIn();
        $(".ce_uberpanel-toggle").click(function (e) {
            e.preventDefault();
            if ($(this).parents("[data-uberpanel-pos=top]").length === 0) {
                return;
            }
            var doOpen = $(this).find(".toggle-plus").is(":visible");
            if (doOpen) {
                $(this).find(".toggle-plus").hide();
                $(this).find(".toggle-minus").show();
                $("#ce_uberpanel .ce_uberpanel-content_wrapper").slideDown("fast", function () {
                    panelOpen();
                });
                $("#ce_uberpanel").addClass("panel_open");
                fadePanelIn();
            } else {
                $(this).find(".toggle-plus").show();
                $(this).find(".toggle-minus").hide();
                $("#ce_uberpanel .ce_uberpanel-content_wrapper").slideUp("fast", function () {
                    panelClosed();
                });
                $("#ce_uberpanel").removeClass("panel_open");
                fadePanelOut();
            }
        });
        $(document).ready(function () {
            if (!supports3D()) {
                $("[data-uberpanel-pos=left], [data-uberpanel-pos=right]").each(function () {
                    $(this).css("width", $(this).attr("data-uberpanel-width")).css("left", parseInt($(this).attr("data-uberpanel-width")) * -1);
                });
            }
        });
        var originalCss = null;
        $(".ce_uberpanel-toggle").click(function (e) {
            if (!supports3D()) {
                return;
            }
            e.preventDefault();
            if ($(this).parents("[data-uberpanel-pos=left], [data-uberpanel-pos=right]").length === 0) {
                return;
            }
            var isLeft = $(this).parents("[data-uberpanel-pos=left]").length !== 0;
            var width = isLeft ? $(this).parents("[data-uberpanel-pos]").attr("data-uberpanel-width") : $(this).parents("[data-uberpanel-pos]").attr("data-uberpanel-width") * -1;
            $(this).parents("[data-uberpanel-pos]").find(".ce_uberpanel_side-content").css("width", $(this).parents("[data-uberpanel-pos]").attr("data-uberpanel-width"));
            var doOpen = $(this).find(".toggle-plus").is(":visible");
            if (doOpen) {
                $(this).find(".toggle-plus").hide();
                $(this).find(".toggle-minus").show();
                originalCss = $("body").attr("style");
                $("body").addClass("ce_animate_500").css("transform", "translate3d(" + width + "px, 0, 0)").css("-webkit-transform", "translate3d(" + width + "px, 0, 0)").css("-moz-transform", "translate3d(" + width + "px, 0, 0)").css("-ms-transform", "translate3d(" + width + "px, 0, 0)").css("-o-transform", "translate3d(" + width + "px, 0, 0)").css("border", 0).css("height", "auto").css("overflow-x", "visible").css("cssText", "margin-left: 0px !important; " + $("body").attr("style"));
                $("#ce_uberpanel_side").addClass("panel_open").css("border", "0 !important;");
                fadePanelIn();
                panelOpen();
            } else {
                $(this).find(".toggle-plus").show();
                $(this).find(".toggle-minus").hide();
                $("body").css("transform", "translate3d(0, 0, 0)").css("-webkit-transform", "translate3d(0, 0, 0)").css("-moz-transform", "translate3d(0, 0, 0)").css("-ms-transform", "translate3d(0, 0, 0)").css("-o-transform", "translate3d(0, 0, 0)");
                setTimeout(function () {
                    $("body").removeClass("ce_animate_500").css("transform", "").attr("style", originalCss);
                    $("body").css("position", "");
                    $("body").css("width", "");
                }, 500);
                $("#ce_uberpanel_side").removeClass("panel_open").css("margin-top", "");
                fadePanelOut();
            }
        });
        $(".ce_uberpanel-toggle").click(function (e) {
            if (supports3D()) {
                return;
            }
            e.preventDefault();
            if ($(this).parents("[data-uberpanel-pos=left], [data-uberpanel-pos=right]").length === 0) {
                return;
            }
            var isLeft = $(this).parents("[data-uberpanel-pos=left]").length !== 0;
            var width = isLeft ? $(this).parents("[data-uberpanel-pos]").attr("data-uberpanel-width") : $(this).parents("[data-uberpanel-pos]").attr("data-uberpanel-width") * -1;
            $(this).parents("[data-uberpanel-pos]").find(".ce_uberpanel_side-content").css("width", $(this).parents("[data-uberpanel-pos]").attr("data-uberpanel-width"));
            var doOpen = $(this).find(".toggle-plus").is(":visible");
            if (doOpen) {
                $(this).find(".toggle-plus").hide();
                $(this).find(".toggle-minus").show();
                originalCss = $("body").attr("style");
                $(this).parents("[data-uberpanel-pos]").animate({
                    left: 0
                }, 500);
                $("#ce_uberpanel_side").addClass("panel_open");
                fadePanelIn();
                panelOpen();
            } else {
                $(this).find(".toggle-plus").show();
                $(this).find(".toggle-minus").hide();
                $(this).parents("[data-uberpanel-pos]").animate({
                    left: parseInt($(this).parents("[data-uberpanel-pos]").attr("data-uberpanel-width")) * -1
                }, 500);
                setTimeout(function () {
                    $("body").css("position", "");
                    $("body").css("width", "");
                    $("body").attr("style", originalCss);
                }, 500);
                $("#ce_uberpanel_side").removeClass("panel_open");
                fadePanelOut();
            }
        });
        $(".ce_uberpanel_toggle").click(function (e) {
            e.preventDefault();
            $(".ce_uberpanel-toggle").trigger("click");
            if ($(this).attr("data-uberpanel-scroll") === "true") {
                $("html, body").animate({
                    scrollTop: 0
                });
            }
        });
        $("[data-uberpanel-width]:first").attr("data-uberpanel-original-width", $("[data-uberpanel-width]:first").attr("data-uberpanel-width"));
        var managePanelSize = function () {
            if ($(window).width() < parseInt($("[data-uberpanel-width]:first").attr("data-uberpanel-original-width")) + 50) {
                $("[data-uberpanel-width]:first").attr("data-uberpanel-width", $(window).width() - 50);
            } else {
                $("[data-uberpanel-width]:first").attr("data-uberpanel-width", $("[data-uberpanel-width]:first").attr("data-uberpanel-original-width"));
            }
            if ($("#ce_uberpanel_side").hasClass("panel_open")) {
                $("body").css("width", $("html").width());
            }
        };
        $(document).ready(managePanelSize);
        $(window).resize(managePanelSize);
        if ($("[data-uberpanel-hoveranimation=true]").length > 0) {
            fadePanelOut();
            $(".ce_uberpanel-toggle").hover(function () {
                fadePanelIn();
            }, function () {
                if ($(".ce_uberpanel_container").hasClass("panel_open")) {
                    return;
                }
                fadePanelOut();
            });
        }

        function fadePanelIn() {
            if ($("[data-uberpanel-hoveranimation=true]").length === 0) {
                return;
            }
            if (supportsNamedQueue()) {
                $(".ce_uberpanel_container").animate({
                    opacity: 1
                }, {
                    queue: "opacity"
                }).dequeue("opacity");
            } else {
                $(".ce_uberpanel_container").animate({
                    opacity: 1
                });
            }
        }

        function fadePanelOut() {
            if ($("[data-uberpanel-hoveranimation=true]").length === 0) {
                return;
            }
            if (supportsNamedQueue()) {
                $(".ce_uberpanel_container").stop("opacity").animate({
                    opacity: 0.8
                }, {
                    queue: "opacity"
                }).dequeue("opacity");
            } else {
                $(".ce_uberpanel_container").animate({
                    opacity: 0.8
                });
            }
        }

        function panelClosed() {}

        function panelOpen() {
            if ($("[data-uberpanel-pos=left], [data-uberpanel-pos=right]").length === 0) {
                return;
            }
            $("body").css("position", "absolute");
            $("body").css("width", $("html").width());
        }

        function supportsNamedQueue() {
            var vernums = $.fn.jquery.split(".");
            if (parseInt(vernums[0]) === 1 && parseInt(vernums[1]) >= 7 || parseInt(vernums[0]) > 1) {
                return true;
            }
            return false;
        }
    });
})(jQuery);

function supports3D() {
    if (document.body && document.body.style.perspective !== undefined) {
        return true;
    }
    var _tempDiv = document.createElement("div"),
        style = _tempDiv.style,
        a = ["Webkit", "Moz", "O", "Ms", "ms"],
        i = a.length;
    if (_tempDiv.style.perspective !== undefined) {
        return true;
    }
    while (--i > -1) {
        if (style[a[i] + "Perspective"] !== undefined) {
            return true;
        }
    }
    return false;
};