function popCenter( url, width, height ) {
	var left = ( screen.width / 2 ) - ( width / 2 );
	var top = ( screen.height / 2 ) - ( height / 2 );
	window.open( url, '_blank', 'left='+left+',top='+top+',width='+width+',height='+height+',menubar=no,status=no,scrollbars=no,toolbar=no' );
}

jQuery(function($){

	var _gaq = _gaq || [];
	var getnoticed = {
		placeholder: null,
		the_widget: null,
		is_moved: false,
		init: function() {
			// initialize subscribe widget placeholder
			getnoticed.the_widget = $('#secondary .widget_getnoticed_subscribe:first');
			getnoticed.placeholder = $('<div id="widget_getnoticed_subscribe_placeholder" />');
			getnoticed.the_widget.before( getnoticed.placeholder );
		},
		resize: function() {
			// .widget_getnoticed_subscribe
			// full-size: top of #secondary
			// smaller: after #primary .post:first
			if ( $('#secondary').css('float') == 'none' && !getnoticed.is_moved ) {
				getnoticed.is_moved = true;
				getnoticed.the_widget.insertAfter( $('#primary .hentry:first') );
				//$('.widget_reachWidget:first').insertAfter( $('#primary .post:eq(1)') );
			} else if ( $('#secondary').css('float') != 'none' && getnoticed.is_moved ) {
				//$('.widget_reachWidget:first').prependTo( $('#secondary') );
				getnoticed.is_moved = false;
				getnoticed.placeholder.before( getnoticed.the_widget );
			}
		}
	}
	getnoticed.init();
	
	// initialize field labels
	$('label.overlay').css( 'position', 'absolute' );
	$('label.overlay').each( function() {
		var lbl = $(this);
		$(this).parent().find('input:first').on({
			blur: function() {
				if ( $(this).val() == '' ) lbl.css( 'display', 'block' );
			},
			focus: function() {
				lbl.css( 'display', 'none' );
			}
		});
	});
	
	// initialize off-canvas area
	$('body').append('<div id="ocnav" />');
	// search
	$('#searchform').clone().attr('id', 'ocsearch').appendTo('#ocnav');
	$('#ocsearch #s').attr('id', '').attr('placeholder','');
	$('#ocsearch #searchsubmit').attr('id', '');
	// social
	if ( $('#secondary .widget_sociallist > ul').length ) {
		if ( $('#secondary .widget_getnoticed_sociallist h3').length )
			$('#secondary .widget_getnoticed_sociallist h3').clone().appendTo('#ocnav');
		else
			$('#ocnav').append('<h3>Connect with Me</h3>');
		$('#secondary .widget_sociallist > ul').clone().appendTo('#ocnav');
	}
	// primary nav
	if ( $('#primary-menu > ul').length ) {
		$('#ocnav').append('<h3>Menu</h3>');
		$('#primary-menu > ul').clone().attr('id','').appendTo('#ocnav');
	}
	// categories
	if ( $('#categories-menu > ul').length ) {
		$('#ocnav').append('<div id="ocnav_categories"><h3>Categories</h3></div>');
		$('#categories-menu > ul').clone().attr('id','').appendTo('#ocnav_categories');
	}
	
	$('.mobile_menu').on( 'click', function(e){
		e.preventDefault();
		$('body').toggleClass('mobileside_active');
	});
	
	// initialize mobile search (ipad portrait)
	$('#searchform').clone().attr('id', 'mobile_search_form').appendTo('#mobile_search');
	$('#mobile_search_form #s').attr('id', 'mobile_search_s').attr('placeholder','');
	$('#mobile_search_form label').attr('for', 'mobile_search_s');
	$('#mobile_search_form #searchsubmit').attr('id', 'mobile_search_submit');
	$('#mobile_search_form #mobile_search_s').on({
		'focus': function(){
			$('.site-navigation > .innerwrap').css('left','-185px');
		},
		'blur': function(){
			$('.site-navigation > .innerwrap').css('left','0');
		}
	});
	
	
	// initialize resizing
	$(window).resize(function() {
		getnoticed.resize();
	});
	getnoticed.resize();
	
	// initialize share bar
	if ( $('.sharebar').length > 0 ) {
		var draftmode = false;
		if ( $('.sharebar:first').data('status') == 'draft' ) draftmode = true;
		
		$('.blog .sharebar .share-print, .category .sharebar .share-print, .archive .sharebar .share-print').css('display', 'block').on( 'click', function(e) {
			// this will send them over to the page to print with a hashtag, we'll capture the hashtag on the single page and fire the print dialog
			_gaq.push([ '_trackSocial', 'Printer', 'Print from Index', $(this).data('url') ]);
		});
		if ( $('.single').length > 0 && window.location.hash.indexOf("print") > -1 ) window.print();
		$('.single .sharebar .share-print, .page .sharebar .share-print').css('display', 'block').on( 'click', function(e) {
			e.preventDefault();
			// fire tracking event
			_gaq.push([ '_trackSocial', 'Printer', 'Print', $(this).data('url') ]);
			// trigger print dialog
			window.print();
		});
		
		$('.sharebar .share-email').on( 'click', function(e) {
			_gaq.push([ '_trackSocial', 'Email', 'Email', $(this).data('url') ]);
		});

		$('.sharebar .share-comment').on( 'click', function(e) {
			_gaq.push([ '_trackSocial', 'WordPress', 'Comment', $(this).data('url') ]);
		});

		$('.sharebar .share-facebook, .reminder .share-facebook').on( 'click', function(e) {
			e.preventDefault();
			_gaq.push([ '_trackSocial', 'Facebook', 'Share', $(this).data('url') ]);
			popCenter( $(this).attr('href'), 655, 350 );
		});
		$('.sharebar .share-tweet, .reminder .share-twitter').on( 'click', function(e) {
			e.preventDefault();
			_gaq.push([ '_trackSocial', 'Twitter', 'Tweet', $(this).data('url') ]);
			popCenter( $(this).attr('href'), 550, 350 );
		});
		$('.sharebar .share-buffer').on( 'click', function(e) {
			e.preventDefault();
			_gaq.push([ '_trackSocial', 'Buffer', 'Share', $(this).data('url') ]);
			popCenter( $(this).attr('href'), 940, 530 );
		});
		$('.sharebar .share-pinterest').on( 'click', function(e) {
			e.preventDefault();
			_gaq.push([ '_trackSocial', 'Pinterest', 'Pin It', $(this).data('url') ]);
			popCenter( $(this).attr('href'), 750, 314 );
		});
		$('.sharebar .share-googleplus').on( 'click', function(e) {
			e.preventDefault();
			_gaq.push([ '_trackSocial', 'Google+', '+1', $(this).data('url') ]);
			popCenter( $(this).attr('href'), 480, 460 );
		});
		$('.sharebar .share-linkedin, .reminder .share-linkedin').on( 'click', function(e) {
			e.preventDefault();
			_gaq.push([ '_trackSocial', 'LinkedIn', 'Share', $(this).data('url') ]);
			popCenter( $(this).attr('href'), 600, 410 );
		});
		$('.sharebar .share-stumbleupon').on( 'click', function(e) {
			e.preventDefault();
			_gaq.push([ '_trackSocial', 'StumbleUpon', 'StumbleIt', $(this).data('url') ]);
			popCenter( $(this).attr('href'), 600, 410 );
		});

		if ( ! draftmode ) {

			// add arrows and show counts
			var set = $('.sharebar span[class|="share"]').not('.share-comment');
			set.find('.count').wrap( '<div class="count-wrap" />' );
			set.find('.count-wrap').wrap('<div class="count-effect" />' ).prepend( '<i class="spa"></i><i class="spb"></i>' );

			// facebook will return multiple counts in one request
			var permalinks = new Array();
			$('.share-facebook').each( function() {
				if ( $.inArray( $(this).attr('data-url'), permalinks ) == -1 ) permalinks[permalinks.length] = $(this).attr('data-url');
			});
			// Long Graph API Method
			var fbsharecountURL = "//graph.facebook.com/fql?q=SELECT%20url,%20normalized_url,%20share_count,%20like_count,%20comment_count,%20total_count,commentsbox_count,%20comments_fbid,%20click_count%20FROM%20link_stat%20WHERE%20url%20IN%20('" + encodeURIComponent(permalinks.join("','")) + "')";
			if ($.browser.msie && ! $.support.cors && window.XDomainRequest) {
				var xdr = new XDomainRequest();
				xdr.open( "GET", fbsharecountURL );
				xdr.onload = function () {
					var JSON = $.parseJSON(xdr.responseText);
					if (JSON == null || typeof (JSON) == 'undefined') {
						JSON = $.parseJSON(data.firstChild.textContent);
					}
					var counts = {};
					for ( var i = 0; i < JSON.data.length; i++ ) {
						counts[JSON.data[i].url] = JSON.data[i].total_count;
					}
					// display counts
					$('.share-facebook').each( function() {
						var tmp = $(this).attr('data-url');
						if ( tmp && counts[tmp] ) {
							$(this).find('.lbl').html( counts[tmp] );
							$(this).parent().find('.count').html( counts[tmp] );
							$(this).parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
						} else {
							$(this).parent().find('.count').html( 0 );
							$(this).parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
						}
					});
				};
				xdr.send();
			} else {
				$.getJSON( fbsharecountURL, function(results) {
					var counts = {};
					for ( var i = 0; i < results.data.length; i++ ) {
						counts[results.data[i].url] = results.data[i].total_count;
					}
					// display counts
					$('.share-facebook').each( function() {
						var tmp = $(this).attr('data-url');
						if ( tmp && counts[tmp] ) {
							$(this).find('.lbl').html( counts[tmp] );
							$(this).parent().find('.count').html( counts[tmp] );
							$(this).parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
						} else {
							$(this).parent().find('.count').html( 0 );
							$(this).parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
						}
					});
				} );
			}

/*
			$('.share-tweet').each( function() {
				$.getJSON( "//cdn.api.twitter.com/1/urls/count.json?callback=?&url=" + encodeURIComponent( $(this).attr('data-url') ), function(data) {
					data.url = data.url.substr( 0, data.url.length - 1 );
					var links = $('.share-tweet[data-url^="'+data.url+'"]');
					links.find('.lbl').html( data.count );
					links.parent().find('.count').html( data.count );
					links.parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
			    });
			});
*/
			
			$('.share-linkedin').each( function() {
				$.getJSON( "//www.linkedin.com/countserv/count/share?format=jsonp&callback=?&url=" + encodeURIComponent( $(this).attr('data-url') ), function(data) {
					var links = $('.share-linkedin[data-url^="' + data.url + '"]');
					links.find('.lbl').html( data.count );
					links.parent().find('.count').html( data.count );
					links.parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
				});
			});
		
			$('.share-pinterest').each( function() {
				$.getJSON( "//widgets.pinterest.com/v1/urls/count.json?callback=?&url=" + encodeURIComponent( $(this).attr('data-url') ), function(data) {
					var links = $('.share-pinterest[data-url^="' + data.url + '"]');
					links.parent().find('.count').html( data.count );
					links.parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
				});
			});
		
			/*
			$('.share-stumbleupon a').each( function() {
				var a = $(this);
				$.getJSON( "//www.stumbleupon.com/services/1.01/badge.getinfo?callback=?&url=" + encodeURIComponent( $(this).attr('data-url') ), function(data) {
					a.parent().find('.count').html( data.result.views );
					a.parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
			    });
			});
			*/
		
			$('.share-buffer').each( function() {
				var a = $(this);
				$.getJSON( "//api.bufferapp.com/1/links/shares.json?callback=?&url=" + encodeURIComponent( $(this).attr('data-url') ), function(data) {
					a.parent().find('.count').html( data.shares );
					a.parent().find('.count-wrap').animate({ left:'0px' }, 600, 'swing' );
			    });
			});
			
		}
	}
	
	// Make videos responsive #!! update this
	$('.videoframe').each(function(){
		var w = ( $(this).attr('width') ) ? $(this).attr('width') : $(this).width();
		var h = ( $(this).attr('height') ) ? $(this).attr('height') : $(this).height();
		var r = h / w;
		$(this).data( 'ratio', r );
		$(this).css( 'width', '100%' );
		$(this).css( 'height', Math.ceil( $(this).width() * $(this).data('ratio') ) + 'px' );
	});

	$(window).on({
		resize: function() {
			$('.videoframe').each(function(){
				if ( $(this).data('ratio') )
					$(this).css( 'height', Math.ceil( $(this).width() * $(this).data('ratio') ) + 'px' );
			});
		}
	});
	
	// nRelate tracking
	$('.nrelate').on( {
		click: function() {
			var relTitle = $(this).find('.nr_post_title').text();
			_gaq.push(['_trackEvent', 'nRelate', 'Click', relTitle]);
		},
		hover: function() {
			var relTitle = $(this).find('.nr_post_title').text();
			_gaq.push(['_trackEvent', 'nRelate', 'Hover', relTitle]);
		}
	}, '.nr_panel' );
	
	// Tweetable quotes
	$('.tweetable .actions .icon-facebook').on( 'click', function(e) {
		e.preventDefault();
		_gaq.push([ '_trackSocial', 'Facebook', 'Share Quote', $(this).data('url') ]);
		popCenter( $(this).attr('href'), 655, 350 );
	});
	$('.tweetable .actions .icon-twitter').on( 'click', function(e) {
		e.preventDefault();
		_gaq.push([ '_trackSocial', 'Twitter', 'Tweet Quote', $(this).data('url') ]);
		popCenter( $(this).attr('href'), 550, 350 );
	});
	
});
