jQuery(document).ready(function($){
	$(window).scroll(function() {
		var scrolled = $(window).scrollTop();
		if ( ! $('#permalogo').hasClass('shown') && scrolled > 80 ) {
			$('#permalogo').addClass('shown');
		} else if ( $('#permalogo').hasClass('shown') && scrolled < 80 ) {
			$('#permalogo').removeClass('shown');
		}
	});
	$('#permalogo').on('click', function(e){
		e.preventDefault();
		$('body').toggleClass('desktopside_active');
	});
	$('#desktopsplash').on('click', function(e){
		e.preventDefault();
		$('body').removeClass('desktopside_active');
	});
	
	$('#store-filter').css( 'display', 'block' );
	$('#store-filter-toggle').on('click', function(e){
		e.preventDefault();
		e.stopPropagation();
		if ( $('#store-filter .filter-menu').css('display') == 'none' ) {
			$('.page').one('click', function(e){
				$('#store-filter .filter-menu').css( 'display', 'none' );
			});
			$('#store-filter .filter-menu').css( 'display', 'block' );
		} else {
			$('#store-filter .filter-menu').css( 'display', 'none' );
		}
	});
	$('#store-filter .filter-menu a').on('click', function(e){
		$('#store-filter .filter-menu').css( 'display', 'none' );
		
		$('#store-filter .filter-menu a').removeClass('active');
		$(this).addClass('active');
		
		var countShown = 0;
		var cat = $(this).data('refid').toString();
		var items = $('#primary article');
		
		if ( cat == 'all' ) {
			items.css('display', 'block');
			countShown = 1;
		} else {
			for ( var i=0; i < items.length; i++ ) {
				var check = $(items[i]).data('refid');
				var checkarr = check.toString().split(',');
				if ( checkarr.indexOf(cat) >= 0 ) {
					$(items[i]).css( 'display', 'block' );
					countShown++;
				} else {
					$(items[i]).css( 'display', 'none' );
				}
			}
		}
		
		if ( countShown > 0 ) {
			$('#store-filter-noresults').css('display', 'none');
		} else {
			$('#store-filter-noresults').css('display', 'block');
		}
	});
	
});

