"use strict";

//the current webpage without any of the variables
var PAGE = (function() {
    var output = location.href;
    //the end of the url
    var end = output.length;

    //for each character that would end a url prematurely
    ['#', ';', '?'].iterate(function(c) {
        //get its position
        var index = output.indexOf(c);

        //if it was found, and is the smallest so far
        if (index > -1 && index < end)
            //use this one
            end = index;
    });

    //get the truncated url
    return output.substring(0, end);
})();

//initial setup
$(document).ready(function() {

    var RESULTS = window.RESULTS;
    var SCAN_RESULTS = window.SCAN_RESULTS;

   var parentPage = parent.PAGE.split("/")[3];
        if (parentPage != null && parentPage.toLowerCase() == "thesaurus")
                 {
                    if($.trim($('#getTermId').text()) ==  "")
                        $('#getTermId').remove();
                 }
    /* CALENDAR DATE PICKER */
    //shows the clear button
    var showDateClearButton = function() {
        (function() {
            this.datepicker('widget').find('.ui-datepicker-close')
                //.click($.datepicker._clearDate.callLater(this));
                .click(invokeLater.call(this, 'val', ['']));
        }).makeAsynchronous().apply($(this));
    };


    $.datepicker.setDefaults({
        showOn : 'both',
        buttonImageOnly : true,
        buttonImage : '/images-v4/form-calendar.gif',
        buttonText : 'Calendar',
        dateFormat : 'dd/mm/yy',
        yearRange : '1970:' + ((new Date()).getFullYear() + 1),
        showButtonPanel : true,
        changeYear : true,
        closeText : 'Clear',
        beforeShow : showDateClearButton,
        onChangeMonthYear : showDateClearButton
    });
    $('.from-date, .to-date').datepicker();

    (function(dateBoxes) {
        if (dateBoxes.length < 1)
            return;

        /*for inputs
        dateBoxes.spinner({
            min : '1920',
            max : (new Date()).getFullYear() + 1
        })*/

        /*for selects*/
        dateBoxes.append(function() {
            return $('<option>').val('').text('-');
        });

        iterate([1920, (new Date()).getFullYear() + 1], function(year) {
            dateBoxes.append(function() {
                return $('<option>').val(year + '').text(year + '')
            });
        }, -1);

        dateBoxes.chosen().trigger('liszt:updated');
        //get rid of little magnifying glass in input box
        dateBoxes.next().find('.chzn-search input').css('background', 'none');
        dateBoxes.next().css('width', '80px');
    })($('.from-year, .to-year'));


    $('select').not('.nochosen').chosen({'disable_search':true});


    // STYLESHEET SWITCHER BETWEEN SMALL SCREEN AND DEFAULT

// $('.desktop-version-toggle').click(function(){
//        if( readCookie('nomobile') === 'true' && $(this).hasClass('desktop'))
//         {
//             $(this).text('view desktop version');
//             $(this).addClass('mobile');
//             $(this).removeClass('desktop');
//             var head = document.getElementsByTagName('head')[0];
//             var link = document.createElement('link');
//             link.id  = 'small-screen-css';
//             link.rel = 'stylesheet';
//             link.type = 'text/css';
//             link.href = '/css/styles-small_v4.css';
//             link.media = 'all';
//             head.appendChild(link);
//             $('body').removeClass('mobile-wide');
//             eraseCookie('nomobile');


//         }
//         else
//         {
//             $(this).text('View mobile version');
//             $(this).addClass('desktop');
//             $(this).removeClass('mobile');
//             $('#small-screen-css').remove();
//             $('body').addClass('mobile-wide');
//             createCookie('nomobile','true',1);
//         }
// });



    $('.desktop-version-toggle').funcToggle(
        'click',
        function() {
            $(this).text('View mobile version');
            $(this).addClass('desktop');
            $(this).removeClass('mobile');
            $('#small-screen-css').remove();
            $('body').addClass('mobile-wide');
            createCookie('nomobile','true',1);
            $('.sectionFooter ul li').first().removeClass('visible-phone');
        },
        function() {
            $(this).text('view desktop version');
            $(this).addClass('mobile');
            $(this).removeClass('desktop');
            var head = document.getElementsByTagName('head')[0];
            var link = document.createElement('link');
            link.id  = 'small-screen-css';
            link.rel = 'stylesheet';
            link.type = 'text/css';
            link.href = '/css/styles-small_v4.css';
            link.media = 'all';
            head.appendChild(link);
            $('body').removeClass('mobile-wide');
            eraseCookie('nomobile');
        }
    );

   if( readCookie('nomobile') === 'true' && $('.desktop-version-toggle').hasClass('desktop') )
        {
            $('.desktop-version-toggle').trigger('click');

        }
        else
        {
            $('.sectionFooter ul li').first().addClass('visible-phone');
                               //Hide unwanted paggination button for mobile
            // if($('.pagination ul li:nth-child(4)').not('ellipses').length)
            // {
            //     $('.pagination ul li:nth-child(4)').addClass('hide-pangenumber');
            // }
            //   if($('.pagination ul li:nth-child(5)').not('ellipses').length)
            // {
            //     $('.pagination ul li:nth-child(5)').addClass('hide-pangenumber');
            // }
            //   if($('.pagination ul li:nth-child(6)').not('ellipses').length)
            // {
            //     $('.pagination ul li:nth-child(6)').addClass('hide-pangenumber');
            // }
            //   if($('.pagination ul li:nth-child(7)').not('ellipses').length)
            // {
            //     $('.pagination ul li:nth-child(7)').addClass('hide-pangenumber');
            // }
            //     if($('.pagination ul li:nth-child(8)').not('ellipses').length)
            // {
            //     $('.pagination ul li:nth-child(8)').addClass('hide-pangenumber');
            // }

        }




    // MAIN NAV FOR MOBILE
    // $('.btn-navbar').funcToggle(
    //     'click',
    //     function() {
    //         $('.main-nav').toggle();
    //         $(this).addClass('close');
    //         $(this).removeClass('open');
    //         $('.account-menu').hide();
    //     },
    //     function() {
    //         $('.main-nav').toggle();
    //         $(this).addClass('open');
    //         $(this).removeClass('close');
    //         $('.account-menu').hide();
    //     }
    // );

    // ACCOUNT NAV FOR MOBILE
    $('.btn-navbar-account').funcToggle(
        'click',
        function() {
            $('.account-menu-mobile').toggle();
            $(this).addClass('close');
            $(this).removeClass('open');
            $('.main-nav').hide();
        },
        function() {
            $('.account-menu-mobile').toggle();
            $(this).addClass('open');
            $(this).removeClass('close');
            $('.main-nav').hide();
        }
    );

    // auto-submit form when theasurus changed
    $(function() {
        $('#tSelect').change(function() {
            this.form.submit();
        });
    });


    // LOGIN PASSWORD FIELD PLACEHOLDER

    $("form.loginForm input.input-field")
		.bind("focus.labelFx", function(){
			$(this).prev().hide();
            this.style.color = 'black';
		})
		.bind("blur.labelFx", function(){
			$(this).prev()[!this.value ? "show" : "hide"]();
		})
		.trigger("blur.labelFx");


    // CHANGE DBs MODAL

    $('.header-tools-dbs').fancybox({
        type : 'iframe',
        width : 1000,
        minHeight : '90%',
        height : '90%',
        padding : 0
    });

    $('.change-dbs').fancybox({
        type : 'iframe',
        width : 1000,
        minHeight : '90%',
        height : '90%',
        padding : 0
    });

    if (RESULTS || SCAN_RESULTS)
    {
        window.setupResults();
    }

    if(getUrlVars()["searchResult"] == "clear")
        clearResults();

    // var docHeight = $(window).height();
    // var footer =$('footer');
    // var footerHeight = footer.height();
    // var footerTop = footer.position().top + footerHeight;

    // if (footerTop < docHeight) {
    //     footer.css('margin-top',(docHeight - footerTop) + 'px');
    // }

    chosenFocusGlow($('select.chzn-done'));

		// Tooltip for the logged in user name
	$("p.header-account-name").attr("title",function() {
		return $("p.header-account-name").text();
		});
	$("p.header-account-name").tooltip();

		//disabled the browse by publication link
	$('.disabled').find("a").click(function(e) {
        e.preventDefault();
    });


    setupRedirectToReferrerOnLogin();

    setHostForShibbolethRedirect();

});



//clears all form inputs given a root node. if no node is given, searchForm
//is used
function clearSearch(root) {
    //make sure root is a jquery obj, or suplement our own
    root = $(root || '[name="searchForm"]');

    //get all inputs
    var elements = root.find(':input');

    //for text inputs
    elements.filter('input[type="text"], textarea').val('');

    //for checkboxes
    elements.filter('input[type="checkbox"]').prop('checked', false);

    //for select boxes
    elements.filter('select').each(function(i, select) {
        select = $(select);

        //if not a multiselect
        if (!select.prop('multiple'))
            //select the first option, or nothing if no options
            select.val(select.find('option').val() || '');
        else
            //select no option
            select.val([]);

        //if it has a chosen display, update it
        if (select.hasClass('chzn-done'))
            chosenFocusGlow(select.trigger('liszt:updated'));
    });
}

/*! DEPRECATED !*
 * use vanialla open(),
 * none of these option values are guaranteed
 * esp. on mobile devices which we support.
 * for anchor elements just use target="_blank" and no javascript at all!
// Open Pop-up window.
function openWindow(url, name, w, h, scroll, resize) {
    return open(
        url,
        name,
        'height=' + h + ',' +
        'width=' + w + ',' +
        'menubar=yes,' +
        'top=' + ((screen.height) ? (screen.height - h) / 2 : 0) + ',' +
        'left=' + ((screen.width) ? (screen.width - w) / 2 : 0) + ',' +
        'scrollbars=' + scroll + ',' +
        'resizable=' + resize + ',' +
        'status=yes'
    );
}*/

/*! DEPRECATED !*
 * see openWindow()
function showResourceInfo(res, fromDB) {
    if (isNumber(res))
        // get actual name from list
        res = document.forms[0].resources.options[res].value;

    open(
        '/databaseInfo' +
            ';res=' + res +
            ((fromDB) ? ';fromDbPage=true' : '')
        ,
        'help',
        'width=750,height=550,scrollbars=yes,resizable=yes,status=yes'
    );
}*/

// Neal Landry
// Tuesday, 11 March 2003 11:16:36 AM
//
// Validate an email address entered by user on the client side.
// 5/1/04 - AR - modified to allow hyphens
    function isValidEmailAddress(address) {
        if (isValidEmailAddress._regexp.test(address))
            return true;

        alert("Please enter a valid email address!");
        return false;
    }
    isValidEmailAddress._regexp = /^\w[\w.-]*\w@\w[\w.-]*\w$/;
//

//creates the hide form button
function setupHideForm(hideOnLoad) {
    //the button to hide/show the form
    var toggler = $('<a>')
        .attr('href', 'javascript:')
        .attr('class', 'collapser open hidden-phone')
        .text('Hide search form')
    ;
    $('.current-dbs').after(toggler);

    var form = $('.form-container');
    //hides/shows the form
    var toggle = function() {
        //whether we should show or hide the form depends on whether
        //it is shown
        var show = $(this).hasClass('close');

        form.toggle();

        $(this)
            //change the text
            .text((show) ? 'Hide search form' : 'Show search form')
            //make sure the state is set
            .addClass((show) ? 'open' : 'close')
            .removeClass((show) ? 'close' : 'open')
        ;
    };
    toggler.click(toggle);

    if (hideOnLoad) {
        //inititally hide the form
        toggle.call(toggler);
    }
}


//makes the array of `chosen` elements overtly display their focus if tabbed
//to.
//must be called each time the chosen div's are generated (after the initial
//'chosen()' call and any subsequesnt 'trigger("liszt:updated")')
function chosenFocusGlow(selects) {
    selects.each(function(i, el) {
        el = $(el).next();
        var a = el.find('a.chzn-single')[0];

        el = el.find('.chzn-search input')
            .focus(function() {
                a.setStyles({borderColor:{value:'orange', important:true}});
            })
            .blur(function() {
                a.style.borderLeftColor = '';
                a.style.borderRightColor = '';
                a.style.borderBottomColor = '';
                a.style.borderTopColor = '';
            })
        ;
    });
}

function clearResults() {
    $('.results-number').parent().empty();
    $('.query-string').remove();

    var advlink = $('#btn_advanced').attr('href');
    var simplelink = $('#btn_simple').attr('href');
    $('#btn_simple').attr('href',simplelink + ";searchResult=clear");
    $('#btn_advanced').attr('href',advlink + ";searchResult=clear");
}


function getUrlVars()
{
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf(';') + 1).split('&');
    for(var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
}

////    GOOGLE ANALYTICS    ////
////  live site account no : -  UA-17461355-9 //
/// beta site account no : - UA-17461355-14 //
/// qatest account no: - UA-17461355-16 //
(function() {
    var tracker = "";
    if (window.RESULTS != null)
    {
        tracker = '/search?q=' + window.RESULTS.searchTerm;
    }

    ga('create', 'UA-17461355-9', 'auto', {'allowLinker': true});
    ga('require', 'linker');
    ga('linker:autoLink', ['search.informit.org', 'testsearch.informit.com.au'] );
    ga('send', 'pageview', tracker);

    if (window.PPVSuccess && window.PPVSuccess.transaction_id) {
        ga('require', 'ecommerce', 'ecommerce.js');
        ga('ecommerce:addTransaction', {'id' : window.PPVSuccess.transaction_id, 'affiliation' : window.PPVSuccess.affiliation, 'revenue' : window.PPVSuccess.total, 'tax' : window.PPVSuccess.tax, 'shipping' : window.PPVSuccess.shipping});
        ga('ecommerce:addItem', {'id' : window.PPVSuccess.transaction_id, 'sku' : window.PPVSuccess.sku, 'name' : window.PPVSuccess.product_name, 'category' : window.PPVSuccess.category, 'price' : window.PPVSuccess.unit_price, 'quantity' : window.PPVSuccess.unit_quantity});
        ga('ecommerce:send');
    }

})();



// ** Functions for Help **

//dv addition for use in ResourceInfoHandler
var usesDOM=(document.getElementById)?true:false;
var isIE4=(document.all && !usesDOM)?true:false;
var expanded=false;

function expandCollapse(gID) {
   if (isIE4) {
      var t=document.all("typediv"+gID).style;
      var p=document.all("itemdiv"+gID).style;
   } else if (usesDOM) {
      var t=document.getElementById("typediv"+gID).style;
      var p=document.getElementById("itemdiv"+gID).style;
   }
   if (p.display=="none") {
      t.fontStyle="italic";
	  t.color="#339900";
      p.display="block";
   } else {
      t.fontStyle="normal";
	  t.color="#000000";
	  p.display="none";
   }
   window.focus();    // forces the hilite border around a link to piss off
}

// below functions copied from http://www.quirksmode.org/js/cookies.html
function createCookie(name,value,days) {
  if (days) {
    var date = new Date();
    date.setTime(date.getTime()+(days*24*60*60*1000));
    var expires = "; expires="+date.toGMTString();
  } else {
    var expires = "";
  };
  document.cookie = name+"="+value+expires+"; path=/";
};

function readCookie(name) {
  var nameEQ = name + "=";
  var ca = document.cookie.split(';');
  for(var i=0;i < ca.length;i++) {
    var c = ca[i];
    while (c.charAt(0)==' ') c = c.substring(1,c.length);
    if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
  };
  return null;
};

function eraseCookie(name) {
  createCookie(name,"",-1);
};

function disableProcess()
// ** Function to disable submit button after submit
{
	document.getElementById('actionButtons').style.display="none";
	document.getElementById('pleaseWait').style.display="block";
    return true;
}

function setupRedirectToReferrerOnLogin (){
  var path = document.location.pathname;
  if (path.startsWith("/search") || path.startsWith("/advanced")) {
    setLoginParams();
  } else
  if (path.startsWith("/login")) {
    var referrer = document.referrer;
    if (path.includes(";url=")) { // login attempt failed or direct login from search
      $("form[name='loginForm']")[0].action=path;
      if (readCookie('requestedUrl')) {
        eraseCookie('requestedUrl');
      }
      createCookie('requestedUrl',encodeURIComponent(decodeURIComponent(path.split(';url=')[1])));
    } else if (path === "/login" && referrer.includes('/documentSummary'))
    { // first login attempt
      if (readCookie('requestedUrl')) {
        eraseCookie('requestedUrl');
      }
      if(document.location.host == referrer.split('/')[2])
      {
        createCookie('requestedUrl',encodeURIComponent(referrer.split('/')[3]));
        //$("form[name='loginForm']")[0].action+=";url="+encodeURIComponent(document.referrer);

        $("form[name='loginForm']")[0].action="/login"+";url="+encodeURIComponent(referrer.split('/')[3]);
      }

    }
  } else {
    if (readCookie('requestedUrl')) {
      eraseCookie('requestedUrl');
    }
  }



}

function setLoginParams() {
  var isLogin = false;
  // checl if already logged in
  $('.header-account.visible-desktop>ul>li>a').each(
    function()
    {
      var loginLabel = $(this).attr('href');
      if(loginLabel && loginLabel.startsWith('/login'))
      {
        isLogin=true;
      }
  });
  if (isLogin)
  {
    $('.row.list-item').each(function(index){
      var titleLinkSelector = $(this).find('.list-item-title a');
      if (titleLinkSelector.attr('href')){
        var loginSelector = $(this).find('ul.span10.offset4.list-item-actions a');
        if (loginSelector) {
          var loginLink = loginSelector.attr('href')+';url='+encodeURIComponent($(this).find('.list-item-title a').attr('href'));
          loginSelector.attr('href',loginLink);
        }
      }
    });
  }
}

function setHostForShibbolethRedirect(){
    var host = "?host=" + window.location.hostname;

    if (document.location.pathname.startsWith("/login")) {
        $('[name="shibFederationsDD"] > option').each(function() {
            this.value = this.value + encodeURIComponent(host);
        })
    }
}

//  Checks that string starts with the specific string
if (typeof String.prototype.startsWith != 'function') {
    String.prototype.startsWith = function (str) {
        return this.slice(0, str.length) == str;
    };
}

//  Checks that string ends with the specific string...
if (typeof String.prototype.endsWith != 'function') {
    String.prototype.endsWith = function (str) {
        return this.slice(-str.length) == str;
    };
}

if (!String.prototype.includes) {
  String.prototype.includes = function(search, start) {
    'use strict';
    if (typeof start !== 'number') {
      start = 0;
    }

    if (start + search.length > this.length) {
      return false;
    } else {
      return this.indexOf(search, start) !== -1;
    }
  };
}
