'use strict';

var timeout = window.timeout;
(function Timeout() {
    if (!(this instanceof Timeout)) {
        timeout = new Timeout();
        return;
    }

    this.dontCheck = false;
    this.autoRefresh = false;
    this.ajax = null;
    this.timer = null;
    this.dontAsk = false;

    if (isDefined(window.timeout)) {
        if (isDefined(timeout.dontCheck))
            this.dontCheck = timeout.dontCheck;
        if (isDefined(timeout.autoRefresh))
            this.autoRefresh = timeout.autoRefresh;
    }

    this.dialogue = getStandalone.call(
        $(document.body.makeElement('div'))
            .text('Your previous session has ended.')
            .attr('title', 'Session timeout')
            .dialog({
                autoOpen:false,
                modal : true,
                buttons : {
                     OK: function() {
                                    $(this).dialog( "close" );
                                 }
                }
            })
        ,
        'dialog'
    );

    this.question = getStandalone.call(
        $(document.body.makeElement('div'))
            .text('Your session is about to end. Would you like to extend your session?')
            .attr('title', 'Session timeout')
            .dialog({
                autoOpen : false,
                modal : true,
                buttons : {
                    'Yes' : function() {
                        $.ajax('/extendSession');
                        timeout.question('close');
                    },
                    'No' : function() {
                        timeout.question('close');
                        timeout.dontAsk = true;
                    }
                }
            })
        ,
        'dialog'
    );

    //asks the server how much time is left on this session
    this.ask = function() {
        //remove the old timer id
        timeout.timer = null;
        timeout.ajax = $.ajax('/checkTimeout').always(timeout.check);
    }

    //checks the response from the server
    this.check = function() {
        //if the response code is as if the session is lost
        if (
            timeout.ajax.status < 200 ||
            timeout.ajax.status >= 300
        ) {
            timeout.question('close');
            //notify the user
            timeout.dialogue('open');
        }

        //otherwise
        else
            timeout.evaluate(parseInt(timeout.ajax.responseText) * 60);

        //remove the old ajax object
        timeout.ajax = null;
    }

    //given the approximate amount of time left in seconds
    //decides what to tell the user
    this.evaluate = function(timeLeft) {
        timeout.question('close');

        //check again, if we are meant to
        if (!timeout.dontCheck) {
            timeout.timer = setTimeout(
                timeout.ask,
                //90 seconds before timeout, or 15 seconds if not enough time
                ((timeLeft > 90) ? timeLeft - 90 : 15) * 1000
            );
        }

        //if there are less than 2 minutes left
        if (timeLeft < 120) {
            //if we are meant to refresh for them
            if (timeout.autoRefresh)
                $.ajax('/extendSession')
            //otherwise if they have not said no before
            else if (!timeout.dontAsk)
                //ask the user to refresh the session
                timeout.question('open');
        }
    }
})();

//start now if im not an iframe and not meant to not check
if (window == parent && !timeout.dontCheck)
    timeout.ask();

