/* COPYRIGHT SAIC Pty Ltd, 2013
 * library.js - utilities
 * Written by Ashley Hall
 * provides crucial and core javascript functionality for the rest of the
 * library.
 */
"use strict";var ieFix={setTimeout:function(b){return function a(c,d){return b(c,d)}},clearTimeout:function(b){return function a(c){return b(c)}},setInterval:function(b){return function a(c,d){return b(c,d)}},clearInterval:function(b){return function a(c){return b(c)}},alert:function(b){return function a(c){return b(c)}}};for(var funcName in ieFix){if(typeof window[funcName]!=="object"){continue}try{ieFix[funcName]=ieFix[funcName](window[funcName]);eval("var "+funcName+";");window[funcName]=ieFix[funcName]}catch(e){if(window.console){console.error(e)}}if(window.console){if(typeof window[funcName]==="function"){console.warn("Fixed "+funcName+"()")}else{console.error("Couldn't fix "+funcName+"()")}}}try{(function(){}).apply(window,null)}catch(e){Function.prototype.apply=(function(b){return function a(d,c){return b.call(this,d,c||[])}})(Function.prototype.apply);if(window.console){try{(function(){}).apply(window,null);console.warn("Fixed Function.apply()")}catch(e2){console.error("Couldn't fix Function.apply()")}}}function typeOf(){var a=Object.prototype.toString.call(this);return a.substring(a.indexOf(" ")+1,a.length-1)}function isObject(a){return typeof a=="object"}function isString(a){return typeOf.call(a)=="String"}function isFunction(a){return typeOf.call(a)=="Function"}function isNumber(a){return typeOf.call(a)=="Number"}function isArray(a){return typeOf.call(a)=="Array"}function isUndefined(a){return typeof a=="undefined"}function isDefined(a){return a!=null}function isArrayLike(b,c){var a=true;if(!isArray(b)){if(!isDefined(c)){c=b.length}if(isNumber(c)){while((--c)>-1){if(!(c in b)){a=false;break}}}else{a=false}}return a}function getObject(d,a){if(!isArray(d)){d=[d]}var c=this;for(var b=0;b<d.length;++b){if(a&&!isDefined(c)){return false}c=c[d[b]]}return c}function setObject(h,g,d){var b=this;if(!isArray(h)){h=[h]}else{h=h.copy()}var f=h.splice(h.length-1,1);for(var c=0;c<h.length;++c){if(d&&!isDefined(b[h[c]])){b[h[c]]=new Object()}b=b[h[c]]}var a=b[f];b[f]=g;if(g!==b[f]){throw"Could not set "+f+" of "+(typeof b)}" to "+(typeof g);return a}function _EXTEND(d,f){if(!isDefined(d)){d=window}var c;var a;for(var b in f){a=f[b];if(isArray(a)){for(c=0;c<a.length;++c){_EXTEND._do(d,b,a[c])}}else{_EXTEND._do(d,b,a)}}return d}_EXTEND._do=function(f,b,d){var a=false;if(!isFunction(d)){if(isDefined(d.of)){f=d.of}if(isDefined(d.view)){a=d.view}d=d.func}try{if(!Object.prototype.hasOwnProperty.call(f,b)){Object.defineProperty(f,b,{value:d,enumerable:a,configurable:false,writable:false})}}catch(c){if(f===Object.prototype){f=window;if(window.console){console.warn("You must use "+b+".call(obj, args...)")}}if(!Object.prototype.hasOwnProperty.call(f,b)){f[b]=d}}if(f[b]!==d){alert("Unable to set "+b+" to "+f);throw"Unable to set "+b+" to "+f}};_EXTEND(Object.prototype,{typeOf:typeOf,setObject:setObject,getObject:getObject,getStandalone:function getStandalone$(a){return this[a].makeStandalone(this)},invokeLater:function invokeLater$(a,b){return this[a].callLaterOn(this,b)},asArray:function asArray$(c){if(!isDefined(c)){c=this.length}var b=Array(parseInt(c));iterate(c,(function a(d){b[d]=this[d]}).makeStandalone(this));return b}});_EXTEND(Array.prototype,{indecies:function indecies$(){var a=[];iterate([0,this.length-1],function b(c){a.push(c)});return a},transform:function transform$(d,f,c){if(!isFunction(d)){return this.transform(function b(g){return d[g]})}if(!isDefined(f)){f=0}if(!isDefined(c)){c=this.length-f}var a=[];this.iterate(function b(h,g){a.push(d(h,g))},null,null,[f,c+f-1]);return a},sortOrder:function sortOrder$(a){if(!isDefined(a)){a=function b(d,c){if(d<c){return -1}if(d>c){return 1}return 0}}return this.indecies().sort(function b(d,c){return a(this[d],this[c])})},copy:function copy(){return this.slice(0)},excludeRanges:function excludeRanges$(c){c=c.concat([this.length]);var a=[];var b=-1;c.iterate((function d(g){var h=(b[1]||b[0]||b)+1;var f=g[0]||g;if(h<f){a=a.concat(this.slice(h,f))}b=g}).makeStandalone(this));return a},fetchRanges:function fetchRanges$(b){var a=[];b.iterate((function c(d){if(!isArray(d)){a.push(this[d])}else{a=a.concat(this.slice(d[0],d[1]+1))}}).makeStandalone(this));return a}});_EXTEND(Object.prototype,{copyMap:function copyMap$(b){if(!isDefined(b)){b=new Object()}for(var a in this){b[a]=this[a]}return b},mergeMaps:{of:window,view:true,func:function mergeMaps$(c){var a=new Object();c.iterate(function b(d){copyMap.call(d,a)});return a}},properties:function properties$(){var a=[];for(var b in this){a.push(b)}return a},mapRemove:function mapRemove$(a){if(isUndefined(this[a])){return false}delete this[a];if(!isUndefined(this[a])){throw"Couldn't delete!"}return true},transformMap:function transformMap$(b){if(!isFunction(b)){return transformMap.call(this,function c(d){return b[d]})}var a=new Object();enumerate.call(this,function c(d,f){a[d]=b(f,d)});return a}});_EXTEND(Function.prototype,{makeAsynchronous:function makeAsynchronous$(c){var a=this;return function b(){var g=this;var d=arguments;setTimeout(function f(){var h=a.apply(g,d);if(c){c(h)}},0)}},makeStandalone:function makeStandalone$(c){var b=this;return function a(){return b.apply(c,arguments)}},callLater:function callLater$(){var c=this;var b=arguments;return function a(){return c.apply(window,b)}},callLaterOn:function callLaterOn(c,d){var a=this;return function b(){return a.apply(c,d)}},restrictCalls:function restrictCalls$(c,f){var g=this;var b=false;var h;var d=null;if(!isDefined(f)){h=function a(){var j=d;d=null;b=setTimeout(function i(){if(d==null){b=false}else{h()}},c);j()};return function a(){d=g.callLaterOn(this,arguments);if(b){return}h();return true}}if(f=="wait"){h=function a(){b=false;d()};return function a(){if(b!=false){clearTimeout(b)}d=g.callLaterOn(this,arguments);b=setTimeout(h,c);return}}if(f=="forget"){h=function a(){b=false};return function a(){if(b){return false}b=true;setTimeout(h,c);g.apply(this,arguments);return true}}throw"Unrecognised type!"}});_EXTEND(null,{enumerate:{of:Object.prototype,func:function enumerate$(d){var a=true;var b;for(var c in this){b=(d||this[c])(c,this[c],a);if(b===false){return}a=false}}},iterate:[{of:window,view:true,func:function iterate$(g,f,b,d){if(isNumber(g)){g=[0,g-1]}if(g[0]>g[1]){return null}if(!isDefined(b)){b=1}if(isNumber(b)){if(!isDefined(d)){d=(b<0)?g[1]:g[0]}b=(function h(i){return function j(k){return k+i}})(parseInt(b))}var c;var a=true;while(d>=g[0]&&d<=g[1]){c=f(d,a);a=false;if(c===false){break}if(isNumber(c)){d=c}else{d=b(d)}}return d}},{of:Array.prototype,func:function iterate$(c,a,f,b){if(this.length<1){return null}if(isNumber(b)){b=[0,b]}if(!isDefined(b)){b=[0,this.length-1]}else{b[0]=cap(b[0],0);b[1]=cap(b[1],null,this.length-1)}return iterate(b,(function d(h,g){return(c||this[h])(this[h],h,g)}).makeStandalone(this),a,f)}},{of:String.prototype,func:function iterate$(){return Array.prototype.iterate.apply(((new String("5"))[0]==="5")?this:this.split(""),arguments)}},{of:NodeList.prototype,func:function iterate$(){return Array.prototype.iterate.apply(this,arguments)}},{of:HTMLCollection.prototype,func:function iterate$(){return Array.prototype.iterate.apply(this,arguments)}}]});
/* COPYRIGHT SAIC Pty Ltd, 2013
 * strings.js - utilities/
 * Written by Ashley Hall
 * implements a number of methods to do with manipulating strings
 */
"use strict";function stringTrim(c,a){if(!isDefined(a)){a=" \n\t"}var d=c.length;var b=-1;c.iterate(function(g,f){if(a.indexOf(g)<0){d=f;return false}});c.iterate(function(g,f){if(a.indexOf(g)<0){b=f;return false}},-1);if(d>b){return""}return c.substring(d,b+1)}function alphanumericSort(a){return a.sort(alphanumericSort._compareFunc)}alphanumericSort._compareFunc=function(d,c){if(!isNaN(d)&&isNaN(c)){return -1}if(isNaN(d)&&!isNaN(c)){return 1}if(!isNaN(d)){return Number(d)-Number(c)}if(d==c){return 0}return(d<c)?-1:1};function surroundAndJoin(a,b,c){if(!isArray(b)){b=[b]}if(b.length<2){b=[b[0],b[0]]}return modifyAndJoin(a,function(d){return b[0]+d+b[1]},c)}function modifyAndJoin(a,d,c){if(!isDefined(c)){c=""}var b="";a.iterate(function(h,f,g){if(!g){b+=c}b+=d(h)});return b}_EXTEND(String.prototype,{isInteger:function(){var a=true;findAndDo(this,function(c,b){return !isNumeral(c.charCodeAt(0))},function(){a=false});return a}});function modifyString(d,b,c,a){if(!isDefined(a)){a=0}if(!isDefined(c)){c=""}return d.substring(0,b)+c+d.substring(b+a)}function isAlphaNumeric(a){return isAlpha(a)||isNumeral(a)}function isNumeral(a){return a>=isNumeral._zero&&a<=isNumeral._nine}isNumeral._zero="0".charCodeAt(0);isNumeral._nine="9".charCodeAt(0);function isAlpha(a){return isUpper(a)||isLower(a)}function isUpper(a){return a>=isUpper._a&&a<=isUpper._z}isUpper._a="A".charCodeAt(0);isUpper._z="Z".charCodeAt(0);function isLower(a){return a>=isLower._a&&a<=isLower._z}isLower._a="a".charCodeAt(0);isLower._z="z".charCodeAt(0);function decodeHTML(b){var a=document.createElement("pre");a.innerHTML=b;return a.firstChild.nodeValue}function escapeHTML(a){return document.createElement("pre").addText(a).innerHTML}function removeHTML(a){return a.replace(new RegExp("<[^>]*>","g"),"")}function splitWords(f,b,d,c){if(!isDefined(d)){d=" "}if(!isDefined(c)){c=" \t\n\r"}c=(function(g){return function(i){for(var h=0;h<g.length;++h){if(i==g[h]){return true}}return false}})(c);var a=0;f.iterate(function(h,g){if(c(h)){a=0;return}++a;if(a<=b){return}f=f.substring(0,g)+d+f.substring(g);a=0;return g+d.length});return f}function hasCapital(a){return hasCapital._regex.test(a)}hasCapital._regex=new RegExp("[A-Z]");function hasHyphen(a){return hasHyphen._regex.test(a)}hasHyphen._regex=new RegExp("[-]");function fromCamel(c){var a=[];var b="";c.iterate(function(d){if(isUpper(d.charCodeAt(0))){a.push(b);b=d.toLowerCase()}else{b+=d}});a.push(b);return a}function toCamel(c){var b="";var a=false;c.iterate(function(f,d){var g=c.charCodeAt(d);if(isNumeral(g)){b+=f}if(!isAlpha(g)){a=true;return}b+=(a)?f.toUpperCase():f.toLowerCase();a=false});return b}function fromHyphenated(a){return a.split("-")}function toHyphenated(b){var a="";b.iterate(function(d,c){var f=b.charCodeAt(c);if(isUpper(f)||(isAlpha(f)&&isNumeral(a.charCodeAt(length-1)))){a+="-"}else{if(!isAlphaNumeric(f)){if(c<b.length-1&&isAlphaNumeric(b.charCodeAt(c+1))){a+="-"}return}}a+=d.toLowerCase()});return a}
/* COPYRIGHT SAIC Pty Ltd, 2013
 * math.js - utilities
 * Written by Ashley Hall
 * some basic math functions that have been seen to be used often
 */
"use strict";function random(a,b){return Math.random()*(b-a)+a}function isWithin(b,a){return(b.x>=a.xMin&&b.x<=a.xMax)&&(b.y>=a.yMin&&b.y<=a.yMax)}function isNear(b,a,c){if(isNumber(c)){c={horizontal:c,vertical:c}}return(Math.abs(b.x-a.x)<c.horizontal&&Math.abs(b.y-a.y)<c.vertical)}function cap(b,a,c){if(isDefined(a)&&b<a){return a}if(isDefined(c)&&b>c){return c}return b}function isEven(a){return a%2==0}function isOdd(a){return(a-1)%2==0}function roundUp(a){return Math.ceil(a)}function roundDown(a){return Math.floor(a)}function roundTowardZero(a){return(a<0)?roundUp(a):roundDown(a)}function roundAwayFromZero(a){return(a<0)?roundDown(a):roundUp(a)}function roundHalfUp(a){return Math.round(a)}function roundHalfDown(a){return -roundHalfUp(-a)}function roundHalfAwayFromZero(a){return(a<0)?roundHalfDown(a):roundHalfUp(a)}function roundHalfTowardZero(a){return(a<0)?roundHalfUp(a):roundHalfDown(a)}function roundHalfToEven(a){return(isEven(roundTowardZero(a)))?roundHalfTowardZero(a):roundHalfAwayFromZero(a)}function roundHalfToOdd(a){return(isOdd(roundTowardZero(a)))?roundHalfTowardZero(a):roundHalfAwayFromZero(a)}function roundTest(a){return{up:roundUp(a),down:roundDown(a),towardZero:roundTowardZero(a),awayFromZero:roundAwayFromZero(a),halfUp:roundHalfUp(a),halfDown:roundHalfDown(a),halfAwayFromZero:roundHalfAwayFromZero(a),halfTowardZero:roundHalfTowardZero(a),halfEven:roundHalfToEven(a),halfOdd:roundHalfToOdd(a)}}function testRounds(){return[[0,roundTest(0)],[1,roundTest(1)],[-1,roundTest(-1)],[0.49,roundTest(0.49)],[-0.49,roundTest(-0.49)],[0.5,roundTest(0.5)],[-0.5,roundTest(-0.5)],[0.51,roundTest(0.51)],[-0.51,roundTest(-0.51)],]}
/* COPYRIGHT SAIC Pty Ltd, 2013
 * dom.js - utilities/
 * Written by Ashley Hall
 * implements a number of utility functions to do with manipulating the DOM
 */
"use strict";function getBodyAsDiv(b){var c=b.indexOf("<body");if(c<0){return b}else{c+=5}var a=b.lastIndexOf("/body>");if(a<0){return b}else{a+=1}return"<div"+b.substring(c,a)+"div>"}function changeOption(a,c){var b=false;findAndDo(a.options,function(d){return d.value==c},function(d){a.selectedIndex=d;b=true});return b}function getSelectedOption(a){return a.options[a.selectedIndex].value}_EXTEND(Element.prototype,{precedeWith:function(a){return this.parentNode.insertBefore(a,this)},succeedWith:function(a){return this.parentNode.insertBefore(a,this.nextSibling)},prependChild:function(a){return this.insertBefore(a,this.firstChild)},replace:function(a){return this.parentNode.replaceChild(a,this)},safeRemove:function(){if(isDefined(this.parentNode)){this.parentNode.removeChild(this)}return this}});_EXTEND(Element.prototype,{setAttributes:function(a){var b=this;enumerate.call(a,function(c,d){b.setAttribute(c,d)});return b}});_EXTEND((window.HTMLDocument||window.Document).prototype,{createLink:[function(b,a){return this.makeElement("a",{href:a},null,b)},{of:Element.prototype,func:function(b,a){return this.appendChild(this.ownerDocument.createLink(b,a))}}],createText:{of:Element.prototype,func:function(a){return this.appendChild(this.ownerDocument.createTextNode(a))}},addText:{of:Element.prototype,func:function(a){this.createText(a);return this}},createJavascriptLink:[function(c,b){var a=this.createLink(c,"javascript:");a.onclick=function(){b();return false};return a},{of:Element.prototype,func:function(b,a){return this.appendChild(this.ownerDocument.createJavascriptLink(b,a))}}],toElement:[function(b){var a=this.createElement("div");a.innerHTML=b;return a.firstChild.cloneNode(true)},{of:Element.prototype,func:function(a){return this.appendChild(this.ownerDocument.toElement(a))}}],makeElement:[function(c,b,d,f){var a=this.createElement(c);if(isDefined(b)){a.setAttributes(b)}if(isDefined(d)){a.setStyles(d)}if(isDefined(f)){a.addText(f)}return a},{of:Element.prototype,func:function(b,a,c,d){return this.appendChild(this.ownerDocument.makeElement(b,a,c,d))}}],makeSelect:[function makeSelect(c,f,b,d){var a=this.makeElement("select",b,d);c.iterate(function(h){if(!isArray(h)){h=[h]}if(h.length<2){h.push(h[0])}var g={value:h[0]};if(isDefined(f)&&h[0]==f){g.selected="selected"}a.makeElement("option",g).addText(h[1])});return a},{of:Element.prototype,func:function(b,d,a,c){return this.appendChild(this.ownerDocument.makeSelect(b,d,a,c))}}]});_EXTEND(Element.prototype,{removeClass:function(a){if(isArray(a)){a.iterate((function(b){this.removeClass(b)}).makeStandalone(this));return this}this.className=this.className.replace(new RegExp("(?:^|\\s)"+a+"(?!\\S)","g"),"");return this},addClass:function(a){if(isArray(a)){a.iterate((function(b){this.addClass(b)}).makeStandalone(this));return this}if(!this.hasClass(a)){if(this.className.length>0){a=" "+a}this.className+=a}return this},hasClass:function(a){return(new RegExp("(?:^|\\s)"+a+"(?!\\S)","g")).test(this.className)}});_EXTEND(Element.prototype,{getNatural:{of:window,func:function(b,c){var a=new Image();a.onload=function(){c({width:a.naturalWidth||a.width,height:a.naturalHeight||a.height})};a.src=b.src;return null}},getScale:{of:window,func:function(b,a){if(!isDefined(a)){a={width:b.naturalWidth,height:b.naturalHeight};if(isUndefined(a.width)){throw"Image naturals unsupported natively. Use getNatural()"}}return{horizontal:b.width/a.width,vertical:b.height/a.height}}},getDimensions:function(){return{width:this.offsetWidth,height:this.offsetHeight}},getCoordinates:function(a){if(isDefined(a)){if(a instanceof Element){a=a.getCoordinates()}a={x:-a.x,y:-a.y}}else{a={x:0,y:0}}a.x+=this.offsetLeft;a.y+=this.offsetTop;var b=this.offsetParent;while(b){a.x+=b.offsetLeft+b.clientLeft-b.scrollLeft;a.y+=b.offsetTop+b.clientTop-b.scrollTop;b=b.offsetParent}return a}});

/* COPYRIGHT SAIC Pty Ltd, 2013
 * general.js - utilities
 * Written by Ashley Hall
 * performs generic tasks that dont fit into any other existing utility file,
 * yet are equally as useful as those
 */
"use strict";function printUrl(c){var d=document.documentElement.clientWidth;var b=document.documentElement.clientHeight;var f=document.body.makeElement("iframe",{src:c},{position:"absolute",height:b+"px",width:d+"px",top:(b*-2)+"px",left:(d*-2)+"px"});function a(){f.contentWindow.focus();f.contentWindow.print()}if(isDefined(f.contentWindow)&&f.contentDocument.readyState=="complete"){a()}else{attachListener(f,"load",a)}}function waitFor(f,d,a,c,b){if(f()){return d()}if(isDefined(c)){--c;if(c<0){if(isDefined(b)){b()}return}}if(!isDefined(a)){a=10}setTimeout(waitFor.callLater(f,d,a,c,b),a)}function submitForm(b){var a=b.makeElement("input",{type:"submit"},{display:"none"});a.click();a.safeRemove()}function clearUserSelection(){if(window.getSelection){getSelection().removeAllRanges()}else{document.selection.empty()}}function getSelectedText(){var a;if(window.getSelection){a=getSelection().toString()}else{a=document.selection.createRange().text}return a}function isSiteTrusted(){try{new ActiveXObject("htmlfile")}catch(a){return false}return true}function getDefaults(b,c){if(!isDefined(b)){b=new Object()}var a=new Object();enumerate.call(c,function(f,d){a[f]=(isDefined(b[f]))?b[f]:d});return a}var TIME_ORDER=["milliseconds","seconds","minutes","hours","days","weeks","fortnights","months","years","centuries","millennia"];var TIME_CONVERSION=new Object();TIME_CONVERSION.milliseconds=1;TIME_CONVERSION.seconds=toMilli(1000,"milliseconds");TIME_CONVERSION.minutes=toMilli(60,"seconds");TIME_CONVERSION.hours=toMilli(60,"minutes");TIME_CONVERSION.days=toMilli(24,"hours");TIME_CONVERSION.weeks=toMilli(7,"days");TIME_CONVERSION.fortnights=toMilli(2,"weeks");TIME_CONVERSION.months=toMilli(30,"days");TIME_CONVERSION.years=toMilli(365,"days");TIME_CONVERSION.decades=toMilli(10,"years");TIME_CONVERSION.centuries=toMilli(10,"decades");TIME_CONVERSION.millennia=toMilli(10,"centuries");function milliTo(a,b){return a/TIME_CONVERSION[b]}function toMilli(b,a){return b*TIME_CONVERSION[a]}function timeToMilli(d,c){var b=0;if(!isDefined(c)){c="milliseconds"}for(var a in d){if(isDefined(d[a])){b+=toMilli(d[a],a)}}return b}function milliToTime(a,b){TIME_ORDER.iterate(function(c){if(!isDefined(b[c])){return}b[c]=Math.floor(milliTo(a,c));a-=toMilli(b[c],c)},-1);return a}function modifyDate(a,b){b=compatibleTime(b);a.setMonth(a.getMonth()+b.months);a.setMilliseconds(a.getMilliseconds()+b.milliseconds);return a}function compatibleTime(c){var a=milliTo(timeToMilli({millenia:c.millenia,centuries:c.centuries,decades:c.decades,years:c.years,months:c.months}),"months");var b=timeToMilli({fortnights:c.fortnights,weeks:c.weeks,days:c.days,hours:c.hours,minutes:c.minutes,seconds:c.seconds,milliseconds:c.milliseconds});b=Math.floor(b+toMilli(a%1,"months"));a=Math.floor(a);return{months:a,milliseconds:b}}var userAgent=(function(){function d(h,f){if(!h){h=0}var g=[];var i;var j;while(h<navigator.userAgent.length){j=navigator.userAgent.charAt(h);if(f&&f.indexOf(j)>-1){++h;break}else{if(j==")"){break}else{if(j==" "||j==","||j==":"||j=="/"||j==";"){++h;continue}else{if(j=="("){++h;i=d(h,")")}else{if(f==")"){i=d(h,",;")}else{if(!f){i=d(h," ")}else{i=a(h)}}}}}}g.push(i[0]);h=i[1]}if(f==",;"&&g.length==1){g=g[0]}if(!f||f==")"){g.dontSave=true}return[g,h]}function a(g){var f="";var h;while(g<navigator.userAgent.length){h=navigator.userAgent.charAt(g);if(h==";"||h==" "||h==":"||h==","||h=="/"||h==")"){break}++g;f+=h}return[f,g]}var b=new Object();function c(f){var h;if(isString(f)){b[f]=true}else{if(!f.dontSave){h=f[f.length-1];f=f.slice(0,f.length-1);if(!isNaN(parseFloat(h))){h=parseFloat(h)}setObject.call(b,f,h,true)}else{for(var g=0;g<f.length;++g){c(f[g])}}}}b._orig=d()[0];c(b._orig);return b})();_EXTEND(window,{findAndDo:function(b,g,d,a,h,c){var f=g;if(!isFunction(g)){f=function(i){return i==g}}return b.iterate(function(j,i){var k;if(!f(j,i)){return}k=d(i,j);if(isUndefined(k)){k=false}return k},a,h,c)},findTheseAndDo:function(b,d,g,a,h,f,c){if(!isDefined(c)){c=function(i,j){return i==j}}return findAndDo(b,function(j){var i=false;findAndDo(d,c,function(){i=true;return false});return i},g,a,h,f)},findStringAndDo:function(b,c,f,a,g,d){return findAndDo(b,function(h){return !isUndefined(c[h])},f,a,g,d)}});function Subscription(a){this.options=getDefaults(a,{firesOnce:false,context:null,args:null,before:null,after:null});this.stop=false;this.subscribed=[];this._before=a.before;this._after=a.after;this.fired=0}Subscription.prototype={subscribe:function(a){if(this.subscribed!=null){this.subscribed.push(a)}else{this.run(a)}},unsubscribe:function(a){findAndDo(this.subscribed,function(b){return b==a},function(b){this.subscribed.splice(b,1)})},empty:function(){this.subscribed=[]},fire:function(a){if(isDefined(a)){this.options.args=a}if(isDefined(this._before)){this.run(this._before)}var b=this.subscribed;if(this.options.firesOnce){this.subscribed=null}b.iterate(getStandalone.call(this,"run"));++this.fired;if(isDefined(this._after)){this.run(this._after)}},run:function(a){if(this.stop){return}try{a.apply(this.options.context,this.options.args)}catch(b){(function(){throw b}).makeAsynchronous()()}},cease:function(){this.stop=true;this.subscribed=null}}
/* COPYRIGHT SAIC Pty Ltd, 2013
 * events.js - utilities
 * Written by Ashley Hall
 * attempts to normalise events and their handlers
 */
;"use strict";_EXTEND(Event.prototype,{dontPropagate:function(){if(isDefined(this.stopPropagation)){this.stopPropagation()}else{this.cancelBubble=true}return this},noAction:function(){if(isDefined(this.preventDefault)){this.preventDefault()}else{this.returnValue=false}return this}});function fireEvent(c,b){if(isDefined(c.dispatchEvent)){return c.dispatchEvent(b)}var a=c.fireEvent("on"+b.type,b);if(a){if(isFunction(c[b.type])){c[b.type]()}}return a}function attachListener(c,b,a){if(isArray(c)){c.iterate(function(d){attachListener(d,b,a)});return}if(isArray(b)){b.iterate(function(d){attachListener(c,d,a)});return}if(isArray(a)){b.iterate(function(d){attachListener(c,b,d)});return}if(isDefined(eventNameSwap[b])){b=eventNameSwap[b]}if(c.addEventListener){c.addEventListener(b,a,false)}else{c.attachEvent("on"+b,a)}}function detachListener(c,b,a){if(isArray(c)){c.iterate(function(d){detachListener(d,b,a)});return}if(isArray(b)){b.iterate(function(d){detachListener(c,d,a)});return}if(isArray(a)){b.iterate(function(d){attachListener(c,b,d)});return}if(isDefined(eventNameSwap[b])){b=eventNameSwap[b]}if(c.removeEventListener){c.removeEventListener(b,a,false)}else{c.detachEvent("on"+b,a)}}var eventNameSwap=new Object();if(userAgent.Firefox){eventNameSwap.mousewheel="DOMMouseScroll"}function detachListeners(a,c){if(!isDefined(c)){c=false}var b=a.cloneNode(c);if(!c){a.childNodes.iterate(getStandalone.call(b,"prependChild"),-1)}if(isDefined(a.parentNode)){a.replace(b)}}var onceReady;var onceLoaded;(function(){var b=new Subscription({firesOnce:true});var a=new Subscription({firesOnce:true});attachListener(document,"readystatechange",function c(d){if(b.fired<1&&(document.readyState=="interactive"||document.readyState=="complete")){b.fire()}if(a.fired<1&&document.readyState=="complete"){a.fire();detachListener(document,"readystatechange",c)}});window.onceReady=getStandalone.call(b,"subscribe");window.onceLoaded=getStandalone.call(a,"subscribe")})();function eventOnOnce(d,c,b){attachListener(d,c,function a(){detachListener(d,c,a);b()})}function getSource(a){a=a||event;return a.target||a.srcElement}function getKeyCode(a){a=a||event;return a.keyCode||a.which}function propagateMouseEvent(d,b,c){var a;c=c||event;if(c.initMouseEvent){a=document.createEvent("MouseEvent");a.initMouseEvent(b,true,true,window,0,c.screenX,c.screenY,c.clientX,c.clientY,c.ctrlKey,c.altKey,c.shiftKey,c.metaKey,0,null);d.dispatchEvent(a)}else{a=document.createEventObject(c);d.fireEvent("on"+b,a)}}var resizeIdFunctionMap=new Object();function newResizeObject(c,b){var a={functionIds:[],functions:new Object(),handle:null,obj:c};resizeIdFunctionMap[b]=a;a.handle=runResizeFunctions.callLater(b).restrictCalls(50);attachListener(c,"resize",a.handle)}function runResizeFunctions(a){var b=resizeIdFunctionMap[a].functions;for(var c in b){b[c]()}}function doAfterResize(c,f,d,b){if(!isDefined(d)||!isDefined(b)){d=window;b="window"}if(isUndefined(resizeIdFunctionMap[b])){newResizeObject(d,b)}var a=resizeIdFunctionMap[b];if(isUndefined(a.functions[f])){a.functionIds.push(f)}a.functions[f]=c}function removeResizeFunction(f,b){if(!isDefined(b)){b="window"}var a=resizeIdFunctionMap[b];var d=a.functions;var c=a.functionIds;if(!isDefined(f)){a.functions=new Object();a.functionIds=[]}else{findAndDo(c,f,function(g){delete a.functions[f];c.splice(g,1);return false});if(c.length>0){return}}detachListener(a.obj,"resize",a.handle);delete resizeIdFunctionMap[b]}var wheelIdFunctionMap=new Object();function onWheel(b,c,a){if(!isDefined(a)){a=document.body}b=onWheel._normalise(b);wheelIdFunctionMap[c]=b;attachListener(a,"mousewheel",b)}function removeWheelListener(b,a){if(!isDefined(a)){a=document.body}detachListener(a,"mousewheel",wheelIdFunctionMap[b]);delete wheelIdFunctionMap[b]}if(userAgent.MSIE){onWheel._normalise=function(a){return function(){a(event.wheelDelta/128)}}}else{if(userAgent.Chrome){onWheel._normalise=function(a){return function(b){a(b.wheelDelta/120)}}}else{if(userAgent.Firefox){onWheel._normalise=function(a){return function(b){a(b.detail/-3)}};
/* COPYRIGHT SAIC Pty Ltd, 2013
 * css.js - utilities/
 * Written by Ashley Hall
 * provides the library with the ability to add css rules at its leasure
 */
}}}"use strict";_EXTEND(Element.prototype,{setStyles:function(b){var a=this;enumerate.call(b,function(f,h){if(hasHyphen(f)){f=toCamel(f)}var d=false;if(!isString(h)){d=h.important;h=h.value}var i=convertCss(f,h);if(i!=null){f=i[0];h=i[1]}if(h==null){h=""}if(!d){a.style[f]=h;return}if(f=="cssFloat"){f="float"}else{if(hasCapital(f)){f=toHyphenated(f)}}var g=a.getAttribute("style");var c;if(g==null){g=""}else{c=g.indexOf(f);if(c>0){if(c<1){c=g.indexOf(";");if(c<0){g=""}else{g=g.substring(c)}}else{g=g.replace(new RegExp(f+" ?:[^;]*;?"),"")}}g=stringTrim(g);if(g.length>0&&g[g.length-1]!=";"){g+=";"}}a.setAttribute("style",g+f+":"+h+" !important;")});return a}});function convertCss(c,b){var a=convertCss._properties[c];if(isUndefined(a)){return null}if(a.check){if(isUndefined(a.check())){return}}else{if(!isUndefined(document.body.style[c])){return}}if(a.replacement){c=a.replacement}if(a.convert&&isDefined(b)&&b!==""){b=a.convert(b)}return[c,b]}convertCss._properties={opacity:{replacement:"filter",convert:function(a){return"alpha(opacity="+Math.floor(parseFloat(a)*100)+")"}},cssFloat:{replacement:"float"}};function insertCss(a,b){onceLoaded(function(){var c=insertCss._run(a);if(b){b(c)}})}insertCss._run=function(a){var b=(document.getElementsByTagName("head")[0]||document.documentElement.prependChild(document.makeElement("head"))).makeElement("style",{type:"text/css"});var c="";a.iterate(function(d){c+=insertCss._makeStatement(d[0],d[1])});if(isDefined(b.styleSheet)){b.styleSheet.cssText=c}else{b.appendChild(document.createTextNode(c))}return b};insertCss._makeStatement=function(a,b){return insertCss["_make"+((isArray(b))?"AtRule":"Rule")](a,b)};insertCss._makeAtRule=function(a,b){var c="@"+a+"{";b.iterate(function(d){c+=insertCss._makeStatement(d[0],d[1])});c+="}";return c};insertCss._makeRule=function(a,c){if(isArray(a)){a=a.join(",")}var b=a+"{";enumerate.call(c,function(f,d){b+=insertCss._makeDeclaration(f,d)});b+="}";return b};insertCss._makeDeclaration=function(c,b){var a=";";if(!isString(b)&&!isNumber(b)){if(b.important){a=" !important;"}b=b.value}if(hasHyphen(c)){c=toCamel(c)}var d=convertCss(c,b);if(d!=null){c=d[0];b=d[1]}if(c=="cssFloat"){c="float"}else{if(hasCapital(c)){c=toHyphenated(c)}}return c+":"+b+a};var cssRules=null;function getCssRules(){if(cssRules==null){loadStyleSheets()}return cssRules}function loadStyleSheets(){cssRules=[];document.styleSheets.iterate(function(a){cssRules=cssRules.concat(getEasyRules(a))})}function getEasyRules(d){var a=[];var c=(d.cssRules||d.rules);var b;c.iterate(function(f){b=generateEasyStyles(f);if(b==null){return}a.push({properties:b,sheet:d,selector:f.selectorText,_real:f})});return a}function generateEasyStyles(c){var d=(c.style||c.cssStyles);var a=new Object();if(isUndefined(d)){return null}if(isDefined(d.length)){d.iterate(function(f){var f=toCamel(f);a[f]=d[f]})}else{for(var b in d){if(d[b]==""){continue}a[b]=d[b]}}return a}function getRulesBySelector(a){var b=[];getCssRules();cssRules.iterate(function(c){if(!c.selector.match(a)){return}b.push(c)});return b}function getRulesBySelectors(b,c){var a=[];getCssRules();if(!isDefined(c)){c=true}cssRules.iterate(function(f){var d=true;b.iterate(function(g){if(f.selector.indexOf(g)>=0){return c}d=false;return false});if(d){d.push(f)}});return a}function getRulesBySheet(b){var a=[];getCssRules();cssRules.iterate(function(c){if(c.sheet.href.match(b)){a.push(c)}});return a}insertCss([['[unselectable="on"]',{WebkitUserSelect:"none",MozUserSelect:"-moz-none",MsUserSelect:"none",OUserSelect:"none",UserSelect:"none",WebkitTouchCallout:"none",KhtmlUserSelect:"none"}],[['[unselectable="off"]'],{WebkitUserSelect:"auto",MozUserSelect:"text",MsUserSelect:"text",OUserSelect:"text",UserSelect:"all",WebkitTouchCallout:"default",KhtmlUserSelect:"text"}]]);
/* COPYRIGHT SAIC Pty Ltd, 2013
 * network.js - utilities
 * Written by Ashley Hall
 * this file implements functions to do with requesting things from
 * servers. from AJAX and page refreshing requests to showing loading
 * bars on divs during these requests
 */
"use strict";function request(c,a,b,f){if(!isDefined(f)){f=window}if(isDefined(a)){if(c.indexOf("?")<0){c+="?"}else{c+="&"}c+=toQueryString(a)}if(!isDefined(b)){f.location.href=c;return}var d=f.document.body.makeElement("form",{action:c,method:"POST"},{display:"none"});enumerate.call(b,function(h,g){if(!isDefined(g)){d.makeElement("input",{type:"hidden",name:h})}else{if(!isArray(g)){d.makeElement("input",{type:"hidden",name:h,value:g})}else{g.iterate(function(i){d.makeElement("input",{type:"hidden",name:h,value:i})})}}});d.submit()}function asyncRequest(d,a,c,f,g){var b;if(!(this instanceof asyncRequest)){b=new asyncRequest();asyncRequest.apply(b,arguments);return b}else{if(arguments.length<1){return}}if(!isDefined(f)){f=10000}if(!isDefined(g)){g=(isDefined(c))?"POST":"GET"}if(isDefined(a)){if(d.indexOf("?")<0){d+="?"}else{d+="&"}d+=toQueryString(a)}if(isDefined(c)){if(!isString(c)){c=toQueryString(c)}}this._request=new XMLHttpRequest();this._failQueue=new Subscription({firesOnce:true,args:[this]});this._completeQueue=new Subscription({firesOnce:true,args:[this]});this._successQueue=new Subscription({firesOnce:true,args:[this]});this.status=null;this.statusText=null;this.response=null;this.state=0;this.fetchedUrl=d;this._request.onreadystatechange=invokeLater.call(this,"_stateChange");this._request.open(g,d,true);this._request.setRequestHeader("Content-Type","application/x-www-form-urlencoded");this._request.send(c);if(f>=0){this._timeoutTimer=setTimeout(invokeLater.call(this,"_stateChange",[true]),f)}}asyncRequest.prototype={_stateChange:function(a){if(isDefined(this.status)){return}if(a){this._request.abort();this.status=-1;this.state=4;this.statusText="timeout"}else{this.state=this._request.readyState;if(this.state<4){return}clearTimeout(this._timeoutTimer);this.status=this._request.status;this.statusText=this._request.statusText}this.response=this._request.responseText;if(this._request.status>=200&&this._request.status<300){this._success()}else{this._fail()}this._completeQueue.fire()},onceSuccessful:function(a){this._successQueue.subscribe(a);return this},_success:function(){this._failQueue.cease();this._successQueue.fire()},onceFailed:function(a){this._failQueue.subscribe(a);return this},_fail:function(){this._successQueue.cease();if(this._failQueue.subscribed.length<1){this._failQueue.subscribe(function(){throw"AJAX Failed! ("+this.status+" "+this.statusText+")"})}this._failQueue.fire()},onceCompleted:function(a){this._completeQueue.subscribe(a);return this}};function toQueryString(b){var a="";enumerate.call(b,function(d,f,g){if(!g){a+="&"}var c=encodeURIComponent(d);a+=c;if(isDefined(f)){if(!isArray(f)){a+="="+encodeURIComponent(f)}else{f.iterate(function(j,h,k){if(!k){a+="&"+c}a+="="+encodeURIComponent(j)})}}});return a}function fromQueryString(b){var a=new Object();b.split("&").iterate(function(c){c=c.split("=");c[0]=decodeURIComponent(c[0]);if(!isDefined(c[1])){c[1]=null}else{c[1]=decodeURIComponent(c[1])}if(isDefined(a[c[0]])){if(!isArray(a[c[0]])){a[c[0]]=[a[c[0]]]}a[c[0]].push(c[1])}else{a[c[0]]=c[1]}});return a}function asyncFailure(b,a){return function(c){asyncFailure._run(c,b,a)}}asyncFailure._run=function(c,b,a){alertMessage(asyncFailureHTML(c),(isDefined(b))?b:"Http request call failed").onceReady(function(d){d.setFooter(c.statusText+" ("+c.status+")");if(isDefined(a)){a(d)}})};function asyncFailureDiv(c,b,a){return function(d){asyncFailureDiv._run(d,c,b,a)}}asyncFailureDiv._run=function(c,f,b,a){f.innerHTML=asyncFailureHMTL(c);var d=document.createElement("div");if(isDefined(b)){d.makeElement("h2",null,{color:"red"}).innerHTML=escapeHTML(b)}d.makeElement("h4",null,{color:"red"}).innerHTML=c.statusText+" ("+c.status+")";f.prependChild(d);if(isDefined(a)){a(c,f)}};function asyncFailureHMTL(a){return(a.status>0)?getBodyAsDiv(a.response):"Connection dropped. Either refused or timed-out.<br />Make sure the server is available, and the URL is accurate."}var LOADING_DIVS=[];function indicateLoading(d,c){if(isArray(d)){return d.transform(function(f){return indicateLoading(f,c)})}var b=getLoadingDiv(d);var a={prev:LOADING_DIVS[b].loading,next:null,cursor:(c)?"progress":"wait",index:b};a.prev.next=a;LOADING_DIVS[b].loading=a;d.style.cursor=a.cursor;return a}function finishedLoading(a){if(isArray(a)){a.iterate(finishedLoading);return}var b=a.prev;if(b==null){return}a.prev=null;b.next=null;if(a.next!=null){a.next.prev=b;return}LOADING_DIVS[a.index].div.style.cursor=b.cursor;LOADING_DIVS[a.index].loading=b;if(b.prev==null){b.cursor=null}}function getLoadingDiv(b){var a=null;findAndDo(LOADING_DIVS,function(c){return c.div==b},function(c){a=c});if(a==null){a=LOADING_DIVS.length;LOADING_DIVS.push({div:b,loading:{prev:null,next:null,cursor:null,index:a}})}if(a.cursor==null){a.cursor=b.style.cursor||""}return a}
/* COPYRIGHT SAIC Pty Ltd, 2013
 * popups.js - utilities
 * Written by Ashley Hall
 * implements a YUI2 Panel like window wrapper.
 * I.e. It will open new windows, and return an object linked to it
 * that you can perform standard functions for YAHOO.widget.Panel on
 */
"use strict";attachListener(window,"beforeunload",function(){enumerate.call(ExternalPopup.all,function(b,a){a.destroy()})});var externalPopupNum=0;var ExternalPopup=function(a){this._num=++externalPopupNum;this.ready=false;this._readyQueue=[];if(!isDefined(a)){a=new Object()}var d=function(f,g){if(!isDefined(f)){f=g}return(f)?"yes":"no"};this._window=window.open("about:blank","_blank","height="+(a.height||"200")+"px,location="+d(a.location)+",menubar="+d(a.menuBar)+",resizable="+d(a.resizable,true)+",scrollbars="+d(a.scrollBars,true)+",status="+d(a.status)+",title="+d(a.titleBar,true)+",toolbar="+d(a.toolbar,false)+",width="+(a.width||"300")+"px");ExternalPopup.all[this._num+""]=this;this._document=this._window.document;var c="<!doctype html><html><head>";var b=ExternalPopup.includeScripts.transform(function(f){return new RegExp(f)});document.getElementsByTagName("script").iterate(function(f){f=f.src;if(!isDefined(f)||f.length<1){return}findAndDo(b,function(g){return g.test(f)},function(){c+='<script type="text/javascript" src="'+f+'"><\/script>'})});c+="<title>"+(a.title||"No Title")+'</title></head><body><script type="text/javascript">opener.ExternalPopup.all['+this._num+"]._init();<\/script></body></html>";this._document.write(c)};ExternalPopup.prototype={_init:function(){if(!this._window._EXTEND){setTimeout(invokeLater.call(this,"_init",arguments),10);return}this._body=this._document.body;this._head=this._document.getElementsByTagName("head")[0];this._element=this._document.documentElement;this.element=this._document.body;this.destroyEvent=new Subscription({context:this,firesOnce:true,before:function(){this.ready=false;delete ExternalPopup.all[this._num+""]},after:function(){this._window=null;this._document=null;this._body=null;this._head=null;this._element=null;this.element=null;this.body=null;this.header=null;this.footer=null}});attachListener.call(this._window,this._window,"beforeunload",invokeLater.call(this.destroyEvent,"fire"));this.header=this._body.makeElement("div",{"class":"hd"});this._body.makeElement("hr");this.body=this._body.makeElement("div",{"class":"bd"});this._body.makeElement("hr");this.footer=this._body.makeElement("div",{"class":"ft"});this.ready=true;this._readyQueue.iterate((function(a){a.call(this)}).makeStandalone(this))},setBody:function(a){this.body.innerHTML=a},setHeader:function(a){this.header.innerHTML=a},setFooter:function(a){this.footer.innerHTML=a},show:function(){this._window.focus()},destroy:function(){this._window.close()},onceReady:function(a){if(this.ready){a.call(this)}else{this._readyQueue.push(a)}return this}};ExternalPopup.all=new Object();ExternalPopup.includeScripts=["utilities","jquery","plugin","yui"];
/* COPYRIGHT SAIC Pty Ltd, 2013
 * mouse.js - utilities/
 * Written by Ashley Hall
 * this script keeps record of most mouse interactions in a cross-browser
 * way
 */
"use strict";var currentMouseStats=null;var pressMouseStats=null;var releaseMouseStats=null;var DEBUG_MOUSE=false;var currentMouse={x:0,y:0,left:false,right:false,middle:false,shift:false,alt:false,ctrl:false};var lastMousePress={x:null,y:null,left:null,right:null,middle:null,shift:null,alt:null,ctrl:null};var lastMouseRelease={x:null,y:null,left:null,right:null,middle:null,shift:null,alt:null,ctrl:null};function setMouseStuff(b,d,c,a){if(isDefined(d)){b.x=d.x;b.y=d.y}if(isDefined(c)){b.left=c.left;b.right=c.right;b.middle=c.middle}if(isDefined(a)){b.shift=a.shift;b.alt=a.alt;b.ctrl=a.ctrl}}function getMouseCoordinates(a){return{x:a.clientX,y:a.clientY}}function getMouseButtons(a){if(!a.which){return{left:a.button&1,right:a.button&2,middle:a.button&4}}return{left:a.which==1,right:a.which==3,middle:a.which==2}}function getMouseModifiers(a){return{shift:a.shiftKey,alt:a.altKey,ctrl:a.ctrlKey}}function mousemove(a){a=a||event;setMouseStuff(currentMouse,getMouseCoordinates(a));if(a.button){setMouseStuff(currentMouse,null,getMouseButtons(a))}setMouseStuff(currentMouse,null,null,getMouseModifiers(a));printMouseStats(currentMouseStats,currentMouse)}attachListener(document,"mousemove",mousemove);function mousedown(c){c=c||event;var d=getMouseCoordinates(c);var b=getMouseButtons(c);var a=getMouseModifiers(c);setMouseStuff(lastMousePress,d,b,a);setMouseStuff(currentMouse,d,{left:b.left||currentMouse.left,right:b.right||currentMouse.right,middle:b.middle||currentMouse.middle},a);printMouseStats(currentMouseStats,currentMouse);printMouseStats(pressMouseStats,lastMousePress)}attachListener(document,"mousedown",mousedown);function mouseup(c){c=c||event;var d=getMouseCoordinates(c);var b=getMouseButtons(c);var a=getMouseModifiers(c);setMouseStuff(lastMouseRelease,d,b,a);setMouseStuff(currentMouse,d,{left:!b.left&&currentMouse.left,right:!b.right&&currentMouse.right,middle:!b.middle&&currentMouse.middle},a);printMouseStats(currentMouseStats,currentMouse);printMouseStats(releaseMouseStats,lastMouseRelease)}attachListener(document,"mouseup",mouseup);attachListener(document,"contextmenu",mouseup);function startDebuggingMouse(){if(currentMouseStats!=null||pressMouseStats!=null||releaseMouseStats!=null){currentMouseStats.onceReady(function(a){a.show()});pressMouseStats.onceReady(function(a){a.show()});releaseMouseStats.onceReady(function(a){a.show()});return}currentMouseStats=new ExternalPopup();pressMouseStats=new ExternalPopup();releaseMouseStats=new ExternalPopup();currentMouseStats.onceReady(function(a){a.setHeader("Mouse currently:")});pressMouseStats.onceReady(function(a){a.setHeader("When mouse was last pressed:")});releaseMouseStats.onceReady(function(a){a.setHeader("When mouse was last released:")});startDebuggingMouse()}if(DEBUG_MOUSE){attachListener(window,"load",startDebuggingMouse)}function stopDebuggingMouse(){currentMouseStats.destroy();currentMouseStats=null;pressMouseStats.destroy();pressMouseStats=null;releaseMouseStats.destroy();releaseMouseStats=null}function printMouseStats(a,b){if(!isDefined(a)||!a.ready){return}a.setBody("x:&emsp;"+b.x+"<br />y:&emsp;"+b.y+"<br /><br />left:&emsp;"+b.left+"<br />right:&emsp;"+b.right+"<br />middle:&emsp;"+b.middle+"<br /><br />shift:&emsp;"+b.shift+"<br />alt:&emsp;"+b.alt+"<br />ctrl:&emsp;"+b.ctrl+"<br />")}
/*COPYRIGHT SAIC Pty Ltd
 * mouseclick.js - utilities
 * Written by Ashley Hall
 * redefines a 'mouse click' to be a mouse down an element, and a mouse
 * up off the element to within X pixels of the mouse down
 */
"use strict";var NEARNESS=10;var clickIdFunctionMap=new Object();function newClickObject(c,a){var b={functionIds:[],functions:new Object(),handle:null,obj:c};clickIdFunctionMap[a]=b;b.handle=function(d){mouseup(d);if(isNear(lastMousePress,lastMouseRelease,NEARNESS)){runClickFunctions(a)}};attachListener(c,"mouseup",b.handle)}function runClickFunctions(a){var b=clickIdFunctionMap[a].functions;for(var c in b){b[c]()}}function doAfterClick(b,f,d,a){if(!isDefined(d)||!isDefined(a)){d=document;a="document"}if(isUndefined(clickIdFunctionMap[a])){newClickObject(d,a)}var c=clickIdFunctionMap[a];if(isUndefined(c.functions[f])){c.functionIds.push(f)}c.functions[f]=b}function removeClickFunction(f,a){if(!isDefined(a)){a="document"}var c=clickIdFunctionMap[a];var d=c.functions;var b=c.functionIds;if(!isDefined(f)){c.functions=new Object();c.functionIds=[]}else{findAndDo(b,f,function(g){delete c.functions[f];b.splice(g,1)});if(b.length>0){return}}detachListener(c.obj,"mouseup",c.handle);delete clickIdFunctionMap[a]}var clickReadyIdFunctionMap=new Object();function newClickReadyObject(c,a){var b={functionIds:[],functions:new Object(),handle:null,obj:c,ran:false};clickReadyIdFunctionMap[a]=b;b.moveHandle=function(){if(!b.ran&&(currentMouse.left||currentMouse.right||currentMouse.middle)&&isNear(lastMousePress,currentMouse,NEARNESS)){runClickReadyFunctions(a)}};attachListener(c,"mousemove",b.moveHandle);b.downHandle=runClickReadyFunctions.callLater(a);attachListener(c,"mousedown",b.downHandle)}function runClickReadyFunctions(a){var b=clickReadyIdFunctionMap[a];var c=b.functions;b.ran=true;for(var f in c){c[f]()}var d=clickAwayIdFunctionMap[a];if(!isUndefined(d)){d.ran=false}}function doAfterClickReady(b,f,d,a){if(!isDefined(d)||!isDefined(a)){d=document;a="document"}if(isUndefined(clickReadyIdFunctionMap[a])){newClickReadyObject(d,a)}var c=clickReadyIdFunctionMap[a];if(isUndefined(c.functions[f])){c.functionIds.push(f)}c.functions[f]=b}function removeClickReadyFunction(f,a){if(!isDefined(a)){a="document"}var c=clickReadyIdFunctionMap[a];var d=c.functions;var b=c.functionIds;if(!isDefined(f)){c.functions=new Object();c.functionIds=[]}else{findAndDo(b,f,function(g){delete c.functions[f];b.splice(g,1)});if(b.length>0){return}}detachListener(c.obj,"mousemove",c.moveHandle);detachListener(c.obj,"mousedown",c.downHandle);delete clickReadyIdFunctionMap[a]}var clickAwayIdFunctionMap=new Object();function newClickAwayObject(b,a){var c={functionIds:[],functions:new Object(),moveHandle:null,leaveHandle:null,upHandle:null,obj:b,ran:false};clickAwayIdFunctionMap[a]=c;c.moveHandle=function(){if(!c.ran&&(currentMouse.left||currentMouse.right||currentMouse.middle)&&!isNear(lastMousePress,currentMouse,NEARNESS)){runClickAwayFunctions(a)}};attachListener(b,"mousemove",c.moveHandle);c.leaveHandle=function(){if(!c.ran&&(currentMouse.left||currentMouse.right||currentMouse.middle)){runClickAwayFunctions(a)}};attachListener(b,"mouseout",c.leaveHandle);c.upHandle=runClickAwayFunctions.callLater(a);detachListener(b,"mouseup",c.upHandle)}function runClickAwayFunctions(a){var f=clickAwayIdFunctionMap[a];var c=f.functions;f.ran=true;for(var d in c){c[d]()}var b=clickReadyIdFunctionMap[a];if(!isUndefined(b)){b.ran=false}}function doAfterClickAway(b,d,c,a){if(!isDefined(c)||!isDefined(a)){c=document;a="document"}if(isUndefined(clickAwayIdFunctionMap[a])){newClickAwayObject(c,a)}var f=clickAwayIdFunctionMap[a];if(isUndefined(f.functions[d])){f.functionIds.push(d)}f.functions[d]=b}function removeClickAwayFunction(d,a){if(!isDefined(a)){a="document"}var f=clickAwayIdFunctionMap[a];var c=f.functions;var b=f.functionIds;if(!isDefined(d)){f.functions=new Object();f.functionIds=[]}else{findAndDo(b,d,function(g){delete f.functions[d];b.splice(g,1)});if(b.length>0){return}}detachListener(f.obj,"mousemove",f.moveHandle);detachListener(f.obj,"mouseout",f.leaveHandle);detachListener(f.obj,"mouseup",f.upHandle);delete clickAwayIdFunctionMap[a]}var debugMouseClickWindow=null;var DEBUG_CLICK=false;if(DEBUG_CLICK){attachListener(window,"load",startClickDebugging)}function startClickDebugging(){if(debugMouseClickWindow!=null){return}debugMouseClickWindow=new ExternalPopup({resizable:false});debugMouseClickWindow.onceReady(function(){debugMouseClickWindow.setHeader("Debugging Document Mouse Click Events");debugMouseClickWindow.show();doAfterClick(setTimeout.callLater(function(){debugMouseClickWindow.setBody("Click at <br />x="+currentMouse.x+", y="+currentMouse.y)},50),"debugging");doAfterClickReady(invokeLater.call(debugMouseClickWindow,"setBody",["Ready for click"]),"debugging");doAfterClickAway(invokeLater.call(debugMouseClickWindow,"setBody",["Away from click"]),"debugging")})}function stopClickDebugging(){removeClickFunction("debugging");removeClickAwayFunction("debugging");removeClickReadyFunction("debugging");debugMouseClickWindow.destroy();debugMouseClickWindow=null}
/* COPYRIGHT SAIC Pty Ltd, 2013
 * drawing.js - utilities/
 * Written by Ashley Hall
 * implements a number of utility functions to do with drawing in the DOM
 * strictly in XHTML1.0/CSS2 aherence without using canvases
 */
"use strict";function testDrawing(a){drawTriangle({left:50,top:100,width:100,height:200},{point:"south",skew:0.5,colour:"yellow"},a);drawTriangle({left:50,top:100,width:100,height:200},{point:"south",skew:-0.5,colour:"yellow"},a);drawTriangle({left:150,top:0,width:200,height:100},{point:"east",skew:-0.5,colour:"blue"},a);drawTriangle({left:150,top:0,width:200,height:100},{point:"east",skew:0.5,colour:"blue"},a);drawCircle({x:100,y:50},{radius:25,colour:"green"},a)}function drawTriangle(f,g,d,h,i){if(!isDefined(g.skew)){g.skew=0}if(!isDefined(g.colour)){g.colour="black"}var b=new Object();var a="px solid transparent";var c="px solid "+g.colour;var j=[(1+g.skew)/2,(1-g.skew)/2];if(g.point=="north"||g.point=="south"){b.borderLeft=(j[0]*f.width)+a;b.borderRight=(j[1]*f.width)+a;if(g.point=="north"){b.borderBottom=f.height+c}else{b.borderTop=f.height+c}}else{b.borderTop=(j[0]*f.height)+a;b.borderBottom=(j[1]*f.height)+a;if(g.point=="east"){b.borderLeft=f.width+c}else{b.borderRight=f.width+c}}return insertDrawing({x:f.left,y:f.top},b,d,h,i)}function drawLine(h,c,a,f,g){if(!isDefined(c.width)){c.width=1}if(!isDefined(c.colour)){c.colour="black"}if(!isDefined(c.type)){c.type="solid"}var d=new Object();if(c.direction=="north"){h.y-=c.length}if(c.direction=="west"){h.x-=c.length}var b=c.width+"px "+c.type+" "+c.colour;if(c.direction=="east"||c.direction=="west"){d.borderTop=b;d.width=c.length+"px";h.y-=Math.floor(c.width/2)}else{d.borderLeft=b;d.height=c.length+"px";h.x-=Math.floor(c.width/2)}return insertDrawing({x:h.x,y:h.y},d,a,f,g)}function drawCircle(f,b,a,c,d){if(!userAgent.Firefox){f.x-=b.radius}return drawLine(f,{colour:b.colour,type:"dotted",width:b.radius*2,length:b.radius*2,direction:"east"},a,c,d)}function drawSquare(f,b,a,c,d){f.x-=Math.floor(b.width/2);return drawLine(f,{colour:b.colour,type:"solid",width:b.width,length:b.width,direction:"east"},a,c,d)}function drawApproxEllipse(i,k,g,o,q){if(!isDefined(k)){k={}}var b=k.colour;if(!isDefined(b)){b="black"}var h=k.precision;if(!isDefined(h)){h=10}var c=drawBox(i,null,g,o,q);var a;if(isDefined(k.border)){a=k.border.width;if(!isDefined(a)){a=1}drawApproxEllipse({left:-a,top:-a,width:i.width+2*a,height:i.height+2*a},{colour:k.border.colour,precision:h},c)}var m={width:i.width/2,height:i.height/2};var j=Math.PI/(2*h);var l=[{colour:b,skew:1,point:"north"},{colour:b,skew:1,point:"south"},{colour:b,skew:-1,point:"north"},{colour:b,skew:-1,point:"south"}];var n={x:m.width,y:0,theta:0};var r={x:null,y:null,theta:null};var p={x:null,y:null,top:null,left:null,bottom:null,right:null};var f=true;for(var d=1;d<=h;++d){r.theta=d*j;r.x=Math.floor(m.width*Math.cos(r.theta));r.y=Math.floor(m.height*Math.sin(r.theta));if(!f){p.x=m.width-n.x;p.y=m.height-n.y;drawBox({left:p.x,top:p.y},{backgroundColor:b,right:p.x+"px",bottom:p.y+"px"},c,null,q)}else{f=false}p.x=n.x-r.x;p.y=r.y-n.y;p.left=m.width-n.x;p.top=m.height-n.y-p.y;p.bottom=m.height+n.y;p.right=m.width+n.x-p.x;drawTriangle({left:p.left,top:p.top,width:p.x,height:p.y},l[0],c,null,q);drawTriangle({left:p.left,top:p.bottom,width:p.x,height:p.y},l[1],c,null,q);drawTriangle({left:p.right,top:p.top,width:p.x,height:p.y},l[2],c,null,q);drawTriangle({left:p.right,top:p.bottom,width:p.x,height:p.y},l[3],c,null,q);n.x=r.x;n.y=r.y;n.theta=r.theta}return c}function testApproxEllipseDraw(b){if(!isDefined(b)){b=document.body}for(var a=15;a>0;--a){drawApproxEllipse({left:50,top:100,width:1000,height:500},{colour:"green",border:{colour:"red",width:1},precision:a},b);if(a>5){a=6}}}function drawEllipse(d,h,c,n,o){if(!isDefined(h)){h={}}var a=h.colour;if(!isDefined(a)){a="black"}var g=null;if(isDefined(h.opacity)){g="alpha(opacity="+Math.ceil(h.opacity*100/((d.width>d.height)?d.width/2:d.height/2))+")"}var b=drawBox(d,(g)?{opacity:h.opacity}:null,c,n,o);var m={width:d.width/2,height:d.height/2};var l,j;var f=function(){var p=drawBox({left:m.width-l,top:m.height-j,width:l*2,height:j*2},{backgroundColor:a},b);if(g){p.style.filter=g}};var k,i;if(d.height>d.width){k=m.width/2;i=Math.floor(m.height*Math.sin(Math.acos(k/m.width)))}else{i=m.height/2;k=Math.floor(m.width*Math.cos(Math.asin(i/m.height)))}for(j=i;j<m.height;++j){l=roundHalfUp(m.width*Math.cos(Math.asin(j/m.height)));f()}for(l=k;l<m.width;++l){j=roundHalfUp(m.height*Math.sin(Math.acos(l/m.width)));f()}return b}function drawEllipseOutline(f,g,d,p,q){if(!isDefined(g)){g={}}var a=g.colour;if(!isDefined(a)){a="black"}var c=drawBox(f,null,d,p,q);var n={width:f.width/2,height:f.height/2};var b={width:g.thickness,colour:a,length:null,direction:null};var l,i;var o;var m=function(){b.length=l-o;o=l;b.direction="east";drawLine({x:n.width-l,y:n.height-i},b,c).className="subdrawing";drawLine({x:n.width-l,y:n.height+i},b,c).className="subdrawing";b.direction="west";drawLine({x:n.width+l,y:n.height-i},b,c).className="subdrawing";drawLine({x:n.width+l,y:n.height+i},b,c).className="subdrawing"};var k=function(){b.length=i-o;o=i;b.direction="south";drawLine({x:n.width-l,y:n.height-i},b,c);drawLine({x:n.width+l,y:n.height-i},b,c);b.direction="north";drawLine({x:n.width-l,y:n.height+i},b,c);drawLine({x:n.width+l,y:n.height+i},b,c)};var j,h;if(f.height>f.width){j=n.width/2;h=Math.floor(n.height*Math.sin(Math.acos(j/n.width)))}else{h=n.height/2;j=Math.floor(n.width*Math.cos(Math.asin(h/n.height)))}o=0;for(i=n.height;i>=h;--i){l=roundHalfUp(n.width*Math.cos(Math.asin(i/n.height)));m()}o=0;for(l=n.width;l>=j;--l){i=roundHalfUp(n.height*Math.sin(Math.acos(l/n.width)));k()}return c}function drawBox(a,c,b,d,f){return insertDrawing({x:a.left,y:a.top,width:a.width,height:a.height},isDefined(c)?copyMap.call(c):new Object(),b,d,f)}var drawings=new Object();function insertDrawing(g,c,a,d,f){c.position="absolute";c.left=g.x+"px";c.top=g.y+"px";if(isDefined(g.width)){c.width=g.width+"px"}if(isDefined(g.height)){c.height=g.height+"px"}c.content='""';var b=a.makeElement("div",null,c);if(isDefined(d)){addDrawing(b,d)}return b}function addDrawing(b,a){if(isUndefined(drawings[a])){drawings[a]=[]}drawings[a].push(b)}function removeDrawing(c,b){var a;if(isDefined(b)&&!isUndefined(a=drawings[b])){findAndDo(a,c,function(d){a.splice(d,1)})}c.safeRemove()}function removeDrawings(b){var a=drawings[b];if(!isDefined(a)){return false}a.iterate(function(c){c.safeRemove()});delete a[b];return true}
/* COPYRIGHT SAIC Pty Ltd, 2013
 * debugging.js - utilities
 * Written by Ashley Hall
 * implements functions developers can use either in the console or inline
 * to aid in their processes
 */
"use strict";var CONSOLE_TYPES=null;var CONSOLE_FUNCS=null;function consolePrint(c,b){if(CONSOLE_TYPES==null){CONSOLE_TYPES="LDIWE";CONSOLE_FUNCS=["log","debug","info","warn","error"]}var a;if(!isDefined(b)){b=0}else{b=CONSOLE_TYPES.indexOf(b)}if(window.console){a=0;while(b>=0){if(isDefined(console[CONSOLE_FUNCS[b]])){if(isArray(c)){console[CONSOLE_FUNCS[b]].apply(console,c)}else{console[CONSOLE_FUNCS[b]].call(console,c)}return a}++a;--b}}else{a=-1}return a}var debugWindow=null;var DEBUG_WINDOW_ID="debugwindow";function debugOutput(a){if(debugWindow==null){debugWindow=new ExternalPopup();debugWindow.onceReady(function(){debugWindow.setHeader("Debugging window");debugWindow.setBody("Use setBody() to write html here.<br />Use hide() and show() toggle visibility");debugWindow.setFooter("test")});debugWindow.destroyEvent.subscribe(function(){debugWindow=null})}debugWindow.onceReady(function(){debugWindow.setBody(a);debugWindow.show()})}function alertMessage(b,a){if(isUndefined(b)){b="UNDEFINED"}return new ExternalPopup({title:a}).onceReady(function(){this.setBody(b);this.show()})}function debugObject(c,b){if(!isDefined(b)){b="anonymous"}var a=new Object();a[b]=c;return debugGlobalObject([b],a);onceReady(function(){this.setFooter("")})}function debugObjectReference(b,a){if(!isDefined(a)){a="anonymous"}return debugGlobalObject([a],function(){var c=new Object();c[a]=b();return c})}function debugGlobalObject(c,a){if(!isDefined(a)){a=window}if(!isFunction(a)){a=(function(f){return f}).callLater(a)}c=c.slice(0);var d=c[0];var b=new RegExp("[^A-Za-z_]");c.iterate(function(f){if(f.isInteger()){d+="["+f+"]"}else{if(b.test(f)){d+='["'+f+'"]'}else{d+="."+f}}},null,1);return(new ExternalPopup({title:"Debugging object"})).onceReady(function(){debugGlobalObject._setup.call(this,a,c,d)})}debugGlobalObject._refresh=function(root,path){var obj;var keys=[];try{obj=getObject.call(root(),path);if(isDefined(obj)){keys=alphanumericSort(properties.call(obj))}}catch(e){this.setBody(e);return}this.body.innerHTML="";var element=this.body.makeElement("div",null,{fontWeight:"bold"});var tempDiv=element.makeElement("div");tempDiv.makeElement("span",null,{color:"blue"},"Value [toString()]: ");tempDiv.makeElement("textarea",{cols:"20",rows:"2",readonly:"readonly"},{color:"orange",overflow:"auto",width:"100%",border:"none",backgroundColor:"transparent",resize:"vertical",fontWeight:"bold"},obj+"");tempDiv=element.makeElement("div");tempDiv.makeElement("span",null,{color:"blue"}).innerHTML="Type: ";tempDiv.makeElement("span",{"class":"divspan"},{whiteSpace:"pre-wrap",color:"orange"}).innerHTML=(isDefined(obj)&&isObject(obj))?typeOf.call(obj):typeof obj;var runButton;if(isFunction(obj)){this.body.createText("this.");runButton=this.body.makeElement("button",{type:"button"},null,"apply");this.body.createText("(parent, [");runButton.onclick=(function(input){window.debuggingfunction=obj.makeStandalone(getObject.call(root(),path.slice(0,-1)));eval('debugObject(window["debuggingfunction"]('+input.value+'), "testcall");')}).callLater(this.body.makeElement("input",{type:"text"}));this.body.createText("])");if(keys.length>0){this.body.makeElement("hr")}}var table=this.body.makeElement("table");keys.iterate(function(data){var row=table.makeElement("tr");var type=row.makeElement("td",null,{textAlign:"right"});if(isDefined(obj[data])){type.innerHTML=(isObject(obj[data]))?typeOf.call(obj[data]):(typeof obj[data]);if(isFunction(obj[data])){type.style.color="green"}else{if(!isDefined(obj[data].typeOf)){type.style.color="aqua"}else{if(typeOf.call(obj[data])!=="Object"){type.style.color="blue"}}}row.makeElement("td").createJavascriptLink(data,(function(data){return function(){var dataPath=path.slice(0);dataPath.push(data);debugGlobalObject(dataPath,root)}})(data)).style.color="gray"}else{type.innerHTML=(obj[data]===null)?"null":"undefined";type.style.color="red";row.makeElement("td").makeElement("span",null,null,data)}});this.body.makeElement("hr");this.body.createText("(function() {");element=this.body.makeElement("textarea",{cols:"10",rows:"2"},{width:"100%",resize:"vertical"});this.body.makeElement("br");this.body.createText("}).");this.body.makeElement("button",{type:"button"},null,"call").onclick=(function(input){eval('window["debuggingfunction"] = function() {'+input.value+"}");debugObject(window.debuggingfunction.call(obj))}).callLater(element);this.body.createText("(this)")};debugGlobalObject._setup=function(i,k,d){var h=debugGlobalObject._refresh.callLaterOn(this,[i,k]);this.header.innerHTML="Debugging object: ";this.header.makeElement("span",null,{color:"yellow"},d);var f;var b;var g=null;var a=function(){f.style.visibility="hidden";b.onclick=c;b.innerHTML="Stop watching";b.style.fontWeight="bold";g=setInterval(h,750);return false};var c=function(){b.onclick=a;b.innerHTML="Watch";b.style.fontWeight="";f.style.visibility="";clearInterval(g);g=null;return false};this.setFooter("");var j=this.footer.makeElement("div");f=j.createJavascriptLink("Refresh",h);b=j.createJavascriptLink("Watch",a);b.setStyles({cssFloat:"right"});this.destroyEvent.subscribe(function(){if(g!=null){clearInterval(g)}});h();this.show()};function debugObjectToTable(c,g,i){if(!isDefined(i)){i=document}if(isUndefined(g)){g=true}var j=i.createElement("table");var k;var h;var d;k=j.makeElement("tr");h=k.makeElement("th");h.colSpan="2";h.innerHTML=escapeHTML(c);var f=function(l){l=l.nextSibling.firstChild;l.style.display=(l.style.display=="none")?"":"none"};var a;for(var b in c){a=!isDefined(c[b]);k=j.makeElement("tr");h=k.makeElement("td");h.valign="top";if(a){h.makeElement("span",null,{color:"red"},b)}else{h.createJavascriptLink(b,f.callLater(h))}h=k.makeElement("td");if(!a){d=h.makeElement("pre",null,null,c[b]);if(isUndefined(g)||g==false){d.style.display="none"}}}return j}function debugArray(c,a,b){if(!isDefined(a)){a="anonymous"}(new ExternalPopup()).onceReady(function(){this.setHeader(a);this.setBody("");this.body.appendChild(debugObjectToTable(c,b,this._document));this.show()})}insertCss([[".errormsgpopup",{position:"fixed",bottom:"0px",left:"0px",right:"0px",textAlign:"center",zIndex:"10"}],[".errormsgpopup > span",{backgroundColor:"red",border:"2px ridge gray",opacity:0.7,color:"white",textDecoration:"underline",fontWeight:"bold",cursor:"pointer"}]]);var _ERRORS_=[];var errorFuncs=new Object();window.onerror=(function(a){return function(g,f,c){var b=_ERRORS_.length;_ERRORS_.push({message:g,file:f,line:c});var d=false;enumerate.call(errorFuncs,function(k,i){var h;try{h=i(b);if(!d&&isDefined(h)&&h===false){d=true}}catch(j){consolePrint("Error in error listener!","E");consolePrint(j,"E")}});if(d){return false}if(isDefined(a)){a.apply(this,arguments)}}})(window.onerror);function onError(b,a){errorFuncs[b]=a}function cancelOnError(a){delete errorFuncs[a]}onError("errorpopup",function(a){var c=document.body.makeElement("div",{"class":"errormsgpopup"});var b=c.makeElement("span",null,{opacity:0});b.createText("An error has occurred");b.onclick=debugObject.callLater(_ERRORS_[a],"Javascript error");showErrorPopup(c,b)}.makeAsynchronous());function showErrorPopup(d,b){var c=d.offsetHeight;var a;a=function(){c=cap(c-2,0);d.style.bottom="-"+c+"px";if(c>0){setTimeout(a,50);return}setTimeout(hideErrorPopup.callLater(d),3000)};a();b.setStyles({opacity:""})}function hideErrorPopup(c){var b=0;var a;a=function(){b+=2;c.style.bottom="-"+b+"px";if(b<c.offsetHeight){setTimeout(a,50);return}c.safeRemove()};a()}
/* COPYRIGHT SAIC Pty Ltd, 2013
 * borders.js - utilities
 * Written by Ashley Hall
 * adds highlightable borders to divs which are clickable
 */
"use strict";insertCss([[".quadborder",{position:"absolute",visibility:"hidden"}],[".quadborder .edge",{opacity:0.2,cursor:"pointer",zIndex:"11",backgroundColor:"blue",position:"absolute"}],[".quadborder .clickbox",{zIndex:"10",backgroundColor:"magenta",opacity:0}],["body .quadborder.select .edge",{opacity:0.4}],[".quadborder.hiding .edge",{opacity:0}],[".quadborder.down .edge",{backgroundColor:"red"}],[".quadborder > div",{visibility:"visible"}],[[".quadborder .edge.left",".quadborder .edge.right"],{width:"6px",bottom:"3px",top:"3px"}],[[".quadborder .edge.top",".quadborder .edge.bottom"],{height:"6px"}],[[".quadborder .edge.top",".quadborder .edge.bottom",".quadborder .edge.left"],{left:"-3px"}],[[".quadborder .edge.top",".quadborder .edge.bottom",".quadborder .edge.right"],{right:"-3px"}],[".quadborder .edge.bottom",{bottom:"-3px"}],[".quadborder .edge.top",{top:"-3px"}]]);var borderedBoxesCount=0;var borderObjects=new Object();var borderIds=[];function addBorder(c,f,h,d,i){if(!isDefined(d)){d=c.parentNode}var b="boxborder"+(++borderedBoxesCount);var g=c.getCoordinates(d);var a=c.getDimensions();var j={id:b,div:d.makeElement("div",{"class":"quadborder",id:b},{left:g.x+"px",top:g.y+"px",width:a.width+"px",height:a.height+"px"}),persistantShow:false,leftEdge:null,rightEdge:null,topEdge:null,bottomEdge:null,selected:false,clickBox:null};j.leftEdge=j.div.makeElement("div",{"class":"left edge"});j.rightEdge=j.div.makeElement("div",{"class":"right edge"});j.topEdge=j.div.makeElement("div",{"class":"top edge"});j.bottomEdge=j.div.makeElement("div",{"class":"bottom edge"});j.clickBox=j.div.makeElement("div",{"class":"clickbox allspace"});borderObjects[b]=j;borderIds.push(b);if(!isDefined(f)||f){setupBorderInteractivity(j,h);hideBorder(b)}return j}function destroyBorders(){var a;borderIds.iterate(function(b){a=borderObjects[b];removeBorderInteractivity(a);a.div.safeRemove()});borderObjects=new Object();borderIds=[];borderGroups=new Object()}var borderGroups=new Object();function setupBorderInteractivity(a,c){if(isDefined(c)){if(isUndefined(borderGroups[c])){borderGroups[c]=[]}borderGroups[c].push(a.id)}var b=[a.leftEdge,a.rightEdge,a.topEdge,a.bottomEdge,a.clickBox];attachListener(b,"mouseenter",showBorder.callLater(a.id));attachListener(b,"mouseleave",hideBorder.callLater(a.id));b.iterate(function(f,d){var g=a.id+":"+d;doAfterClickReady(borderPressed.callLater(a.id),"press",f,g);doAfterClickAway(borderReleased.callLater(a.id),"release",f,g)});doAfterClick(function(){if(isDefined(c)){deselectAllIn(borderGroups[c])}borderSelected(a.id)},"click",a.div,a.id)}function hideBorder(a){borderObjects[a].div.addClass("hiding")}function showBorder(a){borderObjects[a].div.removeClass("hiding")}function borderPressed(a){borderObjects[a].div.addClass("down")}function borderReleased(a){borderObjects[a].div.removeClass("down")}function borderSelected(a){borderObjects[a].div.addClass("select")}function borderDeselected(a){borderObjects[a].div.removeClass("select")}function deselectAllIn(a){if(!isDefined(a)){a=borderIds}a.iterate(borderDeselected)}function removeBorderInteractivity(b){removeClickFunction(null,b.id);var c;for(var a=0;a<4;++a){c=b.id+":"+a;removeClickReadyFunction(null,c);removeClickAwayFunction(null,c)}};