var ModalActionUtil = (function() {
	var cookieName = "nextModalAction";
	var delim = "%";
	
	return {
		validateAndShowModal : function(pageID, docID, signedIn) {
			var nextModalAction = this.getNextModalAction(pageID, docID);
			this.resetNextModalAction();
			if (nextModalAction) {
				var action = "", actionStatus = "";
				actionStatus = nextModalAction.substring(nextModalAction
						.lastIndexOf(delim) + 1);
				action = nextModalAction.substring(0, nextModalAction
						.lastIndexOf(delim));
				var chapterID;
				if (action && action.indexOf("#") > -1) {
					var temp = action.split("#");
					action = temp[0];
					chapterID = temp[1];
				}
				
				if (actionStatus === "ssoLoginAttempted" && signedIn == "true") {
					actionStatus = "loginSuccess";
				}
				if (actionStatus === "loginSuccess"
						|| actionStatus === "registrationSuccess"
						|| actionStatus === "registrationRequested"
						|| actionStatus === "loanSuccess"
						|| actionStatus === "downloadSuccess"
						|| actionStatus === "checkoutSuccess"
						|| actionStatus === "continueAsGuest") {
					var e = jQuery.Event("click");
					e.which = 13;
					if (action === "full_download" || action === "full_downloadButton") {
						if(actionStatus !== "downloadSuccess"){
							doAction($("[id^='tool_download_']"), actionStatus);
						}
					} else if (action === "full_downloadLink") {
						if(actionStatus !== "downloadSuccess"){
							doAction($("[id^='wizard_launcher_']"), actionStatus);
						}
					} else if (action === "add_to_bookshelf") {
						doAction($("[id^='tool_addbookshelf_']"), actionStatus);
					} else if (action === "chapter_d") {
						if (pageID === "reader") {
							$("#toolChapterDownload").trigger(e);
						} else if (pageID === "details") {
							var elem = $("[id^='tool_chapterdownload_" + docID + "_'][id$='_"+chapterID+"']");
							try{
								expandTOC(elem);
								if(isFocusable(elem)){
									elem.focus();
								}else{
									$("#chapter_readlink_"+chapterID).focus();
								}
							}catch(err){}
							
							if (actionStatus !== "loanSuccess" && actionStatus !== "registrationRequested"){
								elem.trigger(e);
							}
						}
					} else if (action === "q_download") {
						$("#toolDownload").trigger(e);
					} else if (action === "mediation_request" || action === "mediation_requestBtn") {
						var requestBtn = $("a[id^='requestAccessBtnId_']");
						if(requestBtn && requestBtn.length > 0){
							doAction(requestBtn, actionStatus);
						}else{
							focusNextToolbarItem($("[id^='requestAccessBtnId_disabled']"));
						}
					} if (action === "mediation_requestLink") {
						var requestLink = $("[id^='requestAccessLinkId_']");
						if(requestLink && requestLink.length > 0){
							doAction(requestLink, actionStatus);
						}else{
							$("#goto_toc_link").focus();
						}
					}
				}
			}
			
			function doAction($el, status){
				if(status === "registrationRequested"){
					$el.focus();
				} else {
					var e = jQuery.Event("click");
					e.which = 13;
					$el.trigger(e);
				}
			}
		},
		setNextModalAction : function(pageID, docID, action) {
			var key = getInstanceKey(pageID, docID);
			var newVal = key + delim + action;
			saveToSessionStorage(cookieName, newVal);
		},

		updateModalActionStatus : function(pageID, docID, status) {
			var key = getInstanceKey(pageID, docID);
			var valStr = getFromSessionStorage(cookieName);
			if (valStr.indexOf(key) > -1) {
				if(valStr.split(delim).length === 5){
					valStr = valStr.substring(0, valStr.lastIndexOf(delim));
				}
				valStr += delim + status;
				saveToSessionStorage(cookieName, valStr);
			}
		},

		getNextModalAction : function(pageID, docID) {
			var key = getInstanceKey(pageID, docID);
			var valStr = getFromSessionStorage(cookieName);
			if (key && valStr.indexOf(key) > -1) {
				valStr = valStr.substring(key.length + 1);
			}else{
				valStr = "";
			}
			return valStr;
		},

		resetNextModalAction : function() {
			saveToSessionStorage(cookieName, "");
		},
		
		focusNextToolbarItem : function(element){
			return focusNextToolbarItem(element);
		},
		
		isFocusable : function(element){
			return isFocusable(element);
		}
	};

	function getInstanceKey(pageID, docID) {
		var key = "";
		var channelName = window.location.pathname.split("/")[2];
		if (!channelName || !pageID) {
			return "";
		}
		key = channelName + delim + pageID + delim + docID;
		return key;
	}

	function saveToSessionStorage(key, val) {
		if (key) {
			sessionStorage.setItem(key, val);
		}
	}

	function getFromSessionStorage(key) {
		var val = sessionStorage.getItem(key);
		if (val == null) {
			val = "";
		}
		return val;
	}
	


	function expandTOC(elem) {
		if(!(elem && elem.length > 0)){
			return;
		}
		var sub = elem.parent().closest('[id^="chapter_sub_"]');
		if (!(sub && sub.length > 0)) {
			return;
		}

		var toogle_btn = sub.siblings(".subsection-toggle-row").find(
				'a[href^="#chapter_sub"]');
		var e = jQuery.Event("click");
		e.which = 13;
		toogle_btn.trigger(e);//Trigger subsection link to Expand TOC

		expandTOC(sub);
	}
	
	function focusNextToolbarItem(element){
		var $nextFocusableItem = $(element).nextAll("button,a").each(function(){
			if(isFocusable(this)){
				$(this).focus();
				return false;
			}
		});
	}
	

	function isFocusable(element) {
		return (element && $(element).length > 0
				&&  $(element).css('display') != 'none' 
				&& !($(element).attr("disabled") && $(element).attr("disabled") === "disabled")
				&& !$(element).hasClass("hide") && !($(element)
				.attr("tabindex") && $(element).attr("tabindex") === "-1"));
	}
}());
