/**
 * Handles Injection of Sky Ad into Article Body
 */
(function($) {
	var start = new Date().getTime();

	function moveAdInline() {
		// Move Ad inline below the first paragraph
		var skyAdSelector = '#dfp-ad-sky_1_160_600_0-wrapper, .block-dfp-sky-1-160-600';
		var $skyAd = $(skyAdSelector);
		var bodySecondParagraph = $('.node-article .body.field > p:first');


		// Check to see if Sky Ad and Body Location are available
		if($skyAd.length > 0 && bodySecondParagraph.length > 0) {
			$skyAd.insertAfter(bodySecondParagraph);
		
			if(googletag) {
				// Ad slot for static load
				var skyAdGptSlot = 'sky_1_160_600';
				// Ad slot for Lazy Load
				var skyAdGptSlotLazyLoad = 'sky_1_160_600_0';

				// Refresh single slot for static or lazy load if available
				if(googletag.slots && googletag.slots[skyAdGptSlot]) {
					googletag.pubads().refresh([googletag.slots[skyAdGptSlot]]);
				} else if(googletag.slots && googletag.slots[skyAdGptSlotLazyLoad]) {
					googletag.pubads().refresh([googletag.slots[skyAdGptSlotLazyLoad]]);
				} else {
					console.warn('Unable to find GPT Sky Ad Static slot [\'' + skyAdGptSlot + '\'] or GPT Sky Ad Lazy Load slot [\'' + skyAdGptSlotLazyLoad + '\']; falling back to refrehing all ads');
					googletag.pubads().refresh();
				}
			}
			else {
				$skyAd.hide();
			}
			clearInterval(interval);
		} else {
			if (start + 3000 < (new Date().getTime())) {
				console.warn('Sky Ad block not found, cannot inject. Please confirm hook selector: [\'' + skyAdSelector + '\']');
				clearInterval(interval);
			} else {
				return;
			}
		}
	}

	var interval = setInterval(moveAdInline, 500);
})(jQuery);

/**
 * Add omniture and ad refresh triggers on Slideshow
 */
jQuery(document).ready(function($) {
	// Flexslider base element; exposes bindable triggers
	$flexSlider = $('.flexslider');

	var mobileBreakpoint = 768;

	// Triggers on (before) slide change
	$flexSlider.bind('before', function(event) {
		//  Register a page view in omniture
		if(s !== undefined && s.t !== undefined) {
			s.t();
		}
		// If not can't detect breakpoint or below mobile breakpoint, no Ad refresh
		if (!window.matchMedia || !window.matchMedia('(min-width: ' + mobileBreakpoint + 'px)').matches) {
			return;
		}

		// If googletag object is available
		if (googletag && googletag.pubads) {
			// Refresh all loaded Ads
			googletag.pubads().refresh();
		}

	})
});