// Conditional field display rules for pagination
(function ($) {
    Drupal.behaviors.UBMHideAbsractNotOnFirstPage = {
        attach: function (context, settings) {
            var isSmartPagingActive = $('.smart-paging-pager').length > 0;
            var isLastPageActive = $('.smart-paging-pager .current.last').length > 0;
            var isFirstPageActive = $('.smart-paging-pager .current.first').length > 0;

            var $fieldReferencDisclosuresContainers = $('.node-article .field-name-field-disclosures, .node-article .field-name-references');
            var $fieldAbstractContainer = $('.node-article .field-name-field-abstract');

            if (isSmartPagingActive) {
                // Hide References and/or Disclosure fields unless on last page of Article
                if (!isLastPageActive) {
                    $fieldReferencDisclosuresContainers.hide();
                }
                // Hide Abstract / Synopsis field unless on the first page of the Article
                if (!isFirstPageActive) {
                    $fieldAbstractContainer.hide();
                }
            }
        }
    };

    Drupal.behaviors.UBMDisplayAnswerPollIssue = {
        attach: function (context, settings) {
            if (typeof PollAnon == 'undefined' || !PollAnon.nid) {
                return;
            }

            var cookieName = 'pa-' + PollAnon.nid;

            if ($.cookie(cookieName)) {
                $('.field-name-field-results-blurb').show();
            } else {
                $('.field-name-field-results-blurb').hide();
            }
        }
    };
})(jQuery);