/**
 * @file
 * Attaches behaviors for DFP Lazy Load module.
 */

(function ($) {
  Drupal.behaviors.dfpLazyLoad = {
    attach: function (context, settings) {
      if (context !== document) {
        return;
      }
      var config = settings.dfp_lazy_load || {};
      Object.keys(config).forEach(function (slot) {
        var element = document.getElementById('dfp-ad-' + slot);
        if (element) {
          if (config[slot]) {
            new Waypoint.Inview({
              element: element,
              enter: function () {
                if (!this.element.classList.contains('ad-loaded')) {
                  googletag.pubads().refresh([googletag.slots[slot]]);
                  this.element.classList.add('ad-loaded');
                }
              }
            });
          }
          else {
            googletag.pubads().refresh([googletag.slots[slot]]);
            element.classList.add('ad-loaded');
          }
        }
      });
    }
  };
})(jQuery);
