(function($) {

  var groupHandler = function (group, stickyAds, slot, index, arr) {
    var $block = $('#dfp-ad-' + slot),
      topBarWidth = $('body').width() < 1024 ? 80 : 50;

    if (!$block) {
      return;
    }

    if (stickyAds.indexOf(slot) !== -1) {
      $block.data('stickyWaypoint', new Waypoint.Sticky({
        element: $block,
        offset: topBarWidth
      }));
    }

    if (index !== 0) {
      var $prev = $('#dfp-ad-' + arr[index - 1]);

      if (!$prev.data('stickyWaypoint')) {
        return;
      }

      var scrollHandler = function () {
        var top = $block.offset().top - $(window).scrollTop();
        $prev.css('top', top - $prev.height() - 25);
      };
      $block.data('scrollWaypoint', new Waypoint({
        element: $block,
        handler: function (direction) {
          if (direction === 'down') {
            window.addEventListener('scroll', scrollHandler);
          }
          if (direction === 'up') {
            window.removeEventListener('scroll', scrollHandler);
            $prev.css('top', '');
          }
        },
        offset: function() {
          return topBarWidth + $prev.height() + 25;
        },
        group: group
      }));
    }
  };

  Drupal.behaviors.dfpStickyAds = {
    attach: function (context, settings) {
      if (context !== document || $('body', context).width() < 1100) {
        return;
      }
      var contentAds = ['top_728_90', 'sky_1_160_600', 'bottom_728_90'];
      var sidebarAds = ['rec1_300_250', 'rec2_300_250', 'clone_of_rec2_300_250'];

      var stickyAds = settings.ubm_sticky_ads.filter(function(item) {
        return item !== 'sky_1_160_600';
      });

      var filterVisibleAds = function(slot) {
        var $block = $('#dfp-ad-' + slot);
        return ($block && $block.is(':visible') && $block.height() > 1);
      };

      contentAds
        .filter(filterVisibleAds)
        .forEach(groupHandler.bind(null, 'content', stickyAds));
      sidebarAds
        .filter(filterVisibleAds)
        .forEach(groupHandler.bind(null, 'sidebar', stickyAds));
    }
  };
})(jQuery);