/**
 * Custom javascript for SM
 * 
 */

(function($) {

  $(document).ready(function() {

    //// Form styles
    var placeholderSupported = !!( 'placeholder' in document.createElement('input') );

    // Publication and news searchbox

    // Wrap advanced search submit in row element, if it isn't already
    $('form#advanced #search-sort-field > input:submit').wrap('<div class="searchRow"/>');

    // Iterate over search rows
    $('form#advanced .searchRow').each(function(i, j) {
      $('input:text', j).each(function() {
        $(this).attr('tabindex',i);
        var ph = $(this).prev('label').text();

        //   If device does not support placeholder attribute, use blur/focus instead.
        if (placeholderSupported === true) {
          $(this).attr({'placeholder':ph});
        }
        else {
          if (this.value === '') {
            this.value = this.defaultValue;
          }
          // alert(this.value);
          $(this).bind({
            focus: function() {
              if (this.value === ph) {
                this.value = '';
              }
            },
            blur: function() {
              if (this.value === '') {
                this.value = ph;
              }
            }
          });
        }


      });

      $('select', j).attr('tabindex',i).selectbox();

      // Add value to options
      $('select[name=year] option', j).each(function() {
        $this = $(this);
        $this.attr('value', $this.attr('value'));
      });
      $('select[name=year]', j).attr('tabindex',i).selectbox();
      
      $('input:submit', j).each(function() {
        $(this).attr('tabindex',i);
        $(j).css({'width':'50%','float':'right'});
        $(j).prev('.searchRow').css({'width':'50%','float':'left'});
      });

    });


    var asHight = $('.searchPage #advanced-search').height();
    $("#searchform.searchPage").css({"min-height":asHight+"px"})

    //hack to add selected text in tinymce as link title. Doesn't work in IE.
    var gotIcon = false;
    setInterval(function(){
         if(gotIcon)
             return;

         var btn_link = $("a[id='form.widgets.text_link']");
         if(btn_link.length)
             gotIcon = true;

         btn_link.click(function() {
            setTimeout(function(){
                var ifrm = $('iframe[id^=mce_][id=$_ifr]').contents()
                var gotInput = false;
                ifrm.ready(setInterval(function(){
                      if(gotInput)
                         return;
                      var input = ifrm.find('#common-link-fields #link-title input');
                      if(input.length){
                         input.val(tinyMCE.activeEditor.selection.getContent({format : 'text'}));
                         gotInput = true;
                      }
                }, 250));
           }, 1000);
         })
    }, 250);
    //end hack


  });

})(jQuery);
