/**
 * The University of New England  - Global JS
 *
 * global.js
 * author: Squiz Australia
 */
/*
 * Table of Contents
 *
 *  1. Modernizr
 *
 *  2. Functions
 *      2.1 'Floats' with Dynamic Top Margin
 *      2.2 Carousel
 *
 *  3. Add General Classes
 *
 *  4. Input Wrappers
 *      4.1 Radio Wrappers
 *      4.2 Checkbox Wrappers
 *      4.3 Select Wrappers
 *
 *  5. Accordion
 *
 *  6. Tabs
 *
 *  7. Back to Top Link
 *
 *  8. Cross Browser Placeholder
 *
 *  9. Ask UNE Widget
 *
 *  10. Form Validation
 *
 *  11. Main Navigation
 *
 *  12. Footer Navigation
 *
 *  13. Contact Us - Google Maps
 *
 *  14. Home Page Slider
 *
 *  15. Home Carousel
 *
 *  16. Landing Slider
 *
 *  17. Alumni Carousel
 *
 *  18. First Year Blog Carousel
 *
 *  19. Connect Feature Slider
 *
 *  20. Connect Media Carousel
 *
 *  21. Lightbox
 *
 *  22. Events Pagination
 *
 *  23. Search Links
 *
 *  24. Query Completion
 *
 *  25. Accessibility Mega Menu
 *
 *  26. Link Selector Widget
 *
 *  27. Staff Search Select
 *
 *  28. Ajax Loading
 *
 *  29. Social Hub Load
 *
 *  30. Faceted Navigation more/less links (Funnelback code)
 *
 */

/*
----------------------------
1. Modernizr
----------------------------
*/

/* Modernizr 2.6.2 (Custom Build) | MIT & BSD
 * Build: http://modernizr.com/download/#-csstransforms-csstransitions-input-cssclasses-testprop-testallprops-domprefixes
 */
;window.Modernizr=function(a,b,c){function x(a){j.cssText=a}function y(a,b){return x(prefixes.join(a+";")+(b||""))}function z(a,b){return typeof a===b}function A(a,b){return!!~(""+a).indexOf(b)}function B(a,b){for(var d in a){var e=a[d];if(!A(e,"-")&&j[e]!==c)return b=="pfx"?e:!0}return!1}function C(a,b,d){for(var e in a){var f=b[a[e]];if(f!==c)return d===!1?a[e]:z(f,"function")?f.bind(d||b):f}return!1}function D(a,b,c){var d=a.charAt(0).toUpperCase()+a.slice(1),e=(a+" "+n.join(d+" ")+d).split(" ");return z(b,"string")||z(b,"undefined")?B(e,b):(e=(a+" "+o.join(d+" ")+d).split(" "),C(e,b,c))}function E(){e.input=function(c){for(var d=0,e=c.length;d<e;d++)r[c[d]]=c[d]in k;return r.list&&(r.list=!!b.createElement("datalist")&&!!a.HTMLDataListElement),r}("autocomplete autofocus list placeholder max min multiple pattern required step".split(" "))}var d="2.6.2",e={},f=!0,g=b.documentElement,h="modernizr",i=b.createElement(h),j=i.style,k=b.createElement("input"),l={}.toString,m="Webkit Moz O ms",n=m.split(" "),o=m.toLowerCase().split(" "),p={},q={},r={},s=[],t=s.slice,u,v={}.hasOwnProperty,w;!z(v,"undefined")&&!z(v.call,"undefined")?w=function(a,b){return v.call(a,b)}:w=function(a,b){return b in a&&z(a.constructor.prototype[b],"undefined")},Function.prototype.bind||(Function.prototype.bind=function(b){var c=this;if(typeof c!="function")throw new TypeError;var d=t.call(arguments,1),e=function(){if(this instanceof e){var a=function(){};a.prototype=c.prototype;var f=new a,g=c.apply(f,d.concat(t.call(arguments)));return Object(g)===g?g:f}return c.apply(b,d.concat(t.call(arguments)))};return e}),p.csstransforms=function(){return!!D("transform")},p.csstransitions=function(){return D("transition")};for(var F in p)w(p,F)&&(u=F.toLowerCase(),e[u]=p[F](),s.push((e[u]?"":"no-")+u));return e.input||E(),e.addTest=function(a,b){if(typeof a=="object")for(var d in a)w(a,d)&&e.addTest(d,a[d]);else{a=a.toLowerCase();if(e[a]!==c)return e;b=typeof b=="function"?b():b,typeof f!="undefined"&&f&&(g.className+=" "+(b?"":"no-")+a),e[a]=b}return e},x(""),i=k=null,e._version=d,e._domPrefixes=o,e._cssomPrefixes=n,e.testProp=function(a){return B([a])},e.testAllProps=D,g.className=g.className.replace(/(^|\s)no-js(\s|$)/,"$1$2")+(f?" js "+s.join(" "):""),e}(this,this.document);


$(document).ready(function () {

/*
----------------------------
2. Functions
----------------------------
*/
    //Detect Ipad
    var isiPad = navigator.userAgent.match(/iPad/i) != null;
    //Detect Iphone
    function isiPhone(){
        return (
            //Detect iPhone
            (navigator.platform.indexOf("iPhone") != -1) ||
            //Detect iPod
            (navigator.platform.indexOf("iPod") != -1)
        );
    }

    /* --- 2.1 'Floats' with Dynamic Top Margin --- */

    (function ($) {
        $.fn.dynamicFloat = function (options) {
            //set default variables
            var
            defaults = {
                columns: 4
            },
                settings = $.extend({}, defaults, options);
            //if there is atleast 1 item on the page
            if ($(this).length > 0) {
                var itemType = $(this)[0].tagName;
                var columns = settings.columns;
                var container = $(this).parent();
                var totalHeight = 0;
                var col;

                container.each(function () {
                    //set the item's parent to position relative
                    $(this).css('position', 'relative');
                    //get a handle on the items
                    var item = $(this).children(itemType);

                    item.each(function (i) {
                        //set the index to 1 based
                        i++;
                        //set col equal to the remainder of i/columns
                        col = i % columns;
                        //if col is 0, set it equal to the number of columns
                        if (col === 0) {
                            col = columns;
                        }

                        //set the css on each item to mimic 'float'
                        $(this).css({
                            'display': 'inline-block',
                            'vertical-align': 'top'
                        });

                        item.each(function () {
                            //this will only be true if we are on atleast the second 'row' of items
                            if ($(this).hasClass('dynamic-col-' + col)) {
                                totalHeight += $(this).outerHeight(true);
                                var thisMarginTop = parseInt($(this).css('margin-top'), null);
                                //if thisMarginTop is a negative value
                                if (thisMarginTop < 0) {
                                    totalHeight += Math.abs(thisMarginTop);
                                }
                            }
                        });

                        var itemPosition = $(this).position();

                        if (i > columns) {
                            var marginTop = -1 * (itemPosition.top - totalHeight) + 'px';
                            $(this).css({
                                'margin-top': marginTop
                            });
                        }

                        totalHeight = 0;

                        $(this).addClass('dynamic-col-' + col);
                    });
                });
            }

            // returns the jQuery object to allow for chainability.  
            return this;
        };
    })(jQuery);

    /* --- 2.2 Carousel --- */

    (function ($) {
        $.fn.carousel = function (options) {
            //set default variables
            var
            defaults = {
                slidesToShow: 4,
                scrollTime: 500
            },
                settings = $.extend({}, defaults, options);

            //set handlers and other variables
            $(this).each(function () {

                var slidesToShow = settings.slidesToShow;
                var scrollTime = settings.scrollTime;

                var sliderObj = $(this);
                var sliderId = sliderObj.attr('id');
                if (sliderId === undefined) {
                    sliderId = '';
                }
                var slide = sliderObj.find('.slide');
                var slideWrapper = sliderObj.find('.slides');
                var slideWidth = slide.eq(0).outerWidth(true);
                var slideLen = slide.length;
                var totalSlideWidth = slideWidth * slideLen;
                var scrollDistance = slideWidth;
                var amtOfScrolls = Math.ceil(slideLen / slidesToShow) - 1;
                var currentScroll = 0;
                var translateXPos;
                var leftPos;
                var readyState = true;

                //wrap the slides container with a viewport and set it to 'overflow: hidden'
                slideWrapper.width(totalSlideWidth).wrap('<div class="viewport" />');
                sliderObj.find('.viewport').css('overflow', 'hidden');
                //set the left position for webkit browsers
                slideWrapper.css('left', '0');

                //if css3 is available
                if (Modernizr.csstransitions) {
                    slideWrapper.css({
                        'transition-property': 'transform',
                        'transition-duration': scrollTime + 'ms',
                        'transition-timing-function': 'ease'
                    });
                }

                //create the directional navigation
                sliderObj.append('<ul class="direction-nav"><li><a href="#' + sliderId + '" class="prev"><span class="visuallyhidden">Previous carousel item</span></a></li><li><a href="#' + sliderId + '" class="next"><span class="visuallyhidden">Next carousel item</span></a></li></ul>');

                var prevNav = sliderObj.find('.direction-nav .prev');
                var nextNav = sliderObj.find('.direction-nav .next');

                //on prev click
                prevNav.click(function () {
                    scrollSlides('prev');
                    return false;
                });

                //on next click
                nextNav.click(function () {
                    scrollSlides('next');
                    return false;
                });

                //function to scroll the slides

                function scrollSlides(direction) {
                    if (readyState) {
                        readyState = false;

                        if (direction === undefined) {
                            direction = 'next';
                        }

                        leftPos = parseInt(slideWrapper.css('left'), null);

                        //if direction is 'next'
                        if (direction === 'next') {
                            //if we have any more distance available
                            if (currentScroll < amtOfScrolls) {
                                //if css3 is available
                                if (Modernizr.csstransitions && Modernizr.csstransforms) {
                                    translateXPos = -1 * scrollDistance - (scrollDistance * currentScroll);
                                    slideWrapper.css('transform', 'translate(' + (translateXPos) + 'px,0)');
                                    currentScroll++;
                                    readyState = true;
                                    //else use jQuery animations
                                } else {
                                    newLeftPos = leftPos - scrollDistance;
                                    slideWrapper.animate({
                                        'left': newLeftPos
                                    }, scrollTime, function () {
                                        currentScroll++;
                                        readyState = true;
                                    });
                                }
                            } else {
                                readyState = true;
                            }
                            //if direction is 'prev'
                        } else if (direction === 'prev') {
                            //if we have any more distance available
                            if (currentScroll > 0) {
                                //if css3 is available
                                if (Modernizr.csstransitions && Modernizr.csstransforms) {
                                    translateXPos = translateXPos + scrollDistance;
                                    slideWrapper.css('transform', 'translate(' + translateXPos + 'px,0)');
                                    currentScroll--;
                                    readyState = true;
                                    //else use jQuery animations
                                } else {
                                    newLeftPos = leftPos + scrollDistance;
                                    slideWrapper.animate({
                                        'left': newLeftPos
                                    }, scrollTime, function () {
                                        currentScroll--;
                                        readyState = true;
                                    });
                                }
                            } else {
                                readyState = true;
                            }
                        }
                    } //end if (readystate)
                } //end scrollSlides()
            }); //end $(this).each()

            // returns the jQuery object to allow for chainability.  
            return this;
        };
    })(jQuery);

/*
----------------------------
3. Add General Classes
----------------------------
*/

    /* 	These two lines are supposed to give alternating background colours for 
		table rows. They have been commented out because the taglib does a better 
		job. The taglib does not assume that every table in every page is to have 
		this style.
	*/
    //$('tr:nth-child(odd)').addClass('nth-child-odd');
    //$('tr:nth-child(even)').addClass('nth-child-even');
    $('.event-overview .detail:last-of-type').addClass('last-child');

/*
----------------------------
4. Input Wrappers
----------------------------
*/
    /* --- 4.1 Radio Wrappers --- */
    (function () {
        $('input[type="radio"]').each(function () {
            //if radio inputs do not have the radio wrapper parent, add it for styling
            if (!$(this).parent().is('.radio-wrapper')) {
                $(this).wrap('<div class="radio-wrapper" />');
            }
        });
        $('.radio-wrapper').each(function () {
            //if radio wrappers do not contain a span, add it for styling
            if ($(this).find('span').length === 0) {
                $(this).append('<span />');
            }
        });
    })();

    /* --- 4.2 Checkbox Wrappers --- */
    (function () {
        $('input[type="checkbox"]').each(function () {
            //if checkbox inputs do not have the checkbox wrapper parent, add it for styling
            if (!$(this).parent().is('.checkbox-wrapper')) {
                $(this).wrap('<div class="checkbox-wrapper" />');
            }
        });
        $('.checkbox-wrapper').each(function () {
            //if checkbox wrappers do not contain a span, add it for styling
            if ($(this).find('span').length === 0) {
                $(this).append('<span />');
            }
        });
    })();

    /* --- 4.3 Select Wrappers --- */
    (function () {
        $('select').each(function () {
            //if select boxes do not have the select wrapper parent, add it for styling
            if (!$(this).parent().is('.select-wrapper')) {
                $(this).wrap('<div class="select-wrapper" />');
                $(this).append('<span class="droparrow">Choose and option</span>');
            }
            var selectWrapper = $(this).parent('.select-wrapper');
            var selectWidth = $(this).outerWidth(false);
            //set the width of the selectWrapper to the select box
            selectWrapper.width(selectWidth);
            //add some extra width to the select box so the drop down arrow overflows and gets hidden
            $(this).width(selectWidth + 65);

            //if select box has class 'follow-url' then follow the url in the selected option
            if ($(this).hasClass('follow-url')) {
                $(this).change(function () {
                    window.location = $(this).val();
                });
            }
        });
    })();

/*
----------------------------
5. Accordion
----------------------------
*/
    //accessible accordion so the content prints out normally for screen readers
    (function () {
        var accessibleClass = 'visuallyhidden';
        var slideTime = 350;
        $('.accordion .panel').addClass(accessibleClass);
        $('.accordion .title').click(function () {
            var panel = $(this).next('.panel');
            if (panel.hasClass(accessibleClass)) {
                //show the panel
                $(this).addClass('active');
                panel.slideUp(0, function () {
                    panel.removeClass(accessibleClass).slideDown(slideTime);
                });
            } else {
                //hide the panel, but still show it for screen readers
                $(this).removeClass('active');
                panel.slideUp(slideTime, function () {
                    panel.addClass(accessibleClass).slideDown(0);
                });
            }
        });
    })();

/*
----------------------------
6. Tabs
----------------------------
*/

    $('.tabs').tabs();

    //make the panel hide and show accessible so screen readers can always see the content
    $('.ui-tabs-anchor').click(function () {
        var panelId = $(this).attr('href');
        $(this).closest('.tabs').find('.ui-tabs-panel').removeClass('visuallyhidden');
        $(this).closest('.tabs').find('.ui-tabs-panel').not(panelId).addClass('visuallyhidden').show();
    });

    $('.ui-tabs-nav li:first-child .ui-tabs-anchor').trigger('click');

/*
----------------------------
7. Back to Top Link
----------------------------
*/
    if($("body").hasClass("general")) {
        var mainHeight = $(".main-content").height();
        var winHeight = $(window).height();
        if(mainHeight > winHeight) {
            $(".main-content .content").append("<div class='top-wrapper' aria-hidden='true'><a href='#' class='top'>Back to top <span></span></a></div>");
        }
    }

    $('a.top').click(function () {
        $("html, body").animate({
            scrollTop: 0
        }, 800);
        return false;
    });

/*
----------------------------
8. Cross Browser Placeholder
----------------------------
*/
    //automatically checks if the browser supports the placeholder attribute natively
    (function () {
        if (!Modernizr.input.placeholder) {
            $('input[type="text"], textarea').each(function () {

                if ($(this).attr('placeholder') !== undefined) {
                    $(this).addClass('placeholder');
                    $(this).focus(function () {
                        if ($.trim($(this).val()) === $(this).attr('placeholder')) {
                            $(this).val('').removeClass('placeholder');
                        }
                    });

                    $(this).blur(function () {
                        if ($.trim($(this).val()) === '') {
                            $(this).val($(this).attr('placeholder')).addClass('placeholder');
                        }
                    });

                    //trigger blur on document ready
                    $(this).trigger('blur');
                }
            });
        }
    })();

/*
----------------------------
9. Ask UNE Widget
----------------------------
*/
    //automatically checks if the browser supports the placeholder attribute natively
    (function () {
        if ($('.widget.ask-une').length) {
            $('.widget.ask-une form').submit(function () {
                var searchTerm = encodeURIComponent($(this).find('#ask-une-keyword').val());
                var option = $(this).find('#ask-une-option').val();
                var urlRedirect = option.replace('ask_une_search_term', searchTerm);
                window.location = urlRedirect;
                return false;
            });
        }
    })();

/*
----------------------------
10. Form Validation
----------------------------
*/
    //add a clear div after every checkbox label so they always drop beneath each other
    $('<div class="js clear"/>').insertAfter('.checkbox-wrapper + label');

    //add a clear div after every second radio label in a fieldset, so they drop beneath
    $('fieldset').each(function(){
        if ($(this).find('input[type="radio"]').length) {
            $('<div class="js clear" />').insertAfter($(this).find('label:nth-of-type(2n)'));
        }
    });

    //adding a validator rule for empty values, so required select boxes also need to have a non empty value
    $.validator.addMethod("valueNotEquals", function (value, element, arg) {
        return arg != value;
    }, "This field is required.");

    //validate each form
    $('form').each(function () {
        $(this).validate({
            rules: {
                valueNotEquals: ""
            },
            errorPlacement: function (error, element) {
                //remove any error message already appended to a label
                $('label[for="'+element.attr('id')+'"]').find('em').remove();
                //remove the 'for' attribute as the label will become an 'em'
                error.removeAttr('for');
                //wrap errors in a div for styling purposes
                error.wrap('<span class="validation-error" />');
                //prepend a space before the error text so it reads better
                error.text(' ' + error.text());
                //set the error handler to the 'validation-error' parent
                error = error.parent();

                //if element is a radio, append the error to the legend
                if (element.attr('type') === 'radio') {
                    var legend = element.closest('fieldset').find('legend');
                    error.appendTo(legend);
                //else, append the error to the label
                } else {
                    error.appendTo('label[for="'+element.attr('id')+'"]');
                }
            },
            //make the error an 'em' instead of the default ('label')
            errorElement: "em"
        });
    });

/*
----------------------------
11. Main Navigation
----------------------------
*/

    $('#main-nav .level-2 > li').dynamicFloat();

/*
----------------------------
12. Footer Navigation
----------------------------
*/

    $('.footer-nav > li').dynamicFloat({
        columns: 3
    });

/*
----------------------------
13. Contact Us - Google Maps
----------------------------


    //Google Maps API

    function initMap(zoom, lat, lng) {
        var mapOptions = {
            zoom: zoom,
            center: new google.maps.LatLng(lat, lng),
            mapTypeId: google.maps.MapTypeId.ROADMAP
        };
        var map = new google.maps.Map(document.getElementById('une-map'), mapOptions);

        var image = './?a=3171';
        var myLatLng = new google.maps.LatLng(lat, lng);
        var uneMarker = new google.maps.Marker({
            position: myLatLng,
            map: map,
            icon: image
        });
    }

    //armidale link
    $('.une-locations .armidale').click(function () {
        $('.une-locations .locations a').removeClass('active');
        $(this).addClass('active');
        initMap(16, -30.497933, 151.642667);
        return false;
    });

    //set the map to load armidale first up
    $('.une-locations .armidale').trigger('click');

    //parramatta link
    $('.une-locations .parramatta').click(function () {
        $('.une-locations .locations a').removeClass('active');
        $(this).addClass('active');
        initMap(16, -33.815128, 151.003155);
        return false;
    });
*/
/*
----------------------------
14. Home Page Slider
----------------------------

    //set variables
    var homeTransitionTime = 9000; //in ms
    var homeCssTransitionTime = homeTransitionTime + 'ms';
    var homeCaptionAnimateTime = 1000; //in ms
    var homeCssCaptionAnimateTime = homeCaptionAnimateTime + 'ms';

    //set functions

    function animateLoader(sliderObj, transitionTime, cssTransitionTime) {
        //if css3 is available
        if (Modernizr.csstransitions && Modernizr.csstransforms) {
            sliderObj.find('.loader').removeAttr('style').width(0).css({
                'transition': 'width ' + cssTransitionTime + ' linear',
                'width': '100%'
            });
            //else use jQuery animations
        } else {
            sliderObj.find('.loader').width(0).stop(true).animate({
                'width': '100%'
            }, (transitionTime - 100), 'linear');
        }
    }

    function beforeCaptionAnimate(sliderObj) {
        //if css3 is available
        if (Modernizr.csstransitions && Modernizr.csstransforms) {
            sliderObj.find('.caption .caption-normal').removeAttr('style').css({
                'transform': 'translate(0,40px)',
                'opacity': '0',
                'transition': 'all ' + homeCssCaptionAnimateTime + ' ease'
            });
            sliderObj.find('.caption .caption-strong').removeAttr('style').css({
                'transform': 'scale(0.7,0.7)',
                'opacity': '0',
                'transition': 'all ' + homeCssCaptionAnimateTime + ' ease 500ms'
            });
            sliderObj.find('.caption .caption-more').removeAttr('style').css({
                'opacity': '0',
                'transition': 'all ' + homeCssCaptionAnimateTime + ' ease 1000ms'
            });
            //else use jQuery animations
        } else {
            sliderObj.find('.caption .caption-normal').css({
                'top': '40px',
                'opacity': '0'
            });
            sliderObj.find('.caption .caption-strong').css({
                'opacity': '0'
            });
            sliderObj.find('.caption .caption-more').css({
                'opacity': '0'
            });
        }
    }

    function captionAnimate(sliderObj) {
        //if css3 is available
        if (Modernizr.csstransitions && Modernizr.csstransforms) {
            sliderObj.find('.caption .caption-normal').css({
                'transform': 'translate(0,0)',
                'opacity': '1'
            });
            sliderObj.find('.caption .caption-strong').css({
                'transform': 'scale(1,1)',
                'opacity': '1'
            });
            sliderObj.find('.caption .caption-more').css({
                'opacity': '1'
            });
            //else use jQuery animations
        } else {
            sliderObj.find('.caption .caption-normal').stop(true, true).animate({
                'top': '0',
                'opacity': '1'
            }, homeCaptionAnimateTime);
            sliderObj.find('.caption .caption-strong').stop(true, true).delay(500).animate({
                'opacity': '1'
            }, homeCaptionAnimateTime);
            sliderObj.find('.caption .caption-more').stop(true, true).delay(1000).animate({
                'opacity': '1'
            }, homeCaptionAnimateTime);
        }
    }

    //home slider
    (function () {
        var sliderObj = $('#home-slider');
        if(isiPad != 0 || isiPhone() != false){
            $(sliderObj).flexslider({
                selector: ".slides > .slide",
                slideshowSpeed: homeTransitionTime,
                directionNav: true,
                controlNav: false,
                pauseOnAction: true,
                useCSS: false,
                start: function () {
                    sliderObj.find('.flex-direction-nav a').contents().wrap('<span class="visuallyhidden" />');
                    sliderObj.append('<div class="loader" />');
                    sliderObj.find('.flex-direction-nav a').bind("touchstart", function () {
                        sliderObj.find('.loader').remove();
                    });
                    animateLoader(sliderObj, homeTransitionTime, homeCssTransitionTime);
                },
                before: function () {
                    animateLoader(sliderObj, homeTransitionTime, homeCssTransitionTime);
                }
            });
            sliderObj.find('.caption-normal').css('opacity', 1);
            sliderObj.find('.caption-strong').css('opacity', 1);
            sliderObj.find('.caption-more').css('opacity', 1);
        }
        else {
            $(sliderObj).flexslider({
                selector: ".slides > .slide",
                slideshowSpeed: homeTransitionTime,
                directionNav: true,
                controlNav: false,
                pauseOnAction: true,
                start: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').addClass('visuallyhidden').show();
                    sliderObj.find('.flex-direction-nav a').contents().wrap('<span class="visuallyhidden" />');
                    sliderObj.append('<div class="loader" />');
                    sliderObj.find('.flex-direction-nav a').click(function () {
                        if (!$(this).hasClass('flex-active')) {
                            sliderObj.find('.loader').remove();
                        }
                    });
                    animateLoader(sliderObj, homeTransitionTime, homeCssTransitionTime);
                    beforeCaptionAnimate(sliderObj);
                    captionAnimate(sliderObj);
                },
                before: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').hide().removeClass('visuallyhidden');
                    animateLoader(sliderObj, homeTransitionTime, homeCssTransitionTime);
                    beforeCaptionAnimate(sliderObj);
                },
                after: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').addClass('visuallyhidden').show();
                    captionAnimate(sliderObj);
                }
            });
        }
        
    })();
*/
/*
----------------------------
15. Home Carousel
----------------------------


    $('#home-carousel').carousel();
*/
/*
----------------------------
16. Landing Slider
----------------------------

    var landingTransitionTime = 10000; //in ms
    var landingCssTransitionTime = landingTransitionTime + 'ms';

    if ($('#landing-slider .slide').length > 1) {
        var sliderObj = $('#landing-slider');
        if(isiPad != 0 || isiPhone() != false) {
            sliderObj.flexslider({
                selector: ".slides > .slide",
                slideshowSpeed: landingTransitionTime,
                directionNav: false,
                pauseOnAction: true,
                useCSS: false,
                start: function (slider) {
                    sliderObj.append('<div class="loader" />');
                    animateLoader(sliderObj, landingTransitionTime, landingCssTransitionTime);
                    sliderObj.find('.flex-control-nav a').bind("touchstart", function () {
                        sliderObj.find('.loader').remove();
                        slider.pause();
                });
                },
                before: function () {
                    animateLoader(sliderObj, landingTransitionTime, landingCssTransitionTime);
                }
            });
        }
        else {
            sliderObj.flexslider({
                selector: ".slides > .slide",
                slideshowSpeed: landingTransitionTime,
                directionNav: false,
                pauseOnAction: true,
                start: function (slider) {
                    sliderObj.find('.slide').not('.flex-active-slide').addClass('visuallyhidden').show();
                    sliderObj.find('.flex-control-nav a').contents().wrap('<span class="visuallyhidden" />');
                    sliderObj.append('<div class="loader" />');
                    sliderObj.find('.flex-control-nav a').click(function () {
                        sliderObj.find('.loader').remove();
                        slider.pause();
                    });
                    animateLoader(sliderObj, landingTransitionTime, landingCssTransitionTime);
                },
                before: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').hide().removeClass('visuallyhidden');
                    animateLoader(sliderObj, landingTransitionTime, landingCssTransitionTime);
                },
                after: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').addClass('visuallyhidden').show();
                }
            });
        }

    }
*/
/*
----------------------------
17. Alumni Carousel
----------------------------

    (function () {
        var items = 7;
        if ($('.alumni #people-carousel .slide').length > items) {
            $('.alumni #people-carousel').carousel({
                slidesToShow: items
            });
        }
    })();
*/
/*
----------------------------
18. First Year Blog Carousel
----------------------------

    (function () {
        var items = 5;
        if ($('.first-year-blog #people-carousel .slide').length > items) {
            $('.first-year-blog #people-carousel').carousel({
                slidesToShow: items
            });
        }
    })();
*/
/*
----------------------------
19. Connect Feature Slider
----------------------------

    if ($('#connect-feature-slider .slide').length > 1) {
        var sliderObj = $('#connect-feature-slider');
        if(isiPad != 0 || isiPhone() != false){
            sliderObj.flexslider({
                selector: ".slides > .slide",
                slideshowSpeed: 7000,
                directionNav: true,
                controlNav: false,
                pauseOnAction: true,
                useCSS: false
            });
        }
        else {
            sliderObj.flexslider({
                selector: ".slides > .slide",
                slideshowSpeed: 7000,
                directionNav: true,
                controlNav: false,
                pauseOnAction: true,
                start: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').addClass('visuallyhidden').show();
                    sliderObj.find('.flex-direction-nav a').contents().wrap('<span class="visuallyhidden" />');
                },
                before: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').hide().removeClass('visuallyhidden');
                },
                after: function () {
                    sliderObj.find('.slide').not('.flex-active-slide').addClass('visuallyhidden').show();
                }
            });
        }
    }
*/
/*
----------------------------
20. Connect Media Carousel
----------------------------

    //Wrap items for news and events
    function groupItems(items, groupSize, listClass) {
        var i = 0;
        var split = Math.ceil(items.length / groupSize),
            y = 0;

        for (i=0; i < split; i++) {
            var batch = items.slice(y, y+groupSize);
            batch.wrapAll('<div class="slide"></div>');
            batch.wrapAll('<div class="listing'+listClass+'"></div>');
            y += groupSize;
        }
    }

    $("#connect-news-slider").each(function() {
        // Group items before initiating scrollable
        var Items = $('> div a',this),
        groupSize = 2;
        listClass = " news";
        groupItems(Items, groupSize, listClass);
    });

    $("#connect-events-slider").each(function() {
        // Group items before initiating scrollable
        var Items = $('> div a',this),
        groupSize = 2;
        listClass = " events";
        groupItems(Items, groupSize, listClass);
    });

    $(".connect-panel.slider").each(function() {
        // Group items before initiating scrollable
        var Items = $('> div a',this),
        groupSize = 2;
        listClass = "";
        groupItems(Items, groupSize, listClass);
    });

    //Initialise Sliders
    $('.connect-media-carousel').carousel({
        slidesToShow: 1
    });
*/
/*
----------------------------
21. Lightbox
----------------------------

    $(".inline-video").colorbox({ifame:true,innerHeight:"400px",innerWidth:"510px"});
    $("#cboxNext").text("Next");
    $("#cboxPrevious").text("Previous");
    $("#cboxSlideshow").text("Slideshow");
*/
/*
----------------------------
22. Event Pagination
----------------------------

    // initialize all calendar functions
    iniCalendarFunctions();
    if($(".calendar-events")){
        $(".calendar-events").children("h3").remove();
    }
*/
/*
----------------------------
23. Search Links
----------------------------
*/

    if($("#search-links")) {
        $("#search-links p").each(function(){
            $(this).children("a").each(function(){
                $(this).after("<span>|</span>");
            });
            $(this).find("span:last-child").remove();
        });
    }

/*
----------------------------
24. Query Completion
----------------------------
This code is broken cannot find .fbcompletion() line 1003

        var fb_server = 'http://search-au.funnelback.com/',
        $fb_targets = {
            '#site-search-field' : 'une-meta', 
            '#txtKeywords' : 'une-meta',
			'#query' : 'une-meta' //Name of the field on the blank form
        };
  
        $.each($fb_targets, function(selector, collection) {
            var $selector = $(selector);
            if ($selector.length) {
                $selector.data("autocomplete","off").fbcompletion({
                    'enabled'    : 'enabled',
                    'collection' : collection,
                    'program'    : fb_server + 's/suggest.json',
                    'format'     : 'extended',
                    'alpha'      : '.5',
                    'show'       : '10',
                    'sort'       : '0',
                    'length'     : '3',
                    'delay'      : '0'
                })
                    .attr({ 'autocorrect' : 'off', 'autocapitalize' : 'off', 'autocomplete' : 'off' })
                    .parents('form').attr('autocomplete', 'off');
            }
        });
*/
/*
----------------------------
25. Accessibility Mega Menu
----------------------------

    $("#main-nav-wrapper > ul div a").focusin(function() {
        $(this).closest('div').parent().addClass('hovered');
    });
    $("#main-nav-wrapper > ul div a").bind('blur, click, mouseout, focusout', function() {
        $(this).closest('div').parent().removeClass('hovered');
    });
*/
/*
----------------------------
26. Link Selector Widget
----------------------------
*/
    if($(".widget.linkSelector")) {
        $(".linkSelector select").children("option:first-child").attr('selected', 'selected');
        $(".linkSelector select").change(function(){
            var location = $(this).children("option:selected").attr('value');
            window.location.href = location;
        });
    }

/*
----------------------------
27. Staff Search Select
----------------------------

    if($("#staff-search")) {
        depSelect = $("<select id='queries_department_query' name='queries_department_query' multiple></select>");
        $(".department > ul > li").each(function(){
            option = $(this).children("div").children('input');
            val = option.attr('value');
            text = $(this).children('label').text();
            if(option.attr('checked') == 'checked') {
                selected = "selected='selected'";
            }
            else {
                selected = "";
            }
            depSelect.append("<option value='"+val+"' " +selected+">"+text+"</option>");
        });
        $(".department > ul").replaceWith(depSelect);

        disSelect = $("<select id='queries_discipline_query' name='queries_discipline_query' multiple></select>");
        $(".discipline > ul > li").each(function(){
            option = $(this).children("div").children('input');
            val = option.attr('value');
            text = $(this).children('label').text();
            if(option.attr('checked') == 'checked') {
                selected = "selected='selected'";
            }
            else {
                selected = "";
            }
            disSelect.append("<option value='"+val+"' " +selected+">"+text+"</option>");
        });
        $(".discipline > ul").replaceWith(disSelect);
    }
*/
/*
----------------------------
28. AJAX Loading
----------------------------

    function ajaxSetup(callback, extension, dataVal) {
        config = {
            url : "/_design/ajax-components/" + extension,
            data : {category : dataVal},
            cache : true,
            dataType : "html",
            async : true,
            success : callback
        };

        $.ajax(config);
    }

    //Prefooter Events
    function _prefooterEventsCallback(html) {
        $(".pre-footer-widget .listing.events").html(html);
    }

    if($('.pre-footer-widget .listing.events')) {
        category = $(".pre-footer-widget .listing.news .variable").text();
        ajaxSetup(_prefooterEventsCallback, "prefooter-events-widget-generator", category);
    }

    //Prefooter News
    function _prefooterNewsCallback(html) {
        $(".pre-footer-widget .listing.news").html(html);
    }

    if($('.pre-footer-widget .listing.news')) {
        category = $(".pre-footer-widget .listing.news .variable").text();
        ajaxSetup(_prefooterNewsCallback, "pre-footer-news", category);
    }

    //Widget News
    function _widgetNewsCallback(html) {
        $(".widget.news .listing.news").html(html);
    }

    if($('.widget.news')) {
        category = $(".widget.news .variable").text();
        ajaxSetup(_widgetNewsCallback, "widget-news", category);
    }

    //Widget Events
    function _widgetEventsCallback(html) {
        $(".widget.events .listing.events").html(html);
    }

    if($('.widget.events')) {
        category = $(".widget.events .variable").text();
        ajaxSetup(_widgetEventsCallback, "events-widget-generator", category);
    }
*/
/*
----------------------------
29. Social Hub Load
----------------------------

    function _socialHubCallback(html) {
        $("div.social-hub").html(html);
        $("div.social-hub").tabs();
    }

    socialHubConfig = {
        url : "/_design/ajax-components/social-hub",
        data : [],
        cache : true,
        dataType : "html",
        async : true,
        success : _socialHubCallback
    };

    $.ajax(socialHubConfig);  
*/
/*
---------------------------------------------------------
30. Faceted Navigation more/less links (Funnelback code)
---------------------------------------------------------
	
	// Number of categories to display
	var displayedCategories = 8;

	jQuery('div.facet').each( function() {
		jQuery(this).children('div.category:gt('+(displayedCategories-1)+')').css('display', 'none');
	});
	
	jQuery('.moreOrLessCategories>a').each( function() {
		var nbCategories = jQuery(this).parent().parent().children('div.category').size();
		if ( nbCategories <= displayedCategories ) {
			jQuery(this).parent().css('display', 'none');
		} else {
			jQuery(this).css('display', 'inline');
			jQuery(this).click( function() {
				if (jQuery(this).text().indexOf('more...') < 0) {
					jQuery(this).parent().parent().children('div.category:gt('+(displayedCategories-1)+')').css('display', 'none');
					jQuery(this).text('more...');
				} else {
					jQuery(this).parent().parent().children('div.category').css('display', 'block');
					jQuery(this).text('less...');
				}
			});
		}
	});
*/
}); //end document ready
/*!
    Colorbox v1.4.26 - 2013-06-30
    jQuery lightbox and modal window plugin
    (c) 2013 Jack Moore - http://www.jacklmoore.com/colorbox
    license: http://www.opensource.org/licenses/mit-license.php

(function(e,t,i){function o(i,o,n){var r=t.createElement(i);return o&&(r.id=et+o),n&&(r.style.cssText=n),e(r)}function n(){return i.innerHeight?i.innerHeight:e(i).height()}function r(e){var t=E.length,i=(j+e)%t;return 0>i?t+i:i}function l(e,t){return Math.round((/%/.test(e)?("x"===t?H.width():n())/100:1)*parseInt(e,10))}function a(e,t){return e.photo||e.photoRegex.test(t)}function h(e,t){return e.retinaUrl&&i.devicePixelRatio>1?t.replace(e.photoRegex,e.retinaSuffix):t}function s(e){"contains"in v[0]&&!v[0].contains(e.target)&&(e.stopPropagation(),v.focus())}function d(){var t,i=e.data(A,Z);null==i?(O=e.extend({},Y),console&&console.log&&console.log("Error: cboxElement missing settings object")):O=e.extend({},i);for(t in O)e.isFunction(O[t])&&"on"!==t.slice(0,2)&&(O[t]=O[t].call(A));O.rel=O.rel||A.rel||e(A).data("rel")||"nofollow",O.href=O.href||e(A).attr("href"),O.title=O.title||A.title,"string"==typeof O.href&&(O.href=e.trim(O.href))}function c(i,o){e(t).trigger(i),ht.trigger(i),e.isFunction(o)&&o.call(A)}function u(){var e,t,i,o,n,r=et+"Slideshow_",l="click."+et;O.slideshow&&E[1]?(t=function(){clearTimeout(e)},i=function(){(O.loop||E[j+1])&&(e=setTimeout(J.next,O.slideshowSpeed))},o=function(){R.html(O.slideshowStop).unbind(l).one(l,n),ht.bind(nt,i).bind(ot,t).bind(rt,n),v.removeClass(r+"off").addClass(r+"on")},n=function(){t(),ht.unbind(nt,i).unbind(ot,t).unbind(rt,n),R.html(O.slideshowStart).unbind(l).one(l,function(){J.next(),o()}),v.removeClass(r+"on").addClass(r+"off")},O.slideshowAuto?o():n()):v.removeClass(r+"off "+r+"on")}function p(i){G||(A=i,d(),E=e(A),j=0,"nofollow"!==O.rel&&(E=e("."+tt).filter(function(){var t,i=e.data(this,Z);return i&&(t=e(this).data("rel")||i.rel||this.rel),t===O.rel}),j=E.index(A),-1===j&&(E=E.add(A),j=E.length-1)),g.css({opacity:parseFloat(O.opacity),cursor:O.overlayClose?"pointer":"auto",visibility:"visible"}).show(),V&&v.add(g).removeClass(V),O.className&&v.add(g).addClass(O.className),V=O.className,O.closeButton?P.html(O.close).appendTo(x):P.appendTo("<div/>"),$||($=q=!0,v.css({visibility:"hidden",display:"block"}),W=o(st,"LoadedContent","width:0; height:0; overflow:hidden").appendTo(x),_=b.height()+k.height()+x.outerHeight(!0)-x.height(),D=T.width()+C.width()+x.outerWidth(!0)-x.width(),N=W.outerHeight(!0),z=W.outerWidth(!0),O.w=l(O.initialWidth,"x"),O.h=l(O.initialHeight,"y"),J.position(),u(),c(it,O.onOpen),B.add(S).hide(),v.focus(),O.trapFocus&&t.addEventListener&&(t.addEventListener("focus",s,!0),ht.one(lt,function(){t.removeEventListener("focus",s,!0)})),O.returnFocus&&ht.one(lt,function(){e(A).focus()})),w())}function f(){!v&&t.body&&(X=!1,H=e(i),v=o(st).attr({id:Z,"class":e.support.opacity===!1?et+"IE":"",role:"dialog",tabindex:"-1"}).hide(),g=o(st,"Overlay").hide(),L=e([o(st,"LoadingOverlay")[0],o(st,"LoadingGraphic")[0]]),y=o(st,"Wrapper"),x=o(st,"Content").append(S=o(st,"Title"),M=o(st,"Current"),K=e('<button type="button"/>').attr({id:et+"Previous"}),I=e('<button type="button"/>').attr({id:et+"Next"}),R=o("button","Slideshow"),L),P=e('<button type="button"/>').attr({id:et+"Close"}),y.append(o(st).append(o(st,"TopLeft"),b=o(st,"TopCenter"),o(st,"TopRight")),o(st,!1,"clear:left").append(T=o(st,"MiddleLeft"),x,C=o(st,"MiddleRight")),o(st,!1,"clear:left").append(o(st,"BottomLeft"),k=o(st,"BottomCenter"),o(st,"BottomRight"))).find("div div").css({"float":"left"}),F=o(st,!1,"position:absolute; width:9999px; visibility:hidden; display:none"),B=I.add(K).add(M).add(R),e(t.body).append(g,v.append(y,F)))}function m(){function i(e){e.which>1||e.shiftKey||e.altKey||e.metaKey||e.ctrlKey||(e.preventDefault(),p(this))}return v?(X||(X=!0,I.click(function(){J.next()}),K.click(function(){J.prev()}),P.click(function(){J.close()}),g.click(function(){O.overlayClose&&J.close()}),e(t).bind("keydown."+et,function(e){var t=e.keyCode;$&&O.escKey&&27===t&&(e.preventDefault(),J.close()),$&&O.arrowKey&&E[1]&&!e.altKey&&(37===t?(e.preventDefault(),K.click()):39===t&&(e.preventDefault(),I.click()))}),e.isFunction(e.fn.on)?e(t).on("click."+et,"."+tt,i):e("."+tt).live("click."+et,i)),!0):!1}function w(){var n,r,s,u=J.prep,p=++dt;q=!0,U=!1,A=E[j],d(),c(at),c(ot,O.onLoad),O.h=O.height?l(O.height,"y")-N-_:O.innerHeight&&l(O.innerHeight,"y"),O.w=O.width?l(O.width,"x")-z-D:O.innerWidth&&l(O.innerWidth,"x"),O.mw=O.w,O.mh=O.h,O.maxWidth&&(O.mw=l(O.maxWidth,"x")-z-D,O.mw=O.w&&O.w<O.mw?O.w:O.mw),O.maxHeight&&(O.mh=l(O.maxHeight,"y")-N-_,O.mh=O.h&&O.h<O.mh?O.h:O.mh),n=O.href,Q=setTimeout(function(){L.show()},100),O.inline?(s=o(st).hide().insertBefore(e(n)[0]),ht.one(at,function(){s.replaceWith(W.children())}),u(e(n))):O.iframe?u(" "):O.html?u(O.html):a(O,n)?(n=h(O,n),U=t.createElement("img"),e(U).addClass(et+"Photo").bind("error",function(){O.title=!1,u(o(st,"Error").html(O.imgError))}).one("load",function(){var t;p===dt&&(U.alt=e(A).attr("alt")||e(A).attr("data-alt")||"",O.retinaImage&&i.devicePixelRatio>1&&(U.height=U.height/i.devicePixelRatio,U.width=U.width/i.devicePixelRatio),O.scalePhotos&&(r=function(){U.height-=U.height*t,U.width-=U.width*t},O.mw&&U.width>O.mw&&(t=(U.width-O.mw)/U.width,r()),O.mh&&U.height>O.mh&&(t=(U.height-O.mh)/U.height,r())),O.h&&(U.style.marginTop=Math.max(O.mh-U.height,0)/2+"px"),E[1]&&(O.loop||E[j+1])&&(U.style.cursor="pointer",U.onclick=function(){J.next()}),U.style.width=U.width+"px",U.style.height=U.height+"px",setTimeout(function(){u(U)},1))}),setTimeout(function(){U.src=n},1)):n&&F.load(n,O.data,function(t,i){p===dt&&u("error"===i?o(st,"Error").html(O.xhrError):e(this).contents())})}var g,v,y,x,b,T,C,k,E,H,W,F,L,S,M,R,I,K,P,B,O,_,D,N,z,A,j,U,$,q,G,Q,J,V,X,Y={transition:"elastic",speed:300,fadeOut:300,width:!1,initialWidth:"600",innerWidth:!1,maxWidth:!1,height:!1,initialHeight:"450",innerHeight:!1,maxHeight:!1,scalePhotos:!0,scrolling:!0,inline:!1,html:!1,iframe:!1,fastIframe:!0,photo:!1,href:!1,title:!1,rel:!1,opacity:.9,preloading:!0,className:!1,retinaImage:!1,retinaUrl:!1,retinaSuffix:"@2x.$1",current:"image {current} of {total}",previous:"previous",next:"next",close:"close",xhrError:"This content failed to load.",imgError:"This image failed to load.",open:!1,returnFocus:!0,trapFocus:!0,reposition:!0,loop:!0,slideshow:!1,slideshowAuto:!0,slideshowSpeed:2500,slideshowStart:"start slideshow",slideshowStop:"stop slideshow",photoRegex:/\.(gif|png|jp(e|g|eg)|bmp|ico|webp)((#|\?).*)?$/i,onOpen:!1,onLoad:!1,onComplete:!1,onCleanup:!1,onClosed:!1,overlayClose:!0,escKey:!0,arrowKey:!0,top:!1,bottom:!1,left:!1,right:!1,fixed:!1,data:void 0,closeButton:!0},Z="colorbox",et="cbox",tt=et+"Element",it=et+"_open",ot=et+"_load",nt=et+"_complete",rt=et+"_cleanup",lt=et+"_closed",at=et+"_purge",ht=e("<a/>"),st="div",dt=0,ct={};e.colorbox||(e(f),J=e.fn[Z]=e[Z]=function(t,i){var o=this;if(t=t||{},f(),m()){if(e.isFunction(o))o=e("<a/>"),t.open=!0;else if(!o[0])return o;i&&(t.onComplete=i),o.each(function(){e.data(this,Z,e.extend({},e.data(this,Z)||Y,t))}).addClass(tt),(e.isFunction(t.open)&&t.open.call(o)||t.open)&&p(o[0])}return o},J.position=function(t,i){function o(){b[0].style.width=k[0].style.width=x[0].style.width=parseInt(v[0].style.width,10)-D+"px",x[0].style.height=T[0].style.height=C[0].style.height=parseInt(v[0].style.height,10)-_+"px"}var r,a,h,s=0,d=0,c=v.offset();if(H.unbind("resize."+et),v.css({top:-9e4,left:-9e4}),a=H.scrollTop(),h=H.scrollLeft(),O.fixed?(c.top-=a,c.left-=h,v.css({position:"fixed"})):(s=a,d=h,v.css({position:"absolute"})),d+=O.right!==!1?Math.max(H.width()-O.w-z-D-l(O.right,"x"),0):O.left!==!1?l(O.left,"x"):Math.round(Math.max(H.width()-O.w-z-D,0)/2),s+=O.bottom!==!1?Math.max(n()-O.h-N-_-l(O.bottom,"y"),0):O.top!==!1?l(O.top,"y"):Math.round(Math.max(n()-O.h-N-_,0)/2),v.css({top:c.top,left:c.left,visibility:"visible"}),y[0].style.width=y[0].style.height="9999px",r={width:O.w+z+D,height:O.h+N+_,top:s,left:d},t){var u=0;e.each(r,function(e){return r[e]!==ct[e]?(u=t,void 0):void 0}),t=u}ct=r,t||v.css(r),v.dequeue().animate(r,{duration:t||0,complete:function(){o(),q=!1,y[0].style.width=O.w+z+D+"px",y[0].style.height=O.h+N+_+"px",O.reposition&&setTimeout(function(){H.bind("resize."+et,J.position)},1),i&&i()},step:o})},J.resize=function(e){var t;$&&(e=e||{},e.width&&(O.w=l(e.width,"x")-z-D),e.innerWidth&&(O.w=l(e.innerWidth,"x")),W.css({width:O.w}),e.height&&(O.h=l(e.height,"y")-N-_),e.innerHeight&&(O.h=l(e.innerHeight,"y")),e.innerHeight||e.height||(t=W.scrollTop(),W.css({height:"auto"}),O.h=W.height()),W.css({height:O.h}),t&&W.scrollTop(t),J.position("none"===O.transition?0:O.speed))},J.prep=function(i){function n(){return O.w=O.w||W.width(),O.w=O.mw&&O.mw<O.w?O.mw:O.w,O.w}function l(){return O.h=O.h||W.height(),O.h=O.mh&&O.mh<O.h?O.mh:O.h,O.h}if($){var s,d="none"===O.transition?0:O.speed;W.empty().remove(),W=o(st,"LoadedContent").append(i),W.hide().appendTo(F.show()).css({width:n(),overflow:O.scrolling?"auto":"hidden"}).css({height:l()}).prependTo(x),F.hide(),e(U).css({"float":"none"}),s=function(){function i(){e.support.opacity===!1&&v[0].style.removeAttribute("filter")}var n,l,s=E.length,u="frameBorder",p="allowTransparency";$&&(l=function(){clearTimeout(Q),L.hide(),c(nt,O.onComplete)},S.html(O.title).add(W).show(),s>1?("string"==typeof O.current&&M.html(O.current.replace("{current}",j+1).replace("{total}",s)).show(),I[O.loop||s-1>j?"show":"hide"]().html(O.next),K[O.loop||j?"show":"hide"]().html(O.previous),O.slideshow&&R.show(),O.preloading&&e.each([r(-1),r(1)],function(){var i,o,n=E[this],r=e.data(n,Z);r&&r.href?(i=r.href,e.isFunction(i)&&(i=i.call(n))):i=e(n).attr("href"),i&&a(r,i)&&(i=h(r,i),o=t.createElement("img"),o.src=i)})):B.hide(),O.iframe?(n=o("iframe")[0],u in n&&(n[u]=0),p in n&&(n[p]="true"),O.scrolling||(n.scrolling="no"),e(n).attr({src:O.href,name:(new Date).getTime(),"class":et+"Iframe",allowFullScreen:!0,webkitAllowFullScreen:!0,mozallowfullscreen:!0}).one("load",l).appendTo(W),ht.one(at,function(){n.src="//about:blank"}),O.fastIframe&&e(n).trigger("load")):l(),"fade"===O.transition?v.fadeTo(d,1,i):i())},"fade"===O.transition?v.fadeTo(d,0,function(){J.position(0,s)}):J.position(d,s)}},J.next=function(){!q&&E[1]&&(O.loop||E[j+1])&&(j=r(1),p(E[j]))},J.prev=function(){!q&&E[1]&&(O.loop||j)&&(j=r(-1),p(E[j]))},J.close=function(){$&&!G&&(G=!0,$=!1,c(rt,O.onCleanup),H.unbind("."+et),g.fadeTo(O.fadeOut||0,0),v.stop().fadeTo(O.fadeOut||0,0,function(){v.add(g).css({opacity:1,cursor:"auto"}).hide(),c(at),W.empty().remove(),setTimeout(function(){G=!1,c(lt,O.onClosed)},1)}))},J.remove=function(){v&&(v.stop(),e.colorbox.close(),v.stop().remove(),g.remove(),G=!1,v=null,e("."+tt).removeData(Z).removeClass(tt),e(t).unbind("click."+et))},J.element=function(){return e(A)},J.settings=Y)})(jQuery,document,window);
*/

/***********************************************************************************************
 * Calendar functions
 * desc: The below are all the calendar functions for the what's on and event sections
 * auth: Bart Banda [Jan 2013]

function iniCalendarFunctions(){

  //function for adding month picker 12months in advance of the current month
  $('.date-pagination-wrapper').each(function(){
    var url = $(this).find('.events-link').attr('href');
    //add some html
    $('.date-pagination-wrapper').html('<ul class="date-pagination"></ul><div class="separator"></div>');
    //create our month arrays (12months worth of 2 years)
    var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    var monthNumbers = ['01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12'];
    //get todays month
    var d = new Date();
    var currentMonth = d.getMonth();  

    //construct our ul list
    for(var i = 0; i < 12; i++) {
      if((i + currentMonth) < 12) {
        var year = d.getFullYear();
      } else {
        var year = d.getFullYear() + 1;
      }
      var thisDate = year + '-' + monthNumbers[i + currentMonth] + '-01';
      $('.date-pagination-wrapper ul').append('<li><a class="month date-'+ thisDate +'" href="'+ url +'?SQ_CALENDAR_VIEW=month&SQ_CALENDAR_DATE=' + thisDate + '">' + months[i + currentMonth] + '<span class="year">' + year + '</span></a></li>');
    }

    //if there is a url paramter query with a preselected month, highlight it
    if(getURLParameter('SQ_CALENDAR_DATE')){
      $('.date-pagination-wrapper .date-'+getURLParameter('SQ_CALENDAR_DATE')).addClass('active');
    }else{
    //else highlight the first month
      $('.date-pagination-wrapper .month:first').addClass('active');
    }

  });

}
*/

function getURLParameter(name){
  return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null;
}