/**
 * Highwire AT Symbol
 *
 * Copyright (c) 2010-2011 Board of Trustees, Leland Stanford Jr. University
 * This software is open-source licensed under the GNU Public License Version 2 or later
 * The full license is available in the LICENSE.TXT file at the root of this repository
 */
(function ($) {
  Drupal.behaviors.scienceTablesMarkupProcessor = {
    attach: function(context, settings) {
      $('a.table-expand-inline', context).once('scienceTablesMarkupProcessor', function() {
        $(this, context).each(function() {
          var $caption, captionHTML;
          var $wrapper, $expansion;
          var self = this;
          var toggle = false;
          var load = false;

          $(self).click(function(event) {
            event.preventDefault();
            $wrapper = $(self).closest('.table');

            // Check if we have the element already. 
            // If we don't, load the table expansion data.
            if ($wrapper.find('.table-expansion-inline').length == 0) {
              $wrapper.append('<div class="table-expansion-inline"></div>');
              load = true;
            }
            // If the element exists already, just toggle it.
            else {
              toggle = true;
            }
            
            $expansion = $wrapper.find('.table-expansion-inline');

            // Load table expansion.
            if (load) {
              $expansion.load($(this).data('table-url'), function () {
                load = false;
                // Hide table caption because it's already displayed 
                // above table callout links.
                $expansion.find('.table-caption').hide();
                $(self).html('Collapse inline');
                Drupal.attachBehaviors($expansion[0]);
              });
            }
 
            // Toggle display.
            if (toggle) {
              $wrapper.toggleClass('table-expand-inline');
              $expansion.toggle();
              if ($(self).html() == 'View inline') {
                $(self).html('Collapse inline');
              }
              else {
                $(self).html('View inline');
              }
            }
          });
        });
        /**
         * Added this colorbox calling function as AJAX tabs naigation holds
         * poping up data into model
         */
        $('a.table-expand-popup', context).each(function() {
          cbsettings = $.extend(settings.colorbox, {title: false});
          $(this).colorbox(cbsettings);
        });
      });
    }
  };

  // Attach drupal behaviors to colorbox loading
  $(document).bind('cbox_complete', function() {
    if (colorbox) {
      Drupal.attachBehaviors($(colorbox)[0]);
    }
  });
})(jQuery);
