fullDownloadModal = function(parentContext) {
	//Enables the access to Global functions
	this.global = parentContext;
	this.selectedDevice = "";
	this.selectedContext = "";
	this.firstStepTaken = false;
	this.stepWidth = 80;
	this.stepNum = 0;
	this.selector = $('#fullDownloadModal');
	this.readerLinks = {
		ios : 'http://itunes.com/apps/bluefirereader',
		android : 'https://play.google.com/store/apps/details?id=com.bluefirereader',
		desktop : 'http://www.adobe.com/products/digital-editions/download.html',
		iosdrmreader : 'itms-apps://ax.search.itunes.apple.com/WebObjects/MZSearch.woa/wa/search?media=software&term=adobe+drm'
	};
	this.acsDownloadLink = 'acsDownload.action?';
	this.localDocID = '';

	this.init = function() {
		this.selector.find('#full-download-device').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#screen-desktop-private').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#screen-desktop-public').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#screen-mobile-private').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#screen-ios-mobile-private').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#screen-mobile-public').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#screen-other').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#screen-full-download-final').addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#full-download-other-box').addClass('offscreen hide').attr("aria-hidden", "true").find("button").attr("tabindex", "-1");
		this.initModalStepBars();

		//Load default device and context first time page loads
		if(!this.firstStepTaken){
			//default device
			this.selectedDevice = 'desktop';

			if (navigator.userAgent.match(/(iPad|iPhone|iPod)/i))
				this.selectedDevice = 'ios';
			else if (navigator.userAgent.match(/(Android)/i))
				this.selectedDevice = 'android';

			
			this.selectedContext = "private";
			
			var $radios = $('input:radio[name=public-private-radio]');
		    if($radios.is(':checked') === false) {
		        $radios.filter('[value='+this.selectedContext+']').prop('checked', true);
		    }
		    
		    this.firstStepTaken = true;
		}
		this.doSelectDevice();
		this.checkReadyDevice();
	};

	this.initModalStepBars = function() {
		this.stepNum = 0;
		for (var i = 1; i <= 3; i++) {
			var s = this.selector.find("#fdstep" + i);
			s.css('width', this.stepWidth);
			s.show();
			this.selector.find("#fdstep" + i + "fill").css('width', 0);
		}
	};

	this.load = function() {
		this.init();
		this.selector.find('#fulldownload-screen-title').text(i18n.device_using);
		this.selector.find('#full-download-device').removeClass('offscreen hide').removeAttr("aria-hidden").find("div[id^=select-device-]").attr("tabindex", "0");
		this.selector.find('.preview-chapter-title').html(this.bookTitle);
		this.selector.modal();
		this.reportUsage(0);
	};

	this.doProgressBar = function() {
		this.stepNum++;
		var whichStep = "#fdstep" + this.stepNum + "fill";
		this.selector.find(whichStep).animate({
			width : this.stepWidth
		}, 1000);
	};

	this.doRegressBar = function() {
		var whichStep = "#fdstep" + this.stepNum + "fill";
		this.selector.find(whichStep).animate({
			width : 0
		}, 1000);
		this.stepNum--;
	};

	this.doBack = function(event) {
		event.preventDefault();
		$(event.data.thisScreen).addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#fulldownload-screen-title').text(i18n.device_using);
		this.selector.find('#fulldownload-screen-title').removeClass('screen-title-warning');
		this.selector.find('#full-download-device').removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog").find("div[id^=select-device-]").attr("tabindex", "0");
		this.reportUsage(0);
		this.doRegressBar();
		
		updateModalTabHandlers(event.data.thisScreen, this.selector.find('#full-download-device'));
	};

	this.doFullDownloadFinal = function(event) {
		$(event.data.thisScreen).addClass('offscreen hide').attr("aria-hidden", "true");
		this.selector.find('#fulldownload-screen-title').text(i18n.download_book);
		this.selector.find('#screen-full-download-final').removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
		updateModalTabHandlers(event.data.thisScreen, this.selector.find('#screen-full-download-final'));
		this.reportUsage(2);
		this.doProgressBar();
	};

	this.doSelectDevice = function(event) {
		//handle Spacebar and enter press
		if(event && event.type === "keypress"){
			if(event.which == "13" || event.which == "32"){
				event.preventDefault();
			}else return;
		}
		
		if (event) {
			this.selectedDevice = event.data.thisDevice;
		}

		if (!this.selectedDevice) {
			return;
		}

		//Reset
		this.selector.find('#select-device-desktop').find("use").attr("xlink:href", "#device-desktop-off");
		this.selector.find('#select-device-ios').find("use").attr("xlink:href", "#device-ios-off");
		this.selector.find('#select-device-android').find("use").attr("xlink:href", "#device-android-off");
		this.selector.find('#select-device-other').find("use").attr("xlink:href", "#device-other-off");
		this.selector.find('#select-device-desktop').removeClass('select-device-selected');
		this.selector.find('#select-device-ios').removeClass('select-device-selected');
		this.selector.find('#select-device-android').removeClass('select-device-selected');
		this.selector.find('#select-device-other').removeClass('select-device-selected');
	
		this.selector.find('#select-device-desktop-selected-label').html('');
		this.selector.find('#select-device-ios-selected-label').html('');
		this.selector.find('#select-device-android-selected-label').html('');
		this.selector.find('#select-device-other-selected-label').html('');

		var $defaultFocused;
		// turn selected on
		switch (this.selectedDevice) {
		case 'desktop':
			this.selector.find('#select-device-desktop').find("use").attr("xlink:href", "#device-desktop-on");
			this.selector.find('#select-device-desktop').addClass('select-device-selected');
			this.selector.find('#select-device-desktop-selected-label').html('&nbsp;selected');
			this.selector.find('#full-download-other-box').addClass('offscreen hide').attr("aria-hidden", "true").find("button").attr("tabindex", "-1");
			this.selector.find('#full-download-input-selection').removeClass('offscreen hide').removeAttr("aria-hidden").find("input, button").removeAttr("tabindex");
			this.checkReadyDevice();
			$defaultFocused = this.selector.find('#select-device-desktop');
			break;
		case 'ios':
			this.selector.find('#select-device-ios').find("use").attr("xlink:href", "#device-ios-on");
			this.selector.find('#select-device-ios').addClass('select-device-selected');
			this.selector.find('#select-device-ios-selected-label').html('&nbsp;selected');
			this.selector.find('#full-download-other-box').addClass('offscreen hide').attr("aria-hidden", "true").find("button").attr("tabindex", "-1");
			this.selector.find('#full-download-input-selection').removeClass('offscreen hide').removeAttr("aria-hidden").find("input, button").removeAttr("tabindex");
			this.checkReadyDevice();
			$defaultFocused = this.selector.find('#select-device-ios');
			break;
		case 'android':
			this.selector.find('#select-device-android').find("use").attr("xlink:href", "#device-android-on");
			this.selector.find('#select-device-android').addClass('select-device-selected');
			this.selector.find('#select-device-android-selected-label').html('&nbsp;selected');
			this.selector.find('#full-download-other-box').addClass('offscreen hide').attr("aria-hidden", "true").find("button").attr("tabindex", "-1");
			this.selector.find('#full-download-input-selection').removeClass('offscreen hide').removeAttr("aria-hidden").find("input, button").removeAttr("tabindex");
			this.checkReadyDevice();
			$defaultFocused = this.selector.find('#select-device-android');
			break;
		case 'other':
			this.selector.find('#select-device-other').find("use").attr("xlink:href", "#device-other-on");
			this.selector.find('#select-device-other').addClass('select-device-selected');
			this.selector.find('#select-device-other-selected-label').html('&nbsp;selected');
			if (this.stepNum == 0) {
				this.doProgressBar();
			}
			this.showOtherScreenMessage();
			$defaultFocused = this.selector.find('#select-device-other');
			break;
		}
		
		//Refresh TabKey Handlers for the changed screen
		updateModalTabHandlers($("#full-download-device"), $("#full-download-device"), $defaultFocused);
	};
	
	//Validates user input in step 0 to move progress bar
	this.checkReadyDevice = function() {
		if (this.stepNum == 0 && this.selectedDevice && this.selectedContext) {
			this.selector.find('#ebc-full-download-continue').removeClass('disabled');
			this.doProgressBar();
		} else if (this.stepNum == 1 && (!this.selectedDevice || !this.selectedContext)) {
			this.doRegressBar();
		}
	};

	this.showOtherScreenMessage = function() {
		var $otherScreen = this.selector.find('#full-download-other-box');
		$otherScreen.removeClass('offscreen hide').removeAttr("aria-hidden");
		//enable Tab-ing for current screen region
		$otherScreen.find("button").removeAttr("tabindex");
		
		var $radioContainer = this.selector.find('#full-download-input-selection');
		$radioContainer.addClass('offscreen hide').attr("aria-hidden", "true");
		///Disable Tab-ing for previous screen region
		$radioContainer.find("input, button").attr("tabindex", "-1");
	};

	this.doFullDownloadScreen = function() {
		var $prevScreen, $nextScreen;
		var myCombo = this.selectedDevice + '-' + this.selectedContext;
		$prevScreen = this.selector.find('#full-download-device');
		$prevScreen.addClass('offscreen hide').attr("aria-hidden", "true");
		$prevScreen.find("div[id^=select-device-]").removeAttr("tabindex");
		
		switch (myCombo) {
		case 'desktop-private':
			$nextScreen = this.selector.find('#screen-desktop-private');
			$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
			this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.adobe_digt_edition);
			this.selector.find('#fulldownload-screen-title').addClass('screen-title-warning');
			this.doProgressBar();
			break;
		case 'desktop-public':
			$nextScreen = this.selector.find('#screen-desktop-public');
			$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
			this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.adobe_digt_edition);
			this.doProgressBar();
			break;
		case 'ios-private':
			if (navigator.userAgent.match(/(CriOS)/i)){
				$nextScreen = this.selector.find('#screen-mobile-private');
				$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
				this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.bluefire_rdr);
			}else{
				$nextScreen = this.selector.find('#screen-ios-mobile-private');
				$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
				this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.reader_app);
			}
			this.doProgressBar();
			break;
		case 'android-private':
			$nextScreen = this.selector.find('#screen-mobile-private');
			$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
			this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.bluefire_rdr);
			this.doProgressBar();
			break;
		case 'ios-public':
			$nextScreen = this.selector.find('#screen-mobile-public');
			$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
			if (navigator.userAgent.match(/(CriOS)/i)){
				this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.bluefire_rdr);
				this.selector.find('#get-bluefire-link').text(i18n.bluefire_rdr);
				this.selector.find('#done-mobile-public').text(i18n.have + " " + i18n.bluefire_rdr);
			}else{
				this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.reader_app);
				this.selector.find('#get-bluefire-link').text(i18n.reader_app.charAt(0).toUpperCase()+i18n.reader_app.slice(1));
				this.selector.find('#done-mobile-public').text(i18n.have.charAt(0).toUpperCase()+" "+(i18n.have.charAt(2).toLowerCase()+i18n.have.slice(3)) + " " + i18n.reader_app);
			}
			this.doProgressBar();
			break;
		case 'android-public':
			$nextScreen = this.selector.find('#screen-mobile-public');
			$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
			this.selector.find('#fulldownload-screen-title').text(i18n.you_need + " " + i18n.bluefire_rdr);
			this.selector.find('#get-bluefire-link').text(i18n.bluefire_rdr);
			this.selector.find('#done-mobile-public').text(i18n.have + " " + i18n.bluefire_rdr);
			this.doProgressBar();
			break;
		case 'other-public':
		case 'other-private':
			$nextScreen = this.selector.find('#screen-other');
			$nextScreen.removeClass('offscreen hide').removeAttr("aria-hidden").attr("aria-labelledby", "fulldownload-screen-title").attr("role", "alertdialog");
			this.selector.find('#fulldownload-screen-title').text('Not Supported');
			break;
		}

		this.reportUsage(1);
		updateModalTabHandlers($prevScreen, $nextScreen);
	};

	this.reportUsage = function(step) {
		var stepLabel = "DP_DOWNLOAD_" + step;		
	};

	this.handleBookDownload = function(e) {

		// we checked access when modal first opened.
		// is this needed?
		//dropdown and format error handling
		if ($("#downloadPeriodFull").length > 0 && $("#downloadPeriodFull option:selected").val() === "") {
			e.preventDefault();
			$("#downloadPeriodFullWrapper").addClass("has-error");
			$("#downloadPeriodFull").focus();
			return false;
		} else {
			if ($("#downloadPeriodFull").length > 0) {
				$("#downloadPeriodFull").removeAttr("aria-describedby");
				$("#downloadPeriodFullWrapper").removeClass("has-error");
			}
		}

		var tmpResp = this.getDownloadAccess();
		var access = tmpResp.status || 'no_access';

		if (access === 'has_access') {
			var tmpDFType = $("input[name=optradio]").length > 0 ? $("input[name=optradio]:checked").val() : "";
			var tmpDate = new Date();
			$("#fullDownloadButton").attr("href", this.acsDownloadLink + 'docID=' + this.localDocID + '&op=final&df=' + tmpDFType + '&tm=' + tmpDate.getTime());
			this.closeModal();
			return true;
		} else if (access === 'no_login') {
			this.closeModal();			
			this.checkAndShowLogin(this.localDocID);
		} else {			
			this.handleAccessError(access, tmpResp);
		}

		return false;
	};

	this.getDownloadAccess = function(op, docId) {
		var access = 'no_access';
		var tmpDFType = $("input[name=optradio]").length > 0 ? $("input[name=optradio]:checked").val() : "";
		var tmpDDays = $("#downloadPeriodFull").length > 0 ? $("#downloadPeriodFull option:selected").val() : "";
		var tmpDate = new Date();
		var tmpUrl = this.acsDownloadLink + 'docID=' + this.localDocID + (op ? '&op=' + op : '') + '&df=' + tmpDFType + '&dDays=' + tmpDDays + '&tm=' + tmpDate.getTime();
		var tmpResp = "";
		$.ajax({
			dataType : "json",
			url : tmpUrl,
			async : false,
			success : function(data) {
				tmpResp = data;
				if (data.status) {
					access = data.status;
				}
			},
		});
		if (op === "check") {
			if (typeof (tmpResp.accDtl) !== 'undefined' && tmpResp.accDtl != null) {
				if (typeof (tmpResp.accDtl.daysRequiredRange) !== 'undefined' && tmpResp.accDtl.daysRequiredRange != null) {
					//var tmpDivDwDays= "<br/><div id='downloadPeriodFullWrapper' class='row'><label for='downloadPeriodFull' class='col-xs-5 modal-label control-label '><pqCustText:message key='dd.download_period' /></label><div id='dwDaysSection' class='col-xs-6'></div><div class='col-xs-1  col-sm-1'></div></div>";
					var tmpDivDwDays = "<div id='dwDaysSection'></div>";
					$("#sampleDownloadFull").empty().append(tmpDivDwDays);
					if (tmpResp.accDtl.daysRequiredRange.length == 1) {
						var tmpPLbDay = i18n.days.replace("{0}", tmpResp.accDtl.daysRequiredRange[0]);
						$("#sampleDownloadFull").find("#dwDaysSection").empty().append(tmpPLbDay);
					}
					var tmpSelOptDays = ""
					var selOutput = [];
					$.each(tmpResp.accDtl.daysRequiredRange, function(key, value) {
						if (tmpResp.accDtl.daysRequiredRange.length == 1) {
							tmpSelOptDays = "<select class='form-control hidden ga_download_step3_days' name='downloadPeriodFull' id='downloadPeriodFull'></select>";
							if (value == "1") {
								selOutput.push('<option selected="selected" value="' + value + '">' + i18n.one_day + '</option>');
							} else {
								selOutput.push('<option selected="selected" value="' + value + '">' + i18n.days.replace("{0}", value) + '</option>');
							}
						} else {
							if (tmpResp.accDtl.daysRequiredRange.length > 1 && key == 0) {
								tmpSelOptDays = "<select class='form-control ga_download_step3_days' name='downloadPeriodFull' id='downloadPeriodFull'></select>";
								selOutput.push('<option value="">' + i18n.pqFormModal_label_request_purchase_select + '</option>');
							}
							if (value == "1") {
								selOutput.push('<option value="' + value + '">' + i18n.one_day + '</option>');
							} else {
								selOutput.push('<option value="' + value + '">' + i18n.days.replace("{0}", value) + '</option>');
							}
						}
					});
					$(tmpSelOptDays).prependTo("#dwDaysSection");
					var tmpDwErrSelOpt = "<div id='downloadPeriodFull_error' class='error-msg'></div>";
					$("#dwDaysSection").find("#downloadPeriodFull_error").append(tmpDwErrSelOpt);
					$('#downloadPeriodFull').html(selOutput.join(''));
				} else {
					if (typeof (tmpResp.accDtl.toDownloadExpiry) !== 'undefined' && tmpResp.accDtl.toDownloadExpiry != null) {
						if (tmpResp.accDtl.downloadDays === 0 && tmpResp.accDtl.downloadHours === 0) {
							$("#sampleDownloadFull").empty().append(i18n.expires_in_less_hour);
						} else {
							$("#sampleDownloadFull").empty().append(tmpResp.accDtl.downloadDaysHoursString);
						}
					}
				}
			}
			if (typeof (tmpResp.docMeta) !== 'undefined' && tmpResp.docMeta != null) {

				$(".dwFileTitle").each(function() {
					$(this).empty().html(tmpResp.docMeta.title);
				});
				$("#dwFileImg").empty().html(tmpResp.docMeta.title);
				var tmpImgUrl = $("#mayitestpg").attr("data-pqcoverdata") || "";
				if (tmpImgUrl.length > 2) {
					tmpImgUrl = tmpImgUrl.replace("docNumber", tmpResp.docMeta.docId);
					$("#dwFileImg").attr('src', tmpImgUrl);
				}
				$("#dwFileAuthor").empty().html(tmpResp.docMeta.contributors);
				$("#dwFilePages").empty().html(tmpResp.docMeta.pages);
				$("#dwFileSize").empty().html(Math.round(tmpResp.docMeta.fileSize / 1024) + 'K (' + (tmpResp.docMeta.fileSize / (1024 * 1024)).toFixed(1) + 'MB)');
				$("#downloadBookButton").attr("href", this.acsDownloadLink + 'docID=' + this.localDocID + '&op=final&tm=' + tmpDate.getTime());

				if (typeof (tmpResp.docMeta.format) !== 'undefined' && tmpResp.docMeta.format != null) {
					var formatParts = tmpResp.docMeta.format.split(';');
					var fTOutput = [];
					var radioGrp = $("<div\>", {
						id : 'fd-format-radio-group',
						'class' : 'fieldset'
					});
					var epubRadioItem = $("<div\>", {
						id : 'epubRadioItem',
						style : 'display: inline-block; padding-right: 10px;'
					});
					epubRadioItem.append($("<label for='epubRadioInput' style='font-weight: normal;padding-right: 3px;'>EPUB</label>"));
					epubRadioItem.append($("<input\>", {
						id : 'epubRadioInput',
						type : 'radio',
						name : 'optradio',
						value : 'epub'
					})).append("&nbsp;&nbsp;");
					
					var pdfRadioItem = $("<div\>", {
						id : 'pdfRadioItem',
						style : 'display: inline-block; padding-right: 10px;'
					});
					pdfRadioItem.append($("<label for='pdfRadioInput' style='font-weight: normal;padding-right: 3px;'>PDF</label>"));
					pdfRadioItem.append($("<input\>", {
						id : 'pdfRadioInput',
						type : 'radio',
						name : 'optradio',
						value : 'pdf'
					}));
					
					radioGrp.append(epubRadioItem);
					radioGrp.append(pdfRadioItem);
					
					$("#sampleDownloadFullFlFmt").attr("aria-labelledby", "downloadFormatLbl").empty().append(radioGrp);

					if (formatParts.length > 1) {
						if (formatParts.indexOf('epub') > -1) {
							epubRadioItem.find(":input").attr("checked", 'checked');
						}
					} else {
						if (formatParts.indexOf('pdf') > -1) {
							//Changing apperance of the radio button to label
							pdfRadioItem.find(":input").attr("checked", 'checked').hide();
							epubRadioItem.hide();
						} else if (formatParts.indexOf('epub') > -1) {
							epubRadioItem.find(":input").attr("checked", 'checked').hide();
							pdfRadioItem.hide();
						}
					}
				}
			}

		}//end of if check

		return tmpResp;
	};

	//This method checks user logged in or not before launching the Full download modal
	this.launchFDModal = function(e, docId, bookTitle) {
		e.preventDefault();
		this.localDocID = docId;
		this.bookTitle = bookTitle;
		
		if (!this.checkAndShowLogin(this.localDocID, e.currentTarget.id)) {	

			// check document access
			var tmpResp = this.getDownloadAccess('check', docId);
			var access = tmpResp.status || 'no_access';

			if (access === 'has_access' || access === 'no_access') {
				this.load();
			} else {
				this.handleAccessError(access, tmpResp);
			}
		}
	};

	this.checkAndShowLogin = function(docId, targetElem) {
		try {
			var action = "full_download";
			if(targetElem && targetElem.indexOf("tool_download_") > -1){
				action = "full_downloadButton";
			}else if(targetElem && targetElem.indexOf("wizard_launcher_") > -1){
				action = "full_downloadLink";
			}
			
			if (this.global.MJLoginModal(action, "s", docId, "", this.bookTitle)) {
				return false;
			}
		} catch (err) {
			var usrLnk = $("#mayitestpg").attr("data-pqSign") || "";
			if (usrLnk.length > 0) {
				window.location.href = usrLnk;
				return true;
			}
		}
		return true;
	};

	this.handleAccessError = function(access_error, tmpResp) {
		this.closeModal();
		var $DialogErrorMsg = $("#fulldownload_alert_error");
		$DialogErrorMsg.find('#downloadAlertContinue').hide();

		if (access_error === 'nupo_confirm') {
			$DialogErrorMsg.find("#fdmsg").empty().html(i18n.last_copy_book);
			$DialogErrorMsg.find('#downloadAlertContinue').show();
			$DialogErrorMsg.modal('show');
		} else if (access_error === 'no_access') {
			$DialogErrorMsg.find("#fdmsg").empty().html(i18n.not_available_download);
			$DialogErrorMsg.modal('show');
		}
	};

	this.closeModal = function() {
		this.selector.modal('hide');
	};

	//Init event handlers
	this.selector.find('#fullDownloadButton').on('click', $.proxy(this.handleBookDownload, this));
	this.selector.find('#close-button').on('click', $.proxy(this.closeModal, this));
	this.selector.find('#fd-close-button').on('click', $.proxy(this.closeModal, this));
	this.selector.find('#fda-close-button').on('click', $.proxy(this.closeModal, this));
	this.selector.find('#fdsm-close-button').on('click', $.proxy(this.closeModal, this));
	this.selector.find('#ebc-download-now').on('click', $.proxy(this.closeModal, this));
	this.selector.find('#back-close').on('click', $.proxy(this.closeModal, this));
	this.selector.find('#ebc-full-download-continue').on('click', $.proxy(this.doFullDownloadScreen, this));

	this.selector.find('#back-desktop-private').on('click', {
		thisScreen : '#screen-desktop-private'
	}, $.proxy(this.doBack, this));
	this.selector.find('#back-desktop-public').on('click', {
		thisScreen : '#screen-desktop-public'
	}, $.proxy(this.doBack, this));
	this.selector.find('#back-mobile-private').on('click', {
		thisScreen : '#screen-mobile-private'
	}, $.proxy(this.doBack, this));
	this.selector.find('#back-ios-mobile-private').on('click', {
		thisScreen : '#screen-ios-mobile-private'
	}, $.proxy(this.doBack, this));
	this.selector.find('#back-mobile-public').on('click', {
		thisScreen : '#screen-mobile-public'
	}, $.proxy(this.doBack, this));
	this.selector.find('#back-other').on('click', {
		thisScreen : '#screen-other'
	}, $.proxy(this.doBack, this));

	this.selector.find('#done-desktop-private').on('click', {
		thisScreen : '#screen-desktop-private'
	}, $.proxy(this.doFullDownloadFinal, this));
	this.selector.find('#done-desktop-public').on('click', {
		thisScreen : '#screen-desktop-public'
	}, $.proxy(this.doFullDownloadFinal, this));
	this.selector.find('#done-mobile-private').on('click', {
		thisScreen : '#screen-mobile-private'
	}, $.proxy(this.doFullDownloadFinal, this));
	this.selector.find('#done-ios-mobile-private').on('click', {
		thisScreen : '#screen-ios-mobile-private'
	}, $.proxy(this.doFullDownloadFinal, this));
	this.selector.find('#done-mobile-public').on('click', {
		thisScreen : '#screen-mobile-public'
	}, $.proxy(this.doFullDownloadFinal, this));

	this.selector.find('#select-device-desktop').on('keypress click', {
		thisDevice : 'desktop'
	}, $.proxy(this.doSelectDevice, this));
	this.selector.find('#select-device-ios').on('keypress click', {
		thisDevice : 'ios'
	}, $.proxy(this.doSelectDevice, this));
	this.selector.find('#select-device-android').on('keypress click', {
		thisDevice : 'android'
	}, $.proxy(this.doSelectDevice, this));
	this.selector.find('#select-device-other').on('keypress click', {
		thisDevice : 'other'
	}, $.proxy(this.doSelectDevice, this));

	this.selector.find('#public-private-radios').change($.proxy(function() {
		this.selectedContext = this.selector.find("input[name='public-private-radio']:checked").val();
		this.checkReadyDevice();
	}, this));

	this.selector.find("[id^='get-adobe-']").on('click', $.proxy(function() {
		window.open(this.readerLinks.desktop, '_blank');
	}, this));
	this.selector.find("[id^='get-ios-drm-']").on('click', $.proxy(function() {
		window.open(this.readerLinks.iosdrmreader, '_blank');
	}, this));
	this.selector.find("[id^='get-bluefire-']").on('click', $.proxy(function() {
		var link = "";
		if (this.selectedDevice === 'ios') {
			if(this.selector.find("[id^='get-bluefire-']").text().indexOf(i18n.reader_app.charAt(0).toUpperCase()+i18n.reader_app.slice(1)) >= 0){
				link = this.readerLinks.iosdrmreader;
			}else{
				link = this.readerLinks.ios;
			}
		} else if (this.selectedDevice === 'android') {
			link = this.readerLinks.android;
		}
		window.open(link, '_blank');
	}, this));
};
