

(function($, window, document) {
'use strict';

window.cti || (window.cti = {});
cti.janrain || (cti.janrain = {});
cti.janrain.share || (cti.janrain.share = {});

var ns = cti.janrain.share;

ns.gaTracker = function(data) {
	var category = 'Share' + (data.widget ?
			': ' + data.widget : '');
	
	if ($.isFunction(window.ga)) {
		ga('send', 'event', category, data.provider || data.eventAction, data.title);
	} else if (window._gaq) {
		_gaq.push(['_trackEvent', category,
				data.provider || data.eventAction, data.title]);
	}
};

})(window.Zepto || window.jQuery, window, document);
/**
 * Very basic implementation of the observer pattern.
 * Subscribers can add and remove callbacks to specific
 * events, which will be fired when the publishers trigger
 * those events.
 */
(function($, global) {
'use strict';

global.cti || (global.cti = {});
cti.janrain || (cti.janrain = {});

cti.janrain.events = {

	/**
	 * Adds callbacks to events. These callbacks will be fired when
	 * publisher objects trigger the corresponding events.
	 *
	 * @param name The event's name (string).
	 * @param fn The callback function to be fired.
	 * @param bind The object `this` shall reference within the callback.
	 *
	 * @returns `this`
	 */
	on: function(name, fn, bind) {
		this._events || (this._events = {});
		this._events[name] || (this._events[name] = []);

		if ($.isFunction(fn)) {
			this._events[name].push({
				fn: fn,
				bind: bind
			});
		}

		return this;
	},

	/**
	 * Removes callbacks from an event. A specific callback can be
	 * unsubscribed, all callbacks for an event can be unsubscribed,
	 * or all callbacks on a specific event for a specific object can
	 * be removed.
	 *
	 * @param name The event name (string).
	 * @param fn The callback function to be removed. If not provided,
	 *           then all callbacks matching the `name` and `bind`
	 *           parameters will be removed.
	 * @param bind The value of the callback's `this`. If, for example
	 *             two different objects implement the exact same method,
	 *             and you only want to unsubscribe one of them, specifying
	 *             the `bind` parameter allows the other object's callback
	 *             to remain subscribed.
	 *
	 * @returns `this`
	 */
	off: function(name, fn, bind) {
		var callbacks = this._events && this._events[name],
			i = callbacks && callbacks.length - 1,
			obj;

		if (callbacks) {

			if (!fn && !bind) {
				callbacks.length = [];
			} else {
				while (i >= 0) {
					obj = callbacks[i];

					if ((!fn || obj.fn === fn) && (!bind || obj.bind === bind)) {
						callbacks.splice(0, 1);
					}

					i -= 1;
				}
			}
		}

		return this;
	},

	/**
	 * Fires all callbacks subscribed to a specific event.
	 *
	 * @param name The event's name
	 *
	 * @returns `this`
	 */
	trigger: function(name) {
		var callbacks = this._events && this._events[name],
			args;

		if (callbacks) {
			args = [].slice.call(arguments, 1);
			
			$.each(callbacks, function(i, callback) {
				
				if ($.isFunction(callback.fn)) {
					callback.fn.apply((callback.bind || null), args);
				}
			});
		}

		return this;
	}
};

})(window.Zepto || window.jQuery, window);
(function($, global, document) {
'use strict';

global.cti || (global.cti = {});
cti.janrain || (cti.janrain = {});
cti.janrain.share || (cti.janrain.share = {});

var ns = cti.janrain.share,
	currentData = {};

ns.janrain = {
	initialize: function(events) {
		//console.log(events);

		this.events = events;

		this.subscribe(events);
		this.attach(events);
	},

	subscribe: function(events) {
		//this.events.on('socialShare', this.triggerFlow, this);
		this.triggerFlow(this);
	},
	
	attach: function(events) {
		/*
		janrain.events.onShareSendComplete.addHandler(function(data) {
			if (data && data.success) {
				ns.gaTracker(currentData);
			}
		}.bind(this)); */
	},
 
	buildShareUrl: function(url, provider) {
		/*provider || (provider = '');

		url = url.replace(/visit_source=[a-z]+/, '');
		url += (url.indexOf('?') === -1) ? '?' : '&';
		url += 'visit_source=' + provider;
		
		return url; */
	},
	
	triggerFlow: function(data) {
		/*data.url = this.buildShareUrl(data.url, data.provider);
		currentData = data;
		
		this.reset(data); 
		janrain.engage.share.show(); */
	},

	/**
	 * Clears out anything the user may have entered into the Janrain
	 * share form and repopulates it with the item title, URL, default
	 * share text, the media URL (is applicable), and the provider.
	 */
	//reset: function(provider, title, url, mediaUrl, shareText) {
	reset: function(data) {
		var shareText = data.text,
			mediaUrl = data.media;
		
		janrain.engage.share.reset();
		janrain.engage.share.setTitle(data.title);
		janrain.engage.share.setUrl(data.url);

		if (shareText) {
			shareText = decodeURIComponent(shareText.replace(/\+/g, ' '));

			janrain.engage.share.setMessage(shareText);
		}

		if (mediaUrl) {
			mediaUrl = (typeof mediaUrl === 'string') ?
					mediaUrl : mediaUrl.get('content');

			janrain.engage.share.setImage(mediaUrl);
		}

		janrain.engage.share.showProvider(data.provider);
	},

	getShareCounts: function(urls) {
		if ($.isArray(urls)) {
			urls = urls.map(function(url) {
				return encodeURIComponent(url);
			}).join(',');
		}
		
		$.ajax({
			data: 'urls=' + urls + '&' + new Date().getTime(),
			url: '/system/social/ajax/get_sharecounts.html',
			success: function(data, status, xhr) {
				var obj = $.parseJSON(xhr.responseText);

				this.events.trigger('shareCountsLoaded', obj);
			}.bind(this)
		});
	}
};

})(window.Zepto || window.jQuery, window, document);
(function($, window, document) {
'use strict';

window.cti || (window.cti = {});
cti.janrain || (cti.janrain = {});
cti.janrain.share || (cti.janrain.share = {});

var ns = cti.janrain.share,
	shareDefaults = Object.create(null),
	defaults = {
		cssFilePath: '/system/social/styles/share.css?07082014',
		marginTop: 5,
		minWidth: 1152,
		startY: 0
	},
	currentData;

ns.presenter = {
	initialize: function(events, options) {

		this.options = $.extend({}, defaults, options);
		this.events = events;

		this.loadCSS();
		this.loadElements();

		if (this.$all.length) {
			this.prepareForDisplay().attach();
			this.subscribe();
			this.setDefaults();
		}
	},

	setDefaults: function() {
		var l = location,
			mediaUrl = $('meta[property=og\\:image]').attr('content');

		shareDefaults.shareTitle = document.title;
		shareDefaults.shareUrl = l.protocol + '//' + l.hostname + l.pathname;
		shareDefaults.shareMedia = mediaUrl || '';
	},

	subscribe: function() {
		this.events.on('shareCountsLoaded', this.setFacebookCounts, this);
	},

	loadCSS: function() {
		var css = document.createElement('link'),
			link;
		
		if (!document.getElementById('ctSocialShareCSS')) {
			css.rel = 'stylesheet';
			css.id = 'ctSocialShareCSS';
			css.href = this.options.cssFilePath;
		
			link = document.getElementsByTagName('link')[0];
			link && link.parentNode.appendChild(css);
		}
	},

	loadElements: function() {
		var articleContainer = $('.js-socialShareAdjust');
		this.$socialShareTopMargin = this.options.startY;
		if(articleContainer.length){
			this.$socialShareTopMargin = articleContainer[0].offsetTop;
		}
		this.$sharebar = $('#ctSocialShare');
		this.$fallbacks = $('.ctSocialShare_fallback');
		this.$permanent = $('.ctSocialShare_permanent');
		this.$all = this.$sharebar.add(this.$fallbacks).add(this.$permanent);

		if (this.$sharebar.length) {
			this.$additional = this.$sharebar.find('.ctSocialShare_expandedList');
		}
	},

	setCurrent: function(width) {
		var options = this.options;

		this.current = (this.$sharebar.length && width >= options.minWidth) ?
				'sharebar' : 'fallbacks';

		return this.current;
	},

	prepareForDisplay: function() {
		this.setCurrent($(window).width());
		var topHeader = $('.js-topHeader'),
            topPos = 40,
            headerHeight = topHeader.innerHeight();
            
		if(topHeader.length) {
			if(headerHeight > 40){
				topPos = headerHeight;
			}
		}
		if (this.$sharebar.length) {
			this.$sharebar.css({
				marginTop : this.$socialShareTopMargin,
				top: topPos
			});
		}

		if (this.$permanent.length) {
			this.show(this.$permanent);
		}

		return this;
	},

	attach: function() {
		var presenter = this;

		this.setWindowObserver();
		this.setToggler();

		this.$all.each(function() {
			presenter.add($(this), true);
		});

		return this;
	},

	contains: function($sharebar) {
		return this.$all.index($sharebar) >= 0;
	},

	updateSharebars: function($sharebar) {
		this.$all = this.$all.add($sharebar);

		if ($sharebar.hasClass('ctSocialShare_fallback')) {
			this.$fallbacks = this.$fallbacks.add($sharebar);

			if (this.current === 'fallbacks') {
				this.show($sharebar);
			}
		}

		if ($sharebar.hasClass('ctSocialShare_permanent')) {
			this.$permanent = this.$permanent.add($sharebar);

			this.show($sharebar);
		}
	},

	add: function($sharebar, skipCheck) {
		if (skipCheck || !this.contains($sharebar)) {
			this.updateSharebars($sharebar);
			this.setShareHandler($sharebar);
			this.setEventTracker($sharebar);
		}

		return this;
	},
	
	setShareHandler: function($sharebar) {
		$sharebar.on('click', '.js-shareItem,.js-openWindow', $.proxy(function(e) {
			var $clicked = $(e.currentTarget),
				$sharebar = $(e.liveFired || e.delegateTarget);
	
			e.preventDefault();
			currentData = this.getShareData($sharebar, $clicked);
			
			if ($clicked.data('provider')) {
				this.sendToJanrain(currentData);
			} else if ($clicked.hasClass('js-openWindow')) {
				this.openWindow($clicked);
			}
		}, this));
	},
	
	setEventTracker: function($sharebar) {
		$sharebar.on('click', '.js-trackJanrainClick,.js-shareItem', $.proxy(function(e) {
			var $clicked = $(e.currentTarget),
				$sharebar = $(e.liveFired || e.delegateTarget);
			
			currentData = this.getShareData($sharebar, $clicked);
			ns.gaTracker(currentData);
		}, this));
	},

	getShareData: function($sharebar, $clicked) {
		var data = {};
		
		['Title', 'Url', 'Media', 'Text', 'Widget'].forEach(function(field) {
			var key = field.toLowerCase(),
				name = 'share' + key;
			
			data[key] = $clicked && $clicked.data(name) ||
					$sharebar.data(name) ||
					shareDefaults['share' + field] ||
					null;
		});
		
		data.provider = $clicked.data('provider');
		data.eventAction = $clicked.data('eventaction');
		
		return data;
	},

	getCountUrls: function() {
		var urls = [];

		this.$all.each(function(i, elem) {
			urls.push($(elem).data('counturl') || shareDefaults.shareUrl);
		});

		return urls;
	},

	sendToJanrain: function(data) {
		this.events.trigger('socialShare', data);
	},

	openWindow: function($clicked) {
		var href = $clicked.attr('href'),
			specs = 'width=960,height=450,toolbar=0,location=0,directories=0' +
					',status=0,menubar=1,scrollbars=1,resizable=0';

		if (href) {
			window.open(href, 'printWindow', specs);
		}
	},

	toggleView: function($trigger) {
		var height;

		if (this.$additional.hasClass('is-invisible')) {
			height = u$.height(this.$additional);

			this.$additional.css({
				height: 0,
				overflow: 'hidden'
			}).removeClass('is-invisible');
			u$.slideDown(this.$additional, height);
			$trigger.removeClass('is-collapsed').addClass('is-expanded');
		} else {
			this.$additional.slideUp(function() {
				$(this).addClass('is-invisible');
			});
			$trigger.removeClass('is-expanded').addClass('is-collapsed');
		}
	},

	setToggler: function() {
		if (this.$sharebar.length) {
			this.$sharebar.on('click', '.js-toggle-share', $.proxy(function(e) {
				this.toggleView($(e.currentTarget));
			}, this));
		}
	},
	
	setWindowObserver: function() {
		var $window = $(window),
			minWidth = this.options.minWidth,
			startY = 40;

		if (this.$sharebar.length) {
			this.show(this['$' + this.setCurrent($window.width())]);
			
			$window.on({
				scroll: $.proxy(function() {
					var pos = $window.scrollTop(),
						positionToStop = $('.js-shareHashStop').length ? $('.js-shareHashStop')[0].offsetTop - this.$sharebar.height() - 80 : null,
						newY;
					if(pos < positionToStop || positionToStop === null){
						newY = (pos > this.$socialShareTopMargin) ? 20 : this.$socialShareTopMargin - pos;
					}else {
						newY = positionToStop - pos;
					}
					this.$sharebar.css({'margin-top': newY});
				}, this),

				resize: $.proxy(function() {
					var displayed = this.current,
						toShow = this.setCurrent($window.width());
			
					if (displayed !== toShow) {
						this.show(this['$' + toShow]);
						this.hide(this['$' + displayed]);
					}
				}, this)
			});

			return this;
		}
	},

	show: function($sharebars) {
		$sharebars.css({
			opacity: 0,
			display: 'block',
			visibility: 'visible'
		}).animate({
			opacity: 1
		});
	},

	hide: function($sharebars) {
		$sharebars.animate({
			opacity: 0
		}, {
			complete: function() {
				$(this).css({
					display: 'none',
					visibility: 'hidden'
				});
			}
		});
	},

	setFacebookCounts: function(obj) {
		if (!obj.error) {
			this.$all.each(function(i, elem) {
				var $sharebar = $(elem),
					url = $sharebar.data('counturl') || shareDefaults.shareUrl,
					data = obj[url];
				
				if (data && data.count) {
					$sharebar.find('a[data-provider=facebook] span').text(data.count);
				}
			}.bind(this));
		}
	}
};

})(window.Zepto || window.jQuery, window, document);
(function($, window, document) {
'use strict';

window.cti || (window.cti = {});
cti.janrain || (cti.janrain = {});
cti.janrain.share || (cti.janrain.share = {});

var ns = cti.janrain.share;
var options = '';

	var events = Object.create(cti.janrain.events),
		janrain = Object.create(ns.janrain),
		presenter = Object.create(ns.presenter);
		
	presenter.initialize(events, options);
	janrain.initialize(events);

	// get the URL associated with each sharebar
	// and filter out duplicates
	janrain.getShareCounts(presenter.getCountUrls().
			filter(function(url, i, arr) {
		return arr.indexOf(url) === i;
	}));


})(window.Zepto || window.jQuery, window, document);
