(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    u$.toInt = function(item) {
        var int = parseInt(item, 10);
        return isNaN(int) ? null : int;
    };
    u$.is$ = function(obj) {
        return window.Zepto ? $.zepto.isZ(obj) : obj instanceof $;
    };
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    u$.cacheMixin = {
        setCache: function(key, data) {
            var options = this.options;
            if (options && options.cache) {
                this._cache || (this._cache = {});
                this._cache[key] = data;
            }
            return this;
        },
        getCache: function(key) {
            return this._cache && this._cache[key];
        }
    };
})(window.Zepto || window.jQuery);

(function(global) {
    "use strict";
    global.u$ || (global.u$ = {});
    u$.createFactory = function(proto, before) {
        return function() {
            var instance;
            if ($.isFunction(proto)) {
                proto = proto.apply(null, arguments);
            }
            instance = Object.create(proto);
            if (before) {
                before.apply(instance, arguments);
            }
            if (instance.initialize) {
                instance.initialize.apply(instance, arguments);
            }
            return instance;
        };
    };
})(window);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    u$.detach = function(obj, namespace, props) {
        var old = [];
        $.isArray(props) || (props = [].slice.call(arguments, 2));
        props.forEach(function(name) {
            var prop = obj[name];
            if (u$.is$(prop)) {
                prop.off("." + namespace);
            }
            old.push(prop);
            obj[name] = null;
        });
        return old;
    };
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    u$.is$ = function(obj) {
        return window.Zepto ? $.zepto.isZ(obj) : obj instanceof $;
    };
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    u$.loaderMixin = {
        showLoader: function($appendTo, beforeShow) {
            var options = this.options, appendTo = $appendTo && $appendTo.length ? $appendTo : document.body;
            if ($.isFunction(beforeShow)) {
                beforeShow.call(this);
            }
            this.$loader = $(options && options.loaderHTML || "<div />").addClass("loader").appendTo(appendTo);
            if (options && options.loaderClass) {
                this.$loader.addClass(options.loaderClass);
            }
            return this;
        },
        hideLoader: function() {
            if (this.$loader) {
                this.$loader.remove();
                this.$loader = null;
            }
            return this;
        }
    };
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    function throwIfNotString(name, item) {
        if (typeof item !== "string") {
            throw new TypeError(name + " expects a string.");
        }
    }
    u$.stripHash = function(url) {
        throwIfNotString("u$.stripHash", url);
        return url.indexOf("#") !== -1 ? url.split("#")[0] : url;
    };
    u$.getQuery = function(url) {
        var query;
        throwIfNotString("u$.getQuery", url);
        query = url.split("?");
        query = query && query[1] || "";
        return u$.stripHash(query);
    };
    u$.getObjectFromQuery = function(url) {
        var query;
        throwIfNotString("u$.getObjectFromQuery", url);
        query = u$.getQuery(url);
        if (!query) {
            return null;
        } else {
            query = query.split("&");
            return query.reduce(function(memo, param) {
                var parts = param.split("=");
                memo[parts[0].toLowerCase()] = parts[1];
                return memo;
            }, {});
        }
    };
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    var render = function() {
        var pattern = /\{\{([A-Za-z0-9\-_]+)\}\}/gi;
        function setHTML($container, item, template) {
            var html = template.replace(pattern, function(matched, key) {
                var replacement = item[key];
                return replacement || "";
            });
            if (html.length) {
                $(html).appendTo($container);
            }
        }
        return function($container, data, template) {
            $container.html("");
            if ($.isArray(data)) {
                data.forEach(function(item) {
                    setHTML($container, item, template);
                });
            } else {
                setHTML($container, data, template);
            }
        };
    }();
    u$.renderJSON = function($el, json, template) {
        var obj = $.parseJSON(json);
        if ($.isFunction(template)) {
            template($el, obj);
        } else {
            render($el, obj, template);
        }
    };
    u$.render = function(parent, data, prepend) {
        var $elem = $.isArray(data) ? $.apply($, data) : $(data), method = prepend ? "prependTo" : "appendTo";
        if (parent) {
            $elem[method](parent);
        }
        return $elem;
    };
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    var toZero = {
        paddingTop: 0,
        paddingBottom: 0,
        marginTop: 0,
        marginBottom: 0
    }, boxStyles = $.extend(Object.create(toZero), {
        height: 0
    }), initial = {
        display: "block",
        height: 0,
        overflow: "hidden"
    };
    function setOptions() {
        var options = {
            duration: arguments[0]
        };
        if ($.isFunction(arguments[1])) {
            options.complete = arguments[1];
        } else {
            options.easing = arguments[1];
            options.complete = arguments[2];
        }
        return options;
    }
    function extendOpts($el, options, fn) {
        var complete = options && options.complete;
        return $.extend(options || {}, {
            complete: function() {
                fn.call($el);
                if ($.isFunction(complete)) {
                    complete.call($el);
                }
            }
        });
    }
    function getOverflow($el) {
        var css = {
            overflowY: $el.css("overflow-y"),
            overflowX: $el.css("overflow-x")
        };
        if (css.overflowY !== "scroll") {
            css.overflowY = "hidden";
        }
        return css;
    }
    function slideUp($el, height, options) {
        var props = !height ? boxStyles : {
            height: height
        }, old = u$.getStyles($el, props), opts = extendOpts($el, options, function() {
            if (!height) {
                $(this).css("display", "none").css(old);
            }
        }), css = getOverflow($el);
        css.height = u$.height($el);
        $el.css(css).animate(props, opts);
    }
    function slideDown($el, height, options) {
        var props = !$el.get(0).offsetHeight ? boxStyles : {}, toHeight = height || u$.height($el), css = getOverflow($el), toAnimate = u$.mapStyles($el, props);
        toAnimate.height = toHeight;
        u$.mapStyles($el, initial);
        $el.css(css).animate(toAnimate, options);
    }
    u$.slideUp = function($el, height, options) {
        height = u$.toInt(height) ? height : 0;
        slideUp($el, height, options);
    };
    u$.slideDown = function($el, height, options) {
        height = u$.toInt(height) ? height : 0;
        slideDown($el, height, options);
    };
    u$.slide = function($el, height, options) {
        if (height >= 0) {
            slideUp($el, height, options);
        }
    };
    if (!$.fn.slideUp) {
        $.fn.slideUp = function(options) {
            if (!$.isPlainObject(options)) {
                options = setOptions.apply(null, arguments);
            }
            slideUp(this, 0, options);
            return this;
        };
    }
    if (!$.fn.slideDown) {
        $.fn.slideDown = function(options) {
            if (!$.isPlainObject(options)) {
                options = setOptions.apply(null, arguments);
            }
            slideDown(this, 0, options);
            return this;
        };
    }
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    window.u$ || (window.u$ = {});
    var unhideProps = {
        display: "block",
        position: "absolute",
        visibility: "hidden"
    };
    u$.getStyles = function($el, props, callback) {
        var old = {};
        $.each(props, function(name, value) {
            old[name] = $el.css(name);
            if ($.isFunction(callback)) {
                callback($el, name, value);
            }
        });
        return old;
    };
    u$.mapStyles = function() {
        function setStyle($el, name, value) {
            $el.css(name, value);
        }
        return function($el, props) {
            return u$.getStyles($el, props, setStyle);
        };
    }();
    u$.resetMappedStyles = function($el, props, fn) {
        var old = u$.mapStyles($el, props), retValue = fn($el);
        $.each(old, function(name, value) {
            $el.css(name, value);
        });
        return retValue;
    };
    u$.height = function() {
        var props = $.extend(Object.create(unhideProps), {
            paddingTop: 0,
            paddingBottom: 0,
            borderTop: 0,
            borderBottom: 0
        });
        return function($el) {
            return u$.resetMappedStyles($el, props, function($el) {
                return $el.get(0).offsetHeight;
            });
        };
    }();
})(window.Zepto || window.jQuery);

(function($, window, document) {
    "use strict";
    window.u$ || (window.u$ = {});
    var defaults = {
        collapsedClass: "is-collapsed",
        eventNamespace: null,
        events: null,
        expandedClass: "is-expanded",
        foldClass: "js-fold",
        multiOpen: true,
        setAriaAttributes: true,
        togglerClass: "js-toggler"
    }, setEvent = function() {
        var callbacks = {
            toggle: function(e) {
                var index = this.$togglers.index(e.currentTarget), $fold = this.getFold($(e.currentTarget), index);
                e.preventDefault();
                this.toggle($fold, index);
            },
            keyToggle: function(e) {
                var $toggler = $(e.currentTarget);
                if ((e.which === 13 || e.which === 32) && $toggler.hasClass(this.options.togglerClass)) {
                    e.preventDefault();
                    callbacks.toggle.call(this, e);
                }
            }
        };
        return function(name, $elems, sel, event) {
            var base = this.options.eventNamespace || "", ns = base + "Accordion." + name + "Event", callback = $.proxy(callbacks[name], this);
            $elems.on((event || "click") + "." + ns, sel, callback);
        };
    }(), accordionProto = {
        options: defaults,
        initialize: function($container, options) {
            this.options = $.extend({}, this.options, options || null);
            this.$container = $container;
            this.reset();
            this.attach($container);
        },
        reset: function() {
            var opts = this.options;
            this.$togglers = this.$container.find("." + opts.togglerClass);
            this.$folds = this.$container.find("." + opts.foldClass);
            if (this.options.setAriaAttributes) {
                this.setAriaAttributes(this.$togglers);
            } else {
                this.options.setAriaAttributes = true;
            }
        },
        setAriaAttributes: function($togglers) {
            var ns = (this.options.eventNamespace || "") + "-accordion-";
            $togglers.each(function(i, toggler) {
                var id = ns + i.toString(), $toggler = $(toggler), $fold = this.getFold($toggler, i), isExpanded = !$fold.hasClass(this.options.collapsedClass);
                $toggler.attr("aria-controls", id);
                $toggler.attr("role", "tab");
                $toggler.attr("aria-selected", "false");
                $toggler.attr("tabindex", "-1");
                $fold.attr("aria-labelledby", id);
                $fold.attr("role", "tabpanel");
                $fold.attr("aria-expanded", isExpanded);
                $fold.attr("aria-hidden", !isExpanded);
            }.bind(this));
        },
        attach: function($elems) {
            var togglerClass = this.options.togglerClass, selector = $.isFunction(togglerClass) ? null : "." + togglerClass;
            setEvent.call(this, "toggle", $elems, selector);
            setEvent.call(this, "keyToggle", $elems, selector, "keyup");
        },
        detach: function($togglers) {
            var ns = (this.options.eventNamespace || "") + "Accordion", args;
            if ($togglers && $togglers.length) {
                $togglers.removeClass(this.options.togglerClass);
                this.$togglers = this.$togglers.not($togglers);
            } else {
                args = u$.detach(this, ns, "$container", "$togglers", "$folds");
            }
            args || (args = [ $togglers ]);
            args.unshift("detach");
            this.emit.apply(this, args);
        },
        toggle: function($fold, index) {
            var method = $fold.hasClass(this.options.expandedClass) ? "collapse" : this.options.url ? "load" : "expand";
            this[method]($fold, index);
        },
        expand: function($fold, index) {
            var height = $fold.data("maxheight") || $fold.css("max-height"), opts = this.options;
            this.emit("beforeShow", $fold, this.$togglers, index);
            $fold.removeClass(opts.collapsedClass).addClass(opts.expandedClass);
            u$.slideDown($fold, height);
            if (!this.options.multiOpen) {
                this.collapseAll($fold);
            }
            this.emit("show", $fold, this.$togglers, index);
        },
        collapseAll: function($current) {
            this.$folds.each(function(i, fold) {
                if ($current && fold !== $current.get(0)) {
                    this.collapse($(fold), i);
                }
            }.bind(this));
        },
        collapse: function($fold, index) {
            this.emit("beforeHide", $fold, this.$togglers, index);
            $fold.slideUp({
                complete: function() {
                    var opts = this.options;
                    $fold.css("display", "none").removeClass(opts.expandedClass).addClass(opts.collapsedClass);
                }.bind(this)
            });
            this.emit("hide", $fold, this.$togglers, index);
        },
        getFold: function($toggler, index) {
            var foldId = $toggler.data("foldid");
            return foldId ? $("#" + foldId) : this.$folds.eq(index);
        },
        emit: function(name) {
            var events = this.options.events, start = events ? 0 : 1, method = events ? this.trigger : this.options[name];
            if ($.isFunction(method)) {
                method.apply(this, [].slice.call(arguments, start));
            }
        }
    }, ajaxAccordionProto = $.extend(Object.create(accordionProto), u$.cacheMixin, u$.loaderMixin, {
        options: $.extend({}, defaults, {
            cache: true
        }),
        render: function(response, $fold, index) {
            if (this.options.responseType === "json") {
                u$.renderJSON($fold, response, this.options.template);
            } else {
                $fold.html(response);
            }
            this.expand($fold, index);
        },
        load: function($fold, index) {
            var query = this.options.query || "", cache;
            if ($.isFunction(query)) {
                query = query($fold, index, this.$togglers);
            }
            cache = this.getCache(query);
            if (cache) {
                this.render(cache, $fold, index);
            } else {
                this.send(query, $fold, index);
            }
        },
        send: function(query, $fold, index) {
            $.ajax({
                url: this.options.url,
                data: query,
                beforeSend: function(xhr, settings) {
                    this.showLoader();
                    this.emit("beforeSend", $fold, this.$togglers, index, xhr, settings);
                }.bind(this),
                success: function(data, status, xhr) {
                    this.hideLoader();
                    this.setCache(query, xhr.responseText);
                    this.render(xhr.responseText, $fold, index);
                }.bind(this),
                error: function(xhr, errorType, error) {
                    this.emit("ajaxError", $fold, this.$togglers, index, xhr, errorType, error);
                }.bind(this)
            });
        }
    });
    u$.accordion = function($container, options) {
        var proto = accordionProto, instance;
        if (!u$.is$($container)) {
            options = $container;
            $container = null;
        }
        if (options && options.url) {
            proto = ajaxAccordionProto;
        }
        instance = Object.create(proto);
        if (options && options.events) {
            $.extend(instance, options.events);
        }
        instance.initialize($container && $container.eq(0), options);
        return instance;
    };
})(window.Zepto || window.jQuery, window, document);

(function($, window, document) {
    "use strict";
    window.cti || (window.cti = {});
    cti.getZipFromIP = function() {};
})(window.Zepto || window.jQuery, window, document);

(function($, window, document) {
    "use strict";
    window.cti || (window.cti = {});
    var hideTimer, hoverProto = {
        initialize: function($hover) {
            var isLightbox;
            if ($hover && $hover.length) {
                isLightbox = this.setOverlay();
                this.$hover = $hover;
                if (this.doShow()) {
                    this.fixCloseButton();
                    setTimeout(function() {
                        this.loadModal(isLightbox);
                    }.bind(this), this.setDelay());
                } else {
                    this.$hover.empty().remove();
                }
            }
        },
        setOverlay: function() {
            var $overlay = $("#overlay"), isLightbox = !!$overlay.length;
            $overlay.remove();
            return isLightbox;
        },
        doShow: function() {
            var html = this.$hover.html().toLowerCase(), blackImg = "http://content.aimatch.com/cti/black_default.gif";
            if (html.indexOf("empty hover ad") === -1 && html.indexOf(blackImg) === -1 && this.$hover.children().length > 1) {
                return true;
            } else {
                return false;
            }
        },
        loadModal: function(isLightbox) {
            this._modal = u$.modal({
                destroyOnClose: true,
                isLightbox: isLightbox,
                modals: this.$hover,
                show: function($modal) {
                    $modal.css("visibility", "visible");
                    this.attachModalEvents($modal);
                    hideTimer = setTimeout(function() {
                        this._modal.hide();
                    }.bind(this), 15e3);
                }.bind(this)
            });
        },
        attachModalEvents: function($modal) {
            $modal.on("click", "a,object,embed", $.proxy(function(e) {
                var $el = $(e.currentTarget), pattern = /^(javascript|\s+$|#|\?)/;
                clearTimeout(hideTimer);
                if (!e.currentTarget.href) {
                    this._modal.hide();
                } else {
                    setTimeout(function() {
                        this._modal.hide();
                    }.bind(this), 500);
                }
                if (!$el.hasClass("js-closeModal") && !!$el.attr("href") && !pattern.test($el.attr("href"))) {
                    e.preventDefault();
                    window.open($el.attr("href"));
                }
            }, this));
        },
        setDelay: function() {
            return (u$.toInt(this.$hover.data("delay")) || 0) * 1e3;
        },
        fixCloseButton: function() {
            this.$hover.find("#closeHoverAd").addClass("js-closeModal");
        }
    };
    cti.hoverAd = function() {
        return Object.create(hoverProto).initialize($("#hover"));
    };
})(window.Zepto || window.jQuery, window, document);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.backToTop = function(topTrigger) {
        topTrigger.on("click", function() {
            $("html, body").animate({
                scrollTop: 0
            }, "slow");
            return false;
        });
    };
})(window, window.jQuery);

$(function() {
    var topTrigger = $(".js-backToTop");
    if (topTrigger.length) {
        cti.backToTop(topTrigger);
    }
});

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.charCount = u$.createFactory({
        initialize: function(messageBox, maxChar) {
            messageBox.on("input", function(e) {
                var entry = $(this).val(), str = new String(entry), len = str.length, limitSpan = $("#limit-text"), len = maxChar - len;
                if (len < 0) {
                    $(this).val(entry.slice(0, maxChar));
                    limitSpan.html("<strong>0</strong> character remaining");
                } else if (len > 1) {
                    limitSpan.html("<strong>" + len + "</strong> characters remaining");
                } else {
                    limitSpan.html("<strong>" + len + "</strong> character remaining");
                }
            });
        }
    });
    $(function() {
        var messageBox = $("#message");
        if (messageBox.length) {
            var maxChar = messageBox.data("maxchar") || 2e3;
            cti.charCount(messageBox, maxChar);
        }
    });
})(window, window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.clearField = function(selector, fn) {
        var inputs = $(selector);
        if (inputs.length) {
            inputs.on({
                focus: function(e) {
                    var input = $(this);
                    if (!input.data("originalVal")) {
                        input.data("originalVal", input.val());
                    }
                    input.val("");
                    if ($.isFunction(fn)) {
                        fn(input, "focus", e);
                    }
                },
                blur: function(e) {
                    var input = $(this);
                    if (!input.val()) {
                        input.val(input.data("originalVal"));
                    }
                    if ($.isFunction(fn)) {
                        fn(input, "blur", e);
                    }
                }
            });
        }
    };
    $(function() {
        var clearFieldTrigger = $(".clearField");
        if (clearFieldTrigger.length) {
            cti.clearField(clearFieldTrigger);
        }
    });
})(window, window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.clickTrack = u$.createFactory({
        initialize: function($anchors) {
            $(document.body).on("click", $anchors, function(event) {
                var trigger = $(this), trackCategory = trigger.data("category"), trackAction = trigger.data("action"), trackLabel = trigger.data("label"), trackUrl = trigger.attr("href"), target = trigger.attr("target"), noRefresh = trigger.data("norefresh");
                if (trackCategory.length) {
                    ga("send", "event", trackCategory, trackAction, trackLabel || trackUrl);
                    if ((typeof noRefresh == "undefined" || noRefresh !== true) && target !== "_blank") {
                        if (trackCategory != "NL Sub") {
                            event.preventDefault();
                        }
                        if (trackUrl && !trigger.hasClass("external")) {
                            setTimeout(function() {
                                location.href = trackUrl;
                            }, 200);
                        }
                    }
                }
            });
        }
    });
    $(function() {
        var eventTrigger = ".js-clickTrack";
        if ($(eventTrigger).length) {
            cti.clickTrack(eventTrigger);
        }
    });
})(window, window.jQuery);

(function($, global, document) {
    "use strict";
    global.cti || (global.cti = {});
    $(function() {
        var $body = $(document.body);
        $body.clearInput(".js-clear");
        cti.hoverAd && cti.hoverAd();
    });
})(window.Zepto || window.jQuery, window, document);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.dropcap = u$.createFactory({
        initialize: function(article) {
            console.log(article);
            this.container = article;
            this.implementDropcap();
        },
        implementDropcap: function() {
            var article = this.container, pageNumber = this.container.find(".js-presentPage").text(), logInBox = this.container.find(".js-unsubscribed"), children, pattern, dropcap, first, html, p;
            if (this.container.length) {
                children = article.children();
                p = children.filter("p.text").eq(0);
                dropcap = p.length && article.find(".dropcap");
                if (p.length && !dropcap.length && children.length > 5 && (pageNumber === "1" || pageNumber === "" || logInBox.length > 0)) {
                    html = p.eq(0).text().trim();
                    var articleHTML = $(".content-body").html();
                    var p1 = articleHTML.split("</p>");
                    var pText = p1[0].split('<p class="text">');
                    first = html.slice(0, 1);
                    if (typeof pText[1] !== "undefined") {
                        if (pText[1].indexOf("<") == 0) {
                            var openTag = pText[1].split(">");
                            var closeTag = openTag[1].split("</");
                            var pOutput = "";
                            var pLength = openTag.length;
                            var stringCut = false;
                            openTag.forEach(function(item, index) {
                                if (item.indexOf("<") != 0 && stringCut == false) {
                                    item = item.substr(1);
                                    stringCut = true;
                                }
                                if (index != pLength) pOutput += item + ">";
                            });
                            var firstText = pOutput.substr(0, pOutput.length - 1);
                        } else {
                            var firstText = pText[1].trim().substr(1);
                        }
                        pattern = /[A-Za-z]/;
                        if (pattern.test(first)) {
                            p.html('<span class="article-dropcap uppercase u-left">' + first + "</span>" + firstText);
                        }
                    }

                }
            }
        }
    });
})(window, window.jQuery);

$(function() {
    var articleContent = $(".content-body");
    if (articleContent.length) {
        cti.dropcap(articleContent);
    }
});

$(".article-embed").each(function() {
    var articleID = $(this).attr("articleid");
    var fetchURL = "/system/ajax/embed_article.html?articleid=" + articleID;
    $(this).load(fetchURL);
});

$(".twitter-embed").each(function() {
    var tweet = $(this);
    var id = $(this).attr("embedid");
    twttr.widgets.createTweet(id, tweet[0], {
        conversation: "none",
        cards: "hidden",
        linkColor: "#cc0000",
        theme: "light",
        align: "center"
    }).then(function(el) {
        el.contentDocument.querySelector(".footer").style.display = "none";
    });
});

$(".chart-embed").each(function() {
    var chart = $(this);
    var id = $(this).attr("embedid");
    var iframe = '<iframe title="" aria-label="" id="datawrapper-chart-' + id + '" src="//datawrapper.dwcdn.net/' + id + '/" scrolling="no" frameborder="0" style="width: 0; min-width: 100% !important; border: none;" height="400"></iframe><div class="credit slideshow-caption" style="text-align: initial;margin-bottom: 10px;"><a class="expand-it" href="//datawrapper.dwcdn.net/' + id + '" target="_blank">expand graph</a></div>';
    $(this).html(iframe);
});

$(".soundcloud-embed").each(function() {
    var soundcloud = $(this);
    var src = $(this).attr("data-href");
    var iframe = '<iframe width="100%" height="200" scrolling="no" frameborder="no" allow="autoplay" src="' + src + '"></iframe>';
    $(this).html(iframe);
});

$(".spotify-embed").each(function() {
    var spotify = $(this);
    var src = $(this).attr("data-href");
    var iframe = '<iframe src="' + src + '" width="300" height="380" frameborder="0" allowtransparency="true" allow="encrypted-media"></iframe>';
    $(this).html(iframe);
});
(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.exploreMenu = u$.createFactory({
        initialize: function(container, dropDownContainer, trigger) {
            if (dropDownContainer.find(".js-subscribe").length == 0) {
                dropDownContainer.addClass("explore-nav");
            }
            if (trigger.length) {
                var getbodyWidth = $("body").width(), timeOutFlag = false, displayMenu;
                var isiPad = navigator.userAgent.match(/iPad/i) != null;
                if (isiPad) {
                    this.ipadMenu(getbodyWidth, trigger);
                } else {
                    container.on("mouseenter mouseleave", ".js-menuTrigger", function(event) {
                        var currentTrigger = $(this), menuDropdown = currentTrigger.find(".js-menuDropDown");
                        if (event.type == "mouseenter" || event.type == "mouseover") {
                            if (!displayMenu) {
                                displayMenu = window.setTimeout(function() {
                                    if (timeOutFlag === true) {
                                        clearTimeout(this.hideNav);
                                    }
                                    menuDropdown.css({
                                        left: 0,
                                        width: getbodyWidth
                                    });
                                    menuDropdown.fadeIn(300);
                                }, 500);
                                return displayMenu;
                            }
                        }
                        if (displayMenu) {
                            window.clearTimeout(displayMenu);
                            displayMenu = null;
                        }
                        if (event.type == "mouseleave" || event.type == "mouseout") {
                            this.hideNav = setTimeout(function() {
                                menuDropdown.fadeOut(300);
                                timeOutFlag = true;
                            }, 200);
                        }
                    });
                }
            }
        },
        ipadMenu: function(getbodyWidth, trigger) {
            var me = this;
            this.hrefArr = [ "#", "" ];
            this.menuClickCount = {};
            this.resetAllCounters(trigger);
            trigger.on("touchstart", function(event) {
                var currentTrigger = $(this), menuClickTrigger = currentTrigger.children(":first-child"), menuClickHref = menuClickTrigger.attr("href"), otherDropdown = trigger.not(this).find(".js-menuDropDown");
                me.menuDropdown = currentTrigger.find(".js-menuDropDown");
                otherDropdown.each(function(index, elem) {
                    if ($(elem).css("display") == "block") {
                        $(elem).fadeOut(300);
                        me.resetCounter($(elem).parent(".js-menuTrigger"));
                    }
                });
                if (typeof menuClickHref != "undefined" && $.inArray(menuClickHref, me.hrefArr) == -1) {
                    me.menuClickCount[menuClickHref]++;
                    if (me.menuClickCount[menuClickHref] > 1) {
                        menuClickTrigger.removeAttr("data-norefresh");
                        menuClickTrigger.off("click");
                    } else if (typeof menuClickTrigger.attr("data-norefresh") == "undefined") {
                        menuClickTrigger.attr("data-norefresh", "true");
                        menuClickTrigger.on("click", function(event) {
                            event.preventDefault();
                        });
                    }
                } else if (me.menuClickCount[menuClickHref] > 0) {
                    me.menuClickCount[menuClickHref]--;
                }
                me.menuDropdown.css({
                    left: 0,
                    width: getbodyWidth
                });
                me.menuDropdown.fadeIn(400);
            });
            $(document).on("touchstart", function(event) {
                if (!$(event.target).closest(".js-menuTrigger").length) {
                    if (typeof me.menuDropdown != "undefined") {
                        me.menuDropdown.fadeOut(300);
                        me.resetAllCounters(trigger);
                    }
                }
            });
        },
        resetAllCounters: function(trigger) {
            var me = this;
            trigger.each(function(index, elem) {
                me.resetCounter($(elem));
            });
        },
        resetCounter: function(elem) {
            var me = this, elemHref = elem.children(":first-child").attr("href");
            if (typeof elemHref != "undefined" && $.inArray(elemHref, me.hrefArr) == -1) {
                me.menuClickCount[elemHref] = 0;
            }
        }
    });
    $(function() {
        var menuContainer = $(".js-menuContainer"), dropDownContainer = $(".js-exploreDropDownMenu"), menuTrigger = $(".js-menuTrigger");
        var calExploreMenu = function() {
            if (menuContainer.length) {
                cti.exploreMenu(menuContainer, dropDownContainer, menuTrigger);
            }
        };
        calExploreMenu();
        $(window).on("resize", function() {
            calExploreMenu();
        });
    });
})(window, window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.fixedHeader = u$.createFactory({
        initialize: function(fixHeader, inputElem) {
            this.fixHeaderHeight = fixHeader.offset().top;
            this.searchShareCont = inputElem.searchShareCont;
            this.previousScroll = $(window).scrollTop();
            this.searchBox = inputElem.searchBox;
            this.shareBox = inputElem.shareBox;
            this.closeBtn = inputElem.closeBtn;
            this.totalPages = $(".js-fixedHeader_start").find(".js-countPages").data("pages");
            this.presentPage = $(".js-fixedHeader_start").find(".js-presentPage").text();
            this.singlePageCheck = $(".js-fixedHeader_solo");
            this.fixHeaderProgress(fixHeader);
            if (this.searchBox.length || this.shareBox.length) {
                this.slideDiv(fixHeader);
            }
            if (typeof this.closeBtn != "undefined") {
                this.closeSubContent();
            }
        },
        fixHeaderProgress: function(fixHeader) {
            var mainObj = this;
            $(window).scroll(function(e) {
                var currentScroll = $(window).scrollTop(), currentLocationId, currentLocation, fhStartPoint, shortList = $(".js-listContainer");
                if (shortList.length) {
                    currentLocationId = shortList.find("a.active:last").data("articleid");
                    currentLocation = $("#" + currentLocationId);
                    fhStartPoint = currentLocation.find(".js-fixedHeader_start");
                } else {
                    currentLocation = $(".js-displayArticleContent");
                    fhStartPoint = currentLocation.find(".js-fixedHeader_start");
                }
                var fhTopOffset = fhStartPoint.offset().top, getWindowHeight, getContentHeight, fhEndPoint = currentLocation.find(".js-fixedHeader_stop");
                if (fhTopOffset <= $(window).scrollTop()) {
                    var scrollPercent = 0;
                    getWindowHeight = parseInt($(window).scrollTop() - fhTopOffset);
                    getContentHeight = parseInt(fhEndPoint.offset().top - fhTopOffset);
                    scrollPercent = Math.round(getWindowHeight / getContentHeight * 100);
                    if (currentScroll > mainObj.previousScroll) {
                        if (shortList.length) {
                            if (mainObj.searchShareCont.css("display") == "block") {
                                mainObj.searchShareCont.css("display", "none");
                            }
                            if (!fixHeader.hasClass("box-shadow")) {
                                fixHeader.addClass("box-shadow");
                            }
                            if (fixHeader.css("display") == "block") {
                                fixHeader.slideUp("slow");
                            }
                        } else {
                            fixHeader.slideDown("slow");
                        }
                    } else if (currentScroll == mainObj.previousScroll) {} else {
                        if (fixHeader.css("display") == "none") {
                            fixHeader.slideDown("slow");
                        }
                    }
                    if (getWindowHeight >= mainObj.fixHeaderHeight) {
                        var position = parseInt(scrollPercent);
                        if (position <= 100) {
                            if (mainObj.singlePageCheck.length > 0 || mainObj.totalPages === 1) {
                                if (mainObj.singlePageCheck.length > 0) {
                                    position = (getWindowHeight + 100) / getContentHeight * 100 + 40;
                                    if (position < 60) {
                                        position = 0;
                                    }
                                } else {
                                    position = parseInt(scrollPercent);
                                }
                            } else if (typeof mainObj.totalPages != "undefined") {
                                if (mainObj.presentPage === 1) {
                                    position = parseInt(scrollPercent);
                                } else {
                                    var presentPaging = mainObj.presentPage - 1, previousProgress = parseFloat(presentPaging * (100 / mainObj.totalPages)).toFixed(2), contentHeight = fhStartPoint.height(), contentContainer = $(".js-postContent"), movement, scrollPercent;
                                    if (contentContainer.length) {
                                        contentHeight = contentHeight + parseInt(contentContainer.height());
                                    }
                                    movement = getWindowHeight / contentHeight;
                                    scrollPercent = movement * 100 / mainObj.totalPages;
                                    position = parseInt(previousProgress) + parseInt(scrollPercent);
                                }
                            }
                            if (position >= 98 && position < 100) {
                                position = 100;
                            }
                            $(".fix-header").find(".progress-bar-active").css("width", position + "%");
                        } else {
                            mainObj.searchShareCont.slideUp("slow");
                            fixHeader.addClass("box-shadow");
                        }
                    } else {
                        fixHeader.slideUp("slow").addClass("box-shadow");
                        mainObj.searchShareCont.slideUp("slow");
                    }
                } else {
                    if ($(window).scrollTop() < $(".js-articleContent").eq(0).offset().top) {
                        mainObj.shareBox.slideUp("slow");
                        mainObj.searchShareCont.slideUp("slow");
                        fixHeader.slideUp("slow");
                        fixHeader.addClass("box-shadow");
                        position = 0;
                    }
                }
                mainObj.previousScroll = currentScroll;
            });
        },
        slideDiv: function(fixHeader) {
            var mainObj = this;
            $(document).on("click", ".js-searchTrigger,.js-shareTrigger", function(e) {
                e.preventDefault();
                var getVal, getActionClass, otherClass;
                if ($(this).attr("class").indexOf("js-searchTrigger") != -1) {
                    getActionClass = mainObj.searchBox;
                    otherClass = mainObj.shareBox;
                    getVal = 1;
                } else {
                    getActionClass = mainObj.shareBox;
                    otherClass = mainObj.searchBox;
                }
                var getActionfn = function() {
                    getActionClass.fadeToggle(100, function() {
                        if (mainObj.searchShareCont.css("display") == "none") {
                            mainObj.searchShareCont.fadeIn(500);
                            getActionClass.css("display", "block");
                            if (getVal == 1) {
                                $("#searchQuery").focus();
                            }
                            fixHeader.removeClass("box-shadow");
                        }
                        if (getActionClass.css("display") == "none") {
                            fixHeader.addClass("box-shadow");
                            mainObj.searchShareCont.fadeOut(500);
                        } else {
                            mainObj.searchShareCont.fadeIn(500);
                            if (getVal == 1) {
                                $("#searchQuery").focus();
                            }
                        }
                    });
                };
                if (typeof otherClass != "undefined" && otherClass.length > 0) {
                    otherClass.fadeOut(500, function() {
                        getActionfn();
                    });
                } else {
                    getActionfn();
                }
                $(document).click(function(e) {
                    var fixHeaderCont = $(".js-fixedHeader, .js-fixedHeader .header-content");
                    if (!mainObj.searchShareCont.is(e.target) && !fixHeaderCont.is(e.target) && mainObj.searchShareCont.has(e.target).length === 0 && fixHeaderCont.has(e.target).length === 0) {
                        getActionClass.fadeOut();
                        mainObj.searchShareCont.fadeOut(500);
                        fixHeader.addClass("box-shadow");
                    }
                });
            });
        },
        closeSubContent: function() {
            var mainObj = this;
            this.closeBtn.on("click", function(event) {
                event.preventDefault();
                mainObj.searchShareCont.fadeOut("slow");
            });
        }
    });
    $(function() {
        var fixHeader = $(".js-fixedHeader");
        if (fixHeader.length) {
            window.scrollTo(0, 0);
            var inputElem = {
                searchShareCont: $(".js-searchShareCont"),
                searchBox: $(".js-searchBox"),
                shareBox: $(".js-shareBox"),
                closeBtn: $(".js-btnClose")
            };
            cti.fixedHeader(fixHeader, inputElem);
        }
    });
})(window, window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.globalHeader = u$.createFactory({
        initialize: function(container, inputElem) {
            this.handleClick = "touchstart, click";
            this.documentClick = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ? "touchstart" : "click";
            this.globalNavIcon = inputElem.globalNavIcon;
            this.navCloseIcon = inputElem.navCloseIcon;
            this.navMenuElement = inputElem.navMenuElement;
            this.searchTrigger = inputElem.searchTrigger;
            this.container = container;
            this.createOverlay();
            this.showMobileNav();
            $(this.container).each(function(index, headerElem) {
                var headerElem = $(headerElem);
                headerElem.attr("data-topoffset", headerElem.offset().top);
            });
            if (this.documentClick === "touchstart") {
                this.activeMenuHeight();
            }
            this.hideMobileNav();
            this.windowClick();
            this.menuDropDown();
        },
        createOverlay: function() {
            $("body").append('<div class="js-globalHeaderOverlay display-none"></div>');
            this.overlayElem = $(".js-globalHeaderOverlay");
        },
        showMobileNav: function() {
            var mainObj = this;
            this.globalNavIcon.on(mainObj.handleClick, function() {
                var otherMenu = $(".js-Nav.js-activeMenu"), calcMenu = $(".js-calcNavTrigger").find(".js-Nav"), currentTrigger = $(this), isToggleItems = currentTrigger.data("istoggleitems"), setNavTop = currentTrigger.data("settop");
                if (calcMenu.css("left") === "0px" && currentTrigger.hasClass("js-navIcon")) {
                    calcMenu.animate({
                        left: "-1150px"
                    }, "2000").removeClass("js-activeMenu");
                }
                if (typeof otherMenu !== "undefined" && otherMenu.length) {
                    var otherParent = otherMenu.parents(mainObj.container).eq(0), otherNavIcon = otherParent.find(".js-navIcon"), otherNavClose = otherParent.find(".js-closeIcon");
                    otherNavClose.hide();
                    otherNavIcon.show();
                    $(otherMenu).animate({
                        left: "-1150px"
                    }, "2000").removeClass("js-activeMenu");
                }
                var parentElem = currentTrigger.hasClass("js-initNavIcon") ? $(".js-calcNavTrigger") : currentTrigger.parents(mainObj.container).eq(0), navCloseIcon = parentElem.find(".js-closeIcon"), globalNavElement = parentElem.find(".js-Nav"), setTop = 0;
                if (parentElem.data("autoexpand")) {
                    var currentLocation = window.location.href;
                    $.each(mainObj.navMenuElement, function(elemIndex, dropdownElem) {
                        var currentDropdownElem = $(this);
                        if (currentLocation.indexOf(currentDropdownElem.data("vertical")) != -1 && currentDropdownElem.find(".js-menuItemContainer").css("display") == "none") {
                            currentDropdownElem.click();
                        }
                    });
                }
                if (typeof setNavTop !== "undefined") {
                    if (!setNavTop) {
                        setTop = 0;
                    } else {
                        setTop = parentElem.outerHeight() + parentElem.data("topoffset");
                    }
                } else {
                    setTop = parentElem.outerHeight() + parentElem.data("topoffset");
                }
                if (currentTrigger.hasClass("js-topNavIcon")) {
                    mainObj.toggleOverlayClass("z-index8", "z-index9");
                } else {
                    mainObj.toggleOverlayClass("z-index9", "z-index8");
                }
                parentElem.find(".js-navIcon").hide();
                if (typeof isToggleItems == "undefined") {
                    mainObj.isToggleItems = false;
                } else {
                    mainObj.isToggleItems = true;
                }
                if (!currentTrigger.hasClass("js-initNavIcon") && parentElem.data("type") !== "sticky") {
                    $(globalNavElement).css("top", setTop);
                    if (mainObj.documentClick === "touchstart") {
                        mainObj.setTop = setTop;
                        $(globalNavElement).css("height", $(window).height() - setTop + "px");
                    }
                }
                $(globalNavElement).animate({
                    left: "0"
                }, "2000").addClass("js-activeMenu");
                if (!currentTrigger.hasClass("js-calcDesktop")) {
                    mainObj.overlayElem.addClass("overlay-new").show();
                }
                navCloseIcon.show();
                setTimeout(function() {
                    if (currentTrigger.hasClass("js-initNavIcon")) {
                        document.documentElement.scrollTop = 0;
                    }
                    if (!currentTrigger.hasClass("js-calcDesktop")) {
                        if (!mainObj.isToggleItems) {
                            $("html body").addClass("fix-scroll p-fixed");
                        } else {
                            $("html body").addClass("fix-scroll");
                        }
                    }
                }, 200);
            });
        },
        activeMenuHeight: function() {
            var mainObj = this;
            $(window).resize(function() {
                var activeMenu = $(".js-activeMenu");
                if (activeMenu.length) {
                    activeMenu.css("height", $(window).height() - mainObj.setTop + "px");
                }
            });
        },
        toggleOverlayClass: function(rmClass, adClass) {
            var mainObj = this;
            if (mainObj.overlayElem.hasClass(rmClass)) {
                mainObj.overlayElem.removeClass(rmClass);
            }
            mainObj.overlayElem.addClass(adClass);
        },
        hideMobileNav: function() {
            var mainObj = this;
            this.navCloseIcon.on(mainObj.handleClick, function() {
                mainObj.toggleElems(false, $(this));
            });
            if (this.searchTrigger.length) {
                this.searchTrigger.on(mainObj.handleClick, function() {
                    mainObj.toggleElems(false, $(this));
                });
            }
        },
        windowClick: function() {
            var mainObj = this;
            $(document).on(this.documentClick, function(e) {
                if (!$(e.target).hasClass("js-navIcon") && !$(e.target).hasClass("js-globalNavTrigger") && !$(e.target).hasClass("js-closeIcon") && !$(e.target).hasClass("js-Nav") && $(e.target).parent("js-Nav").length !== 0 || $(e.target).hasClass("js-globalHeaderOverlay")) {
                    mainObj.toggleElems(false);
                }
            });
        },
        menuDropDown: function() {
            var mainObj = this;
            this.navMenuElement.on(mainObj.handleClick, function(e) {
                e.stopPropagation && e.stopPropagation();
                e.preventDefault && e.preventDefault();
                var triggerElem = $(this), siblingElems = triggerElem.siblings("li"), menuItem = triggerElem.find(".js-menuItemContainer");
                if (menuItem.css("display") === "none") {
                    menuItem.slideDown("slow");
                    triggerElem.find("img.arrow-down").hide();
                    triggerElem.find("img.arrow-up").show();
                } else {
                    var target = $(e.target), locateTo = target.attr("href");
                    if (typeof locateTo !== "undefined") {
                        mainObj.clickTrackEvent($(triggerElem.find(".js-clickTrack")));
                    }
                    if (!target.parents(".js-menuItemContainer").length && !target.hasClass("js-menuItemContainer")) {
                        menuItem.slideUp("slow", function() {
                            if (typeof locateTo !== "undefined") {
                                jumpTo(locateTo);
                            }
                        });
                        mainObj.toggleElems(true, triggerElem);
                    } else {
                        jumpTo(locateTo);
                    }
                }
                if (!mainObj.isToggleItems) {
                    siblingElems.find(".js-menuItemContainer").slideUp("slow");
                    mainObj.toggleElems(true, siblingElems);
                }
            });
            function jumpTo(locateTo) {
                if (typeof locateTo != "undefined") {
                    window.location.href = locateTo;
                }
            }
        },
        toggleElems: function(menuDropDown, objElem) {
            var mainObj = this;
            if (menuDropDown === true) {
                objElem.find("img.arrow-down").show();
                objElem.find("img.arrow-up").hide();
            } else {
                var parentElem = $(".js-activeMenu").parents(mainObj.container).eq(0), globalNavIcon = parentElem.find(".js-navIcon"), navCloseIcon = parentElem.find(".js-closeIcon"), globalNavElement = parentElem.find(".js-Nav");
                $(globalNavElement).animate({
                    left: "-1150px"
                }, "2000");
                setTimeout(function() {
                    mainObj.overlayElem.css("opacity", "0.0");
                    mainObj.overlayElem.removeClass("overlay-new").addClass("display-none").css("opacity", "0.6");
                }, 300);
                if (!mainObj.isToggleItems) {
                    $("html body").removeClass("fix-scroll p-fixed");
                } else {
                    $("html body").removeClass("fix-scroll");
                }
                navCloseIcon.hide();
                globalNavIcon.show();
                $(globalNavElement).removeClass("js-activeMenu");
            }
        },
        clickTrackEvent: function(trigger) {
            var trackCategory = trigger.data("category"), trackAction = trigger.data("action"), trackLabel = trigger.data("label"), trackUrl = trigger.attr("href"), target = trigger.attr("target"), noRefresh = trigger.data("norefresh");
            if (typeof trackCategory !== "undefined") {
                ga("send", "event", trackCategory, trackAction, trackLabel || trackUrl);
            }
        }
    });
})(window, window.jQuery);

$(function() {
    var globalNavTrigger = $(".js-calcNavTrigger").length ? ".js-globalNavTrigger, .js-calcNavTrigger" : ".js-globalNavTrigger";
    if ($(globalNavTrigger).length) {
        var inputElem = {
            globalNavIcon: $(globalNavTrigger).find(".js-navIcon"),
            navCloseIcon: $(globalNavTrigger).find(".js-closeIcon"),
            navMenuElement: $(globalNavTrigger).find(".js-navdrop-down"),
            searchTrigger: $(globalNavTrigger).find("#displaySearch")
        };
        cti.globalHeader(globalNavTrigger, inputElem);
    }
});

function generateInlineFootnote() {
    var count = 0;
    $(".inline-footnote").each(function() {
        count++;
        $(this).before('<a class="footnote-button" title="Click to expand this note."> [+]</a>');
        $(this).wrap("<div class='inline-ftn-wrapper' id='footnote-" + count + "'></div>");
        $(this).css("display", "block");
    });
    $(".commentary-article .footnote-button").each(function() {
        count++;
        $(this).text(" [-] ");
        $(this).addClass("active-ftn-button");
        $(this).next("div.inline-ftn-wrapper").find(".inline-footnote").css("display", "block");
        $(this).next("div.inline-ftn-wrapper").css("display", "block");
    });
}

$(document).ready(function() {
    generateInlineFootnote();
});

var btn = $(".js-collapseAll");

$(document).on("click", ".js-collapseAll", function(event) {
    event.preventDefault();
    $(".footnote-button").each(function(i) {
        if (btn.hasClass("collapse")) {
            $(this).text(" [-] ");
            $(this).addClass("active-ftn-button");
            $(this).next("div.inline-ftn-wrapper").slideDown("slow");
        } else {
            $(this).text(" [+] ");
            $(this).removeClass("active-ftn-button");
            $(this).next("div.inline-ftn-wrapper").slideUp("slow");
        }
    });
    if (btn.hasClass("collapse")) {
        btn.removeClass("collapse").text("[ - ] Collapse commentary");
    } else {
        btn.addClass("collapse").text("[ + ] Expand commentary");
    }
});

$(document).on("click", ".footnote-button", function() {
    if ($(this).hasClass("active-ftn-button")) {
        $(this).text(" [+] ");
        $(this).removeClass("active-ftn-button");
        $(this).next("div.inline-ftn-wrapper").slideUp("slow");
    } else {
        $(this).text(" [-] ");
        $(this).addClass("active-ftn-button");
        $(this).next("div.inline-ftn-wrapper").find(".inline-footnote").css("display", "block");
        $(this).next("div.inline-ftn-wrapper").slideDown("slow");
    }
    if ($(".active-ftn-button").length < 1) {
        btn.addClass("collapse").text("[ + ] Expand commentary");
    } else {
        if (btn.hasClass("collapse")) {
            btn.removeClass("collapse").text("[ - ] Collapse commentary");
        }
    }
});

$(document).on("click", ".js-readersmode", function() {
    setTimeout(function() {
        var count = 0;
        $(".inline-footnote").each(function() {
            count++;
            $(this).before('<a class="footnote-button" title="Click to expand this note."> [+]</a>');
            $(this).wrap("<div class='inline-ftn-wrapper' id='footnote-" + count + "'></div>");
        });
        $(document).on("click", ".footnote-button", function() {
            if ($(this).hasClass("active-ftn-button")) {
                $(this).text(" [+] ");
                $(this).removeClass("active-ftn-button");
                $(this).next("div.inline-ftn-wrapper").slideUp("slow");
            } else {
                $(this).text(" [-] ");
                $(this).addClass("active-ftn-button");
                $(this).next("div.inline-ftn-wrapper").find(".inline-footnote").css("display", "block");
                $(this).next("div.inline-ftn-wrapper").slideDown("slow");
            }
        });
    }, 300);
});

$(window).ready(function() {
    if (window.ga && ga.create) {
        (function insertGID() {
            ga(function(tracker) {
                var clientId = tracker.get("clientId");
                function addGID(el, clientId) {
                    var cURL = el.attr("href");
                    var siteID = "GA1." + clientId;
                    var newURL = cURL + "&cds_misc_1=" + siteID;
                    el.attr("href", newURL);
                }
                $('a[href*="buysub.com"]').each(function() {
                    addGID($(this), clientId);
                });
                $('a[href*="subscribe.christianitytoday.com"]').each(function() {
                    addGID($(this), clientId);
                });
            });
        })();
    }
});

window.u$ || (window.u$ = {});

(function($, window, document, ns) {
    "use strict";
    ns || (ns = window);
    var $overlay, $current, defaults = {
        clickOverlayToClose: true,
        closeParams: '<a class="closeModal">close</a>',
        destroyOnClose: false,
        escapeClose: true,
        eventNamespace: null,
        events: null,
        isLightbox: true,
        modals: null,
        overlayParams: '<div class="overlay"></div>',
        triggerClass: "js-triggerModal"
    }, initialize = function($triggers, options) {
        this.options = $.extend({}, this.options, options || null);
        this.$body = $(document.body);
        this.attachModalEvents();
        if ($triggers || this.options.modals || this.options.url) {
            if ($triggers === null) {
                this.load(null, 0);
            } else {
                this.$triggers = $triggers;
                this.attach($triggers);
            }
        }
    }, setEvent = function() {
        var callbacks = {
            clickOverlay: function(e) {
                if ($overlay.data("clickToClose")) {
                    this.hide();
                }
            },
            close: function(e) {
                e.preventDefault();
                this.hide();
            },
            escapeClose: function(e) {
                if (e.which === 27) {
                    this.hide();
                }
            },
            show: function(e) {
                var $trigger = $(e.target), cssClass = this.options.triggerClass, show = true;
                if ($.isFunction(cssClass)) {
                    show = cssClass($trigger);
                } else if (!$trigger.hasClass(cssClass)) {
                    $trigger = $trigger.parent("." + cssClass).eq(0);
                    show = !!$trigger.length;
                }
                if (show) {
                    e.preventDefault();
                    this.load($trigger);
                }
            }
        };
        return function(name, $elems, sel, event) {
            var ns = (this.options.eventNamespace || "") + "Modal." + name + "Event", callback = $.proxy(callbacks[name], this);
            $elems.on((event || "click") + "." + ns, sel, callback);
        };
    }(), modalProto = {
        options: defaults,
        attach: function($triggers) {
            setEvent.call(this, "show", $triggers, "." + this.options.triggerClass);
        },
        attachModalEvents: function() {
            setEvent.call(this, "close", this.$body, ".js-closeModal");
            setEvent.call(this, "clickOverlay", this.$body, ".js-overlay");
            setEvent.call(this, "clickOverlay", this.$body, ".js-overlay", "touchend");
            if (this.options.escapeClose) {
                setEvent.call(this, "escapeClose", this.$body, null, "keyup");
            }
        },
        detach: function($triggers) {
            var ns = (this.options.eventNamespace || "") + "Modal", args;
            if ($triggers && $triggers.length) {
                $triggers.removeClass(this.options.triggerClass);
                this.$triggers = this.$triggers.not($triggers);
            } else {
                args = u$.detach(this, ns, "$modals", "$triggers", "$body");
                args.pop();
            }
            args || (args = [ $triggers ]);
            args.unshift("detach");
            this.emit.apply(this, args);
        },
        add: function($triggers, isDelegate) {
            if (this.$triggers && isDelegate === false) {
                $triggers.addClass(this.options.triggerClass);
            } else {
                this.$triggers = this.$triggers ? this.$triggers.add($triggers) : $triggers;
                this.attach($triggers);
            }
        },
        load: function($trigger, i) {
            var index = $trigger ? $trigger.data("modalindex") : i, $modal, modalId;
            if (typeof index !== "number") {
                modalId = "#" + $trigger.data("modalid");
                $modal = this.$modals && this.$modals.filter(modalId);
                index = $modal && $modal.length ? $modal.index(this.$modals) : -1;
                if (index === -1) {
                    index = this.$modals && this.$modals.length || 0;
                    $modal = $(modalId);
                    this.$modals = index ? this.$modals.add($modal) : $modal;
                }
                $trigger.data("modalindex", index);
            } else {
                this.$modals || (this.$modals = $(this.options.modals));
                $modal = this.$modals.eq(index);
            }
            this.show($modal, $trigger);
        },
        beforeShow: function($modal, $trigger) {
            $current = $modal;
            this.emit("beforeShow", $modal, $trigger, $overlay);
        },
        render: function($modal, $trigger) {
            this.setCloseLink($modal);
            this.position($modal).removeClass("is-invisible");
            this.showOverlay();
            this.emit("show", $modal, $trigger, $overlay);
        },
        position: function($modal) {
            var supportsTranform = $.cssDetect("transform");
            if (!supportsTranform) {
                $modal.css({
                    left: "50%",
                    marginLeft: -$modal.outerWidth() / 2 + "px"
                });
            }
            if ($modal.css("position") !== "fixed") {
                $modal.css("top", $(window).scrollTop() + (this.options.offset || 100) + "px");
            }
            return $modal;
        },
        show: function($modal, $trigger) {
            this.beforeShow($modal, $trigger);
            this.render($modal, $trigger);
        },
        showOverlay: function() {
            if (this.options.isLightbox) {
                if (!$overlay) {
                    $overlay = u$.render(this.$body, this.options.overlayParams);
                    $overlay.addClass("js-overlay");
                }
                $overlay.removeClass("is-invisible").data("clickToClose", !!this.options.clickOverlayToClose);
            }
        },
        hide: function() {
            if ($current) {
                this.emit("beforeHide", $current, $overlay);
                if (this.options.destroyOnClose) {
                    this.$modals = this.$modals.not($current.get(0));
                    $current.empty().remove();
                    $current = null;
                } else {
                    $current.addClass("is-invisible");
                }
                $overlay && $overlay.addClass("is-invisible");
                this.emit("hide", $current, $overlay);
            }
            $current = null;
        },
        setCloseLink: function($modal) {
            if (this.options.closeParams && !$modal.find(".js-closeModal").length) {
                u$.render($modal, this.options.closeParams, true).addClass("js-closeModal");
            }
        },
        emit: function(name) {
            var events = this.options.events, start = events ? 0 : 1, method = events ? this.trigger : this.options[name];
            if ($.isFunction(method)) {
                method.apply(this, [].slice.call(arguments, start));
            }
        }
    }, ajaxModalProto = $.extend(Object.create(modalProto), u$.cacheMixin, u$.loaderMixin, {
        options: $.extend({}, defaults, {
            cache: true,
            modals: [ "<div />", {
                class: "modal js-modal"
            } ]
        }),
        load: function($trigger) {
            var query = this.options.query, cache;
            if ($.isFunction(query)) {
                query = query($trigger);
            }
            cache = this.getCache(query);
            if (cache) {
                this.show(cache, $trigger);
            } else {
                $.ajax({
                    url: this.options.url,
                    data: query,
                    beforeSend: function(xhr, settings) {
                        this.showLoader(this.showOverlay);
                        this.emit("beforeSend", $trigger, xhr, settings);
                    }.bind(this),
                    success: function(data, status, xhr) {
                        this.hideLoader();
                        this.setCache(query, xhr.responseText);
                        this.show(xhr.responseText, $trigger);
                    }.bind(this),
                    error: function(xhr, errorType, error) {
                        this.emit("ajaxError", $trigger, xhr, errorType, error);
                    }.bind(this)
                });
            }
        },
        show: function(response, $trigger) {
            var $modal = this.setModal();
            this.beforeShow($modal, $trigger);
            if (this.options.responseType === "json") {
                u$.renderJSON($modal, response, this.options.template);
            } else {
                $modal.html(response);
            }
            this.render($modal, $trigger);
        },
        setModal: function() {
            this.$modals || (this.$modals = u$.render(this.$body, this.options.modals));
            return this.$modals.eq(0);
        }
    });
    ns.modal = function($triggers, options) {
        var proto = modalProto, instance;
        if (!u$.is$($triggers)) {
            options = $triggers;
            $triggers = null;
        }
        if (options && options.url) {
            proto = ajaxModalProto;
        }
        instance = Object.create(proto);
        if (options && options.events) {
            $.extend(instance, options.events);
        }
        initialize.call(instance, $triggers, options);
        return instance;
    };
})(window.Zepto || window.jQuery, window, document, u$);

(function($) {
    "use strict";
    $.fn.clearInput = function(delegate, focusedClass, populatedClass) {
        return this.each(function(i) {
            var $el = $(this);
            delegate || (delegate = this.nodeName === "INPUT" ? null : "input");
            focusedClass || (focusedClass = "is-focused");
            populatedClass || (populatedClass = "is-populated");
            $el.on({
                focusin: function(e) {
                    var $input = $(e.currentTarget), value = $input.val();
                    if (value !== "") {
                        $input.data("initial-value", value);
                    }
                    $input.addClass(focusedClass).val("");
                },
                focusout: function(e) {
                    var $input = $(e.currentTarget);
                    $input.removeClass(focusedClass);
                    if (!$input.val()) {
                        $input.val($input.data("initial-value") || "");
                    } else {
                        $input.addClass(populatedClass);
                    }
                }
            }, delegate);
        });
    };
})(window.Zepto || window.jQuery);

(function($) {
    "use strict";
    $.cssDetect = function() {
        var memo = {}, vendors = "ms,o,moz,webkit".split(",");
        return function(prop) {
            var supported = false, style = document.createElement("div").style, i = vendors.length - 1, suffix;
            if (memo[prop]) {
                return memo[prop];
            } else if (prop in style) {
                memo[prop] = true;
                return true;
            }
            suffix = prop.charAt(0).toUpperCase() + prop.slice(1);
            while (i >= 0) {
                if (vendors[i] + suffix in style) {
                    supported = true;
                    break;
                }
                i -= 1;
            }
            memo[prop] = supported;
            return supported;
        };
    }();
})(window.Zepto || window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.searchBoxToggle = u$.createFactory({
        initialize: function(searchForm, inputElem) {
            this.toggleIcon = inputElem.toggleIcon;
            this.searchButton = searchForm.find("input[type=submit]").not(this.toggleIcon);
            this.formClass = searchForm.data("toggleclass") || "bg-gray";
            this.searchBoxWidth = this.searchButton.data("boxwidth") || 178;
            this.inputField = searchForm.find("input[type=text]");
            this.boxmargin = searchForm.data("boxmargin") || 0;
            this.handleExpand(searchForm);
            this.handleCollapse(searchForm);
        },
        handleExpand: function(searchForm) {
            var me = this;
            this.searchButton.on("click touchend", function(e) {
                if (!me.inputField.is(e.target) && me.inputField.css("width") == "0px") {
                    e.preventDefault();
                    if (me.toggleIcon.length) {
                        $(this).hide();
                    }
                    setTimeout(function() {
                        if (me.toggleIcon.length) {
                            me.toggleIcon.show();
                        }
                    }, 200);
                    me.inputField.animate({
                        width: me.searchBoxWidth + "px",
                        "padding-left": "5px"
                    }, 500, function() {
                        me.inputField.focus();
                    });
                    $(this).removeClass("bg-white");
                    searchForm.addClass(me.formClass);
                    if (me.boxmargin != 0) {
                        searchForm.animate({
                            margin: "0px"
                        }, 500);
                    }
                } else if (me.inputField.val() != "Search") {
                    searchForm.submit();
                }
            });
        },
        handleCollapse: function(searchForm) {
            var me = this;
            $(document).on("click touchend", function(e) {
                if (!me.searchButton.is(e.target) && !me.inputField.is(e.target)) {
                    if (me.toggleIcon.length) {
                        me.toggleIcon.hide();
                    }
                    me.inputField.val("").animate({
                        width: "0px",
                        "padding-left": "0"
                    }, 500, function() {
                        if (me.toggleIcon.length) {
                            me.searchButton.show();
                        }
                        searchForm.removeClass(me.formClass);
                        me.searchButton.addClass("bg-white");
                    });
                    me.inputField.blur();
                    if (me.boxmargin != 0) {
                        searchForm.animate({
                            margin: me.boxmargin
                        }, 500);
                    }
                }
            });
        }
    });
    $(function() {
        var searchForm = $(".js-searchForm");
        if (searchForm.length) {
            var inputElem = {
                toggleIcon: searchForm.find(".js-toggleIcon")
            };
            cti.searchBoxToggle(searchForm, inputElem);
        }
    });
})(window, window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.selectExplore = u$.createFactory({
        initialize: function(trigger) {
            trigger.on("change", function(eventObject) {
                if ($(this).hasClass("js-sortBy")) {
                    this.form.submit();
                } else {
                    var getlocation = this.value;
                    window.location = getlocation;
                }
            });
        }
    });
    $(function() {
        var selectTrigger = $(".js-selectExplore");
        if (selectTrigger.length) {
            cti.selectExplore(selectTrigger);
        }
    });
})(window, window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.showDownloadModal = u$.createFactory({
        initialize: function(downloadModalTrigger) {
            u$.modal($(document.body), {
                triggerClass: downloadModalTrigger,
                closeParams: '<img class="closeModal" src="/system/img/btn_close.png" width="30" />',
                destroyOnClose: false
            });
        }
    });
    $(function() {
        var downloadModalTrigger = "js-showDownloadModal";
        if (downloadModalTrigger.length) {
            cti.showDownloadModal(downloadModalTrigger);
        }
    });
})(window, window.jQuery);

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.showModalContent = u$.createFactory({
        initialize: function(modalContent) {
            var dataUrl = modalContent.data("url");
            u$.modal($(document.body), {
                url: dataUrl,
                query: function($trigger) {
                    var getHref = $trigger.attr("href");
                    if (typeof getHref !== "undefined") {
                        if (getHref.indexOf("?") !== -1) {
                            getHref = getHref.split("?")[1];
                        }
                        return getHref;
                    }
                },
                modals: [ "<div />", {
                    class: "modal modal-adjust is-centered"
                } ],
                triggerClass: "js-modalContent",
                closeParams: '<img class="closeModal" src="/system/img/btn_close.png" width="30" />',
                destroyOnClose: false,
                clickOverlayToClose: false,
                show: function($modal, $trigger) {
                    if (typeof $trigger.data("class") != "undefined") {
                        $modal.attr("class", $trigger.data("class"));
                    }
                    if (typeof $trigger.data("id") != "undefined") {
                        $modal.attr("id", $trigger.data("id"));
                    }
                    if ($($modal).find("iframe").length) {
                        $modal.on("click", ".closeModal", function() {
                            $modal.find("iframe").remove();
                        });
                    }
                    var textarea = $modal.find("textarea")[0];
                    if ($(textarea).length) {
                        $(textarea).on("click", function(event) {
                            this.focus();
                            this.select();
                        });
                    }
                }
            });
        }
    });
})(window, window.jQuery);

$(function() {
    var modalContent = $(".js-modalContent");
    if (modalContent.length) {
        cti.showModalContent(modalContent);
    }
});

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.toggleSearchResults = u$.createFactory({
        initialize: function(trigger) {
            var mainObj = this, pageUrl = window.location.href, isSearchAll = pageUrl.indexOf("searchall"), isAlgolia = $(".js-searchDiv");
            if (window.location.search != "") {
                trigger.on("click", function() {
                    var searchForm = $(this).parents("form")[0];
                    if (isAlgolia.length) {
                        searchForm.submit();
                    } else {
                        if (this.checked == true && isSearchAll == -1) {
                            window.location = pageUrl + "&searchall=on";
                        } else {
                            window.location = pageUrl.replace("&searchall=on", "");
                        }
                    }
                });
            }
        }
    });
})(window, window.jQuery);

$(function() {
    var toggleSearchTrigger = $(".js-searchAll");
    if (toggleSearchTrigger.length) {
        cti.toggleSearchResults(toggleSearchTrigger);
    }
});

(function(global, $) {
    "use strict";
    global.cti || (global.cti = {});
    cti.toolTip = u$.createFactory({
        initialize: function(hovertip) {
            var currentObj = this, isiPad = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
            if (isiPad) {
                this.ipadTooltip();
            } else {
                $("body").on("mouseenter mouseleave", ".tooltip", function(event) {
                    if (event.type == "mouseenter") {
                        currentObj.getTooltip($(this), event);
                    } else {
                        currentObj.setTooltip($(this), event);
                    }
                }).mousemove(function(event) {
                    var tooltipBlock = $(".tooltip-container");
                    if (window.innerWidth - event.pageX > 350) {
                        tooltipBlock.css({
                            top: event.pageY - 10 + "px",
                            left: event.pageX + 20 + "px"
                        });
                    } else {
                        tooltipBlock.css({
                            width: "130px",
                            "min-width": "130px",
                            top: event.pageY - 5 + "px",
                            right: parseInt(window.innerWidth - event.pageX + 10) + "px",
                            "word-break": "break-word"
                        });
                    }
                });
            }
        },
        ipadTooltip: function() {
            var mainObj = this;
            $("body").on("touchend", ".tooltip", function(event) {
                if (!$(".tooltip-container").length) {
                    mainObj.getTooltip($(this), event, true);
                }
            });
            $("body").on("touchend", function(event) {
                var tooltipImg = $(event.target).hasClass("tooltip"), tooltipDiv = $(event.target).hasClass("tooltip-container");
                if (tooltipImg == false && tooltipDiv == false) {
                    mainObj.setTooltip($(this), event, true);
                }
            });
        },
        getTooltip: function(elem, event, isiPad) {
            var titleText = elem.attr("title");
            if (!isiPad) {
                if (titleText.indexOf("Leadership Journal") != -1) {
                    titleText = titleText.replace("Leadership Journal", "<em>Leadership Journal</em>");
                }
                elem.data("tiptext", titleText).attr("title", "");
            }
            $('<div class="tooltip-container"></p>').html(titleText).appendTo("body").promise().done(function() {
                if (window.innerWidth - event.pageX > 350) {
                    $(this).css({
                        top: event.pageY - 10 + "px",
                        left: event.pageX + 20 + "px",
                        "z-index": 99999
                    }).fadeIn("slow");
                } else {
                    if (isiPad) {
                        $(this).css({
                            top: event.pageY - 10 + "px",
                            left: event.pageX + 20 + "px",
                            "z-index": 99999
                        }).fadeIn("slow");
                    } else {
                        $(this).css({
                            width: "130px",
                            "min-width": "130px",
                            top: event.pageY - 5 + "px",
                            right: parseInt(window.innerWidth - event.pageX + 10) + "px",
                            "z-index": 99999,
                            "word-break": "break-word"
                        }).fadeIn("slow");
                    }
                }
            });
        },
        setTooltip: function(elem, event, isiPad) {
            if (!isiPad) {
                var plainTitle = elem.data("tiptext");
                if (plainTitle.indexOf("Leadership Journal") != -1) {
                    plainTitle = plainTitle.replace("Leadership Journal", "<em>Leadership Journal</em>");
                }
            }
            elem.attr("title", plainTitle);
            $(".tooltip-container").remove();
        }
    });
    $(function() {
        var hovertip = $(".tooltip");
        if (hovertip.length) {
            cti.toolTip(hovertip);
        }
    });
})(window, window.jQuery);