(function(global,$) {
	'use strict';

	global.cti || (global.cti = {});

	var $body = $(document.body);

	//Functionality to open article embedded image or slider in a pop-up
	cti.fullimage_popup = u$.createFactory({
		initialize: function(trigger,fullPageSlideContainer,inPageSliderContainer) {
			/* Initiate full screen slider and Jump to the triggered embedded image */
			this.fullPageSlideContainer = fullPageSlideContainer;
			this.inPageSliderContainer = inPageSliderContainer;

			this.inPageSlider = this.inPageSliderContainer.find('.js-slider').eq(0);
			this.fullPageSlider = this.fullPageSlideContainer.find('.js-slider').eq(0);

			var mainObj=this;

			trigger.on('click touchend',function(event){
				event.preventDefault();
				var triggered_image = $(this).find('.image_embedded'),sliderInt,i;

				$('body').addClass('no-scroll');
				if($('html').css('overflow-y') == 'scroll'){
					$('html').css('overflow','hidden');
				}
				
				// Click on article embedded image
				if(typeof($(triggered_image).attr('src')) !== 'undefined'){
					if($('.js-canReadItem').val() !== "false"){
						var imgsrc = $(triggered_image).attr('src'),
						imgid = imgsrc.substring( imgsrc.lastIndexOf("/") + 1, imgsrc.lastIndexOf("."));
						sliderInt = parseInt(mainObj.fullPageSlider.children('[data-imgid="'+imgid+'"]').data('slideid'));
					}
				} else {
					// Click on Full Screen button
					if(mainObj.inPageSlider.length){
						sliderInt = parseInt(mainObj.inPageSlider.children("div.articleImg.active").data('slideid'));
					} else {
						//Click on launch Slideshow button
						sliderInt = 1;
					}
				}

				if($('.js-canReadItem').val() !== "false"){
					for(i = sliderInt-1; i <= sliderInt+1; i++){
						cti.fetchImages.checkImageExists(mainObj.fullPageSlider,i,'fullScreenSlide');
					}
					cti.fetchImages.loadCreditCaption(sliderInt,mainObj.fullPageSlideContainer,'fullScreenSlide');
					cti.imageSlider.init(mainObj.fullPageSlideContainer,sliderInt);
				}
				
				mainObj.fullPageSlideContainer.parent('#'+triggered_image.attr('data-modalid')).removeClass('is-invisible');
				cti.fetchImages.setMaxHeight(sliderInt,mainObj.fullPageSlideContainer);

				var mobileTopnav = $(".js-topnav");
				/*To handle double tap on Article title of FullScreen Slideshow so that we can avoid touch on site header, as on Billy-Graham*/
				if(typeof mobileTopnav != "undefined" && $(window).width() <= 768){
					mobileTopnav.fadeOut();
				}

				mainObj.fullPageSlideContainer.parent('div').find('.js-closeModal').on('click touchend', function() {
					setTimeout(function(){
						mainObj.showWindowScroll();
					mainObj.unbindPrevNext();
					/*To handle double tap on Article title of FullScreen Slideshow so that we can avoid touch on site header, as on Billy-Graham*/
					if(typeof mobileTopnav != "undefined" && $(window).width() <= 768){
						mobileTopnav.fadeIn(400);
					}
					},100);
				});
				mainObj.fullPageSlideContainer.find('.js-articleTitle').on('click touchend', function() {
					setTimeout(function(){
						mainObj.fullPageSlideContainer.parent('div').find('.js-closeModal').click();
						},100);
				})
				$(document).keyup(function(e) {
					if (e.keyCode == 27) { // escape key maps to keycode `27`
						mainObj.showWindowScroll();
						mainObj.unbindPrevNext();
					}
				});
			});

			trigger.on('touchmove', function(e){
				$(this).off('touchend');
			});

			if($(window).width() <= 768){
				
				$("#fullImageModal").find(".js-closeModal").removeClass("tooltip");
				
			}
		},
		showWindowScroll: function(){
			if(!this.fullPageSlideContainer.parent('div').hasClass('is-invisible')){
				this.fullPageSlideContainer.parent('div').addClass('is-invisible');
			}
			$('body').removeClass('no-scroll');
			if($('html').css('overflow') == 'hidden'){
				$('html').css('overflow-y','scroll');
			}
		},
		unbindPrevNext: function(){
			this.fullPageSlideContainer.find('.js-previous,.js-next').off('click touchend');
			if(typeof this.inPageSliderContainer != "undefined"){
				this.inPageSliderContainer.find('.js-previous,.js-next').off('click touchend');

				var sliderInt = parseInt(this.inPageSlider.children("div.articleImg.active").data('slideid'));
				cti.imageSlider.init(this.inPageSliderContainer,sliderInt);
			}
		}
	});

	cti.imageHover = u$.createFactory({
		initialize: function(trigger,mobileDevice) {

			var embeddedImageHtml = '<div class="slideshow-item"><div class="slideshow-indicator"><img src="/system/slideshow/img/icon_camera.png" width="14" height="13"/><div class="slide-view uppercase">View Larger</div></div></div>',
			linkedImageHtml = '<div class="slideshow-item"><div class="slideshow-indicator"><img src="/system/slideshow/img/icon_camera.png" width="14" height="13" /><div class="slide-view uppercase">Open Link</div></div></div>';
			if(mobileDevice){
				if( /iPad/i.test(navigator.userAgent) == false) {
					embeddedImageHtml = '<div class="slideshow-item"><div class="slideshow-indicator"><img src="/system/slideshow/img/icon_camera.png" alt="Slideshow" title="Slideshow" /></div></div>';
					}
				embeddedImageHtml = '<div class="slideshow-item"><div class="slideshow-indicator"><img src="/system/slideshow/img/icon_camera.png" alt="Slideshow" title="Slideshow" /></div></div>';
				trigger.each(function(){
					if($(this).children().hasClass('image_embedded')){
						$(this).children('img').after(embeddedImageHtml);
					}else if($(this).children().hasClass('image_link')){
						$(this).children('.image_link').append(linkedImageHtml);
					}
				});
			}else{
				trigger.on('mouseenter mouseleave', function(event){
					var hoverElem = $(this).find('.slideshow-item');

					if(event.type == "mouseenter"){
						if(!hoverElem.length){
							if($(this).children().hasClass('image_embedded')){
								$(this).children('img').after(embeddedImageHtml);
							}else if($(this).children().hasClass('image_link')){
								$(this).children('.image_link').append(linkedImageHtml);
							}
						} else if(hoverElem.css('display') == 'none'){
							hoverElem.css('display','block');
						}
					} else if(event.type == "mouseleave"){
						if(hoverElem.length){
							hoverElem.css('display','none');
						}
					}
				});
			}
		}
	});

	// Code for article embedded images slider
	cti.imageSlider = {
		init : function(container,sliderInt) {
			this.slider = container.find('.js-slider');
			this.count = this.slider.children('div.articleImg').length;
			if( typeof(sliderInt) == 'undefined'){
				this.sliderInt = 1;
			} else {
				this.sliderInt = sliderInt;
			}

			this.container = container;
			this.slider.children('div.articleImg').removeClass('active');
			this.slider.children('div[data-slideid="'+this.sliderInt+'"]').addClass('active');
			this.slider.parents('.slideshow').find('.js-image-counter').html(this.sliderInt+' of '+this.count);

			this.attachEvents();
		},

		// Slide change process
		process : function(sliderNextId, triggerType, slideTrigger, mainObj){
			/* Unbind click event from previous and next button and bind them again, in order to avoid display of next slide until the current slide is fully loaded */
			$('body').off('keydown');
			slideTrigger.off('click touchend');
			this.slider.children('div.articleImg').not('[data-slideid="'+sliderNextId+'"]').removeClass('active');
				mainObj.slider.find('div[data-slideid="'+ sliderNextId+'"]').addClass('active');
			setTimeout(function(){
				slideTrigger.on('click touchend', function (){
					if(triggerType == 'prev') {
						mainObj.prev($(this));
					} else if (triggerType == 'next') {
						mainObj.next($(this));
					}
				});
				$('body').keydown(function(e) {
					if(e.keyCode == 37) { // left
						mainObj.prev(mainObj.container.find('.js-previous'));
					}
					else if(e.keyCode == 39) { // right
						mainObj.next(mainObj.container.find('.js-next'));
					}
				});
				mainObj.container.find('.js-image-counter').html(sliderNextId+' of '+mainObj.count);
			},400);

		},

		// Go to which slide
		showSlide : function(id, triggerType, slideTrigger, mainObj){
			if(id > this.count) {
				id = 1;
			} else if(id < 1) {
				id = this.count;
			}
			this.process(id, triggerType, slideTrigger, mainObj);
			this.sliderInt = id;
		},

		// Click events
		attachEvents : function() {
			var mainObj = this;

			$('body').off('keydown');
			$('body').keydown(function(e) {
				if(e.keyCode == 37) { // left
					mainObj.prev(mainObj.container.find('.js-previous'));
				}
				else if(e.keyCode == 39) { // right
					mainObj.next(mainObj.container.find('.js-next'));
				}
			});

			// Click on previous
			this.container.find('.js-previous').off().on('click touchend', function() {
				mainObj.prev($(this));
			});
			// Click on Next
			this.container.find('.js-next').off().on('click touchend', function() {
				mainObj.next($(this));
			});
		},
		prev: function(slideTrigger){
			this.showSlide(this.sliderInt - 1, 'prev', slideTrigger, this);
			// Check if (previous-1) slide's image exists or not
			cti.fetchImages.checkImageExists(this.slider,this.sliderInt - 1);
			cti.fetchImages.loadCreditCaption(this.sliderInt,this.container);
		},
		next: function (slideTrigger){
			this.showSlide(this.sliderInt + 1, 'next', slideTrigger, this);
			// Check if (next+1) slide's image exists or not
			cti.fetchImages.checkImageExists(this.slider,this.sliderInt + 1);
			cti.fetchImages.loadCreditCaption(this.sliderInt,this.container);
		}
	};
	// End of code for article embedded images slider

	// Code to pre-load article images via ajax for slideshow
	cti.fetchImages = {
		init : function(container,totalSlides,inPageSliderContainer,sliderInt){
			this.ajaxResponse = {};
			this.container = container;
			this.totalSlides = totalSlides;
			this.itemId = container.data('itemid');
			this.requestUrl = '/system/slideshow/ajax/get_slideshow.html';

			var contentType;
			if($('.js-contentType').length){
				contentType = $('.js-contentType').val();
			} else{
				contentType = 'article';
			}

			this.requestData = '&itemId='+this.itemId+'&contentType='+contentType;

			this.inPageSliderContainer = inPageSliderContainer;
			this.sliderInt = sliderInt;

			this.preLoadImages();
		},
		preLoadImages : function(){
			var mainObj = this,preImageArr,i,inPageSlider = this.inPageSliderContainer.find('.js-slider'),inPageSliderExist = false;
			if(inPageSlider.length){
				inPageSliderExist = true;
			}

			this.requestData += '&start=1&count='+this.totalSlides;
			$.ajax({
				method: 'get',
				data: 'type=preloadImages'+mainObj.requestData,
				url: mainObj.requestUrl,
				success: function(data, status, xhr) {
					mainObj.ajaxResponse = $.parseJSON(xhr.responseText);
					if(mainObj.totalSlides > 1){
						preImageArr = [''+mainObj.totalSlides-1+'',''+mainObj.totalSlides+'','1','2'];
						preImageArr = jQuery.unique( preImageArr );
					} else if(mainObj.totalSlides == 1){
						preImageArr = ['1'];
					}

					$.each(preImageArr, function(i, item) {
						mainObj.checkImageExists(mainObj.container.find('.js-slider'),item);
						if(inPageSliderExist == true){
							mainObj.checkImageExists(inPageSlider,item);
						}
					});
					//load credit caption for full page slideshow
					mainObj.loadCreditCaption(mainObj.sliderInt,mainObj.container);

					//load credit caption for in-page slideshow
					if(inPageSliderExist == true){
						mainObj.loadCreditCaption(mainObj.sliderInt,mainObj.inPageSliderContainer);
					}
				}
			});
		},
		checkImageExists : function(sliderType,imgPos,isFullScreen) {
			var isStartImageExist;
			if(imgPos < 1) {
				imgPos = this.totalSlides;
			} else if(imgPos > this.totalSlides) {
				imgPos = 1;
			}

			isStartImageExist = sliderType.find('div[data-slideid="'+imgPos+'"] img');
			if(!isStartImageExist.length || $('body').hasClass('resized')){
				if(typeof(isFullScreen) !== 'undefined'){
					sliderType.find('.opaque').show();
				}
				this.loadImages(imgPos,sliderType,isFullScreen);
			}
		},
		loadCreditCaption : function (imgPos,sliderType,isFullScreen){
			var getImgResponse = this.ajaxResponse[imgPos],imgCaption,mainObj=this;
			if(typeof(getImgResponse.imgCredit) !== 'undefined') {
				sliderType.find('.js-image-credit').html(getImgResponse.imgCredit).removeClass("is-invisible");
				//sliderType.find('.js-image-credit').addClass("is-visible").removeClass("is-invisible");
			} else {
				sliderType.find('.js-image-credit').html('').addClass("is-invisible").addClass("is-invisible");
			}

			if(typeof(getImgResponse.imgCaption) !== 'undefined') {
				imgCaption = decodeURIComponent((getImgResponse.imgCaption+'').replace(/\+/g, '%20'));
				sliderType.find('.js-image-caption').addClass('is-invisible');
				sliderType.find('span[data-captionid="'+imgPos+'"]').removeClass("is-invisible");
			}else {
				sliderType.find('.js-image-caption').addClass("is-invisible");
			}
			if(typeof(isFullScreen) === 'undefined'){
				this.setMaxHeight(imgPos,sliderType);
			}
		},
		setMaxHeight: function(imgPos,sliderType){
			if ($('body').hasClass('portrait')){
				var captionElem = $('.js-fullPageSlider').find('.slideshow-caption'),
				sliderHeight = $(window).height() - (captionElem.outerHeight(true) + $('.slideshow-header').outerHeight( true ));
				if($('.js-fullPageSlider span[data-captionid="'+imgPos+'"]').length !== 0){
					sliderHeight = sliderHeight - $('.js-fullPageSlider span[data-captionid="'+imgPos+'"]').outerHeight(true) ;
				}
				sliderType.find('div[data-slideid="'+imgPos+'"] img').css("max-height", sliderHeight + "px");
			}
		},

		loadImages : function (imgPos,sliderType,isFullScreen){
			var getImgObj,imgSrc,imgWidth,imgSrcSet='',getDimension,
				vpWidth = $(window).width(),imgMasterWidth,
				currentImg = sliderType.find('div[data-slideid="'+imgPos+'"]');

			if(typeof(this.ajaxResponse) !== 'undefined'){
				getImgObj = this.ajaxResponse[imgPos];
				if(typeof(getImgObj) !== 'undefined'){
					if(vpWidth <= 991 && getImgObj.width > 991){
						imgWidth = 991;
					}else if(vpWidth <= 1440 && getImgObj.width > 1440){
						imgWidth = 1440;
					}else if(vpWidth <= 1920 && getImgObj.width > 1920){
						imgWidth = 1920;
					}else if(vpWidth <= 2560 && getImgObj.width > 2560){
						imgWidth = 2499;
					}else{
						imgWidth = getImgObj.width;
					}
				
					imgSrc = getImgObj.imgSrc+'?w='+imgWidth;
					imgMasterWidth = imgWidth*2;
					if(getImgObj.width > imgWidth*2){
						imgSrcSet = ' srcset="'+getImgObj.imgSrc+'?w='+imgMasterWidth+' 2x" ';
					}
					if(currentImg.find('img').attr('src') !== imgSrc || typeof(isFullScreen) !== 'undefined'){
						currentImg.html('<img class="slideshow-image" src="'+imgSrc+'"'+imgSrcSet+' />');
					}
				}
				if(sliderType.find('.opaque').css("display") == "block"){
					var mainObj = this;
					var slideImage = sliderType.find('.slide-image');// for in-page height adjustment
					sliderType.find('div[data-slideid="'+imgPos+'"] img').on('load', function() {
						mainObj.setMaxHeight(imgPos,sliderType);
						sliderType.find('.opaque').fadeOut();
						if(slideImage.length && slideImage.hasClass('inactive')){
							slideImage.removeClass('inactive');
						}
					});
				}
			}
		},

		
	};

	cti.initSliderFn = {

		init: function(isAjaxMode,articleId) {

			this.isAjaxMode = isAjaxMode;

			if(typeof(articleId) !== 'undefined'){
				this.fullImageModal = 'fullImageModal_'+articleId;
			}else{
				this.fullImageModal = 'fullImageModal';
			}
			this.articleWrapper = $('#'+this.fullImageModal).parent();
			this.fullPageSlideContainer = this.articleWrapper.find('.js-fullPageSlider');
			this.inPageSliderContainer = this.articleWrapper.find('.js-inPageSlider');

			this.initInPageSlider();
			this.initFullPageSlider();
		},
		initInPageSlider : function(){
			var totalSlides = this.fullPageSlideContainer.find('.js-slider').eq(0).children('div.articleImg').length,
			sliderInt;

			this.inPageSlider = this.inPageSliderContainer.find('.js-slider').eq(0);

			if( this.inPageSlider.children("div.articleImg.active").length){
				sliderInt = parseInt(this.inPageSlider.children("div.articleImg.active").data('slideid'));
			} else {
				sliderInt = 1;
			}

			if(typeof(this.isAjaxMode) !== 'undefined'){
				// unbind click event from in-page and full-page slideshows
				this.articleWrapper.find('.js-previous,.js-next').off('click touchend');
			}

			if(totalSlides){
				cti.fetchImages.init(this.fullPageSlideContainer,totalSlides,this.inPageSliderContainer,sliderInt);
			}
			if(this.inPageSliderContainer.length){
				cti.imageSlider.init(this.inPageSliderContainer,sliderInt);
			}
		},
		initFullPageSlider : function(){
			// attach full-page slideshow player to the article embedded images.
			if($('#'+this.fullImageModal).length){
				var embedded_image = this.articleWrapper.find('.image_embedded'),
					fullimage_trigger = embedded_image.parents('.imageWrapper,.js-slideshow_trigger'),
					hoverElemTrigger = this.articleWrapper.find('.imageWrapper');

				embedded_image.attr('data-modalid',this.fullImageModal);

				if(typeof(this.isAjaxMode) !== 'undefined'){
					fullimage_trigger.off('click touchend');
				}
				
				cti.fullimage_popup(fullimage_trigger,this.fullPageSlideContainer,this.inPageSliderContainer);
				
				if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) == false) {
					cti.imageHover(hoverElemTrigger,false);
				}else{
					cti.imageHover(hoverElemTrigger,true);
				}
			}
		}
	}
	
	cti.applyOrientation = {
		init: function(resizeClass) {
			if (window.innerHeight > window.innerWidth) {
				$('body').addClass('portrait'+resizeClass).removeClass('landscape');
			} else {
				$('body').addClass('landscape'+resizeClass).removeClass('portrait');
			}
			if(resizeClass !== '' && $('.js-canReadItem').val() !== "false"){
				var imgPos = $('.js-slider').find('.active').data('slideid'),
				sliderType = $('.js-inPageSlider, #fullImageModal').not('.is-invisible');
				cti.fetchImages.loadImages(imgPos,sliderType);
			}
		}
	}

})(window, jQuery);

//dom ready state
$(function() {
	var countSlideshow = $('[id^=fullImageModal]');

	if(countSlideshow.length == 1) {
		cti.initSliderFn.init();
	}
	
	window.onresize = function (event) {
		cti.applyOrientation.init(' resized');
	}
	window.onload = function (event) {
		cti.applyOrientation.init('');
	}
});