jQuery.noConflict();

var movable_col_waiting = false;
var movable_column_id = "movable_column";

jQuery(document).ready(function() {
	
	// Adds the scroll event handler if this page has a movable column.
	if (jQuery('#movable_column').length > 0) {
		jQuery(document).scroll(function() {
			if (!movable_col_waiting) {
				movable_col_waiting = true;
				var t=setTimeout("changePosition()",500);
			}
		});
	}
	
});

function changePosition () {
	
	var top_margin = 20;
	var bottom_margin = 20;
	var element_to_move = jQuery('#'+movable_column_id);
	
	var element_to_stay_above = jQuery('.footer-container');
	var element_to_stay_beneath = jQuery('.top-bar');
	
	var min_top = jQuery(element_to_stay_beneath).outerHeight() + jQuery(element_to_stay_beneath).offset().top + top_margin;
	var max_top = jQuery(element_to_stay_above).offset().top - jQuery(element_to_move).outerHeight() - bottom_margin;
	var current_pos = jQuery(document).scrollTop();

	var set_top = min_top;
	var set_left = jQuery(element_to_move).offset().left;

	if (current_pos > min_top) { set_top = current_pos; }
	if (set_top > max_top) { set_top = max_top; }

	jQuery(element_to_move).animate({top: set_top}, 500, function() {
		// Not sure there's anything to go here.
	});

	movable_col_waiting = false;
}

function sendMail(el_id) {
	
	var valid = true;
	var list = "<div id='error-list'><h2>Whoops!</h2><ul>";
	
	jQuery('#error-list').remove();
	
	// Validate the First Name
	if (jQuery('#first_name').val() == "") {
		valid = false;
		list += "<li>First Name is required.</li>";
		jQuery('#first_name').addClass('formerror');
	} else {	
		jQuery('#first_name').removeClass('formerror');
	}

	// Validate the Last Name
	if (jQuery('#last_name').val() == "") {
		valid = false;
		list += "<li>Last Name is required.</li>";
		jQuery('#last_name').addClass('formerror');
	} else {	
		jQuery('#last_name').removeClass('formerror');
	}
	
	// Validate the Email
	filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	if (jQuery('#email').val() == "") {
		valid = false;
		list += "<li>Email is required.</li>";
		jQuery('#email').addClass('formerror');
	} else if (!filter.test(jQuery('#email').val())) {
		valid = false;
		list += "<li>The Email you entered is invalid.</li>";
		jQuery('#email').addClass('formerror');
	} else {	
		jQuery('#email').removeClass('formerror');
	}

	// Validate the Message
	if (jQuery('#message').val() == "") {
		valid = false;
		list += "<li>Message is required.</li>";
		jQuery('#message').addClass('formerror');
	} else {	
		jQuery('#message').removeClass('formerror');
	}
	
	// Validate the Multiplication Question
	if (parseInt(jQuery('#multiply-1').val()) + parseInt(jQuery('#multiply-2').val()) != parseInt(jQuery('#multiply-3').val())) {
		valid = false;
		list += "<li>" + jQuery('#multiply-1').val() + " + " + jQuery('#multiply-2').val() + " is not '" + jQuery('#multiply-3').val() + "'.</li>";
		jQuery('#multiply-3').addClass('formerror');
	} else {	
		jQuery('#multiply-3').removeClass('formerror');
	}
	
	list += "</ul></div>";
	
	if (valid) {
		jQuery.post('/mods/php/mailer.php', jQuery('#'+el_id).serialize(), function(json) {
			data = jQuery.getJSON(json);
			if(data.success) {
				jQuery('#'+el_id).html("<h2>Thank You!</h2><p>Your message has been received.</p>");
			} else 	{
				jQuery('#'+el_id).prepend("<div id='error-list'><h1>Whoops!</h1><p>Your message could not be delivered.</p></div>");
			}
	    });
	} else {
		jQuery('#'+el_id).before(list);
	}
}

function showDesc(id, el) {
	ti = jQuery(el).html();
	jQuery("#"+id).dialog({ modal: true, width: 500, title: ti });
}
