(function(global,$) {
	'use strict';

	global.cti || (global.cti = {});
	
	
	/**
	 *  [FUNCTION] cti.fixedHeader
	 *  [IMPLEMENTATION] 
	 *  var fixedHeader = $('.js-fixedHeader');
	 *  if(fixedHeader.length) {cti.fixedHeader(fixedHeader);}
	 *  
	 */
	cti.fixedHeader = u$.createFactory({
		initialize: function(container) {
			this.container = container; // fixed header content
			this.subContent = this.container.find('.js-fixed-header_subcontent'); // search box below fixed header
			this.subcontentLauncher = this.container.find('.js-fixed-header_search-launcher'); // button launcher for search box
			this.subcontentHide = this.subContent.find('.js-fixed-header_subcontent-close'); // close button for search box
			this.fhStartPoint = $('.js-fixedHeader_start'); // article body content starts at this class
			this.fhTopOffset = parseInt(this.fhStartPoint.offset().top); // article body content start top offset 
			this.contentConclusion = this.fhStartPoint.find('.js-fixedHeader_stop'); // article body concludes here
			this.checkGuest = this.fhStartPoint.find('.js-unsubscribed'); // login box container to check if user is guest
			this.contentTopValue = parseInt(this.contentConclusion.offset().top); // end of article content - top offset
			this.totalPages = this.fhStartPoint.find('.js-countPages').data('pages'); // class which saves number of pages
			this.progressBar = this.container.find('.js-fixed-header_presentProgress'); // progress bar 
			this.uri = u$.getObjectFromQuery(document.URL); // url check
			this.singlePageCheck = $('.js-fixedHeader_solo'); // For single pages 
			this.presentPage = this.fhStartPoint.find('.js-presentPage').text();
			this.fhVisibility();
			this.fhToggleSubcontentVisibility();
		},
		fhVisibility: function(){
			$(window).scroll( $.proxy(function(event) {
				if(this.fhTopOffset <= $(window).scrollTop()){
					this.container.slideDown("slow");
					this.fhProgression();
					this.fhSubcontentVisibility();
				}else{
					this.container.slideUp("slow");
				}
			}, this));
		},
		fhProgression: function(){
			this.progression = ($(window).scrollTop() - this.fhTopOffset);
			

			if(this.checkGuest.length > 0){

				/* 
					[PAID ARTICLE OPENED BY GUEST USER]
					The login+subscribe box is found and we assign it 5 total pages, 
					as there is no way to assess how many pages does the article have.
				*/

				this.totalPages = 5;
				this.progress = ((this.progression/ this.fhStartPoint.height()) / this.totalPages)*100;
			}else{
				if(this.singlePageCheck.length > 0){
					// Extra additions because the stop comes before the container div ends
					this.progress = ((( this.progression + 100 )/this.contentTopValue)*100)+40;
					if(this.progress < 60){
						this.progress = 0;
					}
				}else{
					this.progress = (this.progression / this.fhStartPoint.height())*100;
				}
			}

			$(window).scroll( $.proxy(function(event) {
				if(this.contentTopValue >= $(window).scrollTop()){
					if(this.progress > 95){
						this.progress = 100;
					}
					
					this.progressBar.css('width',this.progress + '%');
				}
			}, this));

		},
		fhSubcontentVisibility: function(){
			this.subcontentLauncher.click( $.proxy(function(event) {
				event.preventDefault();
				this.subContent.fadeIn('slow');
				this.subContent.find('input[type=text]').focus();
			}, this));
			this.subcontentHide.click( $.proxy(function(event) {
				event.preventDefault();
				this.subContent.fadeOut('slow');
			}, this));
			if(this.contentTopValue <= $(window).scrollTop() ){
				this.subContent.slideUp("slow");
			}
		},
		fhToggleSubcontentVisibility: function(){
			$(document).click( $.proxy(function(e) {
				var fixedHeaderElements = $(".js-fixed-header_subcontent,.js-fixed-header_search-launcher"),
					fixedHeaderLauncher=$('.js-fixed-header_search-launcher');
				if (!fixedHeaderLauncher.is(e.target) && !fixedHeaderElements.is(e.target) && fixedHeaderLauncher.has(e.target).length === 0 && fixedHeaderElements.has(e.target).length === 0){
					this.subContent.slideUp("slow");
				}
			}, this));
		}
	});
})(window, window.jQuery);
$(function() {
	var fixedHeader = $('.js-fixedHeader');

	if(fixedHeader.length) {
		cti.fixedHeader(fixedHeader);
	}
});