!function() {
  if ("object" != typeof window.janrain) {
    window.janrain = {};
  }
  if ("object" != typeof window.janrain.settings) {
    window.janrain.settings = {};
  }
  if ("object" != typeof window.janrain.settings.share) {
    window.janrain.settings.share = {};
  }
  if ("object" != typeof window.janrain.settings.packages) {
    /** @type {Array} */
    janrain.settings.packages = [];
  }
  janrain.settings.packages.push("share");
  /** @type {Array} */
  janrain.settings.share.providers = ["facebook", "twitter", "linkedin"];
  /** @type {Array} */
  janrain.settings.share.providersEmail = [];
  /** @type {Array} */
  janrain.settings.share.modes = ["broadcast", "contact"];
  /** @type {boolean} */
  janrain.settings.share.attributionDisplay = true;
  /** @type {string} */
  janrain.settings.share.message = "";
  /** @type {string} */
  janrain.settings.share.title = "";
  /** @type {string} */
  janrain.settings.share.url = "";
  /** @type {string} */
  janrain.settings.share.description = "";
  /** @type {string} */
  janrain.settings.share.modalBackgroundColor = "#000000";
  /** @type {string} */
  janrain.settings.share.modalBorderRadius = "5";
  /** @type {string} */
  janrain.settings.share.modalOpacity = "0.5";
  /** @type {string} */
  janrain.settings.share.modalWidth = "5";
  /** @type {string} */
  janrain.settings.share.bodyBackgroundColor = "#009DDC";
  /** @type {boolean} */
  janrain.settings.share.bodyBackgroundColorOverride = false;
  /** @type {string} */
  janrain.settings.share.bodyColor = "#333333";
  /** @type {string} */
  janrain.settings.share.bodyContentBackgroundColor = "#ffffff";
  /** @type {string} */
  janrain.settings.share.bodyFontFamily = "Helvetica";
  /** @type {string} */
  janrain.settings.share.bodyTabBackgroundColor = "#f8f8f8";
  /** @type {string} */
  janrain.settings.share.bodyTabColor = "#000000";
  /** @type {string} */
  janrain.settings.share.elementBackgroundColor = "#f6f6f6";
  /** @type {string} */
  janrain.settings.share.elementBorderColor = "#cccccc";
  /** @type {string} */
  janrain.settings.share.elementBorderRadius = "3";
  /** @type {string} */
  janrain.settings.share.elementButtonBorderRadius = "6";
  /** @type {string} */
  janrain.settings.share.elementButtonBoxShadow = "3";
  /** @type {string} */
  janrain.settings.share.elementColor = "#cccccc";
  /** @type {string} */
  janrain.settings.share.elementHoverBackgroundColor = "#eeeeee";
  /** @type {string} */
  janrain.settings.share.elementLinkColor = "#009DDC";
}(), function(angular, $window, d) {
  if (!$window.cti) {
    $window.cti = {};
  }
  if (!cti.janrain) {
    cti.janrain = {};
  }
  if (!cti.janrain.share) {
    cti.janrain.share = {};
  }
  var share = cti.janrain.share;
  /**
   * @param {Object} info
   * @return {undefined}
   */
  share.gaTracker = function(info) {
    /** @type {string} */
    var category = "Share" + (info.widget ? ": " + info.widget : "");
    if (angular.isFunction($window.ga)) {
      ga("send", "event", category, info.provider || info.eventAction, info.title);
    } else {
      if ($window._gaq) {
        _gaq.push(["_trackEvent", category, info.provider || info.eventAction, info.title]);
      }
    }
  };
}(window.Zepto || window.jQuery, window, document), function(jQuery, $) {
  if (!$.cti) {
    $.cti = {};
  }
  if (!cti.janrain) {
    cti.janrain = {};
  }
  cti.janrain.events = {
    /**
     * @param {string} type
     * @param {Function} fn
     * @param {Object} context
     * @return {?}
     */
    on : function(type, fn, context) {
      return this._events || (this._events = {}), this._events[type] || (this._events[type] = []), jQuery.isFunction(fn) && this._events[type].push({
        /** @type {Function} */
        fn : fn,
        bind : context
      }), this;
    },
    /**
     * @param {?} type
     * @param {boolean} handler
     * @param {boolean} id
     * @return {?}
     */
    off : function(type, handler, id) {
      var listener;
      var listeners = this._events && this._events[type];
      var i = listeners && listeners.length - 1;
      if (listeners) {
        if (handler || id) {
          for (;i >= 0;) {
            listener = listeners[i];
            if (!(handler && listener.fn !== handler)) {
              if (!(id && listener.bind !== id)) {
                listeners.splice(0, 1);
              }
            }
            i -= 1;
          }
        } else {
          /** @type {Array} */
          listeners.length = [];
        }
      }
      return this;
    },
    /**
     * @param {string} type
     * @return {?}
     */
    trigger : function(type) {
      var args;
      var which = this._events && this._events[type];
      return which && (args = [].slice.call(arguments, 1), jQuery.each(which, function(dataAndEvents, options) {
        if (jQuery.isFunction(options.fn)) {
          options.fn.apply(options.bind || null, args);
        }
      })), this;
    }
  };
}(window.Zepto || window.jQuery, window), function(self, exports, d) {
  if (!exports.cti) {
    exports.cti = {};
  }
  if (!cti.janrain) {
    cti.janrain = {};
  }
  if (!cti.janrain.share) {
    cti.janrain.share = {};
  }
  var $ = cti.janrain.share;
  var info = {};
  $.janrain = {
    /**
     * @param {Object} name
     * @return {undefined}
     */
    initialize : function(name) {
      if (!name) {
        throw{
          name : "JanrainShareError",
          message : "Missing events object in `janrain` controller."
        };
      }
      /** @type {Object} */
      this.events = name;
      this.subscribe();
      this.attach();
    },
    /**
     * @return {undefined}
     */
    subscribe : function() {
      this.events.on("socialShare", this.triggerFlow, this);
    },
    /**
     * @return {undefined}
     */
    attach : function() {
      janrain.events.onShareSendComplete.addHandler(function(e) {
        if (e) {
          if (e.success) {
            $.gaTracker(info);
          }
        }
      }.bind(this));
    },
    /**
     * @param {string} requestUrl
     * @param {string} path
     * @return {?}
     */
    buildShareUrl : function(requestUrl, path) {
    	
      return path || (path = ""), requestUrl = requestUrl.replace(/visit_source=[a-z]+/, ""), requestUrl += -1 === requestUrl.indexOf("?") ? "?" : "&", requestUrl += "visit_source=" + path;
      
    },
    /**
     * @param {Object} data
     * @return {undefined}
     */
    triggerFlow : function(data) {
      data.url = this.buildShareUrl(data.url, data.provider);
      /** @type {Object} */
      info = data;
      this.reset(data);
      janrain.engage.share.show();
    },
    /**
     * @param {Object} item
     * @return {undefined}
     */
    reset : function(item) {
      var value = item.text;
      var e = item.media;
      janrain.engage.share.reset();
      janrain.engage.share.setTitle(item.title);
      janrain.engage.share.setUrl(item.url);
      if (value) {
        /** @type {string} */
        value = decodeURIComponent(value.replace(/\+/g, " "));
        janrain.engage.share.setMessage(value);
      }
      if (e) {
        e = "string" == typeof e ? e : e.get("content");
        janrain.engage.share.setImage(e);
      }
      janrain.engage.share.showProvider(item.provider);
    },
    /**
     * @param {Array} models
     * @return {undefined}
     */
    getShareCounts : function(models) {
      if (self.isArray(models)) {
        models = models.map(function(sectionName) {
          return encodeURIComponent(sectionName);
        }).join(",");
      }
      console.log(models);
      self.ajax({
        data : "urls=" + models + "&" + (new Date).getTime(),
        url : "/system/social/ajax/get_sharecounts.html",
        success : function(dataAndEvents, deepDataAndEvents, xhr) {
          var e = self.parseJSON(xhr.responseText);
          this.events.trigger("shareCountsLoaded", e);
        }.bind(this)
      });
    }
  };
}(window.Zepto || window.jQuery, window, document), function($, win, d) {
  if (!win.cti) {
    win.cti = {};
  }
  if (!cti.janrain) {
    cti.janrain = {};
  }
  if (!cti.janrain.share) {
    cti.janrain.share = {};
  }
  var info;
  var share = cti.janrain.share;
  /** @type {Object} */
  var $scope = Object.create(null);
  var options = {
    cssFilePath : "/system/social/styles/share.css?07082014",
    marginTop : 5,
    minWidth : 1152,
    startY : 0
  };
  share.presenter = {
    /**
     * @param {Object} name
     * @param {?} opts
     * @return {undefined}
     */
    initialize : function(name, opts) {
      if (!name) {
        throw{
          name : "JanrainShareError",
          message : "Missing events object in `view` controller."
        };
      }
      this.options = $.extend({}, options, opts);
      /** @type {Object} */
      this.events = name;
      this.loadCSS();
      this.loadElements();
      if (this.$all.length) {
        this.prepareForDisplay().attach();
        this.subscribe();
        this.setDefaults();
      }
    },
    /**
     * @return {undefined}
     */
    setDefaults : function() {
      /** @type {(Location|null)} */
      var loc = location;
      var type = $("meta[property=og\\:image]").attr("content");
      /** @type {string} */
      $scope.shareTitle = d.title;
      /** @type {string} */
      $scope.shareUrl = loc.protocol + "//" + loc.hostname + loc.pathname;
      $scope.shareMedia = type || "";
    },
    /**
     * @return {undefined}
     */
    subscribe : function() {
      this.events.on("shareCountsLoaded", this.setFacebookCounts, this);
    },
    /**
     * @return {undefined}
     */
    loadCSS : function() {
      var target;
      /** @type {Element} */
      var elem = d.createElement("link");
      if (!d.getElementById("ctSocialShareCSS")) {
        /** @type {string} */
        elem.rel = "stylesheet";
        /** @type {string} */
        elem.id = "ctSocialShareCSS";
        elem.href = this.options.cssFilePath;
        target = d.getElementsByTagName("link")[0];
        if (target) {
          target.parentNode.appendChild(elem);
        }
      }
    },
    /**
     * @return {undefined}
     */
    loadElements : function() {
      this.$sharebar = $("#ctSocialShare");
      this.$fallbacks = $(".ctSocialShare_fallback");
      this.$permanent = $(".ctSocialShare_permanent");
      this.$all = this.$sharebar.add(this.$fallbacks).add(this.$permanent);
      if (this.$sharebar.length) {
        this.$additional = this.$sharebar.find(".ctSocialShare_expandedList");
      }
    },
    /**
     * @param {?} i
     * @return {?}
     */
    setCurrent : function(i) {
      var options = this.options;
      return this.current = this.$sharebar.length && i >= options.minWidth ? "sharebar" : "fallbacks", this.current;
    },
    /**
     * @return {?}
     */
    prepareForDisplay : function() {
      return this.setCurrent($(win).width()), this.$sharebar.length && this.$sharebar.css({
        marginTop : this.options.marginTop,
        top : this.options.startY
      }), this.$permanent.length && this.show(this.$permanent), this;
    },
    /**
     * @return {?}
     */
    attach : function() {
      var elems = this;
      return this.setWindowObserver(), this.setToggler(), this.$all.each(function() {
        elems.add($(this), true);
      }), this;
    },
    /**
     * @param {Object} target
     * @return {?}
     */
    contains : function(target) {
      return this.$all.index(target) >= 0;
    },
    /**
     * @param {Object} header
     * @return {undefined}
     */
    updateSharebars : function(header) {
      this.$all = this.$all.add(header);
      if (header.hasClass("ctSocialShare_fallback")) {
        this.$fallbacks = this.$fallbacks.add(header);
        if ("fallbacks" === this.current) {
          this.show(header);
        }
      }
      if (header.hasClass("ctSocialShare_permanent")) {
        this.$permanent = this.$permanent.add(header);
        this.show(header);
      }
    },
    /**
     * @param {Object} value
     * @param {boolean} dataAndEvents
     * @return {?}
     */
    add : function(value, dataAndEvents) {
      return(dataAndEvents || !this.contains(value)) && (this.updateSharebars(value), this.setShareHandler(value), this.setEventTracker(value)), this;
    },
    /**
     * @param {Object} a
     * @return {undefined}
     */
    setShareHandler : function(a) {
      a.on("click", ".js-shareItem,.js-openWindow", $.proxy(function(event) {
        var $el = $(event.currentTarget);
        var desc = $(event.liveFired || event.delegateTarget);
        event.preventDefault();
        info = this.getShareData(desc, $el);
        var titleLength = info.title.length; 
        var provider = info.provider;
				
        if(titleLength > 95 && provider == "twitter") {
        	info.text = info.text.replace(/\+/g,' ');
        	info.text = info.text.substring(0,90);

        	var cutat= info.text.lastIndexOf(' ');

					if(cutat!=-1) info.text = info.text.substring(0,cutat)+'... via @CTMagazine';
        } 
        if ($el.data("provider")) {
          this.sendToJanrain(info);
        } else {
          if ($el.hasClass("js-openWindow")) {
            this.openWindow($el);
          }
        }
      }, this));
    },
    /**
     * @param {Object} a
     * @return {undefined}
     */
    setEventTracker : function(a) {
      a.on("click", ".js-trackJanrainClick,.js-shareItem", $.proxy(function(event) {
        var clearing = $(event.currentTarget);
        var desc = $(event.liveFired || event.delegateTarget);
        info = this.getShareData(desc, clearing);
        share.gaTracker(info);
      }, this));
    },
    /**
     * @param {MessageEvent} desc
     * @param {Object} $el
     * @return {?}
     */
    getShareData : function(desc, $el) {
      var module = {};
      return["Title", "Url", "Media", "Text", "Widget"].forEach(function(format) {
        var id = format.toLowerCase();
        /** @type {string} */
        var target = "share" + id;

        module[id] = $el && $el.data(target) || (desc.data(target) || ($scope["share" + format] || null));
      }), module.provider = $el.data("provider"), module.eventAction = $el.data("eventaction"), module;
    },
    /**
     * @return {?}
     */
    getCountUrls : function() {
      /** @type {Array} */
      var eventPath = [];
      return this.$all.each(function(dataAndEvents, form) {
        eventPath.push($(form).data("counturl") || $scope.shareUrl);
      }), eventPath;
    },
    /**
     * @param {?} event
     * @return {undefined}
     */
    sendToJanrain : function(event) {
      this.events.trigger("socialShare", event);
    },
    /**
     * @param {HTMLElement} element
     * @return {undefined}
     */
    openWindow : function(element) {
      var href = element.attr("href");
      /** @type {string} */
      var optionString = "width=960,height=450,toolbar=0,location=0,directories=0,status=0,menubar=1,scrollbars=1,resizable=0";
      if (href) {
        win.open(href, "printWindow", optionString);
      }
    },
    /**
     * @param {HTMLElement} name
     * @return {undefined}
     */
    toggleView : function(name) {
      var easing;
      if (this.$additional.hasClass("is-invisible")) {
        easing = u$.height(this.$additional);
        this.$additional.css({
          height : 0,
          overflow : "hidden"
        }).removeClass("is-invisible");
        u$.slideDown(this.$additional, easing);
        name.removeClass("is-collapsed").addClass("is-expanded");
      } else {
        this.$additional.slideUp(function() {
          $(this).addClass("is-invisible");
        });
        name.removeClass("is-expanded").addClass("is-collapsed");
      }
    },
    /**
     * @return {undefined}
     */
    setToggler : function() {
      if (this.$sharebar.length) {
        this.$sharebar.on("click", ".js-toggle-share", $.proxy(function(ev) {
          this.toggleView($(ev.currentTarget));
        }, this));
      }
    },
    /**
     * @return {?}
     */
    setWindowObserver : function() {
      var $win = $(win);
      var b = (this.options.minWidth, this.options.startY);
      return this.$sharebar.length ? (this.show(this["$" + this.setCurrent($win.width())]), $win.on({
        scroll : $.proxy(function() {
          var a = $win.scrollTop();
          /** @type {number} */
          var meterPos = a > b ? 0 : b - a;
          this.$sharebar.css("top", meterPos);
        }, this),
        resize : $.proxy(function() {
          var item = this.current;
          var key = this.setCurrent($win.width());
          if (item !== key) {
            this.show(this["$" + key]);
            this.hide(this["$" + item]);
          }
        }, this)
      }), this) : void 0;
    },
    /**
     * @param {Object} element
     * @return {undefined}
     */
    show : function(element) {
      element.css({
        opacity : 0,
        display : "block",
        visibility : "visible"
      }).animate({
        opacity : 1
      });
    },
    /**
     * @param {Object} view
     * @return {undefined}
     */
    hide : function(view) {
      view.animate({
        opacity : 0
      }, {
        /**
         * @return {undefined}
         */
        complete : function() {
          $(this).css({
            display : "none",
            visibility : "hidden"
          });
        }
      });
    },
    /**
     * @param {Object} $cookies
     * @return {undefined}
     */
    setFacebookCounts : function($cookies) {
      if (!$cookies.error) {
        this.$all.each(function(dataAndEvents, elem) {
          var $elem = $(elem);
          var key = $elem.data("counturl") || $scope.shareUrl;
          var value = $cookies[key];
          if (value) {
            if (value.count) {
              $elem.find("a[data-provider=facebook] span").text(value.count);
            }
          }
        }.bind(this));
      }
    }
  };
}(window.Zepto || window.jQuery, window, document), function(dataAndEvents, $, d) {
  if (!$.cti) {
    $.cti = {};
  }
  if (!cti.janrain) {
    cti.janrain = {};
  }
  if (!cti.janrain.share) {
    cti.janrain.share = {};
  }
  var app = cti.janrain.share;
  /**
   * @param {?} callback
   * @return {?}
   */
  app.factory = function(callback) {
    /** @type {Object} */
    var name = Object.create(cti.janrain.events);
    /** @type {Object} */
    var dataset = Object.create(app.janrain);
    /** @type {Object} */
    var instance = Object.create(app.presenter);
    return dataset.initialize(name), instance.initialize(name, callback), dataset.getShareCounts(instance.getCountUrls().filter(function(key, object, excludes) {
      return excludes.indexOf(key) === object;
    })), {
      events : name,
      janrain : dataset,
      presenter : instance
    };
  };
}(window.Zepto || window.jQuery, window, document), function() {
  /**
   * @return {undefined}
   */
  function completed() {
    /** @type {boolean} */
    janrain.ready = true;
  }
  if ("object" != typeof window.janrain) {
    window.janrain = {};
  }
  if ("object" != typeof window.janrain.settings) {
    window.janrain.settings = {};
  }
  /** @type {boolean} */
  janrain.settings.custom = true;
  /** @type {string} */
  janrain.settings.tokenUrl = "http://" + location.hostname + "/system/social/ajax.html?janrain=true";
  /** @type {string} */
  janrain.settings.tokenAction = "event";
  if (document.addEventListener) {
    document.addEventListener("DOMContentLoaded", completed, false);
  } else {
    window.attachEvent("onload", completed);
  }
  /** @type {Element} */
  var e = document.createElement("script");
  /** @type {string} */
  e.type = "text/javascript";
  /** @type {string} */
  e.id = "janrainAuthWidget";
  if ("https:" === document.location.protocol) {
    /** @type {string} */
    e.src = "https://rpxnow.com/js/lib/login.christianitytoday.com/engage.js";
  } else {
    /** @type {string} */
    e.src = "http://widget-cdn.rpxnow.com/js/lib/login.christianitytoday.com/engage.js";
  }
  var insertAt = document.getElementsByTagName("script")[0];
  insertAt.parentNode.insertBefore(e, insertAt);
}();


$('div#janrain-share-providerslist-provider-facebook').on('click', function() {
	$('.ctSocialShare_facebook a').click();  
});

$('div#janrain-share-providerslist-provider-twitter').on('click', function() {
	$('.ctSocialShare_twitter a').click();  
});


$('div#janrain-share-providerslist-provider-linkedin').on('click', function() {
	$('.ctSocialShare_linkedin a').click();  
});
