﻿window.onload = init;

function init()
{
	
	// Set flyouts
	setFlyouts();
	
	// Set font size functionality
	var textSize = jQuery('TextSize');
	if (textSize != null)
	{
		var fontSizeLinks = jQuery('TextSize a')
		if (fontSizeLinks.length == 2)
		{
			jQuery(fontSizeLinks[0]).observe('click', changeFontSize);
			jQuery(fontSizeLinks[1]).observe('click', changeFontSize);
		}
	}
	
	// Find popup links
	jQuery('a.Popup').click(function () {
		var url = jQuery(this).attr('href');
		url += (url.indexOf("?") != -1 ? "&" : "?") + "Popup=1";
		openWindow(url, 'Popup', 500, 400, 1, 1, 1, 0, 0);
		return false;
	});
		
	// If the location search script is included, call the init
	if (window.InitLocationSearch)
	{
		InitLocationSearch();
	}
}

// depreciated.
function popupLink(e) 
{
	var trigger = (e.srcElement) ? e.srcElement : e.target;
	if (e.preventDefault)
	{
		e.preventDefault();
	}
	else
	{
		e.returnValue = false;
	}
	console.log(e);
	var url = (e.target ? e.target.href : e.srcElement.href);
	url += (url.indexOf("?") != -1 ? "&" : "?") + "Popup=1";
	openWindow(url , 'Popup', 500, 400, 1, 1, 1, 0, 0);
	return false;
}

function openWindow(url,name,width,height,resizable,scrollbars,statusbar,menubar,toolbar)
{
	var win = (window.name) ? eval(name) : null;
	var optionString = "";
	if (width) optionString += "width=" + width + ",";
	if (height) optionString += "height=" + height + ",";
	if (resizable) optionString += "resizable=" + resizable + ",";
	if (scrollbars) optionString += "scrollbars=" + scrollbars + ",";
	if (statusbar) optionString += "status=" + statusbar + ",";
	if (menubar) optionString += "menubar=" + menubar + ",";
	if (toolbar) optionString += "toolbar=" + toolbar + ",";
	win = window.open(url,name,optionString);
	if (win) win.focus();
}

function printPage()
{
	if (window.print) window.print();
	else alert("Please select \"Print...\" from the File menu.");
}

function setActiveStyleSheet(title)
{
	var i, a, main;
	for(i=0; (a = document.getElementsByTagName("link")[i]); i++)
	{
		if(a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title"))
		{
			a.disabled = true;
			if (a.getAttribute("title") == title) a.disabled = false;
		}
	}
}

function changeFontSize(e)
{
	var trigger = (e.srcElement) ? e.srcElement : e.target;
	var amount = (trigger.innerHTML.indexOf("Larger") != -1) ? 1 : -1;
	
	if (e.preventDefault)
	{
		e.preventDefault();
	}
	else
	{
		e.returnValue = false;
	}

	var currentFontSize = parseInt(getCookie("FontSize"));
	if (isNaN(currentFontSize)) currentFontSize = 0;
	currentFontSize += amount;
	if (currentFontSize > 1) currentFontSize = 1;
	else if (currentFontSize < -1) currentFontSize = -1;
	
	var spans = trigger.parentNode.parentNode.getElementsByTagName("span");
	var spanFontSizeDown = spans[0];
	var spanFontSizeUp = spans[2];
	
	switch (currentFontSize)
	{
		case -1 :
		{
			setActiveStyleSheet("Small text size");
			spanFontSizeDown.style.backgroundImage = "url(/Img/FontSizeSmallerDisabled.gif)";
			spanFontSizeUp.style.backgroundImage = "url(/Img/FontSizeLarger.gif)";
			break;
		}
		case 0 :
		{
			setActiveStyleSheet("Default text size");
			spanFontSizeDown.style.backgroundImage = "url(/Img/FontSizeSmaller.gif)";
			spanFontSizeUp.style.backgroundImage = "url(/Img/FontSizeLarger.gif)";
			break;
		}
		case 1 :
		{
			setActiveStyleSheet("Large text size");
			spanFontSizeDown.style.backgroundImage = "url(/Img/FontSizeSmaller.gif)";
			spanFontSizeUp.style.backgroundImage = "url(/Img/FontSizeLargerDisabled.gif)";
			break;
		}
	}
	
	var nextYear = new Date();
	nextYear.setFullYear(nextYear.getFullYear() + 1);
	setCookie("FontSize", currentFontSize, nextYear);
}

function setFlyouts()
{
	// DEPRECIATED.
	//var globalNav = $('GlobalNavigation');
	//if (globalNav != null)
	//{
	//	if (parseInt(navigator.userAgent.substr(navigator.userAgent.indexOf("MSIE ") + 5, 3)) < 7)
	//	{
	//		// IE6 or below, set up hovers
	//		var navRoots = $(globalNav.getElementsByTagName("ul")[0]).immediateDescendants();
	//		for (var i=0; i<navRoots.length; i++)
	//		{
	//			navRoots[i].onmouseover = function() { this.className += " Hover";}
	//			navRoots[i].onmouseout = function() { this.className = this.className.replace(" Hover", ""); }
	//		}
	//	}
	//	else
	//	{
	//		alert("here");
	//		// Decent browser, set up shadows
	//		var flyouts = $(globalNav).findAll(function (elt) {
	//			return elt.match('div.FlyoutWrapper');
	//		});
	//		for (var i=0; i<flyouts.length; i++)
	//		{
	//			alert("here2");
	//			var shadow = $(flyouts[i].parentNode.insertBefore(Builder.node('div', {className:'FlyoutShadow'}), flyouts[i]));
	//			shadow.appendChild(Builder.node('div'));
	//			shadow.setStyle({height:$(flyouts[i]).getHeight() + 'px'});
	//		}
	//	}
	//}
}

function trim(theString)
{
	var newString = theString;
	while (newString.charAt(0) == " " || newString.charCodeAt(0) == 10 || newString.charCodeAt(0) == 13 || newString.charCodeAt(0) == 9)
	{
		newString = newString.substring(1,newString.length);
	}
	while (newString.charAt(newString.length - 1) == " " || newString.charCodeAt(newString.length - 1) == 10 || newString.charCodeAt(newString.length - 1) == 13 || newString.charCodeAt(newString.length - 1) == 9)
	{
		newString = newString.substring(0,newString.length - 1);
	}
	return newString;
}

function getCookie(name)
{
	var cookies = document.cookie.split(";")
	for (var i=0; i<cookies.length; i++)
	{
		var nameVal = cookies[i].split("=");
		if (nameVal.length == 2 && trim(nameVal[0]) == trim(name))
		{
			return trim(nameVal[1]);
		}
	}
	return "";
}

function setCookie(name, value, expires)
{
	document.cookie = name + "=" + value + ";path=/;" + (expires ? " expires=" + expires.toGMTString() + ";" : "");
}

function removeCookie(name)
{
	setCookie(name, "", new Date("2 January 1970"));
}

function addListener(object, eventType, handler)
{
	if (window.attachEvent)
	{
		object.attachEvent("on" + eventType, handler);
	}
	else if (window.addEventListener)
	{
		object.addEventListener(eventType, handler, false);
	}
}

var xmlRequest;
function GetXml(url, handler)
{
	xmlRequest = null;
	
	// Branch for native XMLHttpRequest object
	if (window.XMLHttpRequest)
	{
		try
		{
			xmlRequest = new XMLHttpRequest();
		}
		catch(e)
		{
			xmlRequest = null;
		}
    // branch for IE/Windows ActiveX version
	}
	else if (window.ActiveXObject)
	{
		try
		{
			xmlRequest = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch(e)
		{
			try
			{
				xmlRequest = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch(e)
			{
				xmlRequest = null;
			}
		}
	}
	if (xmlRequest != null)
	{
		xmlRequest.onreadystatechange = handler;
		xmlRequest.open("GET", url, true);
		xmlRequest.send(null);
	}
}

function parseCurrency(total)
{
	if (total.length == 0) return 0;
	else
	{
		var isNegative = (total.substr(0, 1) == "-" || total.substr(0,1) == "(");
		while (isNaN(total.substr(0, 1))) total = total.substr(1);
		total = parseFloat(total);
		if (isNegative)
		{
			total = 0 - total;
		}
		return total;
	}
}

function formatCurrency(total, noSymbol)
{
	console.log(noSymbol);
	total = Math.round(total * 100) / 100; // fix for stupid JS rounding bug
	var value = (noSymbol ? total.toString() : "$" + total);
	if (noSymbol)
	{
		console.log(value);
	}
	var newValue = "";
	var tokens = value.split(".");
	if (tokens.length == 1)
	{
		newValue += tokens[0] + ".00";
	}
	else if (tokens.length == 2)
	{
		newValue = tokens[0] + "." + tokens[1];
		if (tokens[1].length == 1) newValue += "0";
	}
	return newValue;
}

/*
	In case you're wondering about the part of the function which subtracts and then adds 5000, 
	it's a workaround for a known JavaScript bug (JavaScript can't reliably round numbers 
	between 8192 and 10484).
*/
function roundNumber(number, decimalPlaces)
{
	if (!decimalPlaces) return Math.round(number);
	var newNumber;
	if (number > 8191 && number < 10485)
	{
		number = number - 5000;
		newNumber = Math.round(number * Math.pow(10, decimalPlaces)) / Math.pow(10, decimalPlaces);
		newNumber = newNumber + 5000;
	}
	else
	{
		var newNumber = Math.round(number * Math.pow(10, decimalPlaces)) / Math.pow(10, decimalPlaces);
	}
	return newNumber;
}

if ((typeof HTMLElement != "undefined") && (typeof HTMLElement.prototype.__defineGetter__ != "undefined")) {
	HTMLElement.prototype.__defineGetter__(
		"innerText",
		function () {
			var range = this.ownerDocument.createRange();
			range.selectNodeContents(this);
			return range.toString();
		}
	);
	HTMLElement.prototype.__defineSetter__(
		"innerText",
		function (text) {
			var range = this.ownerDocument.createRange();
			range.selectNodeContents(this);
			range.deleteContents();
			this.appendChild(document.createTextNode(text));
		}
	);
}
else if(typeof HTMLElement != "undefined")
{
	Object.defineProperty(HTMLElement, "innerText", {
		get: function () {
			var range = this.ownerDocument.createRange();
			range.selectNodeContents(this);
			return range.toString();
		},
		set: function (text) {
			var range = this.ownerDocument.createRange();
			range.selectNodeContents(this);
			range.deleteContents();
			this.appendChild(document.createTextNode(text));
		}
	});
}

// String format method
if (!String.prototype.format) {
	String.prototype.format = function () {
		var args = arguments;
		return this.replace(/{(\d+)}/g, function (match, number) {
			return typeof args[number] != 'undefined'
			  ? args[number]
			  : match
			;
		});
	};
}

if (typeof String.prototype.trim !== 'function') {
	String.prototype.trim = function () {
		return this.replace(/^\s+|\s+$/g, '');
	}
}