(function ($) {
  $(document).ready(function () {
    // toggle the Find Therapist search block on click at mobile widths
    if ( window.innerWidth < 480 && !$('body').hasClass('front') ) {
      $('#td_search_label').removeClass('top-search-open');
      $('.input-wrapper').css('display', 'none');

      tdToggleEvent();
    }

    // We need to reset and reapply bindings after page resize
    $(window).bind('resize.ptSlideToggle', function(event){
      clearTimeout(this.id);
      this.id = setTimeout(handleResize, 200);
    });

    // Reset the state of Therapist Directory to closed after a window resize
    // Specifically unbind the click event (runs a slideToggle) every time to keep them from repeating
    function handleResize() {
      $('#td_search_label').removeClass('top-search-open');
      $('#td_search_label').unbind('click');

      if (window.innerWidth < 480 && !$('body').hasClass('front')) {
        $('.input-wrapper').css('display', 'none');
        tdToggleEvent();
      }
      else {
        $('.input-wrapper').css('display', 'inline-block');
      }
    }

    // Binds the slideToggle click event to the td search Label
    function tdToggleEvent() {
      $('#td_search_label').on('click', function (e) {
        e.preventDefault();
        $('.input-wrapper').slideToggle('fast', function () {
          $(this).siblings('#td_search_label').toggleClass('top-search-open');
        });
      })
    }


  });
})(jQuery);;
(function($) {

  // Country
  var pt_country = localStorage.getItem("pt_country") || '';
  // OK, we're ready!
  $(document).ready(function() {
    // What country are we in?
    switch (pt_country) {
      case 'US': case 'us':
      case 'CA': case 'ca':
      case 'KY': case 'ky':
        // Show the top search block
        $('#block-pt-td-td-top-search').closest('.region-below-header').addClass('show-search-block');
        break;
      default:
        // Do nothing, really.
    }

    // Get the country, if we don't already know. And show Therapist Directory search.
    if (pt_country == '' || pt_country == 'undefined') {
      $.getJSON("/sites/all/modules/custom/pt_td/api/region.php")
        .done(function (json) {

          if ( json.success ) {
            // Set the country to local storage.
            localStorage.setItem("pt_country", json.country);
            switch (json.country) {
              case 'US':
              case 'us':
              case 'CA':
              case 'ca':
              case 'KY':
              case 'ky':
                // Show the top search block
                $('#block-pt-td-td-top-search').closest('.region-below-header').addClass('show-search-block');
                break;
              default:
              // Do nothing, really.
            }
          }
        });
    }
  });

})(jQuery);
;
