
(function($) {

/**
 * Drupal FieldGroup object.
 */
Drupal.FieldGroup = Drupal.FieldGroup || {};
Drupal.FieldGroup.Effects = Drupal.FieldGroup.Effects || {};
Drupal.FieldGroup.groupWithfocus = null;

Drupal.FieldGroup.setGroupWithfocus = function(element) {
  element.css({display: 'block'});
  Drupal.FieldGroup.groupWithfocus = element;
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processFieldset = {
  execute: function (context, settings, type) {
    if (type == 'form') {
      // Add required fields mark to any fieldsets containing required fields
      $('fieldset.fieldset', context).once('fieldgroup-effects', function(i) {
        if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
          $('legend span.fieldset-legend', $(this)).eq(0).append(' ').append($('.form-required').eq(0).clone());
        }
        if ($('.error', $(this)).length) {
          $('legend span.fieldset-legend', $(this)).eq(0).addClass('error');
          Drupal.FieldGroup.setGroupWithfocus($(this));
        }
      });
    }
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processAccordion = {
  execute: function (context, settings, type) {
    $('div.field-group-accordion-wrapper', context).once('fieldgroup-effects', function () {
      var wrapper = $(this);

      // Get the index to set active.
      var active_index = false;
      wrapper.find('.accordion-item').each(function(i) {
        if ($(this).hasClass('field-group-accordion-active')) {
          active_index = i;
        }
      });

      wrapper.accordion({
        heightStyle: "content",
        active: active_index,
        collapsible: true,
        changestart: function(event, ui) {
          if ($(this).hasClass('effect-none')) {
            ui.options.animated = false;
          }
          else {
            ui.options.animated = 'slide';
          }
        }
      });

      if (type == 'form') {

        var $firstErrorItem = false;

        // Add required fields mark to any element containing required fields
        wrapper.find('div.field-group-accordion-item').each(function(i) {

          if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
            $('h3.ui-accordion-header a').eq(i).append(' ').append($('.form-required').eq(0).clone());
          }
          if ($('.error', $(this)).length) {
            // Save first error item, for focussing it.
            if (!$firstErrorItem) {
              $firstErrorItem = $(this).parent().accordion("activate" , i);
            }
            $('h3.ui-accordion-header').eq(i).addClass('error');
          }
        });

        // Save first error item, for focussing it.
        if (!$firstErrorItem) {
          $('.ui-accordion-content-active', $firstErrorItem).css({height: 'auto', width: 'auto', display: 'block'});
        }

      }
    });
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processHtabs = {
  execute: function (context, settings, type) {
    if (type == 'form') {
      // Add required fields mark to any element containing required fields
      $('fieldset.horizontal-tabs-pane', context).once('fieldgroup-effects', function(i) {
        if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
          $(this).data('horizontalTab').link.find('strong:first').after($('.form-required').eq(0).clone()).after(' ');
        }
        if ($('.error', $(this)).length) {
          $(this).data('horizontalTab').link.parent().addClass('error');
          Drupal.FieldGroup.setGroupWithfocus($(this));
          $(this).data('horizontalTab').focus();
        }
      });
    }
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processTabs = {
  execute: function (context, settings, type) {
    if (type == 'form') {

      var errorFocussed = false;

      // Add required fields mark to any fieldsets containing required fields
      $('fieldset.vertical-tabs-pane', context).once('fieldgroup-effects', function(i) {
        if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
          $(this).data('verticalTab').link.find('strong:first').after($('.form-required').eq(0).clone()).after(' ');
        }
        if ($('.error', $(this)).length) {
          $(this).data('verticalTab').link.parent().addClass('error');
          // Focus the first tab with error.
          if (!errorFocussed) {
            Drupal.FieldGroup.setGroupWithfocus($(this));
            $(this).data('verticalTab').focus();
            errorFocussed = true;
          }
        }
      });
    }
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 *
 * TODO clean this up meaning check if this is really
 *      necessary.
 */
Drupal.FieldGroup.Effects.processDiv = {
  execute: function (context, settings, type) {

    $('div.collapsible', context).once('fieldgroup-effects', function() {
      var $wrapper = $(this);

      // Turn the legend into a clickable link, but retain span.field-group-format-toggler
      // for CSS positioning.

      var $toggler = $('span.field-group-format-toggler:first', $wrapper);
      var $link = $('<a class="field-group-format-title" href="#"></a>');
      $link.prepend($toggler.contents());

      // Add required field markers if needed
      if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
        $link.append(' ').append($('.form-required').eq(0).clone());
      }

      $link.appendTo($toggler);

      // .wrapInner() does not retain bound events.
      $link.click(function () {
        var wrapper = $wrapper.get(0);
        // Don't animate multiple times.
        if (!wrapper.animating) {
          wrapper.animating = true;
          var speed = $wrapper.hasClass('speed-fast') ? 300 : 1000;
          if ($wrapper.hasClass('effect-none') && $wrapper.hasClass('speed-none')) {
            $('> .field-group-format-wrapper', wrapper).toggle();
          }
          else if ($wrapper.hasClass('effect-blind')) {
            $('> .field-group-format-wrapper', wrapper).toggle('blind', {}, speed);
          }
          else {
            $('> .field-group-format-wrapper', wrapper).toggle(speed);
          }
          wrapper.animating = false;
        }
        $wrapper.toggleClass('collapsed');
        return false;
      });

    });
  }
};

/**
 * Behaviors.
 */
Drupal.behaviors.fieldGroup = {
  attach: function (context, settings) {
    settings.field_group = settings.field_group || Drupal.settings.field_group;
    if (settings.field_group == undefined) {
      return;
    }

    // Execute all of them.
    $.each(Drupal.FieldGroup.Effects, function (func) {
      // We check for a wrapper function in Drupal.field_group as
      // alternative for dynamic string function calls.
      var type = func.toLowerCase().replace("process", "");
      if (settings.field_group[type] != undefined && $.isFunction(this.execute)) {
        this.execute(context, settings, settings.field_group[type]);
      }
    });

    // Fixes css for fieldgroups under vertical tabs.
    $('.fieldset-wrapper .fieldset > legend').css({display: 'block'});
    $('.vertical-tabs fieldset.fieldset').addClass('default-fallback');

    // Add a new ID to each fieldset.
    $('.group-wrapper .horizontal-tabs-panes > fieldset', context).once('group-wrapper-panes-processed', function() {
      // Tats bad, but we have to keep the actual id to prevent layouts to break.
      var fieldgroupID = 'field_group-' + $(this).attr('id');
      $(this).attr('id', fieldgroupID);
    });
    // Set the hash in url to remember last userselection.
    $('.group-wrapper ul li').once('group-wrapper-ul-processed', function() {
      var fieldGroupNavigationListIndex = $(this).index();
      $(this).children('a').click(function() {
        var fieldset = $('.group-wrapper fieldset').get(fieldGroupNavigationListIndex);
        // Grab the first id, holding the wanted hashurl.
        var hashUrl = $(fieldset).attr('id').replace(/^field_group-/, '').split(' ')[0];
        window.location.hash = hashUrl;
      });
    });

  }
};

})(jQuery);
;
(function ($) {
    Drupal.behaviors.block_content = {
        attach: function (context, settings) {
            var $generalBlock = $('#block-block-donate-block-donate-general');
            var $diseaseSpecificBlock = $('div#block-block-donate-block-donate');
            var $blockContext = $generalBlock.add($diseaseSpecificBlock);

            var promoCodes = {
              9537: 2004,   // Alzheimer's
              10012: 2003,  // Macular
              10013: 2002   // Glaucoma
            };

          /**
           * Update the URL with the new amount being donated.
           *
           * Needed for: both blocks.
           */
            var setURLAmount = function(amount) {
                $('a#donate-link', $blockContext).attr('href', function(i,a){
                    return a.replace(/(donationAmount=)[0-9]*$/, 'donationAmount=' + amount);
                });
            };

          /**
           * Update the donationFrequency parameter in the URL.
           *
           * Needed for: disease-specific block only.
           */
            var setURLFrequency = function(frequency) {
                $('a#donate-link', $diseaseSpecificBlock).attr('href', function(i,a) {
                    return a.replace(/(donationFrequency=)[0-9]?/, 'donationFrequency=' + frequency);
                });
            };

          /**
           * Update the tsid parameter in the URL.
           *
           * Needed for: general block only.
           */
            var setURLDisease = function(disease) {
                $('a#donate-link', $generalBlock).attr('href', function(i,a) {
                    return a.replace(/(tsid=)[0-9]+/, 'tsid=' + disease);
                });
            };

          /**
           * Update the amount displayed in the Donate button.
           *
           * Needed for: disease-specific block only.
           */
            var updateButtonAmount = function(amount) {
                $('a#donate-link', $diseaseSpecificBlock).prop('innerText', function(i, a) {
                    return a.replace(/(\$[0-9]*)/, '$$' + amount);
                });
            };

          /**
           * Update the frequency displayed in the Donate button.
           *
           * Needed for: disease-specific block only.
           */
            var updateButtonFrequency = function(frequency) {
                var frequencyText = frequency === '4' ? 'Monthly' : '';
                $('a#donate-link', $diseaseSpecificBlock).prop('innerText', function(i,a) {
                    return a.replace(/(\$[0-9]+)(.*)/, '$1 ' + frequencyText);
                });
            };

          /**
           * Update the promo code when the disease changes.
           *
           * Needed for: general block only.
           */
            var setURLPromoCode = function(disease) {
              $('a#donate-link', $generalBlock).attr('href', function(i,a) {
                return a.replace(/(promo=)[0-9]+/, 'promo=' + promoCodes[disease]);
              });
            };

          /**
           * Update donation amounts when the frequency changes.
           */
            var updateDonationAmountsByFrequency = function(frequency) {
                var idOfDivToShow = frequency === '4' ? '#amounts-monthly' : '#amounts-once';
                var idOfDivToHide = frequency === '4' ? '#amounts-once' : '#amounts-monthly';
                var defaultAmount = frequency === '4' ? '50' : '250';
                var $divToShow = $(idOfDivToShow);
                var $divToHide = $(idOfDivToHide);

                // Show the div that matched the amounts for the current frequency.
                $divToShow.show();

                // Hide the other div and clear out any checked amounts.
                $divToHide.hide();
                $divToHide.find('input:checked').prop('checked', false);
                $divToHide.find('label.selected').removeClass('selected');
                var $amountOther = $divToHide.find('#amount-other');
                if ($amountOther.length) {
                  $amountOther.val('');
                }
                var $amountOtherMonthly = $divToHide.find('#amount-m-other');
                if ($amountOtherMonthly.length) {
                  $amountOtherMonthly.val('');
                }

                // Update checked amounts.
                $divToShow.find('label.selected').removeClass('selected');
                $divToShow.find('#amount-' + defaultAmount).prop('checked', true);
                $divToShow.find('label[for="amount-' + defaultAmount + '"]').addClass('selected');
                updateButtonAmount(defaultAmount);
                setURLAmount(defaultAmount);
            };

            // Get the current donation amount.
            $('input[name="amount"]', $blockContext).prop('checked', false);

            // Update the URL and (for disease-specific blocks) button with the
            // new donation amount.
            $('input[name="amount"][type="radio"]', $blockContext).on('click', function() {
                $('label', $('#amounts-once, #amounts-monthly')).removeClass('selected');
                $('label[for="' + $(this).attr('id') + '"]', $blockContext).addClass('selected');
                var amount = $(this).val();
                setURLAmount(amount);
                updateButtonAmount(amount);
                $('input[name="amount"][type="text"]', $blockContext).val('');
            });

            // Also handle custom donation amounts on both blocks.
            $('input[name="amount"][type="text"]', $blockContext).on('keyup', function() {
                $('label', $('#amounts-once, #amounts-monthly')).removeClass('selected');
                var amount = $(this).val();
                if(amount !== '') {
                    $('input[name="amount"][type="radio"]', $blockContext).prop('checked', false);
                    setURLAmount(amount);
                    updateButtonAmount(amount);
                }
            });

            // Frequency is only relevant on the disease-specific blocks.
            $('input[name="donationFrequency"]', $diseaseSpecificBlock).on('click', function() {
                $('#frequency label', $diseaseSpecificBlock).removeClass('selected');
                $('label[for="' + $(this).attr('id') + '"]', $diseaseSpecificBlock).addClass('selected');
                var frequency = $(this).val();
                setURLFrequency(frequency);
                updateButtonFrequency(frequency);

                // Show / hide amounts based on the frequency.
                updateDonationAmountsByFrequency(frequency);
            });

            // We only need to set the disease and related promo code for the
            // general (non-disease-specific) block.
            $('input[name="disease"]', $generalBlock).on('click', function() {
              $('#disease label', $generalBlock).removeClass('selected');
              $('label[for="' + $(this).attr('id') + '"]', $generalBlock).addClass('selected');
              var disease = $(this).val();
              setURLDisease(disease);
              setURLPromoCode(disease);
            });
        }
    };
}(jQuery));
;
