'use strict';
$(function() {

	// logging interactions
	(function() {
		try {
			// log page view
			rhiLog
				.fire("115","Trigger1",null,true)
				.init();
			// bind to MPF to listen to search in video event
			RAMP.Widgets.get("metaplayer",function(mpf) {
				mpf.search.listen("results",function(data) {
					RHIData.ovpQuery = encodeURIComponent(data.query);
					RHIData.resultsFound = data.data.results.length;
					rhiLog
						.fire("113","Trigger3",null,true)
						.init();
				});
			});
		} catch(e) {};
	})();

    // check to look for query params
    function getQueryVariable (variable) {
        // grab any queries
        var query = window.location.search.substring(1);
        // split up the &
        var vars = query.split('&');
        // for i and less than length of vars, break up the = and return it in an array
        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split('=');
            if (decodeURIComponent(pair[0]) == variable) {
                return decodeURIComponent(pair[1]);
            } // end if
        } // end for
    } // end getQueryVariable()



    /************************
    VIDEO RIGHT FRAME
    ************************/
    $('ul#rhiVideoTabs li.rhi-tab').on('click', function(e) {
        e.preventDefault();
        // remove active tab
        $(this).siblings('.rhi-active').removeClass('rhi-active');
        // hide 
        $('.rhi-video-tab-content li.rhi-active').removeClass('rhi-active');
        // add new active class to clicked tab
        $(this).addClass('rhi-active');
        // show content li with index of active tab
        $('.rhi-video-tab-content li').eq($(this).index()).addClass('rhi-active');
    }); // end on



    /************************
    MODAL - VARIABLES
    ************************/
    // stores modal body
    var $modal = $('#rhiModal');
    // stores data-type of modal
    var $modalSlide = $('#rhiModal .rhi-slide');
    // stores button to close modal
    var $close = $('#rhiClose');
    // stores dark background
    var $mask = $('.rhi-overlay');



    /************************
    MODAL - FUNCTIONS
    ************************/
    // opens modal
    function openModal(modal, context) {
        // open desired content based on data type of anchor
        
        if (context === 'rhi-mail') {
            $('#rhiModal').addClass('rhi-mail');
        } // end if

        $(modal).find('.rhi-slide' + '.' + context).show();
        // show mask
        $mask.fadeIn();
        // show modal
        $(modal).fadeIn().addClass('visible');

        if (context === 'rhi-mail') {
            $(modal).addClass('rhi-mail');
        }

        // unchecks all checkbox's
        $('input[type="checkbox"], input[type="radio"]').prop('checked', false);
        // if no checkboxes are checked submit button becomes disabled and lightgray
        $('input[type="submit"]').css('background-color', 'lightgray');
        // disable button
        $('input[type="submit"]').prop('disabled', true);
        // disable checkboxes
        $('input[type="checkbox"]').prop('disabled', false);

    } // end openModal


    // closes modal
    function closeModal() {
        // hide any slides that may be visible
        $modal.find($modalSlide).hide();
        // remove mail class if it exists
        $modal.removeClass('rhi-mail');
        // hide modal
        $modal.hide().removeClass('visible').removeClass('rhi-mail');

        // clear/reset all inputs
        $('input[type="text"], input[type="email"]').each(function() {
            if ($('input[type="email"]#rhiText_email')) {
                $(this).css('border', '1px solid #999');
            }
            else {
                $(this).val('');
                $(this).css('border', '1px solid #999');
            }
        }); // end each

        // hide mask
        $mask.hide();
    } // end closeModal



    /************************
    MODAL - EVENT LISTENERS
    ************************/
    // Tab Utility Click - triggers modal
    $('ul#rhiVideoTabs li.rhi-utility').on('click', 'a', function(e) {
        // prevents default anchor behavior
        e.preventDefault();
        // open modal, with specific slide we want to show
        openModal($('#rhiModal'), $(this).data('rhitype'));
    }); // end on


    // modal close click, closes modal
    $close.on('click', function(e) {
        // prevents default anchor behavior
        e.preventDefault();
        // close modal
        closeModal();
    }); // end on


    // press escape while modal is open, closes modal
    $(document).on('keydown', function(e) {
        // if keycode is 27, fire close modal func
        if(e.which == 27 && $modal.hasClass('visible')) {
            // close modal
            closeModal();
        } // end if
    }); // end on


    // click on mask closes modal
    $mask.on('click', function(e) {
        // close modal
        closeModal();
    }); // end on
    
    // When you click on submit, validate input fields
    $('#rhiModal input[type=submit]').on('click', function(e) {
        // prevents default behavior
        e.preventDefault();
        var $submitBtn = $(this);
        var $slideType = $(this).data('slide');
        // example: 'rhi-mail' -> 'mail'
        var mode = $slideType.split('rhi-');
        // after click, dim button to show activity
        $('.' + $slideType).find('input[type=submit]').css('opacity', '0.3');

        // if mode doesn't equal email, validate checkboxes and send it off, 
        // we know something is checked because the button become enabled
        if (mode[1] != 'mail') {
            // validate print/save
            validateOther($submitBtn, $slideType, mode[1]);
        } // end if
        else {
            // validate email
            validateEmail($submitBtn, $slideType, mode[1]);
        } // end else

    }); // end on

    $('input[type="submit"]').on('change', function(e) {
        e.preventDefault();
        if ($(this).prop('disabled')) {
            $(this).attr('aria-disabled', true);
        } // end if
        else {
            $(this).attr('aria-disabled', false);
        } // end else
    }); // end on

    $('input').not('input[type="submit"]').on('change keyup', function() {
		var enable = function() {
			$('input[type="submit"]')
				.css('background-color', 'orange')
				.prop('disabled', false);
		},
		disable = function() {
			$('input[type="submit"]')
				.css('background-color', 'lightgray')
				.prop('disabled', true);
		},
		mode = $("input.rhiSubmit","div.rhi-slide:visible")
				.data("slide")
				.replace(/rhi-/i,"");
		
		switch (mode) {
			case "mail":
				if ($('input[type="checkbox"]:checked').length > 0
                    && $('#rhiText_name').val().length > 0
                    && $('#rhiText_email').val().length > 0
                    && $('#rhiText_send').val().length > 0
                    && $('input[type="radio"]:checked').length > 0
                    ) {
						enable();
				} // end if
                else {
					disable();
				}; // end else
				break;
			default:
				if ($('input[type="checkbox"]:checked').length > 0) {
					enable();
				} // end if
                else {
					disable();
				}; // end else
				break;
		}; // end switch
    }); // end on



    /************************
    CHECKBOX ALL/FUNC
    ************************/
    // if the "All" checkbox is checked all sibling checkboxes are checked as well and become disabled
    $("input[id^=rhiAll]").on("change", function() {
        $("input[type=checkbox]").prop("checked", $(this).is(":checked"));
        $('input[type="checkbox"]').not("input[id^=rhiAll]").prop('disabled', true);
    }); // end on
    
    // if atleast one checkbox is checked the submit button becomes clickable and orange.
    $('input[type="checkbox"]').on('change', function(){
        // on change, if the checked length is zero, disable button.
        if ($('input[type="checkbox"]:checked').length > 0) {
            // Making button Orange, Showing Active State
            $('input[type="submit"]').not('.rhi-mail input[type="submit"]').css('background-color', 'orange');
            // enable button
            $('input[type="submit"]').not('.rhi-mail input[type="submit"]').prop('disabled', false);
        } // end if
        else {
            // if no checkboxes are checked submit button becomes disabled and lightgray
            $('input[type="submit"]').css('background-color', 'lightgray');
            // disable button
            $('input[type="submit"]').prop('disabled', true);
            // disable checkboxes
            $('input[type="checkbox"]').prop('disabled', false);
        } // end else
    }); // end on 

	
	
    /************************
    VALIDATION - VARIABLES
    ************************/
    // RHI Token
    var token = $('#RHI-post-tkn').val();

	// object for retention of POST args
	var postObj = {
		print : {},
		save : {},
		mail : {}
	};


    /************************
    VALIDATION - FUNCTIONS
    ************************/
    // validate print/save
    function validateOther(submitBtn, slideType, mode){
        // submit button clicked
        var $submitBtn = submitBtn;
        // slide type
        var slideType = '.' + slideType;
        // Video ID
        var videoId = $('div.rhi-video div').data('ramp-item-id');     
        // which mode will we use
        var mode = mode;

        // sends POST depending on the modal (print/save)
        if ($submitBtn.parent().hasClass('rhi-print')) {
            // build object for print, checkboxes are unchecked (false) by default
            postObj.print = {
                "RHIToken": token,
                "id" : videoId,
                "mode" : mode,              
                "rhicite_print" : "false",
                "rhidetails_print" : "false",
                "rhiscript_print" : "false",
                "rhishotlist_print" : "false",
                "rhistoryline_print" : "false" 
            } // end postObj.print

            // conditional statements to check to see if checkbox is checked
			// first object prop tells logging that "all" has been selected
            if ( $('#rhiAll_print').prop('checked') ) {
                postObj.print.rhiall = "true";
                postObj.print.rhidetails_print = "true";
                postObj.print.rhiscript_print = "true";
                postObj.print.rhistoryline_print = "true";
                postObj.print.rhishotlist_print = "true";
                postObj.print.rhicite_print = "true";
            } // end if

            // if "All" not checked check every checkbox to see if they were individually checked
            if ( $('#rhiDetails_print').prop('checked') ) {
                postObj.print.rhidetails_print = "true";
            } // end if
            if ( $('#rhiScript_print').prop('checked') ) {
                postObj.print.rhiscript_print = "true";
            } // end if
            if ( $('#rhiStoryLine_print').prop('checked') ) {
                postObj.print.rhistoryline_print = "true";
            } // end if
            if ( $('#rhiShotList_print').prop('checked') ) {
                postObj.print.rhishotlist_print = "true";
            } // end if
            if ( $('#rhiCite_print').prop('checked') ) {
                postObj.print.rhicite_print = "true";
            } // end if

            // POST print
            goPost(slideType, postObj.print);
        }
        else {
            // build object for save, checkboxes are unchecked (false) by default
            postObj.save = {
                "RHIToken": token,
                "id" : videoId,
                "mode" : mode,              
                "rhicite_save" : "false",
                "rhidetails_save" : "false",
                "rhiscript_save" : "false",
                "rhishotlist_save" : "false",
                "rhistoryline_save" : "false"    
            } // end postObj.save

            // conditional statements to check to see if checkbox is checked
			// first object prop tells logging that "all" has been selected			
            if ( $('#rhiAll_save').prop('checked') ) {
                postObj.save.rhiall = "true";
                postObj.save.rhidetails_save = "true";
                postObj.save.rhiscript_save = "true";
                postObj.save.rhistoryline_save = "true";
                postObj.save.rhishotlist_save = "true";
                postObj.save.rhicite_save = "true";
            } // end if

            // if "All" not checked check every checkbox to see if they were individually checked
            if ( $('#rhiDetails_save').prop('checked') ) {
                postObj.save.rhidetails_save = "true";
            } // end if
            if ( $('#rhiScript_save').prop('checked') ) {
                postObj.save.rhiscript_save = "true";
            } // end if
            if ( $('#rhiStoryLine_save').prop('checked') ) {
                postObj.save.rhistoryline_save = "true";
            } // end if
            if ( $('#rhiShotList_save').prop('checked') ) {
                postObj.save.rhishotlist_save = "true";
            } // end if
            if ( $('#rhiCite_save').prop('checked') ) {
                postObj.save.rhicite_save = "true";
            } // end if

            // POST save
            goPost(slideType, postObj.save);
        } // end else
        
    } // end validateOther


    // function to validate, pass in submit button, to check form inputs within that slide
    function validateEmail(submitBtn, slideType, mode){
        // submit button clicked
        var $submitBtn = submitBtn;
        // slide type
        var slideType = '.' + slideType;
        // Video ID
        var videoId = $('div.rhi-video div').data('ramp-item-id');     
        // which mode will we use
        var mode = mode;
        // which slide is open, pull data attribute to check
        var $slide = $('#rhiModal .rhi-slide' + '.' + $submitBtn.data('slide'));

        // find input that isn't submit within slide
        var $checkBoxInput = $slide.find('input[type=checkbox]');
        var $checkTextInput = $slide.find('input[type=text], input[type=email]');

        // call checkBoxValidate function
        checkBoxValidate($checkBoxInput, slideType);

        // validates the list of checkboxes
        function checkBoxValidate (checkBoxes, slideType) {
            var $checkBoxes = checkBoxes;
            var checkArray = [];
            var slideType = slideType;

            // checks each checkbox, if it's checked it adds a 'checked' item to an array
            $checkBoxes.each(function(){
                if ($(this).prop('checked')) {
                    checkArray.push('checked');
                } // end if
            }); // end each
            // if the length of the array is greater than 0 proceed to validate the text input
            if( checkArray.length > 0 ){
                inputTextValidate($checkTextInput, slideType);
            } // end if
            else {
                notValid(slideType);
            } // end else

        } // end checkBoxValidate

        // validates the textboxes
        function inputTextValidate(inputText, slideType) {

            var $slideType = $(slideType);
            var $checkTextInput = inputText;
            var $radios = $(slideType).find('input[type=radio]');


            $checkTextInput.each(function() {
                // if the text input does not have a value, warn the user
                if(!$(this).val()){
                    notValid($slideType);    
                } // end if
            }); // end each

            // call radioValidate function
            radioValidate($radios, $slideType);
        } // end inputTextValidate
        
        // validates the radio inputs
        function radioValidate(radios, slideType) {
            var $slideType = slideType;
            var radios = radios;
            var radioCheckArray = [];
            var $textArea = $('#rhiTextArea');

            // checks each radio input
            $(radios).each(function() {
                // if the radio button is checked
                if( $(this).prop('checked') ){
                    // add a 'valid' item to the array
                    radioCheckArray.push('valid');
                } // end if
            }); // end radioValidate

            // checks if the length of the array is greater than 0
            if (radioCheckArray.length > 0 ){
                // if it is proceed to validate the textarea
                textAreaValidate($textArea, $slideType)
            } // end if
            else {
                // if not warn the user
                notValid($slideType);
            } // end else
        } // end radioValidate

        // validate the textarea input
        function textAreaValidate(textArea, slideType) {
            var $textArea = $('#rhiTextArea');
            var $slideType = slideType;

            // if the textarea has no user input
            // if (!$textArea.val()) {
                // run the notValid function
                // notValid($slideType);   
            // } // end if
            // else {
                // call buildPost function
                buildPost($slideType)
            // } // end else
        } // end textAreaValidate

        function notValid (slideType) {
            var $slideType = $(slideType);
            $slideType
				.find('input')
				.not('input[type=submit]')
				.fadeOut(200)
				.fadeIn()
				.addClass('required');         
        }  // end not valid

        // if valid build post
        function buildPost(slideType) {
            var $slideType = slideType;
            
            // build object for email, checkboxes are unchecked (false) by default
            postObj.mail = {
                "RHIToken": token,
                "id" : videoId,
                "mode" : mode,                
                "rhicite_email" : "false",
                "rhidetails_email" : "false",
                "rhiscript_email" : "false",
                "rhishotlist_email" : "false",
                "rhistoryline_email" : "false",
                "rhitext_name" : "",
                "rhitext_email" : "",
                "rhitext_send" : "",
                "rhiradio_html" : "false",
                "rhiradio_plain" : "false",
                "rhitextarea" : ""              
            } // end postObj.mail
            
            // conditional statements to check to see if the "All" checkbox is checked
			// first object prop tells logging that "all" has been selected
            if ( $('#rhiAll_email').prop('checked') ) {
                postObj.mail.rhiall = "true";
                postObj.mail.rhidetails_email = "true";
                postObj.mail.rhiscript_email = "true";
                postObj.mail.rhistoryline_email = "true";
                postObj.mail.rhishotlist_email = "true";
                postObj.mail.rhicite_email = "true";
            } // end if

            // if "All" not checked check every checkbox to see if they were individually checked
            if ( $('#rhiDetails_email').prop('checked') ) {
                postObj.mail.rhidetails_email = "true";
            } // end if
            if ( $('#rhiScript_email').prop('checked') ) {
                postObj.mail.rhiscript_email = "true";
            } // end if
            if ( $('#rhiStoryLine_email').prop('checked') ) {
                postObj.mail.rhistoryline_email = "true";
            } // end if
            if ( $('#rhiShotList_email').prop('checked') ) {
                postObj.mail.rhishotlist_email = "true";
            } // end if
            if ( $('#rhiShotList_email').prop('checked') ) {
                postObj.mail.rhicite_email = "true";
            } // end if

            postObj.mail.rhitext_name = $('#rhiText_name').val();
            postObj.mail.rhitext_email = $('#rhiText_email').val();
            postObj.mail.rhitext_send = $('#rhiText_send').val();

            if ($('#rhiRadio_html').is(':checked')) {
                postObj.mail.rhiradio_html = "true";
            } // end if
            else {
                postObj.mail.rhiradio_plain = "true";
            } // end else

            postObj.mail.rhitextarea = $('#rhiTextArea').val();

            // POST the data on the email modal
            goPost($slideType, postObj.mail);
        } // end buildPost
    } // end validate

	// test validation objects for radio button selections
	function getShareDetails(modalType) {
		var detailsObj = postObj[modalType],
			logStr = "",
			bool = false,
			testKeys = function(modalType) {
				$.each(detailsObj,function(objKey,objVal) {
					if (new RegExp(modalType,"i").test(objKey) && objVal === "true") {
						bool = true;
					};
				});
				return bool;
			};
			
		if (testKeys("all") || testKeys("details")) {
			logStr = "DetailedCitationAndAbstract"
		};
		if ((!(testKeys("all") || testKeys("details"))) && testKeys("cite")) {
			logStr = "BriefCitation";
		};
		if (! (testKeys("all") || testKeys("details") || testKeys("cite"))) {
			logStr = "NoCitation";
		};
		return logStr;
	};
	
    // if success, POST or request endpoint URI
    function goPost(slideType, object) {
        var slideType = slideType,
			postObj = object,
			mode = postObj.mode,
			cgiList = $.param(postObj) + "&lang=" + RHIData.lang,
			doAjax = function(doneCb,failCb) {
                // POST data
				$.ajax({
					type : "POST",
					url : RHIData.widgetUri,
					data : cgiList
				}) // end ajax
                // if success
				.done(function(data) {
					if (doneCb instanceof Function) {
						doneCb(data);
					} // end if
				}) // end done
                // if fails
				.fail(function(data) {
					if (failCb instanceof Function) {
						failCb(data);
					} // end if
				}); // end fail
			}; // end doAjax
		
		// clear previous share mode
		RHIData.shareMode = "";
		
		// clear previous shared details
		RHIData.shareDetails = "";

		// set shared details for 115:P10
		RHIData.shareDetails = getShareDetails(mode);

		switch (mode) {
			case "print":
				RHIData.shareMode = "Print";
				doAjax(function(html) {
					if (html) {
						try {
							var w = window.open();
							w.document.open();
							w.document.write(html);
							w.document.close();
							w.focus();
							w.print();
							w.close();
							$('input[type=submit]').css('opacity', '1');
						} catch(e) {};
					};
				},function() {
					$(slideType)
						.find('input[type=submit]')
						.css({'opacity' : '1'});
				});
				// log the interaction
				try {
					rhiLog
						.fire("115","Trigger2",null,true)
						.init();
				} catch(e) {};
				break;
			case "save":
				RHIData.shareMode = "Save";
				window.open(RHIData.widgetUri + "?" + cgiList);
				$('input[type=submit]').css('opacity', '1');
				// log the interaction
				try {
					rhiLog
						.fire("115","Trigger2",null,true)
						.init();
				} catch(e) {};

				break;
			case "mail":
				RHIData.shareMode = "Email";
				doAjax(function() {
					$('input[type=submit]').css('opacity', '1');
                    closeModal();
                },function() {
					$(slideType)
						.find('input[type=submit]')
						.css({'opacity' : '1'});
				});
				// log the interaction
				try {
					rhiLog
						.fire("115","Trigger2",null,true)
						.init();
				} catch(e) {};

				break;
			default: break;
		};
    } // end go Post
	
    
    $('.query-wrapper input').on('input',function(){
        if( $(this).val() !== '' ) {
            $(this).parent().addClass('query-wrapper-active');
        } else {
            $(this).parent().removeClass('query-wrapper-active');
        }
    }).each(function(){
        if( $(this).val() !== '' ) {
            $(this).parent().addClass('query-wrapper-active');
        }
    });
	
	$('.query-wrapper').append('<span class="query-clear"></span>');
	$('.query-wrapper').find('.query-clear').on('click',function(){
		console.log('query-clear click');
		$(this).parent().find('input.query').val('');
		$(this).parent().find('input.query').attr('value','');
		$(this).parent().removeClass('query-wrapper-active');
	});
	
	$('.rhi-search-box-wrapper input[type="submit"]').click(function(e){
		e.preventDefault();
		try {
			rhiLog.fire("113","Trigger1",null,true).init();
		} catch(e) {};
		$(this).parents('form').submit();
	});

	//making ajax request to send log data on winow unload event
 	window.onbeforeunload = RHIWindowUnloadHandler.doAjaxBeforeUnload;
    $(window).unload(RHIWindowUnloadHandler.doAjaxBeforeUnload);

}); // end $(document).ready(function() {});

var RHIWindowUnloadHandler = (function($) {
	var doAjaxBeforeUnloadEnabled = true; 
	return {
		doAjaxBeforeUnload: function(){
			if (!doAjaxBeforeUnloadEnabled) {
		        return;
		    }
		    doAjaxBeforeUnloadEnabled = false;
			try {
				rhiLog._makeRequest();
			} catch(e) {};
		}
	};
})(jQuery);