(function ($, Drupal, window, document, undefined) {

  Drupal.behaviors.ksu_library_zurb = {
    attach: function (context, settings) {
      if (context === document) { // only fires on document load
          if (window.location.hostname === "www-test.library.kent.edu") {
            $('a').each(function() {
              var link = $(this).attr('href');
              if (typeof link !== 'undefined') {
                if (link === 'https://www.library.kent.edu') {
                  $(this).attr('href', '/');
                }
                else {
                  $(this).attr('href', link.replace('https://www.library.kent.edu', ''));
                  $(this).attr('href', link.replace('http://www.library.kent.edu', ''));
                }
              }
            })
          }

          $('.tablesorter .header').on('click', function() {
            if (typeof ga !== "undefined") {
                ga('send', 'event', 'Tablesorter Click', window.location.pathname);
            }
          });

          $('#ul-icons-header a').on('click', function() {
            if (typeof ga !== "undefined" && !$(this).hasClass('goog-te-menu-value')) {
                ga('send', 'event', 'Icon Header Click', $(this).attr('href'));
            }
          });

          $('#apachesolr-panels-search-block').on('submit', function() {
            if (typeof ga !== "undefined") {
              ga('send', 'event', 'KSU Search', $('#edit-apachesolr-panels-search-form').val());
            }
          });
          if ($('.pane-kent-state-blocks-group-primary-menu .pane-content ul').length == 0) {
            $('.pane-kent-state-blocks-group-primary-menu').hide();
          }

          $('.search-button').on('click', function() {
            $('#edit-apachesolr-panels-search-form').focus();
          })
      }
    }
  };

})(jQuery, Drupal, this, this.document);
