var proxy_domain = 'proxy.library.kent.edu';
var proxy_starting_point_url = 'https://' + proxy_domain + '/login?url=';
var proxy_link_query = null;
var browser_host = window.location.hostname
if (browser_host.indexOf('kentlink.kent.edu') >= 0) {
  proxy_link_query = '.briefcitActions a, .tpBibLinks a, #tpBibLinks ul li a';
}
else if (browser_host == 'libguides.library.kent.edu') {
  proxy_link_query = '#s-lg-tabs-container a, #s-lg-side-nav-content a';
}
else if (browser_host == 'libguides.trumbull.kent.edu') {
  proxy_link_query = '#s-lg-guide-main a';
}
else if (browser_host == 'eds.a.ebscohost.com' || browser_host == 'eds.b.ebscohost.com') {
  proxy_link_query = '.record-type.custom-link-item,.record-type.custom-link, #linkOnlineAccess';
}
else if (browser_host == 'www.library.kent.edu') {
  proxy_link_query = '.resourceIndexLink a';
}
else if (browser_host == 'apps.library.kent.edu') {
  proxy_link_query = '#listingInterface a, #detailsInterface a';
}

function prependURL(that) {
  var href = that.attr('href');
  if (href.indexOf(proxy_domain) == -1) {
    that.attr('href', proxy_starting_point_url + href);
    var onclick = that.attr('onclick');
    if (typeof onclick !== 'undefined' && that.attr('onclick').length > 0) {
      that.attr('onclick', onclick.replace("window.open('", "window.open('"+proxy_starting_point_url));
    }
  }
}

function rewriteURL(that) {
  var href = that.attr('href');
  var original_href = href;
  if (href.indexOf(proxy_domain) === -1) {
    if (that.prop('protocol') === 'https:') {
      var hostname = that.prop('hostname').split('.').join('-');
      href = href.replace(that.prop('hostname'), hostname + '.' + proxy_domain);
    }
    else {
      href = href.replace(that.prop('hostname'), that.prop('hostname') + '.' + proxy_domain);
    }
    that.attr('href', href);
    var onclick = that.attr('onclick');
    if (typeof onclick !== 'undefined' && that.attr('onclick').length > 0) {
      that.attr('onclick', onclick.replace(original_href, href));
    }
  }
}

function defer(method) {
    if (window.jQuery)
        method();
    else
        setTimeout(function() { defer(method) }, 50);
}

defer(function () {
  jQuery(document).ready(function() {
    var urls = [];
    if (browser_host.indexOf(proxy_domain) >= 0) {
      jQuery(proxy_link_query).each(function() {
        var onclick = jQuery(this).attr('onclick');
        if (typeof onclick !== 'undefined' && onclick.length > 0) {
          jQuery(this).attr('onclick', "window.open('"+jQuery(this).attr('href')+'")');
        }
      });
    }
    else {
      jQuery(proxy_link_query).each(function() {
        var domain = jQuery(this).prop('hostname');
        var scheme = jQuery(this).prop('protocol');
        if (jQuery(this).prop('port').length && jQuery(this).prop('port') != '80' && jQuery(this).prop('port') != '443') {
          domain += ':' + jQuery(this).prop('port');
        }
        var url = scheme + '//' + domain;
        if (domain !== browser_host && domain.indexOf(proxy_domain) == -1 && jQuery.inArray(url, urls) == -1) {
          if (domain !== 'kentlink.kent.edu' && (browser_host !== 'defunct.libguides.library.kent.edu' || typeof jQuery(this).attr('onclick') === 'undefined')) {
            urls.push(url);
          }
        }
      });
      jQuery.ajax({
        type: 'POST',
        data: 'urls=' + JSON.stringify(urls),
        url: 'https://www.library.kent.edu/kentlink_ezproxy/check.php',
        dataType: 'json',
        success: function(response) {
          jQuery(proxy_link_query).each(function() {
            var domain = jQuery(this).prop('hostname');
            var scheme = jQuery(this).prop('protocol');
            var url = scheme + '//' + domain;
            if (typeof response[url] !== 'undefined') {
              if (response[url] == '1') {
                prependURL(jQuery(this));
              }
              else if (response[url] == '2') {
                rewriteURL(jQuery(this));
              }
            }
          });
        }
      });
    }
  });
});

