(function ($, Drupal, window, document, undefined) {

    //stickynav
    jQuery(function($) {

        var $nav = $('.l-header');
        var $win = $(window);
        var winH = $win.height();   // Get the window height.

        $win.on("scroll", function () {
            if ($(this).scrollTop() > winH && $('#azindex99').is(':empty') ) {
                $nav.addClass("stickymenu");
                $nav.addClass("animated");
                $nav.addClass("slideInDown");
            } else {
                //$nav.removeClass("animated");
                $nav.removeClass("stickymenu");
                $nav.removeClass("slideInDown ");
            }
        }).on("resize", function(){ // If the user resizes the window
            winH = $(this).height(); // you'll need the new height value
        });

    });

    Drupal.behaviors.mobileMenuToggle = {
        attach: function (context, settings) {
            if (context === document) { // only fires on document load
                function closeMiniMenu() {
                    $("body").removeClass("active-mobile-menu");
                    $('a.mobile-button.menu-button').attr('aria-expanded', 'false');
                }
                function openMiniMenu() {
                    $("body").addClass("active-mobile-menu");
                    $('a.mobile-button.menu-button').attr('aria-expanded', 'true');
                }
                $('.block-ksu-custom-blocks-redesign-kent-mobile-menu a.mobile-button.menu-button').on('click', function (e) {
                    e.preventDefault();
                    if ($('body').hasClass('active-mobile-menu')) {
                        closeMiniMenu();

                    } else {
                        openMiniMenu();
                    }
                });
                $('#block-kent-state-blocks-group-megamenu').focusin(function () {
                    openMiniMenu();
                });
                $(".block-ksu-custom-blocks-redesign-utility-nav-links--2 li").last().bind("focusout", function () {
                    closeMiniMenu();
                });
                $(".block-kent-state-blocks-campus-logo a.active").focus(function () {
                    closeMiniMenu();
                });
                $(".block-kent-state-blocks-group-header a.active").focus(function () {
                    closeMiniMenu();
                });
            }
        }
    };


  /**
   * Utility function to clear overlay classes.
   */
  function clearbody() {
    var li = $('ul.megamenu-wrapper li');

    if( $('body').hasClass("not-logged-in") ) {


        $('body').removeClass('body-overlay'); // content overlay
        $('body').removeClass('search-open');
        $('#azindex99').html('');// search
        li.removeClass('open'); // megamenus
        li.find('a.megamenu-title').attr('aria-expanded','false');
        li.find('a.megamenu-title').attr('aria-selected','false');
        li.find('a.megamenu-title').next('.megamenu-container').find('a').each(function(i) {
          $(this).attr('tabindex','-1');
        });
      }
  }

  /**
   * Search form toggle functions.
   */
  Drupal.behaviors.SearchFormToggle = {
      attach: function (context, settings) {
          if (context === document) { // only fires on document load
              // TODO: user hook in preprocess
              var input_search = $('.kent-search-overlay form input.apachesolr-autocomplete');
              var body = $('body');

              // Toggle search visibility.
              $('.l-header a.search-button, .kent-search-overlay a.close-button-overlay').on('click', function (e) {
                  e.preventDefault();
                  if (!body.hasClass('search-open')) {
                      clearbody();

                      body.addClass('body-overlay search-open');

                      input_search.focus();
                      input_search.attr('placeholder', 'Enter Your Search...');
                      input_search.keydown(function () {
                              input_search.blur(function () {
                                 // $(this).val('');
                              });
                          });
                  } else {
                    clearbody();
                  }
              });
          }
      }
  };
  /**
   * MegaMenu toggle and mobile detections.
   */
  Drupal.behaviors.MegaMenuToggles = {
    attach: function (context, settings) {
      if (context === document) { // only fires on document load

        // Grab variables
        var menu_li = $('.kent-rd-megamenu ul.megamenu-wrapper li');
        var menu_link = menu_li.find('a.megamenu-title');
        var close_button = $('.megamenu-wrapper a.close-button-overlay');
        menu_li.removeClass('open'); // Onload remove classes

        // establish bindings to click close / focus out of nav
        close_button.on('click', function (e) {
          e.preventDefault();
          clearbody();
        });

        $('.megamenu-container:last a:last').on('focusout', function (e) {
          e.preventDefault();
          clearbody();
        });

        // On Menu Click
        menu_link.on('click', function (e) {

          /*TO DO, if sticky nav active,



              $('.theme--ksu-kent-zurb').addClass('disabled-scroll');
              megamenu, overflow-y scroll.
              on exit, revert


          */
          if ( Drupal.settings.ajaxPageState.theme == 'ksu_kent_zurb' || $(window).width() <= 1024 ) {
            //for mega menu (not dropdown... aka everything kent campus or mobile / tablet)
              if ($("body").hasClass("section-404-page") ||
                  $("body").hasClass("section-404") ||
                  $("body").hasClass("page-taxonomy") ||
                  $("body").hasClass("page-taxonomy-term") ||
                  $("body").hasClass("page-taxonomy-term-") ||
                  $("body").hasClass("page-search") ||
                  $("body").hasClass("page-search-site") ||
                  $("body").hasClass("page-search-site-")) {
              return true;
              }
            if (!$(this).hasClass('no-children')) {
              e.preventDefault();
            }
            var li = $(this).closest('li');
            if (!li.hasClass('open')) {
              clearbody();
              li.addClass('open');
              li.find('a.megamenu-title').attr('aria-expanded','true');
              li.find('a.megamenu-title').attr('aria-selected','true');
              li.find('a.megamenu-title').next('.megamenu-container').find('a').each(function(i) {
                $(this).attr('tabindex','0');
              });
              $('body').addClass('body-overlay');

            }
            else {
              clearbody();
            }
          }
        });

        // On Menu Focus
        menu_link.on('focus', function (e) {
          // for drop down (not mega menu... aka everything desktop and not kent campus)
          if ( Drupal.settings.ajaxPageState.theme != 'ksu_kent_zurb' && $(window).width() >= 1024 ) {
            var li = $(this).closest('li');
            if (!li.hasClass('open')) {
              clearbody();
              li.addClass('open');
              li.find('a.megamenu-title').attr('aria-expanded','true');
              li.find('a.megamenu-title').attr('aria-selected','true');
              li.find('a.megamenu-title').next('.megamenu-container').find('a').each(function(i) {
                $(this).attr('tabindex','0');
              });
            }
          }
        });
      }
    }
  };

  /**
   * Video overlay toggles.
   */
  Drupal.behaviors.kentVideoModal = {
    attach: function (context, settings) {
      if (context === document) { // only fires on document load

        $('.js-lazyYT').lazyYT('AIzaSyC7GqaHWU6Ca5qgepUe3aDb5i0a4zJ5E5I'); // Lazy load youtube video

        var video_link = $('body a.play-video-modal-js');
        if (video_link.length < 1) {
          return;
        }

        video_link.on('click', function (e) {
          if (!$('body').hasClass('video-overlay')) {
            $('body').addClass('video-overlay');
          }
          e.preventDefault();
        });

        $(".js-lazyYT").click(function(e) {
          e.stopPropagation();
        });
        $('.youtube_video_embed, .youtube_modal a.close').on('click', function (e) {
          $('body').removeClass('video-overlay');
            e.preventDefault();
          // Clear and Reset YouTube
          $('.js-lazyYT').remove('iframe');
          $('.js-lazyYT').lazyYT();
          $('.js-lazyYT').removeClass('lazyYT-video-loaded');
        });

      }
    }
  };

  /**
   * Side Nav functionality.
   */
  Drupal.behaviors.sideNavBuild = {
    attach: function (context, settings) {
jQuery('.pane-kent-state-blocks-group-primary-menu li a[href="' + window.location.pathname + '"]').parent().addClass('current-active-menu-trail');
      $('.pane-kent-state-blocks-group-primary-menu').addClass('show-primary-side-nav');
      return;

      //if current page is a child
      if (last_active_trail.hasClass('leaf')) {
        //find closest parent navigation page
        last_active_trail = last_active_trail.closest('li.active-trail:not(.leaf)');
        //if current page has no parent navigation page
        if( last_active_trail.length == 0 ) {
          //reset to current page
          last_active_trail = $('li.active-trail:last');
          //display current page and siblings
          last_active_trail.addClass("current-active-menu-trail");
          last_active_trail.siblings().addClass("current-active-menu-trail-sibling");
        } else {
          //display the parent and siblings
          last_active_trail.addClass("current-active-menu-trail");
          //move parent to top
          last_active_trail.prependTo(".pane-kent-state-blocks-group-primary-menu > .pane-content > .menu");
        }
      } else {
          last_active_trail = last_active_trail.closest('li.active-trail:not(.leaf)');
          last_active_trail.addClass("current-active-menu-trail");
          //last_active_trail.prependTo(".pane-kent-state-blocks-group-primary-menu > .pane-content > .menu");
      }
    }
  };

  /**
   * Video Background helper.
   */
  Drupal.behaviors.videoBackgroundPane = {
    attach: function (context, settings) {
      if (context === document) { // only fires on document load

        var video_node_wrapper = $('body .video_node_wrapper');
        if (video_node_wrapper.length < 1) {
          return;
        }

        // load after populated.
        $(window).on('load', function () {
          video_node_wrapper.find('.backgr_cover_animated').fadeIn(600);
        });

        var timerEl;
        $(window).on('load resize', function () {
          if (timerEl) {
            clearTimeout(timerEl);
          }
          timerEl = setTimeout(function () {
            if ($(window).width() >= 1024) {
              video_node_wrapper.find('.backgr_cover_animated video').css({
                'min-height': video_node_wrapper.height() + 20,
                'min-width': video_node_wrapper.width() + 20
              });
            }
          }, 100); // this only fires every increment
        });

      }
    }
  };

  /**
   * Quick links mobile accordion functionality.
   */
  Drupal.behaviors.quickLinkMenus = {
    attach: function (context, settings) {
      if (context === document) { // only fires on document load

        var quicklink_el = $('body .kent--quick-links-js');
        if (quicklink_el.length < 1) {
          return;
        }

        quicklink_el.each(function () {
          $(this).wrap("<span class='quicklinks-wrapper-js'></span>");
          $(this).before('<a class="quicklinks-toggle" href="#">Quick links</a>');
        });

        $('.quicklinks-wrapper-js a.quicklinks-toggle').on('click', function (e) {
          e.preventDefault();
          if (!$(this).hasClass('open')) {
            $(this).addClass('open');
            $(this).siblings(".kent--quick-links-js").slideDown('fast');
          }
          else {
            $(this).removeClass('open');
            $(this).siblings(".kent--quick-links-js").slideUp('fast');
          }
        });

      }
    }
  };

  /**
   * Megamenu admin toggles.
   */
  Drupal.behaviors.megamenuAdminToggle = {
    attach: function (context, settings) {
      if (context === document) { // only fires on document load

        var arrow_toggle = $('.admission_top_markup .arrow-toggle');
        var arrow_toggle_container = arrow_toggle.closest('.apply_el');

        if (arrow_toggle.length < 1) {
          return;
        }
        arrow_toggle.on('click', function (e) {
          e.preventDefault();
          if (!arrow_toggle_container.hasClass('open')) {
            arrow_toggle_container.addClass('open');
          }
          else {
            arrow_toggle_container.removeClass('open');
            arrow_toggle_container.closest('a').attr('aria-expanded','false');
            arrow_toggle_container.closest('a').attr('aria-selected','false');

          }
        });

      }
    }
  };

  Drupal.behaviors.azindex = {
      attach: function (context, settings) {
          if (context === document) {
              $('header li.ui-state-default a').click(function () {
                  $('header ul.ui-tabs-nav').find('a').each(function(i) {
                      $(this).attr('tabindex','-1');
                  });
                  $(this).attr('tabindex','0');
                  $(this).parent().addClass('ui-state-active');
                  var url = $(this).attr('href');
                  var link = this + '?az=';

                  $('#azindex99').html('<div role="alert" aria-label="loading selection - please wait" class="loader">Loading... please wait</div>');
                  $.ajax({
                      url: link,
                      cache: true,
                      success: function (data) {
                          var insider5 = $($($.parseHTML(data)).find("div.field-name-body")).html();
                          var insider6 = '<div class="pane-content"><span role="alert" aria-live="assertive" style="position:absolute;left:-10000000px;text-indent: -10000px;" aria-label="loading complete">loading complete you can now tab through your selection</span></span> <div class="field field-name-body field-type-text-with-summary field-label-hidden">' + insider5 + '</div></div>';
                          $('#azindex99').html(insider6);
                      }
                  });
                  return false;
              });
              $('header li.ui-state-default a').focus(function () {
                   $('header ul.ui-tabs-nav').find('a').each(function(i) {
                       $(this).attr('tabindex','0');
                    });
                   $(this).attr('tabindex','0');
                  $(this).parent().removeClass('ui-state-active');

              });
          }
      }
  };
$( document ).ready(function() {



    /* TAB NAVIGATION ANIMATION */

    //Unbind jquery ui tab default click binding
     $("main .ui-tabs-nav li a").unbind('click');

     var $prev_tab;
     var $next_tab;

     $('main .ui-tabs-nav li a').click(function( e ) {
        e.preventDefault();

         //get prev active tab
         $prev_tab = $('main .ui-tabs-nav > li.ui-state-active');
         //get next active tab
         $next_tab = $(this).parent();

        // Find direction
        if ( $prev_tab.attr('aria-labelledby').substring(6)-2 > $next_tab.attr('aria-labelledby').substring(6)-2 ) {
            // out to the right, in from left to right
            //alert('moving left');
            //hide prev tab
          $prev_tab.removeClass('ui-state-active');
          $('#'+$prev_tab.attr('aria-controls')).hide("slide", { direction: "right" }, 400, function( ) {

            //show new tab
            $next_tab.addClass('ui-state-active');
            $('#'+$next_tab.attr('aria-controls')).show("slide", { direction: "left" }, 400);


          }).delay(1000);

        } else {
            // out to the left, in from right to left
            //alert('moving right');
            //hide prev tab
          $prev_tab.removeClass('ui-state-active');
          $('#'+$prev_tab.attr('aria-controls')).hide("slide", { direction: "left" }, 400, function( ) {

            //show new tab
            $next_tab.addClass('ui-state-active');
            $('#'+$next_tab.attr('aria-controls')).show("slide", { direction: "right" }, 400);

          }).delay(1000);

        }


     });

     // override foundation tabs
     $('.tabs-nav a').click(function( e ) {
        e.preventDefault();


         //get prev active tab
         $prev_tab = $('.tabs-nav dd.active');
         $prev_tab_id = $('.tabs-nav dd.active a').attr('href');

         //get next active tab
         $next_tab = $(this).parent();
         $next_tab_id = $(this).attr('href');


        // Find direction
        if ( $( ".tabs-nav dd" ).index( $prev_tab ) > $( ".tabs-nav dd" ).index( $next_tab ) ) {
            // out to the right, in from left to right
            //alert('moving left');
            //hide prev tab
            $prev_tab.removeClass('active');
            $('.tabs-content '+$prev_tab_id).hide("slide", { direction: "right" }, 400, function( ) {

            //show new tab
            $next_tab.addClass('active');
            $('.tabs-content '+$next_tab_id).show("slide", { direction: "left" }, 400);


          }).delay(1000);

        } else {
            // out to the left, in from right to left
            //alert('moving right');
            //hide prev tab
            $prev_tab.removeClass('active');
            $('.tabs-content '+$prev_tab_id).hide("slide", { direction: "left" }, 400, function( ) {

            //show new tab
            $next_tab.addClass('active');
            $('.tabs-content '+$next_tab_id).show("slide", { direction: "right" }, 400);


          }).delay(1000);

        }

     });


//Run foundation
$( document ).ready(function() {
    $(this).foundation();
    $('div.field-name-body').has('table').addClass('horizScroll');
});


});


})(jQuery, Drupal, this, this.document);
