(function (window, document, undefined) {
    jQuery.cookie = function (key, value, options) {
	
		// key and at least value given, set cookie...
        if (arguments.length > 1 && String(value) !== "[object Object]") {
            options = jQuery.extend({}, options);

            if (value === null || value === undefined) {
                options.expires = -1;
            }

            if (typeof options.expires === 'number') {
                var days = options.expires,
                    t = options.expires = new Date();
                t.setDate(t.getDate() + days);
            }

            value = String(value);

            return (document.cookie = [
            encodeURIComponent(key), '=',
            options.raw ? value : encodeURIComponent(value),
            options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires //attribute, max-age is not supported by IE
            options.path ? '; path=' + options.path : '',
            options.domain ? '; domain=' + options.domain : '',
            options.secure ? '; secure' : ''].join(''));
        }

        // key and possibly options given, get cookie...
        options = value || {};
        var result, decode = options.raw ? function (s) {
                return s;
            } : decodeURIComponent;
        return (result = new RegExp('(?:^|; )' + encodeURIComponent(key) + '=([^;]*)').exec(document.cookie)) ? decode(result[1]) : null;
    };

    window.PAIDWALL2 = (function () {
        var paidContentUrl = $('meta[name = "turl"]').attr('content') || ($('meta[name = "paid-content-url"]').attr('content') ? 'http://' + document.domain + $('meta[name = "paid-content-url"]').attr('content') : undefined),
            turl = paidContentUrl,
            rurl = $('meta[name = "rurl"]').attr('content') || document.location.href + '.pw-modal',
            hasPaidContentUrl = paidContentUrl !== undefined,
            TimeCookie = $.cookie('TimeSub') || null,
            isLoggedIn = TimeCookie !== null,
            TimeOpenHouseCookie = $.cookie('TimeCpgn') || null,
            isTOC = $('meta[name = "magazine"]').attr('content') === 'toc',
            hasPromoOptIn = TimeOpenHouseCookie !== null,
            isOlderFF = $.browser.mozilla && parseFloat($.browser.version) < 4,
            errorCode = $.cookie('time-status') || null,
            isStage = !! document.domain.match('pw-stage.time.com'),
            logoutUrl = isStage ? 'https://qa-auth.time.com/logout.php' : 'https://auth.time.com/logout.php',
            allAccessDiv = '<div id="allAccess"><p class="constrain">You are logged into TIME magazine <em>ALL</em> ACCESS <a href="' + logoutUrl + '?turl=' + window.location + '">Log Out</a></p></div>',
            allAccessPromoDiv = '<div id="enjoyAllAccess"><p>Enjoy your <em>ALL</em> ACCESS Preview</p></div>',
            $PAIDWALL2 = $('.pw-modal'),
            $subscribeNowTout,
            $rememberToolTip,
            $html = $('html'),
            setTeaserCookie = function () {
                $.cookie('lastTeaserPage', $('meta[name = "rurl"]').attr('content'), { expires: 1, path: '/', domain: '.time.com' });
            },
			badUser = 'Please enter a valid username or Email.',
			badPassword= 'Please enter your password.',
			noCookies= 'You must have cookies enabled to sign in',
            hasPlaceholder = typeof (document.createElement('input').placeholder) !== 'undefined',
            deleteErrorCookie = function () {
                $.cookie('time-status', null, {
                    path: '/',
                    domain: '.time.com'
                });
            },
            gotToPaidContent = function () {
                window.location = paidContentUrl;
            },
            indicateError = function () {
                if (!errorCode) {
                    return false;
                }
				
                var errCode = parseInt(errorCode.match(/\d+/)[0], 10),
                    myClass = 'PAIDWALL2-error';

                switch (errCode) {
                case 1:
					showError('Your subscription has expired. Please <a href="https://subscription.time.com/storefront/subscribe-to-time/link/1004496.html" target="_blank">click here</a> to gain access again.');
                    break;
                case 2:
					showError('Email address or Password is incorrect');
                    break;
                case 3:
					showError('A required form parameter was missing');
                    break;
                case 4:
					showError('The System is currently down. Please try again in a few minutes');
                    break;
                default:
					showError('Email address or Password is incorrect');
                }

                $html.addClass(myClass);
            },
            indicateHasJS = function () {
                $html.addClass('has-js');
            },
            indicateNoPlaceholder = function () {
				if(!hasPlaceholder) {
					$html.addClass('no-placeholder');
				}
            },
            clearSystemErrorEvent = function () {
                if (!errorCode) {
                    return false;
                }
                $('.PAIDWALL2-error .pw-modal .login input').live('click', function () {
                    $PAIDWALL2 = $PAIDWALL2 || $(this).parents('.pw-modal');
                    $PAIDWALL2.find('.message .error').hide();
                    $('.pw-modal').removeClass('error');
                });

            },
            fakePlaceHolders = function () {
				
				if(!hasPlaceholder) {
					positionLabels();
					
					$(window).resize(function() {
						positionLabels();
					});
					
					var $inputs = $('input','.pw-modal'),
						$labels = $('label');
					
					//Hide label when input is already populated
					$inputs.each(function() {
						var t = $(this);
						if (t.val() !== '') {
							t.prev('label').hide();
						}
					});
					
					$inputs.live('blur', function() {
						var n = $(this).attr('name');
						if ($(this).val() === '') {
							$('label[for =' + n + ']').show();
							positionLabels();
						}
					});
					
					$labels.live('click focus', function () {
						$(this).hide();
					});
					
					$inputs.live('focus', function () {
						$(this).prev('label').hide();
					});
				}
            },
			positionLabels = function () {
				//for IE
				$('.login input.js-placeholder-field','.pw-modal').each(function() {
					var $this = $(this),
						pos = $this.position();
						inputWidth = $this.width();
					$this.prev('label')
						.css('left',pos.left)
						.css('top',pos.top)
						.css('width',inputWidth);
				});
				
				
				
			},
            subscribeNowEvent = function () {
				
				return false;
				
				/*
                $('#subscribe-now-wrapper img').live('click', function () {
                    $subscribeNowTout = $subscribeNowTout || $('#subscribe-now-tout');
                    $subscribeNowTout.toggle();
                });
                $('#subscribe-now-wrapper').live('mouseover', function () {
                    $subscribeNowTout = $subscribeNowTout || $('#subscribe-now-tout');
                    $subscribeNowTout.show();
                }).live('mouseout', function () {
                    $subscribeNowTout = $subscribeNowTout || $('#subscribe-now-tout');
                    $subscribeNowTout.hide();
                });
				*/
            },
            isValidEmail = function () {
                var re = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
                return re.test($.trim($('.pw-modal #username').attr('value')));
            },
            isValidUser = function () {
            	
				if (isValidEmail()) {
					return true;
				} else {
					var regEx = /[0-9a-zA-Z]{3,}/,
						regEx2 = /^[a-zA-Z0-9]*$/,
						user = $.trim($('.pw-modal #username').attr('value'));
					
					if (regEx2.test(user) && regEx.test(user)) {
						return true;
					} else {
						return false;
					}
				}
            },
            isValidPassword = function () {
                return $('.pw-modal #password').attr('value').length > 0;
            },
			showError = function (msg) {
				$('.pw-modal').addClass('error');
				$('.pw-modal .message .error').show().html('* ' + msg);
				fakePlaceHolders();
			},
			clearErrorMsg = function() {
				$('.pw-modal').removeClass('error');
				$('.pw-modal .message .error').html('').hide();
			},
			cookiesEnabled = function() {
				var TIME_TEST_COOKIE = 'test_cookie';
				jQuery.cookie( TIME_TEST_COOKIE, true );
				if ( jQuery.cookie ( TIME_TEST_COOKIE ) ) {
					jQuery.cookie( TIME_TEST_COOKIE, null );  // delete the cookie
					return true;
				} else {
					return false;
				}
			},
            submitClickEvent = function () {
				
				$('#paid-wall-submit').live('click', function (e) {
					
					clearErrorMsg();

					if (!cookiesEnabled()) {
                        showError(noCookies);
						return false;
					} else if (!isValidUser()) {
                        showError(badUser);
						return false;
                    } else if  (!isValidPassword()) {
                        showError(badPassword);
						return false;
                    }

                    var $pw = $('.pw-modal');
                    $pw.find('#turl').attr('value', turl);
                    $pw.find('#rurl').attr('value', rurl);
                    
                    console.log();

                    
                });
            },
            applyPAIDWALL2FormEvent = function () {

                indicateHasJS();
				indicateNoPlaceholder();
                submitClickEvent();
				fakePlaceHolders();
				
            },
			renderAllAccessDiv = function () {
				$(function () {
					if(!$('#allAccess').length) {
						$('#site-header').prepend(allAccessDiv);
					}
                });
            },
            renderAllAccessPromoDiv = function () {
                $(function () {
                    //$('#header-new').prepend(allAccessPromoDiv);
					$('#site-header').prepend(allAccessPromoDiv);
                });
            },
            renderLockIcon = function () {
                $(function () {
                      $('.widget_time_paid_content article h4').addClass('locked');
                      $('.widget_time_paid_content .subscribe-text').show();
                      $('.widget_time_paid_content .section-title .subtext').show();

                });
            },
            hideSubscribe = function () {
                $(function () {
                      $('.widget_time_paid_content .subscribe-text').hide();
                      $('.widget_time_paid_content .section-title .subtext').hide();

                });
            },
			mobileInteraction = function () {
				$('.show-hide-login').live('click', function(e) {
					e.preventDefault();
					$('.pw-modal').toggleClass('login-show');
					$('.first').slideToggle(250);
				});
			},
			rememberMeHover = function () {
				var $label = $('#remember-field label');
				var $tooltip = $('#remember-tool-tip');
				
				$('.pw-modal').before($tooltip);
				
				$label.mouseenter(function() {
					lOffset = $label.offset();
					$tooltip
						.show()
						.css('left', lOffset.left)
						.css('top', (lOffset.top + 15));
					$label.addClass('active');
				});
				$tooltip.mouseleave(function() {
					$tooltip.fadeOut(200);
					$label.removeClass('active');
				});
			},
			showPW = function () {
				//$('.pw-modal').show();
			},
            hideLoginTout = function () {

                if (isTOC) {
					$html.addClass('hide-login-tout');
                }

            };

        return {
            paidContentUrl: paidContentUrl,
            isLoggedIn: isLoggedIn,
            init: function () {
				
				mobileInteraction();
				rememberMeHover();
				setTeaserCookie();
								
				if (!isLoggedIn) {
					showPW();
					renderLockIcon();
				} else {
					renderAllAccessDiv();
					hideSubscribe();
				}
				
				if (hasPaidContentUrl || isTOC) {
                        indicateError();
                        clearSystemErrorEvent();
                        deleteErrorCookie();
                        applyPAIDWALL2FormEvent();
				}
            }
        };

    })();
    
	$(document).ready(function() {
		
		window.PAIDWALL2.init();
		
		$(".pw-links .pw-login").click(function(e) {
			e.preventDefault();
			$('body').css('overflow','hidden');
			$('.pw-modal').show();
			preventScrolliing('yes');
		});
		
	    $(".pw-modal .modal-close").click(function() {
	    	$('body').css('overflow', 'auto');
	    	$('.pw-modal, #remember-tool-tip').hide();
	    	preventScrolliing('no');
	    });
	    
	    if (window.location.hash == '#paid-wall') {
	    	$('.pw-links .pw-login').trigger('click');
    	}
		
		$(document).keyup(function(e) {
		    if (e.keyCode == 27) {
		        $('.pw-modal .modal-close').trigger('click');
		        preventScrolliing('no');
		    }
		});
		
		function preventScrolliing(scroll) {
			if (scroll == 'yes') {
				document.ontouchmove = function(e){ e.preventDefault(); };
			} else {
				document.ontouchmove = function(e){ return true; };
			}
		}
		
	});
	
}(this, this.document));
