/*!
 * modernizr v3.0.0-alpha.3
 * Build http://v3.modernizr.com/download/#-cssgradients-csspointerevents-csstransforms-csstransitions-flexbox-objectfit-dontmin
 *
 * Copyright (c)
 *  Faruk Ates
 *  Paul Irish
 *  Alex Sexton
 *  Ryan Seddon
 *  Alexander Farkas
 *  Patrick Kettner
 *  Stu Cox
 *  Richard Herrera

 * MIT License
 */

/*
 * Modernizr tests which native CSS3 and HTML5 features are available in the
 * current UA and makes the results available to you in two ways: as properties on
 * a global `Modernizr` object, and as classes on the `<html>` element. This
 * information allows you to progressively enhance your pages with a granular level
 * of control over the experience.
*/

;(function(window, document, undefined){
  var classes = [];


  var tests = [];


  var ModernizrProto = {
    // The current version, dummy
    _version: '3.0.0-alpha.3',

    // Any settings that don't work as separate modules
    // can go in here as configuration.
    _config: {
      'classPrefix' : '',
      'enableClasses' : true,
      'enableJSClass' : true,
      'usePrefixes' : true
    },

    // Queue of tests
    _q: [],

    // Stub these for people who are listening
    on: function( test, cb ) {
      // I don't really think people should do this, but we can
      // safe guard it a bit.
      // -- NOTE:: this gets WAY overridden in src/addTest for
      // actual async tests. This is in case people listen to
      // synchronous tests. I would leave it out, but the code
      // to *disallow* sync tests in the real version of this
      // function is actually larger than this.
      var self = this;
      setTimeout(function() {
        cb(self[test]);
      }, 0);
    },

    addTest: function( name, fn, options ) {
      tests.push({name : name, fn : fn, options : options });
    },

    addAsyncTest: function (fn) {
      tests.push({name : null, fn : fn});
    }
  };



  // Fake some of Object.create
  // so we can force non test results
  // to be non "own" properties.
  var Modernizr = function(){};
  Modernizr.prototype = ModernizrProto;

  // Leak modernizr globally when you `require` it
  // rather than force it here.
  // Overwrite name so constructor name is nicer :D
  Modernizr = new Modernizr();



  /**
   * is returns a boolean for if typeof obj is exactly type.
   */
  function is( obj, type ) {
    return typeof obj === type;
  }
  ;

  // Run through all tests and detect their support in the current UA.
  function testRunner() {
    var featureNames;
    var feature;
    var aliasIdx;
    var result;
    var nameIdx;
    var featureName;
    var featureNameSplit;

    for ( var featureIdx in tests ) {
      featureNames = [];
      feature = tests[featureIdx];
      // run the test, throw the return value into the Modernizr,
      //   then based on that boolean, define an appropriate className
      //   and push it into an array of classes we'll join later.
      //
      //   If there is no name, it's an 'async' test that is run,
      //   but not directly added to the object. That should
      //   be done with a post-run addTest call.
      if ( feature.name ) {
        featureNames.push(feature.name.toLowerCase());

        if (feature.options && feature.options.aliases && feature.options.aliases.length) {
          // Add all the aliases into the names list
          for (aliasIdx = 0; aliasIdx < feature.options.aliases.length; aliasIdx++) {
            featureNames.push(feature.options.aliases[aliasIdx].toLowerCase());
          }
        }
      }

      // Run the test, or use the raw value if it's not a function
      result = is(feature.fn, 'function') ? feature.fn() : feature.fn;


      // Set each of the names on the Modernizr object
      for (nameIdx = 0; nameIdx < featureNames.length; nameIdx++) {
        featureName = featureNames[nameIdx];
        // Support dot properties as sub tests. We don't do checking to make sure
        // that the implied parent tests have been added. You must call them in
        // order (either in the test, or make the parent test a dependency).
        //
        // Cap it to TWO to make the logic simple and because who needs that kind of subtesting
        // hashtag famous last words
        featureNameSplit = featureName.split('.');

        if (featureNameSplit.length === 1) {
          Modernizr[featureNameSplit[0]] = result;
        } else {
          // cast to a Boolean, if not one already
          /* jshint -W053 */
          if (Modernizr[featureNameSplit[0]] && !(Modernizr[featureNameSplit[0]] instanceof Boolean)) {
            Modernizr[featureNameSplit[0]] = new Boolean(Modernizr[featureNameSplit[0]]);
          }

          Modernizr[featureNameSplit[0]][featureNameSplit[1]] = result;
        }

        classes.push((result ? '' : 'no-') + featureNameSplit.join('-'));
      }
    }
  }

  ;

  var docElement = document.documentElement;


  // Pass in an and array of class names, e.g.:
  //  ['no-webp', 'borderradius', ...]
  function setClasses( classes ) {
    var className = docElement.className;
    var classPrefix = Modernizr._config.classPrefix || '';

    // Change `no-js` to `js` (we do this independently of the `enableClasses`
    // option)
    // Handle classPrefix on this too
    if(Modernizr._config.enableJSClass) {
      var reJS = new RegExp('(^|\\s)'+classPrefix+'no-js(\\s|$)');
      className = className.replace(reJS, '$1'+classPrefix+'js$2');
    }

    if(Modernizr._config.enableClasses) {
      // Add the new classes
      className += ' ' + classPrefix + classes.join(' ' + classPrefix);
      docElement.className = className;
    }

  }

  ;

  // List of property values to set for css tests. See ticket #21
  var prefixes = (ModernizrProto._config.usePrefixes ? ' -webkit- -moz- -o- -ms- '.split(' ') : []);

  // expose these for the plugin API. Look in the source for how to join() them against your input
  ModernizrProto._prefixes = prefixes;



  var createElement = function() {
    if (typeof document.createElement !== 'function') {
      // This is the case in IE7, where the type of createElement is "object".
      // For this reason, we cannot call apply() as Object is not a Function.
      return document.createElement(arguments[0]);
    } else {
      return document.createElement.apply(document, arguments);
    }
  };

/*!
{
  "name": "CSS Gradients",
  "caniuse": "css-gradients",
  "property": "cssgradients",
  "tags": ["css"],
  "knownBugs": ["False-positives on webOS (https://github.com/Modernizr/Modernizr/issues/202)"],
  "notes": [{
    "name": "Webkit Gradient Syntax",
    "href": "http://webkit.org/blog/175/introducing-css-gradients/"
  },{
    "name": "Mozilla Linear Gradient Syntax",
    "href": "http://developer.mozilla.org/en/CSS/-moz-linear-gradient"
  },{
    "name": "Mozilla Radial Gradient Syntax",
    "href": "http://developer.mozilla.org/en/CSS/-moz-radial-gradient"
  },{
    "name": "W3C Gradient Spec",
    "href": "dev.w3.org/csswg/css3-images/#gradients-"
  }]
}
!*/


  Modernizr.addTest('cssgradients', function() {

    var str1 = 'background-image:';
    var str2 = 'gradient(linear,left top,right bottom,from(#9f9),to(white));';
    var str3 = 'linear-gradient(left top,#9f9, white);';

    // standard syntax             // trailing 'background-image:'
    var css = str1 + prefixes.join(str3 + str1).slice(0, -str1.length);
    if (Modernizr._config.usePrefixes) {
    // legacy webkit syntax (FIXME: remove when syntax not in use anymore)
      css += str1 + '-webkit-' + str2;
    }

    var elem = createElement('div');
    var style = elem.style;
    style.cssText = css;

    // IE6 returns undefined so cast to string
    return ('' + style.backgroundImage).indexOf('gradient') > -1;
  });

/*!
{
  "name": "CSS Pointer Events",
  "caniuse": "pointer-events",
  "property": "csspointerevents",
  "authors": ["ausi"],
  "tags": ["css"],
  "builderAliases": ["css_pointerevents"],
  "notes": [
    {
      "name": "MDN Docs",
      "href": "http://developer.mozilla.org/en/CSS/pointer-events"
    },{
      "name": "Test Project Page",
      "href": "http://ausi.github.com/Feature-detection-technique-for-pointer-events/"
    },{
      "name": "Test Project Wiki",
      "href": "http://github.com/ausi/Feature-detection-technique-for-pointer-events/wiki"
    },
    {
      "name": "Related Github Issue",
      "href": "http://github.com/Modernizr/Modernizr/issues/80"
    }
  ]
}
!*/

  Modernizr.addTest('csspointerevents', function() {
    var element = createElement('x');
    element.style.cssText = 'pointer-events:auto';
    return element.style.pointerEvents === 'auto';
  });


  // Helper function for converting kebab-case to camelCase,
  // e.g. box-sizing -> boxSizing
  function cssToDOM( name ) {
    return name.replace(/([a-z])-([a-z])/g, function(str, m1, m2) {
      return m1 + m2.toUpperCase();
    }).replace(/^-/, '');
  }
  ;

  // Following spec is to expose vendor-specific style properties as:
  //   elem.style.WebkitBorderRadius
  // and the following would be incorrect:
  //   elem.style.webkitBorderRadius

  // Webkit ghosts their properties in lowercase but Opera & Moz do not.
  // Microsoft uses a lowercase `ms` instead of the correct `Ms` in IE8+
  //   erik.eae.net/archives/2008/03/10/21.48.10/

  // More here: github.com/Modernizr/Modernizr/issues/issue/21
  var omPrefixes = 'Moz O ms Webkit';


  var cssomPrefixes = (ModernizrProto._config.usePrefixes ? omPrefixes.split(' ') : []);
  ModernizrProto._cssomPrefixes = cssomPrefixes;


  /**
   * atRule returns a given CSS property at-rule (eg @keyframes), possibly in
   * some prefixed form, or false, in the case of an unsupported rule
   *
   * @param prop - String naming the property to test
   */

  var atRule = function(prop) {
    var length = prefixes.length;
    var cssrule = window.CSSRule;
    var rule;

    if (typeof cssrule === 'undefined') {
      return undefined;
    }

    if (!prop) {
      return false;
    }

    // remove literal @ from beginning of provided property
    prop = prop.replace(/^@/,'');

    // CSSRules use underscores instead of dashes
    rule = prop.replace(/-/g,'_').toUpperCase() + '_RULE';

    if (rule in cssrule) {
      return '@' + prop;
    }

    for ( var i = 0; i < length; i++ ) {
      // prefixes gives us something like -o-, and we want O_
      var prefix = prefixes[i];
      var thisRule = prefix.toUpperCase() + '_' + rule;

      if (thisRule in cssrule) {
        return '@-' + prefix.toLowerCase() + '-' + prop;
      }
    }

    return false;
  };



  var domPrefixes = (ModernizrProto._config.usePrefixes ? omPrefixes.toLowerCase().split(' ') : []);
  ModernizrProto._domPrefixes = domPrefixes;


  /**
   * contains returns a boolean for if substr is found within str.
   */
  function contains( str, substr ) {
    return !!~('' + str).indexOf(substr);
  }

  ;

  // Change the function's scope.
  function fnBind(fn, that) {
    return function() {
      return fn.apply(that, arguments);
    };
  }

  ;

  /**
   * testDOMProps is a generic DOM property test; if a browser supports
   *   a certain property, it won't return undefined for it.
   */
  function testDOMProps( props, obj, elem ) {
    var item;

    for ( var i in props ) {
      if ( props[i] in obj ) {

        // return the property name as a string
        if (elem === false) return props[i];

        item = obj[props[i]];

        // let's bind a function
        if (is(item, 'function')) {
          // bind to obj unless overriden
          return fnBind(item, elem || obj);
        }

        // return the unbound function or obj or value
        return item;
      }
    }
    return false;
  }

  ;

  /**
   * Create our "modernizr" element that we do most feature tests on.
   */
  var modElem = {
    elem : createElement('modernizr')
  };

  // Clean up this element
  Modernizr._q.push(function() {
    delete modElem.elem;
  });



  var mStyle = {
    style : modElem.elem.style
  };

  // kill ref for gc, must happen before
  // mod.elem is removed, so we unshift on to
  // the front of the queue.
  Modernizr._q.unshift(function() {
    delete mStyle.style;
  });



  // Helper function for converting camelCase to kebab-case,
  // e.g. boxSizing -> box-sizing
  function domToCSS( name ) {
    return name.replace(/([A-Z])/g, function(str, m1) {
      return '-' + m1.toLowerCase();
    }).replace(/^ms-/, '-ms-');
  }
  ;

  function getBody() {
    // After page load injecting a fake body doesn't work so check if body exists
    var body = document.body;

    if(!body) {
      // Can't use the real body create a fake one.
      body = createElement('body');
      body.fake = true;
    }

    return body;
  }

  ;

  // Inject element with style element and some CSS rules
  function injectElementWithStyles( rule, callback, nodes, testnames ) {
    var mod = 'modernizr';
    var style;
    var ret;
    var node;
    var docOverflow;
    var div = createElement('div');
    var body = getBody();

    if ( parseInt(nodes, 10) ) {
      // In order not to give false positives we create a node for each test
      // This also allows the method to scale for unspecified uses
      while ( nodes-- ) {
        node = createElement('div');
        node.id = testnames ? testnames[nodes] : mod + (nodes + 1);
        div.appendChild(node);
      }
    }

    // <style> elements in IE6-9 are considered 'NoScope' elements and therefore will be removed
    // when injected with innerHTML. To get around this you need to prepend the 'NoScope' element
    // with a 'scoped' element, in our case the soft-hyphen entity as it won't mess with our measurements.
    // msdn.microsoft.com/en-us/library/ms533897%28VS.85%29.aspx
    // Documents served as xml will throw if using &shy; so use xml friendly encoded version. See issue #277
    style = ['&#173;','<style id="s', mod, '">', rule, '</style>'].join('');
    div.id = mod;
    // IE6 will false positive on some tests due to the style element inside the test div somehow interfering offsetHeight, so insert it into body or fakebody.
    // Opera will act all quirky when injecting elements in documentElement when page is served as xml, needs fakebody too. #270
    (!body.fake ? div : body).innerHTML += style;
    body.appendChild(div);
    if ( body.fake ) {
      //avoid crashing IE8, if background image is used
      body.style.background = '';
      //Safari 5.13/5.1.4 OSX stops loading if ::-webkit-scrollbar is used and scrollbars are visible
      body.style.overflow = 'hidden';
      docOverflow = docElement.style.overflow;
      docElement.style.overflow = 'hidden';
      docElement.appendChild(body);
    }

    ret = callback(div, rule);
    // If this is done after page load we don't want to remove the body so check if body exists
    if ( body.fake ) {
      body.parentNode.removeChild(body);
      docElement.style.overflow = docOverflow;
      // Trigger layout so kinetic scrolling isn't disabled in iOS6+
      docElement.offsetHeight;
    } else {
      div.parentNode.removeChild(div);
    }

    return !!ret;

  }

  ;

  // Function to allow us to use native feature detection functionality if available.
  // Accepts a list of property names and a single value
  // Returns `undefined` if native detection not available
  function nativeTestProps ( props, value ) {
    var i = props.length;
    // Start with the JS API: http://www.w3.org/TR/css3-conditional/#the-css-interface
    if ('CSS' in window && 'supports' in window.CSS) {
      // Try every prefixed variant of the property
      while (i--) {
        if (window.CSS.supports(domToCSS(props[i]), value)) {
          return true;
        }
      }
      return false;
    }
    // Otherwise fall back to at-rule (for Opera 12.x)
    else if ('CSSSupportsRule' in window) {
      // Build a condition string for every prefixed variant
      var conditionText = [];
      while (i--) {
        conditionText.push('(' + domToCSS(props[i]) + ':' + value + ')');
      }
      conditionText = conditionText.join(' or ');
      return injectElementWithStyles('@supports (' + conditionText + ') { #modernizr { position: absolute; } }', function( node ) {
        return getComputedStyle(node, null).position == 'absolute';
      });
    }
    return undefined;
  }
  ;

  // testProps is a generic CSS / DOM property test.

  // In testing support for a given CSS property, it's legit to test:
  //    `elem.style[styleName] !== undefined`
  // If the property is supported it will return an empty string,
  // if unsupported it will return undefined.

  // We'll take advantage of this quick test and skip setting a style
  // on our modernizr element, but instead just testing undefined vs
  // empty string.

  // Property names can be provided in either camelCase or kebab-case.

  function testProps( props, prefixed, value, skipValueTest ) {
    skipValueTest = is(skipValueTest, 'undefined') ? false : skipValueTest;

    // Try native detect first
    if (!is(value, 'undefined')) {
      var result = nativeTestProps(props, value);
      if(!is(result, 'undefined')) {
        return result;
      }
    }

    // Otherwise do it properly
    var afterInit, i, propsLength, prop, before;

    // If we don't have a style element, that means
    // we're running async or after the core tests,
    // so we'll need to create our own elements to use
    if ( !mStyle.style ) {
      afterInit = true;
      mStyle.modElem = createElement('modernizr');
      mStyle.style = mStyle.modElem.style;
    }

    // Delete the objects if we
    // we created them.
    function cleanElems() {
      if (afterInit) {
        delete mStyle.style;
        delete mStyle.modElem;
      }
    }

    propsLength = props.length;
    for ( i = 0; i < propsLength; i++ ) {
      prop = props[i];
      before = mStyle.style[prop];

      if (contains(prop, '-')) {
        prop = cssToDOM(prop);
      }

      if ( mStyle.style[prop] !== undefined ) {

        // If value to test has been passed in, do a set-and-check test.
        // 0 (integer) is a valid property value, so check that `value` isn't
        // undefined, rather than just checking it's truthy.
        if (!skipValueTest && !is(value, 'undefined')) {

          // Needs a try catch block because of old IE. This is slow, but will
          // be avoided in most cases because `skipValueTest` will be used.
          try {
            mStyle.style[prop] = value;
          } catch (e) {}

          // If the property value has changed, we assume the value used is
          // supported. If `value` is empty string, it'll fail here (because
          // it hasn't changed), which matches how browsers have implemented
          // CSS.supports()
          if (mStyle.style[prop] != before) {
            cleanElems();
            return prefixed == 'pfx' ? prop : true;
          }
        }
        // Otherwise just return true, or the property name if this is a
        // `prefixed()` call
        else {
          cleanElems();
          return prefixed == 'pfx' ? prop : true;
        }
      }
    }
    cleanElems();
    return false;
  }

  ;

  /**
   * testPropsAll tests a list of DOM properties we want to check against.
   *     We specify literally ALL possible (known and/or likely) properties on
   *     the element including the non-vendor prefixed one, for forward-
   *     compatibility.
   */
  function testPropsAll( prop, prefixed, elem, value, skipValueTest ) {

    var ucProp = prop.charAt(0).toUpperCase() + prop.slice(1),
    props = (prop + ' ' + cssomPrefixes.join(ucProp + ' ') + ucProp).split(' ');

    // did they call .prefixed('boxSizing') or are we just testing a prop?
    if(is(prefixed, 'string') || is(prefixed, 'undefined')) {
      return testProps(props, prefixed, value, skipValueTest);

      // otherwise, they called .prefixed('requestAnimationFrame', window[, elem])
    } else {
      props = (prop + ' ' + (domPrefixes).join(ucProp + ' ') + ucProp).split(' ');
      return testDOMProps(props, prefixed, elem);
    }
  }

  // Modernizr.testAllProps() investigates whether a given style property,
  //     or any of its vendor-prefixed variants, is recognized
  // Note that the property names must be provided in the camelCase variant.
  // Modernizr.testAllProps('boxSizing')
  ModernizrProto.testAllProps = testPropsAll;



  // Modernizr.prefixed() returns the prefixed or nonprefixed property name variant of your input
  // Modernizr.prefixed('boxSizing') // 'MozBoxSizing'

  // Properties can be passed as DOM-style camelCase or CSS-style kebab-case.
  // Return values will always be in camelCase; if you want kebab-case, use Modernizr.prefixedCSS().

  // If you're trying to ascertain which transition end event to bind to, you might do something like...
  //
  //     var transEndEventNames = {
  //         'WebkitTransition' : 'webkitTransitionEnd',// Saf 6, Android Browser
  //         'MozTransition'    : 'transitionend',      // only for FF < 15
  //         'transition'       : 'transitionend'       // IE10, Opera, Chrome, FF 15+, Saf 7+
  //     },
  //     transEndEventName = transEndEventNames[ Modernizr.prefixed('transition') ];

  var prefixed = ModernizrProto.prefixed = function( prop, obj, elem ) {
    if (prop.indexOf('@') === 0) {
      return atRule(prop);
    }

    if (prop.indexOf('-') != -1) {
      // Convert kebab-case to camelCase
      prop = cssToDOM(prop);
    }
    if (!obj) {
      return testPropsAll(prop, 'pfx');
    } else {
      // Testing DOM property e.g. Modernizr.prefixed('requestAnimationFrame', window) // 'mozRequestAnimationFrame'
      return testPropsAll(prop, obj, elem);
    }
  };


/*!
{
  "name": "CSS Object Fit",
  "caniuse": "object-fit",
  "property": "objectfit",
  "tags": ["css"],
  "builderAliases": ["css_objectfit"],
  "notes": [{
    "name": "Opera Article on Object Fit",
    "href": "http://dev.opera.com/articles/view/css3-object-fit-object-position/"
  }]
}
!*/

  Modernizr.addTest('objectfit', !!prefixed('objectFit'), { aliases: ['object-fit'] });


  /**
   * testAllProps determines whether a given CSS property, in some prefixed
   * form, is supported by the browser. It can optionally be given a value; in
   * which case testAllProps will only return true if the browser supports that
   * value for the named property; this latter case will use native detection
   * (via window.CSS.supports) if available. A boolean can be passed as a 3rd
   * parameter to skip the value check when native detection isn't available,
   * to improve performance when simply testing for support of a property.
   *
   * @param prop - String naming the property to test (either camelCase or
   *               kebab-case)
   * @param value - [optional] String of the value to test
   * @param skipValueTest - [optional] Whether to skip testing that the value
   *                        is supported when using non-native detection
   *                        (default: false)
   */
  function testAllProps (prop, value, skipValueTest) {
    return testPropsAll(prop, undefined, undefined, value, skipValueTest);
  }
  ModernizrProto.testAllProps = testAllProps;

/*!
{
  "name": "CSS Transitions",
  "property": "csstransitions",
  "caniuse": "css-transitions",
  "tags": ["css"]
}
!*/

  Modernizr.addTest('csstransitions', testAllProps('transition', 'all', true));

/*!
{
  "name": "Flexbox",
  "property": "flexbox",
  "caniuse": "flexbox",
  "tags": ["css"],
  "notes": [{
    "name": "The _new_ flexbox",
    "href": "http://dev.w3.org/csswg/css3-flexbox"
  }],
  "warnings": [
    "A `true` result for this detect does not imply that the `flex-wrap` property is supported; see the `flexwrap` detect."
  ]
}
!*/
/* DOC
Detects support for the Flexible Box Layout model, a.k.a. Flexbox, which allows easy manipulation of layout order and sizing within a container.
*/

  Modernizr.addTest('flexbox', testAllProps('flexBasis', '1px', true));

/*!
{
  "name": "CSS Transforms",
  "property": "csstransforms",
  "caniuse": "transforms2d",
  "tags": ["css"]
}
!*/

  Modernizr.addTest('csstransforms', function() {
    // Android < 3.0 is buggy, so we sniff and blacklist
    // http://git.io/hHzL7w
    return navigator.userAgent.indexOf('Android 2.') === -1 &&
           testAllProps('transform', 'scale(1)', true);
  });


  // Run each test
  testRunner();

  // Remove the "no-js" class if it exists
  setClasses(classes);

  delete ModernizrProto.addTest;
  delete ModernizrProto.addAsyncTest;

  // Run the things that are supposed to run after the tests
  for (var i = 0; i < Modernizr._q.length; i++) {
    Modernizr._q[i]();
  }

  // Leak Modernizr namespace
  window.Modernizr = Modernizr;


;

})(window, document);/*

  A17 vs Scientific American

*/

// --------------------------------------------------------------------------------------------------------------

// set up some objects within the master one, to hold my Helpers and behaviors
A17.Behaviors = {
};
A17.Helpers = {
};
A17.Functions = {
};
A17.media_query_in_use = "large";

// look through the document (or ajax'd in content if "context" is defined) to look for "data-behavior" attributes.
// Initialize a new instance of the method if found, passing through the element that had the attribute
// So in this example it will find 'data-behavior="show_articles"' and run the show_articles method.
A17.LoadBehavior = function(context){
  if(context === undefined){
    context = document;
  }
  var all = context.querySelectorAll("[data-behavior]");
  var i = -1;
  while (all[++i]) {
    var currentElement = all[i];
    var behaviors = currentElement.getAttribute("data-behavior");
    var splitted_behaviors = behaviors.split(" ");
    for (var j = 0, k = splitted_behaviors.length; j < k; j++) {
      var thisBehavior = A17.Behaviors[splitted_behaviors[j]];
      if(typeof thisBehavior !== "undefined") {
        thisBehavior.call(currentElement,currentElement);
      }
    }
  }
};

// set up and trigger looking for the behaviors on DOM ready
A17.onReady = function(){
  // observe fonts loading
  A17.Helpers.font_observers();
  // sort out which media query we're using
  A17.media_query_in_use = A17.Helpers.get_media_query_in_use();
  // go go go
  A17.LoadBehavior();
  // on resize, check
  var resize_timer;
  $(window).on('resize', function(){
    clearTimeout(resize_timer);
    resize_timer = setTimeout(function(){
      A17.Helpers.resized();
    },250);
  });
};

// Add user agent to <html>
var doc = document.documentElement;
doc.setAttribute('data-useragent', navigator.userAgent);

if (A17.browserSpec && A17.browserSpec === "html5") {
  document.addEventListener('DOMContentLoaded', function(){
    window.$ = min$;
    A17.onReady();
  });

}

// make console.log safe
if (typeof console === "undefined") {
  console = {
    log: function () {
      return;
    }
  };
}

(function(d,p){
    var a=new XMLHttpRequest(),
        b=d.body;
    a.open("GET",p,!0);
    a.send();
    a.onload=function(){
        var c=d.createElement("div");
        c.style.display="none";
        c.innerHTML=a.responseText;
        b.insertBefore(c,b.childNodes[0]);
    };
})(document,"/resources/video-sprite-b8abeecb98bfc301add05f93c8a63a5b.svg");

/*
* helper for loading scripts
*/

A17.loadScript = function(url, callback){

  if (typeof callback !== 'function') {
     throw new Error('Not a valid callback');
  }

  var script = document.createElement('script');
  script.type='text/javascript';
  script.async=true;
  script.onload = callback;
  script.src = (location.protocol==='https:'?'https:':'http:')+url;
  document.getElementsByTagName('head')[0].appendChild(script);
}
;
(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
'use strict';

var _typeof2 = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof2(obj);
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof2(obj);
};

var _createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
  };
}();

var _dom = require('./util/dom');

var _throwIfMissing = require('./util/throwIfMissing');

var _throwIfMissing2 = _interopRequireDefault(_throwIfMissing);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

var LEFT_ARROW = 37;
var RIGHT_ARROW = 39;

// All officially-supported browsers have this, but it's easy to
// account for, just in case.
var HAS_ANIMATION = typeof document === 'undefined' ? false : 'animation' in document.createElement('div').style;

var Lightbox = function () {
  function Lightbox() {
    var _this = this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Lightbox);

    this._sizeImgWrapperEl = function () {
      var style = _this.imgWrapperEl.style;
      style.width = _this.innerEl.clientWidth + 'px';
      style.maxWidth = _this.innerEl.clientWidth + 'px';
      style.height = _this.innerEl.clientHeight - _this.captionEl.clientHeight + 'px';
      style.maxHeight = _this.innerEl.clientHeight - _this.captionEl.clientHeight + 'px';
    };

    this._handleKeydown = function (e) {
      if (e.keyCode == LEFT_ARROW) {
        _this.showPrevious();
      } else if (e.keyCode == RIGHT_ARROW) {
        _this.showNext();
      }
    };

    this.showNext = function () {
      if (!_this.settings._gallery) {
        return;
      }

      _this.currentTrigger = _this.settings._gallery.nextTrigger(_this.currentTrigger);
      _this._updateImgSrc();
      _this._updateCaption();
      _this._sizeImgWrapperEl();
    };

    this.showPrevious = function () {
      if (!_this.settings._gallery) {
        return;
      }

      _this.currentTrigger = _this.settings._gallery.previousTrigger(_this.currentTrigger);
      _this._updateImgSrc();
      _this._updateCaption();
      _this._sizeImgWrapperEl();
    };

    this._completeOpen = function () {
      _this.el.removeEventListener('animationend', _this._completeOpen, false);

      (0, _dom.removeClasses)(_this.el, _this.openingClasses);
    };

    this._completeClose = function () {
      _this.el.removeEventListener('animationend', _this._completeClose, false);

      (0, _dom.removeClasses)(_this.el, _this.openClasses);
      (0, _dom.removeClasses)(_this.el, _this.closingClasses);
    };

    var _options$namespace = options.namespace;
    var namespace = _options$namespace === undefined ? null : _options$namespace;
    var _options$parentEl = options.parentEl;
    var parentEl = _options$parentEl === undefined ? (0, _throwIfMissing2.default)() : _options$parentEl;
    var _options$triggerEl = options.triggerEl;
    var triggerEl = _options$triggerEl === undefined ? (0, _throwIfMissing2.default)() : _options$triggerEl;
    var _options$sourceAttrib = options.sourceAttribute;
    var sourceAttribute = _options$sourceAttrib === undefined ? (0, _throwIfMissing2.default)() : _options$sourceAttrib;
    var _options$caption = options.caption;
    var caption = _options$caption === undefined ? null : _options$caption;
    var _options$includeImgix = options.includeImgixJSClass;
    var includeImgixJSClass = _options$includeImgix === undefined ? false : _options$includeImgix;
    var _options$_gallery = options._gallery;

    var _gallery = _options$_gallery === undefined ? null : _options$_gallery;

    var _options$_arrowNaviga = options._arrowNavigation;

    var _arrowNavigation = _options$_arrowNaviga === undefined ? null : _options$_arrowNaviga;

    this.settings = { namespace: namespace, parentEl: parentEl, triggerEl: triggerEl, sourceAttribute: sourceAttribute, caption: caption, includeImgixJSClass: includeImgixJSClass, _gallery: _gallery, _arrowNavigation: _arrowNavigation };

    if (!(0, _dom.isDOMElement)(this.settings.parentEl)) {
      throw new TypeError('`new Lightbox` requires a DOM element passed as `parentEl`.');
    }

    this.currentTrigger = this.settings.triggerEl;

    this.openClasses = this._buildClasses('open');
    this.openingClasses = this._buildClasses('opening');
    this.closingClasses = this._buildClasses('closing');

    this.elementBuilt = false;
  }

  _createClass(Lightbox, [{
    key: '_buildClasses',
    value: function _buildClasses(suffix) {
      var classes = ['lum-' + suffix];

      var ns = this.settings.namespace;
      if (ns) {
        classes.push(ns + '-' + suffix);
      }

      return classes;
    }
  }, {
    key: '_buildElement',
    value: function _buildElement() {
      this.el = document.createElement('div');
      (0, _dom.addClasses)(this.el, this._buildClasses('lightbox'));

      this.innerEl = document.createElement('div');
      (0, _dom.addClasses)(this.innerEl, this._buildClasses('lightbox-inner'));
      this.el.appendChild(this.innerEl);

      var loaderEl = document.createElement('div');
      (0, _dom.addClasses)(loaderEl, this._buildClasses('lightbox-loader'));
      this.innerEl.appendChild(loaderEl);

      this.imgWrapperEl = document.createElement('div');
      (0, _dom.addClasses)(this.imgWrapperEl, this._buildClasses('lightbox-image-wrapper'));
      this.innerEl.appendChild(this.imgWrapperEl);

      var positionHelperEl = document.createElement('span');
      (0, _dom.addClasses)(positionHelperEl, this._buildClasses('lightbox-position-helper'));
      this.imgWrapperEl.appendChild(positionHelperEl);

      this.imgEl = document.createElement('img');
      (0, _dom.addClasses)(this.imgEl, this._buildClasses('img'));
      positionHelperEl.appendChild(this.imgEl);

      this.captionEl = document.createElement('p');
      (0, _dom.addClasses)(this.captionEl, this._buildClasses('lightbox-caption'));
      positionHelperEl.appendChild(this.captionEl);

      if (this.settings._gallery) {
        this._setUpGalleryElements();
      }

      this.settings.parentEl.appendChild(this.el);

      this._updateImgSrc();
      this._updateCaption();

      if (this.settings.includeImgixJSClass) {
        this.imgEl.classList.add('imgix-fluid');
      }
    }
  }, {
    key: '_setUpGalleryElements',
    value: function _setUpGalleryElements() {
      this._buildGalleryButton('previous', this.showPrevious);
      this._buildGalleryButton('next', this.showNext);
    }
  }, {
    key: '_buildGalleryButton',
    value: function _buildGalleryButton(name, fn) {
      var btn = document.createElement('button');
      this[name + 'Button'] = btn;

      btn.innerText = name;
      (0, _dom.addClasses)(btn, this._buildClasses(name + '-button'));
      (0, _dom.addClasses)(btn, this._buildClasses('gallery-button'));
      this.innerEl.appendChild(btn);

      btn.addEventListener('click', function (e) {
        e.stopPropagation();

        fn();
      }, false);
    }
  }, {
    key: '_updateCaption',
    value: function _updateCaption() {
      var captionType = _typeof(this.settings.caption);
      var caption = '';

      if (captionType === 'string') {
        caption = this.settings.caption;
      } else if (captionType === 'function') {
        caption = this.settings.caption(this.currentTrigger);
      }

      this.captionEl.innerHTML = caption;
    }
  }, {
    key: '_updateImgSrc',
    value: function _updateImgSrc() {
      var _this2 = this;

      var imageURL = this.currentTrigger.getAttribute(this.settings.sourceAttribute);

      if (!imageURL) {
        throw new Error('No image URL was found in the ' + this.settings.sourceAttribute + ' attribute of the trigger.');
      }

      var loadingClasses = this._buildClasses('loading');
      (0, _dom.addClasses)(this.el, loadingClasses);
      this.imgEl.onload = function () {
        (0, _dom.removeClasses)(_this2.el, loadingClasses);
      };

      this.imgEl.setAttribute('src', imageURL);
    }
  }, {
    key: 'open',
    value: function open() {
      if (!this.elementBuilt) {
        this._buildElement();
        this.elementBuilt = true;
      }

      // When opening, always reset to the trigger we were passed
      this.currentTrigger = this.settings.triggerEl;

      // Make sure to re-set the `img` `src`, in case it's been changed
      // by someone/something else.
      this._updateImgSrc();
      this._updateCaption();

      (0, _dom.addClasses)(this.el, this.openClasses);

      this._sizeImgWrapperEl();
      window.addEventListener('resize', this._sizeImgWrapperEl, false);

      if (this.settings._arrowNavigation) {
        window.addEventListener('keydown', this._handleKeydown, false);
      }

      if (HAS_ANIMATION) {
        this.el.addEventListener('animationend', this._completeOpen, false);
        (0, _dom.addClasses)(this.el, this.openingClasses);
      }
    }
  }, {
    key: 'close',
    value: function close() {
      window.removeEventListener('resize', this._sizeImgWrapperEl, false);

      if (this.settings._arrowNavigation) {
        window.removeEventListener('keydown', this._handleKeydown, false);
      }

      if (HAS_ANIMATION) {
        this.el.addEventListener('animationend', this._completeClose, false);
        (0, _dom.addClasses)(this.el, this.closingClasses);
      } else {
        (0, _dom.removeClasses)(this.el, this.openClasses);
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.el) {
        this.settings.parentEl.removeChild(this.el);
      }
    }
  }]);

  return Lightbox;
}();

exports.default = Lightbox;

},{"./util/dom":6,"./util/throwIfMissing":7}],2:[function(require,module,exports){
'use strict';

var _createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
  };
}();

var _class, _temp, _initialiseProps;

var _dom = require('./util/dom');

var _injectBaseStylesheet = require('./injectBaseStylesheet');

var _injectBaseStylesheet2 = _interopRequireDefault(_injectBaseStylesheet);

var _Lightbox = require('./Lightbox');

var _Lightbox2 = _interopRequireDefault(_Lightbox);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

module.exports = (_temp = _class = function () {
  function Luminous(trigger) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Luminous);

    _initialiseProps.call(this);

    this.isOpen = false;

    this.trigger = trigger;

    if (!(0, _dom.isDOMElement)(this.trigger)) {
      throw new TypeError('`new Luminous` requires a DOM element as its first argument.');
    }

    // A bit unexpected if you haven't seen this pattern before.
    // Based on the pattern here:
    // https://github.com/getify/You-Dont-Know-JS/blob/master/es6%20&%20beyond/ch2.md#nested-defaults-destructured-and-restructured
    var _options$namespace = options.namespace;
    var namespace = _options$namespace === undefined ? null : _options$namespace;
    var _options$sourceAttrib = options.sourceAttribute;
    var sourceAttribute = _options$sourceAttrib === undefined ? 'href' : _options$sourceAttrib;
    var _options$caption = options.caption;
    var caption = _options$caption === undefined ? null : _options$caption;
    var _options$openTrigger = options.openTrigger;
    var openTrigger = _options$openTrigger === undefined ? 'click' : _options$openTrigger;
    var _options$closeTrigger = options.closeTrigger;
    var closeTrigger = _options$closeTrigger === undefined ? 'click' : _options$closeTrigger;
    var _options$closeWithEsc = options.closeWithEscape;
    var closeWithEscape = _options$closeWithEsc === undefined ? true : _options$closeWithEsc;
    var _options$closeOnScrol = options.closeOnScroll;
    var closeOnScroll = _options$closeOnScrol === undefined ? false : _options$closeOnScrol;
    var _options$appendToSele = options.appendToSelector;
    var appendToSelector = _options$appendToSele === undefined ? 'body' : _options$appendToSele;
    var _options$onOpen = options.onOpen;
    var onOpen = _options$onOpen === undefined ? null : _options$onOpen;
    var _options$onClose = options.onClose;
    var onClose = _options$onClose === undefined ? null : _options$onClose;
    var _options$includeImgix = options.includeImgixJSClass;
    var includeImgixJSClass = _options$includeImgix === undefined ? false : _options$includeImgix;
    var _options$injectBaseSt = options.injectBaseStyles;
    var injectBaseStyles = _options$injectBaseSt === undefined ? true : _options$injectBaseSt;
    var _options$_gallery = options._gallery;

    var _gallery = _options$_gallery === undefined ? null : _options$_gallery;

    var _options$_arrowNaviga = options._arrowNavigation;

    var _arrowNavigation = _options$_arrowNaviga === undefined ? null : _options$_arrowNaviga;

    this.settings = { namespace: namespace, sourceAttribute: sourceAttribute, caption: caption, openTrigger: openTrigger, closeTrigger: closeTrigger, closeWithEscape: closeWithEscape, closeOnScroll: closeOnScroll, appendToSelector: appendToSelector, onOpen: onOpen, onClose: onClose, includeImgixJSClass: includeImgixJSClass, injectBaseStyles: injectBaseStyles, _gallery: _gallery, _arrowNavigation: _arrowNavigation };

    if (this.settings.injectBaseStyles) {
      (0, _injectBaseStylesheet2.default)();
    }

    this._buildLightbox();
    this._bindEvents();
  }

  _createClass(Luminous, [{
    key: '_buildLightbox',
    value: function _buildLightbox() {
      this.lightbox = new _Lightbox2.default({
        namespace: this.settings.namespace,
        parentEl: document.querySelector(this.settings.appendToSelector),
        triggerEl: this.trigger,
        sourceAttribute: this.settings.sourceAttribute,
        caption: this.settings.caption,
        includeImgixJSClass: this.settings.includeImgixJSClass,
        _gallery: this.settings._gallery,
        _arrowNavigation: this.settings._arrowNavigation
      });
    }
  }, {
    key: '_bindEvents',
    value: function _bindEvents() {
      this.trigger.addEventListener(this.settings.openTrigger, this.open, false);

      if (this.settings.closeWithEscape) {
        window.addEventListener('keyup', this._handleKeyup, false);
      }
    }
  }, {
    key: '_bindCloseEvent',
    value: function _bindCloseEvent() {
      this.lightbox.el.addEventListener(this.settings.closeTrigger, this.close, false);
    }
  }, {
    key: '_unbindEvents',
    value: function _unbindEvents() {
      this.trigger.removeEventListener(this.settings.openTrigger, this.open, false);
      if (this.lightbox.el) {
        this.lightbox.el.removeEventListener(this.settings.closeTrigger, this.close, false);
      }

      if (this.settings.closeWithEscape) {
        window.removeEventListener('keyup', this._handleKeyup, false);
      }
    }
  }]);

  return Luminous;
}(), _initialiseProps = function _initialiseProps() {
  var _this = this;

  this.VERSION = '1.0.1';

  this.open = function (e) {
    if (e && typeof e.preventDefault === 'function') {
      e.preventDefault();
    }

    var previouslyBuilt = _this.lightbox.elementBuilt;

    _this.lightbox.open();

    if (!previouslyBuilt) {
      _this._bindCloseEvent();
    }

    if (_this.settings.closeOnScroll) {
      window.addEventListener('scroll', _this.close, false);
    }

    var onOpen = _this.settings.onOpen;
    if (onOpen && typeof onOpen === 'function') {
      onOpen();
    }

    _this.isOpen = true;
  };

  this.close = function (e) {
    if (e && typeof e.preventDefault === 'function') {
      e.preventDefault();
    }

    if (_this.settings.closeOnScroll) {
      window.removeEventListener('scroll', _this.close, false);
    }

    _this.lightbox.close();

    var onClose = _this.settings.onClose;
    if (onClose && typeof onClose === 'function') {
      onClose();
    }

    _this.isOpen = false;
  };

  this._handleKeyup = function (e) {
    if (_this.isOpen && e.keyCode === 27) {
      _this.close();
    }
  };

  this.destroy = function () {
    _this._unbindEvents();
    _this.lightbox.destroy();
  };
}, _temp);

},{"./Lightbox":1,"./injectBaseStylesheet":4,"./util/dom":6}],3:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
  };
}();

var _dom = require('./util/dom');

var _Luminous = require('./Luminous');

var _Luminous2 = _interopRequireDefault(_Luminous);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

var LuminousGallery = function () {
  function LuminousGallery(triggers) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var luminousOpts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    _classCallCheck(this, LuminousGallery);

    this.boundMethod = function () {};

    var _options$arrowNavigat = options.arrowNavigation;
    var arrowNavigation = _options$arrowNavigat === undefined ? true : _options$arrowNavigat;

    this.settings = { arrowNavigation: arrowNavigation };

    this.triggers = triggers;
    this.luminousOpts = luminousOpts;
    this.luminousOpts._gallery = this;
    this.luminousOpts._arrowNavigation = this.settings.arrowNavigation;
    this._constructLuminousInstances();
  }

  _createClass(LuminousGallery, [{
    key: '_constructLuminousInstances',
    value: function _constructLuminousInstances() {
      this.luminousInstances = [];

      var triggerLen = this.triggers.length;
      for (var i = 0; i < triggerLen; i++) {
        var trigger = this.triggers[i];
        var lum = new _Luminous2.default(trigger, this.luminousOpts);
        this.luminousInstances.push(lum);
      }
    }
  }, {
    key: 'nextTrigger',
    value: function nextTrigger(trigger) {
      var nextTriggerIndex = Array.prototype.indexOf.call(this.triggers, trigger) + 1;

      return nextTriggerIndex >= this.triggers.length ? this.triggers[0] : this.triggers[nextTriggerIndex];
    }
  }, {
    key: 'previousTrigger',
    value: function previousTrigger(trigger) {
      var prevTriggerIndex = Array.prototype.indexOf.call(this.triggers, trigger) - 1;

      return prevTriggerIndex < 0 ? this.triggers[this.triggers.length - 1] : this.triggers[prevTriggerIndex];
    }
  }, {
    key: 'destroy',
    value: function destroy() {}
  }]);

  return LuminousGallery;
}();

exports.default = LuminousGallery;

},{"./Luminous":2,"./util/dom":6}],4:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = injectBaseStylesheet;
var RULES = '\n@keyframes lum-noop {\n  0% { zoom: 1; }\n}\n\n.lum-lightbox {\n  position: fixed;\n  display: none;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n}\n\n.lum-lightbox.lum-open {\n  display: block;\n}\n\n.lum-lightbox.lum-opening, .lum-lightbox.lum-closing {\n  animation: lum-noop 1ms;\n}\n\n.lum-lightbox-inner {\n  position: absolute;\n  top: 0%;\n  right: 0%;\n  bottom: 0%;\n  left: 0%;\n\n  overflow: hidden;\n}\n\n.lum-lightbox-loader {\n  display: none;\n}\n\n.lum-lightbox-inner img {\n  max-width: 100%;\n  max-height: 100%;\n}\n\n.lum-lightbox-image-wrapper {\n  vertical-align: middle;\n  display: table-cell;\n  text-align: center;\n}\n';

function injectBaseStylesheet() {
  if (document.querySelector('.lum-base-styles')) {
    return;
  }

  var styleEl = document.createElement('style');
  styleEl.type = 'text/css';
  styleEl.classList.add('lum-base-styles');

  styleEl.appendChild(document.createTextNode(RULES));

  var head = document.head;
  head.insertBefore(styleEl, head.firstChild);
}

},{}],5:[function(require,module,exports){
(function (global){
'use strict';

var _Luminous = require('./Luminous');

var _Luminous2 = _interopRequireDefault(_Luminous);

var _LuminousGallery = require('./LuminousGallery');

var _LuminousGallery2 = _interopRequireDefault(_LuminousGallery);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

global.Luminous = _Luminous2.default;
global.LuminousGallery = _LuminousGallery2.default;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./Luminous":2,"./LuminousGallery":3}],6:[function(require,module,exports){
'use strict';

var _typeof2 = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof2(obj);
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof2(obj);
};

exports.isDOMElement = isDOMElement;
exports.addClasses = addClasses;
exports.removeClasses = removeClasses;
// This is not really a perfect check, but works fine.
// From http://stackoverflow.com/questions/384286
var HAS_DOM_2 = (typeof HTMLElement === 'undefined' ? 'undefined' : _typeof(HTMLElement)) === 'object';

function isDOMElement(obj) {
  return HAS_DOM_2 ? obj instanceof HTMLElement : obj && (typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) === 'object' && obj !== null && obj.nodeType === 1 && typeof obj.nodeName === 'string';
}

function addClasses(el, classNames) {
  classNames.forEach(function (className) {
    el.classList.add(className);
  });
}

function removeClasses(el, classNames) {
  classNames.forEach(function (className) {
    el.classList.remove(className);
  });
}

},{}],7:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = throwIfMissing;
function throwIfMissing() {
  throw new Error('Missing parameter');
}

},{}]},{},[5]);A17.Behaviors.accordion = function(node) {
  var titles = node.querySelectorAll('[data-accordion-title]');
  var closeLinks = node.querySelectorAll('[data-accordion-close]');
  $.each(titles, function(v) {
    v.addEventListener('click', function(event) {

      event.preventDefault();

      var only = $(v).attr("data-only");
      // Restrict by a media query
      if (only) {
          var mq = A17.Helpers.get_media_query_in_use();
          if (mq !== only) {
              return false;
          }
      }

      if(A17.Helpers.hasClass(v.parentNode, 'open')) {
        $(v.parentNode).removeClass('open');
      } else {
        $(v.parentNode).addClass('open');
      }
    });
  });

  $.each(closeLinks, function(v) {
    v.addEventListener('click', function(event) {
      event.preventDefault();
      $($('#' + $(v).attr('data-accordion-title-id'))[0].parentNode).removeClass('open');
    });
  });
  
	if (window.location.hash.length) {
		$(window.location.hash+'-accordion').addClass('open');
	}

};A17.Behaviors.advanced_search = function() {
	var advanced = document.getElementById('advanced-search');
	var searchAgain = document.getElementById('search-again');
	var advancedText = document.getElementById('advanced-search-options');
	var advancedClose = document.getElementById('advanced-search-close');
	var primaryNav = document.querySelector("[data-behavior='primary_nav']");
	var navSearchInput = document.getElementById('sidebar-search');

	function getSearchParam(param){
		var searchString = window.location.search.substring(1);
    	var variableArray = searchString.split('&');
    	
    	for(var i = 0; i < variableArray.length; i++){
			
			var keyValuePair = variableArray[i].split('=');
			
			if(keyValuePair[0] == param){
				return keyValuePair[1];
			}
		}
	}

	var searchParam = getSearchParam('q');

	$(advanced).on('click', function() {
		$(advancedText).addClass('visible');
	});

	$(advancedClose).on('click', function() {
		$(advancedText).removeClass('visible');
	});

	$(searchAgain).on('click', function() {

		$(primaryNav).addClass('primary-nav--searching');
		// navSearchInput.value = searchParam;
		navSearchInput.focus();
	});
};A17.Behaviors.article_comments = function(node) {

	Mura(function(){
		Mura.processDisplayObject(Mura('div[data-object="comments"]'),false).then(function() {
			var commentsToggle = document.getElementById('comments-toggle');
			if (commentsToggle != null) {
				commentsToggle.addEventListener('click', function(e) {
					// init'ing comments logic
					A17.Helpers.comments();
				});

				//Display comments when comments count bubble is clicked
				var commentsCountBubble = document.querySelectorAll('.comments-count-bubble');
				$.each(commentsCountBubble, function(ccb) {
					$(ccb).on('click', function(e) {
						var eventListenerCallee = arguments.callee;

						commentsToggle.click();
						ccb.removeEventListener("click", eventListenerCallee);
					});
					
				});


				var commentsHashHandler = function(){
					var hash = window.location.hash;
					if (hash.length > 0 && hash.indexOf("comment-") > 0) {
						var comment = hash.replace("#comment-", "");
						if (comment.indexOf('-') > 0) {
							var pageno =  comment.substring(0, comment.indexOf('-'));
							var commentid = comment.replace(pageno+'-', '')

							$("#comments").addClass('is-active');
							$(commentsToggle).addClass('is-active');

							A17.Helpers.comments();
						}
					
					}
				};

				if(window.attachEvent) {
					window.attachEvent('onload', commentsHashHandler);
				} else {
					if(window.onload) {
						var curronload = window.onload;
						var newonload = function() {
							curronload();
							commentsHashHandler();
						};
						window.onload = newonload;
					} else {
						window.onload = commentsHashHandler;
					}
				}
			}
		});
	});

};A17.Behaviors.article_progress = function(node) {
  var _scrollTop = 0, _newScrollTop;
  var bar = node.querySelector('.article-progress__bar');
  var _progressPc = 0;
  var _isHidden = false;
  var bannerFooter = document.querySelector('[data-footer-banner]');
  var blogsNextPrev = document.querySelector('[data-blog-next-previous]');
  function render() {
    _scrollTop = _newScrollTop;

    var pointer = _scrollTop + window.innerHeight;
    var articleTop = window.innerHeight;
    if ( blogsNextPrev ) {
      var articleBottom = blogsNextPrev.offsetHeight + blogsNextPrev.offsetTop + blogsNextPrev.offsetHeight;
    } else if(bannerFooter !== null){
      var articleBottom = bannerFooter.offsetHeight + bannerFooter.offsetTop + bannerFooter.offsetHeight;
    }
    var progressPc = (pointer - articleTop) / (articleBottom - articleTop) * 100;

    if(progressPc < 0) { progressPc = 0; }
    else if(progressPc > 100) { progressPc = 100; }

    if(progressPc !== _progressPc) {
      bar.style.width = progressPc + '%';
      _progressPc = progressPc;
    }

    if(pointer > (articleBottom + 5) && !_isHidden) {
      bar.style.display = 'none';
      _isHidden = true;
    }
    else if(pointer <= (articleBottom + 5) && _isHidden) {
      bar.style.display = 'block';
      _isHidden = false;
    }
  }
  (function animloop() {
    requestAnimFrame(animloop);
    if(_scrollTop !== _newScrollTop || typeof _newScrollTop === 'undefined') {
      render();
    }
  })();

  function setNewScrollTop() {
    _newScrollTop = (document.documentElement.scrollTop||document.body.scrollTop);
  }

  $(window).on('scroll', function() {
    setNewScrollTop();
  });

  $(window).on('resize', function() {
    setNewScrollTop();
    render();
  });
};A17.Behaviors.autocomplete = function () {
	var autocompleteContainer = document.querySelector('.primary-nav__search-results'),
		autocompleteResults = document.querySelector('.primary-nav__search-results-list'),
		searchInput = document.querySelector('.primary-nav__search-input');

	function toggleAutocomplete() {
		if (autocompleteResults.innerHTML != 0 || autocompleteResults.innerHTML !== '') {
			autocompleteContainer.classList.add('primary-nav__search-results--open');
		} else if (autocompleteResults.innerHTML == 0 || autocompleteResults.innerHTML === '') {
			autocompleteContainer.classList.remove('primary-nav__search-results--open');
		}
	}
	searchInput.addEventListener('input', function () {
		while (searchInput.value != 0 || searchInput.value !== '') {
			toggleAutocomplete();
			break;
		}
		while (searchInput.value == 0 || searchInput.value === '') {
			autocompleteResults.innerHTML = null;
			toggleAutocomplete();
			break;
		}
	});
	window.addEventListener('click', function (e) {
		if (e.target.matches('.primary-nav__search-btn') || e.target.matches('.header__search-btn')) {
			searchInput.focus();
		} else if (e.target.matches('.primary-nav__search-close-btn')) {
			searchInput.value = null;
			searchInput.blur();
			autocompleteResults.innerHTML = null;
			toggleAutocomplete();
		}
	}, false);
};A17.Behaviors.blog_slider = function(node) {
  if(A17.browserSpec !== 'html5') {
    return;
  }

  var inner, paginator, slider, width;

  function refreshSelectors() {
    inner = node.querySelector('[data-slider-inner]');
    paginator = node.querySelector('[data-slider-paginator]');
  }

  function init_slider(w) {

    refreshSelectors();

    width = w;

    slides = inner.querySelectorAll('li');
    $.each(slides, function(s) {
      s.style.width = width + 'px';
    });

    slider = (new a17_slider({
      sliderContainer: node,
      sliderInner: inner,
      paginator: paginator,
      slideAmount: width,
      keyControls: false,
      automate: false,
      centered: true
    }));
  }

  function reinit_slider() {
    var new_width = node.offsetWidth;
    if (new_width != width) {
      slider.destroy();
      init_slider(new_width);
    }
  }

  function onWindowResize() {
    if(typeof timer !== 'undefined') {
      clearTimeout(timer);
    }
    timer = setTimeout(function(){
      reinit_slider();
    }, 250);
  }

  $(window).on('resize', onWindowResize);

  init_slider(node.offsetWidth);

};A17.Behaviors.browser_update = function(node) {
  if ( A17.Helpers.cookie_read("acceptCPol") == null ) {
  	$('#cookie-policy').removeClass("browser-update--hide");
	$('#cookie-policy').addClass("browser-update");
  }
  var closeBtn = node.querySelector('[data-browser-update-close]');
  $(closeBtn).on('click', function() {
    $(node).addClass("browser-update--hide");
  });
};A17.Behaviors.btn_dropdown = function(node) {
  var mouseleaveTimeout = null;

  $(node).on('mouseenter', function() {
    $(node).addClass('is-animating');
    if(mouseleaveTimeout !== null) {
      clearTimeout(mouseleaveTimeout);
    }
  }).on('mouseleave', function() {
    mouseleaveTimeout = setTimeout(function() {
      $(node).removeClass('is-animating');
    }, 200);
  });
};A17.Behaviors.cart_description = function (node) {
	var clickToggle = node.querySelector("[data-description-toggle-button]");
	var sectionToggle = node.querySelector("[data-description-toggle-section]");

	$(clickToggle).on('click', function() {
		if (A17.Helpers.hasClass(sectionToggle, 'opening')) {
			$(sectionToggle).removeClass('opening');
			$(sectionToggle).addClass('closing');
		}else {
			$(sectionToggle).removeClass('closing');
			$(sectionToggle).addClass('opening');
		}
	});
}
;
A17.Behaviors.checkout_description = function (node) {
	var clickToggle = node.querySelector("[data-description-toggle-button]");
	var sectionToggle = node.querySelector("[data-description-toggle-section]");

	$(clickToggle).on('click', function() {
		if (A17.Helpers.hasClass(sectionToggle, 'opening')) {
			$(sectionToggle).removeClass('opening');
			$(sectionToggle).addClass('closing');
		} else {
			$(sectionToggle).removeClass('closing');
			$(sectionToggle).addClass('opening');
		}
	});
}
;
A17.Behaviors.child_navs = function(node) {
  var links = node.querySelectorAll('[data-child-navs-link]');

  $.each(links, function(link) {

    link.addEventListener('click', function(event) {
      event.preventDefault();

      if(window.innerWidth >= 1024) {
        return;
      }

      if(A17.Helpers.hasClass(link, 'open')) {
        var childNav = link.parentNode.querySelector('.child-nav');
        $(link).removeClass('open');
        childNav.style.height = null;
      } else {
        $.each(links, function(l) {
          var childNav = l.parentNode.querySelector('.child-nav');
          if(l === link) {
            var childLinksCount = childNav.querySelectorAll('li').length;
            var childNavHeight = (30 * childLinksCount) + 25;
            $(l).addClass('open');
            childNav.style.height = childNavHeight + 'px';
          }
          else {
            $(l).removeClass('open');
            childNav.style.height = null;
          }
        });
      }
    });
  });
};A17.Behaviors.click_trigger = function(node) {
  var $node = $(node);
  $node.on('click', function onNodeClick() {
    var eventName = $node.attr('data-event-name');
    $node.trigger(eventName);
  });
};A17.Behaviors.context_nav = function(node) {
  var $categories = node.querySelectorAll('aside li');
  var $sections = node.querySelectorAll('section');

  $.each($categories, function(v, i) {
    $(v).on('click', function onCategoryClick() {
      $.each($categories, function(vv) { $(vv).removeClass('current'); });
      $($categories[i]).addClass('current');
      $.each($sections, function(vv) { $(vv).removeClass('current'); });
      $($sections[i]).addClass('current');
    });
  });

};A17.Behaviors.cookie_policy = function(node) {
	document.getElementById("cookie_policy_close").addEventListener('click', function() {
       	if ( A17.Helpers.cookie_read("acceptCPol") == null ) {
			A17.Helpers.cookie_create("acceptCPol", true, 10000);
		}
    });
};A17.Behaviors.copy_link = function(node) {

  var input = node.querySelector('[data-copy-link-input]');
  var btn = node.querySelector('[data-copy-link-btn]');
  var icon = btn.querySelector('.icon');

  $(input).on('copy', function() {
    $(node).addClass('is-copied');
    $(node).removeClass('is-active');
    $(icon).addClass('icon--subtle');
    setTimeout(function() {
      $(node).removeClass('is-copied');
    }, 5000);
  });

  $(btn).on('click', function(e) {
    e.preventDefault();
    A17.Helpers.toggleClass(node, 'is-active');
    A17.Helpers.toggleClass(icon, 'icon--subtle');
    setTimeout(function() {
      if(typeof jQuery !== 'undefined') {
        if(A17.Helpers.hasClass(node, 'is-active')) {
          jQuery(input).focus();
          setTimeout(function() {
            jQuery(input).select();
          }, 20);
        }
      }
    }, 20);
  });
};A17.Behaviors.csrf_token_update = function (node) {
	var tokenInput = node.querySelector('[name=csrf_token]'),
		tokenExpiresInput = node.querySelector('[name=csrf_token_expires]'),
		signinClick = document.querySelector('#signin-click'),
		sRedirectURL = node.querySelector('[name=sRedirectURL]');
	signinClick.addEventListener('click', function () {
		if (tokenInput && tokenExpiresInput) {
			Mura.post(Mura.apiEndpoint + '?method=generateCSRFTokens', {
				context: 'flyoutlogin',
				siteid: Mura.siteid
			}).then(function (result) {
				tokenInput.value = result.data.csrf_token;
				tokenExpiresInput.value = result.data.csrf_token_expires;
			});

			Mura.post(Mura.apiEndpoint + '?method=findone', {
				entityname: 'content',
				siteid: Mura.siteid,
				id: Mura.contentid
			}).then(function (result) {
				sRedirectURL.value = result.data.url;
			});
		} else {
			return false;
		}
	});
};/*
*
*  Loads and begin KRUX interchange GPT
*
*/
'use strict';

	window.Krux||((Krux=function(){Krux.q.push(arguments);}).q=[]);

	(function(){

	"use strict";

		A17.loadScript('//cdn.krxd.net/controltag/Jn7TXKj3.js',function(){
		function retrieve(n){
				var m, k='kx'+n;

				if (window.localStorage) {
					return window.localStorage[k] || "";

				} else if (navigator.cookieEnabled) {
					m = document.cookie.match(k+'=([^;]*)');
					return (m && unescape(m[1])) || "";
				} else {
					return '';
				}

			}

			Krux.user = retrieve('user');
			Krux.segments = retrieve('segs') && retrieve('segs').split(',') || [];

		});

	})();

	/**
	 * Google DFP Ads
	 *
	 */


	var dfp	= {},
		googletag = window.googletag || {cmd: []};

	A17.loadScript('//www.googletagservices.com/tag/js/gpt.js',function(){});

    /**
     * checks for the adtype params is in the url
     * @param {srtring} adtype
     */
    function check_for_queryParams(url){
        var query_params = url.search != ''?url.search:'';
        return (query_params && url.search.match(/adtype=([^&]*)/) ? url.search.match(/adtype=([^&]*)/)[1].replace(/[0-9]|%/g, '') : '');
    }
	var DFP_targeting = {
		adtype: check_for_queryParams(window.location),
		type: dataLayer[0].content.category.contentType,
		subject: dataLayer[0].content.category.contentSubType1,
		category: dataLayer[0].content.attributes.subjects,
		kwrd: dataLayer[0].content.category.contentType === "Store" ? "nointerstitial" : dataLayer[0].content.attributes.keywords,
		logged: (dataLayer[0].session.authentication.loginStatus == "logged out" ? 'n' : 'y'),
		title: dataLayer[0].content.contentInfo.title,
		doi: (dataLayer[0].content.article != null ? (dataLayer[0].content.article.doi != null ? dataLayer[0].content.article.doi : "") : ""),
		user: [dataLayer[0].user[0].segment.commented, dataLayer[0].user[0].segment.subscriberMind, dataLayer[0].user[0].segment.subscriberSA, dataLayer[0].user[0].segment.customer]
	};

	/**
	 * Checks user view port
	 * @param {srtring} element id
	 */

     dfp.inViewport = function(element) {
         var element_size, client_window;

         if ( !element || 1 !== element.nodeType ) { return false; }
         client_window = document.documentElement;
         element_size = element.getBoundingClientRect();

         return ( !!element_size
           && element_size.bottom >= 0
           && element_size.right  >= 0
           && element_size.top    <= client_window.clientHeight
           && element_size.left   <= client_window.clientWidth
         );
     }

	dfp.init = function(){
		var arr = [];
		ad1 = document.getElementById("div-gpt-ad-top-1-child");
		if (ad1 !== null) {
			arr.push(ad1);
		}
		ad2 = document.getElementById("div-gpt-ad-interstitial-1-child");
		if (ad2 !== null) {
			arr.push(ad2);
		}

		googletag.cmd.push(function() {
		  for(var i =0; i < arr.length; i++){
			 var displayAds= arr[i].getAttribute('data-dfp-adContainer');
			 googletag.display(displayAds);
		  }
		});
	}

	dfp.targeting = DFP_targeting;

	dfp.get_screen_size = function(screenWidth) {
		if (screenWidth > 1023) {
			return "desktop";
		}
		else if (screenWidth <= 1023 && screenWidth > 767) {
			return "tablet";
		}
		else {
			return "mobile";
		}
	}

	// refresh Ads on screen resize
	dfp.screen_size = dfp.get_screen_size(window.innerWidth);
	dfp.targeting['screen_size'] = dfp.screen_size;

	window.addEventListener("resize", function(){
		var newSize = dfp.get_screen_size(window.innerWidth);
		if (newSize != dfp.screen_size) {
			dfp.screen_size = newSize;
			googletag.cmd.push(function() {
				googletag.pubads().refresh();
			});
		}
	});

	/**
	 * Ads specifications
	 *
	 */
	var gptadslots=[];
	dfp.adslots = {};
	var adUnit1 = "/270604982/sciam";
	var adUnit2 = "";
	var adUnit3 = "";
	var title = dataLayer[0].content.contentInfo.title.replace('&', 'and').replace('@', 'at').replace(',', '').replace(/[ ]/g,'-');

    if ("arabic,espanol,blogs".indexOf(mura.siteid) !== -1) {
		adUnit1 = adUnit1  + "/" + mura.siteid;
	}

	if (dataLayer[0].content.contentInfo.title == "About Scientific American") {
		adUnit2 = "/about";
	}
	else if (dataLayer[0].content.category.subjectType != "") {
		adUnit2 = "/" + dataLayer[0].content.category.subjectType.replace(/[ ]/g,'-');
		if (dataLayer[0].content.category.subjectSubType1 != "") {
			adUnit3 = "/" + dataLayer[0].content.category.subjectSubType1.replace('&', 'and').replace(',', '').replace(/[ ]/g,'-');
		}
	}
	else {
		switch(dataLayer[0].content.category.contentType){
			case "Home":
				adUnit2 = "/home";
				break;
			case "BlogsHome":
				break;
			case "Search":
				adUnit2 = "/search";
				break;
			case "VideoSeries":
				adUnit2 = "/video";
				break;
			case "PodcastSeries":
				adUnit2 = "/podcasts/" + title;
				break;
			default:
				if (dataLayer[0].content.contentInfo.title != '') {
					if (["K-12", "Higher Ed", "Lifelong Learning", "Careers", "Citizen Science", "Bring Science Home", "SA at the Google Science Fair"].indexOf(dataLayer[0].content.contentInfo.title) > -1) {
						adUnit2 = "/education/" + title;
					}
					else {
						adUnit2 = "/" + title;
					}
				}
		}
	}
	

	dfp.adUnit = adUnit1 + adUnit2.toLowerCase() + adUnit3.toLowerCase();

	dfp.top = {
		sizes : "[320, 50]",
		name: "div-gpt-ad-top-",
		count : 0
	};

	dfp.middle = {
		sizes : "[320, 50]",
		name: "div-gpt-ad-middle-",
		count : 0
	};

	dfp.right = {
		sizes : "[300, 250]",
		name: "div-gpt-ad-right-",
		count : 0
	};

	dfp.right2 = {
		sizes : "[300, 250]",
		name: "div-gpt-ad-right2-",
		count : 0
	};

	dfp.slideshow = {
		sizes : "[300, 250]",
		name: "div-gpt-ad-slideshow-",
		count : 0
	};

	googletag.cmd.push(function() {
		dfp.top.mapping = googletag.sizeMapping().
			addSize([1, 1 ], [320, 50]).
			addSize([767, 1 ], [728, 90]).
			addSize([1023, 1 ], [[728, 90], [970, 90]]).
			build();

		dfp.middle.mapping = googletag.sizeMapping().
			addSize([1, 1 ], [320, 50]).
			addSize([767, 1 ], [728, 90]).
			addSize([1023, 1 ], [[728, 90], [970, 90], [970, 250]]).
			build();

		dfp.right.mapping = googletag.sizeMapping().
			addSize([1023, 1 ], [[300, 250], [300, 600]]).
			addSize([767, 1 ], [[300, 250], [300, 600]]).
			addSize([1, 1 ], [300, 250]).
			build();

		dfp.right2.mapping = googletag.sizeMapping().
			addSize([1023, 1 ], [300, 250]).
			addSize([767, 1 ], [300, 250]).
			addSize([1, 1 ], [300, 250]).
			build();

		dfp.slideshow.mapping = googletag.sizeMapping().
			addSize([1023, 1 ], [300, 250]).
			addSize([767, 1 ], [300, 250]).
			addSize([1, 1 ], [300, 250]).
			build();

			gptadslots[0] = googletag.defineSlot(dfp.adUnit, [300, 50], 'div-gpt-ad-top-1').defineSizeMapping(dfp.top.mapping).setTargeting('pos',['LB1']).addService(googletag.pubads());

			gptadslots[1] = googletag.defineOutOfPageSlot(dfp.adUnit, 'div-gpt-ad-interstitial-1').addService(googletag.pubads());
		/*
		* All page-level DFP Custom Tagging goes here
		*/
		googletag.pubads()
			.setTargeting('adtype', dfp.targeting['adtype'])
			.setTargeting('type', dfp.targeting['type'])
			.setTargeting('subject', dfp.targeting['subject'])
			.setTargeting('category', dfp.targeting['category'])
			.setTargeting('title', dfp.targeting['title'])
			.setTargeting('kwrd', dfp.targeting['kwrd'])
			.setTargeting('logged', dfp.targeting['logged'])
			.setTargeting('doi', dfp.targeting['doi'])
			.setTargeting('user', dfp.targeting['user']);

		googletag.pubads().setTargeting("ksg", Krux.segments);
		googletag.pubads().setTargeting("kuid", Krux.user);

		googletag.pubads().enableSingleRequest();
		googletag.pubads().enableAsyncRendering();
		googletag.enableServices();
	});

	/**
	 * Takes the ads specifications and loads them on scroll
	 *
	 * @param {srtring} adName The ad name
	 * @param {srtring} positionName The ad position
	 * @param {srtring} adContainer The ad class name
	 * @param {string}  adOffset The distance from the window lower edge to the element
	 */

	dfp.pushAds = function(adName, positionName, adContainer) {
		dfp[adName].count++;
		var slotName	= dfp[adName].name + dfp[adName].count;
		var adSlotDiv	= document.createElement('div');
			adSlotDiv.id= slotName;
			document.getElementById(adContainer).appendChild(adSlotDiv);

			if (positionName == "") {
				positionName = (adName == "middle" ? "LB2" : adName)+dfp[adName].count;
			}

		googletag.cmd.push(function() {
			gptadslots.push(googletag.defineSlot(dfp.adUnit, dfp[adName].sizes, slotName).
			defineSizeMapping(dfp[adName].mapping).
			setTargeting('pos',[positionName]).
			addService(googletag.pubads()));

			dfp.adslots[positionName] = googletag.display(slotName);
		});

	}

	dfp.loadAds = function(adName, positionName, adContainer, node) {
		var isAdActive = false;

		if(node === undefined){
			node = document.querySelector('#'+ adContainer +'');
		}

		if(dfp.inViewport(node) && !isAdActive) {
			isAdActive = true;
			dfp.pushAds(adName, positionName, adContainer);
		}

		window.addEventListener('scroll', function() {
			if(!isAdActive) {
				isAdActive = true;
				dfp.pushAds(adName, positionName, adContainer);
			}
		});
	}

	dfp.init();

A17.Behaviors.dfp = function(node) {
	/**
	* we grad the specifications for each add and fetch them
	*
	*/
	adName				= node.getAttribute('data-dfp-adName'),
	isMobileOnly		= (node.getAttribute('data-dfp-mobileonly') != null ? true : false),
	isDesktopOnly		= (node.getAttribute('data-dfp-desktoponly') != null ? true : false),
	adContainer	 		= node.getAttribute('data-dfp-adContainer'),
	positionName		= node.getAttribute('data-dfp-positionName');

	if (isMobileOnly || isDesktopOnly) {
		if ((isMobileOnly && dfp.screen_size === 'mobile') || (isDesktopOnly && dfp.screen_size === 'desktop')) {
			dfp.loadAds(adName, positionName,adContainer,node);
		}
	}
	else {
		dfp.loadAds(adName, positionName,adContainer,node);
	}
};A17.Behaviors.dfp_article_rendering = function (node) {
	var adword = node.getAttribute('data-dfp-adword');
	function getChildElements(element, target) {
		var paragraph = [],
			children = element.children[0] !== undefined && element.children[0].querySelector('.mura-region-local') !== null ? element.children[0].querySelector('.mura-region-local').childNodes : null;
		if (children !== null) {
			for (var i = 0; i < children.length; i++) {
				if (children[i].nodeName === target) {
					paragraph.push(children[i]);
				} else if (children[i].className === target) {
					paragraph.push(children[i]);
				}
			}
		}
		return paragraph;
	}

	function addDfpSlots() {
		var _paragraphs = document.querySelector('.article-text'),
			paragraphs_array = getChildElements(_paragraphs, 'P'),
			count_0 = 0,
			count_1 = 0;
		for (var i = 2; i < paragraphs_array.length; i += 5) {
			count_0++;
			if (count_0 <= 5) {
				var dfp_template = '<figure class="aside-banner aside-banner__article-bottom dfp-article-ad">' + '<div class="dfp-article" id="dfp-right2-article-' + count_0 + '"></div>' +
								   '<figcaption class="aside-banner__label">' + adword + '</figcaption>' +
								   '</figure>';

				paragraphs_array[i].insertAdjacentHTML('afterend', dfp_template);
			}
		}

		for (var j = 0; j < getChildElements(_paragraphs, 'aside-banner aside-banner__article-bottom dfp-article-ad').length; j++) {
			count_1++;
			var script = document.createElement('script');
			script.innerHTML = 'dfp.loadAds("right2","MPU' + (count_1 + 1) + '","dfp-right2-article-' + count_1 + '")';
			getChildElements(_paragraphs, 'aside-banner aside-banner__article-bottom dfp-article-ad')[j].firstChild.appendChild(script);
		}
	}
	addDfpSlots();
};
// Removing the rendered Ads in when front-end editing
Mura(document).on('muraBeforeContentSave', function () {
	Mura('.dfp-article-ad').remove();
});A17.Behaviors.enable_hamburger = function (node) {
	var primaryNav = document.querySelector('.primary-nav'),
		searchBar = document.querySelector('.primary-nav__search'),
		searchInput = document.querySelector('.primary-nav__search-input'),
		searchAutoCompleteResultsContainer = document.querySelector('.primary-nav__search-results'),
		searchAutoCompleteResults = document.querySelector('.primary-nav__search-results-list'),
		subscribeBtn = document.querySelector('.subscribe-nav-btn'),
		searchBtn = document.querySelector('.header__search-btn'),
		supportEls = ['.header__menu-btn', '.primary-nav__close-btn', '.primary-nav__list--drawer-utils', '.primary-nav__list--social', '.primary-nav__bg'];

	function applyBurger() {
		supportEls.forEach(function (el) {
			var selectedEls = document.querySelector(el);
			selectedEls.classList.remove('large-up-hide');
		});
		subscribeBtn.classList.add('hide');
		primaryNav.classList.remove('primary-nav');
		primaryNav.classList.add('primary-nav--store');
		// clear the search bar when applying burger menu
		searchBar.classList.remove('primary-nav__search--open');
		searchInput.value = null;
		searchInput.blur();
		searchAutoCompleteResultsContainer.classList.remove('primary-nav__search-results--open');
		searchAutoCompleteResults.innerHTML = null;

		if (A17.media_query_in_use === 'large') {
			searchBtn.classList.add('hide');
		}
	}

	function disableBurger() {
		supportEls.forEach(function (el) {
			var selectedEls = document.querySelector(el);
			selectedEls.classList.add('large-up-hide');
		});
		subscribeBtn.classList.remove('hide');
		primaryNav.classList.remove('primary-nav--store');
		primaryNav.classList.add('primary-nav');

		if (A17.media_query_in_use === 'large') {
			searchBtn.classList.remove('hide');
		}
	}

	function enableHamburger() {
		if (node.classList.contains('is-sticky') || node.classList.contains('is-end')) {
			applyBurger();
		} else {
			disableBurger();
		}
	}
	window.addEventListener('scroll', debounce(enableHamburger, 0, true));
};A17.Behaviors.expired_promo_redirect = function	() {
	function getUrlParameter(name) {
		name = name.replace(/[[]/, '\\[').replace(/[\]]/, '\\]');
		var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
		var results = regex.exec(location.search);
		return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
	}

	if (location.search) {
		if (getUrlParameter('expired')) {
			var expired_msg = document.querySelector('div.expired');
			$(expired_msg).removeClass('browser-update--hide');
			$(expired_msg).addClass('browser-update');
		}
	}
};A17.Behaviors.filter_change = function(node) {
  if ( sessionStorage !== 'undefined' ) {

  	$(node).on('change', function() {
  		// get filter value
  		var filter = node.querySelector("input");
  		var filterName = filter.name;

  		// get page context
  		var filterPageContext = filter.dataset.filterPageContext;

      var filterToSet = filterPageContext + "." + filterName;
      var pageToSet = filterPageContext + "." + "page";

  		// set item in session storage
  		sessionStorage.setItem(filterToSet.toUpperCase(), encodeURIComponent(filter.value));
      sessionStorage.setItem(pageToSet.toUpperCase(), encodeURIComponent(1));

  		// create a cookie with the filter value
  		A17.Helpers.cookie_create(filterToSet.toUpperCase(), encodeURIComponent(filter.value));
      A17.Helpers.cookie_create(pageToSet.toUpperCase(), encodeURIComponent(1));
  	});
  }
};A17.Behaviors.filter_remove = function(node) {
  if ( sessionStorage !== 'undefined' ) {

  	$(node).on('click', function() {

  		// get page context
  		var filterPageContext = node.dataset.filterPageContext;

  		// get filter
  		var filterToRemove = filterPageContext + "." + node.href.split("=")[1];
      var pageToSet = filterPageContext + "." + "page";

  		sessionStorage.removeItem(filterToRemove.toUpperCase());
      sessionStorage.removeItem(pageToSet.toUpperCase());
      
  		A17.Helpers.cookie_delete(filterToRemove.toUpperCase());
      A17.Helpers.cookie_delete(pageToSet.toUpperCase());
  	});
  }
};A17.Behaviors.footer_reveal = function(node) {
  $(node).on('click', function(event) {
    event.preventDefault();
    $('#footer .grid__col').removeClass('medium-down-hide');
    $('#footer .grid__col').addClass('medium-two');
    $('[data-footer-reveal-parent]').addClass('hidden');
  });
};A17.Behaviors.ga_sku_label_update = function (node) {
	var productOptionForm = node.parentElement,
		ogDataTrackLabel = node.getAttribute('data-track-label');

	function updateSku(e) {
		var productSelection = e.target;

		if (productSelection.nodeName === 'INPUT') {
			var updatedSkuId = productSelection.value,
				updatedDataTrackLabel = ogDataTrackLabel.replace(/paywall-\w*/i, 'paywall-' + updatedSkuId);
			node.setAttribute('data-track-label', updatedDataTrackLabel);
		}
	}
	// listen for changes in product options, update GA data-track-label SKU on change
	productOptionForm.addEventListener('click', updateSku, false);
};A17.Behaviors.info_tooltip = function(node) {
  var $node = $(node);
  var tooltipId = $node.attr('data-tooltip-id');

  $node.on('mouseenter', function() {
    $('.info-tooltip').removeClass('open');
    $('.info-tooltip').removeClass('visible');
    $('[data-behavior^="info_tooltip"]').removeClass('open');

    var $tooltip = $('#' + $node.attr('data-tooltip-id'));
    var tooltip = $tooltip[0];
    $tooltip.addClass('open');
    $node.addClass('open');

    setTimeout(function() {

      var offsetLeft = node.getBoundingClientRect().left + document.body.scrollLeft;
      var offsetTop = node.getBoundingClientRect().top + (document.documentElement.scrollTop||document.body.scrollTop);

      var tooltipOffsetX = node.offsetWidth / 2;

      var tooltipOffsetY = -(tooltip.offsetHeight) - 25;

      var outer = document.querySelectorAll('.tooltip-outer[data-tooltip="' + tooltipId + '"]')[0];
      if(typeof outer === 'undefined') {
        outer = A17.Helpers.closest(node, function(el) {
          return A17.Helpers.hasClass(el, 'tooltip-outer');
        });
      }

      var outerLeft = outer.getBoundingClientRect().left + document.body.scrollLeft;
      var outerTop = outer.getBoundingClientRect().top + (document.documentElement.scrollTop||document.body.scrollTop);

      var tooltipLeft = (offsetLeft + tooltipOffsetX - outerLeft);
      var tooltipTop = (offsetTop + tooltipOffsetY - outerTop);

      tooltip.style.left = tooltipLeft + 'px';
      tooltip.style.top = tooltipTop + 'px';

      setTimeout(function() {
        $tooltip.addClass('visible');
      }, 20);
    }, 20);

  }).on('mouseleave', function() {
    $('.info-tooltip').removeClass('visible');
    setTimeout(function() {
      $('.info-tooltip').removeClass('open');
    }, 300);
    $('[data-behavior^="info_tooltip"]').removeClass('open');
  });
};A17.Behaviors.infographic = function(node) {

  if(A17.browserSpec !== 'html5') {
    return;
  }

  A17.Helpers.load_jquery(function($) {
    A17.Helpers.load_jquery_panzoom(function() {

      var $btn = $(node);
      var infographicId = $btn.data('infographic-id');
      var $infographic = $('#' + infographicId);
      var $image = $infographic.find('[data-infographic-image]');
      var $closeBtn = $infographic.find('[data-infographic-close]');

      $btn.on('click', function(e) {
        e.preventDefault();

        $('html').addClass('is-slideshow-open');
        $infographic.fadeIn(function() {
          $image.panzoom({
            '$zoomIn': $infographic.find('[data-infographic-zoomin]'),
            '$zoomOut': $infographic.find('[data-infographic-zoomout]'),
            '$zoomRange': $infographic.find('[data-infographic-zoomrange]'),
            minScale: 1,
            contain: 'invert'
          });
        });
        setTimeout(function() {
          $infographic.addClass('is-open');
        }, 20);
      });

      $closeBtn.on('click', function(e) {
        e.preventDefault();
        $('html').removeClass('is-slideshow-open');
        $infographic.removeClass('is-open');
        window.location.hash = '';
        $infographic.fadeOut(function() {
          $infographic.panzoom('destroy');
        });
      });

      $infographic.find('[data-copy-link-input]').val(A17.Helpers.get_url_without_hash() + '#' + infographicId);

      if(window.location.hash === ('#' + infographicId)) {
        $btn.triggerHandler('click');
      }

    });
  });
};

/* A17.Behaviors.infographic = function(node) {
  var range = node.querySelector('[data-infographic-range]');
  var imageContainer = node.querySelector('[data-infographic-image]');
  var naturalWidth = $(imageContainer).attr('data-infographic-width');
  var naturalHeight = $(imageContainer).attr('data-infographic-height');
  var containerWidth, containerHeight, originX, originY, dragX, dragY, sliderValue = 0;
  var isMouseDown = true;

  var linearScale = function ( domain, range ) {
		var d0 = domain[0], r0 = range[0], multiplier = ( range[1] - r0 ) / ( domain[1] - d0 );

		// special case
		if ( r0 === range[1] ) {
			return function () {
				return r0;
			};
		}

		return function ( num ) {
			return r0 + ( multiplier * ( num - d0 ) );
		};
	};

  function render() {
    // Size scale
    var initialScale = containerHeight / naturalHeight * 100;
    var scaleDomain = [initialScale, 100];
    var scaleRange = [100, (naturalHeight / containerHeight * 100)];
    var imageScale = linearScale(scaleDomain, scaleRange);
    var scaleValue = initialScale + ((100 - initialScale) / 10 * sliderValue);
    var backgroundSize = imageScale(scaleValue);

    // Position scale
    var xPositionDomain = [0, naturalWidth / scaleValue];
    var yPositionDomain = [0, naturalHeight / scaleValue];
    var positionRange = [0, 100];
    var xPositionScale = linearScale(xPositionDomain, positionRange);
    var yPositionScale = linearScale(yPositionDomain, positionRange);

    // Calculate the virtual x/y pixel positions
    // debugger;


    var backgroundPositionXPc = xPositionScale();
    var backgroundPositionYPc = yPositionScale();

    // Set DOM
    imageContainer.style.backgroundSize = 'auto ' + backgroundSize + '%';
    imageContainer.style.backgroundPosition = '';
  }

  function cacheResizeDimensions() {
    containerWidth = imageContainer.offsetWidth;
    containerHeight = imageContainer.offsetHeight;
  }

  function onRangeChange() {
    sliderValue = this.value;
    render();
  }

  $(imageContainer).on('mousedown', function(e) {
    originX = e.clientX;
    originY = e.clientY;
    isMouseDown = true;
    render();
  });

  $(imageContainer).on('mousemove', function(e) {
    if(!isMouseDown) return;
    dragX = e.clientX;
    dragY = e.clientY;

  });

  $(range).on('change', onRangeChange);
  $(range).on('mousemove', onRangeChange);

  $(window).on('resize', function() {
    cacheResizeDimensions();
    render();
  });

  cacheResizeDimensions();
  render();
}; */
;
A17.Behaviors.issue_scroll = function(node) {
	var hash = window.location.hash;
	if (hash.length > 0 && hash.indexOf("article-") > 0) {
		var urltitle = hash.replace("#", '');
		A17.Helpers.scroll.To(urltitle);

	}
};A17.Behaviors.lightbox = function(node) {
  if(A17.browserSpec !== 'html5') {
    return;
  }

  A17.Helpers.load_jquery(function($) {

    var $btn, $lightbox, $inner, $paginator, $grid, relatedIndex;
    var slider;
    var width, slides, total;
    var starting_position = getSlideFromHash() || 1;
    var originalCaptions = { };

    refreshSelectors();

    $btn.on('click', function(e) {
      e.preventDefault();
      $('html').addClass('is-slideshow-open');
      $lightbox.css('display', 'block');
      onLightboxOpen();
      $lightbox.addClass('is-open');
    });

    moveToHash();

    if(getSlideFromHash()) {
      $btn.triggerHandler('click');
    }

    $(window).on('hashchange', function() {
      moveToHash();
    });

    function getSlideFromHash() {
      var slidePrefix = '#slide-';
      if(window.location.hash.substr(0, slidePrefix.length) === slidePrefix) {
        var hashSlideNumber = parseInt(window.location.hash.replace(slidePrefix, ''), null);
        return hashSlideNumber;
      }
    }

    function moveToHash() {
      var hashSlideNumber = getSlideFromHash();
      if(!isNaN(hashSlideNumber) && hashSlideNumber !== starting_position) {
        var new_width = $lightbox[0].offsetWidth;
        slider.destroy();
        starting_position = hashSlideNumber;
        init_slider(new_width);
      }
    }

    function refreshSelectors() {
      $btn = $(node);
      $lightbox = $('#' + $btn.data('lightbox-id'));
      $inner = $lightbox.find('[data-slider-inner]');
      $paginator = $lightbox.find('[data-slider-paginator]');
      $grid = $lightbox.find('[data-slider-grid]');
    }

    function onLightboxOpen() {

      $(window).on('resize', onWindowResize);

      $lightbox[0].addEventListener("slider_destroyed", function(event) {
        starting_position = event.data.currentSet;
      });

      $lightbox[0].addEventListener("slider_moved", onSliderMoved);

      init_slider($lightbox[0].offsetWidth);

    }

    function init_slider(w) {

      refreshSelectors();

      width = w * 0.6;
      slides = $inner.find('li');
      slides.each(function(i, s) {
        s.style.width = width + 'px';
      });

      relatedIndex = $lightbox.find('[data-slider-related]').index();

      if(typeof itemCount === 'undefined') {
        total = $lightbox.find('[data-slider-index]').length;
      }

      slider = new a17_slider({
        sliderContainer: $lightbox[0],
        sliderInner: $inner[0],
        paginator: $paginator[0],
        slideAmount: width,
        currentSet: starting_position,
        centered: true,
        automate: false,
        keyControls: false
      });

      $('[data-copy-link-input]').val(A17.Helpers.get_url_without_hash() + '#slide-' + starting_position);

      // A17.Behaviors.copy_link($('.copy-link')[0]);

      // Update current index
      var count = starting_position;
      if(count < 10) {
        count = '0' + count.toString();
      }
      $lightbox.find('[data-slider-count]').html(count);

      // Update total
      if(total < 10) {
        total = '0' + total.toString();
      }
      $lightbox.find('[data-slider-total]').html(total);

      // Clamp captions once fonts are loaded
      $(document).off('font-loaded:benton-normal-normal');
      if(!$('html').hasClass('benton-normal-normal-loaded')) {
        $(document).on('font-loaded:benton-normal-normal', function() {
          clampCaptions();
        });
      } else {
        clampCaptions();
      }

    }

    function reinit_slider() {
      var new_width = $lightbox[0].offsetWidth;
      if (new_width * 0.6 != width) {
        slider.destroy();
        init_slider(new_width);
      }
    }

    function onSliderMoved(event) {

      currentPosition = event.data.currentSet;

      // setTimeout(function() {

        var $currentEl = $lightbox.find('.a17s_visible[data-a17slider-position="' + (event.data.currentSet - 1) + '"]').eq(0);

        // Update current index
        var count = $currentEl.data('a17slider-position');
        if(typeof count !== 'undefined') {
          count = parseInt(count, null) + 1;
          if(count < 10) {
            count = '0' + count.toString();
          }
          $lightbox.find('[data-slider-count]').html(count);
        }

        // Close copy link
        $('.copy-link').removeClass('is-active');
        $('[data-copy-link-btn] .icon').addClass('icon--subtle');

        // Update value
        $('[data-copy-link-input]').val(A17.Helpers.get_url_without_hash() + '#slide-' + event.data.currentSet);

      // }, 200);

      // Close all captions
      var $captions = $lightbox.find('[data-slider-caption]');
      $captions.each(function(i, caption) {
        var $caption = $(caption);
        if(typeof $caption.data('open') === 'undefined') {
          $caption.data('open', false);
        }
        if($caption.data('open')) {
          $caption.parent().removeClass('open');
          $caption.data('open', false);
          $clamp(caption, {clamp: 2, useNativeClamp: false});
        }
      });

      // See if it's the related slide
      if((event.data.currentSet - 1) === relatedIndex) {
        $lightbox.addClass('is-related-visible');
      }
      else {
        $lightbox.removeClass('is-related-visible');
      }
    }

    function onCaptionContainerClick(e) {
      e.preventDefault();

      refreshSelectors();

      var $caption = $(this).find('[data-slider-caption]');
      var caption = $caption[0];
      var currentIndex = $lightbox.find('.a17s_visible').eq(0).data('a17slider-position');

      if(typeof $caption.data('open') === 'undefined') {
        $caption.data('open', false);
      }
      if($caption.data('open')) {
        // Close it
        $caption.parent().removeClass('open');
        $caption.data('open', false);
        $clamp(caption, {clamp: 2, useNativeClamp: false});
      }
      else {
        // Open it
        $caption.attr('style', null);
        caption.innerHTML = originalCaptions[currentIndex];
        $caption.parent().addClass('open');
        $caption.data('open', true);
      }
    }

    function onGridItemClick() {
      var index = parseInt($(this).attr('data-slider-grid-item'), null);
      $lightbox.removeClass('is-grid-visible');
      $grid.fadeOut(200, function() {
        slider.move(index + 1);
      });
    }

    function onGridBtnClick(e) {
      e.preventDefault();
      $grid.fadeIn(200);
      $lightbox.addClass('is-grid-visible');
    }

    function onCloseBtnClick(e) {
      e.preventDefault();
      $('html').removeClass('is-slideshow-open');
      $lightbox.removeClass('is-grid-visible');
      $lightbox.removeClass('is-open');
      window.location.hash = '';
      setTimeout(function() {
        $lightbox.css('display', '');
        if(typeof slider.destroy === 'function') {
          slider.destroy();
          $(window).off('resize', onWindowResize);
        }
      }, 200);
    }

    function clampCaptions() {
      $inner.find('li').each(function(i, s) {
        var caption = s.querySelector('[data-slider-caption]');
        if(caption === null) {
          return true;
        }

        var $caption = $(caption);
        if(typeof originalCaptions[i] === 'undefined') {
          originalCaptions[i] = $caption.html();
        }
        $clamp(caption, {clamp: 2, useNativeClamp: false});
      });
    }

    function onWindowResize() {
      if(typeof timer !== 'undefined') {
        clearTimeout(timer);
      }
      timer = setTimeout(function(){
        reinit_slider();
      }, 250);
    }

    $lightbox.on('click', '[data-slider-caption-container]', onCaptionContainerClick);
    $lightbox.on('click', '[data-slider-gridbtn]', onGridBtnClick);
    $lightbox.on('click', '[data-slider-grid-item]', onGridItemClick);
    $lightbox.on('click', '[data-slider-close]', onCloseBtnClick);

  });

};A17.Behaviors.media_util_bar = function(node) {
	min$('#form-filter-series [type=radio]').attr('onclick', 'window.location=this.value');
	min$('#form-filter-topic [type=radio]').attr('onclick', 'submit()');
};A17.Behaviors.mobile_search = function(node) {
  var searchBtn = document.querySelector('[data-mobile-search-btn]');
  var closeBtn = node.querySelector('[data-mobile-search-close]');
  var input = node.querySelector('[data-mobile-search-input]');
  var results = node.querySelector('[data-mobile-search-results]');

  searchBtn.addEventListener('click', function() {
    openSearch();
  });

  closeBtn.addEventListener('click', function() {
    closeSearch();
  });

  input.addEventListener('keyup', function() {
    renderResults();
  });

  function renderResults() {
    if(input.value) {
      $(results).addClass('is-populated');
    }
    else {
      $(results).removeClass('is-populated');
    }
  }

  function openSearch() {
    $(node).addClass('is-open');
    setTimeout(function() {
      input.focus();
    }, 20);
  }

  function closeSearch() {
    $(node).removeClass('is-open');
  }
};A17.Behaviors.page_change = function(node) {
  if ( sessionStorage !== 'undefined' ) {

  	$(node).on('click', function() {

      var filterName = "page";

  		// get page value
  		var pageNumber = node.dataset.filterPageNum;

  		// get page context
  		var filterPageContext = node.dataset.filterPageContext;
      var pageToSet = filterPageContext + "." + filterName;

  		// set item in session storage
  		sessionStorage.setItem(pageToSet.toUpperCase(), encodeURIComponent(pageNumber));

  		// create a cookie with the filter value
  		A17.Helpers.cookie_create(pageToSet.toUpperCase(), encodeURIComponent(pageNumber));
  	});
  }
};A17.Behaviors.page_context_nav = function () {
	var pageContextNav = document.querySelector('.page-context-nav'),
		stickyHeader = document.querySelector('.sticky-header'),
		primaryNav = document.querySelector('.primary-nav');

	function toggleContextNav() {
		if (pageContextNav != 'undefined') {
			if (stickyHeader.classList.contains('is-sticky')) {
				pageContextNav.classList.add('is-sticky');
				primaryNav.classList.add('hide');
			} else if (stickyHeader.classList.contains('is-end')) {
				pageContextNav.classList.remove('is-sticky');
			} else {
				pageContextNav.classList.remove('is-sticky');
				primaryNav.classList.remove('hide');
			}
		}
	}
	window.addEventListener('scroll', debounce(toggleContextNav, 0, true), false);
};var isRendered = true;

function plyrSetup() {
  if(typeof plyr !== 'undefined') {
    plyr.setup({
      html: [
        "<div class='player-controls'>",
          "<span class='player-controls-left'>",
              "<button class='play-button' type='button' data-player='play'>",
                  "<svg><use xlink:href='#icon-play'></use></svg>",
                  "<span class='sr-only'>Play</span>",
              "</button>",
              "<button class='pause-button' type='button' data-player='pause'>",
                  "<svg><use xlink:href='#icon-pause'></use></svg>",
                  "<span class='sr-only'>Pause</span>",
              "</button>",
              "<span class='volume-controls'>",
              "<input class='inverted sr-only' id='mute{id}' type='checkbox' data-player='mute'>",
              "<label id='mute{id}' for='mute{id}'>",
                  "<svg class='icon-muted'><use xlink:href='#icon-muted'></use></svg>",
                  "<svg class='icon-volume'><use xlink:href='#icon-volume'></use></svg>",
                  "<span class='sr-only'>Toggle Mute</span>",
              "</label>",
              "<label for='volume{id}' class='sr-only'>Volume</label>",
              "<span class='volume-controls-tooltip'>",
                "<input id='volume{id}' class='player-volume' type='range' min='0' max='10' value='5' data-player='volume'>",
              "</span>",
              "</span>",
              "<span class='player-time'>",
                  "<span class='sr-only'>Current time</span>",
                  "<span class='player-current-time'>00:00</span>",
              "</span>",
          "</span>",
          "<div class='player-progress-container'>",
            "<div class='player-progress-container-inner'>",
              "<div class='player-progress'>",
                  "<label for='seek{id}' class='sr-only'>Seek</label>",
                  "<input id='seek{id}' class='player-progress-seek' type='range' min='0' max='100' step='0.5' value='0' data-player='seek'>",
                  "<progress class='player-progress-played' max='100' value='0'>",
                      "<span>0</span>% played",
                  "</progress>",
                  "<progress class='player-progress-buffer' max='100' value='0'>",
                      "<span>0</span>% buffered",
                  "</progress>",
              "</div>",
            "</div>",
          "</div>",
          "<span class='player-controls-right'>",
          "<span class='player-time'>",
                "<span class='sr-only'>Current time</span>",
                "<span><span class='player-current-time'>00:00</span> /</span>",
            "</span>",
              "<span class='player-time player-time--total'>",
                  "<span class='sr-only'>Duration</span>",
                  "<span class='player-duration'>00:00</span>",
              "</span>",
              "<input class='sr-only' id='captions{id}' type='checkbox' data-player='captions'>",
              "<label class='player-captions-label' for='captions{id}'>",
                  "<svg class='icon-captions-on'><use xlink:href='#icon-captions-on'></use></svg>",
                  "<svg class='icon-captions-off'><use xlink:href='#icon-captions-off'></use></svg>",
                  "<span class='sr-only'>Toggle Captions</span>",
              "</label>",
              "<span class='volume-controls'>",
              "<input class='inverted sr-only' id='mute{id}' type='checkbox' data-player='mute'>",
              "<label id='mute{id}' for='mute{id}'>",
                  "<svg class='icon-muted'><use xlink:href='#icon-muted'></use></svg>",
                  "<svg class='icon-volume'><use xlink:href='#icon-volume'></use></svg>",
                  "<span class='sr-only'>Toggle Mute</span>",
              "</label>",
              "<label for='volume{id}' class='sr-only'>Volume</label>",
              "<span class='volume-controls-tooltip'>",
                "<input id='volume{id}' class='player-volume' type='range' min='0' max='10' value='5' data-player='volume'>",
              "</span>",
              "</span>",
              "<button class='player-fullscreen-button' type='button' data-player='fullscreen'>",
                  "<svg class='icon-exit-fullscreen'><use xlink:href='#icon-exit-fullscreen'></use></svg>",
                  "<svg><use xlink:href='#icon-enter-fullscreen'></use></svg>",
                  "<span class='sr-only'>Toggle Fullscreen</span>",
              "</button>",
          "</span>",
      "</div>"].join("\n")
    });
  }
}

// copy of original plyrSetup function for use with layout tool only
function plyrSetupModule() {
  if(typeof plyr !== 'undefined') {
    plyr.setup({
      html: [
        "<div class='player-controls player-controls__lt-module'>",
          "<span class='player-controls-left'>",
              "<button class='play-button' type='button' data-player='play'>",
                  "<svg><use xlink:href='#icon-play'></use></svg>",
                  "<span class='sr-only'>Play</span>",
              "</button>",
              "<button class='pause-button' type='button' data-player='pause'>",
                  "<svg><use xlink:href='#icon-pause'></use></svg>",
                  "<span class='sr-only'>Pause</span>",
              "</button>",
              "<span class='volume-controls'>",
              "<input class='inverted sr-only' id='mute{id}' type='checkbox' data-player='mute'>",
              "<label id='mute{id}' for='mute{id}'>",
                  "<svg class='icon-muted'><use xlink:href='#icon-muted'></use></svg>",
                  "<svg class='icon-volume'><use xlink:href='#icon-volume'></use></svg>",
                  "<span class='sr-only'>Toggle Mute</span>",
              "</label>",
              "<label for='volume{id}' class='sr-only'>Volume</label>",
              "<span class='volume-controls-tooltip'>",
                "<input id='volume{id}' class='player-volume' type='range' min='0' max='10' value='5' data-player='volume'>",
              "</span>",
              "</span>",
              "<span class='player-time'>",
                  "<span class='sr-only'>Current time</span>",
                  "<span class='player-current-time'>00:00</span>",
              "</span>",
          "</span>",
          "<div class='player-progress-container'>",
            "<div class='player-progress-container-inner'>",
              "<div class='player-progress'>",
                  "<label for='seek{id}' class='sr-only'>Seek</label>",
                  "<input id='seek{id}' class='player-progress-seek' type='range' min='0' max='100' step='0.5' value='0' data-player='seek'>",
                  "<progress class='player-progress-played' max='100' value='0'>",
                      "<span>0</span>% played",
                  "</progress>",
                  "<progress class='player-progress-buffer' max='100' value='0'>",
                      "<span>0</span>% buffered",
                  "</progress>",
              "</div>",
            "</div>",
          "</div>",
          "<span class='player-controls-right'>",
          "<span class='player-time'>",
                "<span class='sr-only'>Current time</span>",
                "<span><span class='player-current-time'>00:00</span> /</span>",
            "</span>",
              "<span class='player-time player-time--total'>",
                  "<span class='sr-only'>Duration</span>",
                  "<span class='player-duration'>00:00</span>",
              "</span>",
              "<input class='sr-only' id='captions{id}' type='checkbox' data-player='captions'>",
              "<label class='player-captions-label' for='captions{id}'>",
                  "<svg class='icon-captions-on'><use xlink:href='#icon-captions-on'></use></svg>",
                  "<svg class='icon-captions-off'><use xlink:href='#icon-captions-off'></use></svg>",
                  "<span class='sr-only'>Toggle Captions</span>",
              "</label>",
              "<span class='volume-controls'>",
              "<input class='inverted sr-only' id='mute{id}' type='checkbox' data-player='mute'>",
              "<label id='mute{id}' for='mute{id}'>",
                  "<svg class='icon-muted'><use xlink:href='#icon-muted'></use></svg>",
                  "<svg class='icon-volume'><use xlink:href='#icon-volume'></use></svg>",
                  "<span class='sr-only'>Toggle Mute</span>",
              "</label>",
              "<label for='volume{id}' class='sr-only'>Volume</label>",
              "<span class='volume-controls-tooltip'>",
                "<input id='volume{id}' class='player-volume' type='range' min='0' max='10' value='5' data-player='volume'>",
              "</span>",
              "</span>",
              "<button class='player-fullscreen-button' type='button' data-player='fullscreen'>",
                  "<svg class='icon-exit-fullscreen'><use xlink:href='#icon-exit-fullscreen'></use></svg>",
                  "<svg><use xlink:href='#icon-enter-fullscreen'></use></svg>",
                  "<span class='sr-only'>Toggle Fullscreen</span>",
              "</button>",
          "</span>",
      "</div>"].join("\n")
    });
  }
}

function plyrRender(node) {
  // Only show on non-small screens
  if(window.innerWidth > 767 && isRendered === false) {
    node.plyr.restore();
    isRendered = true;
  }
  else if(window.innerWidth <= 767 && isRendered === true) {
    node.plyr.destroy();
    isRendered = false;
  }
}

A17.Behaviors.plyr = function(node) {
  var inst = 0;
  if(inst === 0) {
    plyrSetup();
    plyrRender(node);
    $(window).on('resize', function() {
      node.plyr.pause();
      plyrRender(node);
    });
  }
  inst ++;
};

// copy of original plyr function for use with layout tool only
A17.Behaviors.plyr_module = function(node) {
  var inst = 0;
  if(inst === 0) {
    plyrSetupModule();
    plyrRender(node);
    $(window).on('resize', function() {
      node.plyr.pause();
      plyrRender(node);
    });
  }
  inst ++;
};A17.Behaviors.plyr_switch = function(node) {
  var playToggle = node.querySelector('[data-plyr-switch-play-toggle]');
  var player = node.querySelector('[data-plyr-switch-player]');
  var isPlaying = false;

  playToggle.addEventListener('click', function(e) {
    e.preventDefault();
    isPlaying = !isPlaying;
    if(isPlaying) {
      $(node).addClass('is-playing');
      player.plyr.play();
    } else {
      $(node).removeClass('is-playing');
      player.plyr.pause();
    }
  });
};A17.Behaviors.primary_nav = function (node) {
	var primaryNav = document.querySelector('.primary-nav'),
		primaryNavBG = document.querySelector('.primary-nav__bg'),
		primaryNavStore = document.querySelector('.primary-nav--store'),
		isStorePage = document.querySelector('body').classList.contains('store');

	function toggleHamburgerMenu(e) {
		if (A17.media_query_in_use === 'medium' || A17.media_query_in_use === 'small') {
			e.preventDefault();
			primaryNav.classList.toggle('primary-nav--open');
		}
		if (isStorePage) {
			e.preventDefault();
			primaryNavStore.classList.toggle('primary-nav--open');
		}
	}

	function closeOnResize() {
		var mediaQuery = A17.Helpers.get_media_query_in_use();
		if (mediaQuery === 'xlarge' || mediaQuery === 'large') {
			primaryNav.classList.remove('primary-nav--open');
		}
	}
	node.addEventListener('click', toggleHamburgerMenu, false);
	primaryNavBG.addEventListener('click', function () {
		primaryNav.classList.remove('primary-nav--open');
	}, false);
	window.addEventListener('resize', debounce(closeOnResize, 175, false), false);
};A17.Behaviors.product_option = function(node) {
	var $node = $(node);
	var $option = $('.product-option[data-for="' + $node.attr('id') + '"]');
	var $group = $('#' + $option.attr('data-group'));
	var $label = $('label[for="' + $node.attr('id') + '"]');
	var $submit = document.querySelectorAll('[data-product-cta-submit]')[0];
	$label.on('change', function onNodeChange(event) {
		event.stopPropagation();
		$.each($group[0].querySelectorAll('.product-option'), function(option) {
		  $(option).removeClass('active');
		});
		$option.addClass('active');
		if ($submit !== undefined && $submit.disabled == true) {
		  $submit.removeAttribute('disabled');
		}
	});

	if ($node.attr('data-wt') !== null) {
		$node.on('click', function() {
			var wtinput = document.getElementById('paywallformwt');
			wtinput.value = $node.attr('data-wt');
		});
	}
};A17.Behaviors.scroll = function(node) {

	var elementID = $(node).attr('href').replace("#","");
	node.addEventListener('click', function(e) {
		e.preventDefault();
		A17.Helpers.scroll.To(elementID);
	});

};A17.Behaviors.search = function (node) {
	var url_title = this.getAttribute('data-url-title'),
		query_string = this.getAttribute('data-query-search'),
		is_search_page = url_title === 'search' ? true : false,
		search_group = document.querySelector('.search-group__autocomplete'),
		nav_search_form = document.querySelector('#search-form'),
		searchpage_search_form = document.querySelector('.search-group__form'),
		clear_button = document.querySelector('.icon__search-input-btn'),
		mobileSearchBtn = document.querySelector('.primary-nav__search-btn'),
		search_autocomplete_results = document.querySelector('.search_autocomplete_results'),
		out = document.querySelector('.primary-nav__search-results-list'),
		style = 'none',
		index = -1; // Needs to be outside the function scope

	/**
	 * Takes a list elements and events type
	 *
	 * @constructor
	 * @param {object} element The element instance
	 * @param {object} event The event key type
	*/
	function ElementList(element, event) {
		this.element = element;
		this.event = event;
	}

	/**
	 * Takes the search input and looks for letter matches to make them bold
	 * @param {string} i_v The input value
	 */

	ElementList.prototype.highlight = function (i_v) {
		for (var i = 0; i < this.element.length; i++) {
			var matchStart = this.element[i].innerText.toLowerCase().indexOf("" + i_v.toLowerCase() + "");
			if (matchStart >= 0) {
				var matcher = "<a href='" + this.element[i].getElementsByTagName('A')[0].href + "'>" + "<span class='" + this.element[i].getElementsByTagName('SPAN')[0].className + "'>" + "</span>" + this.element[i].innerText.slice(0, matchStart) + "<strong>" + this.element[i].innerText.slice(matchStart, (matchStart + i_v.length - 1) + 1) + "</strong>" + this.element[i].innerText.slice((matchStart + i_v.length - 1) + 1) + "</a>";
				this.element[i].innerHTML = matcher;
			}
		}
		return this;
	};


	ElementList.prototype.handleKeyboardEvent = function () {
		var end_of_array = this.element.length - 1 == index;
		if (this.event == 40 || this.event == 38 || this.event == 13 || this.event == 27) {
			if (this.event == 40 && !end_of_array) {
				index++;
			} else if (this.event == 38) {
				if (index !== 0) {
					index--;
				}
			} else if (this.event == 27) {// if clicked Scape Key
				document.querySelector('.search-group__autocomplete').style.display = 'none';
			} else if (this.event == 13) {// if clicked Enter Key
				document.querySelector('#search-result-input').value = this.element[index].getElementsByTagName('a')[0].innerText;
				document.search_form.submit();
			}
			/**
			 * will add the selected class to each item index
			 **/
			this.element[index].classList.add("selected");
		}
		return this;
	};


	/**
	 * mouse events for hover effect
	 */
	ElementList.prototype.handleMouseEvent = function () {
		for (var i = 0; i < this.element.length; i++) {
			var list_arr = this.element;
			(function (l) {
				var that = list_arr[i];
				/**
				 * hover effect and alse set the index to the current item position
				 */
				A17.Helpers.addEvent(that, 'mouseover', function () {
					index = l;
					if (that.classList.contains('selected')) {
						that.classList.remove('selected');
					}
					that.classList.add('selected');
				});
				A17.Helpers.addEvent(that, 'mouseout', function () {
					index = l;
					if (that.classList.contains('selected')) {
						that.classList.remove('selected');
					}
				});
				/**
				 * When mouse enter's the container, will make sure to unselect previous elements
				 */
				A17.Helpers.addEvent(document.querySelector('.search_autocomplete_results'), 'mouseenter', function () {
					if (that.classList.contains('selected')) {
						that.classList.remove('selected');
					}
				});
			})(i);
			/**
			 * When clicking ouside, will close autocomplete
			 */
			A17.Helpers.addEvent(document.querySelector('#scientific-american'), 'mousedown', function (e) {
				if (!document.querySelector('.search-group__form').contains(e.target)) {
					document.querySelector('.search-group__autocomplete').style.display = 'none';
				}
			});
		}
		return this;
	}

	
	/**
	 * keyboard functionality for the search auto complete
	 */
	if (is_search_page) {
		/*
		 *grabs the value from the url query
		 *string to bind value with the search input
		 */
		this.value = query_string.replace(/"/g, '');
		//clear search input action
		clear_button.clickHandler = function () {
			// if on mobile device, let the search button submit form
			if (A17.media_query_in_use === 'small') {
				searchpage_search_form.submit();
			} else { // else on desktop, search button clears form
				node.value = '';
				clear_button.style.display = 'none';
				search_group.style.display = 'none';
				node.focus();
				return false;
			}
		} //calling the event handler helper
		A17.Helpers.addEvent(clear_button, 'click', clear_button.clickHandler);
	}

	// get results base on the input entering
	node.keyupHandler = function (e) {
		var self = this;
		var charCode = window.event ? e.keyCode : e.which;
		node.selectionEnd; //prevents defaut event for the left & right keys
		if (charCode == 37 || charCode == 39) {
			return e.preventDefault();
		}
		if ($(self).attr('class') !== null && $(self).attr('class').indexOf('mobile') >= 0) {
			style = 'mobile';
			out = document.querySelector('#mobile-search-results')
		}
		if (self.value.length > 0) {
			is_search_page ? clear_button.style.display = 'block' : null;
			setTimeout(function(){
				mura.ajax({
					type: "post",
					url: "/sciam/remote/misc.cfc?method=asyncSearch&q=" + self.value + '&style=' + style + '&siteid=' + mura.siteid,
					success: function (data) {
						if (is_search_page) {
							search_autocomplete_results.innerHTML = data;
							(node.value !== '' && data) ? search_group.style.display = 'block': search_group.style.display = 'none';
							var theElementList = new ElementList(search_autocomplete_results.querySelectorAll('li'), charCode);
							theElementList.highlight(node.value).handleKeyboardEvent().handleMouseEvent(); //Method chaining
						} else {
							out.innerHTML = data;
						} // home search autocomplete
					}
				});
			},0);
		}
		if (is_search_page && self.value == '') {
			if (A17.media_query_in_use != 'small') {
				clear_button.style.display = 'none';
			}
			search_group.style.display = 'none';
			search_autocomplete_results.innerHTML = []; // removing results from the Dom if the input is empty or if there is no results
			index = -1;
		}
		return false;
	};
	A17.Helpers.addEvent(node, 'keydown', node.keyupHandler);


	mobileSearchBtn.addEventListener('click', function (e) {
		if ((A17.media_query_in_use === 'medium' || A17.media_query_in_use === 'small')) {
			nav_search_form.submit();
		}
	});
};A17.Behaviors.search_filter = function (node) {
	var radio_buttons = node.querySelectorAll('.tooltip__field__input');
	for (var i = 0; i < radio_buttons.length; i++) {
		radio_buttons[i].onclick = function () {
			var tooltip = this.closest('div.tooltip'),
				dropdown_list = tooltip.parentElement,
				target = dropdown_list.querySelector('span.small-hide'),
				replace_label = this.getAttribute('data-name');
			target.textContent = replace_label;
			this.checked = true;
			node.submit();
		};
	}
};A17.Behaviors.sharer = function(node) {
  var urlTemplate = $($(node)[0]).attr('data-sharer-url');
  $(node).on('click', function(e) {
    e.preventDefault();
    var popupURL = urlTemplate.replace('[URL]', encodeURIComponent(window.location.href));
    popupURL = popupURL.replace('[TITLE]', window.document.title);
    var newwindow = window.open(popupURL, 'name', 'height=300,width=600,top=100,left=100');
    if (window.focus) { newwindow.focus(); }
  });
};A17.Behaviors.sign_in_flyout = function(node) {
	var signin = document.getElementById('signin-click');
	var signinForm = document.getElementById('signin-flyout');
	var signinClose = document.getElementById('signin-flyout__close');
	var signinEmail = node.querySelector('[data-signin-email]');
	var signinPassword = node.querySelector('[data-signin-password]');
	var signinSubmit = node.querySelector('[data-signin-submit-btn]');
	var signinLoading = node.querySelector('[data-signin-loading]');

	$(signin).on('click', function() {
		A17.Helpers.toggleClass(signinForm, 'active');
	});

	$(signinClose).on('click', function() {
		A17.Helpers.toggleClass(signinForm, 'active');
	});

	signinForm.addEventListener('submit', function(e) {
		// e.preventDefault();

		// signinValidation();

		signinSubmit.disabled = 'true';

		signinSubmit.style.display = 'none';

		signinLoading.style.display = 'block';

	});

	function signinValidation() {
		var response = $.slatwall.doAction('public:account.login', {'password':signinPassword.value,'emailAddress':signinEmail.value});
		return response;
	};
};


A17.Behaviors.sign_in_main = function(node) {
	var signinForm = node.querySelector('[data-signin-form]');
	var signinLoading = node.querySelector('[data-signin-loading]');
	var signinSubmit = node.querySelector('[data-signin-submit]');

	signinForm.addEventListener('submit', function(e) {
		//e.preventDefault();

		signinSubmit.disabled = 'true';
		signinSubmit.style.display = 'none';
		signinLoading.style.display = 'block';
	});
};A17.Behaviors.slider = function(node) {
  if(A17.browserSpec !== 'html5') {
    return;
  }

  var inner, paginator, slider, width;

  function refreshSelectors() {
    inner = node.querySelector('[data-slider-inner]');
    paginator = node.querySelector('[data-slider-paginator]');
  }

  function init_slider() {

    refreshSelectors();

    slider = (new a17_slider({
      sliderContainer: node,
      sliderInner: inner,
      paginator: paginator,
      slideAmount: 190,
      keyControls: false,
      automate: false,
      centered: true
    }));
  }

  function reinit_slider() {
    var new_width = node.offsetWidth;
    if (new_width != width) {
      slider.destroy();
      init_slider(new_width);
    }
  }

  function onWindowResize() {
    if(typeof timer !== 'undefined') {
      clearTimeout(timer);
    }
    timer = setTimeout(function(){
      reinit_slider();
    }, 250);
  }

  window.reinitSubscribeSlider = reinit_slider;

  $(window).on('resize', onWindowResize);

  init_slider(node.offsetWidth);
};A17.Behaviors.sticky = function (node) {
	var scrollTop,
		boundaryBox = node.closest('.sticky-bounds'),
		topOffset = parseInt(node.getAttribute('data-top-offset'), null) || 0;

	function handleStickyBehavior() {
		var boundaryStart = boundaryBox.getBoundingClientRect().top + scrollTop,
			boundaryEnd = boundaryBox.getBoundingClientRect().bottom,
			boundaryBoxHeight = boundaryBox.offsetHeight,
			stickyElHeight = node.offsetHeight + topOffset,
			isInsideBounds = scrollTop > (boundaryStart - topOffset),
			isAboveEndBounds = scrollTop < boundaryEnd,
			isPastBounds = (scrollTop + stickyElHeight) >= (boundaryStart + boundaryBoxHeight);
		if ((isInsideBounds && isAboveEndBounds && !isPastBounds) || (isAboveEndBounds && isInsideBounds && !isPastBounds)) {
			applySticky();
		} else if (!isInsideBounds) {
			removeSticky();
		} else if (isPastBounds) {
			markAtEnd();
		}
	}

	function applySticky() {
		if (!node.classList.contains('is-sticky')) {
			node.classList.remove('is-end');
			node.classList.add('is-sticky');
		}
	}

	function removeSticky() {
		if (node.classList.contains('is-sticky')) {
			node.classList.remove('is-end');
			node.classList.remove('is-sticky');
		}
	}

	function markAtEnd() {
		if (node.classList.contains('is-sticky')) {
			node.classList.remove('is-sticky');
			node.classList.add('is-end');
		}
	}

	function setNewScrollTop() {
		if (scrollTop != 0 || scrollTop === 'undefined') {
			scrollTop = (document.documentElement.scrollTop || document.body.scrollTop);
		}
	}
	window.addEventListener('DOMContentLoaded', setNewScrollTop, false);
	window.addEventListener('resize', debounce(handleStickyBehavior, 0, true));
	window.addEventListener('scroll', debounce(handleStickyBehavior, 0, true));
};A17.Behaviors.subscribe_hover = function(node) {
  var panel = node.querySelector('[data-subscribe-hover-panel]');
  var panelSub = panel.childNodes[0];
  var btn = node.querySelector('[data-subscribe-hover-btn]');
  var isOpen = false;

  panel.removeChild(panelSub);

  hoverintent(btn, function() {
    $(panel).addClass('visible');
    panel.appendChild(panelSub);
    isOpen = true;
    /*
    setTimeout(function() {
      reinitSubscribeSlider();
    }, 20); */
  }, function() {

  });

  var timeout;

  function constrainToViewportEdge() {
    var offset = (panel.getBoundingClientRect().left + document.body.scrollLeft);
    var width = parseInt(getComputedStyle(panel).width, null);
    panel.style.width = width + 40 + offset + 'px';
    panel.style.marginLeft = 0 - 40 - offset + 'px';
  }

  $(window).on('resize', function() {
    panel.style.width = null;
    panel.style.marginLeft = null;
    setTimeout(function() {
      constrainToViewportEdge();
    }, 0);
  });

  constrainToViewportEdge();

  $(panel).on('mouseleave', function() {
    timeout = setTimeout(function() {
      $(panel).removeClass('visible');
      panel.removeChild(panelSub);
      isOpen = false;
    }, 500);
  });

  $(panel).on('mouseenter', function() {
    if(typeof timeout !== 'undefined' && isOpen) {
      clearTimeout(timeout);
    }
  });
};A17.Behaviors.tabs = function(node) {
  var $node = $(node);
  var links = node.querySelectorAll('a');
  var contents = document.querySelectorAll('[data-tabs-content]');
  var contextContents = [];
  $.each(contents, function(v) {
    if($(v).attr('data-tabs-id') === $node.attr('id')) {
      contextContents.push(v);
    }
  });

  $.each(links, function(link) {
    link.addEventListener('click', function onLinkClick(event) {
      event.preventDefault();
      var $this = $(this);

      // "current" link on tab
      $.each(links, function(v) {
        $(v).removeClass('current');
      });
      $this.addClass('current');

      // Visibility of panels
      $.each(contextContents, function(v) {
        $(v).addClass('small-hide');
      });
      var contentId = $this.attr('data-content-id');
      $.each(contextContents, function(v) {
        if(v.dataset.tabsContent === contentId) {
          $(v).removeClass('small-hide');
        }
      });
    });
  });
};// Toaster

A17.Behaviors.toaster = function(node) {

    if ( A17.Helpers.cookie_read("toaster_load") == null ) {
       
        A17.Helpers.cookie_create("toaster_load", true, 5);

        var toaster = document.getElementById("global__toaster-ad");
        var toasterClose = document.getElementById("global__toaster-ad__close");

        $(toaster).addClass("toaster-risen");

        document.getElementById("global__toaster-ad__close").addEventListener('click', function() {
            $(toaster).addClass("toaster-closed");
        });
    }    
};A17.Behaviors.toggle = function(node) {
  var $node = $(node);

  $node.on('click', function(e) {
    e.preventDefault();

    var href = $(this).attr('href') || $(this).attr('data-href');
    var only = $(this).attr('data-only');
    var parent = $(this).attr('data-parent');

    // Restrict by a media query
    if(only) {
      var mq = A17.Helpers.get_media_query_in_use();
      if(mq !== only) {
        return false;
      }
    }

    var $target = $(href);
    if(A17.Helpers.hasClass($target[0], 'is-active')) {
      $target.removeClass('is-active');
      $node.removeClass('is-active');
      if (parent){
       $($node[0].parentNode).removeClass('is-active'); 
      }
    } else {
      $target.addClass('is-active');
      $node.addClass('is-active');
      if (parent){
       $($node[0].parentNode).addClass('is-active'); 
      }
    }
  });
};A17.Behaviors.toggle_infographic_width = function(node) {

  var isOpen = false;
  node.addEventListener('click', function(e) {
    e.preventDefault();
    if(isOpen) {
      close();
    } else {
      open();
    }
  });

  function open() {
    var mq = A17.Helpers.get_media_query_in_use();
    if(mq === 'small') {
      return false;
    }

    $(node).addClass('is-open');
    $(node).removeClass('is-fully-closed');
    isOpen = true;
  }

  function close() {
    $(node).removeClass('is-open');
    isOpen = false;
    setTimeout(function() {
      $(node).addClass('is-fully-closed');
    }, 300);
  }

  $(window).on('resize', function() {
    if(isOpen) {
      close();
    }
  });
};A17.Behaviors.toggle_open = function (node) {
	var targetName = node.getAttribute('data-target'),
		targetEl = document.querySelector('[data-toggle=' + targetName + ']'),
		targetElOpenClass = targetName + '--open',
		initMediaQuery = A17.Helpers.get_media_query_in_use();

	function toggleOpen(e) {
		e.preventDefault();
		targetEl.classList.toggle(targetElOpenClass);
	}

	function resetOnResize() {
		var newMediaQuery = A17.media_query_in_use;
		if (newMediaQuery != initMediaQuery) {
			targetEl.classList.remove(targetElOpenClass);
		}
	}
	node.addEventListener('click', toggleOpen, false);
	window.addEventListener('resize', debounce(resetOnResize, 175, false), false);
};A17.Behaviors.toggle_open_tabs = function (node) {
	var targetContainerName = node.getAttribute('data-tab-target'),
		targetTabContainer = document.querySelector('[data-tab-container=' + targetContainerName + ']');

	function toggleOpen(e) {
		var targetTab = document.querySelector('.' + e.target.getAttribute('data-target'));
		e.preventDefault();
		if (!targetTab.classList.contains('active')) {
			targetTabContainer.childNodes.forEach(function (el) {
				el.classList.remove('active');
			});
			targetTab.classList.add('active');
		} else {
			targetTab.classList.remove('active');
		}
	}
	node.addEventListener('click', toggleOpen, false);
};A17.Behaviors.tooltip = function(node) {

  var tooltipId = $(node).attr('data-tooltip-id');
  var tooltip = document.getElementById(tooltipId);
  var boundsId = $(node).attr('data-tooltip-bounds-id'), bounds;

  var inst = 0;

  if(boundsId) {
    bounds = document.getElementById(boundsId);
  }
  else {
    bounds = document.getElementById('scientific-american');
  }

  var tooltipWidth = $(node).attr('data-tooltip-width') !== null ? $(node).attr('data-tooltip-width') : 275;
  var hoverMode = $(node).attr('data-tooltip-hover') !== null;
  var topMode = $(node).attr('data-tooltip-top') !== null;

  function closeTooltip() {
    $(tooltip).removeClass('open');
    $(node).removeClass('open');
  }

  $(node).on((hoverMode ? 'mouseenter' : 'click'), function(e) {
    e.cancelBubble = true;
    e.preventDefault();
    e.stopPropagation();

    if(A17.Helpers.hasClass(tooltip, 'open')) {
      closeTooltip();
      return;
    }

    var arrow = tooltip.querySelectorAll('.tooltip__arrow')[0];
    var offsetLeft = node.getBoundingClientRect().left + document.body.scrollLeft;
    var offsetTop = node.getBoundingClientRect().top + (document.documentElement.scrollTop||document.body.scrollTop);
    var nodeWidth = node.offsetWidth;
    var originLeft = offsetLeft + (nodeWidth / 2);
    var tooltipLeft = originLeft - (tooltipWidth / 2);
    var boundsLeft = bounds.getBoundingClientRect().left + document.body.scrollLeft;

    if(boundsLeft > tooltipLeft) {
      tooltipLeft = boundsLeft;
      var arrowLeft = originLeft - tooltipLeft;
      arrow.style.left = arrowLeft + 'px';
    }
    else {
      arrow.style.left = null;
    }

    var outer = document.querySelectorAll('.tooltip-outer[data-tooltip="' + tooltipId + '"]')[0];
    if(typeof outer === 'undefined') {
      outer = A17.Helpers.closest(node, function(el) {
        return A17.Helpers.hasClass(el, 'tooltip-outer');
      });
    }

    var outerLeft = outer.getBoundingClientRect().left + document.body.scrollLeft;
    var outerTop = outer.getBoundingClientRect().top + (document.documentElement.scrollTop||document.body.scrollTop);

    tooltip.style.left = (tooltipLeft - outerLeft) + 'px';

    if(topMode) {
      tooltip.style.top = (offsetTop - outerTop - tooltip.offsetHeight - node.offsetHeight) + 'px';
    } else {
      tooltip.style.top = (offsetTop - outerTop) + 'px';
    }

    // Don't close clicked tooltips when hovering a tooltip
    if(hoverMode) {
      $('.tooltip:not([data-keep-tooltip]), [data-tooltip]:not([data-keep-tooltip])').removeClass('open');
      $('[data-behavior^="tooltip"]').removeClass('open');
    }
    else {
      $('.tooltip, [data-tooltip]').removeClass('open');
      $('[data-behavior^="tooltip"]').removeClass('open');
    }


    $(tooltip).addClass('open');
    $(node).addClass('open');
  }).on('mouseleave', function() {
    if(hoverMode) {
      closeTooltip();
    }
  });

  $.each(tooltip.querySelectorAll('a'), function(v) {
    $(v).on('click', function(e) {
      e.cancelBubble = true;
      e.stopPropagation();
    });
  });

  function cacheDimensions() {

  }

  var triggers = document.querySelectorAll('[data-tooltip-trigger][data-tooltip="' + tooltipId + '"]');
  $.each(triggers, function(v) {
    $(v).on('click', function(e) {
      e.cancelBubble = true;
      e.preventDefault();
      e.stopPropagation();
      $(node).trigger('click');
    });
  });

  cacheDimensions();

  $(window).on('resize', function() {
    cacheDimensions();
  });

  if(inst === 0) {
    $(window).on('resize', function() {
      $('.tooltip').removeClass('open');
      $('[data-behavior^="tooltip"]').removeClass('open');
    });

    $('html').on('click', function() {
      $('.tooltip').removeClass('open');
      $('[data-behavior^="tooltip"]').removeClass('open');
    });
  }

  inst ++;
};A17.Behaviors.wt_tracking = function () {

        window.webtrendsAsyncInit=function(){
            var onSiteDomains = 'nature.com,connotea.org,labanimal.com,natureasia.com,naturechina.com.cn,neuroscience-gateway.org,palgrave-connect.com,www.econolog.net,www.palgrave-journals.com,www.rikenresearch.riken.jp,www.scitable.com,www.natureprotocols.com,scientificamerican.com,sciam.com';
            window.dcs = new Webtrends.dcs().init({
                dcsid:"dcszbiart00000oiar2s6w5ud_4y9j",
                domain:"statse.webtrendslive.com",
                timezone:-5,
                downloadtypes:"xls,doc,pdf,txt,csv,zip,docx,xlsx",
                navigationtag:"div,table",
                trackevents:true,
                enabled:true,
                i18n:false,
                adimpressions:true,
                adsparam:"WT.ac",
                offsite: true,
                paidsearchparams:"gclid",
                splitvalue:"",
                preserve:true,
                cookieTypes:"all",
                metanames:"Access,citation_authors,citation_title,citation_journal_title,citation_date,citation_volume,citation_issue,citation_doi",
                onsitedoms: {
                    doms: onSiteDomains,
                    test: function(host) {
                    if (onSiteDomains.length > 0) {
                      var doms = onSiteDomains.split(",");
                      var len = doms.length;
                      var pattern;
                      for (var i = 0; i < len; i++) {
                        doms[i] = doms[i].replace(/^\s*/, "").replace(/\s*$/, "");
                        pattern = new RegExp(doms[i] + '$');
                        if (host.search(pattern) != -1) {
                          return true;
                        }
                      }
                    }
                    return false;
                  }
                },
                fpcdom:".scientificamerican.com",
                plugins:{
                    hm:{src:"//s.webtrends.com/js/webtrends.hm.js"},
                    WT_Nature_ndl: {
                        src: function (_window) {
                            _window = _window || window;
            
                            if (!_window.Webtrends)
                            return;
            
                            function doTransform(d, o) {
                                var e = o.element || {};
                                var evt = o.event || {};
                            
                                var getDl = function() {
                                    if (o && o.argsa) {
                                        for (var i = 0; i < o.argsa.length - 1; i += 2) {
                                            if (o.argsa[i] === 'WT.dl') {
                                                return o.argsa[i + 1];
                                            }
                                        }
                                    }
                                    return d.WT.dl;
                                };
                            
                                var _dl = getDl() || '0';

                               // Begin test for offsite.
                                if (e.hostname && !d.dcsIsOnsite(e.hostname, d._onsitedoms) && !d._isRightClick(evt)) {
                                    _dl = '24';
                                }
                                // End test for offsite
                            
                                // Start testing for downloads
                                if ((e.pathname) && d.dcsTypeMatch(e.pathname, d._downloadtypes) && !d._isRightClick(evt)) {
                                    _dl = '20';
                                }
                                // End testing for downloads 

                                o.argsa.push("WT.ndl", _dl);
                            
                                if (d.DCS.dcsuri.substr(d.DCS.dcsuri.length-4)=='.pdf') {
                                    _dl = '0';
                                }
                                d.WT.ndl = _dl;
                            }
            
                            function regTransform() {
                                _window.Webtrends.addTransform(doTransform, 'all');
                            }
                            Webtrends.registerPlugin("WT_Nature_ndl", regTransform);
                        }
                    }
                }
            });
                dcs.WT.cg_n = WT.cg_n;
                dcs.WT.template = "sa_responsive";
                dcs.WT.cg_s = WT.cg_s;
                dcs.WT.sa_cat = WT.sa_cat;
                dcs.WT.sa_cattop = WT.sa_cattop;
                dcs.WT.sa_author = WT.sa_authors;
                dcs.WT.sa_pubdate = WT.sa_pubdate;
                dcs.WT.sa_access_status = WT.sa_access_status;
                dcs.WT.sa_cstatus_registrant = WT.sa_cstatus_registrant;
                dcs.WT.sa_cstatus_customer =  WT.sa_cstatus_customer;
                dcs.WT.sa_cstatus_subscriber = WT.sa_cstatus_subscriber;
                dcs.WT.z_cg_ecollection = WT.z_cg_ecollection;
                dcs.WT.sa_article_id = WT.sa_article_id;
                dcs.WT.sa_issue = WT.sa_issue;

                if ( window.location.href.indexOf("order-confirmation") > -1 ) {
                    dcs.WT.si_n = WT.si_n;
                    dcs.WT.si_x = WT.si_x;
                    dcs.WT.si_cs = WT.si_cs;
                    dcs.WT.tx_e = WT.tx_e;
                    dcs.WT.tx_u = WT.tx_u;
                    dcs.WT.tx_s = WT.tx_s;
                    dcs.WT.tx_it = WT.tx_it;
                    dcs.WT.tx_id = WT.tx_id;
                    dcs.WT.tx_i = WT.tx_i;
                    dcs.WT.pn_sku = WT.pn_sku;
                }

                if ( window.location.href.indexOf("/search/") > -1 || window.location.href.indexOf("/search?") > -1 ) {
                    dcs.WT.oss = WT.oss;
                    dcs.WT.oss_r = WT.oss_r;
                }
                
                if (window.innerWidth > 1023){
                    dcs.WT.z_css = "desktop";
                } else if (window.innerWidth <= 1023 && window.innerWidth > 768 ) {
                    dcs.WT.z_css = "tablet";
                } else if (window.innerWidth <= 767) {
                    dcs.WT.z_css = "mobile";
                }
                
                dcs.track();
        };


};A17.Behaviors.validate_filters = function(node) {
  if ( sessionStorage !== 'undefined' ) {

    // get page context
    var filterPageContext = node.dataset.filterPageContext.split(",");

    for (var j=0; j <= filterPageContext.length - 1; j++) {

      // get filters
      var filters = node.dataset.filters.split(",");

      var pageContext = filterPageContext[j];

      for (var i=0; i <= filters.length - 1; i++) {
        var filterName = filters[i];

        // get filter to remove
        var filterToRemove = (pageContext + "." + filterName).toUpperCase();

        if (!sessionStorage.getItem(filterToRemove)) {
          console.log(filterToRemove);
          A17.Helpers.cookie_delete(filterToRemove);
        }
      }
    }
  }
};A17.Behaviors.video_feature = function(node) {
  var poster = node.querySelector('[data-video-feature-poster]');
  var player = node.querySelector('[data-video-feature-player]');
  var playervideo = node.querySelector('#sciamResVid');
  var playerinner = node.querySelector('[data-video-feature-player-inner]');
  var playervolume = document.querySelectorAll('.vjs-volume-bar')[0].parentNode.parentNode;

  player.style.display = 'none';

  poster.addEventListener('click', function(e) {
    e.preventDefault();
    $(player).removeClass('is-hidden');
    player.style.display = 'block';
    poster.style.display = 'none';
    playervideo.style.height = '100%';
    playervolume.style.margin = '0 0px 25px -3px';
    videojs("sciamResVid").ready(function() {
      var myPlayer = this;
      myPlayer.play();
    });
  });
};A17.Behaviors.visual_breadcrumbs = function(node) {
  var navItems = node.querySelectorAll('[data-block-id]');
  var _scrollTop = 0;
  var headerSize = 300;

  $.each(navItems, function(v) {
    v.addEventListener('click', function(e) {
      e.preventDefault();
      var block = document.getElementById($(v).attr('data-block-id'));
      A17.Helpers.scrollTo(block, headerSize);
    });
  });

  setScrollTop();
  render();

  $(window).on('scroll', function() {
    setScrollTop();
  });

  function setScrollTop() {
    _scrollTop = (document.documentElement.scrollTop||document.body.scrollTop);
  }

  function render() {
    $.each(navItems, function(v) {
      if(typeof v.passed === 'undefined') {
        v.passed = false;
      }
      var block = document.getElementById($(v).attr('data-block-id'));
      if(block.offsetTop < _scrollTop && !v.passed) {
        $(v).addClass('is-passed');
        v.passed = true;
      }
      else if(block.offsetTop >= _scrollTop && v.passed) {
        $(v).removeClass('is-passed');
        v.passed = false;
      }
    });
  }

  (function animloop() {
    requestAnimFrame(animloop);
    render();
  })();
};/**
* @param {object} element The elemnt instance
* @param {string} type Event type
* @param {object} handler event functions
*/
A17.Helpers.addEvent = function (el, type, handler) {
	if (el.attachEvent) {
		el.attachEvent('on' + type, handler);
	} else {el.addEventListener(type, handler);}
};A17.Helpers.closest = function (el, fn) {
	return el && (fn(el) ? el : A17.Helpers.closest(el.parentNode, fn));
};
// polyfill for .closest
if (!Element.prototype.matches) {
	Element.prototype.matches = Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
}
if (!Element.prototype.closest) {
	Element.prototype.closest = function (s) {
		var el = this;
		if (!document.documentElement.contains(el)) {
			return null;
		}
		do {
			if (el.matches(s)) {
				return el;
			}
			el = el.parentElement;
		} while (el !== null);
		return null;
	}
}
// end polyfill
;
A17.Helpers.comments = function(){

	var commentsProxyPath = mura.themepath + "/display_objects/comments/ajax/commentsProxy.cfc";
	var nextN = 20;
	var commentsPage = document.getElementById('commentsPage');
	var theForm = document.getElementById("postcomment-form");
	var editor = document.getElementById('postcomment');

	var sortSection = document.getElementById('article-comment-sort');
	if (sortSection != null) {
		var sortDirection = sortSection.querySelector("[name=sortDirection]").value;
	}
	else {
		var sortDirection = "desc";
	}

	var params = {
		method: "renderCommentsPage",
		contentID: $(commentsPage).attr('data-contentid'),
		siteID: $(commentsPage).attr('data-siteid'),
		sortDirection: sortDirection,
		nextN: nextN
	};


	// sort comments
	var sortDirectionButtons = document.getElementsByName("sortDirection");
	$.each(sortDirectionButtons, function(s) {
		$(s).on('click', function(e ) {
			params.sortDirection = s.value;
			params.pageNo = 1;

			commentsPage.innerHTML = "";
			loadComments(params);
			A17.Helpers.cookie_create("commentssort", s.value, 30);
			
		});
	});


	var initComments=function() {
		var hash = window.location.hash;
		if (hash.length > 0 && hash.indexOf("comment-") > 0) {

			var comment = hash.replace("#comment-", "");
			if (comment.indexOf('-') > 0) {
				var pageno =  comment.substring(0, comment.indexOf('-'));
				var commentid = comment.replace(pageno+'-', '')			

				params.pageNo = pageno

				mura.ajax({
					type: "post",
					url: commentsProxyPath,
					data: params,
					success: function(data) {
						var commentNodeId = hash.replace("#", '');
						commentsPage.innerHTML = commentsPage.innerHTML + data;
						bindEvents();

						A17.Helpers.scroll.To(commentNodeId);

						var commentNode = document.getElementById(commentNodeId);
						comment_fade(commentNode);
						
					}
				});
			}
			else {
				loadComments(params);
			}
		}
		else {
			loadComments(params);
		}
		
			
	}

	var loadComments=function(params) {


		mura.ajax({
			type: "post",
			url: commentsProxyPath,
			data: params,
			success: function(data) {
				commentsPage.innerHTML = commentsPage.innerHTML + data;
				bindEvents();
			}
		});
	}


	var bindEvents=function(){

		// more comments
		var moreComments = document.getElementById('moreComments');

		if (moreComments != null){
			$(moreComments).on('click', function( event ) {
				event.preventDefault();
				var pageNo = $(moreComments).attr('data-pageno');
				var contentID = $(commentsPage).attr('data-contentid');
				params.pageNo = pageNo;
				params.commentID = "";
				
				moreComments.parentNode.removeChild(moreComments);
				loadComments(params);
				
			});
		}


		// reply

		var reply = commentsPage.querySelectorAll('.reply');

		$.each(reply, function(r) {
		
			$(r).on('click', function(e) {
				e.preventDefault();
				var id = $(r).attr('data-id');
				var thisReply = document.getElementById("postcomment-" + id)
				var editor = document.getElementById('postcomment');
				
				if (thisReply.childNodes.length == 0) {
					editor.parentNode.removeChild(editor);

					thisReply.appendChild(editor);
					editor.querySelector("[name=parentid]").value = id;
					editor.querySelector("[type=submit]").innerHTML = "Reply";

					
					theForm.querySelector("#postcomment-comment").style.display = "inline-block";
					theForm.querySelector(".article-comment-form__header").style.display = "none";
				}
			});
			
		});

		var newComment = theForm.querySelector('#postcomment-comment');

		$(newComment).on('click', function( e ) {
			e.preventDefault();
			newComment.style.display = "none";
			var editor = document.getElementById('postcomment');

			editor.parentNode.removeChild(editor);

			if (newComment.parentNode.parentNode.querySelector("form") == null) {
				theForm.querySelector(".article-comment-form__header").style.display = "block";
				
				theForm.appendChild(editor);
				editor.querySelector("[name=parentid]").value = "";
				editor.querySelector("[type=submit]").innerHTML = "Post";
			}
			
		});


		//in reply to
		var inReplyTo = commentsPage.querySelectorAll('.inReplyTo');

		$.each(inReplyTo, function(irt) {
			if (!A17.Helpers.hasClass(irt, 'eventcomment')) {
				$(irt).addClass('eventcomment');

				$(irt).on('click', function(e) {
					e.preventDefault();

					var id = $(irt).attr('data-id');
					var parentid = $(irt).attr('data-parentid');
					
					if ($('#comment-' + parentid).length != 0) {
						A17.Helpers.scroll.To('comment-' + parentid);
						var parent = document.getElementById("comment-"+parentid);

						comment_fade(parent.parentNode);
					 } 
					 else {
						params.commentID = parentid;

						mura.ajax({
							type: "post",
							url: commentsProxyPath,
							data: params,
							success: function(data) {
								var newComment = document.createElement("div");
								newComment.innerHTML = data;
								irt.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.insertBefore(newComment, irt.parentNode.parentNode.parentNode.parentNode.parentNode);
								comment_fade(newComment);
								bindEvents();
							}
						});

					}

				});
			}
		});


		// Spam 
		var spam = commentsPage.querySelectorAll('.flagAsSpam');

		$.each(spam, function(s) {
			$(s).on('click', function(e) {
				e.preventDefault();
				var id = $(s).attr('data-id');
				var eventListenerCallee = arguments.callee;
				
				var actionURL = commentsProxyPath + "?method=flag&commentID=" + id;

				mura.ajax({
					type: "get",
					url: actionURL,
					success: function(data) {
						s.innerHTML = "Reported as Abuse";
						s.removeEventListener("click", eventListenerCallee);
						$(s).on('click', function( e ) {
							e.preventDefault();
						});
						s.style.cursor = "default";
					}
				});

			});
		});
		
		
	}

	function comment_fade(element) {
		// var op = 0.1;  // initial opacity
		// var timer = setInterval(function () {
		// 	if (op >= 1){
		// 		clearInterval(timer);
		// 	}
		// 	element.style.opacity = op;
		// 	element.style.filter = 'alpha(opacity=' + op * 100 + ")";
		// 	op += op * 0.1;
		// }, 30);

		element.style.background = 'hsl(0,0,95%)';

		var d = 100;
		for(var i=85; i<=200; i=i+0.05){ //i represents the lightness
			d  += 10;
			(function(ii,dd){
				setTimeout(function(){
					element.style.background = 'hsl(0,0.1%,'+ii+'%)';
				}, dd);    
			})(i,d);
		}

	}



	initComments();


};A17.Helpers.cookie_create = function(name,value,days) {
  /*

    # A17.Helpers.cookie_create
    * v.1

    ## description
    Creates a cookie with optional expiration date

    ## requires
    * nothing

    ## parameters
    * name - required - name of cookie
    * value - required - value of cookie
    * days - optional - expiry time, in days. If non specified the cookie expires when the browser window is closed

    ## returns
    * nothing

    ## example usage:
    ```js
    A17.Helpers.cookie_create("splash",true,1);
    ```

    ## thanks to
    http://www.quirksmode.org/js/cookies.html
  */
  var date, expires;
  if (days) {
    date = new Date();
    date.setTime(date.getTime()+(days*24*60*60*1000));
    expires = "; expires="+date.toGMTString();
  } else {
    expires = "";
  }
  document.cookie = name+"="+value+expires+"; path=/";
};A17.Helpers.cookie_delete = function(name) {
  /*

    # A17.Helpers.cookie_delete
    * v.1

    ## description
    Deletes a named cookie

    ## requires
    * nothing

    ## parameters
    * name - required - name of cookie

    ## returns
    * nothing

    ## example usage:
    ```js
    A17.Helpers.cookie_delete("splash");
    ```

    ## thanks to
    http://www.quirksmode.org/js/cookies.html
  */
  if (name) {
    A17.Helpers.cookie_create(name,"",-1);
  }
};A17.Helpers.cookie_read = function(name) {
  /*

    # A17.Helpers.cookie_read
    * v.1

    ## description
    Returns the value of a named cookie

    ## requires
    * nothing

    ## parameters
    * name - required - name of cookie

    ## returns
    * string of cookie value or null if cookie doesn't exist

    ## example usage:
    ```js
    A17.Helpers.cookie_read("splash"); // value or null if cookie doesn't exist
    ```

    ## thanks to
    http://www.quirksmode.org/js/cookies.html
  */
  if (name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
      var c = ca[i];
      while (c.charAt(0)==' ') {
        c = c.substring(1,c.length);
      }
      if (c.indexOf(nameEQ) === 0) {
        return c.substring(nameEQ.length,c.length);
      }
    }
    return null;
  }
  return null;
};function debounce(func, wait, immediate) {
	var timeout;
	return function () {
		var context = this,
			args = arguments;
		var later = function () {
			timeout = null;
			if (!immediate) {
				func.apply(context, args);
			}
		};
		var callNow = immediate && !timeout;
		clearTimeout(timeout);
		timeout = setTimeout(later, wait);
		if (callNow) {
			func.apply(context, args);
		}
	};
}
;
A17.Helpers.font_observers = function() {

  /*

    # A17.Helpers.font_observers
    * v.1

    ## description
    Adds a class to the document when fonts have loaded

    ## requires
    * fontfaceonload v0.1.6 https://github.com/zachleat/fontfaceonload

    ## parameters
    * none

    ## returns
    * nothing

    ## example usage:
    ```js
    A17.Helpers.font_observers();
    ```
  */

  var weightLookup = {
    "normal": 400,
    "bold": 700
  };

  var fonts = [
    {
      name: "Benton",
      weight: "normal",
      style: "normal"
    },
    {
      name: "Benton",
      weight: "bold",
      style: "normal"
    },
    {
      name: "Brunel-Deck-Semibold",
      weight: "normal",
      style: "normal"
    },
    {
      name: "Brunel-Deck-Semibold",
      weight: "normal",
      style: "italic"
    },
    {
      name: "Brunel-Poster-Bold",
      weight: "normal",
      style: "italic"
    }
  ];
  // check we have cookie of fonts already loaded or not
  var fonts_loaded = A17.Helpers.cookie_read("SA_fonts_loaded") || "";

  // when a font is determined to be loaded
  function font_loaded(i,cache) {
    var font = fonts[i];
    if (!font) {
      return;
    }

    var alias = font.name.toLowerCase()+"-"+font.weight+"-"+font.style;

    // add a class
    window.document.documentElement.className += " "+alias+"-loaded";
    // update object
    font.loaded = true;
    // if this isn't from cache, update cookie, comma sep list
    if (!cache) {
      fonts_loaded += i+",";
      A17.Helpers.cookie_create("SA_fonts_loaded",fonts_loaded,1);
    }

    // setTimeout(function() {
      $(document).trigger('font-loaded:' + alias);
    // }, 20);
  }

  // quick looper func
  function loop(arr,func) {
    for (var i = 0, l = arr.length; i < l; i++) {
      func.call(arr[i],arr[i],i);
    }
  }

  // if cookie, show fonts (not first page load)
  if (fonts_loaded) {
    // loop list and add that class
    loop(fonts_loaded.split(","),function(v){
      if (v) {
        v = parseInt(v,10);
        if (typeof v === "number") {
          font_loaded(v,true);
        }
      }
    });
  }

  // go check on those fonts, using fontfaceonload https://github.com/zachleat/fontfaceonload
  loop(fonts,function(font,i){
    if (!font.loaded) {
      FontFaceOnload(font.name, {
        success: function() {
          font_loaded(i,false);
        },
        weight: weightLookup[font.weight],
        style: font.style,
        timeout: 3000
      });
    }
  });

};A17.Helpers.get_media_query_in_use = function() {
  /*

    # A17.Helpers.get_media_query_in_use
    * v.1

    ## description
    Returns the current media query in use by looking at the font-family of the head of the document and text in some pseudo content

    ## requires
    * specific HTML

    ## parameters
    * none

    ## returns
    * media query string as a string

    ## example usage:
    ```js
    var mq = A17.Helpers.get_media_query_in_use();
    ```

    ## CSS required
    ```css
    body {
    }
      body:after {
        font: 0/0 a;
        color: transparent;
        text-shadow: none;
        width: 1px;
        height: 1px;
        margin: -1px 0 0 -1px;
        position: absolute;
        left: -1px;
        top: -1px;
      }
      @media (max-width: 767px) {
        head {
          font-family: 'small';
        }
        body:after {
          content: 'small';
        }
      }
      @media (max-width: 768px) {
        head {
          font-family: 'medium';
        }
        body:after {
          content: 'medium';
        }
      }
    ```
  */

  if (window.opera){
    return parse(window.getComputedStyle(document.body,':after').getPropertyValue('content')) || "large";
  } else if (window.getComputedStyle) {
    return parse(window.getComputedStyle(document.head,null).getPropertyValue('font-family')) || "large";
  } else {
    return "large";
  }

  function parse(str) {
    return str.replace(/'/gi,"").replace(/"/gi,"");
  }
};A17.Helpers.get_url_without_hash = function() {
  return location.protocol+'//'+location.host+location.pathname+(location.search?location.search:"");
};A17.Helpers.hasClass = function(el, className) {
  if (el.classList) {
    return el.classList.contains(className);
  } else {
    return new RegExp('(^| )' + className + '( |$)', 'gi').test(el.className);
  }
};A17.Helpers.load_jquery = function(cb) {
  if(window.jQuery) {
    cb(window.jQuery);
  }

  var jq = document.createElement('script');
  jq.type = 'text/javascript';
  jq.src = ('https:' == document.location.protocol ? 'https://' : 'http://') + 'ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js';
  var sc = document.getElementsByTagName('script')[0];
  sc.parentNode.insertBefore(jq, sc);

  // Poll for jQuery to come into existance
  var checkJQReady = function(callback) {
    if (window.jQuery) {
      callback(jQuery);
    }
    else {
      window.setTimeout(function() { checkJQReady(callback); }, 100);
    }
  };

  checkJQReady(function() {
    jQuery.noConflict();
    cb(jQuery);
  });
};

A17.Helpers.load_jquery_panzoom = function(cb) {
  if(typeof jQuery.Panzoom !== 'undefined') {
    cb();
  }

  var jq = document.createElement('script');
  jq.type = 'text/javascript';
  jq.src = ('https:' == document.location.protocol ? 'https://' : 'http://') + 'cdnjs.cloudflare.com/ajax/libs/jquery.panzoom/2.0.5/jquery.panzoom.js';
  var sc = document.getElementsByTagName('script')[0];
  sc.parentNode.insertBefore(jq, sc);

  // Poll for jQuery to come into existance
  var checkReady = function(callback) {
    if (typeof jQuery.Panzoom !== 'undefined') {
      callback(jQuery.Panzoom);
    }
    else {
      window.setTimeout(function() { checkReady(callback); }, 100);
    }
  };

  checkReady(function() {
    cb();
  });
};A17.Helpers.oritentation_change_fix = function() {
  /*

    # A17.Helpers.oritentation_change_fix
    * v.1

    ## description
    Stopping iOS devices scaling up when rotating from portrait to landcape

    ## requires
    * nothing

    ## parameters
    * none

    ## returns
    * nothing

    ## example usage:
    ```js
    A17.Helpers.oritentation_change_fix();
    // (included at the bottom of this file)
    ```

    ## thanks to
    http://stackoverflow.com/questions/5434656/ipad-layout-scales-up-when-rotating-from-portrait-to-landcape
  */
  if (navigator.userAgent.match(/iPhone/i) || navigator.userAgent.match(/iPad/i)) {
      var viewportmeta = document.querySelector('meta[name="viewport"]');
      if (viewportmeta) {
          viewportmeta.content = 'width=device-width, minimum-scale=1.0, maximum-scale=1.0, initial-scale=1.0';
          document.body.addEventListener('gesturestart', function () {
              viewportmeta.content = 'width=device-width, minimum-scale=0.25, maximum-scale=1.6';
          }, false);
      }
  }
};
A17.Helpers.oritentation_change_fix();// shim layer with setTimeout fallback
window.requestAnimFrame = (function(){
  return  window.requestAnimationFrame       ||
          window.webkitRequestAnimationFrame ||
          window.mozRequestAnimationFrame    ||
          function( callback ){
            window.setTimeout(callback, 1000 / 60);
          };
})();A17.Helpers.resized = function() {
  /*

    # A17.Helpers.resized
    * v.1

    ## description
    What to do on document resize, also checks if current media query has changed

    ## requires
    * A17.Helpers.get_media_query_in_use
    * global variable of: A17.media_query_in_use

    ## parameters
    * none

    ## returns
    * sets A17.media_query_in_use to new value
    * fires events to tell application about resize and media query update

    ## example usage:
    ```js
    // on resize, check
    var resize_timer;
    window.on('resize', function(event){
      clearTimeout(resize_timer);
      resize_timer = setTimeout(function(){
        A17.Helpers.resized();
      },250);
    });
    ```
  */

  fireevent("resized");

  if (!A17.Helpers.get_media_query_in_use) {
    console.log("Missing: A17.Helpers.get_media_query_in_use");
    return false;
  }

  var new_media_query = A17.Helpers.get_media_query_in_use();
  if (A17.media_query_in_use != new_media_query) {
    A17.media_query_in_use = A17.Helpers.get_media_query_in_use();
    // update the image sizes
    fireevent("media_query_updated");
  }

  function fireevent(type) {
    var event = document.createEvent('HTMLEvents');
    event.initEvent(type, true, true);
    event.eventName = type;
    event.target = document;
    document.dispatchEvent(event);
  }
};// Custom SA scroll
A17.Helpers.scroll = (function() {

    var elementPosition = function(a) {
        return function() {
            return a.getBoundingClientRect().top - 400;
        };
    };

    var scrolling = function( elementID ) {

        var el = document.getElementById( elementID ),
            elPos = elementPosition( el ),
            duration = 20,
            increment = Math.round( Math.abs( elPos() )/50 ),
            time = Math.round( duration/increment ),
            last = 0,
            E;

        function scroller() {
            E = elPos();
            
            if (E === last) {
                return;
            } else {
                last = E;
            }

            increment = (E > -100 && E < 100) ? ((E > - 5 && E < 5) ? 1 : 5) : increment;

            if (E > 1 || E < -1) {

                if (E < 0) {
                    window.scrollBy( 0,-increment );
                } else {
                    window.scrollBy( 0,increment );
                }

                setTimeout(scroller, time);

            }
        }

        scroller();
    };

    return {
        To: scrolling
    }

})();function __scrollTo(element, to, duration) {
  if (duration < 0) {
    return;
  }
  var difference = to - element.scrollTop;
  var perTick = difference / duration * 10;

  setTimeout(function() {
      element.scrollTop = element.scrollTop + perTick;
      if (element.scrollTop === to) {
        return;
      }
      __scrollTo(element, to, duration - 10);
  }, 10);
}

A17.Helpers.scrollTo = function(element, offset, duration) {
  offset = typeof offset !== 'undefined' ? offset : 0;
  duration = typeof duration !== 'undefined' ? duration : 200;
  var to = (element.offsetTop - offset);

  if(typeof document.body.scrollTop !== 'undefined') {
    __scrollTo(document.body, to, duration);
  } else {
    __scrollTo(document.documentElement, to, duration);
  }
};A17.Helpers.toggleClass = function(node, class_) {
  if(A17.Helpers.hasClass(node, class_)) {
    $(node).removeClass(class_);
  } else {
    $(node).addClass(class_);
  }
};min$ = (function () {

  // Kill exeuction for bad browsers
  if(typeof document.querySelectorAll === undefined || !('addEventListener' in window) || !window.getComputedStyle || !Object.keys) {
    return;
  }

  // make $ collection objects
  function $(elements) {
    if (elements) {
      this.length = elements.length;
      for (var i = 0; i < this.length; i++) {
        this[i] = elements[i];
      }
    }
  }

  // a counter for unique event ids - used for namespacing event handlers
  var event_uuid = 0;
  // a store for events - used for namespacing event handlers
  var events_cache = {};

  // a breakable each function
  var each = function(arr,func) {
    var arr_length = arr.length;
    for (var i = 0; i < arr_length; i++) {
      var value = func.call(arr[i],arr[i],i);
      if (value === false) {
        break;
      }
    }
    return arr;
  };

  // the main methods of minjs
  $.prototype = {
    each:function(func){
      return each(this,func);
    },
    on:function(type,fn){
      each(this,function(el){
        event_uuid++;
        if (!el.handlers) {
          el.handlers = {};
        }
        // check for namespace
        var type_arr = type.split(".");
        // store event data
        el.handlers[event_uuid] = type;
        events_cache[event_uuid] = {
          type: type_arr[0],
          namespace: type_arr[1] || "",
          fn: fn
        };
        // add listener
        el.addEventListener(type_arr[0], fn, false);
      });
      // allow for chaining
      return this;
    },
    off:function(type){
      each(this,function(el){
        // check for namespace
        var node = el;
        var node_handlers = node.handlers || [];
        var type_arr = (typeof type === "undefined") ? [] : type.split(".");
        var event_type, event_namespace;
        //
        if (type_arr.length > 0) {
          event_type = type_arr[0] || "";
          event_namespace = type_arr[1] || "";
        }
        // loop handlers
        Object.keys(node_handlers).forEach(function(key){
          if (
            (type_arr.length === 0) || // off(); so remove all events from node
            (event_type === events_cache[key].type && event_namespace === events_cache[key].namespace) || // match type and namespace
            (event_type === events_cache[key].type && event_namespace === "") || // match type and no namespace
             (event_namespace === events_cache[key].namespace && event_type === "") // match namespace and no type
          ){
            // remove the listener
            node.removeEventListener(events_cache[key].type, events_cache[key].fn, false);
            // clean up after yourself
            delete node.handlers[key];
            delete events_cache[key];
          }
        });
      });
      // allow for chaining
      return this;
    },
    trigger:function(type,data){
      // construct an HTML event. This could have
      // been a real custom event
      var event = document.createEvent('HTMLEvents');
      event.initEvent(type, true, true);
      event.data = data || {};
      event.eventName = type;
      //
      each(this,function(el){
        event.target = el;
        el.dispatchEvent(event);
      });
      // allow for chaining
      return this;
    },
    addClass:function(className){
      each(this,function(el){
        if (el.classList) {
          el.classList.add(className);
        } else if (!min$(el).hasClass(className)) {
          el.className += ' ' + className;
        }
      });
      return this;
    },
    removeClass:function(className){
      each(this,function(el){
        if (el.classList) {
          el.classList.remove(className);
        } else {
          el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
        }
      });
      return this;
    },
    hasClass:function(className){
      var el = (this.length > 0) ? this[0] : this;
      if (!document.body.contains(el)) { return this; }
      if (el.classList) {
        return el.classList.contains(className);
      } else {
        return new RegExp('(^| )' + className + '( |$)', 'gi').test(el.className);
      }
    },
    attr:function(a,v){
      if (v === undefined) {
        var el = (this.length > 0) ? this[0] : this;
        if (!document.body.contains(el)) { return this; }
        return el.getAttribute(a);
      } else {
        each(this,function(el){
          el.setAttribute(a,v);
        });
        return this;
      }
    },
    css:function(p,v){
      if (typeof p === "object") {
        each(this,function(el){
          for (var n in p) {
            if (p.hasOwnProperty(n)) {
              el.style[n] = p[n];
            }
          }
        });
        return this;
      } else {
        if (v === undefined) {
          var el = (this.length > 0) ? this[0] : this;
          if (!document.body.contains(el)) { return this; }
          return window.getComputedStyle(el,null).getPropertyValue(p);
        } else {
          each(this,function(el){
            el.style[p] = v;
          });
          return this;
        }
      }
    },
    index:function(item){
      var n = -1;
      if (item) {
        item = (item.length > 0 || item.addClass) ? item[0] : item;
        if (!document.body.contains(item)) {
          return n;
        }
      } else {
        item = this[0] || this;
      }
      each(this,function(el,i){
        if (el === item) {
          n = i;
          return false;
        }
      });
      return n;
    }
  };

  function min$(selector,context){
    var nodes = [];
    if (selector && typeof selector !== "string") {
      nodes = (selector.addClass) ? selector : [selector];
    } else if (selector) {
      nodes = (context || document).querySelectorAll(selector || '☺');
    }
    return new $(nodes);
  }

  min$.each = each;

  min$.prototype = $.prototype;

  return min$;
})();/*
  a17_slider
  v0.0.1

*/
(function () {
  'use strict';

  window.a17_slider = function(options) {

    var defaults = {
      sliderContainer: undefined,
      sliderInner: undefined,
      slideAmount: undefined,
      paginator: undefined,
      itemsVisible: 1,
      scrollBySet: false,
      cloneAll: false,
      currentSet: 1,
      budge: 0,
      centered: false,
      looping: true,
      automate: false,
      interval: 5000,
      quickLinks: true,
      speed: 250,
      quickLinksChar: "bull",
      keyControls: true,
      swipable: true,
      swipeThreshold: 150
    };

    var this_instance = this;
    var reset = false; // controlled by the function for resetting the loop
    var hovering = false;
    var sliderMoving = false;
    var dragging = false;
    var rtl = a17S("html[dir=rtl]",document).length == 0 ? false : true;
    var directionRight = a17S("html[dir=rtl]",document).length == 0 ? 'right' : 'left';
    var directionLeft = a17S("html[dir=rtl]",document).length == 0 ? 'left' : 'right';
    var dataAttr = "data-a17slider-position";
    var dupeAttr = "data-a17slider-dupe";
    var this_instance_params, original_node, currentSliderPos, paginator, nextBtn, prevBtn, totalLi, maxSet, timer, slides, slidesWidths, middleItem, totalWidth, xDown, yDown, xDiff, yDiff, animationFrame;

    function init() {
      this_instance_params = defaults;
      options = options || {};
      for (var def in this_instance_params) {
        if (typeof options[def] !== 'undefined') {
            this_instance_params[def] = options[def];
        }
      }

      if (this_instance_params.sliderContainer == undefined || this_instance_params.sliderInner == undefined || this_instance_params.paginator == undefined ) {
        if (typeof console === "object") {
          console.warn("a17_slider: no sliderContainer, sliderInner or paginator specified");
        }
        return;
      }

      original_node = this_instance_params.sliderContainer.innerHTML;
      currentSliderPos = 0;
      nextBtn = a17S("li.next a",this_instance_params.paginator);
      prevBtn = a17S("li.prev a",this_instance_params.paginator);
      totalLi = nodeCount(this_instance_params.sliderInner);
      maxSet = Math.ceil(totalLi / this_instance_params.itemsVisible);
      slides = children(this_instance_params.sliderInner);
      slidesWidths = [];
      middleItem = Math.round(totalLi / 2) - 1;
      totalWidth = 0;
      //
      // set up
      if (this_instance_params.slideAmount === undefined) {
        this_instance_params.slideAmount = this_instance_params.sliderContainer.offsetWidth;
      }
      if (this_instance_params.automate) {
        this_instance_params.looping = true;
      }
      if (this_instance_params.slideAmount == "mixed") {
        this_instance_params.looping = true;
        this_instance_params.cloneAll = true;
        this_instance_params.itemsVisible = 1;
        this_instance_params.scrollBySet = false;
      } else if (this_instance_params.slideAmount < this_instance_params.sliderContainer.offsetWidth) {
        this_instance_params.cloneAll = true;
        this_instance_params.looping = true;
      }
      if (this_instance_params.currentSet > maxSet) {
        this_instance_params.currentSet = 1;
      }
      if (this_instance_params.scrollBySet && this_instance_params.itemsVisible === 1) {
        this_instance_params.scrollBySet = false;
      }
      this_instance_params.interval = this_instance_params.interval * 1000;

      // ###############################################################
      // Determining slide amount incase not known

      if (this_instance_params.slideAmount == "mixed") {
        Array.prototype.forEach.call(slides, function(slide, i){
          var width = attr(slide,"width") * 1 || slide.offsetWidth;
          slidesWidths.push(width);
          totalWidth += width;
        });
      } else {
        Array.prototype.forEach.call(slides, function(slide, i){
          slidesWidths.push(this_instance_params.slideAmount);
        });
        totalWidth = (this_instance_params.scrollBySet) ? this_instance_params.slideAmount * maxSet : this_instance_params.slideAmount * totalLi;
      }

      // ###############################################################
      // adding helper numbers

      Array.prototype.forEach.call(slides, function(node, i){
        attr(node,dataAttr,i);
      });
      // do the required cloning to do the infinite looping trick
      if (this_instance_params.looping && this_instance_params.itemsVisible == 1 && totalLi > this_instance_params.itemsVisible && !this_instance_params.centered && !this_instance_params.cloneAll) {

        var first_child = a17S("li:first-child",this_instance_params.sliderInner).cloneNode(true);
        var last_child = a17S("li:last-child",this_instance_params.sliderInner).cloneNode(true);

        attr(first_child,dupeAttr,"");
        attr(last_child,dupeAttr,"");

        tabIndexMinus1(first_child);
        tabIndexMinus1(last_child);

        this_instance_params.sliderInner.appendChild(first_child);
        this_instance_params.sliderInner.insertBefore(last_child, this_instance_params.sliderInner.firstChild);

        slides = children(this_instance_params.sliderInner);

        this_instance_params.budge = this_instance_params.budge - slidesWidths[0];

      } else if (this_instance_params.looping && totalLi > this_instance_params.itemsVisible || this_instance_params.centered || this_instance_params.cloneAll) {

        // check the amount of LIs, make to a division of o.itemsVisible
        // and then keep checking until it is
        for (var i = 1; i <= this_instance_params.itemsVisible; i++) {
          var isEvenTest = totalLi % this_instance_params.itemsVisible;
          if ((isEvenTest * 1) > 0) {
            var $new_li = document.createElement('li');
            $new_li.className = "blank";
            slides.push($new_li);
            totalLi = slides.length;
          }
        }

        // get the first and last sets
        var firstSet = [];
        var lastSet = [];
        Array.prototype.forEach.call(slides, function(node, i){
          var node_dupe = node.cloneNode(true);
          if (i < this_instance_params.itemsVisible && !this_instance_params.cloneAll) {
            attr(node_dupe,dupeAttr,"");
            tabIndexMinus1(node_dupe);
            firstSet.push(node_dupe);
          }
          if (i >= totalLi - this_instance_params.itemsVisible && !this_instance_params.cloneAll) {
            attr(node_dupe,dupeAttr,"");
            tabIndexMinus1(node_dupe);
            lastSet.push(node_dupe);
          }
          if (this_instance_params.cloneAll) {
            attr(node,dupeAttr,"");
            tabIndexMinus1(node_dupe);
            firstSet.push(node_dupe);
            lastSet.push(node_dupe);
          }
        });
        //
        // concat all together
        slides = lastSet.concat(slides,firstSet);
        // generate new slider html
        var new_slide_html = "";
        Array.prototype.forEach.call(slides, function(node, i){
          new_slide_html += node.outerHTML;
        });
        // and insert it
        this_instance_params.sliderInner.innerHTML = new_slide_html;
        // update slides var
        slides = children(this_instance_params.sliderInner);
        //
        if (this_instance_params.cloneAll) {
          this_instance_params.budge = this_instance_params.budge - totalWidth;
        } else {
          this_instance_params.budge = this_instance_params.budge - slidesWidths[0];
        }
      }

      // ###############################################################
      // init lazy lazy load
      loadImages();

      // ###############################################################
      // update the initial slider position
      currentSliderPos = calcCurrentSliderPos();
      //
      updatePosition();

      // ###############################################################
      // set up to allow transitions
      toggleTransitionClass("add");

      // ###############################################################
      // if swipable, add webkit cursor for grabbing
      if (this_instance_params.swipable) {
        css(this_instance_params.sliderInner,"cursor","-webkit-grab");
      }

      // ###############################################################
      // hide/show next/prev and draw in quicklink indicators
      setUpPaginator();

      // ###############################################################
      // go go go
      setUpInteractions();
      trigger("slider_setup_complete");
    }

    // ###############################################################
    // Internal Functions

    function a17S(s,c) {
      var r = (c || this_instance_params.sliderContainer).querySelectorAll(s || '☺');
      return (r.length == 1) ? r[0] : r;
    }

    function css(el,p,v) {
      if (typeof p === "object") {
        for (var n in p) {
          el.style[n] = p[n];
        }
        return this;
      } else {
        if (v === undefined) {
          return document.defaultView.getComputedStyle(el,null).getPropertyValue(p);
        } else {
          el.style[p] = v;
          return el;
        }
      }
    }

    function attr(el,a,v) {
      if (v === undefined) {
        return el.getAttribute(a);
      } else {
        el.setAttribute(a,v);
        return el;
      }
    }

    function addClass(el,c) {
      if (el.classList) {
        el.classList.add(c);
      } else {
        el.className += ' ' + c;
      }
    }

    function removeClass(el,c) {
      if (el.classList) {
        el.classList.remove(c);
      } else {
        el.className = el.className.replace(new RegExp('(^|\\b)' + c.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
      }
    }

    function hasClass(el,c) {
      if (el.classList) {
        return el.classList.contains(c);
      } else {
        return new RegExp('(^| )' + c + '( |$)', 'gi').test(el.className);
      }
    }

    function children(el){
      var nodes = el.childNodes;
      var nodes_arr = [];
      Array.prototype.forEach.call(nodes, function(node, i){
        if (node.nodeType === 1) {
          nodes_arr.push(node);
        }
      });
      return nodes_arr;
    }

    function nodeCount(el){
      return children(el).length;
    };

    function trigger(type){
      var event = document.createEvent('HTMLEvents');
      event.initEvent(type, true, true);
      event.data = {
        container: this_instance_params.sliderContainer,
        currentSet: this_instance_params.currentSet
      };
      event.eventName = type;
      this_instance_params.sliderContainer.dispatchEvent(event);
    }

    function loadImages() {
      // just loops through the images and fades them in on load
      var elements = a17S("img[data-src]",this_instance_params.sliderInner);
      Array.prototype.forEach.call(elements, function(el, i){
        var newImage = new Image();
        var $this = el;
        //
        newImage.onload = function () {
          if ($this.css("opacity") == 0) {
            $this.css("opacity","1");
          }
        }
        if ($this.attr("src") == "") {
          newImage.src = $this.attr("data-src") || $this.attr("src");
        }
      });
    }

    function updatePosition(pos) {
      try{
        // stopping hangs when an updatePosition is superceeded by a later animation frame
        window.cancelAnimationFrame(animationFrame);
      } catch(err) {}
      if (pos) {
        // used while dragging
        var to = (rtl) ? pos * -1 : pos;
        animationFrame = window.requestAnimationFrame(function(){
          writeLeftPos(to);
        });
      } else {
        // regular moves
        writeLeftPos(currentSliderPos);
      }
    }

    function writeLeftPos(pos) {
      css(this_instance_params.sliderInner,{
        "-webkit-transform": "translateX("+pos+"px)",
        "-moz-transform": "translateX("+pos+"px)",
        "-ms-transform": "translateX("+pos+"px)",
        "transform": "translateX("+pos+"px)"
      });
    }

    function moveSlider(direction) {
      if (!sliderMoving) {
        calculateNextPosition(direction);
        sliderMoving = true;
        //
        updatePosition();
        setTimeout(function(){
          if (reset) {
            currentSliderPos = calcCurrentSliderPos();
            toggleTransitionClass("remove");
            updatePosition();
            toggleTransitionClass("add");
          }
          sliderMoving = false;

          trigger("slider_moved");
          if (!hovering) {
            auto();
          }
        },this_instance_params.speed);
        //
        trigger("slider_moving");
        //
        updatePaginator();
      }
    }

    function calculateNextPosition(direction) {
      if (direction == directionRight) {
        //
        if (this_instance_params.centered) {
          currentSliderPos -= (this_instance_params.sliderContainer.offsetWidth - slidesWidths[this_instance_params.currentSet - 1])/2;
        }
        if (this_instance_params.slideAmount == "mixed") {
          currentSliderPos -= slidesWidths[this_instance_params.currentSet - 1];
        } else {
          currentSliderPos -= this_instance_params.slideAmount;
        }
        //
        if (this_instance_params.looping && this_instance_params.currentSet == maxSet) {
          reset = true;
          this_instance_params.currentSet = 1;
        } else {
          this_instance_params.currentSet++;
        }
        //
        if (this_instance_params.centered) {
          currentSliderPos += (this_instance_params.sliderContainer.offsetWidth - slidesWidths[this_instance_params.currentSet - 1])/2;
        }
        //
      } else if (direction == directionLeft) {
        if (this_instance_params.centered) {
          currentSliderPos -= (this_instance_params.sliderContainer.offsetWidth - slidesWidths[this_instance_params.currentSet - 1])/2;
        }
        //
        if (this_instance_params.looping && this_instance_params.currentSet == 1) {
          reset = true;
          this_instance_params.currentSet = maxSet;
        } else {
          this_instance_params.currentSet--;
        }
        //
        if (this_instance_params.centered) {
          currentSliderPos += (this_instance_params.sliderContainer.offsetWidth - slidesWidths[this_instance_params.currentSet - 1])/2;
        }
        if (this_instance_params.slideAmount == "mixed") {
          currentSliderPos += slidesWidths[this_instance_params.currentSet - 1];
        } else {
          currentSliderPos += this_instance_params.slideAmount;
        }
        //
      } else {
        this_instance_params.currentSet = direction;
        currentSliderPos = calcCurrentSliderPos();
      }
    }

    function calcCurrentSliderPos() {
      var init_pos = 0;
      for (var i = 0; i < this_instance_params.currentSet - 1; i++) {
        init_pos += slidesWidths[i];
      }
      if (this_instance_params.centered) {
        init_pos -= (this_instance_params.sliderContainer.offsetWidth - slidesWidths[this_instance_params.currentSet - 1])/2;
      }
      return this_instance_params.budge + (init_pos * -1);
    }


    function updatePaginator() {
      if (!this_instance_params.looping) {
        addClass(prevBtn,"disabled");
        addClass(nextBtn,"disabled");

        if (this_instance_params.currentSet > 1) {
          removeClass(prevBtn,"disabled");
        }
        if (this_instance_params.scrollBySet) {
          if (o.currentSet < maxSet) {
            removeClass(nextBtn,"disabled");
          }
        } else {
          if (this_instance_params.currentSet + this_instance_params.itemsVisible < totalLi + 1) {
            removeClass(nextBtn,"disabled");
          }
        }
      }
      if (this_instance_params.quickLinks) {
        try {
          removeClass(a17S("li.current",this_instance_params.paginator),"current");
        } catch(err) {};
        addClass(a17S("li:nth-child("+this_instance_params.currentSet+")",this_instance_params.paginator),"current");
      }

      // sort visible class out
      Array.prototype.forEach.call(children(this_instance_params.sliderInner), function(slide, i){
        removeClass(slide,"a17s_visible");
      });
      var active_slides_search = "";
      for (var i = 0; i < this_instance_params.itemsVisible; i++) {
        if (i > 0) {
          active_slides_search += ",";
        }
        active_slides_search += "li["+dataAttr+"=\""+(((this_instance_params.currentSet-1)*this_instance_params.itemsVisible)+i)+"\"]";
      }

      var active_slides = a17S(active_slides_search,this_instance_params.sliderInner);

      if(typeof active_slides.length === 'undefined') {
        active_slides = [active_slides];
      }

      Array.prototype.forEach.call(active_slides, function(slide, i){
        addClass(slide,"a17s_visible");

        if (hasClass(slide, "slideshow-ad") && slide.hasAttribute('data-a17slider-dupe') && !slide.hasAttribute('data-slideshow-active')) {
          var slotName = dfp.slideshow.name + attr(slide, "data-slideshow-count");
          dfp.slideshow.count++;
          var adPosition = "slideshow"+dfp.slideshow.count;

          var adSlotDiv = document.createElement('div');
          adSlotDiv.id = slotName;
          slide.children[0].children[0].children[0].appendChild(adSlotDiv);
          
          googletag.cmd.push(function() {
            gptadslots.push( googletag.defineSlot(dfp.adUnit, dfp.slideshow.sizes, slotName).
            defineSizeMapping(dfp.slideshow.mapping).
            setTargeting('position', adPosition).
            addService(googletag.pubads()) );

            googletag.display(slotName);
            //googletag.pubads().refresh([slot]);
          });

          attr(slide, "data-slideshow-active", "");

        }

      });
    }

    function auto() {
      if (this_instance_params.automate) {
        // if we're automating..
        clearTimeout(timer); // clear the timeout var, so it doesn't bubble itself into a mess
        timer = setTimeout(openNext, this_instance_params.interval); // set the timer again
      }
    }

    function halt_auto() {
      clearTimeout(timer);
      hovering = true;
    }

    function openNext() {
      moveSlider('right');
    }

    function setUpPaginator() {
      if (this_instance_params.currentSet == 1 && maxSet == 1) {
        nextBtn.style.display = "none";
        prevBtn.style.display = "none";
        this_instance_params.paginator.style.display = "none";
      } else {
        if (this_instance_params.quickLinks) {
          var pages = "";
          var loopUntil = (this_instance_params.scrollBySet) ? maxSet : totalLi;
          for (var i = 0; i < loopUntil; i++) {
            if (this_instance_params.quickLinksChar == "bull") {
              pages = pages + '<li><a href="#">&bull;</a></li>';
            } else {
              pages = pages + '<li><a href="#">' + (i + 1) + '</a></li>';
            }
          }
          this_instance_params.paginator.innerHTML = pages + this_instance_params.paginator.innerHTML;
          nextBtn = a17S("li.next a",this_instance_params.paginator);
          prevBtn = a17S("li.prev a",this_instance_params.paginator);
        }
        //
        updatePaginator();
        timer = setTimeout(auto, 50); // set the automatic swap happening
      }
    }

    function setUpInteractions() {
      if (this_instance_params.currentSet == 1 && maxSet == 1) {
        return;
      }
      // ###############
      // mouse events
      // add some events to the slider buttons
      prevBtn.addEventListener("click",function(event) {
        event.preventDefault();
        if (this_instance_params.looping) {
          moveSlider('left');
        } else {
          if (!hasClass(this,"disabled")) {
            moveSlider('left');
          }
        }
      },false);
      nextBtn.addEventListener("click",function(event) {
        event.preventDefault();
        if (this_instance_params.looping) {
          moveSlider('right');
        }
        else {
          if (!hasClass(this,"disabled")) {
            moveSlider('right');
          }
        }
      },false);
      //
      if (this_instance_params.quickLinks) {
        var paginator_btns = a17S("li:not(.next):not(.prev) a",this_instance_params.paginator);
        Array.prototype.forEach.call(paginator_btns, function(a, i){
          a.addEventListener("click",function(event){
            event.preventDefault();
            if (i < maxSet && !hasClass(this.parentNode,"current")) {
              moveSlider(i + 1);
            }
          });
        });
      }
      //
      // if you hover over the slider to read the content, it stops the automatic transition
      this_instance_params.sliderContainer.addEventListener("mouseenter",function() {
        clearTimeout(timer);
        hovering = true;
      },false);
      // and restarts it when you roll out
      this_instance_params.sliderContainer.addEventListener("mouseleave",function() {
        auto();
        hovering = false;
      },false);
      //
      // ###############
      // add keyboard controls
      if (this_instance_params.keyControls) {
        // on left and right arrow key down, highlight the button as though mouse over
        document.addEventListener("keydown",function (event) {
          switch (event.keyCode) {
            case 37:
              // left arrow
              addClass(prevBtn,"active");
              break;
            case 39:
              // right arrow
              addClass(nextBtn,"active");
              break;
          }
        },false);
        // on left and right arrow key up, un highlight and trigger movement
        document.addEventListener("keyup",function (event) {
          switch (event.keyCode) {
            case 37:
              // move left
              removeClass(prevBtn,"active");
              if (this_instance_params.looping) {
                moveSlider('left');
              } else {
                if (!hasClass(prevBtn,"disabled")) {
                  moveSlider('left');
                }
              }
              break;
            case 39:
              // move right
              removeClass(nextBtn,"active");
              if (this_instance_params.looping) {
                moveSlider('right');
              } else {
                if (!hasClass(nextBtn,"disabled")) {
                  moveSlider('right');
                }
              }
              break;
          }
        });
      }
      //
      // ###############
      // add drag/swipes
      if (this_instance_params.swipable) {
        // mouse events
        this_instance_params.sliderInner.addEventListener("mousedown",function(event){
          event.preventDefault();
          xDown = document.all ? window.event.clientX : event.pageX;
          yDown = document.all ? window.event.clientY : event.pageY;
          onDraggingStart();
        },false);
        document.addEventListener("mousemove",function(event){
          onDragging(
            (document.all ? window.event.clientX : event.pageX),
            (document.all ? window.event.clientY : event.pageY)
          );
        },false);
        document.addEventListener("mouseup",function(event){
          onDraggingEnd();
        },false);

        // touch events
        this_instance_params.sliderInner.addEventListener("touchstart",function(event){
          xDown = event.touches[0].clientX;
          yDown = event.touches[0].clientY;
          onDraggingStart();
        },false);
        this_instance_params.sliderInner.addEventListener("touchmove",function(event){
          onDragging(event.changedTouches[0].clientX, event.changedTouches[0].clientY);
        });
        this_instance_params.sliderInner.addEventListener("touchend",function(event){
          onDraggingEnd();
        },false);
      }
      //
      // ###############
      // watch for focus events
      Array.prototype.forEach.call(slides, function(slide, i){
        var slide_links = slide.querySelectorAll("a");
        Array.prototype.forEach.call(slide_links, function(link, i){
          link.addEventListener("focus",function(event){
            this_instance_params.sliderContainer.scrollLeft = 0;
            // oh webkit!
            setTimeout(function() {
              this_instance_params.sliderContainer.scrollLeft = 0;
            }, 0);
            // stop automation
            clearTimeout(timer);
            // jump to focussed position
            var position_focussed = parseInt(attr(slide,dataAttr)) || -1;
            if (position_focussed) {
              if (this_instance_params.itemsVisible > 1) {
                position_focussed = Math.floor(position_focussed/this_instance_params.itemsVisible);
              }
              moveSlider(position_focussed + 1);
            }
          });
        });
      });
    }

    function toggleTransitionClass(action){
      var redraw = this_instance_params.sliderInner.offsetHeight; // bash
      if (action === "add") {
        addClass(this_instance_params.sliderInner,"a17s_transition");
      } else {
        removeClass(this_instance_params.sliderInner,"a17s_transition");
      }
      var redraw = this_instance_params.sliderInner.offsetHeight; // bash
    }

    function onDraggingStart(event) {
      toggleTransitionClass("remove");
      dragging = true;
      halt_auto();
      css(this_instance_params.sliderInner,"cursor","-webkit-grabbing");
    }

    function onDragging(xUp,yUp) {
      if (dragging) {
        if (!xDown || !yDown) {
          return;
        }
        //
        xDiff = xDown - xUp;
        yDiff = yDown - yUp;
        // horizontal or vertical swipe */
        if (Math.abs(xDiff) > Math.abs(yDiff)) {
          if (xDiff > 0) {
            if (hasClass(nextBtn,"disabled")) {
              xDiff = rubberBand(xDiff);
            }
            // left swipe
            updatePosition(currentSliderPos-xDiff);
          } else if (xDiff < 0) {
            if (hasClass(prevBtn,"disabled")) {
              xDiff = rubberBand(xDiff);
            }
            // right swipe
            updatePosition(currentSliderPos-xDiff);
          }
        } else {
          return;
        }
      }
    }

    function onDraggingEnd() {
      if (dragging) {
        dragging = false;
        toggleTransitionClass("add");
        css(this_instance_params.sliderInner,"cursor","-webkit-grab");
        if (!xDown || !yDown || xDiff === undefined || yDiff === undefined) {
          return;
        }
        if (Math.abs(xDiff) > Math.abs(yDiff)) {
          if (Math.abs(xDiff) <= this_instance_params.swipeThreshold) {
            // didn't swipe far enough - reset
            updatePosition();
            auto();
          } else {
            if (xDiff > this_instance_params.swipeThreshold && !hasClass(nextBtn,"disabled")) {
              // left swipe beyond threshold
              moveSlider('right');
            } else if (xDiff < (this_instance_params.swipeThreshold * -1) && !hasClass(prevBtn,"disabled")) {
              // right swipe beyond threshold
              moveSlider('left');
            } else {
              // next/prev button disabled, reset
              updatePosition();
              auto();
            }
          }
        }
        resetDragVars();
      }
    }

    function resetDragVars() {
      xDown = undefined;
      yDown = undefined;
      xDiff = undefined;
      yDiff = undefined;
    }

    function tabIndexMinus1(node) {
      Array.prototype.forEach.call(node.querySelectorAll("a"), function(node, i){
        node.tabIndex = -1;
      });
    }

    function rubberBand(diff) {
      var ratio = Math.abs(diff) / 75;
      var factor = 1 / (ratio + 1);
      return diff * factor;
    }

    // ###############################################################
    // Methods
    this_instance.move = function(direction){
      moveSlider(direction);
    };
    this_instance.currentSet = function() {
      return defaults.currentSet;
    };
    this_instance.destroy = function() {
      this_instance_params.sliderContainer.innerHTML = original_node;
      delete this_instance["move"];
      delete this_instance["currentSet"];
      delete this_instance["destroy"];
      trigger("slider_destroyed");
      this_instance = null;
    };

    init();

    return this_instance;

  };

})();/*!
* Clamp.js 0.5.1
*
* Copyright 2011-2013, Joseph Schmitt http://joe.sh
* Released under the WTFPL license
* http://sam.zoy.org/wtfpl/
*/

(function(){
    /**
     * Clamps a text node.
     * @param {HTMLElement} element. Element containing the text node to clamp.
     * @param {Object} options. Options to pass to the clamper.
     */
    function clamp(element, options) {
        options = options || {};

        var self = this,
            win = window,
            opt = {
                clamp:              options.clamp || 2,
                useNativeClamp:     typeof(options.useNativeClamp) != 'undefined' ? options.useNativeClamp : true,
                splitOnChars:       options.splitOnChars || ['.', '-', '–', '—', ' '], //Split on sentences (periods), hypens, en-dashes, em-dashes, and words (spaces).
                animate:            options.animate || false,
                truncationChar:     options.truncationChar || '…',
                truncationHTML:     options.truncationHTML
            },

            sty = element.style,
            originalText = element.innerHTML,

            supportsNativeClamp = typeof(element.style.webkitLineClamp) != 'undefined',
            clampValue = opt.clamp,
            isCSSValue = clampValue.indexOf && (clampValue.indexOf('px') > -1 || clampValue.indexOf('em') > -1),
            truncationHTMLContainer;

        if (opt.truncationHTML) {
            truncationHTMLContainer = document.createElement('span');
            truncationHTMLContainer.innerHTML = opt.truncationHTML;
        }


// UTILITY FUNCTIONS __________________________________________________________

        /**
         * Return the current style for an element.
         * @param {HTMLElement} elem The element to compute.
         * @param {string} prop The style property.
         * @returns {number}
         */
        function computeStyle(elem, prop) {
            if (!win.getComputedStyle) {
                win.getComputedStyle = function(el, pseudo) {
                    this.el = el;
                    this.getPropertyValue = function(prop) {
                        var re = /(\-([a-z]){1})/g;
                        if (prop == 'float') prop = 'styleFloat';
                        if (re.test(prop)) {
                            prop = prop.replace(re, function () {
                                return arguments[2].toUpperCase();
                            });
                        }
                        return el.currentStyle && el.currentStyle[prop] ? el.currentStyle[prop] : null;
                    }
                    return this;
                }
            }

            return win.getComputedStyle(elem, null).getPropertyValue(prop);
        }

        /**
         * Returns the maximum number of lines of text that should be rendered based
         * on the current height of the element and the line-height of the text.
         */
        function getMaxLines(height) {
            var availHeight = height || element.clientHeight,
                lineHeight = getLineHeight(element);

            return Math.max(Math.floor(availHeight/lineHeight), 0);
        }

        /**
         * Returns the maximum height a given element should have based on the line-
         * height of the text and the given clamp value.
         */
        function getMaxHeight(clmp) {
            var lineHeight = getLineHeight(element);
            return lineHeight * clmp;
        }

        /**
         * Returns the line-height of an element as an integer.
         */
        function getLineHeight(elem) {
            var lh = computeStyle(elem, 'line-height');
            if (lh == 'normal') {
                // Normal line heights vary from browser to browser. The spec recommends
                // a value between 1.0 and 1.2 of the font size. Using 1.1 to split the diff.
                lh = parseInt(computeStyle(elem, 'font-size')) * 1.2;
            }
            return parseInt(lh);
        }


// MEAT AND POTATOES (MMMM, POTATOES...) ______________________________________
        var splitOnChars = opt.splitOnChars.slice(0),
            splitChar = splitOnChars[0],
            chunks,
            lastChunk;

        /**
         * Gets an element's last child. That may be another node or a node's contents.
         */
        function getLastChild(elem) {
            //Current element has children, need to go deeper and get last child as a text node
            if (elem.lastChild.children && elem.lastChild.children.length > 0) {
                return getLastChild(Array.prototype.slice.call(elem.children).pop());
            }
            //This is the absolute last child, a text node, but something's wrong with it. Remove it and keep trying
            else if (!elem.lastChild || !elem.lastChild.nodeValue || elem.lastChild.nodeValue == '' || elem.lastChild.nodeValue == opt.truncationChar) {
                elem.lastChild.parentNode.removeChild(elem.lastChild);
                return getLastChild(element);
            }
            //This is the last child we want, return it
            else {
                return elem.lastChild;
            }
        }

        /**
         * Removes one character at a time from the text until its width or
         * height is beneath the passed-in max param.
         */
        function truncate(target, maxHeight) {

            if (!maxHeight) {return;}

            /**
             * Resets global variables.
             */
            function reset() {
                splitOnChars = opt.splitOnChars.slice(0);
                splitChar = splitOnChars[0];
                chunks = null;
                lastChunk = null;
            }

            var nodeValue = target.nodeValue.replace(opt.truncationChar, '');

            //Grab the next chunks
            if (!chunks) {
                //If there are more characters to try, grab the next one
                if (splitOnChars.length > 0) {
                    splitChar = splitOnChars.shift();
                }
                //No characters to chunk by. Go character-by-character
                else {
                    splitChar = '';
                }

                chunks = nodeValue.split(splitChar);
            }

            //If there are chunks left to remove, remove the last one and see if
            // the nodeValue fits.
            if (chunks.length > 1) {
                // console.log('chunks', chunks);
                lastChunk = chunks.pop();
                // console.log('lastChunk', lastChunk);
                applyEllipsis(target, chunks.join(splitChar));
            }
            //No more chunks can be removed using this character
            else {
                chunks = null;
            }

            //Insert the custom HTML before the truncation character
            if (truncationHTMLContainer) {
                target.nodeValue = target.nodeValue.replace(opt.truncationChar, '');
                element.innerHTML = target.nodeValue + ' ' + truncationHTMLContainer.innerHTML + opt.truncationChar;
            }

            //Search produced valid chunks
            if (chunks) {
                //It fits
                if (element.clientHeight <= maxHeight) {

                    //There's still more characters to try splitting on, not quite done yet
                    if (splitOnChars.length >= 0 && splitChar != '') {
                        applyEllipsis(target, chunks.join(splitChar) + splitChar + lastChunk);
                        chunks = null;
                    }
                    //Finished!
                    else {
                      return element.innerHTML;
                    }
                }
            }
            //No valid chunks produced
            else {
                //No valid chunks even when splitting by letter, time to move
                //on to the next node
                if (splitChar == '') {
                    applyEllipsis(target, '');
                    target = getLastChild(element);

                    reset();
                }
            }

            //If you get here it means still too big, let's keep truncating
            if (opt.animate) {
                setTimeout(function() {
                    truncate(target, maxHeight);
                }, opt.animate === true ? 10 : opt.animate);
            }
            else {
                return truncate(target, maxHeight);
            }
        }

        function applyEllipsis(elem, str) {
            elem.nodeValue = str + opt.truncationChar;
        }


// CONSTRUCTOR ________________________________________________________________

        if (clampValue == 'auto') {
            clampValue = getMaxLines();
        }
        else if (isCSSValue) {
            clampValue = getMaxLines(parseInt(clampValue));
        }

        var clampedText;
        if (supportsNativeClamp && opt.useNativeClamp) {
            sty.overflow = 'hidden';
            sty.textOverflow = 'ellipsis';
            sty.webkitBoxOrient = 'vertical';
            sty.display = '-webkit-box';
            sty.webkitLineClamp = clampValue;

            if (isCSSValue) {
                sty.height = opt.clamp + 'px';
            }
        }
        else {
            var height = getMaxHeight(clampValue);
            if (height <= element.clientHeight) {
                clampedText = truncate(getLastChild(element), height);
            }
        }

        return {
            'original': originalText,
            'clamped': clampedText
        }
    }

    window.$clamp = clamp;
})();/*! fontfaceonload - v0.1.6 - 2015-03-13
 * https://github.com/zachleat/fontfaceonload
 * Copyright (c) 2015 Zach Leatherman (@zachleat)
 * MIT License */

;(function( win, doc ) {
  "use strict";

  var TEST_STRING = 'AxmTYklsjo190QW',
    SANS_SERIF_FONTS = 'sans-serif',
    SERIF_FONTS = 'serif',

    defaultOptions = {
      tolerance: 2, // px
      delay: 100,
      glyphs: '',
      success: function() {},
      error: function() {},
      timeout: 5000,
      weight: '400', // normal
      style: 'normal'
    },

    // See https://github.com/typekit/webfontloader/blob/master/src/core/fontruler.js#L41
    style = [
      'display:block',
      'position:absolute',
      'top:-999px',
      'left:-999px',
      'font-size:48px',
      'width:auto',
      'height:auto',
      'line-height:normal',
      'margin:0',
      'padding:0',
      'font-variant:normal',
      'white-space:nowrap'
    ],
    html = '<div style="%s">' + TEST_STRING + '</div>';

  var FontFaceOnloadInstance = function() {
    this.fontFamily = '';
    this.appended = false;
    this.serif = undefined;
    this.sansSerif = undefined;
    this.parent = undefined;
    this.options = {};
  };

  FontFaceOnloadInstance.prototype.getMeasurements = function () {
    return {
      sansSerif: {
        width: this.sansSerif.offsetWidth,
        height: this.sansSerif.offsetHeight
      },
      serif: {
        width: this.serif.offsetWidth,
        height: this.serif.offsetHeight
      }
    };
  };

  FontFaceOnloadInstance.prototype.load = function () {
    var startTime = new Date(),
      that = this,
      serif = that.serif,
      sansSerif = that.sansSerif,
      parent = that.parent,
      appended = that.appended,
      dimensions,
      options = this.options,
      ref = options.reference;

    function getStyle( family ) {
      return style
        .concat( [ 'font-weight:' + options.weight, 'font-style:' + options.style ] )
        .concat( "font-family:" + family )
        .join( ";" );
    }

    var sansSerifHtml = html.replace( /\%s/, getStyle( SANS_SERIF_FONTS ) ),
      serifHtml = html.replace( /\%s/, getStyle(  SERIF_FONTS ) );

    if( !parent ) {
      parent = that.parent = doc.createElement( "div" );
    }

    parent.innerHTML = sansSerifHtml + serifHtml;
    sansSerif = that.sansSerif = parent.firstChild;
    serif = that.serif = sansSerif.nextSibling;

    if( options.glyphs ) {
      sansSerif.innerHTML += options.glyphs;
      serif.innerHTML += options.glyphs;
    }

    function hasNewDimensions( dims, el, tolerance ) {
      return Math.abs( dims.width - el.offsetWidth ) > tolerance ||
          Math.abs( dims.height - el.offsetHeight ) > tolerance;
    }

    function isTimeout() {
      return ( new Date() ).getTime() - startTime.getTime() > options.timeout;
    }

    (function checkDimensions() {
      if( !ref ) {
        ref = doc.body;
      }
      if( !appended && ref ) {
        ref.appendChild( parent );
        appended = that.appended = true;

        dimensions = that.getMeasurements();

        // Make sure we set the new font-family after we take our initial dimensions:
        // handles the case where FontFaceOnload is called after the font has already
        // loaded.
        sansSerif.style.fontFamily = that.fontFamily + ', ' + SANS_SERIF_FONTS;
        serif.style.fontFamily = that.fontFamily + ', ' + SERIF_FONTS;
      }

      if( appended && dimensions &&
        ( hasNewDimensions( dimensions.sansSerif, sansSerif, options.tolerance ) ||
          hasNewDimensions( dimensions.serif, serif, options.tolerance ) ) ) {

        options.success();
      } else if( isTimeout() ) {
        options.error();
      } else {
        if( !appended && "requestAnimationFrame" in window ) {
          win.requestAnimationFrame( checkDimensions );
        } else {
          win.setTimeout( checkDimensions, options.delay );
        }
      }
    })();
  }; // end load()

  FontFaceOnloadInstance.prototype.cleanFamilyName = function( family ) {
    return family.replace( /[\'\"]/g, '' ).toLowerCase();
  };
  FontFaceOnloadInstance.prototype.cleanWeight = function( weight ) {
    // lighter and bolder not supported
    var weightLookup = {
      normal: '400',
      bold: '700'
    };

    return '' + (weightLookup[ weight ] || weight);
  };

  FontFaceOnloadInstance.prototype.checkFontFaces = function( timeout ) {
    var _t = this;
    doc.fonts.forEach(function( font ) {
      if( _t.cleanFamilyName( font.family ) === _t.cleanFamilyName( _t.fontFamily ) &&
        _t.cleanWeight( font.weight ) === _t.cleanWeight( _t.options.weight ) &&
        font.style === _t.options.style ) {
        font.load().then(function() {
          _t.options.success();
          win.clearTimeout( timeout );
        });
      }
    });
  };

  FontFaceOnloadInstance.prototype.init = function( fontFamily, options ) {
    var timeout;

    for( var j in defaultOptions ) {
      if( !options.hasOwnProperty( j ) ) {
        options[ j ] = defaultOptions[ j ];
      }
    }

    this.options = options;
    this.fontFamily = fontFamily;

    // For some reason this was failing on afontgarde + icon fonts.
    if( !options.glyphs && "fonts" in doc ) {
      if( options.timeout ) {
        timeout = win.setTimeout(function() {
          options.error();
        }, options.timeout );
      }

      this.checkFontFaces( timeout );
    } else {
      this.load();
    }
  };

  var FontFaceOnload = function( fontFamily, options ) {
    var instance = new FontFaceOnloadInstance();
    instance.init(fontFamily, options);

    return instance;
  };

  // intentional global
  win.FontFaceOnload = FontFaceOnload;
})( this, this.document );;(function(global) {

var hoverintent = function(el, over, out) {
  var x, y, pX, pY;
  var h = {},
    state = 0,
    timer = 0;

  var options = {
    sensitivity: 7,
    interval: 100,
    timeout: 0
  };

  var defaults = function(opt) {
    options = merge(opt || {}, options);
  };

  var merge = function(obj) {
    for (var i = 1; i < arguments.length; i++) {
      var def = arguments[i];
      for (var n in def) {
        if (obj[n] === undefined) obj[n] = def[n];
      }
    }
    return obj;
  };

  // Cross browser events
  var addEvent = function(object, event, method) {
    if (object.attachEvent) {
      object['e' + event + method] = method;
      object[event + method] = function() {
        object['e' + event + method](window.event);
      };
      object.attachEvent('on' + event, object[event + method]);
    } else {
      object.addEventListener(event, method, false);
    }
  };

  var removeEvent = function(object, event, method) {
    if (object.detachEvent) {
      object.detachEvent('on' + event, object[event + method]);
      object[event + method] = null;
    } else {
      object.removeEventListener(event, method, false);
    }
  };

  var track = function(e) {
    x = e.clientX;
    y = e.clientY;
  };

  var delay = function(el, outEvent, e) {
    if (timer) timer = clearTimeout(timer);
    state = 0;
    return outEvent.call(el, e);
  };

  var dispatch = function(e, event, over) {
    var tracker = function(e) {
      track(e);
    };

    if (timer) timer = clearTimeout(timer);
    if (over) {
      pX = e.clientX;
      pY = e.clientY;
      addEvent(el, 'mousemove', tracker);

      if (state !== 1) {
        timer = setTimeout(function() {
          compare(el, event, e);
        }, options.interval);
      }
    } else {
      removeEvent(el, 'mousemove', tracker);

      if (state === 1) {
        timer = setTimeout(function() {
          delay(el, event, e);
        }, options.timeout);
      }
    }
    return this;
  };

  var compare = function(el, overEvent, e) {
    if (timer) timer = clearTimeout(timer);
    if ((Math.abs(pX - x) + Math.abs(pY - y)) < options.sensitivity) {
      state = 1;
      return overEvent.call(el, e);
    } else {
      pX = x;
      pY = y;
      timer = setTimeout(function() {
        compare(el, overEvent, e);
      }, options.interval);
    }
  };

  // Public methods
  h.options = function(opt) {
    defaults(opt);
  };

  var dispatchOver = function(e) {
    dispatch(e, over, true);
  };
  var dispatchOut = function(e) {
    dispatch(e, out);
  };

  h.remove = function() {
    if (!el) return;
    removeEvent(el, 'mouseover', dispatchOver);
    removeEvent(el, 'mouseout', dispatchOut);
  };

  if (el) {
    addEvent(el, 'mouseover', dispatchOver);
    addEvent(el, 'mouseout', dispatchOut);
  }

  defaults();
  return h;
};

global.hoverintent = hoverintent;
if (typeof module !== 'undefined' && module.exports) module.exports = hoverintent;

})(this);/*! Picturefill - v2.3.1 - 2015-04-09
* http://scottjehl.github.io/picturefill
* Copyright (c) 2015 https://github.com/scottjehl/picturefill/blob/master/Authors.txt; Licensed MIT */
/*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight. Dual MIT/BSD license */

window.matchMedia || (window.matchMedia = function() {
	"use strict";

	// For browsers that support matchMedium api such as IE 9 and webkit
	var styleMedia = (window.styleMedia || window.media);

	// For those that don't support matchMedium
	if (!styleMedia) {
		var style       = document.createElement('style'),
			script      = document.getElementsByTagName('script')[0],
			info        = null;

		style.type  = 'text/css';
		style.id    = 'matchmediajs-test';

		script.parentNode.insertBefore(style, script);

		// 'style.currentStyle' is used by IE <= 8 and 'window.getComputedStyle' for all other browsers
		info = ('getComputedStyle' in window) && window.getComputedStyle(style, null) || style.currentStyle;

		styleMedia = {
			matchMedium: function(media) {
				var text = '@media ' + media + '{ #matchmediajs-test { width: 1px; } }';

				// 'style.styleSheet' is used by IE <= 8 and 'style.textContent' for all other browsers
				if (style.styleSheet) {
					style.styleSheet.cssText = text;
				} else {
					style.textContent = text;
				}

				// Test if media query is true or false
				return info.width === '1px';
			}
		};
	}

	return function(media) {
		return {
			matches: styleMedia.matchMedium(media || 'all'),
			media: media || 'all'
		};
	};
}());
/*! Picturefill - Responsive Images that work today.
*  Author: Scott Jehl, Filament Group, 2012 ( new proposal implemented by Shawn Jansepar )
*  License: MIT/GPLv2
*  Spec: http://picture.responsiveimages.org/
*/
(function( w, doc, image ) {
	// Enable strict mode
	"use strict";

	function expose(picturefill) {
		/* expose picturefill */
		if ( typeof module === "object" && typeof module.exports === "object" ) {
			// CommonJS, just export
			module.exports = picturefill;
		} else if ( typeof define === "function" && define.amd ) {
			// AMD support
			define( "picturefill", function() { return picturefill; } );
		}
		if ( typeof w === "object" ) {
			// If no AMD and we are in the browser, attach to window
			w.picturefill = picturefill;
		}
	}

	// If picture is supported, well, that's awesome. Let's get outta here...
	if ( w.HTMLPictureElement ) {
		expose(function() { });
		return;
	}

	// HTML shim|v it for old IE (IE9 will still need the HTML video tag workaround)
	doc.createElement( "picture" );

	// local object for method references and testing exposure
	var pf = w.picturefill || {};

	var regWDesc = /\s+\+?\d+(e\d+)?w/;

	// namespace
	pf.ns = "picturefill";

	// srcset support test
	(function() {
		pf.srcsetSupported = "srcset" in image;
		pf.sizesSupported = "sizes" in image;
		pf.curSrcSupported = "currentSrc" in image;
	})();

	// just a string trim workaround
	pf.trim = function( str ) {
		return str.trim ? str.trim() : str.replace( /^\s+|\s+$/g, "" );
	};

	/**
	 * Gets a string and returns the absolute URL
	 * @param src
	 * @returns {String} absolute URL
	 */
	pf.makeUrl = (function() {
		var anchor = doc.createElement( "a" );
		return function(src) {
			anchor.href = src;
			return anchor.href;
		};
	})();

	/**
	 * Shortcut method for https://w3c.github.io/webappsec/specs/mixedcontent/#restricts-mixed-content ( for easy overriding in tests )
	 */
	pf.restrictsMixedContent = function() {
		return w.location.protocol === "https:";
	};
	/**
	 * Shortcut method for matchMedia ( for easy overriding in tests )
	 */

	pf.matchesMedia = function( media ) {
		return w.matchMedia && w.matchMedia( media ).matches;
	};

	// Shortcut method for `devicePixelRatio` ( for easy overriding in tests )
	pf.getDpr = function() {
		return ( w.devicePixelRatio || 1 );
	};

	/**
	 * Get width in css pixel value from a "length" value
	 * http://dev.w3.org/csswg/css-values-3/#length-value
	 */
	pf.getWidthFromLength = function( length ) {
		var cssValue;
		// If a length is specified and doesn’t contain a percentage, and it is greater than 0 or using `calc`, use it. Else, abort.
        if ( !(length && length.indexOf( "%" ) > -1 === false && ( parseFloat( length ) > 0 || length.indexOf( "calc(" ) > -1 )) ) {
            return false;
        }

		/**
		 * If length is specified in  `vw` units, use `%` instead since the div we’re measuring
		 * is injected at the top of the document.
		 *
		 * TODO: maybe we should put this behind a feature test for `vw`? The risk of doing this is possible browser inconsistancies with vw vs %
		 */
		length = length.replace( "vw", "%" );

		// Create a cached element for getting length value widths
		if ( !pf.lengthEl ) {
			pf.lengthEl = doc.createElement( "div" );

			// Positioning styles help prevent padding/margin/width on `html` or `body` from throwing calculations off.
			pf.lengthEl.style.cssText = "border:0;display:block;font-size:1em;left:0;margin:0;padding:0;position:absolute;visibility:hidden";

			// Add a class, so that everyone knows where this element comes from
			pf.lengthEl.className = "helper-from-picturefill-js";
		}

		pf.lengthEl.style.width = "0px";

        try {
		    pf.lengthEl.style.width = length;
        } catch ( e ) {}

		doc.body.appendChild(pf.lengthEl);

		cssValue = pf.lengthEl.offsetWidth;

		if ( cssValue <= 0 ) {
			cssValue = false;
		}

		doc.body.removeChild( pf.lengthEl );

		return cssValue;
	};

    pf.detectTypeSupport = function( type, typeUri ) {
        // based on Modernizr's lossless img-webp test
        // note: asynchronous
        var image = new w.Image();
        image.onerror = function() {
            pf.types[ type ] = false;
            picturefill();
        };
        image.onload = function() {
            pf.types[ type ] = image.width === 1;
            picturefill();
        };
        image.src = typeUri;

        return "pending";
    };
	// container of supported mime types that one might need to qualify before using
	pf.types = pf.types || {};

	pf.initTypeDetects = function() {
        // Add support for standard mime types
        pf.types[ "image/jpeg" ] = true;
        pf.types[ "image/gif" ] = true;
        pf.types[ "image/png" ] = true;
        pf.types[ "image/svg+xml" ] = doc.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#Image", "1.1");
        pf.types[ "image/webp" ] = pf.detectTypeSupport("image/webp", "data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAAAAAAfQ//73v/+BiOh/AAA=");
    };

	pf.verifyTypeSupport = function( source ) {
		var type = source.getAttribute( "type" );
		// if type attribute exists, return test result, otherwise return true
		if ( type === null || type === "" ) {
			return true;
		} else {
				var pfType = pf.types[ type ];
			// if the type test is a function, run it and return "pending" status. The function will rerun picturefill on pending elements once finished.
			if ( typeof pfType === "string" && pfType !== "pending") {
				pf.types[ type ] = pf.detectTypeSupport( type, pfType );
				return "pending";
			} else if ( typeof pfType === "function" ) {
				pfType();
				return "pending";
			} else {
				return pfType;
			}
		}
	};

	// Parses an individual `size` and returns the length, and optional media query
	pf.parseSize = function( sourceSizeStr ) {
		var match = /(\([^)]+\))?\s*(.+)/g.exec( sourceSizeStr );
		return {
			media: match && match[1],
			length: match && match[2]
		};
	};

	// Takes a string of sizes and returns the width in pixels as a number
	pf.findWidthFromSourceSize = function( sourceSizeListStr ) {
		// Split up source size list, ie ( max-width: 30em ) 100%, ( max-width: 50em ) 50%, 33%
		//                            or (min-width:30em) calc(30% - 15px)
		var sourceSizeList = pf.trim( sourceSizeListStr ).split( /\s*,\s*/ ),
			winningLength;

		for ( var i = 0, len = sourceSizeList.length; i < len; i++ ) {
			// Match <media-condition>? length, ie ( min-width: 50em ) 100%
			var sourceSize = sourceSizeList[ i ],
				// Split "( min-width: 50em ) 100%" into separate strings
				parsedSize = pf.parseSize( sourceSize ),
				length = parsedSize.length,
				media = parsedSize.media;

			if ( !length ) {
				continue;
			}
			// if there is no media query or it matches, choose this as our winning length
			if ( (!media || pf.matchesMedia( media )) &&
				// pass the length to a method that can properly determine length
				// in pixels based on these formats: http://dev.w3.org/csswg/css-values-3/#length-value
				(winningLength = pf.getWidthFromLength( length )) ) {
				break;
			}
		}

		//if we have no winningLength fallback to 100vw
		return winningLength || Math.max(w.innerWidth || 0, doc.documentElement.clientWidth);
	};

	pf.parseSrcset = function( srcset ) {
		/**
		 * A lot of this was pulled from Boris Smus’ parser for the now-defunct WHATWG `srcset`
		 * https://github.com/borismus/srcset-polyfill/blob/master/js/srcset-info.js
		 *
		 * 1. Let input (`srcset`) be the value passed to this algorithm.
		 * 2. Let position be a pointer into input, initially pointing at the start of the string.
		 * 3. Let raw candidates be an initially empty ordered list of URLs with associated
		 *    unparsed descriptors. The order of entries in the list is the order in which entries
		 *    are added to the list.
		 */
		var candidates = [];

		while ( srcset !== "" ) {
			srcset = srcset.replace( /^\s+/g, "" );

			// 5. Collect a sequence of characters that are not space characters, and let that be url.
			var pos = srcset.search(/\s/g),
				url, descriptor = null;

			if ( pos !== -1 ) {
				url = srcset.slice( 0, pos );

				var last = url.slice(-1);

				// 6. If url ends with a U+002C COMMA character (,), remove that character from url
				// and let descriptors be the empty string. Otherwise, follow these substeps
				// 6.1. If url is empty, then jump to the step labeled descriptor parser.

				if ( last === "," || url === "" ) {
					url = url.replace( /,+$/, "" );
					descriptor = "";
				}
				srcset = srcset.slice( pos + 1 );

				// 6.2. Collect a sequence of characters that are not U+002C COMMA characters (,), and
				// let that be descriptors.
				if ( descriptor === null ) {
					var descpos = srcset.indexOf( "," );
					if ( descpos !== -1 ) {
						descriptor = srcset.slice( 0, descpos );
						srcset = srcset.slice( descpos + 1 );
					} else {
						descriptor = srcset;
						srcset = "";
					}
				}
			} else {
				url = srcset;
				srcset = "";
			}

			// 7. Add url to raw candidates, associated with descriptors.
			if ( url || descriptor ) {
				candidates.push({
					url: url,
					descriptor: descriptor
				});
			}
		}
		return candidates;
	};

	pf.parseDescriptor = function( descriptor, sizesattr ) {
		// 11. Descriptor parser: Let candidates be an initially empty source set. The order of entries in the list
		// is the order in which entries are added to the list.
		var sizes = sizesattr || "100vw",
			sizeDescriptor = descriptor && descriptor.replace( /(^\s+|\s+$)/g, "" ),
			widthInCssPixels = pf.findWidthFromSourceSize( sizes ),
			resCandidate;

			if ( sizeDescriptor ) {
				var splitDescriptor = sizeDescriptor.split(" ");

				for (var i = splitDescriptor.length - 1; i >= 0; i--) {
					var curr = splitDescriptor[ i ],
						lastchar = curr && curr.slice( curr.length - 1 );

					if ( ( lastchar === "h" || lastchar === "w" ) && !pf.sizesSupported ) {
						resCandidate = parseFloat( ( parseInt( curr, 10 ) / widthInCssPixels ) );
					} else if ( lastchar === "x" ) {
						var res = curr && parseFloat( curr, 10 );
						resCandidate = res && !isNaN( res ) ? res : 1;
					}
				}
			}
		return resCandidate || 1;
	};

	/**
	 * Takes a srcset in the form of url/
	 * ex. "images/pic-medium.png 1x, images/pic-medium-2x.png 2x" or
	 *     "images/pic-medium.png 400w, images/pic-medium-2x.png 800w" or
	 *     "images/pic-small.png"
	 * Get an array of image candidates in the form of
	 *      {url: "/foo/bar.png", resolution: 1}
	 * where resolution is http://dev.w3.org/csswg/css-values-3/#resolution-value
	 * If sizes is specified, resolution is calculated
	 */
	pf.getCandidatesFromSourceSet = function( srcset, sizes ) {
		var candidates = pf.parseSrcset( srcset ),
			formattedCandidates = [];

		for ( var i = 0, len = candidates.length; i < len; i++ ) {
			var candidate = candidates[ i ];

			formattedCandidates.push({
				url: candidate.url,
				resolution: pf.parseDescriptor( candidate.descriptor, sizes )
			});
		}
		return formattedCandidates;
	};

	/**
	 * if it's an img element and it has a srcset property,
	 * we need to remove the attribute so we can manipulate src
	 * (the property's existence infers native srcset support, and a srcset-supporting browser will prioritize srcset's value over our winning picture candidate)
	 * this moves srcset's value to memory for later use and removes the attr
	 */
	pf.dodgeSrcset = function( img ) {
		if ( img.srcset ) {
			img[ pf.ns ].srcset = img.srcset;
			img.srcset = "";
			img.setAttribute( "data-pfsrcset", img[ pf.ns ].srcset );
		}
	};

	// Accept a source or img element and process its srcset and sizes attrs
	pf.processSourceSet = function( el ) {
		var srcset = el.getAttribute( "srcset" ),
			sizes = el.getAttribute( "sizes" ),
			candidates = [];

		// if it's an img element, use the cached srcset property (defined or not)
		if ( el.nodeName.toUpperCase() === "IMG" && el[ pf.ns ] && el[ pf.ns ].srcset ) {
			srcset = el[ pf.ns ].srcset;
		}

		if ( srcset ) {
			candidates = pf.getCandidatesFromSourceSet( srcset, sizes );
		}
		return candidates;
	};

	pf.backfaceVisibilityFix = function( picImg ) {
		// See: https://github.com/scottjehl/picturefill/issues/332
		var style = picImg.style || {},
			WebkitBackfaceVisibility = "webkitBackfaceVisibility" in style,
			currentZoom = style.zoom;

		if (WebkitBackfaceVisibility) {
			style.zoom = ".999";

			WebkitBackfaceVisibility = picImg.offsetWidth;

			style.zoom = currentZoom;
		}
	};

	pf.setIntrinsicSize = (function() {
		var urlCache = {};
		var setSize = function( picImg, width, res ) {
            if ( width ) {
			    picImg.setAttribute( "width", parseInt(width / res, 10) );
            }
		};
		return function( picImg, bestCandidate ) {
			var img;
			if ( !picImg[ pf.ns ] || w.pfStopIntrinsicSize ) {
				return;
			}
			if ( picImg[ pf.ns ].dims === undefined ) {
				picImg[ pf.ns].dims = picImg.getAttribute("width") || picImg.getAttribute("height");
			}
			if ( picImg[ pf.ns].dims ) { return; }

			if ( bestCandidate.url in urlCache ) {
				setSize( picImg, urlCache[bestCandidate.url], bestCandidate.resolution );
			} else {
				img = doc.createElement( "img" );
				img.onload = function() {
					urlCache[bestCandidate.url] = img.width;

                    //IE 10/11 don't calculate width for svg outside document
                    if ( !urlCache[bestCandidate.url] ) {
                        try {
                            doc.body.appendChild( img );
                            urlCache[bestCandidate.url] = img.width || img.offsetWidth;
                            doc.body.removeChild( img );
                        } catch(e){}
                    }

					if ( picImg.src === bestCandidate.url ) {
						setSize( picImg, urlCache[bestCandidate.url], bestCandidate.resolution );
					}
					picImg = null;
					img.onload = null;
					img = null;
				};
				img.src = bestCandidate.url;
			}
		};
	})();

	pf.applyBestCandidate = function( candidates, picImg ) {
		var candidate,
			length,
			bestCandidate;

		candidates.sort( pf.ascendingSort );

		length = candidates.length;
		bestCandidate = candidates[ length - 1 ];

		for ( var i = 0; i < length; i++ ) {
			candidate = candidates[ i ];
			if ( candidate.resolution >= pf.getDpr() ) {
				bestCandidate = candidate;
				break;
			}
		}

		if ( bestCandidate ) {

			bestCandidate.url = pf.makeUrl( bestCandidate.url );

			if ( picImg.src !== bestCandidate.url ) {
				if ( pf.restrictsMixedContent() && bestCandidate.url.substr(0, "http:".length).toLowerCase() === "http:" ) {
					if ( window.console !== undefined ) {
						console.warn( "Blocked mixed content image " + bestCandidate.url );
					}
				} else {
					picImg.src = bestCandidate.url;
					// currentSrc attribute and property to match
					// http://picture.responsiveimages.org/#the-img-element
					if ( !pf.curSrcSupported ) {
						picImg.currentSrc = picImg.src;
					}

					pf.backfaceVisibilityFix( picImg );
				}
			}

			pf.setIntrinsicSize(picImg, bestCandidate);
		}
	};

	pf.ascendingSort = function( a, b ) {
		return a.resolution - b.resolution;
	};

	/**
	 * In IE9, <source> elements get removed if they aren't children of
	 * video elements. Thus, we conditionally wrap source elements
	 * using <!--[if IE 9]><video style="display: none;"><![endif]-->
	 * and must account for that here by moving those source elements
	 * back into the picture element.
	 */
	pf.removeVideoShim = function( picture ) {
		var videos = picture.getElementsByTagName( "video" );
		if ( videos.length ) {
			var video = videos[ 0 ],
				vsources = video.getElementsByTagName( "source" );
			while ( vsources.length ) {
				picture.insertBefore( vsources[ 0 ], video );
			}
			// Remove the video element once we're finished removing its children
			video.parentNode.removeChild( video );
		}
	};

	/**
	 * Find all `img` elements, and add them to the candidate list if they have
	 * a `picture` parent, a `sizes` attribute in basic `srcset` supporting browsers,
	 * a `srcset` attribute at all, and they haven’t been evaluated already.
	 */
	pf.getAllElements = function() {
		var elems = [],
			imgs = doc.getElementsByTagName( "img" );

		for ( var h = 0, len = imgs.length; h < len; h++ ) {
			var currImg = imgs[ h ];

			if ( currImg.parentNode.nodeName.toUpperCase() === "PICTURE" ||
			( currImg.getAttribute( "srcset" ) !== null ) || currImg[ pf.ns ] && currImg[ pf.ns ].srcset !== null ) {
				elems.push( currImg );
			}
		}
		return elems;
	};

	pf.getMatch = function( img, picture ) {
		var sources = picture.childNodes,
			match;

		// Go through each child, and if they have media queries, evaluate them
		for ( var j = 0, slen = sources.length; j < slen; j++ ) {
			var source = sources[ j ];

			// ignore non-element nodes
			if ( source.nodeType !== 1 ) {
				continue;
			}

			// Hitting the `img` element that started everything stops the search for `sources`.
			// If no previous `source` matches, the `img` itself is evaluated later.
			if ( source === img ) {
				return match;
			}

			// ignore non-`source` nodes
			if ( source.nodeName.toUpperCase() !== "SOURCE" ) {
				continue;
			}
			// if it's a source element that has the `src` property set, throw a warning in the console
			if ( source.getAttribute( "src" ) !== null && typeof console !== undefined ) {
				console.warn("The `src` attribute is invalid on `picture` `source` element; instead, use `srcset`.");
			}

			var media = source.getAttribute( "media" );

			// if source does not have a srcset attribute, skip
			if ( !source.getAttribute( "srcset" ) ) {
				continue;
			}

			// if there's no media specified, OR w.matchMedia is supported
			if ( ( !media || pf.matchesMedia( media ) ) ) {
				var typeSupported = pf.verifyTypeSupport( source );

				if ( typeSupported === true ) {
					match = source;
					break;
				} else if ( typeSupported === "pending" ) {
					return false;
				}
			}
		}

		return match;
	};

	function picturefill( opt ) {
		var elements,
			element,
			parent,
			firstMatch,
			candidates,
			options = opt || {};

		elements = options.elements || pf.getAllElements();

		// Loop through all elements
		for ( var i = 0, plen = elements.length; i < plen; i++ ) {
			element = elements[ i ];
			parent = element.parentNode;
			firstMatch = undefined;
			candidates = undefined;

			// immediately skip non-`img` nodes
			if ( element.nodeName.toUpperCase() !== "IMG" ) {
				continue;
			}

			// expando for caching data on the img
			if ( !element[ pf.ns ] ) {
				element[ pf.ns ] = {};
			}

			// if the element has already been evaluated, skip it unless
			// `options.reevaluate` is set to true ( this, for example,
			// is set to true when running `picturefill` on `resize` ).
			if ( !options.reevaluate && element[ pf.ns ].evaluated ) {
				continue;
			}

			// if `img` is in a `picture` element
			if ( parent && parent.nodeName.toUpperCase() === "PICTURE" ) {

				// IE9 video workaround
				pf.removeVideoShim( parent );

				// return the first match which might undefined
				// returns false if there is a pending source
				// TODO the return type here is brutal, cleanup
				firstMatch = pf.getMatch( element, parent );

				// if any sources are pending in this picture due to async type test(s)
				// remove the evaluated attr and skip for now ( the pending test will
				// rerun picturefill on this element when complete)
				if ( firstMatch === false ) {
					continue;
				}
			} else {
				firstMatch = undefined;
			}

			// Cache and remove `srcset` if present and we’re going to be doing `picture`/`srcset`/`sizes` polyfilling to it.
			if ( ( parent && parent.nodeName.toUpperCase() === "PICTURE" ) ||
			( !pf.sizesSupported && ( element.srcset && regWDesc.test( element.srcset ) ) ) ) {
				pf.dodgeSrcset( element );
			}

			if ( firstMatch ) {
				candidates = pf.processSourceSet( firstMatch );
				pf.applyBestCandidate( candidates, element );
			} else {
				// No sources matched, so we’re down to processing the inner `img` as a source.
				candidates = pf.processSourceSet( element );

				if ( element.srcset === undefined || element[ pf.ns ].srcset ) {
					// Either `srcset` is completely unsupported, or we need to polyfill `sizes` functionality.
					pf.applyBestCandidate( candidates, element );
				} // Else, resolution-only `srcset` is supported natively.
			}

			// set evaluated to true to avoid unnecessary reparsing
			element[ pf.ns ].evaluated = true;
		}
	}

	/**
	 * Sets up picture polyfill by polling the document and running
	 * the polyfill every 250ms until the document is ready.
	 * Also attaches picturefill on resize
	 */
	function runPicturefill() {
		pf.initTypeDetects();
		picturefill();
		var intervalId = setInterval( function() {
			// When the document has finished loading, stop checking for new images
			// https://github.com/ded/domready/blob/master/ready.js#L15
			picturefill();

			if ( /^loaded|^i|^c/.test( doc.readyState ) ) {
				clearInterval( intervalId );
				return;
			}
		}, 250 );

		var resizeTimer;
		var handleResize = function() {
	        picturefill({ reevaluate: true });
	    };
		function checkResize() {
		    clearTimeout(resizeTimer);
		    resizeTimer = setTimeout( handleResize, 60 );
		}

		if ( w.addEventListener ) {
			w.addEventListener( "resize", checkResize, false );
		} else if ( w.attachEvent ) {
			w.attachEvent( "onresize", checkResize );
		}
	}

	runPicturefill();

	/* expose methods for testing */
	picturefill._ = pf;

	expose( picturefill );

} )( window, window.document, new window.Image() );// ==========================================================================
// Plyr
// plyr.js v1.1.13
// https://github.com/selz/plyr
// License: The MIT License (MIT)
// ==========================================================================
// Credits: http://paypal.github.io/accessible-html5-video-player/
// ==========================================================================

(function (api) {
    "use strict";

    // Globals
    var fullscreen, config;

    // Default config
    var defaults = {
        enabled:                true,
        debug:                  false,
        seekTime:               10,
        volume:                 5,
        click:                  true,
        tooltips:               false,
        displayDuration:        true,
        selectors: {
            container:          ".player",
            controls:           ".player-controls",
            labels:             "[data-player] .sr-only, label .sr-only",
            buttons: {
                seek:           "[data-player='seek']",
                play:           "[data-player='play']",
                pause:          "[data-player='pause']",
                restart:        "[data-player='restart']",
                rewind:         "[data-player='rewind']",
                forward:        "[data-player='fast-forward']",
                mute:           "[data-player='mute']",
                volume:         "[data-player='volume']",
                captions:       "[data-player='captions']",
                fullscreen:     "[data-player='fullscreen']"
            },
            progress: {
                container:      ".player-progress",
                buffer:         ".player-progress-buffer",
                played:         ".player-progress-played"
            },
            captions:           ".player-captions",
            currentTime:        ".player-current-time",
            duration:           ".player-duration"
        },
        classes: {
            video:              "player-video",
            videoWrapper:       "player-video-wrapper",
            audio:              "player-audio",
            stopped:            "stopped",
            playing:            "playing",
            muted:              "muted",
            loading:            "loading",
            tooltip:            "player-tooltip",
            hidden:             "sr-only",
            hover:              "hover",
            captions: {
                enabled:        "captions-enabled",
                active:         "captions-active"
            },
            fullscreen: {
                enabled:        "fullscreen-enabled",
                active:         "fullscreen-active",
                hideControls:   "fullscreen-hide-controls"
            }
        },
        captions: {
            defaultActive:      false
        },
        fullscreen: {
            enabled:            true,
            fallback:           true,
            hideControls:       true
        },
        storage: {
            enabled:            true,
            key:                "plyr_volume"
        },
        controls:               ["restart", "rewind", "play", "fast-forward", "current-time", "duration", "mute", "volume", "captions", "fullscreen"],
        onSetup:                function() {},
    };

    // Build the default HTML
    function _buildControls() {
        // Open and add the progress and seek elements
        var html = [
        "<div class='player-controls'>",
            "<div class='player-progress'>",
                "<label for='seek{id}' class='sr-only'>Seek</label>",
                "<input id='seek{id}' class='player-progress-seek' type='range' min='0' max='100' step='0.5' value='0' data-player='seek'>",
                "<progress class='player-progress-played' max='100' value='0'>",
                    "<span>0</span>% played",
                "</progress>",
                "<progress class='player-progress-buffer' max='100' value='0'>",
                    "<span>0</span>% buffered",
                "</progress>",
            "</div>",
            "<span class='player-controls-left'>"];

        // Restart button
        if(_inArray(config.controls, "restart")) {
            html.push(
                "<button type='button' data-player='restart'>",
                    "<svg><use xlink:href='#icon-restart'></use></svg>",
                    "<span class='sr-only'>Restart</span>",
                "</button>"
            );
        }

        // Rewind button
        if(_inArray(config.controls, "rewind")) {
            html.push(
                "<button type='button' data-player='rewind'>",
                    "<svg><use xlink:href='#icon-rewind'></use></svg>",
                    "<span class='sr-only'>Rewind {seektime} secs</span>",
                "</button>"
            );
        }

        // Play/pause button
        if(_inArray(config.controls, "play")) {
            html.push(
                "<button type='button' data-player='play'>",
                    "<svg><use xlink:href='#icon-play'></use></svg>",
                    "<span class='sr-only'>Play</span>",
                "</button>",
                "<button type='button' data-player='pause'>",
                    "<svg><use xlink:href='#icon-pause'></use></svg>",
                    "<span class='sr-only'>Pause</span>",
                "</button>"
            );
        }

        // Fast forward button
        if(_inArray(config.controls, "fast-forward")) {
            html.push(
                "<button type='button' data-player='fast-forward'>",
                    "<svg><use xlink:href='#icon-fast-forward'></use></svg>",
                    "<span class='sr-only'>Forward {seektime} secs</span>",
                "</button>"
            );
        }

        // Media current time display
        if(_inArray(config.controls, "current-time")) {
            html.push(
                "<span class='player-time'>",
                    "<span class='sr-only'>Current time</span>",
                    "<span class='player-current-time'>00:00</span>",
                "</span>"
            );
        }

        // Media duration display
        if(_inArray(config.controls, "duration")) {
            html.push(
                "<span class='player-time'>",
                    "<span class='sr-only'>Duration</span>",
                    "<span class='player-duration'>00:00</span>",
                "</span>"
            );
        }

        // Close left controls
        html.push(
            "</span>",
            "<span class='player-controls-right'>"
        );

        // Toggle mute button
        if(_inArray(config.controls, "mute")) {
            html.push(
                "<input class='inverted sr-only' id='mute{id}' type='checkbox' data-player='mute'>",
                "<label id='mute{id}' for='mute{id}'>",
                    "<svg class='icon-muted'><use xlink:href='#icon-muted'></use></svg>",
                    "<svg><use xlink:href='#icon-volume'></use></svg>",
                    "<span class='sr-only'>Toggle Mute</span>",
                "</label>"
            );
        }

        // Volume range control
        if(_inArray(config.controls, "volume")) {
            html.push(
                "<label for='volume{id}' class='sr-only'>Volume</label>",
                "<input id='volume{id}' class='player-volume' type='range' min='0' max='10' value='5' data-player='volume'>"
            );
        }

        // Toggle captions button
        if(_inArray(config.controls, "captions")) {
            html.push(
                "<input class='sr-only' id='captions{id}' type='checkbox' data-player='captions'>",
                "<label for='captions{id}'>",
                    "<svg class='icon-captions-on'><use xlink:href='#icon-captions-on'></use></svg>",
                    "<svg><use xlink:href='#icon-captions-off'></use></svg>",
                    "<span class='sr-only'>Toggle Captions</span>",
                "</label>"
            );
        }

        // Toggle fullscreen button
        if(_inArray(config.controls, "fullscreen")) {
            html.push(
                "<button type='button' data-player='fullscreen'>",
                    "<svg class='icon-exit-fullscreen'><use xlink:href='#icon-exit-fullscreen'></use></svg>",
                    "<svg><use xlink:href='#icon-enter-fullscreen'></use></svg>",
                    "<span class='sr-only'>Toggle Fullscreen</span>",
                "</button>"
            );
        }

        // Close everything
        html.push(
            "</span>",
        "</div>"
        );

        return html.join("");
    }

    // Debugging
    function _log(text, error) {
        if(config.debug && window.console) {
            console[(error ? "error" : "log")](text);
        }
    }

    // Credits: http://paypal.github.io/accessible-html5-video-player/
    // Unfortunately, due to mixed support, UA sniffing is required
    function _browserSniff() {
        var nAgt = navigator.userAgent,
            name = navigator.appName,
            fullVersion = "" + parseFloat(navigator.appVersion),
            majorVersion = parseInt(navigator.appVersion, 10),
            nameOffset,
            verOffset,
            ix;

        // MSIE 11
        if ((navigator.appVersion.indexOf("Windows NT") !== -1) && (navigator.appVersion.indexOf("rv:11") !== -1)) {
            name = "IE";
            fullVersion = "11;";
        }
        // MSIE
        else if ((verOffset=nAgt.indexOf("MSIE")) !== -1) {
            name = "IE";
            fullVersion = nAgt.substring(verOffset + 5);
        }
        // Chrome
        else if ((verOffset=nAgt.indexOf("Chrome")) !== -1) {
            name = "Chrome";
            fullVersion = nAgt.substring(verOffset + 7);
        }
        // Safari
        else if ((verOffset=nAgt.indexOf("Safari")) !== -1) {
            name = "Safari";
            fullVersion = nAgt.substring(verOffset + 7);
            if ((verOffset=nAgt.indexOf("Version")) !== -1) {
                fullVersion = nAgt.substring(verOffset + 8);
            }
        }
        // Firefox
        else if ((verOffset=nAgt.indexOf("Firefox")) !== -1) {
            name = "Firefox";
            fullVersion = nAgt.substring(verOffset + 8);
        }
        // In most other browsers, "name/version" is at the end of userAgent
        else if ((nameOffset=nAgt.lastIndexOf(" ") + 1) < (verOffset=nAgt.lastIndexOf("/"))) {
            name = nAgt.substring(nameOffset,verOffset);
            fullVersion = nAgt.substring(verOffset + 1);

            if (name.toLowerCase() == name.toUpperCase()) {
                name = navigator.appName;
            }
        }
        // Trim the fullVersion string at semicolon/space if present
        if ((ix = fullVersion.indexOf(";")) !== -1) {
            fullVersion = fullVersion.substring(0, ix);
        }
        if ((ix = fullVersion.indexOf(" ")) !== -1) {
            fullVersion = fullVersion.substring(0, ix);
        }
        // Get major version
        majorVersion = parseInt("" + fullVersion, 10);
        if (isNaN(majorVersion)) {
            fullVersion = "" + parseFloat(navigator.appVersion);
            majorVersion = parseInt(navigator.appVersion, 10);
        }

        // Return data
        return {
            name:       name,
            version:    majorVersion,
            ios:        /(iPad|iPhone|iPod)/g.test(navigator.platform)
        };
    }

    // Check for mime type support against a player instance
    // Credits: http://diveintohtml5.info/everything.html
    // Related: http://www.leanbackplayer.com/test/h5mt.html
    function _supportMime(player, mimeType) {
        var media = player.media;

        // Only check video types for video players
        if(player.type == "video") {
            // Check type
            switch(mimeType) {
                case "video/webm":   return !!(media.canPlayType && media.canPlayType("video/webm; codecs=\"vp8, vorbis\"").replace(/no/, ""));
                case "video/mp4":    return !!(media.canPlayType && media.canPlayType("video/mp4; codecs=\"avc1.42E01E, mp4a.40.2\"").replace(/no/, ""));
                case "video/ogg":    return !!(media.canPlayType && media.canPlayType("video/ogg; codecs=\"theora\"").replace(/no/, ""));
            }
        }

        // Only check audio types for audio players
        else if(player.type == "audio") {
            // Check type
            switch(mimeType) {
                case "audio/mpeg":   return !!(media.canPlayType && media.canPlayType("audio/mpeg;").replace(/no/, ""));
                case "audio/ogg":    return !!(media.canPlayType && media.canPlayType("audio/ogg; codecs=\"vorbis\"").replace(/no/, ""));
                case "audio/wav":    return !!(media.canPlayType && media.canPlayType("audio/wav; codecs=\"1\"").replace(/no/, ""));
            }
        }

        // If we got this far, we're stuffed
        return false;
    }

    // Element exists in an array
    function _inArray(haystack, needle) {
        return Array.prototype.indexOf && (haystack.indexOf(needle) != -1);
    }

    // Replace all
    function _replaceAll(string, find, replace) {
        return string.replace(new RegExp(find.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1"), "g"), replace);
    }

    // Wrap an element
    function _wrap(elements, wrapper) {
        // Convert `elements` to an array, if necessary.
        if (!elements.length) {
            elements = [elements];
        }

        // Loops backwards to prevent having to clone the wrapper on the
        // first element (see `child` below).
        for (var i = elements.length - 1; i >= 0; i--) {
            var child   = (i > 0) ? wrapper.cloneNode(true) : wrapper;
            var element = elements[i];

            // Cache the current parent and sibling.
            var parent  = element.parentNode;
            var sibling = element.nextSibling;

            // Wrap the element (is automatically removed from its current
            // parent).
            child.appendChild(element);

            // If the element had a sibling, insert the wrapper before
            // the sibling to maintain the HTML structure; otherwise, just
            // append it to the parent.
            if (sibling) {
                parent.insertBefore(child, sibling);
            }
            else {
                parent.appendChild(child);
            }
        }
    }

    // Unwrap an element
    // http://plainjs.com/javascript/manipulation/unwrap-a-dom-element-35/
    function _unwrap(wrapper) {
        // Get the element's parent node
        var parent = wrapper.parentNode;

        // Move all children out of the element
        while (wrapper.firstChild) {
            parent.insertBefore(wrapper.firstChild, wrapper);
        }

        // Remove the empty element
        parent.removeChild(wrapper);
    }

    // Remove an element
    function _remove(element) {
        element.parentNode.removeChild(element);
    }

    // Prepend child
    function _prependChild(parent, element) {
        parent.insertBefore(element, parent.firstChild);
    }

    // Set attributes
    function _setAttributes(element, attributes) {
        for(var key in attributes) {
            element.setAttribute(key, attributes[key]);
        }
    }

    // Toggle class on an element
    function _toggleClass(element, name, state) {
        if(element){
            if(element.classList) {
                element.classList[state ? "add" : "remove"](name);
            }
            else {
                var className = (" " + element.className + " ").replace(/\s+/g, " ").replace(" " + name + " ", "");
                element.className = className + (state ? " " + name : "");
            }
        }
    }

    // Toggle event
    function _toggleHandler(element, events, callback, toggle) {
        var eventList = events.split(" ");

        // If a nodelist is passed, call itself on each node
        if(element instanceof NodeList) {
            for (var x = 0; x < element.length; x++) {
                if (element[x] instanceof Node) {
                    _toggleHandler(element[x], arguments[1], arguments[2], arguments[3]);
                }
            }
            return;
        }

        // If a single node is passed, bind the event listener
        for (var i = 0; i < eventList.length; i++) {
            element[toggle ? "addEventListener" : "removeEventListener"](eventList[i], callback, false);
        }
    }

    // Bind event
    function _on(element, events, callback) {
        if(element) {
            _toggleHandler(element, events, callback, true);
        }
    }

    // Unbind event
    function _off(element, events, callback) {
        if(element) {
            _toggleHandler(element, events, callback, false);
        }
    }

    // Trigger event
    function _triggerEvent(element, event) {
        // Create faux event
        var fauxEvent = document.createEvent("MouseEvents");

        // Set the event type
        fauxEvent.initEvent(event, true, true);

        // Dispatch the event
        element.dispatchEvent(fauxEvent);
    }

    // Toggle checkbox
    function _toggleCheckbox(event) {
        // Only listen for return key
        if(event.keyCode && event.keyCode != 13) {
            return true;
        }

        // Toggle the checkbox
        event.target.checked = !event.target.checked;

        // Trigger change event
        _triggerEvent(event.target, "change");
    }

    // Get percentage
    function _getPercentage(current, max) {
        if(current === 0 || max === 0 || isNaN(current) || isNaN(max)) {
            return 0;
        }
        return ((current / max) * 100).toFixed(2);
    }

    // Deep extend/merge two Objects
    // http://andrewdupont.net/2009/08/28/deep-extending-objects-in-javascript/
    // Removed call to arguments.callee (used explicit function name instead)
    function _extend(destination, source) {
        for (var property in source) {
            if (source[property] && source[property].constructor && source[property].constructor === Object) {
                destination[property] = destination[property] || {};
                _extend(destination[property], source[property]);
            }
            else {
                destination[property] = source[property];
            }
        }
        return destination;
    }

    // Fullscreen API
    function _fullscreen() {
        var fullscreen = {
                supportsFullScreen: false,
                isFullScreen: function() { return false; },
                requestFullScreen: function() {},
                cancelFullScreen: function() {},
                fullScreenEventName: "",
                element: null,
                prefix: ""
            },
            browserPrefixes = "webkit moz o ms khtml".split(" ");

        // check for native support
        if (typeof document.cancelFullScreen != "undefined") {
            fullscreen.supportsFullScreen = true;
        }
        else {
            // check for fullscreen support by vendor prefix
            for (var i = 0, il = browserPrefixes.length; i < il; i++ ) {
                fullscreen.prefix = browserPrefixes[i];

                if (typeof document[fullscreen.prefix + "CancelFullScreen"] != "undefined") {
                    fullscreen.supportsFullScreen = true;
                    break;
                }
                // Special case for MS (when isn't it?)
                else if (typeof document.msExitFullscreen != "undefined" && document.msFullscreenEnabled) {
                    fullscreen.prefix = "ms";
                    fullscreen.supportsFullScreen = true;
                    break;
                }
            }
        }

        // Safari doesn't support the ALLOW_KEYBOARD_INPUT flag (for security) so set it to not supported
        // https://bugs.webkit.org/show_bug.cgi?id=121496
        if(fullscreen.prefix === "webkit" && !!navigator.userAgent.match(/Version\/[\d\.]+.*Safari/)) {
             fullscreen.supportsFullScreen = false;
        }

        // Update methods to do something useful
        if (fullscreen.supportsFullScreen) {
            // Yet again Microsoft awesomeness,
            // Sometimes the prefix is "ms", sometimes "MS" to keep you on your toes
            fullscreen.fullScreenEventName = (fullscreen.prefix == "ms" ? "MSFullscreenChange" : fullscreen.prefix + "fullscreenchange");

            fullscreen.isFullScreen = function(element) {
                if(typeof element == "undefined") {
                    element = document;
                }

                switch (this.prefix) {
                    case "":
                        return document.fullscreenElement == element;
                    case "moz":
                        return document.mozFullScreenElement == element;
                    default:
                        return document[this.prefix + "FullscreenElement"] == element;
                }
            };
            fullscreen.requestFullScreen = function(element) {
                return (this.prefix === "") ? element.requestFullScreen() : element[this.prefix + (this.prefix == "ms" ? "RequestFullscreen" : "RequestFullScreen")](this.prefix === "webkit" ? element.ALLOW_KEYBOARD_INPUT : null);
            };
            fullscreen.cancelFullScreen = function() {
                return (this.prefix === "") ? document.cancelFullScreen() : document[this.prefix + (this.prefix == "ms" ? "ExitFullscreen" : "CancelFullScreen")]();
            };
            fullscreen.element = function() {
                return (this.prefix === "") ? document.fullscreenElement : document[this.prefix + "FullscreenElement"];
            };
        }

        return fullscreen;
    }

    // Local storage
    function _storage() {
        var storage = {
            supported: (function() {
                try {
                    return "localStorage" in window && window.localStorage !== null;
                }
                catch(e) {
                    return false;
                }
            })()
        }
        return storage;
    }

    // Player instance
    function Plyr(container) {
        var player = this;
        player.container = container;

        // Captions functions
        // Seek the manual caption time and update UI
        function _seekManualCaptions(time) {
            // If it's not video, or we're using textTracks, bail.
            if (player.usingTextTracks || player.type !== "video" || !player.supported.full) {
                return;
            }

            // Reset subcount
            player.subcount = 0;

            // Check time is a number, if not use currentTime
            // IE has a bug where currentTime doesn't go to 0
            // https://twitter.com/Sam_Potts/status/573715746506731521
            time = typeof time === "number" ? time : player.media.currentTime;

            while (_timecodeMax(player.captions[player.subcount][0]) < time.toFixed(1)) {
                player.subcount++;
                if (player.subcount > player.captions.length-1) {
                    player.subcount = player.captions.length-1;
                    break;
                }
            }

            // Check if the next caption is in the current time range
            if (player.media.currentTime.toFixed(1) >= _timecodeMin(player.captions[player.subcount][0]) &&
                player.media.currentTime.toFixed(1) <= _timecodeMax(player.captions[player.subcount][0])) {
                    player.currentCaption = player.captions[player.subcount][1];

                // Render the caption
                player.captionsContainer.innerHTML = player.currentCaption;
            }
            else {
                // Clear the caption
                player.captionsContainer.innerHTML = "";
            }
        }

        // Display captions container and button (for initialization)
        function _showCaptions() {
            // If there's no caption toggle, bail
            if(!player.buttons.captions) {
                return;
            }

            _toggleClass(player.container, config.classes.captions.enabled, true);

            if (config.captions.defaultActive) {
                _toggleClass(player.container, config.classes.captions.active, true);
                player.buttons.captions.checked = true;
            }
        }

        // Utilities for caption time codes
        function _timecodeMin(tc) {
            var tcpair = [];
            tcpair = tc.split(" --> ");
            return _subTcSecs(tcpair[0]);
        }
        function _timecodeMax(tc) {
            var tcpair = [];
            tcpair = tc.split(" --> ");
            return _subTcSecs(tcpair[1]);
        }
        function _subTcSecs(tc) {
            if (tc === null || tc === undefined) {
                return 0;
            }
            else {
                var tc1 = [],
                    tc2 = [],
                    seconds;
                tc1 = tc.split(",");
                tc2 = tc1[0].split(":");
                seconds = Math.floor(tc2[0]*60*60) + Math.floor(tc2[1]*60) + Math.floor(tc2[2]);
                return seconds;
            }
        }

        // Find all elements
        function _getElements(selector) {
            return player.container.querySelectorAll(selector);
        }

        // Find a single element
        function _getElement(selector) {
            return _getElements(selector)[0];
        }

        // Determine if we're in an iframe
        function _inFrame() {
            try {
                return window.self !== window.top;
            }
            catch (e) {
                return true;
            }
        }

        // Insert controls
        function _injectControls() {
            // Make a copy of the html
            var html = config.html;

            // Insert custom video controls
            _log("Injecting custom controls.");

            // If no controls are specified, create default
            if(!html) {
                html = _buildControls();
            }

            // Replace seek time instances
            html = _replaceAll(html, "{seektime}", config.seekTime);

            // Replace all id references with random numbers
            html = _replaceAll(html, "{id}", Math.floor(Math.random() * (10000)));

            // Inject into the container
            player.container.insertAdjacentHTML("beforeend", html);

            // Setup tooltips
            if(config.tooltips) {
                var labels = _getElements(config.selectors.labels);

                for (var i = labels.length - 1; i >= 0; i--) {
                    var label = labels[i];

                    _toggleClass(label, config.classes.hidden, false);
                    _toggleClass(label, config.classes.tooltip, true);
                }
            }
        }

        // Find the UI controls and store references
        function _findElements() {
            try {
                player.controls                 = _getElement(config.selectors.controls);

                // Buttons
                player.buttons = {};
                player.buttons.seek             = _getElement(config.selectors.buttons.seek);
                player.buttons.play             = _getElement(config.selectors.buttons.play);
                player.buttons.pause            = _getElement(config.selectors.buttons.pause);
                player.buttons.restart          = _getElement(config.selectors.buttons.restart);
                player.buttons.rewind           = _getElement(config.selectors.buttons.rewind);
                player.buttons.forward          = _getElement(config.selectors.buttons.forward);
                player.buttons.fullscreen       = _getElement(config.selectors.buttons.fullscreen);

                // Inputs
                player.buttons.mute             = _getElement(config.selectors.buttons.mute);
                player.buttons.captions         = _getElement(config.selectors.buttons.captions);
                player.checkboxes               = _getElements("[type='checkbox']");

                // Progress
                player.progress = {};
                player.progress.container       = _getElement(config.selectors.progress.container);

                // Progress - Buffering
                player.progress.buffer          = {};
                player.progress.buffer.bar      = _getElement(config.selectors.progress.buffer);
                player.progress.buffer.text     = player.progress.buffer.bar && player.progress.buffer.bar.getElementsByTagName("span")[0];

                // Progress - Played
                player.progress.played          = {};
                player.progress.played.bar      = _getElement(config.selectors.progress.played);
                player.progress.played.text     = player.progress.played.bar && player.progress.played.bar.getElementsByTagName("span")[0];

                // Volume
                player.volume                   = _getElement(config.selectors.buttons.volume);

                // Timing
                player.duration                 = _getElement(config.selectors.duration);
                player.currentTime              = _getElements(config.selectors.currentTime);
                player.seekTime                 = _getElements(config.selectors.seekTime);

                return true;
            }
            catch(e) {
                _log("It looks like there's a problem with your controls html. Bailing.", true);

                // Restore native video controls
                player.media.setAttribute("controls", "");

                return false;
            }
        }

        // Setup aria attributes
        function _setupAria() {
            // If there's no play button, bail
            if(!player.buttons.play) {
                return;
            }

            // Find the current text
            var label = player.buttons.play.innerText || "Play";

            // If there's a media title set, use that for the label
            if (typeof(config.title) !== "undefined" && config.title.length) {
                label += ", " + config.title;
            }

            player.buttons.play.setAttribute("aria-label", label);
        }

        // Setup media
        function _setupMedia() {
            // If there's no media, bail
            if(!player.media) {
                _log("No audio or video element found!", true);
                return false;
            }

            if(player.supported.full) {
                // Remove native video controls
                player.media.removeAttribute("controls");

                // Add type class
                _toggleClass(player.container, config.classes[player.type], true);

                // If there's no autoplay attribute, assume the video is stopped and add state class
                _toggleClass(player.container, config.classes.stopped, (player.media.getAttribute("autoplay") === null));

                // Add iOS class
                if(player.browser.ios) {
                    _toggleClass(player.container, "ios", true);
                }

                // Inject the player wrapper
                if(player.type === "video") {
                    // Create the wrapper div
                    var wrapper = document.createElement("div");
                    wrapper.setAttribute("class", config.classes.videoWrapper);

                    // Wrap the video in a container
                    _wrap(player.media, wrapper);

                    // Cache the container
                    player.videoContainer = wrapper;
                }
            }

            // Autoplay
            if(player.media.getAttribute("autoplay") !== null) {
                _play();
            }
        }

        // Setup captions
        function _setupCaptions() {
            if(player.type === "video") {
                // Inject the container
                player.videoContainer.insertAdjacentHTML("afterbegin", "<div class='" + config.selectors.captions.replace(".", "") + "'></div>");

                // Cache selector
                player.captionsContainer = _getElement(config.selectors.captions);

                // Determine if HTML5 textTracks is supported
                player.usingTextTracks = false;
                if (player.media.textTracks) {
                    player.usingTextTracks = true;
                }

                // Get URL of caption file if exists
                var captionSrc = "",
                    kind,
                    children = player.media.childNodes;

                for (var i = 0; i < children.length; i++) {
                    if (children[i].nodeName.toLowerCase() === "track") {
                        kind = children[i].getAttribute("kind");
                        if (kind === "captions") {
                            captionSrc = children[i].getAttribute("src");
                        }
                    }
                }

                // Record if caption file exists or not
                player.captionExists = true;
                if (captionSrc === "") {
                    player.captionExists = false;
                    _log("No caption track found.");
                }
                else {
                    _log("Caption track found; URI: " + captionSrc);
                }

                // If no caption file exists, hide container for caption text
                if (!player.captionExists) {
                    _toggleClass(player.container, config.classes.captions.enabled);
                }
                // If caption file exists, process captions
                else {
                    // Turn off native caption rendering to avoid double captions
                    // This doesn't seem to work in Safari 7+, so the <track> elements are removed from the dom below
                    var tracks = player.media.textTracks;
                    for (var x=0; x < tracks.length; x++) {
                        tracks[x].mode = "hidden";
                    }

                    // Enable UI
                    _showCaptions(player);

                    // Disable unsupported browsers than report false positive
                    if ((player.browser.name === "IE" && player.browser.version >= 10) ||
                        (player.browser.name === "Firefox" && player.browser.version >= 31) ||
                        (player.browser.name === "Chrome" && player.browser.version >= 43) ||
                        (player.browser.name === "Safari" && player.browser.version >= 7)) {
                        // Debugging
                        _log("Detected unsupported browser for HTML5 captions. Using fallback.");

                        // Set to false so skips to "manual" captioning
                        player.usingTextTracks = false;
                    }

                    // Rendering caption tracks
                    // Native support required - http://caniuse.com/webvtt
                    if (player.usingTextTracks) {
                        _log("TextTracks supported.");

                        for (var y=0; y < tracks.length; y++) {
                            var track = tracks[y];

                            if (track.kind === "captions") {
                                _on(track, "cuechange", function() {
                                    // Clear container
                                    player.captionsContainer.innerHTML = "";

                                    // Display a cue, if there is one
                                    if (this.activeCues[0] && this.activeCues[0].hasOwnProperty("text")) {
                                        player.captionsContainer.appendChild(this.activeCues[0].getCueAsHTML());
                                    }
                                });
                            }
                        }
                    }
                    // Caption tracks not natively supported
                    else {
                        _log("TextTracks not supported so rendering captions manually.");

                        // Render captions from array at appropriate time
                        player.currentCaption = "";
                        player.captions = [];

                        if (captionSrc !== "") {
                            // Create XMLHttpRequest Object
                            var xhr = new XMLHttpRequest();

                            xhr.onreadystatechange = function() {
                                if (xhr.readyState === 4) {
                                    if (xhr.status === 200) {
                                        var records = [],
                                            record,
                                            req = xhr.responseText;

                                        records = req.split("\n\n");

                                        for (var r=0; r < records.length; r++) {
                                            record = records[r];
                                            player.captions[r] = [];
                                            player.captions[r] = record.split("\n");
                                        }

                                        // Remove first element ("VTT")
                                        player.captions.shift();

                                        _log("Successfully loaded the caption file via AJAX.");
                                    }
                                    else {
                                        _log("There was a problem loading the caption file via AJAX.", true);
                                    }
                                }
                            }

                            xhr.open("get", captionSrc, true);

                            xhr.send();
                        }
                    }

                    // If Safari 7+, removing track from DOM [see "turn off native caption rendering" above]
                    if (player.browser.name === "Safari" && player.browser.version >= 7) {
                        _log("Safari 7+ detected; removing track from DOM.");

                        // Find all <track> elements
                        tracks = player.media.getElementsByTagName("track");

                        // Loop through and remove one by one
                        for (var t=0; t < tracks.length; t++) {
                            player.media.removeChild(tracks[t]);
                        }
                    }
                }
            }
        }

        // Setup fullscreen
        function _setupFullscreen() {
            if(player.type === "video" && config.fullscreen.enabled) {
                // Check for native support
                var nativeSupport = fullscreen.supportsFullScreen;

                if(nativeSupport || (config.fullscreen.fallback && !_inFrame())) {
                    _log((nativeSupport ? "Native" : "Fallback") + " fullscreen enabled.");

                    // Add styling hook
                    _toggleClass(player.container, config.classes.fullscreen.enabled, true);
                }
                else {
                    _log("Fullscreen not supported and fallback disabled.");
                }

                // Set control hide class hook
                if(config.fullscreen.hideControls) {
                    _toggleClass(player.container, config.classes.fullscreen.hideControls, true);
                }
            }
        }

        // Play media
        function _play() {
            player.media.play();
        }

        // Pause media
        function _pause() {
            player.media.pause();
        }

        // Toggle playback
        function _togglePlay(toggle) {
            // Play
            if(toggle === true) {
                _play();
            }
            // Pause
            else if(toggle === false) {
                _pause();
            }
            // True toggle
            else {
                player.media[player.media.paused ? "play" : "pause"]();
            }
        }

        // Rewind
        function _rewind(seekTime) {
            // Use default if needed
            if(typeof seekTime !== "number") {
                seekTime = config.seekTime;
            }
            _seek(player.media.currentTime - seekTime);
        }

        // Fast forward
        function _forward(seekTime) {
            // Use default if needed
            if(typeof seekTime !== "number") {
                seekTime = config.seekTime;
            }
            _seek(player.media.currentTime + seekTime);
        }

        // Seek to time
        // The input parameter can be an event or a number
        function _seek(input) {
            var targetTime = 0;

            // Explicit position
            if (typeof input === "number") {
                targetTime = input;
            }
            // Event
            else if (typeof input === "object" && (input.type === "input" || input.type === "change")) {
                // It's the seek slider
                // Seek to the selected time
                targetTime = ((input.target.value / input.target.max) * player.media.duration);
            }

            // Normalise targetTime
            if (targetTime < 0) {
                targetTime = 0;
            }
            else if (targetTime > player.media.duration) {
                targetTime = player.media.duration;
            }

            // Set the current time
            // Try/catch incase the media isn't set and we're calling seek() from source() and IE moans
            try {
                player.media.currentTime = targetTime.toFixed(1);
            }
            catch(e) {}

            // Logging
            _log("Seeking to " + player.media.currentTime + " seconds");

            // Special handling for "manual" captions
            _seekManualCaptions(targetTime);
        }

        // Check playing state
        function _checkPlaying() {
            _toggleClass(player.container, config.classes.playing, !player.media.paused);
            _toggleClass(player.container, config.classes.stopped, player.media.paused);
        }

        // Toggle fullscreen
        function _toggleFullscreen(event) {
            // Check for native support
            var nativeSupport = fullscreen.supportsFullScreen;

            // If it's a fullscreen change event, it's probably a native close
            if(event && event.type === fullscreen.fullScreenEventName) {
                player.isFullscreen = fullscreen.isFullScreen(player.container);
            }
            // If there's native support, use it
            else if(nativeSupport) {
                // Request fullscreen
                if(!fullscreen.isFullScreen(player.container)) {
                    fullscreen.requestFullScreen(player.container);
                }
                // Bail from fullscreen
                else {
                    fullscreen.cancelFullScreen();
                }

                // Check if we're actually full screen (it could fail)
                player.isFullscreen = fullscreen.isFullScreen(player.container);
            }
            else {
                // Otherwise, it's a simple toggle
                player.isFullscreen = !player.isFullscreen;

                // Bind/unbind escape key
                if(player.isFullscreen) {
                    _on(document, "keyup", _handleEscapeFullscreen);
                    document.body.style.overflow = "hidden";
                }
                else {
                    _off(document, "keyup", _handleEscapeFullscreen);
                    document.body.style.overflow = "";
                }
            }

            // Set class hook
            _toggleClass(player.container, config.classes.fullscreen.active, player.isFullscreen);

            // Toggle controls visibility based on mouse movement and location
            var hoverTimer, isMouseOver = false;

            // Show the player controls
            function _showControls() {
                // Set shown class
                _toggleClass(player.controls, config.classes.hover, true);

                // Clear timer every movement
                window.clearTimeout(hoverTimer);

                // If the mouse is not over the controls, set a timeout to hide them
                if(!isMouseOver) {
                    hoverTimer = window.setTimeout(function() {
                        _toggleClass(player.controls, config.classes.hover, false);
                    }, 2000);
                }
            }

            // Check mouse is over the controls
            function _setMouseOver (event) {
                isMouseOver = (event.type === "mouseenter");
            }

            if(config.fullscreen.hideControls) {
                // Hide on entering full screen
                _toggleClass(player.controls, config.classes.hover, false);

                // Keep an eye on the mouse location in relation to controls
                _toggleHandler(player.controls, "mouseenter mouseleave", _setMouseOver, player.isFullscreen);

                // Show the controls on mouse move
                _toggleHandler(player.container, "mousemove", _showControls, player.isFullscreen);
            }
        }

        // Bail from faux-fullscreen
        function _handleEscapeFullscreen(event) {
            // If it's a keypress and not escape, bail
            if((event.which || event.charCode || event.keyCode) === 27 && player.isFullscreen) {
                _toggleFullscreen();
            }
        }

        // Set volume
        function _setVolume(volume) {
            // Use default if no value specified
            if(typeof volume === "undefined") {
                if(config.storage.enabled && _storage().supported) {
                    volume = window.localStorage[config.storage.key] || config.volume;
                }
                else {
                    volume = config.volume;
                }
            }

            // Maximum is 10
            if(volume > 10) {
                volume = 10;
            }
            // Minimum is 0
            if(volume < 0) {
                volume = 0;
            }

            // Set the player volume
            player.media.volume = parseFloat(volume / 10);

            // Toggle muted state
            if(player.media.muted && volume > 0) {
                _toggleMute();
            }
        }

        // Mute
        function _toggleMute(muted) {
            // If the method is called without parameter, toggle based on current value
            if(typeof muted === "undefined") {
                muted = !player.media.muted;
            }

            // Set mute on the player
            player.media.muted = muted;
        }

        // Update volume UI and storage
        function _updateVolume() {
            // Get the current volume
            var volume = player.media.muted ? 0 : (player.media.volume * 10);

            // Update the <input type="range"> if present
            if(player.supported.full && player.volume) {
                player.volume.value = volume;
            }

            // Store the volume in storage
            if(config.storage.enabled && _storage().supported) {
                window.localStorage.setItem(config.storage.key, volume);
            }

            // Toggle class if muted
            _toggleClass(player.container, config.classes.muted, (volume === 0));

            // Update checkbox for mute state
            if(player.supported.full && player.buttons.mute) {
                player.buttons.mute.checked = (volume === 0);
            }
        }

        // Toggle captions
        function _toggleCaptions(show) {
            // If there's no full support, or there's no caption toggle
            if(!player.supported.full || !player.buttons.captions) {
                return;
            }

            // If the method is called without parameter, toggle based on current value
            if(typeof show === "undefined") {
                show = (player.container.className.indexOf(config.classes.captions.active) === -1);
                player.buttons.captions.checked = show;
            }

            _toggleClass(player.container, config.classes.captions.active, show);
        }

        // Check if media is loading
        function _checkLoading(event) {
            var loading = (event.type === "waiting");

            // Clear timer
            clearTimeout(player.loadingTimer);

            // Timer to prevent flicker when seeking
            player.loadingTimer = setTimeout(function() {
                _toggleClass(player.container, config.classes.loading, loading);
            }, (loading ? 250 : 0));
        }

        // Update <progress> elements
        function _updateProgress(event) {
            var progress    = player.progress.played.bar,
                text        = player.progress.played.text,
                value       = 0;

            if(event) {
                switch(event.type) {
                    // Video playing
                    case "timeupdate":
                    case "seeking":
                        value = _getPercentage(player.media.currentTime, player.media.duration);

                        // Set seek range value only if it's a "natural" time event
                        if(event.type == "timeupdate" && player.buttons.seek) {
                            player.buttons.seek.value = value;
                        }

                        break;

                    // Events from seek range
                    case "change":
                    case "input":
                        value = event.target.value;
                        break;


                    // Check buffer status
                    case "playing":
                    case "progress":
                        progress    = player.progress.buffer.bar;
                        text        = player.progress.buffer.text;
                        value       = (function() {
                                        var buffered = player.media.buffered;

                                        if(buffered.length) {
                                            return _getPercentage(buffered.end(0), player.media.duration);
                                        }

                                        return 0;
                                    })();
                        break;
                }
            }

            // Set values
            if(progress) {
                progress.value = value;
            }
            if(text) {
                text.innerHTML = value;
            }
        }

        // Update the displayed time
        function _updateTimeDisplay(time, element) {
            // Bail if there's no duration display
            if(!element) {
                return;
            }

            player.secs = parseInt(time % 60);
            player.mins = parseInt((time / 60) % 60);
            player.hours = parseInt(((time / 60) / 60) % 60);

            // Do we need to display hours?
            var displayHours = (parseInt(((player.media.duration / 60) / 60) % 60) > 0)

            // Ensure it"s two digits. For example, 03 rather than 3.
            player.secs = ("0" + player.secs).slice(-2);
            player.mins = ("0" + player.mins).slice(-2);

            var printTime = (displayHours ? player.hours + ":" : "") + player.mins + ":" + player.secs;

            // Render
            if( element.toString() == "[object NodeList]" ) {
              $.each(element, function(o) {
                o.innerHTML = printTime;
              });
            } else {
              element.innerHTML = printTime;
            }
        }

        // Show the duration on metadataloaded
        function _displayDuration() {
            var duration = player.media.duration || 0;

            // If there's only one time display, display duration there
            if(!player.duration && config.displayDuration && player.media.paused) {
                _updateTimeDisplay(duration, player.currentTime);
            }

            // If there's a duration element, update content
            if(player.duration) {
                _updateTimeDisplay(duration, player.duration);
            }
        }

        // Handle time change event
        function _timeUpdate(event) {
            // Duration
            _updateTimeDisplay(player.media.currentTime, player.currentTime);

            // Playing progress
            _updateProgress(event);
        }

        // Remove <source> children and src attribute
        function _removeSources() {
            // Find child <source> elements
            var sources = player.media.querySelectorAll("source");

            // Remove each
            for (var i = sources.length - 1; i >= 0; i--) {
                _remove(sources[i]);
            }

            // Remove src attribute
            player.media.removeAttribute("src");
        }

        // Inject a source
        function _addSource(attributes) {
            if(attributes.src) {
                // Create a new <source>
                var element = document.createElement("source");

                // Set all passed attributes
                _setAttributes(element, attributes);

                // Inject the new source
                _prependChild(player.media, element);
            }
        }

        // Update source
        // Sources are not checked for support so be careful
        function _parseSource(sources) {
            // Pause playback (webkit freaks out)
            _pause();

            // Restart
            _seek();

            // Remove current sources
            _removeSources();

            // If a single source is passed
            // .source("path/to/video.mp4")
            if(typeof sources === "string") {
                player.media.setAttribute("src", sources);
            }

            // An array of source objects
            // Check if a source exists, use that or set the "src" attribute?
            // .source([{ src: "path/to/video.mp4", type: "video/mp4" },{ src: "path/to/video.webm", type: "video/webm" }])
            else if (sources.constructor === Array) {
                for (var index in sources) {
                    _addSource(sources[index]);
                }
            }

            if(player.supported.full) {
                // Reset time display
                _timeUpdate();

                // Update the UI
                _checkPlaying();
            }

            // Re-load sources
            player.media.load();

            // Play if autoplay attribute is present
            if(player.media.getAttribute("autoplay") !== null) {
                _play();
            }
        }

        // Update poster
        function _updatePoster(source) {
            if(player.type === "video") {
                player.media.setAttribute("poster", source);
            }
        }

        // Listen for events
        function _listeners() {
            // IE doesn't support input event, so we fallback to change
            var inputEvent = (player.browser.name == "IE" ? "change" : "input");

            // Play
            _on(player.buttons.play, "click", function() {
                _play();
                setTimeout(function() { player.buttons.pause.focus(); }, 100);
            });

            // Pause
            _on(player.buttons.pause, "click", function() {
                _pause();
                setTimeout(function() { player.buttons.play.focus(); }, 100);
            });

            // Restart
            _on(player.buttons.restart, "click", _seek);

            // Rewind
            _on(player.buttons.rewind, "click", _rewind);

            // Fast forward
            _on(player.buttons.forward, "click", _forward);

            // Seek
            _on(player.buttons.seek, inputEvent, _seek);

            // Set volume
            _on(player.volume, inputEvent, function() {
                _setVolume(this.value);
            });

            // Mute
            _on(player.buttons.mute, "change", function() {
                _toggleMute(this.checked);
            });

            // Fullscreen
            _on(player.buttons.fullscreen, "click", _toggleFullscreen);

            // Handle user exiting fullscreen by escaping etc
            if(fullscreen.supportsFullScreen) {
                _on(document, fullscreen.fullScreenEventName, _toggleFullscreen);
            }

            // Time change on media
            _on(player.media, "timeupdate seeking", _timeUpdate);

            // Update manual captions
            _on(player.media, "timeupdate", _seekManualCaptions);

            // Display duration
            _on(player.media, "loadedmetadata", _displayDuration);

            // Captions
            _on(player.buttons.captions, "change", function() {
                _toggleCaptions(this.checked);
            });

            // Handle the media finishing
            _on(player.media, "ended", function() {
                // Clear
                if(player.type === "video") {
                    player.captionsContainer.innerHTML = "";
                }

                // Reset UI
                _checkPlaying();
            });

            // Check for buffer progress
            _on(player.media, "progress", _updateProgress);

            // Also check on start of playing
            _on(player.media, "playing", _updateProgress);

            // Handle native mute
            _on(player.media, "volumechange", _updateVolume);

            // Handle native play/pause
            _on(player.media, "play pause", _checkPlaying);

            // Loading
            _on(player.media, "waiting canplay seeked", _checkLoading);

            // Toggle checkboxes on return key (as they look like buttons)
            _on(player.checkboxes, "keyup", _toggleCheckbox);

            // Click video
            if(player.type === "video" && config.click) {
                _on(player.videoContainer, "click", function() {
                    if(player.media.paused) {
                        _triggerEvent(player.buttons.play, "click");
                    }
                    else if(player.media.ended) {
                        _seek();
                        _triggerEvent(player.buttons.play, "click");
                    }
                    else {
                        _triggerEvent(player.buttons.pause, "click");
                    }
                });
            }
        }

        // Destroy an instance
        function _destroy() {
            // Bail if the element is not initialized
            if(!player.init) {
                return null;
            }

            // Reset container classname
            player.container.setAttribute("class", config.selectors.container.replace(".", ""));

            // Event listeners are removed when elements are removed
            // http://stackoverflow.com/questions/12528049/if-a-dom-element-is-removed-are-its-listeners-also-removed-from-memory

            // Remove controls
            _remove(_getElement(config.selectors.controls));

            // If video, we need to remove some more
            if(player.type === "video") {
                // Remove captions
                _remove(_getElement(config.selectors.captions));

                // Remove video wrapper
                _unwrap(player.videoContainer);
            }

            // Restore native video controls
            player.media.setAttribute("controls", "");

            // Clone the media element to remove listeners
            // http://stackoverflow.com/questions/19469881/javascript-remove-all-event-listeners-of-specific-type
            var clone = player.media.cloneNode(true);
            player.media.parentNode.replaceChild(clone, player.media);

            // Remove init flag
            player.init = false;
        }

        // Setup a player
        function _init() {
            // Bail if the element is initialized
            if(player.init) {
                return null;
            }

            // Setup the fullscreen api
            fullscreen = _fullscreen();

            // Sniff out the browser
            player.browser = _browserSniff();

            // Get the media element
            player.media = player.container.querySelectorAll("audio, video")[0];

            // Set media type
            player.type = player.media.tagName.toLowerCase();

            // Check for full support
            player.supported = api.supported(player.type);

            // If no native support, bail
            if(!player.supported.basic) {
                return false;
            }

            // Debug info
            _log(player.browser.name + " " + player.browser.version);

            // Setup media
            _setupMedia();

            // If there's full support
            if(player.supported.full) {
                // Inject custom controls
                _injectControls();

                // Find the elements
                if(!_findElements()) {
                    return false;
                }

                // Display duration if available
                if(config.displayDuration) {
                    _displayDuration();
                }

                // Set up aria-label for Play button with the title option
                _setupAria();

                // Captions
                _setupCaptions();

                // Set volume
                _setVolume();
                _updateVolume();

                // Setup fullscreen
                _setupFullscreen();

                // Listeners
                _listeners();
            }

            // Successful setup
            player.init = true;
        }

        // Initialize instance
        _init();

        // If init failed, return an empty object
        if(!player.init) {
            return {};
        }

        return {
            media:              player.media,
            play:               _play,
            pause:              _pause,
            restart:            _seek,
            rewind:             _rewind,
            forward:            _forward,
            seek:               _seek,
            source:             _parseSource,
            poster:             _updatePoster,
            setVolume:          _setVolume,
            togglePlay:         _togglePlay,
            toggleMute:         _toggleMute,
            toggleCaptions:     _toggleCaptions,
            toggleFullscreen:   _toggleFullscreen,
            isFullscreen:       function() { return player.isFullscreen || false; },
            support:            function(mimeType) { return _supportMime(player, mimeType); },
            destroy:            _destroy,
            restore:            _init
        }
    }

    // Check for support
    api.supported = function(type) {
        var browser = _browserSniff(),
            oldIE   = (browser.name === "IE" && browser.version <= 9),
            iPhone  = /iPhone|iPod/i.test(navigator.userAgent),
            audio   = !!document.createElement("audio").canPlayType,
            video   = !!document.createElement("video").canPlayType,
            basic, full;

        switch (type) {
            case "video":
                basic = video;
                full  = (basic && (!oldIE && !iPhone));
                break;

            case "audio":
                basic = audio;
                full  = (basic && !oldIE);
                break;

            default:
                basic = (audio && video);
                full  = (basic && !oldIE);
                break;
        }

        return {
            basic:  basic,
            full:   full
        };
    }

    // Expose setup function
    api.setup = function(options){
        // Extend the default options with user specified
        config = _extend(defaults, options);

        // Bail if disabled or no basic support
        // You may want to disable certain UAs etc
        if(!config.enabled || !api.supported().basic) {
            return false;
        }

        // Get the players
        var elements    = document.querySelectorAll(config.selectors.container),
            players     = [];

        // Create a player instance for each element
        for (var i = elements.length - 1; i >= 0; i--) {
            // Get the current element
            var element = elements[i];

            // Setup a player instance and add to the element
            if(typeof element.plyr === "undefined") {
                // Create new instance
                var instance = new Plyr(element);

                // Set plyr to false if setup failed
                element.plyr = (Object.keys(instance).length ? instance : false);

                // Callback
                config.onSetup.apply(element.plyr);
            }

            // Add to return array even if it's already setup
            players.push(element.plyr);
        }

        return players;
    }

}(this.plyr = this.plyr || {}));/* Define dependencies */

//(=) require modernizr.js
//(=) require src/application.js
//(=) require_tree src/behaviors
//(=) require_tree src/helpers
//(=) require_tree src/vendor
;
