(function ($) {
  $(document).ready(function(){
    $('#pt-social-media a').not('.email-share-button, .more-share-button, .facebook-share-button').click(function(e){
      e.preventDefault();
      var url = $(this).attr('href');
      window.open(url, 'newwindow', config='height=430, width=500, toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, directories=no, status=no');
    });
    $('#pt-social-media a.more-share-button').click(function(e){
      e.preventDefault();
      $('.pt-social-media_google-plus, .pt-social-media_linkedin, .pt-social-media_stumble, .pt-social-media_reddit').toggle();
      if ($(this).text() == 'MORE') {
        $('.pt-social-media_more span').text('LESS');
      }
      else {
        $('.pt-social-media_more span').text('MORE');
      }

    });
    $('#pt-social-media-notags a.more-share-button').click(function(e){
      e.preventDefault();
      $('.pt-social-media-notags_google-plus, .pt-social-media-notags_linkedin, .pt-social-media-notags_stumble, .pt-social-media-notags_reddit').toggle();
      if ($(this).text() == 'MORE') {
        $('.pt-social-media-notags_more span').text('LESS');
      }
      else {
        $('.pt-social-media-notags_more span').text('MORE');
      }

    });

    //var url = 'https://www.psychologytoday.com' + window.location.pathname;
    //
    //// Facebook shares
    //$.get( "http://graph.facebook.com/", { id: url } )
    //  .done(function( data ) {
    //  if (data.shares > 0) {
    //    $('#facebook-share span').html( $('#facebook-share span').html() + '('+data.shares+')');
    //  }
    //});
    //


  });
})(jQuery);
;
(function ($) {
  $(document).ready(function () {
    // toggle the Find Therapist search block on click at mobile widths
    if ( window.innerWidth < 480 && !$('body').hasClass('front') ) {
      $('#td_search_label').removeClass('top-search-open');
      $('.input-wrapper').css('display', 'none');

      tdToggleEvent();
    }

    /*
     *  - We need to reset and reapply bindings after page resize because the form label is a link on tablet/desktop,
     *     but a toggle trigger on mobile.
     *
     *   - In PT-273 we discovered that opening a keyboard in Android devices fires a 'resize' event that we didn't expect.
     *     In some cases, this meant that the keyboard would immediately close after opening.
     *     We'll detect this by comparing the window widths before and after the resize - if they are the same,
     *     assume it was a keyboard event and don't fire our resize callback stuff.
     */
    var windowWidth = $(window).width();

    $(window).bind('resize.ptSlideToggle', function(event){
      if ( windowWidth != $(window).width() ) {
        clearTimeout(this.id);
        if (!$('#block-pt-td-td-top-search input#searchField').is(':focus')) {
          this.id = setTimeout(handleResize, 200);
        }
      }

      // Reset windowWidth with new width
      windowWidth = $(window).width();
    });

    // Reset the state of Therapist Directory to closed after a window resize
    // Specifically unbind the click event (runs a slideToggle) every time to keep them from repeating
    function handleResize() {
      $('#td_search_label').removeClass('top-search-open');
      $('#td_search_label').unbind('click');

      if (window.innerWidth < 480 && !$('body').hasClass('front')) {
        $('.input-wrapper').css('display', 'none');
        tdToggleEvent();
      }
      else {
        $('.input-wrapper').css('display', 'inline-block');
      }
    }

    // Binds the slideToggle click event to the td search Label
    function tdToggleEvent() {
      $('#td_search_label').on('click', function (e) {
        e.preventDefault();
        $('.input-wrapper').slideToggle('fast', function (e) {
          $(this).siblings('#td_search_label').toggleClass('top-search-open');
        });
      });
    }

  });
})(jQuery);
;
(function($) {

  // Country
  var pt_country = localStorage.getItem("pt_country") || '';
  // OK, we're ready!
  $(document).ready(function() {
    // What country are we in?
    switch (pt_country) {
      case 'US': case 'us':

        // Show the top search block
        $('#block-pt-td-td-top-search').closest('.region-below-header').addClass('show-search-block');
        break;

      case 'CA': case 'ca':
        // Override the title.
        $('#block-pt-td-td-top-search #td_search_label a').text('Find a Counsellor');

        // Override the placeholder text.
        $('#block-pt-td-td-top-search #searchField').attr('placeholder', 'City or Postal Code');

        // Override the pt_td_label
        $('#block-pt-td-td-top-search #td_existing .pt_td_label').text('Counsellors:');

        // Show the top search block
        $('#block-pt-td-td-top-search').closest('.region-below-header').addClass('show-search-block');
        break;

      case 'KY': case 'ky':
        // Show the top search block
        $('#block-pt-td-td-top-search').closest('.region-below-header').addClass('show-search-block');

        break;
      default:
        // Do nothing, really.
    }

    // Get the country, if we don't already know. And show Therapist Directory search.
    if (pt_country == '' || pt_country == 'undefined') {
      $.getJSON("/sites/all/modules/custom/pt_td/api/region.php")
        .done(function (json) {

          if ( json.success ) {
            // Set the country to local storage.
            localStorage.setItem("pt_country", json.country);
            switch (json.country) {
              case 'CA':
              case 'ca':
                // Override the title.
                $('#block-pt-td-td-top-search #td_search_label a').text('Find a Counsellor');

                // Override the placeholder text.
                $('#block-pt-td-td-top-search #searchField').attr('placeholder', 'City or Postal Code');

                // Override the pt_td_label
                $('#block-pt-td-td-top-search #td_existing .pt_td_label').text('Counsellors:');

                // Show the top search block
                $('#block-pt-td-td-top-search').closest('.region-below-header').addClass('show-search-block');
                break;
              case 'US':
              case 'us':
              case 'KY':
              case 'ky':
                // Show the top search block
                $('#block-pt-td-td-top-search').closest('.region-below-header').addClass('show-search-block');
                break;
              default:
              // Do nothing, really.
            }
          }
        });
    }
  });

})(jQuery);
;
