(function ($) {

Drupal.behaviors.quote = {
  attach: function() {
    var level = Drupal.settings.quote_nest - 1;
    if (level >= 0) {
      var top = $('blockquote.quote-nest-1');
      $('blockquote.quote-msg:eq(' + level + ')', top)
      .hide()
      .after('<div class="quote-snip">' + Drupal.t('<a href="#">[snip]</a>') + '</div>')
      .next('.quote-snip')
      .children('a')
      .click(function(e) {
        $(this).parent().siblings('.quote-msg').toggle();
        e.preventDefault();
      });
    }
  }
};

}(jQuery));
;
(function($) {

  Drupal.behaviors.morecomments = {
    attach: function() {
      var pager = Drupal.settings.morecomments_pager;
      // Replace the default pager with the more comments pager
      $("#comments .pager").replaceWith(pager);

      $(".morecomments-button").live('click', morecomments_load);

      function morecomments_load(event) {
        var classes = $(this).attr("class");
        var info = classes.match("node-([0-9]+) page-([0-9]+)");
        $(".morecomments-button").append("<div class = 'wait'>&nbsp;</div>");
        $.get(Drupal.settings.basePath + "morecomments/" + info[1] + "/" + info[2], function(data) {
          var parent = $(".morecomments-button").parent();
          $(".morecomments-button").replaceWith(data);
          Drupal.attachBehaviors(parent);
        });
      }
    }
  };

})(jQuery);
;
(function($){

  Drupal.behaviors.pt_copyright = {
    attach: function (context, settings) {

        // Source Copyright field.
        var copyright = $('input.form-text', this);

      // Get all images that are inside any .insertArea.
      $('.insertArea img', context).each(function(index){
        // Set the image to a variable.
        var $img = $(this);

        // Set the file src to a variable.
        var fileSrc = $(this).attr('src');

        /**
         * Loop over values passed from Drupal.
         * @variable index = file name.
         * @variable value = the copyright value.
         */
        $.each(Drupal.settings.pt_copyright, function(index, value){
          // Set the image parent to a variable.
          var $parent = $img.parents('.insert-inner');

          // Set the copyright text to a variable.
          var originText = $parent.children('.insertArea--origin').text().trim();

          var currentImage = $img;

          var imagename = index.substring(0, index.indexOf('.'));

          // Match the fileSrc with the index.
          if(fileSrc.indexOf(imagename) > -1 && value !== ''){

            if (originText !== '' && index.indexOf(imagename) > -1 ) {
              $parent.children('.insertArea--origin').text('Source: ' + value);
            }
            else if(originText === '' && $parent.children('.insertArea--origin').length === 0){
              $parent.append('<div class="subtext insertArea--origin">Source: ' + value + '</div>');
            }
            else if(originText === '' && $parent.children('.insertArea--origin').length > 0){
              $parent.children('.insertArea--origin').text('Source: ' + value);
            }
          }

          //if (originText !== value) {
          //  //$parent.children('.insertArea--origin').text('Source: ' + value);
          //}

        });

      });
    },
  }
})(jQuery);
;
